
<!--====== Start Intro Section ======-->
<section id="videoSection" class="intro-section bg_cover overlay pt-240 pb-300 wow fadeInUp"
         style="position: relative; overflow: hidden;">
  <!-- Background Video (keep in DOM; use opacity instead of display:none) -->
  <video id="bgVideo" loop playsinline preload="auto" controlsList="nodownload" style="
    position: absolute;
    inset: 0;
    width: 100%;
    height: 100%;
    object-fit: cover;
    z-index: 1;
    opacity: 0;
    transition: opacity .6s ease;
    pointer-events: none; /* avoid accidental clicks unless you want toggle behaviour */
  ">
    <source src="assets/abimg/videos/placementvideo.mp4" type="video/mp4">
    Your browser does not support the video tag.
  </video>

  <!-- Overlay Background Image -->
  <div id="videoOverlayImage" style="
    position: absolute; inset: 0;
    background-image: url('assets/abimg/home/videoimage.webp');
    background-size: cover;
    background-position: center;
    z-index: 2;
    transition: opacity .6s ease;
  "></div>

  <!-- Unmute prompt (hidden until needed) -->
  <button id="unmuteBtn" style="
    position: absolute;
    top: 20px;
    right: 30px;
    z-index: 6;
    display: none;
   background-color: rgba(0, 0, 0, 0);
    border: none;
    padding: 10px 14px;
    border-radius: 6px;
    cursor: pointer;
    font-size: 14px;
  "></button>

  <div class="container" style="position: relative; z-index: 3;">
    <div class="row">
      <div class="col-lg-12 text-center">
        <!-- you keep your content here -->
      </div>
    </div>
  </div>
</section>

<script>
  const bgVideo = document.getElementById('bgVideo');
  const overlayImage = document.getElementById('videoOverlayImage');
  const videoSection = document.getElementById('videoSection');
  const unmuteBtn = document.getElementById('unmuteBtn');

  // --- Ensure video is muted first so autoplay is allowed ---
  bgVideo.muted = true;
  bgVideo.volume = 1.0;
  let started = false;

  // --- Helper log (optional) ---
  function log(...args) { console.log('[VideoSection]', ...args); }

  // --- Try to unmute when browser allows ---
  async function tryUnmute() {
    try {
      bgVideo.muted = false;
      await bgVideo.play();
      log('Unmuted and playing with sound.');
      return true;
    } catch (err) {
      log('Unmute blocked:', err);
      bgVideo.muted = true;
      return false;
    }
  }

  // --- Show/Hide Unmute UI ---
  function showUnmuteUI() { unmuteBtn.style.display = 'block'; }
  function hideUnmuteUI() { unmuteBtn.style.display = 'none'; }

  // --- On Unmute Button Click ---
  unmuteBtn.addEventListener('click', async () => {
    try {
      await bgVideo.play();
      bgVideo.muted = false;
      hideUnmuteUI();
      log('User clicked Unmute — sound enabled.');
    } catch (err) {
      log('Error on user unmute click:', err);
    }
  });

  // --- Intersection Observer to control play/pause ---
  const observer = new IntersectionObserver(async (entries) => {
    for (const entry of entries) {
      if (entry.isIntersecting && entry.intersectionRatio >= 0.5) {
        // Section visible — play video muted first
        overlayImage.style.opacity = '0';
        bgVideo.style.opacity = '1';
        bgVideo.style.display = '';

        try {
          bgVideo.muted = true;
          await bgVideo.play();
          started = true;
          log('Muted autoplay started.');
        } catch (err) {
          log('Muted autoplay failed:', err);
        }

        // Attempt to unmute (if allowed)
        const unmuted = await tryUnmute();
        if (!unmuted) showUnmuteUI();
        else hideUnmuteUI();

      } else {
        // Section not visible — pause and reset
        if (started) log('Section hidden — pausing video.');
        bgVideo.pause();
        bgVideo.currentTime = 0;
        bgVideo.muted = true;
        overlayImage.style.opacity = '1';
        bgVideo.style.opacity = '0';
        hideUnmuteUI();
      }
    }
  }, { threshold: [0.5] });

  // --- Start observing the section ---
  observer.observe(videoSection);

  // --- Ensure autoplay starts on load ---
  window.addEventListener('load', async () => {
    try {
      bgVideo.muted = true;
      await bgVideo.play();
      log('Initial autoplay triggered.');
    } catch (err) {
      log('Initial autoplay blocked:', err);
    }
  });

  // --- Debug: video error listener ---
  bgVideo.addEventListener('error', (e) => {
    console.error('[VideoSection] video error:', e, bgVideo.error);
  });

  // --- Optional: check network availability ---
  fetch(bgVideo.querySelector('source').src, { method: 'HEAD' })
    .then(resp => {
      if (!resp.ok) console.warn('[VideoSection] video HEAD returned', resp.status);
      else log('Video resource OK (HEAD).');
    })
    .catch(err => console.warn('[VideoSection] video HEAD fetch error:', err));
</script>

<!-- <section class="intro-section bg_cover overlay pt-240 pb-300 wow fadeInUp" style="background-image: url(assets/abimg/home/videoimage.webp);">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                         
                        <div class="convis-video-popup text-center">
                            <a href="https://www.youtube.com/" class="video-popup"><i class="fas fa-play"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        </section>  -->