<?php $head_title = "About || convis || convis PHP Template" ?>
<?php $bodyClass = "page-template-default" ?>

<!-- header -->
<?php require_once('parts/header/header.php'); ?>
<?php
$page_title = "Permanent Placement";
require_once('parts/placemeant-title.php');
?>

<section class="about-section pt-120 pb-80">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-8">
                <div class="section-content-box mb-10">
                    <div class="section-title mb-40 wow fadeInDown">
                        <span class="sub-style style-one">Permanent Placement</span>
                        <h2><span class="font-300"> Your Partner in </span> Building Lasting Teams</h2>
                    </div>
                    <div class="row">
                        <div class="col-lg-8 mb-40">
                            <p class="mb-30 wow fadeInDown">At The Abney Group, we believe that great companies are built by great people. Our <strong>Permanent Placement Services</strong> are designed to help you find professionals who not only meet your technical requirements but also align with your organization’s culture, values, and long-term vision. We don’t just fill positions — we help you build a workforce that drives sustained growth and success</p>
                            <h3 class="mb-20 wow fadeInDown">A Strategic Approach to Long-Term Hiring</h3>
                            <p class="mb-30 wow fadeInDown">Hiring full-time employees is one of the most critical decisions any business can make. Every hire impacts your team dynamics, productivity, and overall company culture. That’s why The Abney Group takes a <strong>consultative, data-driven, and human-centered approach</strong> to permanent placement </p>
                            <p class="mb-30 wow fadeInDown">We partner closely with your leadership and HR teams to understand your goals, workplace environment, and the soft skills that define success in your organization. From there, we identify and attract high-caliber professionals who not only have the right qualifications but also share your company’s mindset and ambition.</p>

                            <a href="contact.php" class="theme-btn style-one wow fadeInUp">Call Now<i class="far fa-arrow-right"></i></a>
                        </div>
                        <div class="col-lg-4">
                            <div class="experience-card style-one mb-40 wow fadeInDown">
                                <div class="content">
                                    <h2>10+</h2>
                                    <h4>Years of Expertise in Permanent Placement</h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="about-two_image-box mb-50 wow fadeInRight">
                    <div class="about-img">
                        <img src="assets/images/about/placemant-people.png" alt="About Image">
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section class="why-choose-us gray-light-bg pt-80 pb-80">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <div class="choose-one_image-box text-center mb-50 wow fadeInLeft">
                    <img src="assets/images/gallery/placemant-people-1.png" alt="Why Choose">
                </div>
            </div>
            <div class="col-lg-6">
                <div class="section-content-box mb-50 wow fadeInRight">
                    <div class="section-title mb-50">
                        <span class="sub-title style-one">Why Choose Us</span>
                        <h2><span class="font-300">Staff </span> Permanent Placement </h2>
                    </div>
                    <div class="iconic-list-wrapper">
                        <div class="iconic-box style-three wow fadeInUp">
                            <div class="icon">
                                <i class="flaticon-digital-strategy"></i>
                            </div>
                            <div class="content">
                                <h5>Right Talent, Right Fit: </h5>
                                <p>Hire professionals who align perfectly with your company’s goals and culture.</p>
                            </div>
                        </div>
                        <div class="iconic-box style-three wow fadeInUp">
                            <div class="icon">
                                <i class="flaticon-cooperation"></i>
                            </div>
                            <div class="content">
                                <h5>Long-Term Stability: </h5>
                                <p>Build a reliable team that drives consistent growth and lasting success.</p>
                            </div>
                        </div>
                        <div class="iconic-box style-three wow fadeInUp">
                            <div class="icon">
                                <i class="flaticon-costumer"></i>
                            </div>
                            <div class="content">
                                <h5>Quality Hiring:</h5>
                                <p>Gain access to thoroughly vetted candidates with proven industry expertise.</p>
                            </div>
                        </div>

                        <div class="iconic-box style-three wow fadeInUp">
                            <div class="icon">
                                <i class="flaticon-technology"></i>
                            </div>
                            <div class="content">
                                <h5> End-to-End Recruitment:</h5>
                                <p> From sourcing to onboarding, we handle every step of the hiring process seamlessly.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</section>


<section class="pt-40 pb-40">
    <div class="dividerr">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <h2 class="mb-20 wow fadeInDown"><span class="font-300">Our</span> Process</h2>

                    <ul class="check-list style-two mb-20 wow fadeInLeft">
                        <li><i class="far fa-check"></i><span><b>Understanding Your Needs :</b> We start by learning everything about your business — your structure, challenges, and expectations for the role.</span> </li>
                        <li><i class="far fa-check"></i><span><b>Talent Mapping and Sourcing :</b> Using a combination of advanced tools, industry insights, and our professional network, we source candidates who match your technical and cultural criteria.</span></li>
                        <li><i class="far fa-check"></i><span><b>Comprehensive Screening :</b> Every candidate is carefully vetted through interviews, background checks, and skill assessments to ensure they meet your standards. </span></li>
                        <li><i class="far fa-check"></i><span><b>Final Selection and Placement :</b> We present a refined shortlist of the best-fit candidates, coordinate interviews, and manage the offer process for a seamless experience.</span></li>
                        <li><i class="far fa-check"></i><span><b>Post-Hire Support :</b> Our relationship doesn’t end at placement — we stay connected to ensure smooth onboarding and long-term retention </span></li>
                    </ul>

                </div>
            </div>
        </div>
    </div>

</section>
<section class="pt-40 pb-40">
    <div class="dividerr">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <h2 class="mb-20 wow fadeInDown"><span class="font-300">Your Success Starts with the</span> Right People</h2>

                    <p class="mb-30 wow fadeInDown ">In today’s competitive talent market, attracting and retaining the right employees can be challenging. That’s where The Abney Group comes in — as your trusted partner in talent acquisition, we make permanent hiring effortless, precise, and strategic.</p>
                    <p class="mb-30 wow fadeInDown ">From entry-level professionals to senior executives, we help you find individuals who bring value, stability, and passion to your organization. With The Abney Group, you gain more than a recruitment service — you gain a <strong>partner dedicated to building your future workforce.</strong></p>

                </div>
            </div>
        </div>
    </div>

</section>

<?php require_once('parts/home/cta.php'); ?>

<?php require_once('parts/home/funfact.php'); ?>


<?php require_once('parts/home/intro.php'); ?>
<?php require_once('parts/home/feedback.php'); ?>
<?php require_once('parts/home/client.php'); ?>
<?php require_once('parts/home/cta2.php'); ?>
<?php require_once('parts/footer/footer.php'); ?>
<?php require_once('parts/layout/bottom-layout.php'); ?>