// JavaScript for interactive tilt + parallax
document.querySelectorAll('.blue-card.interactive').forEach(card => {
  const cardBg = card.querySelector('.card-bg');

  card.addEventListener('mousemove', e => {
    const rect = card.getBoundingClientRect();
    const x = (e.clientX - rect.left) / rect.width;
    const y = (e.clientY - rect.top) / rect.height;

    const rotateY = (x - 0.5) * 20; // tilt degrees
    const rotateX = (0.5 - y) * 15; // tilt degrees

    card.style.transform = `perspective(900px) rotateX(${rotateX}deg) rotateY(${rotateY}deg) scale(1.05)`;
    card.style.boxShadow = `${-rotateY}px ${20 + Math.abs(rotateX)}px 48px rgba(3,30,60,0.2), 0 0 20px rgba(10,132,255,0.5)`;

    if (cardBg) {
      const bgX = (x - 0.5) * 15;
      const bgY = (y - 0.5) * 12;
      cardBg.style.transform = `translate(${bgX}px, ${bgY}px) scale(1.08)`;
    }
  });

  card.addEventListener('mouseleave', () => {
    card.style.transform = '';
    card.style.boxShadow = '';
    if (cardBg) cardBg.style.transform = '';
  });
});