

  <!-- Owl Carousel CSS -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.min.css">

  <style>
   
    .slider_item_container {
      height: 100vh;
      max-height:600px;
      width: 100vw;
      background-size: cover;
      background-position: center;
    }
  </style>


<!-- One Unified Slider -->
<div id="main-carousel" class="owl-carousel owl-theme">
  <!-- Images will be injected here -->
</div>

<!-- JS -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>

<script>
  $(function () {
    const isMobile = window.matchMedia("(max-width: 768px)").matches;

    const desktopImages = [
      'images/unique/unb131.png',
      'images/unique/unb112.png',
      'images/unique/unb53.png'
    ];

    const mobileImages = [
      'images/unique/uniqmob1.png',
      'images/unique/uniqmob2.png',
      'images/unique/uniqmob3.png'
    ];

    const selectedImages = isMobile ? mobileImages : desktopImages;

    selectedImages.forEach(src => {
      $('#main-carousel').append(`
        <div class="slider_item_container" style="background-image: url('${src}')"></div>
      `);
    });

    // Initialize Owl only after images are added
    $('#main-carousel').owlCarousel({
      items: 1,
      loop: true,
      autoplay: true,
      autoplayTimeout: 3000,
      nav: false,
      dots: true
    });
  });
</script>


