<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width,initial-scale=1" />
<title>Sidebar Product Demo</title>

<style>
  body { margin:0; font-family:Arial, sans-serif; }

  /* your product card design */
  .product { width:220px; display:inline-block; margin:15px; cursor:pointer; }
  .product .thumb { position:relative; overflow:hidden; }
  .product .thumb img { width:100%; display:block; transition:.3s; }
  .product .thumb img.hover-image { position:absolute; top:0; left:0; opacity:0; }
  .product:hover .hover-image { opacity:1; }

  .badges { position:absolute; top:10px; left:10px; }
  .badges .new {
      background:#ff4d4d; color:white; padding:3px 6px; font-size:12px;
      border-radius:3px;
  }

  .actions {
      position:absolute; bottom:10px; right:10px; display:flex; gap:8px;
  }
  .actions .action { color:#333; font-size:16px; }

  .add-to-cart {
      width:100%; padding:8px; margin-top:8px;
      background:#000; color:#fff; border:none; cursor:pointer;
  }

  /* Sidebar */
  .right-sidebar {
    position:fixed; top:0; right:0; width:360px; height:100vh;
    background:#fff; transform:translateX(100%);
    transition:.28s cubic-bezier(.2,.9,.3,1);
    z-index:9999; padding:1rem; overflow-y:auto;
    box-shadow:-8px 0 24px rgba(0,0,0,.12);
  }
  .right-sidebar.open { transform:translateX(0); }

  .backdrop {
    position:fixed; inset:0; background:rgba(0,0,0,.35);
    opacity:0; pointer-events:none; transition:.2s;
    z-index:9998;
  }
  .backdrop.show { opacity:1; pointer-events:all; }

  .close-btn { position:absolute; top:10px; right:10px; font-size:22px; border:0; background:0; cursor:pointer; }
  .thumb-big { width:100%; border-radius:6px; margin-bottom:12px; }
  .thumb-small { width:80px; height:70px; object-fit:cover; cursor:pointer; margin-right:8px; }
  .image-row {
    display: flex;
    gap: 10px;
    justify-content: space-between;
}

.thumb-box {
    width: 32%;
    text-align: center;
    text-decoration: none;
}

.thumb-small {
    width: 100%;
    border-radius: 6px;
    cursor: pointer;
}

.thumb-title {
    margin-top: 5px;
    font-size: 12px;
    font-weight: 600;
    color: #333;
}

</style>
</head>

<body>

<!-- ================= YOUR PRODUCT CARD ================= -->
<div id="productCard" class="product">
  <div class="thumb">
    <a class="image">
      <img src="assets/furniture/products/2.webp" alt="Product" />
      <img class="hover-image" src="assets/furniture/products/1.webp" alt="Product" />
    </a>

    <span class="badges">
      <span class="new">New</span>
    </span>

    <div class="actions">
      <a class="action wishlist"><i class="icon-heart"></i></a>
      <a class="action quickview"><i class="icon-size-fullscreen"></i></a>
      <a class="action compare"><i class="icon-refresh"></i></a>
    </div>

    <button class="add-to-cart">Add To Cart</button>
  </div>

  <div class="content">
    <h5 class="title">Wooden decorations</h5>
  </div>
</div>
<!-- ===================================================== -->


<!-- Backdrop -->
<div id="backdrop" class="backdrop"></div>

<!-- ==================== RIGHT SIDEBAR ====================== -->
<aside id="rightSidebar" class="right-sidebar">
    <button id="closeBtn" class="close-btn">✖</button>
    <h3>Product Images</h3>

    <div class="image-row">

        <!-- Image 1 -->
        <a href="product1.html" class="thumb-box">
            <img class="thumb-small" src="assets/furniture/products/2.webp" alt="Product 1">
            <p class="thumb-title">Product 1</p>
        </a>

        <!-- Image 2 -->
        <a href="product2.html" class="thumb-box">
            <img class="thumb-small" src="assets/furniture/products/2.webp" alt="Product 2">
            <p class="thumb-title">Product 2</p>
        </a>

        <!-- Image 3 -->
        <a href="product3.html" class="thumb-box">
            <img class="thumb-small" src="assets/furniture/products/2.webp" alt="Product 3">
            <p class="thumb-title">Product 3</p>
        </a>

    </div>

</aside>

<!-- ========================================================= -->

<script>
  const card = document.getElementById('productCard');
  const sidebar = document.getElementById('rightSidebar');
  const backdrop = document.getElementById('backdrop');
  const closeBtn = document.getElementById('closeBtn');
  const sidebarMainImg = document.getElementById('sidebarMainImg');

  function openSidebar() {
    sidebar.classList.add('open');
    backdrop.classList.add('show');
  }
  function closeSidebar() {
    sidebar.classList.remove('open');
    backdrop.classList.remove('show');
  }

  // open / close events
  card.addEventListener('click', openSidebar);
  closeBtn.addEventListener('click', closeSidebar);
  backdrop.addEventListener('click', closeSidebar);

  // ESC key closes
  document.addEventListener('keydown', e => {
    if (e.key === 'Escape') closeSidebar();
  });

  // Thumbnail click to update the main image
  document.addEventListener('click', e => {
    if (e.target.classList.contains('small-thumb')) {
      sidebarMainImg.src = e.target.dataset.full;
    }
  });
</script>

</body>
</html>
