<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get and sanitize form data
    $name = filter_var(trim($_POST['name']), FILTER_SANITIZE_STRING);
    $email = filter_var(trim($_POST['email']), FILTER_SANITIZE_EMAIL);
    $phone = filter_var(trim($_POST['phone']), FILTER_SANITIZE_STRING);
    $message = filter_var(trim($_POST['message']), FILTER_SANITIZE_STRING);

    // Validate required fields
    if (empty($name) || empty($email) || empty($phone) || empty($message)) {
        echo 'All fields are required.';
        exit;
    }

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        echo 'Invalid email format.';
        exit;
    }

    // Define admin and backup emails
    $adminEmails = [
        'sales@uniquedosing.com',
        'info@uniquedosing.com',
        'mktg@uniquedosing.com',
        'backupilogicx@gmail.com' 
    ];

    // Subjects
    $adminSubject = 'Contact Form Submission From Website';
    $userSubject = 'Thank You for Contacting Us';

    // Common email headers
    $headers = "MIME-Version: 1.0\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8\r\n";
    $headers .= "From: Unique Dosing <info@uniquedosing.com>\r\n";

    // Admin email body
    $adminBody = "<h2>Contact Form Submission from uniquedosing.com</h2>";
    $adminBody .= "<table border='1' cellspacing='0' cellpadding='5'>";
    $adminBody .= "<tr><th>Name</th><td>{$name}</td></tr>";
    $adminBody .= "<tr><th>Email</th><td>{$email}</td></tr>";
    $adminBody .= "<tr><th>Phone</th><td>{$phone}</td></tr>";
    $adminBody .= "<tr><th>Message</th><td>{$message}</td></tr>";
    $adminBody .= "</table>";

    // User email body
    $userBody = "<h2>Thank You for Contacting Us</h2>";
    $userBody .= "<p>Dear {$name},</p>";
    $userBody .= "<p>Thank you for reaching out to us. We will get back to you shortly.</p>";
    $userBody .= "<p>Best regards,<br>Team Unique Dosing</p>";

    // Send confirmation email to user
    $userHeaders = $headers . "Reply-To: {$email}\r\n";
    $userMailResult = mail($email, $userSubject, $userBody, $userHeaders);

    // Send email to each admin address separately
    $adminMailResults = [];
    foreach ($adminEmails as $adminEmail) {
        $adminMailResults[] = mail($adminEmail, $adminSubject, $adminBody, $headers);
    }

    // Check if all admin emails and user email were sent successfully
    if ($userMailResult && !in_array(false, $adminMailResults, true)) {
        echo 'sent';
    } else {
        echo 'Failed to send email.';
    }
} else {
    echo 'Invalid request method.';
}
?>
