<?php
/**
 * Default Theme Options
 *
 * @package Graceful
 */

function graceful_options( $control ) {

	$graceful_defaults = array(
		'main_navigation_show' => true,
		'main_navigation_height' => '65',
		'main_navigation_align' => 'left',
		'main_navigation_position' => 'below',
		'main_navigation_fixed' => true,
		'main_navigation_show_socials' => false,
		'main_navigation_show_search' => true,
		'main_navigation_show_sidebar' => false,
		'basic_site_width' => '1160',
		'basic_content_padding' => '40',
		'basic_sidebar_width' => '270',
		'basic_sidebar_sticky' => true,
		'basic_show_left_sidebar' => false,
		'basic_show_right_sidebar' => true,
		'basic_home_layout' => 'col1-rightsidebar',
		'basic_single_layout' => 'rightsidebar',
		'basic_other_layout' => 'col1-rightsidebar',
		'basic_header_width' => 'contained',
		'basic_slider_width' => 'wrapped',
		'basic_content_width' => 'wrapped',
		'basic_single_width' => 'wrapped',
		'basic_footer_width' => 'contained',
		'color_main_navigation_bg' => '#f1f1f1',
		'color_main_navigation_link' => '#000000',
		'color_main_navigation_link_hover' => '#999999',
		'color_header_bg' => '#ffffff',
		'color_header_text_bg' => '#ffffff',
		'color_show_header_text_bg' => false,
		'color_content_bg' => '#ffffff',
		'color_content_text' => '#010101',
		'color_content_title' => '#030303',
		'color_content_meta' => '#a1a1a1',
		'color_content_accent' => '#010101',
		'color_text_selection' => '#999999',
		'color_content_border' => '#e8e8e8',
		'color_button' => '#555555',
		'color_button_text' => '#ffffff',
		'color_button_hover' => '#999999',
		'color_button_hover_text' => '#ffffff',
		'color_overlay' => '#000000',
		'color_overlay_text' => '#ffffff',
		'color_footer_bg' => '#f6f6f6',
		'color_footer_text' => '#333333',
		'color_footer_title' => '#111111',
		'color_footer_accent' => '#999999',
		'color_footer_border' => '#e0dbdb',
		'color_loading_anim' => '#000000',
		'color_loading_bg' => '#ffffff',
		'top_navigation_label' => false,
		'top_navigation_show_menu' => true,
		'navigation_show_socials' => true,
		'header_image_parallax' => false,
		'title_tagline_logo_wide' => '400',
		'title_tagline_logo_distance' => '120',
		'post_slider_label' => false,
		'post_slider_display' => 'all',
		'post_slider_category' => 'null',
		'post_slider_orderby' => 'rand',
		'post_slider_amount' => '3',
		'post_slider_columns' => '1',
		'post_slider_autoplay' => '0',
		'post_slider_navigation' => true,
		'post_slider_pagination' => false,
		'post_slider_categories' => false,
		'post_slider_title' => true,
		'post_slider_excerpt' => false,
		'post_slider_more' => true,
		'post_slider_date' => false,
		'special_links_label' => false,
		'post_page_gutter_horz' => '37',
		'post_page_gutter_vert' => '100',
		'post_page_post_description' => 'excerpt',
		'post_page_excerpt_length' => '100',
		'post_page_grid_excerpt_length' => '60',
		'post_page_site_pagination' => 'default',
		'post_page_show_categories' => true,
		'post_page_show_date' => true,
		'post_page_show_comments' => true,
		'post_page_show_dropcaps' => false,
		'post_page_show_more' => true,
		'post_page_more_text' => 'Continue Reading',
		'post_page_show_author' => true,
		'post_page_show_facebook' => true,
		'post_page_show_twitter' => true,
		'post_page_show_pinterest' => true,
		'post_page_show_google' => true,
		'post_page_show_linkedin' => false,
		'post_page_show_reddit' => false,
		'post_page_show_tumblr' => false,
		'post_page_related_title' => 'Related Posts',
		'post_page_related_orderby' => 'none',
		'single_post_page_show_categories' => true,
		'single_post_page_show_date' => true,
		'single_post_page_show_dropcaps' => false,
		'single_post_page_show_tags' => true,
		'single_post_page_show_author' => true,
		'single_post_page_show_comments' => true,
		'single_post_page_show_author_desc' => true,
		'single_post_page_show_author_nav' => true,
		'single_post_page_related_title' => 'Related Posts',
		'single_post_page_related_orderby' => 'related',
		'single_post_page_show_comments_area' => true,
		'loading_label' => false,
		'loading_type' => 'animation_10',
		'social_media_window' => true,
		'social_m_icon_1' => 'facebook',
		'social_m_url_1' => '',
		'social_m_icon_2' => 'twitter',
		'social_m_url_2' => '',
		'social_m_icon_3' => 'instagram',
		'social_m_url_3' => '',
		'social_m_icon_4' => 'linkedin',
		'social_m_url_4' => '',
		'page_footer_columns' => 'three',
		'page_footer_align' => 'right-left',
		'page_footer_copyright' => '',
		'page_footer_show_socials' => false,

	);

	// merge defaults and options
	$graceful_defaults = wp_parse_args( get_option('graceful_options'), $graceful_defaults );

	// return control
	return $graceful_defaults[ $control ];

}