<!DOCTYPE html>
<html lang="en">

<head>
<meta charset="utf-8">
<?php include("keyword.php"); ?>
<?php echo seo_keywords(); ?>
<!-- Stylesheets -->
<link href="assets/css/bootstrap.css" rel="stylesheet">
<link href="assets/css/style.css" rel="stylesheet">
<link href="assets/css/custom.css" rel="stylesheet">
<!-- Responsive File -->
<link href="assets/css/responsive.css" rel="stylesheet">
	<link href="dist/css/lightbox.css" rel="stylesheet" />
<!-- Color File -->
<link href="assets/css/color.css" rel="stylesheet">

<link rel="preconnect" href="https://fonts.googleapis.com/">
<link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;500;600;700&amp;family=Roboto:wght@400;500;700;900&amp;display=swap" rel="stylesheet">

<link rel="shortcut icon" href="assets/img/favicon.png" type="image/x-icon">
<link rel="icon" href="assets/img/favicon.png" type="image/x-icon">

<!-- Responsive -->
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">
<meta name="robots" content="follow, index, max-snippet:-1, max-video-preview:-1, max-image-preview:large" />
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
<meta name="robots" content="index, follow" />
<meta name="googlebot" content="index, follow" />
<meta name="distribution" content="Global" />
<meta name="language" content="English">
<meta name="revisit-after" content="4 days" />
<!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-8JJHTMV69T"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-8JJHTMV69T');
</script>

<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "Organization",
  "name": "Unique Dosing System",
  "url": "https://www.uniquedosing.com/",
  "logo": "https://www.uniquedosing.com/path-to-logo.png",
  "description": "Manufacturer of high-quality dosing pumps for various industries, including water treatment, chemical processing, and pharmaceuticals.",
  "address": {
    "@type": "PostalAddress",
    "streetAddress": "M88, MIDC, Ambad, Nashik - 422010, Maharashtra, India",
    "addressLocality": "Nashik",
    "addressRegion": "Maharashtra",
    "postalCode": "422010",
    "addressCountry": "IN"
  },
  "contactPoint": {
    "@type": "ContactPoint",
    "telephone": "+91 9822420535",
    "contactType": "customer service",
    "email": "info@uniquedosing.com"
  },
  "sameAs": [
    "https://www.facebook.com/uniquedosing",
    "https://www.linkedin.com/company/uniquedosing",
    "https://twitter.com/uniquedosing"
    ]
 }
}
</script>

<!--Start of Tawk.to Script-->
<script type="text/javascript">
var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
(function(){
var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
s1.async=true;
s1.src='https://embed.tawk.to/63a2d584b0d6371309d575a4/1gkq144p2';
s1.charset='UTF-8';
s1.setAttribute('crossorigin','*');
s0.parentNode.insertBefore(s1,s0);


Tawk_API.onPrechatSubmit = function(data) {
  var formData = {
    name: '',
    email: '',
    phone: '',
    message: ''
  };

  for (var i = 0; i < data.length; i++) {
    if (data[i].label === 'Name') {
      formData.name = data[i].answer;
    } else if (data[i].label === 'Email') {
      formData.email = data[i].answer;
    } else if (data[i].label === 'Phone') {
      formData.phone = data[i].answer;
    } else if (data[i].label === 'Message') {
      formData.question = data[i].answer;
    }
  }

  console.log('Form Data:', formData);

  var domain = 'uniquedosing.com';
  var project_unique_code = 'uniquedosing27'; 

  // Pass formData, domain, and staticValue in the data property of the AJAX request
  $.ajax({
    type: 'POST',
    url: 'https://clients.dotphi.com/seo_html/live_lead.php',
    data: { ...formData, domain: domain, project_unique_code: project_unique_code }, 
    success: function(response) {
      console.log('Data submitted successfully:', response);
    },
    error: function(error) {
      console.error('Error submitting data:', error);
    }
  });
};


})();
</script>
<!--End of Tawk.to Script-->
<style>
    
    /* header */
.header{
	display: block;
	width: 100%;
	position: relative;
	z-index: 99;
	padding:15px;
}
.header .item-left{
	flex:0 0 20%;
}
.header .logo a{
	font-size: 30px;
	color:#000000;
	font-weight: 700;
	text-decoration: none;
}
.header .item-center{
	/*flex:0 0 50%;*/
		flex:0 0 60%;
	 padding-top: 20px;
}
.header .item-right{
    padding-top: 20px;
	flex:0 0 20%;
	display: flex;
	justify-content: flex-end;
}
.header .item-right a{ 
     text-decoration: none;
     font-size: 16px;
     /*color:#555555;*/
     display: inline-block;
     margin-left: 10px;
     transition: color 0.3s ease;
}
.header .menu > ul > li{
	display: inline-block;
	line-height: 50px;
	margin-left: 25px;
}
.header .menu > ul > li > a{
    	position: relative;
    text-align: center;
    font-size: 18px;
    font-weight: 500;
    line-height: 30px;
    text-transform: capitalize;
    color: #000;
    padding: 3px 0;
    opacity: 1;
    
    transition: all 300ms ease;
}
/*	font-size: 15px;*/
/*	font-weight: 500;*/
/*	color:#000000;*/
/*	position: relative;*/
/*	text-transform: capitalize;*/
/*	transition: color 0.3s ease;*/
/*}*/
.header .menu > ul > li .sub-menu{
	position: absolute;
	z-index: 500;
	background-color:#ffffff;
	box-shadow: -2px 2px 70px -25px rgba(0,0,0,0.3); 
	padding: 20px 30px;
	transition: all 0.5s ease;
	margin-top:25px;
	opacity:0;
	visibility: hidden;
}
@media(min-width: 992px){
.header .menu > ul > li.menu-item-has-children:hover .sub-menu{
	margin-top: 0;
	visibility: visible;
	opacity: 1;
}
}
.header .menu > ul > li .sub-menu > ul > li{
	line-height: 1;
}
.header .menu > ul > li .sub-menu > ul > li > a{
	display: inline-block;
	padding: 10px 0;
	font-size: 15px;
	color: #555555;
	transition: color 0.3s ease;
	text-decoration: none;
	text-transform: capitalize;
}
.header .menu > ul > li .single-column-menu{
	min-width: 280px;
	max-width: 350px;
}
.header .menu > ul > li .sub-menu.mega-menu > .list-item > ul > li{
   line-height: 1;
   display: block; 
}
.header .menu > ul > li .sub-menu.mega-menu > .list-item > ul > li > a {
	padding:5px 0;
	display: inline-block;
	font-size: 14px;
	color:#555555;
	transition: color 0.3s ease;
}
.header .menu > ul > li .sub-menu.mega-menu{ 
    left: 50%;
    transform: translateX(-50%);	
}

.header .menu > ul > li .sub-menu.mega-menu-column-4{
  max-width: 1700px;
  width: 100vw; 	
  display: flex;
  flex-wrap: wrap;
  padding:20px 15px;
}
.header .menu > ul > li .sub-menu.mega-menu-column-4 > .list-item{
  flex:0 0 25%;
  padding:0 15px;
}
.header .menu > ul > li .sub-menu.mega-menu-column-4 > .list-item .title{
	font-size: 20px;
	color:#ea4636;
	font-weight: 500;
	line-height: 1;
	padding:10px 0;
}
.header .menu > ul > li .sub-menu.mega-menu-column-4 > .list-item.text-center .title{
	text-align: center;
}
.header .menu > ul > li .sub-menu.mega-menu-column-4 > .list-item img{
	max-width: 100px;
	width: 100%;
	vertical-align: middle;
	margin-top: 10px;
	height: 40px;
	object-fit: cover;
}
.header .menu > ul > li .sub-menu.mega-menu > .list-item > ul > li > a:hover,
.header .menu > ul > li .sub-menu > ul > li > a:hover,
.header .item-right a:hover,
.header .menu > ul > li:hover > a{
	color:#ea4636;
}
/* banner section */
.banner-section{
  background-image: url('../img/banner.jpg');
  background-size: cover;
  background-position: center;
  height: 700px;
  width: 100%;
  display: block;
}
.mobile-menu-head,
.mobile-menu-trigger{
	display: none;
}
ul.list-1 li {
    margin-bottom: 2px;
}
/*responsive*/
@media(max-width: 991px){

	.header .item-center{
		order:3;
		flex:0 0 50%;
	}
	.header .item-left,
	.header .item-right{
		flex:0 0 50%;
	}
	.v-center{
		justify-content: space-between;
	}
	.header .mobile-menu-trigger{
		display: flex;
		height: 30px;
		width: 30px;
		margin-left: 15px;
		cursor: pointer;
		align-items: center;
		justify-content: center;
	}
	.header .mobile-menu-trigger span{
		display: block;
		height: 2px;
		background-color: #333333;
		width: 24px;
		position: relative;
	}
	.header .mobile-menu-trigger span:before,
	.header .mobile-menu-trigger span:after{
		content: '';
		position: absolute;
		left:0;
		width: 100%;
		height: 100%;
		background-color: #333333;
	}
	.header .mobile-menu-trigger span:before{
		top:-6px;
	}
	.header .mobile-menu-trigger span:after{
		top:6px;
	}
	.header .item-right{
		align-items: center;
	}

	.header .menu{
		position: fixed;
		width: 320px;
		background-color:#ffffff;
		left:0;
		top:0;
		height: 100%;
		overflow: hidden;
		transform: translate(-100%);
		transition: all 0.5s ease;
		z-index: 1099;
	}
	.header .menu.active{
	   transform: translate(0%);	
	}
	.header .menu > ul > li{
		line-height: 1;
		margin:0;
		display: block;
	}
	.header .menu > ul > li > a{
		line-height: 50px;
		height: 50px;
		padding:0 50px 0 15px;
		display: block;
		border-bottom: 1px solid rgba(0,0,0,0.1);
	}
	.header .menu > ul > li > a i{
		position: absolute;
		height: 50px;
		width: 50px;
		top:0;
		right: 0;
		text-align: center;
		line-height: 50px;
		transform: rotate(-90deg);
	}
	.header .menu .mobile-menu-head{
		display: flex;
		height: 50px;
		border-bottom: 1px solid rgba(0,0,0,0.1);
		justify-content: space-between;
		align-items: center;
		position: relative;
		z-index: 501;
		position: sticky;
		background-color: #ffffff;
		top:0;
	}
	.header .menu .mobile-menu-head .go-back{
		height: 50px;
		width: 50px;
		border-right: 1px solid rgba(0,0,0,0.1);
		cursor: pointer;
		line-height: 50px;
		text-align: center;
		color:#000000;
		font-size: 16px;
		display: none;
	}
	.header .menu .mobile-menu-head.active .go-back{
		display: block;
	}
	.header .menu .mobile-menu-head .current-menu-title{
		font-size: 15px;
		font-weight: 500;
		color:#000000;
	}
	.header .menu .mobile-menu-head .mobile-menu-close{
	    height: 50px;
		width: 50px;
		border-left: 1px solid rgba(0,0,0,0.1);
		cursor: pointer;
		line-height: 50px;
		text-align: center;
		color:#000000;	
		font-size: 25px;
	}
	.header .menu .menu-main{
		height: 100%;
		overflow-x: hidden;
		overflow-y: auto;
	}
	.header .menu > ul > li .sub-menu.mega-menu,
	.header .menu > ul > li .sub-menu{
		visibility: visible;
		opacity: 1;
		position: absolute;
		box-shadow: none;
		margin:0;
		padding:15px;
		top:0;
		left:0;
		width: 100%;
		height: 100%;
		padding-top: 65px;
		max-width: none;
		min-width: auto;
		display: none;
		transform: translateX(0%);
		overflow-y: auto;
	}
.header .menu > ul > li .sub-menu.active{
	display: block;
}
@keyframes slideLeft{
	0%{
		opacity:0;
		transform: translateX(100%);
	}
	100%{
	    opacity:1;
		transform: translateX(0%);	
	}
}
@keyframes slideRight{
	0%{
		opacity:1;
		transform: translateX(0%);
	}
	100%{
	    opacity:0;
		transform: translateX(100%);	
	}
}
	.header .menu > ul > li .sub-menu.mega-menu-column-4 > .list-item img{
		margin-top:0;
	}
	.header .menu > ul > li .sub-menu.mega-menu-column-4 > .list-item.text-center .title{
		margin-bottom: 20px;
	}
	.header .menu > ul > li .sub-menu.mega-menu-column-4 > .list-item.text-center:last-child .title{
		margin-bottom:0px;
	}
	.header .menu > ul > li .sub-menu.mega-menu-column-4 > .list-item{
		flex: 0 0 100%;
        padding: 0px;
	}
	.header .menu > ul > li .sub-menu > ul > li > a,
	.header .menu > ul > li .sub-menu.mega-menu > .list-item > ul > li > a{
		display: block;
	}
	.header .menu > ul > li .sub-menu.mega-menu > .list-item > ul {
		margin-bottom: 15px;
	}
	.menu-overlay{
		position: fixed;
		background-color: rgba(0,0,0,0.5);
		left:0;
		top:0;
		width: 100%;
		height: 100%;
		z-index: 1098;
		visibility: hidden;
		opacity:0;
		transition: all 0.5s ease;
	}
	.menu-overlay.active{
	  visibility: visible;
	  opacity:1;	
	}
}
</style>
</head>

<body>

<div class="page-wrapper">

    <div class="loader-wrap">
        <div class="preloader"><div class="preloader-close">Preloader Close</div></div>
        <div class="layer layer-one"><span class="overlay"></span></div>
        <div class="layer layer-two"><span class="overlay"></span></div>        
        <div class="layer layer-three"><span class="overlay"></span></div>        
    </div>

<header class="header">
      <div class="container" style="max-width: 1520px;">
        <div class="row v-center">
          <div class="header-item item-left">
            <div class="logo">
              <a href="index.php"><img src="assets/img/logo.png" alt="unique dosing"></a>
            </div>
          </div>
          <!-- menu start here -->
          <div class="header-item item-center">
            <div class="menu-overlay"></div>
            <nav class="menu">
              <div class="mobile-menu-head">
                <div class="go-back"><i class="fa fa-angle-left"></i></div>
                <div class="current-menu-title"></div>
                <div class="mobile-menu-close">&times;</div>
              </div>
              <ul class="menu-main">
                <li><i class="fa fa-home" style="font-size:16px;color: #e6181c;"></i>&nbsp;&nbsp;
                  <a href="index.php">Home</a>
                </li>
                <li class="menu-item-has-children">
                    <i class='fas fa-user-circle' style='font-size:16px;color: #e6181c;'></i>&nbsp;&nbsp;
                  <a href="#">About-Us <i class="fa fa-angle-down"></i></a>
                  <div class="sub-menu mega-menu mega-menu-column-4">
                    <div class="list-item text-center">
                     <a href="profile.php">
                        <img src="assets/img/uniq/menu/aboutus.png"
                          alt="About Us" style="height: auto;">
                        <h4 class="title">About Us</h4>
                      </a>
                    </div>
                    <div class="list-item text-center">
                      <a href="quality.php">
                        <img src="assets/img/uniq/menu/quality.png"
                          alt="Quality" style="height: auto;">
                        <h4 class="title">Quality</h4>
                       
                      </a>
                    </div>
                    <div class="list-item text-center">
                      <a href="infrastructure.php">
                        <img src="assets/img/uniq/menu/infrastructure.png"
                          alt="Infrastructure" style="height: auto;">
                        <h4 class="title">Infrastructure</h4>
                       
                      </a>
                    </div>
                    <!--<div class="list-item text-center">-->
                    <!--  <a href="industries-we-cater.php">-->
                    <!--    <img src="assets/img/uniq/menu/indusrywecare.png"-->
                    <!--      alt="Industries We Cater" style="height: auto;">-->
                    <!--    <h4 class="title">Industries We Cater</h4>-->
                       
                    <!--  </a>-->
                    <!--</div>-->
                  </div>
                </li>
                
        
                 <li class="menu-item-has-children">
                     <i class='fas fa-address-card' style='font-size:16px;color: #e6181c;'></i>&nbsp;&nbsp;
                  <a href="#">Credential<i class="fa fa-angle-down"></i></a>
                  <div class="sub-menu mega-menu mega-menu-column-4">
                    <div class="list-item text-center">
                     <a href="iso-certificate.php">
                         <img src="assets/img/uniq/menu/isocert.png"
                          alt="ISO Certificate" style="height: auto;">
                        <h4 class="title"> Certificate</h4>
                      </a>
                    </div>
                    <div class="list-item text-center">
                      <a href="quality-circle.php">
                          <img src="assets/img/uniq/menu/quality.png"
                          alt="Quality Circle" style="height: auto;">
                        <h4 class="title">Quality Circle</h4>
                      </a>
                    </div>
                    <div class="list-item text-center">
                      <a href="assets/img/unique-dosing-systems.pdf">
                          <img src="assets/img/uniq/menu/companybroucher.png"
                          alt="Company Brochure" style="height: auto;">
                        <h4 class="title">Company Brochure</h4>
                      </a>
                    </div>
                    
                    <div class="list-item text-center">
                        
                      <a href="assets/img/Introducing_Unique Dosing Systems.pdf">
                        <img src="assets/img/uniq/menu/companyprofile.png"
                          alt="Company Profile" style="height: auto;">
                        <h4 class="title">Company Profile</h4>
                       
                      </a>
                    </div>
                    
                       <div class="list-item text-center">
                      <a href="approval.php">
                      <img src="assets/img/uniq/aproved.png"
                          alt="Product Catalogue" style="height: auto;">
                        <h4 class="title">Approvals </h4>
                       
                      </a>
                    </div>
                 
                    <div class="list-item text-center">
                      <a href="clientele.php">
                        <img src="assets/img/uniq/menu/clientel.png  "
                          alt="Clientele" style="height: auto;">
                        <h4 class="title">Clientele</h4>
                       
                      </a>
                    </div>
                  </div>
                </li>
                  <li><i class="fa fa-industry" style="font-size:16px;color: #e6181c;"></i>&nbsp;&nbsp;<a href="industries-we-cater.php">Industries</a></li>
                
                <li class="menu-item-has-children">
                 <i class='fas fa-box-open' style='font-size:16px;color: #e6181c;'></i>&nbsp;&nbsp;
                  <a href="#">Products <i class="fa fa-angle-down"></i></a>
                  <div class="sub-menu mega-menu mega-menu-column-4">
                    <div class="list-item">
                      <h4 class="title"><a href="dosing-pumps.php" style="color:#10539a;">Dosing Pumps</a></h4>
                     <ul class="list-1" style="border-right: 2px dotted #b7b5b5;">
                                                     
                                    <li><a href="dosing-pump.php"><i class="fa fa-angle-double-right"></i>Dosing Pump </a></li>
                                     <li><a href="multihead-dosing-pumps.php"><i class="fa fa-angle-double-right"></i>Multihead Dosing Pumps </a></li>
                                     <li><a href="auto-controlled-dosing-pump.php"><i class="fa fa-angle-double-right"></i>Auto Controlled Dosing Pump </a></li>
                                     <li><a href="alum-dosing-pump.php"><i class="fa fa-angle-double-right"></i>Alum Dosing Pump </a></li>
                                      <li><a href="plunger-type-dosing-pump.php"><i class="fa fa-angle-double-right"></i>Plunger Type Dosing Pump</a></li>
                                      <li><a href="plunger-pumps.php"><i class="fa fa-angle-double-right"></i>Plunger Pumps </a></li>
                                      <li><a href="reciprocating-pumps.php"><i class="fa fa-angle-double-right"></i>Reciprocating Pumps</a></li>
                                      <li><a href="antiscalant-dosing-pump.php"><i class="fa fa-angle-double-right"></i>Antiscalant Dosing Pump </a></li>
                                      <li><a href="jacked-dosing-pump.php"><i class="fa fa-angle-double-right"></i>Jacked Dosing Pump</a></li>
                                      <li><a href="lime-dosing-pump.php"><i class="fa fa-angle-double-right"></i>Lime Dosing Pump </a></li>
                                      <li><a href="high-pressure-dosing-pump.php"><i class="fa fa-angle-double-right"></i>High Pressure Dosing Pump</a></li>
                                      <li><a href="flocculent-dosing-clarifier.php"><i class="fa fa-angle-double-right"></i>Flocculent Dosing for Clarifierp </a></li>
                                      <li><a href="rosin-dosing-pump.php"><i class="fa fa-angle-double-right"></i>Rosin Dosing Pump</a></li>
                                      <li><a href="etp-section.php"><i class="fa fa-angle-double-right"></i>ETP Section </a></li>
                                      <li><a href="effluent-treatment-plant-pump.php"><i class="fa fa-angle-double-right"></i>Effluent Treatment Plant Pump</a></li>
                                      <!--------------------->
                                      
                                      
                                      
                                    
                                     <!--<h4 class="title"><a href="" style="color:#10539a;">Other Pumps</a></h4>-->
                                      <h6 class="title"><a href="diaphragm-type-dosing-pumps.php" style="color:#10539a;font-size:16px;">Diaphragm Type Dosing Pumps</a></h6>
                                       <li><a href="diaphragm-type-dosing-pumps.php"><i class="fa fa-angle-double-right"></i>Diaphragm Type Dosing Pumps</a></li>
                                                
                                                     
                                    <li><a href="hydraulic-actuated-diaphragm-type-pump.php"><i class="fa fa-angle-double-right"></i>Hydraulic Actuated Diaphragm Type Pump </a></li>
                                     <li><a href="hydraulic-diaphragm-pump.php"><i class="fa fa-angle-double-right"></i>Hydraulic Diaphragm Pump </a></li>
                                      
                                       <h4 class="title"><a href="metering-pump.php" style="color:#10539a;font-size:16px;">Metering Pump</a></h4>
                                      <li><a href="metering-pump.php"><i class="fa fa-angle-double-right"></i>Metering Pump</a></li>

                                                 </ul>
                     
                    </div>
                    <div class="list-item">
                        <h4 class="title"><a href="dosing-pumps.php" style="color:#10539a;">Dosing Pumps</a></h4>
                    <ul class="list-1" style="border-right: 2px dotted #b7b5b5;">
                        <li><a href="mechanical-actuated-diaphragm-pumps.php"><i class="fa fa-angle-double-right"></i>Mechanical Actuated Diaphragm Pumps </a></li>
                      
                                         
                                       <li><a href="electronic-dosing-pumps.php"><i class="fa fa-angle-double-right"></i>Electronic Dosing Pumps</a></li>
                                      
                                      <li> <a href="shrikhand-transfer-pumps.php"><i class="fa fa-angle-double-right"></i>Shrikhand Transfer Pumps</a></li>
                          
                      
                                      <li><a href="filter-press-pump.php"><i class="fa fa-angle-double-right"></i>Filter Press Pump </a></li>
                                      
                                      
                                      
                                      <h4 class="title"><a href="hydro-test-pumps.php" style="color:#10539a;font-size:16px;">Hydro Test Pumps</a></h4>
                                      <li><a href="hydro-test-pumps.php"><i class="fa fa-angle-double-right"></i>Hydro Test Pumps</a></li>
                                                 
                           
                                                         
                                <li><a href="demineralised-water-plant-pump.php"><i class="fa fa-angle-double-right"></i>Demineralised Water Plant Pump</a></li>
                                <li ><a href="hydrostatic-pump.php"><i class="fa fa-angle-double-right"></i>Hydrostatic Pump</a></li>
                                 <li><a href="hydro-testing-pump.php"><i class="fa fa-angle-double-right"></i>Hydro Testing Pump</a></li>
                                 <li><a href="hydro-test-pump-accessories.php"><i class="fa fa-angle-double-right"></i>Hydro Test Pump &amp; Accessories</a></li>
  
                              
                                      
                                      
                                            
                                              
                                              
                                              <h4 class="title"><a href="sugar-industries-pump.php" style="color:#10539a;font-size:16px;">Sugar Industries Pump</a></h4>
                                        <li><a href="sugar-industries-pump.php"><i class="fa fa-angle-double-right"></i>Sugar Industries Pump</a></li>
                                         
                                                           
                                        <li><a href="mill-section-mill-sanitation.php"><i class="fa fa-angle-double-right"></i>Mill Section : Mill Sanitation</a></li>
                                         <li><a href="pan-manufacturing-section-antiscalent.php"><i class="fa fa-angle-double-right"></i>Pan/Manufacturing Section : Antiscalent</a></li>
                                        <li><a href="distillery-tro-dosing-pump.php"><i class="fa fa-angle-double-right"></i>Distillery : Tro Dosing Pump</a></li>
                                         <li><a href="mill-sanitation-dosing-pump.php"><i class="fa fa-angle-double-right"></i>Mill Sanitation Dosing Pump</a></li>
                                         
                                          <h4 class="title"><a href="chemical-pumps.php" style="color:#10539a;font-size:16px;">Chemical Pumps</a></h4>
                                       <li><a href="chemical-pumps.php"><i class="fa fa-angle-double-right"></i>Chemical Pumps</a></li>
                                                   
                                       <li><a href="chemical-dosing-pumps.php"><i class="fa fa-angle-double-right"></i>Chemical Dosing Pumps</a></li>
                                      <li><a href="chemical-dosing-skid.php"><i class="fa fa-angle-double-right"></i>Chemical Dosing Skid</a></li>
                                     <li><a href="chemical-dosing-system.php"><i class="fa fa-angle-double-right"></i>Chemical Dosing System</a></li>
                                    <li><a href="mill-sanitation-dosing-pump.php"><i class="fa fa-angle-double-right"></i>Mill Sanitation Dosing Pump</a></li>
                                      </ul>
                   
                   
                    </div>
                    
                    <div class="list-item">
                        <h4 class="title"><a href="dosing-systems.php" style="color:#10539a;">Dosing Systems</a></h4>
                      <ul class="list-1" style="border-right: 2px dotted #b7b5b5;">
                     
                                                  <li><a href="dosing-systems.php"><i class="fa fa-angle-double-right"></i>Dosing Systems </a></li>
                                     <li><a href="skid-mounted-dosing-systems.php"><i class="fa fa-angle-double-right"></i>Skid Mounted Dosing Systems  </a></li>
                                      <li><a href="aluminium-dosing-system.php"><i class="fa fa-angle-double-right"></i>Aluminium Dosing System</a></li>
                                      <li><a href="boiler-chemical-dosing-system.php"><i class="fa fa-angle-double-right"></i>Boiler Chemical Dosing System </a></li>
                                      <li><a href="chlorine-dosing-system.php"><i class="fa fa-angle-double-right"></i>Chlorine Dosing System</a></li>
                                      <li><a href="oxallic-acid-dosing-system.php"><i class="fa fa-angle-double-right"></i>Oxallic Acid Dosing System</a></li>
                                      <li><a href="phosphoric-acid-dosing-system.php"><i class="fa fa-angle-double-right"></i>Phosphoric Acid Dosing System</a></li>
                                      <li><a href="sodium-hypochlorite-dosing-system.php"><i class="fa fa-angle-double-right"></i>Sodium Hypochlorite Dosing System </a></li>
                                      <li><a href="flocculent-dosing-system.php"><i class="fa fa-angle-double-right"></i>Flocculent Dosing System </a></li>
                                      <li><a href="polyelectrolyte-dosing-system.php"><i class="fa fa-angle-double-right"></i>Polyelectrolyte Dosing System </a></li>
                                      <li><a href="caustic-dosing-system.php"><i class="fa fa-angle-double-right"></i>Caustic Dosing System  </a></li>
                                      <li><a href="alum-dosing-systems.php"><i class="fa fa-angle-double-right"></i>Alum Dosing Systems  </a></li>
                                      <li><a href="lime-dosing-system.php"><i class="fa fa-angle-double-right"></i>Lime Dosing System</a></li>
                                       <li><a href="ferric-chloride-dosing-system.php"><i class="fa fa-angle-double-right"></i>Ferric Chloride Dosing System  </a></li>
                                      <li><a href="hp-dosing-system.php"><i class="fa fa-angle-double-right"></i>HP Dosing System</a></li>
                                       <li><a href="bill-section-lp-hp-dosing-system.php"><i class="fa fa-angle-double-right"></i>Bill Section:LP/HP Dosing System  </a></li>
                                      <li><a href="cooling-tower-dosing-system.php"><i class="fa fa-angle-double-right"></i>Cooling Tower Dosing System</a></li>
                                       <li><a href="coolant-dosing-system.php"><i class="fa fa-angle-double-right"></i>Coolant Dosing System  </a></li>
                                      <li><a href="hcl-dosing-system.php"><i class="fa fa-angle-double-right"></i>HCL Dosing System</a></li>
                                       <li><a href="plunger-type-metering-system.php"><i class="fa fa-angle-double-right"></i>Plunger Type Metering System  </a></li>
                                     <!---------------->
                                     <li><a href="caustic-metering-system.php"><i class="fa fa-angle-double-right"></i>Caustic Metering System </a></li>
                                     
                                    
                      </ul>
                    
                    </div>
                    
                    
                    
                    
                    
                    
                    
                    <div class="list-item">
                        <h4 class="title"><a href="product.php" style="color:#10539a;"> Other Pumps</a></h4>
                       <ul class="list-1" style="border-right: 2px dotted #b7b5b5;">
                
                                       <li><a href="resonator-dampener.php"><i class="fa fa-angle-double-right"></i>Resonator Dampener </a></li>
                        <li><a href="bladder-type-pulsation-dampener.php"><i class="fa fa-angle-double-right"></i>Bladder Type Pulsation Dampener </a></li>
                        <li><a href="volume-bottle-type-pulsation.php"><i class="fa fa-angle-double-right"></i>Volume Bottle Type Pulsation</a></li>
                            <li><a href="water-mist-generation-unit.php"><i class="fa fa-angle-double-right"></i>Water Mist Generation Unit</a></li>
                                    
                                                 
                                    
                                     
                                         <h4 class="title"><a href="pump-accessories.php" style="color:#10539a;font-size:16px;">Pump Accessories</a></h4>
                                                         <li><a href="pump-accessories.php"><i class="fa fa-angle-double-right"></i>Pump Accessories</a></li>
                                     <li><a href="pulsation-dampners.php"><i class="fa fa-angle-double-right"></i>Pulsation Dampners</a></li>
                                     <li><a href="nrv-vertical-horizontal-valves.php"><i class="fa fa-angle-double-right"></i>NRV Vertical / Horizontal Valves</a></li>
                                      <li><a href="pressure-safety-valve.php"><i class="fa fa-angle-double-right"></i>Pressure Safety Valve</a></li>
                                          
                       
                       
                             <h4 class="title"><a href="agitator.php" style="color:#10539a;font-size:16px;">Agitator</a></h4>
                                         <li><a href="agitator.php"><i class="fa fa-angle-double-right"></i>Agitator </a></li>
                                                    
                                          <li><a href="dosing-system-agitator-stirrer.php"><i class="fa fa-angle-double-right"></i>Dosing System Agitator (Stirrer)</a></li>
                      </ul>
                     
                       
                                                   
                       
                    
                    </div>
                    
                    
                    
                  </div>
                </li>
                
                <!--<li><a href="#"> Downloads </a>-->
               <li><i class='fas fa-phone-volume' style='font-size:16px;color: #e6181c;'></i>&nbsp;&nbsp;<a href="contact-us.php">Contact Us</a></li>
                </li>
              </ul>
            </nav>
          </div>
          <!-- menu end here -->
          <div class="header-item item-right">
            <div class="sidemenu-nav-toggler mr_30"><img src="assets/images/icons/menu.svg" alt="menu"></div>
             <!--<div class="header-link-btn"><img src="assets/images/icons/menu.svg" alt="menu"></div>-->
            
            <div class="header-link-btn"><a href="enquire-now.php" class="btn-1 pt_10 pb_10 pl_30 pr_30 b_radius_23 ff_sec fw_bold tt_u fs_14 ls_1">Enquire Now</a></div>
            <!-- mobile menu trigger -->
            <div class="mobile-menu-trigger">
              <span></span>
            </div>
          </div>
        </div>
      </div>
    </header>
    <!-- header end -->


    <section class="hidden-sidebar close-sidebar">
        <div class="wrapper-box">
            <div class="hidden-sidebar-close"><span class="fal fa-times"></span></div>
            <div class="logo"><a href="#"><img src="assets/img/logo.png" alt="logo"></a></div>
            <div class="content">
             
                <!-- Contact Widget -->
                <div class="sidebar-contact-info mb_40">
                    <h4 class="fs_22 fw_medium mb_20">Conatct Us</h4>
                    <ul>
                        <li>
                            <div class="inner">
                                <div class="icon">
                                    <img src="assets/images/icons/icon-7__mapmarker.png" alt="icon">
                                </div>
                                <div class="text">
									<h4 class="fs_22 fw_medium mb_20">Address</h4>
                                    <p>Plot No. - M88, MIDC, Ambad, Nashik - 422010, Maharashtra, India</p>
                                    
                                </div>
                            </div>
                        </li>
                        <li>
                            <div class="inner">
                                <div class="icon">
                                    <img src="assets/images/icons/icon-9__phone.png" alt="icon">
                                </div>
                                <div class="text">
									<h4 class="fs_22 fw_medium mb_20">Mr. Mahendra Kasar(Director)</h4>
									<p><a href="tel:+91 253-2386610">Tele No.: +91 253-2386610 </a><br><a href="tel:+91 253-2386610">+91 9822420535</a></p>
                                </div>
                            </div>
                        </li>
                        <li>
                            <div class="inner">
                                <div class="icon">
                                    <img src="assets/images/icons/icon-8__envelop.png" alt="icon">
                                </div>
                                <div class="text">
                                    <p><a href="mailto: info@uniquedosing.com"> Email: info@uniquedosing.com</a> <br><a href="mailto: sales@uniquedosing.com">
sales@uniquedosing.com

</a></p>
                                </div>
                            </div>
                        </li>
                       
                    </ul>
                </div>
                <!-- Newsletter Widget -->
                <div class="newsletter-widget">
                    <h4 class="fs_22 fw_medium mb_20">Newsletter Subscription</h4>
                    <form action="#">
                        <input type="email" placeholder="Enter Email Address">
                        <button class="btn-1 pt_18 pb_15 pl_30 pr_30 ff_sec fw_bold tt_u fs_14 ls_1">Subscribe Us <i class="flaticon-right-arrow-1"></i><span></span></button>
                    </form>
                </div>
            </div>
        </div>
    </section>

    <div id="search-popup" class="search-popup">
        <div class="close-search theme-btn"><span class="fal fa-times"></span></div>
        <div class="popup-inner">
            <div class="overlay-layer"></div>
            <div class="search-form">
                <form method="post" action="#">
                    <div class="form-group">
                        <fieldset>
                            <input type="search" class="form-control" name="search-input" value="" placeholder="Search Here" required >
                            <input type="submit" value="Search Now!" class="theme-btn">
                        </fieldset>
                    </div>
                </form>
                <br>
                <h3>Recent Search Keywords</h3>
                <ul class="recent-searches">
                    <li><a href="#">Finance</a></li>
                    <li><a href="#">Idea</a></li>
                    <li><a href="#">Service</a></li>
                    <li><a href="#">Growth</a></li>
                    <li><a href="#">Plan</a></li>
                </ul>
            </div>
        </div>
    </div>
    
  <script>
    
const menu = document.querySelector(".menu");
const menuMain = menu.querySelector(".menu-main");
const goBack = menu.querySelector(".go-back");
const menuTrigger = document.querySelector(".mobile-menu-trigger");
const closeMenu = menu.querySelector(".mobile-menu-close");
let subMenu;

// Open the main menu
menuTrigger.addEventListener("click", () => {
    toggleMenu();
});

// Close the main menu
closeMenu.addEventListener("click", () => {
    toggleMenu();
});

// Close menu when clicking outside (overlay)
document.querySelector(".menu-overlay").addEventListener("click", () => {
    toggleMenu();
});

// Handle menu clicks
menuMain.addEventListener("click", (e) => {
    if (!menu.classList.contains("active")) return;

    const target = e.target;

    // Allow normal navigation for links
    if (target.tagName === "A") {
        menu.classList.remove("active"); // Close menu after clicking link
        document.querySelector(".menu-overlay").classList.remove("active");
        return;
    }

    // Handle submenu activation
    if (target.closest(".menu-item-has-children")) {
        const hasChildren = target.closest(".menu-item-has-children");
        showSubMenu(hasChildren);
    }
});

// Go back from submenu
goBack.addEventListener("click", () => {
    hideSubMenu();
});

// Toggle main menu visibility
function toggleMenu() {
    menu.classList.toggle("active");
    document.querySelector(".menu-overlay").classList.toggle("active");
}

// Show submenu
function showSubMenu(hasChildren) {
    subMenu = hasChildren.querySelector(".sub-menu");
    subMenu.classList.add("active");
    subMenu.style.animation = "slideLeft 0.5s ease forwards";

    const menuTitle = hasChildren.querySelector("i").parentNode.childNodes[0].textContent;
    menu.querySelector(".current-menu-title").innerHTML = menuTitle;
    menu.querySelector(".mobile-menu-head").classList.add("active");
}

// Hide submenu
function hideSubMenu() {
    if (!subMenu) return; // Prevent errors if no submenu is open

    subMenu.style.animation = "slideRight 0.5s ease forwards";
    setTimeout(() => {
        subMenu.classList.remove("active");
    }, 300);

    menu.querySelector(".current-menu-title").innerHTML = "";
    menu.querySelector(".mobile-menu-head").classList.remove("active");
}

// Auto-close menu on window resize
window.onresize = function () {
    if (window.innerWidth > 991 && menu.classList.contains("active")) {
        toggleMenu();
    }
};


</script> 

<!-- Event snippet for Submit lead form conversion page
In your html page, add the snippet and call gtag_report_conversion when someone clicks on the chosen link or button. -->
<script>
function gtag_report_conversion(url) {
  var callback = function () {
    if (typeof(url) != 'undefined') {
      window.location = url;
    }
  };
  gtag('event', 'conversion', {
      'send_to': 'AW-16920636302/g3-SCNTMjakaEI7XsYQ_',
      'value': 1.0,
      'currency': 'INR',
      'event_callback': callback
  });
  return false;
}
</script>
