<?php include('header.php');?>

    <style>.filter_links {
  margin-top: 18px;
  width: 100%;
  display: flex;
  align-items: center;
  justify-content: center;
}

.filter_links ul {
  position: relative;
  overflow-x: auto;
  list-style: none;
  display: flex;
  background: #1f1f1f;
  border-radius: 12px;
}

.active_box {
  position: absolute;
  top: 0;
  left: 0;
  transform: translateX(0px);
  z-index: 1;
  width: 120px;
  height: 100%;
  background: crimson;
  border-radius: 12px;
  transition: transform 0.3s ease-in-out;
}

.filter_links ul li {
  width: 120px;
  z-index: 2;
  text-align: center;
  font-family: "Segoe UI", Tahoma, Geneva, Verdana, sans-serif;
  padding: 8px 0px;
  color: #ffffff;
  font-size: 18px;
  font-weight: 500;
  text-transform: capitalize;
  cursor: pointer;
}

.filter_image_container {
  margin-top: 12px;
  padding-inline: 20px;
  max-width: 100%;
  column-count: 3;
  column-gap: 0px;
}

.filter_image_container img {
  transition: width 0.3s height 0.4s ease-out;
  width: 100%;
  padding: 4px;
  border-radius: 12px;
}

.image_box {
  display: grid;
  grid-template-rows: 0fr;
  transition: grid-template-rows 0.5s ease;
}

.hide_image {
  display: none;
}

@media screen and (max-width: 768px) {
  .filter_links {
    padding-block: 12px;
    margin-top: 18px;
    width: 100%;
    margin: 0 auto;
  }
  .filter_image_container {
    margin-top: 12px;
    padding-inline: 20px;
    max-width: 100%;
    column-count: 2;
    column-gap: 0px;
  }
  .active_box {
    width: 70px;
  }

  .filter_links ul li {
    width: 70px;
    padding: 6px 0px;
    color: #ffffff;
    font-size: 12px;
    font-weight: 500;
  }
}

@media screen and (max-width: 368px) {
  .filter_image_container {
    margin-top: 12px;
    padding-inline: 20px;
    max-width: 100%;
    column-count: 1;
    column-gap: 0px;
  }
  .filter_links {
    padding-block: 12px;
    margin-top: 18px;
    width: 100%;
    margin: 0 auto;
  }
}
</style>




    <!-- Title Bar -->
         <div class="pbmit-title-bar-wrapper">
            <div class="container">
               <div class="pbmit-title-bar-content">
                  <div class="pbmit-title-bar-content-inner">
                     <div class="pbmit-tbar">
                        <div class="pbmit-tbar-inner container">
                           <h1 class="pbmit-tbar-title"> Gallery </h1>
                        </div>
                     </div>
                     <div class="pbmit-breadcrumb">
                        <div class="pbmit-breadcrumb-inner">
                           <span><a title="" href="#" class="home"><span>Home</span></a></span>
                           <span class="sep"><i class="pbmit-base-icon-angle-double-right"></i></span>
                           <span><span class="post-root post post-post current-item">Gallery</span></span>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
         <!-- Title Bar End-->
         
         
        
  <div class="container mt-5">
    <div class="heading">
      <h2>Gallery</h2>
    </div>
    <!-- filter links -->
    <div class="filter_links">
      <ul class="links">
        <li class="active_box"></li>
        <li class="link" data-filter="*">all</li>
        <li class="link" data-filter="radio">Radiology</li>
        <li class="link" data-filter="optometry">Optometry</li>
        <li class="link" data-filter="medical">Medical Lab</li>
        <li class="link" data-filter="society"> Society</li>
      </ul>
    </div>

    <div class="filter_image_container">
      <img
        class="gallery_image"
        src="images/rd2.jpg"
        alt="1.jpg"
        alt="image"
        data-image-type="['radio']"
      />
      <img
        class="gallery_image"
        src="images/ml1.jpg"
        alt="image"
        data-image-type="['medical']"
      />
      <img
        class="gallery_image"
        src="images/op2.jpg"
        alt="3.jpg"
        alt="image"
        data-image-type="['optometry']"
      />
      <img
        class="gallery_image"
        src="images/ml2.jpg"
        alt="4.jpg"
        alt="image"
        data-image-type="['medical']"
      />
      <img
        class="gallery_image"
        src="images/op1.jpg"
        alt="5.jpg"
        alt="image"
        data-image-type="['optometry']"
      />
      <img
        class="gallery_image"
        src="images/rd1.jpg"
        alt="6.jpg"
        alt="image"
        data-image-type="['radio']"
      />
      <img
        class="gallery_image"
        src="images/ml3.jpg"
        alt="7.jpg"
        alt="image"
        data-image-type="['medical']"
      />
      <img
        class="gallery_image"
        src="images/rd3.jpg"
        alt="8.jpg"
        alt="image"
        data-image-type="['radio']"
      />
      <img
        class="gallery_image"
        src="images/ml4.png"
        alt="9.jpg"
        alt="image"
        data-image-type="['medical']"
      />
      <img
        class="gallery_image"
        src="images/ml5.jpg"
        alt="10.jpg"
        alt="image"
        data-image-type="['medical']"
      />
      <img
        class="gallery_image"
        src="images/rd4.jpg"
        alt="11.jpg"
        alt="image"
        data-image-type="['radio']"
      />
      <img
        class="gallery_image"
        src="images/op3.jpg"
        alt="12.jpg"
        alt="image"
        data-image-type="['optometry']"
      />
      <img
        class="gallery_image"
        src="images/op4.jpg"
        alt="13.jpg"
        alt="image"
        data-image-type="['optometry']"
      />
      <!--<img-->
      <!--  class="gallery_image"-->
      <!--  src="images/DSC06759.jpg"-->
      <!--  alt="14.jpg"-->
      <!--  alt="image"-->
      <!--  data-image-type="['radio']"-->
      <!--/>-->
      <img
        class="gallery_image"
        src="images/op5.jpg"
        alt="15.jpg"
        alt="image"
        data-image-type="['optometry']"
      />
      <!--<img-->
      <!--  class="gallery_image"-->
      <!--  src="images/DSC06768.jpg"-->
      <!--  alt="16.jpg"-->
      <!--  alt="image"-->
      <!--  data-image-type="['radio']"-->
      <!--/>-->
      <img
        class="gallery_image"
        src="images/op6.jpg"
        alt="image"
        data-image-type="['optometry']"
      />
      <img
        class="gallery_image"
        src="images/ml6.jpg"
        alt="18.jpg"
        alt="image"
        data-image-type="['medical']"
      />
      <img
        class="gallery_image"
        src="images/ac1.jpg"
        alt="19.jpg"
        alt="image"
        data-image-type="['society']"
      />
       <img
        class="gallery_image"
        src="images/ac9.jpg"
        alt="19.jpg"
        alt="image"
        data-image-type="['society']"
      />
      <img
        class="gallery_image"
        src="images/ac2.jpg"
        alt="19.jpg"
        alt="image"
        data-image-type="['society']"
      />
       <img
        class="gallery_image"
        src="images/ac8.jpg"
        alt="19.jpg"
        alt="image"
        data-image-type="['society']"
      />
      <img
        class="gallery_image"
        src="images/ac3.jpg"
        alt="19.jpg"
        alt="image"
        data-image-type="['society']"
      />
      <img
        class="gallery_image"
        src="images/ac4.jpg"
        alt="19.jpg"
        alt="image"
        data-image-type="['society']"
      />
      <img
        class="gallery_image"
        src="images/ac5.jpg"
        alt="19.jpg"
        alt="image"
        data-image-type="['society']"
      />
      <img
        class="gallery_image"
        src="images/ac6.jpg"
        alt="19.jpg"
        alt="image"
        data-image-type="['society']"
      /><img
        class="gallery_image"
        src="images/ac7.png"
        alt="19.jpg"
        alt="image"
        data-image-type="['society']"
      />
     
     
    </div>


  </div>

    <script>
      const filterLinks = Array.from(document.querySelectorAll(".link"));
const allImages = Array.from(document.querySelectorAll(".gallery_image"));
const activeBox = document.querySelector(".active_box");
let windowWidth = 120;
window.addEventListener("resize", () => {
  windowWidth = window.innerWidth > 768 ? 120 : 70;
  console.log(windowWidth);
});

filterLinks.forEach((link, index) => {
  link.addEventListener("click", () => {
    console.log(getComputedStyle(link).width);
    let activeBoxPosition =
      index * Number(getComputedStyle(link).width.slice(0, -2));
    activeBox.style.transform = `translateX(${activeBoxPosition}px)`;
    activeBox.style.width = getComputedStyle(link).width;

    filterImages(link.getAttribute("data-filter"));
  });
});

function filterImages(imageFilterType) {
  allImages.forEach((image) => {
    let imageType = image.getAttribute("data-image-type");
    if (!imageType.includes(imageFilterType) && imageFilterType !== "*") {
      image.classList.add("hide_image");
    } else {
      image.classList.remove("hide_image");
    }
  });
}

    </script>

<?php include('footer.php');?>