(function () {
    var $;

    function aggregateTokens(selector) {
        var tokens = [];

        $(selector).each(function () {
            var token = $(this).data('token');
            if (!token) return;

            tokens.push(token);
        });

        return tokens;
    }

    function replaceAllElements(selector, valueMap, valueDataName, replaceDataName) {
        replaceDataName = replaceDataName || 'replace-from';
        valueDataName = valueDataName || 'token';

        $(selector).each(function () {
            var $el = $(this);
            var token = $el.data(valueDataName);
            var replaceFrom = $el.data(replaceDataName);
            var replaceTo = valueMap[token];

            if (!token || !replaceFrom || !replaceTo) return;

            var html = replaceAll(replaceFrom, replaceTo, $el.html());
            $el.html(html);
        });
    }

    function replaceAllTokens(selector, fetchedTokens) {
        replaceAllElements(selector, fetchedTokens, 'token', 'replace-from');
    }

    // JS String.prototype.replace replaces the first instance.
    function replaceAll(search, replace, subject) {
        return subject.split(search).join(replace);
    }

    function requestNumbers(kbid, tokens) {
        var url = window.mapiAjaxUrl;
        if (!url) return null;

        var data = {
            action: 'mapi_token_numbers',
            tokens: tokens,
            path: window.location.pathname,
            mapiNonce: window.mapiNonces ? window.mapiNonces.mapi_token_numbers : ''
        };

        if(kbid) data.kbid = kbid;

        return $.getJSON(url, data);
    }

    function datalayerPush(obj) {
        window.data_layer = window.data_layer || [];
        window.data_layer.push(obj);
    }

    function performTokenRequest(tokens) {
        var kbid = Promo.getKbid();

        tokens = tokens || aggregateTokens('.cl-phone');
        if (!tokens || !tokens.length) return false;

        var xhr = requestNumbers(kbid, tokens);
        if (!xhr) return false;

        xhr.then(function (response) {
            if (!response || !response.tokens) return;

            replaceAllTokens('.cl-phone', response.tokens);
            handleHeartbeatResponse(response);
        });

        return xhr;
    }

    function cookie(name) {
        return name !== undefined ? decodeURIComponent((("; " + document.cookie).split("; " + name + "=")[1] || "").split(";")[0]) : '';
    }

    function getQueryParams() {
        const qp = Promo.parseQueryString();
        const params = ['kbid', 'utm_channel', 'utm_medium', 'utm_campaign', 'utm_source', 'utm_term', 'utm_content', 'utm_name'];
        var out = {};
        for (var i = 0, len = params.length; i < len; i++) {
            if (params[i] in qp) {
                out[params[i]] = qp[params[i]];
            }
        }
        return out;
    }

    // TODO Update audience when we have an audience mapper.
    function getDefaultDataLayer() {
        const queryParams = getQueryParams();
        var out = {
            'postal_code': '',
            'audience': 'Everyone',
            'rotation_enabled': false,
            'request_id': '',
            'request_id_encoded': '',
            'promo_code': '',
            'kbid': '',
            'historical_promo_code': cookie('historical_promo_code'),
            'marketing_channel': '',
            'mobile': /Mobi/i.test(window.navigator.userAgent) ? 1 : 0,
            'state': '',
            'city': '',
            'opt_test': '',
            'opt_v': '',
            'utm_channel': '',
            'utm_medium': '',
            'utm_campaign': '',
            'utm_source': '',
            'utm_term': '',
            'utm_content': '',
            'utm_name': '',
            'aoa': [''],
            'screen_resolution': window.screen.width + 'x' + window.screen.height,
            'promo_brand': '',
            'visitor_id': '',
            'buyflow': false,
            'site_search': false,
            'current_scroll_depth': 0,
            'display_id': '',
            'last_price_viewed': '',
            'last_product_viewed': '',
            'last_product_name': '',
            'used_availability': true,
            'isp': ''
        };

        for (var i in queryParams) {
            // noinspection JSUnfilteredForInLoop
            out[i] = queryParams[i];
        }

        return out;
    }

    function setPiwikID() {
        var curTimeout = 0;
        var piwikInt = setInterval(function () {
            curTimeout += 1000;
            if (curTimeout > 10000) {
                clearInterval(piwikInt);
            }

            if (!window.piwikData || !window.piwikData.fingerprint) {
                return;
            }

            clearInterval(piwikInt);
            datalayerPush({visitor_id: window.piwikData.fingerprint});
            datalayerPush({event: 'clDatalayerFingerprint'});
        }, 1000);
    }

    function getMapiCache(key) {
        var mapiCache = window.localStorage && window.localStorage.getItem('mapi');
        if(!mapiCache) return key ? '' : {};

        var cache = JSON.parse(mapiCache);
        return key ? cache[key] : cache;
    }

    function setMapiCache(key, value) {
        var cache = getMapiCache() || {};
        cache[key] = value;

        window.localStorage && window.localStorage.setItem('mapi', cache);
        return cache;
    }

    function getMapiJsRequestId() {
        return getMapiCache('requestId');
    }

    function getDataLayer(response) {
        if (!response) {
            return getDefaultDataLayer();
        }

        // When we have no WP request ID, but a mapi-js one, send the mapi-js one
        // to WP
        var requestId = response.requestId;
        if(!requestId && getMapiJsRequestId()) {
            requestId = getMapiJsRequestId();
        }

        var defaultDl = getDefaultDataLayer();
        defaultDl.promo_code = response.promoCode;
        defaultDl.request_id = requestId;
        defaultDl.request_id_encoded = encodeURI(requestId);

        setPiwikID();

        return defaultDl;
    }

    function performHeartbeatRequest() {
        var query = Promo.parseQueryString();

        var url = window.mapiAjaxUrl;
        if (!url) return null;

        var data = {
            action: 'mapi_hb',
            location: window.location + '',
            path: window.location.pathname,
            incomingQuery: window.location ? window.location.search : '',
            referrer: window.document.referrer,
            mapiNonce: window.mapiNonces ? window.mapiNonces.mapi_hb : ''
        };

        if (query.kbid) data.kbid = query.kbid;

        setUpRequestIdWatcher();
        return $.getJSON(url, data).then(handleHeartbeatResponse);
    }

    function setUpRequestIdWatcher() {
        var reqIdId = setInterval(function() {
            var reqId = getMapiJsRequestId();
            if(!reqId) return;

            clearInterval(reqIdId);
            var wpId = getFromDataLayer('requestID');

            $.get(
                window.mapiBaseUrl + '/cpr/request/' + (wpId || reqId),
                function (mapiData) {
                    var promoData = mapiData && mapiData.data && mapiData.data.promo_data && mapiData.data.promo_data.data;
                    var maxmindData = (mapiData && mapiData.data && mapiData.data.maxmind && mapiData.data.maxmind.data) || {};

                    if(!promoData) return;

                    datalayerPush({
                        rotation_enabled: promoData.conversion_tracking,
                        promo_brand: promoData.promo_brand,
                        marketing_channel: promoData.marketing_channel,
                        isp: maxmindData.mm_isp
                    });
                    datalayerPush({event: 'clDatalayerPromoInfo'});
                }
            );

            // If we have a request ID from WP, it wins. Don't overwrite.
            if(wpId) {
                return;
            }

            // Otherwise, set our MAPI generated request ID in WP. This will happen on those pages
            // that aren't served a rotated number.
            // Of course, we could have the WP backend always hit at least the track endpoint in MAPI,
            // and return a request ID. Problem is that mapi-js only waits up to 5 seconds before giving
            // up and hitting the track endpoint itself. Since we have to cover that scenario anyway,
            // not worth adding code to the backend when we have to add this frontend code regardless.
            datalayerPush({requestID: reqId});
            setWpRequestId(reqId);
        });
    }

    function setWpRequestId(requestId) {
        // if the WP request id is already this, don't push it.
        if(getFromDataLayer('requestID') === requestId) {
            return null;
        }

        var url = window.mapiAjaxUrl;
        if (!url) return null;
        
        var data = {
            action: 'mapi_set_request_id',
            location: window.location + '',
            requestId: requestId,
            mapiNonce: window.mapiNonces ? window.mapiNonces.mapi_set_request_id : ''
        };

        return $.getJSON(url, data);
    }

    function replaceUrlWithMap(el, promoMap) {
        var parsed = Promo.parseUrl(el.href);
        var host = (parsed.hostname || '').replace(/^www\./, '');
        var withPath = host + parsed.pathname;
        var promo = window.mapiPromo;

        var map = promoMap[withPath] || promoMap[host];

        if (!map) return;
        if (!promo) return;
        if (!map[promo]) return;

        el.href = Promo.replaceQueryParameters(el.href, map[promo].rows || []);
    }

    function getFromDataLayer(keyToFind, dl) {
        dl = dl || window.data_layer || [];

        // Last element wins
        for(var i = dl.length-1; i >= 0; i--) {
            var item = dl[i][keyToFind];
            if(typeof item !== 'undefined') {
                return item;
            }
        }

        return undefined;
    }

    function handleHeartbeatResponse(response) {
        if (!response.promoCode) return;

        var dl = getDataLayer(response);
        if(response.requestId) dl.requestID = response.requestId;
        if(response.promoCode) {
            // duplicating, since mapi-js looks for promoCode
            dl.promoCode = response.promoCode;
            dl.promo_code = response.promoCode;
        }

        window.mapiPromo = response.promoCode;

        var promoMap = response.promoMap;

        if (promoMap) {
            var domains = Object.keys(promoMap);

            $('a').each(function () {
                var href = this.href || '';

                for (var i = 0; i < domains.length; i++) {
                    if (href.indexOf(domains[i]) !== -1) {
                        replaceUrlWithMap(this, promoMap);
                    }
                }
            });
        }

        datalayerPush(dl);
        datalayerPush({event: 'clDatalayerBasic'});
        datalayerPush({event: 'clDatalayerProductInfo'});
        triggerOnce('mapi_heartbeat', response);

        $.get(
            window.mapiBaseUrl + '/geoip',
            function (geoData) {
                datalayerPush({
                    city: geoData.data.cityName,
                    state: geoData.data.mostSpecificSubdivisionIsoCode,
                    postal_code: geoData.data.cityPostalCode
                });
                datalayerPush({event: 'clDatalayerGeo'});
            }
        );
    }

    var events = {};
    var triggered = {};

    function on(event, cb) {
        if (!events[event]) events[event] = [];

        // A trigger-once event has already been triggered, call immediately
        if (triggered[event]) {
            cb.apply(null, triggered[event]);
            return;
        }

        events[event].push(cb);
    }

    function remove(event, cb) {
        var handlers = events[event];
        if (!handlers) return;

        var index = handlers.indexOf(cb);
        if (index === -1) return;

        handlers.splice(index, 1);
    }

    function trigger(event) {
        var args = arguments;

        each(events[event], function (cb) {
            cb.apply(null, args);
        });
    }

    function triggerOnce(event) {
        var args = Array.prototype.slice.call(arguments);
        trigger.apply(null, args);

        events[event] = [];
        triggered[event] = args;
    }

    // Bootstrap events that came in before the mapiRepl script loaded
    if(window.mapiEvents && window.mapiEvents.ev) {
        var evs = window.mapiEvents.ev;
        for(var key in evs) {
            if(!evs.hasOwnProperty(key)) continue;

            var cbs = evs[key];
            if(!cbs.length) continue;
            for(var i = 0; i < cbs.length; i++) {
                on(key, cbs[i]);
            }
        }
    }

    window.mapiEvents = {
        on: on,
        remove: remove
    };

    function initLinkAttributes() {
        var url = window.mapiAjaxUrl;
        if (!url) return null;

        var data = {
            action: 'mapi_get_link_attributes'
        };

        return $.getJSON(url, data).then(linkAttributes);
    }

    function blacklisted(href, list) {
        if (!list) {
            return;
        }
        var parsedUrl = Promo.parseUrl(href);
        var host = (parsedUrl.hostname || '').replace(/^www\./, '');
        return list.indexOf(host) > -1;
    }

    function linkAttributes(response) {
        var url = window.mapiAjaxUrl;

        if (!url) return null;
        if (!window.mapiRewriteExternalLinks) return null;

        var data_layer = window.data_layer;

        var queryString = Promo.parseQueryString();
        $('a').each(function () {
            var $el = $(this);
            var href = $el.attr('href');

            if (!isExternal($el) || blacklisted(href, response.blacklist)) {
                return;
            }

            var qParams = {};
            $.each(response.attributes, function (index, val) {
                var domainRegex = new RegExp(val.uri, "g");
                if (domainRegex.test(href) || val.uri === null) {
                    var key = val.key;
                    var regex = /^{\D*}/g;

                    // Look for tokenized parameter and check data_layer for it's existence.
                    if (regex.test(val.value)) {
                        var trimmed = val.value.substring(1).slice(0, -1);
                        var dataLayerValue = getFromDataLayer(trimmed, data_layer);

                        if (typeof(dataLayerValue) === "undefined" || dataLayerValue === "") {

                            // We need to wait for possible ajax requests to finish.
                            doWhen( function() {
                                var fromDl = getFromDataLayer(trimmed, data_layer);
                                return fromDl !== "" && fromDl !== "undefined";
                            }, function() {
                                var dataLayerVal = getFromDataLayer(trimmed);
                                qParams[key] = dataLayerVal;
                                queryString[key] = dataLayerVal;
                                $el.attr('href', Promo.replaceQueryParameters(href, qParams));
                            });

                        } else {
                            qParams[key] = dataLayerValue;
                            queryString[key] = dataLayerValue;
                        }
                    } else if(!val.persist) {
                        qParams[key] = val.value;
                    } else if(key === 'kbid') {
                        qParams[key] = window.mapiPromo;
                    } else {
                        qParams[key] = key in queryString
                            ? queryString[key]
                            : val.value;
                    }
                }
            });

            var replaced = Promo.replaceQueryParameters(href, qParams);
            $el.attr('href', replaced);
        });

        return true;
    }

    function isExternal($link) {
        if(!$link) return false;

        var internal = window.location.hostname;
        var hostname = $link.prop('hostname');

        return internal !== hostname;
    }

    // Depending on the script include order, jQuery may not be present. Plus, using the
    // dependencies available in wp_enqueue_script doesn't always work, since crazy people
    // like to delete / rename the default jquery script. So, hang out and poll til it's present.
    var checkId = setInterval(function () {
        if (!window.jQuery) return;

        $ = window.jQuery;
        clearInterval(checkId);

        $(function () {
            mapiEvents.on('mapi_heartbeat', function () {
                initLinkAttributes();
            });

            var performedRequest = performTokenRequest();

            // If we made a request, that counts as bootstrapping / pinging the session.
            if (performedRequest) return;

            // Otherwise, we need a heartbeat.
            performHeartbeatRequest();
        });
    }, 250);

    /**
     * Call cb for each element of the collection.
     *
     * @param col Can be an object, or anything array-like (can get by index, has 'length' param),
     * @param cb function Signature cb(value, key, col)
     * @param ctx {*} Context to call cb in (that is, the 'this' parameter). In case you don't wanna use 'bind'.
     */
    function each(col, cb, ctx) {
        if (!col) return;

        if (col && col.length !== undefined) {
            for (var i = 0; i < col.length; i++) {
                cb.call(ctx, col[i], i, col);
            }
        } else {
            for (var key in col) {
                if (!col.hasOwnProperty(key)) continue;

                cb.call(ctx, col[key], key, col);
            }
        }
    }

    /**
     * Perform the 'action' function when 'predicate' returns a truthy value.
     * @param predicate function
     * @param action function
     * @param interval int Interval to wait between predicate checks.
     * @param maxWait int Maximum amount of time to wait for predicate to be true
     * @param callAfterExpiration bool Call the action after maxWait. true to call, false otherwise
     */
    function doWhen(predicate, action, interval, maxWait, callAfterExpiration) {
        var waited = 0;
        interval = interval || 500;
        callAfterExpiration = typeof callAfterExpiration === 'undefined' ? false : callAfterExpiration;

        // If currently true, just call without a setInterval
        if(predicate.call()) {
            action.call();
            return;
        }

        var intId = setInterval(function() {
            waited += interval;

            if(predicate.call()) {
                clearInterval(intId);
                action.call();
            }

            if(maxWait && waited > maxWait) {
                clearInterval(intId);
                if(callAfterExpiration) action.call();
            }
        }, interval);
    }
    window.WpMapiUtils = {
        performPhoneRotation: performTokenRequest
    }
})();
