/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 19);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports) {

module.exports = jQuery;

/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transitionend = exports.GetYoDigits = exports.rtl = undefined;

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Core Foundation Utilities, utilized in a number of places.

/**
 * Returns a boolean for RTL support
 */
function rtl() {
  return (0, _jquery2.default)('html').attr('dir') === 'rtl';
}

/**
 * returns a random base-36 uid with namespacing
 * @function
 * @param {Number} length - number of random base-36 digits desired. Increase for more random strings.
 * @param {String} namespace - name of plugin to be incorporated in uid, optional.
 * @default {String} '' - if no plugin name is provided, nothing is appended to the uid.
 * @returns {String} - unique id
 */
function GetYoDigits(length, namespace) {
  length = length || 6;
  return Math.round(Math.pow(36, length + 1) - Math.random() * Math.pow(36, length)).toString(36).slice(1) + (namespace ? '-' + namespace : '');
}

function transitionend($elem) {
  var transitions = {
    'transition': 'transitionend',
    'WebkitTransition': 'webkitTransitionEnd',
    'MozTransition': 'transitionend',
    'OTransition': 'otransitionend'
  };
  var elem = document.createElement('div'),
      end;

  for (var t in transitions) {
    if (typeof elem.style[t] !== 'undefined') {
      end = transitions[t];
    }
  }
  if (end) {
    return end;
  } else {
    end = setTimeout(function () {
      $elem.triggerHandler('transitionend', [$elem]);
    }, 1);
    return 'transitionend';
  }
}

exports.rtl = rtl;
exports.GetYoDigits = GetYoDigits;
exports.transitionend = transitionend;

/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Plugin = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _foundationUtil = __webpack_require__(1);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// Abstract class for providing lifecycle hooks. Expect plugins to define AT LEAST
// {function} _setup (replaces previous constructor),
// {function} _destroy (replaces previous destroy)
var Plugin = function () {
  function Plugin(element, options) {
    _classCallCheck(this, Plugin);

    this._setup(element, options);
    var pluginName = getPluginName(this);
    this.uuid = (0, _foundationUtil.GetYoDigits)(6, pluginName);

    if (!this.$element.attr('data-' + pluginName)) {
      this.$element.attr('data-' + pluginName, this.uuid);
    }
    if (!this.$element.data('zfPlugin')) {
      this.$element.data('zfPlugin', this);
    }
    /**
     * Fires when the plugin has initialized.
     * @event Plugin#init
     */
    this.$element.trigger('init.zf.' + pluginName);
  }

  _createClass(Plugin, [{
    key: 'destroy',
    value: function destroy() {
      this._destroy();
      var pluginName = getPluginName(this);
      this.$element.removeAttr('data-' + pluginName).removeData('zfPlugin')
      /**
       * Fires when the plugin has been destroyed.
       * @event Plugin#destroyed
       */
      .trigger('destroyed.zf.' + pluginName);
      for (var prop in this) {
        this[prop] = null; //clean up script to prep for garbage collection.
      }
    }
  }]);

  return Plugin;
}();

// Convert PascalCase to kebab-case
// Thank you: http://stackoverflow.com/a/8955580


function hyphenate(str) {
  return str.replace(/([a-z])([A-Z])/g, '$1-$2').toLowerCase();
}

function getPluginName(obj) {
  if (typeof obj.constructor.name !== 'undefined') {
    return hyphenate(obj.constructor.name);
  } else {
    return hyphenate(obj.className);
  }
}

exports.Plugin = Plugin;

/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MediaQuery = undefined;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Default set of media queries
var defaultQueries = {
  'default': 'only screen',
  landscape: 'only screen and (orientation: landscape)',
  portrait: 'only screen and (orientation: portrait)',
  retina: 'only screen and (-webkit-min-device-pixel-ratio: 2),' + 'only screen and (min--moz-device-pixel-ratio: 2),' + 'only screen and (-o-min-device-pixel-ratio: 2/1),' + 'only screen and (min-device-pixel-ratio: 2),' + 'only screen and (min-resolution: 192dpi),' + 'only screen and (min-resolution: 2dppx)'
};

// matchMedia() polyfill - Test a CSS media type/query in JS.
// Authors & copyright (c) 2012: Scott Jehl, Paul Irish, Nicholas Zakas, David Knight. Dual MIT/BSD license
var matchMedia = window.matchMedia || function () {
  'use strict';

  // For browsers that support matchMedium api such as IE 9 and webkit

  var styleMedia = window.styleMedia || window.media;

  // For those that don't support matchMedium
  if (!styleMedia) {
    var style = document.createElement('style'),
        script = document.getElementsByTagName('script')[0],
        info = null;

    style.type = 'text/css';
    style.id = 'matchmediajs-test';

    script && script.parentNode && script.parentNode.insertBefore(style, script);

    // 'style.currentStyle' is used by IE <= 8 and 'window.getComputedStyle' for all other browsers
    info = 'getComputedStyle' in window && window.getComputedStyle(style, null) || style.currentStyle;

    styleMedia = {
      matchMedium: function matchMedium(media) {
        var text = '@media ' + media + '{ #matchmediajs-test { width: 1px; } }';

        // 'style.styleSheet' is used by IE <= 8 and 'style.textContent' for all other browsers
        if (style.styleSheet) {
          style.styleSheet.cssText = text;
        } else {
          style.textContent = text;
        }

        // Test if media query is true or false
        return info.width === '1px';
      }
    };
  }

  return function (media) {
    return {
      matches: styleMedia.matchMedium(media || 'all'),
      media: media || 'all'
    };
  };
}();

var MediaQuery = {
  queries: [],

  current: '',

  /**
   * Initializes the media query helper, by extracting the breakpoint list from the CSS and activating the breakpoint watcher.
   * @function
   * @private
   */
  _init: function _init() {
    var self = this;
    var $meta = (0, _jquery2.default)('meta.foundation-mq');
    if (!$meta.length) {
      (0, _jquery2.default)('<meta class="foundation-mq">').appendTo(document.head);
    }

    var extractedStyles = (0, _jquery2.default)('.foundation-mq').css('font-family');
    var namedQueries;

    namedQueries = parseStyleToObject(extractedStyles);

    for (var key in namedQueries) {
      if (namedQueries.hasOwnProperty(key)) {
        self.queries.push({
          name: key,
          value: 'only screen and (min-width: ' + namedQueries[key] + ')'
        });
      }
    }

    this.current = this._getCurrentSize();

    this._watcher();
  },


  /**
   * Checks if the screen is at least as wide as a breakpoint.
   * @function
   * @param {String} size - Name of the breakpoint to check.
   * @returns {Boolean} `true` if the breakpoint matches, `false` if it's smaller.
   */
  atLeast: function atLeast(size) {
    var query = this.get(size);

    if (query) {
      return matchMedia(query).matches;
    }

    return false;
  },


  /**
   * Checks if the screen matches to a breakpoint.
   * @function
   * @param {String} size - Name of the breakpoint to check, either 'small only' or 'small'. Omitting 'only' falls back to using atLeast() method.
   * @returns {Boolean} `true` if the breakpoint matches, `false` if it does not.
   */
  is: function is(size) {
    size = size.trim().split(' ');
    if (size.length > 1 && size[1] === 'only') {
      if (size[0] === this._getCurrentSize()) return true;
    } else {
      return this.atLeast(size[0]);
    }
    return false;
  },


  /**
   * Gets the media query of a breakpoint.
   * @function
   * @param {String} size - Name of the breakpoint to get.
   * @returns {String|null} - The media query of the breakpoint, or `null` if the breakpoint doesn't exist.
   */
  get: function get(size) {
    for (var i in this.queries) {
      if (this.queries.hasOwnProperty(i)) {
        var query = this.queries[i];
        if (size === query.name) return query.value;
      }
    }

    return null;
  },


  /**
   * Gets the current breakpoint name by testing every breakpoint and returning the last one to match (the biggest one).
   * @function
   * @private
   * @returns {String} Name of the current breakpoint.
   */
  _getCurrentSize: function _getCurrentSize() {
    var matched;

    for (var i = 0; i < this.queries.length; i++) {
      var query = this.queries[i];

      if (matchMedia(query.value).matches) {
        matched = query;
      }
    }

    if ((typeof matched === 'undefined' ? 'undefined' : _typeof(matched)) === 'object') {
      return matched.name;
    } else {
      return matched;
    }
  },


  /**
   * Activates the breakpoint watcher, which fires an event on the window whenever the breakpoint changes.
   * @function
   * @private
   */
  _watcher: function _watcher() {
    var _this = this;

    (0, _jquery2.default)(window).off('resize.zf.mediaquery').on('resize.zf.mediaquery', function () {
      var newSize = _this._getCurrentSize(),
          currentSize = _this.current;

      if (newSize !== currentSize) {
        // Change the current media query
        _this.current = newSize;

        // Broadcast the media query change on the window
        (0, _jquery2.default)(window).trigger('changed.zf.mediaquery', [newSize, currentSize]);
      }
    });
  }
};

// Thank you: https://github.com/sindresorhus/query-string
function parseStyleToObject(str) {
  var styleObject = {};

  if (typeof str !== 'string') {
    return styleObject;
  }

  str = str.trim().slice(1, -1); // browsers re-quote string style values

  if (!str) {
    return styleObject;
  }

  styleObject = str.split('&').reduce(function (ret, param) {
    var parts = param.replace(/\+/g, ' ').split('=');
    var key = parts[0];
    var val = parts[1];
    key = decodeURIComponent(key);

    // missing `=` should be `null`:
    // http://w3.org/TR/2012/WD-url-20120524/#collect-url-parameters
    val = val === undefined ? null : decodeURIComponent(val);

    if (!ret.hasOwnProperty(key)) {
      ret[key] = val;
    } else if (Array.isArray(ret[key])) {
      ret[key].push(val);
    } else {
      ret[key] = [ret[key], val];
    }
    return ret;
  }, {});

  return styleObject;
}

exports.MediaQuery = MediaQuery;

/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/*******************************************
 *                                         *
 * This util was created by Marius Olbertz *
 * Please thank Marius on GitHub /owlbertz *
 * or the web http://www.mariusolbertz.de/ *
 *                                         *
 ******************************************/



Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Keyboard = undefined;

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _foundationUtil = __webpack_require__(1);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var keyCodes = {
  9: 'TAB',
  13: 'ENTER',
  27: 'ESCAPE',
  32: 'SPACE',
  35: 'END',
  36: 'HOME',
  37: 'ARROW_LEFT',
  38: 'ARROW_UP',
  39: 'ARROW_RIGHT',
  40: 'ARROW_DOWN'
};

var commands = {};

// Functions pulled out to be referenceable from internals
function findFocusable($element) {
  if (!$element) {
    return false;
  }
  return $element.find('a[href], area[href], input:not([disabled]), select:not([disabled]), textarea:not([disabled]), button:not([disabled]), iframe, object, embed, *[tabindex], *[contenteditable]').filter(function () {
    if (!(0, _jquery2.default)(this).is(':visible') || (0, _jquery2.default)(this).attr('tabindex') < 0) {
      return false;
    } //only have visible elements and those that have a tabindex greater or equal 0
    return true;
  });
}

function parseKey(event) {
  var key = keyCodes[event.which || event.keyCode] || String.fromCharCode(event.which).toUpperCase();

  // Remove un-printable characters, e.g. for `fromCharCode` calls for CTRL only events
  key = key.replace(/\W+/, '');

  if (event.shiftKey) key = 'SHIFT_' + key;
  if (event.ctrlKey) key = 'CTRL_' + key;
  if (event.altKey) key = 'ALT_' + key;

  // Remove trailing underscore, in case only modifiers were used (e.g. only `CTRL_ALT`)
  key = key.replace(/_$/, '');

  return key;
}

var Keyboard = {
  keys: getKeyCodes(keyCodes),

  /**
   * Parses the (keyboard) event and returns a String that represents its key
   * Can be used like Foundation.parseKey(event) === Foundation.keys.SPACE
   * @param {Event} event - the event generated by the event handler
   * @return String key - String that represents the key pressed
   */
  parseKey: parseKey,

  /**
   * Handles the given (keyboard) event
   * @param {Event} event - the event generated by the event handler
   * @param {String} component - Foundation component's name, e.g. Slider or Reveal
   * @param {Objects} functions - collection of functions that are to be executed
   */
  handleKey: function handleKey(event, component, functions) {
    var commandList = commands[component],
        keyCode = this.parseKey(event),
        cmds,
        command,
        fn;

    if (!commandList) return console.warn('Component not defined!');

    if (typeof commandList.ltr === 'undefined') {
      // this component does not differentiate between ltr and rtl
      cmds = commandList; // use plain list
    } else {
      // merge ltr and rtl: if document is rtl, rtl overwrites ltr and vice versa
      if ((0, _foundationUtil.rtl)()) cmds = _jquery2.default.extend({}, commandList.ltr, commandList.rtl);else cmds = _jquery2.default.extend({}, commandList.rtl, commandList.ltr);
    }
    command = cmds[keyCode];

    fn = functions[command];
    if (fn && typeof fn === 'function') {
      // execute function  if exists
      var returnValue = fn.apply();
      if (functions.handled || typeof functions.handled === 'function') {
        // execute function when event was handled
        functions.handled(returnValue);
      }
    } else {
      if (functions.unhandled || typeof functions.unhandled === 'function') {
        // execute function when event was not handled
        functions.unhandled();
      }
    }
  },


  /**
   * Finds all focusable elements within the given `$element`
   * @param {jQuery} $element - jQuery object to search within
   * @return {jQuery} $focusable - all focusable elements within `$element`
   */

  findFocusable: findFocusable,

  /**
   * Returns the component name name
   * @param {Object} component - Foundation component, e.g. Slider or Reveal
   * @return String componentName
   */

  register: function register(componentName, cmds) {
    commands[componentName] = cmds;
  },


  // TODO9438: These references to Keyboard need to not require global. Will 'this' work in this context?
  //
  /**
   * Traps the focus in the given element.
   * @param  {jQuery} $element  jQuery object to trap the foucs into.
   */
  trapFocus: function trapFocus($element) {
    var $focusable = findFocusable($element),
        $firstFocusable = $focusable.eq(0),
        $lastFocusable = $focusable.eq(-1);

    $element.on('keydown.zf.trapfocus', function (event) {
      if (event.target === $lastFocusable[0] && parseKey(event) === 'TAB') {
        event.preventDefault();
        $firstFocusable.focus();
      } else if (event.target === $firstFocusable[0] && parseKey(event) === 'SHIFT_TAB') {
        event.preventDefault();
        $lastFocusable.focus();
      }
    });
  },

  /**
   * Releases the trapped focus from the given element.
   * @param  {jQuery} $element  jQuery object to release the focus for.
   */
  releaseFocus: function releaseFocus($element) {
    $element.off('keydown.zf.trapfocus');
  }
};

/*
 * Constants for easier comparing.
 * Can be used like Foundation.parseKey(event) === Foundation.keys.SPACE
 */
function getKeyCodes(kcs) {
  var k = {};
  for (var kc in kcs) {
    k[kcs[kc]] = kcs[kc];
  }return k;
}

exports.Keyboard = Keyboard;

/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Triggers = undefined;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _foundationUtil = __webpack_require__(6);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var MutationObserver = function () {
  var prefixes = ['WebKit', 'Moz', 'O', 'Ms', ''];
  for (var i = 0; i < prefixes.length; i++) {
    if (prefixes[i] + 'MutationObserver' in window) {
      return window[prefixes[i] + 'MutationObserver'];
    }
  }
  return false;
}();

var triggers = function triggers(el, type) {
  el.data(type).split(' ').forEach(function (id) {
    (0, _jquery2.default)('#' + id)[type === 'close' ? 'trigger' : 'triggerHandler'](type + '.zf.trigger', [el]);
  });
};

var Triggers = {
  Listeners: {
    Basic: {},
    Global: {}
  },
  Initializers: {}
};

Triggers.Listeners.Basic = {
  openListener: function openListener() {
    triggers((0, _jquery2.default)(this), 'open');
  },
  closeListener: function closeListener() {
    var id = (0, _jquery2.default)(this).data('close');
    if (id) {
      triggers((0, _jquery2.default)(this), 'close');
    } else {
      (0, _jquery2.default)(this).trigger('close.zf.trigger');
    }
  },
  toggleListener: function toggleListener() {
    var id = (0, _jquery2.default)(this).data('toggle');
    if (id) {
      triggers((0, _jquery2.default)(this), 'toggle');
    } else {
      (0, _jquery2.default)(this).trigger('toggle.zf.trigger');
    }
  },
  closeableListener: function closeableListener(e) {
    e.stopPropagation();
    var animation = (0, _jquery2.default)(this).data('closable');

    if (animation !== '') {
      _foundationUtil.Motion.animateOut((0, _jquery2.default)(this), animation, function () {
        (0, _jquery2.default)(this).trigger('closed.zf');
      });
    } else {
      (0, _jquery2.default)(this).fadeOut().trigger('closed.zf');
    }
  },
  toggleFocusListener: function toggleFocusListener() {
    var id = (0, _jquery2.default)(this).data('toggle-focus');
    (0, _jquery2.default)('#' + id).triggerHandler('toggle.zf.trigger', [(0, _jquery2.default)(this)]);
  }
};

// Elements with [data-open] will reveal a plugin that supports it when clicked.
Triggers.Initializers.addOpenListener = function ($elem) {
  $elem.off('click.zf.trigger', Triggers.Listeners.Basic.openListener);
  $elem.on('click.zf.trigger', '[data-open]', Triggers.Listeners.Basic.openListener);
};

// Elements with [data-close] will close a plugin that supports it when clicked.
// If used without a value on [data-close], the event will bubble, allowing it to close a parent component.
Triggers.Initializers.addCloseListener = function ($elem) {
  $elem.off('click.zf.trigger', Triggers.Listeners.Basic.closeListener);
  $elem.on('click.zf.trigger', '[data-close]', Triggers.Listeners.Basic.closeListener);
};

// Elements with [data-toggle] will toggle a plugin that supports it when clicked.
Triggers.Initializers.addToggleListener = function ($elem) {
  $elem.off('click.zf.trigger', Triggers.Listeners.Basic.toggleListener);
  $elem.on('click.zf.trigger', '[data-toggle]', Triggers.Listeners.Basic.toggleListener);
};

// Elements with [data-closable] will respond to close.zf.trigger events.
Triggers.Initializers.addCloseableListener = function ($elem) {
  $elem.off('close.zf.trigger', Triggers.Listeners.Basic.closeableListener);
  $elem.on('close.zf.trigger', '[data-closeable], [data-closable]', Triggers.Listeners.Basic.closeableListener);
};

// Elements with [data-toggle-focus] will respond to coming in and out of focus
Triggers.Initializers.addToggleFocusListener = function ($elem) {
  $elem.off('focus.zf.trigger blur.zf.trigger', Triggers.Listeners.Basic.toggleFocusListener);
  $elem.on('focus.zf.trigger blur.zf.trigger', '[data-toggle-focus]', Triggers.Listeners.Basic.toggleFocusListener);
};

// More Global/complex listeners and triggers
Triggers.Listeners.Global = {
  resizeListener: function resizeListener($nodes) {
    if (!MutationObserver) {
      //fallback for IE 9
      $nodes.each(function () {
        (0, _jquery2.default)(this).triggerHandler('resizeme.zf.trigger');
      });
    }
    //trigger all listening elements and signal a resize event
    $nodes.attr('data-events', "resize");
  },
  scrollListener: function scrollListener($nodes) {
    if (!MutationObserver) {
      //fallback for IE 9
      $nodes.each(function () {
        (0, _jquery2.default)(this).triggerHandler('scrollme.zf.trigger');
      });
    }
    //trigger all listening elements and signal a scroll event
    $nodes.attr('data-events', "scroll");
  },
  closeMeListener: function closeMeListener(e, pluginId) {
    var plugin = e.namespace.split('.')[0];
    var plugins = (0, _jquery2.default)('[data-' + plugin + ']').not('[data-yeti-box="' + pluginId + '"]');

    plugins.each(function () {
      var _this = (0, _jquery2.default)(this);
      _this.triggerHandler('close.zf.trigger', [_this]);
    });
  }

  // Global, parses whole document.
};Triggers.Initializers.addClosemeListener = function (pluginName) {
  var yetiBoxes = (0, _jquery2.default)('[data-yeti-box]'),
      plugNames = ['dropdown', 'tooltip', 'reveal'];

  if (pluginName) {
    if (typeof pluginName === 'string') {
      plugNames.push(pluginName);
    } else if ((typeof pluginName === 'undefined' ? 'undefined' : _typeof(pluginName)) === 'object' && typeof pluginName[0] === 'string') {
      plugNames.concat(pluginName);
    } else {
      console.error('Plugin names must be strings');
    }
  }
  if (yetiBoxes.length) {
    var listeners = plugNames.map(function (name) {
      return 'closeme.zf.' + name;
    }).join(' ');

    (0, _jquery2.default)(window).off(listeners).on(listeners, Triggers.Listeners.Global.closeMeListener);
  }
};

function debounceGlobalListener(debounce, trigger, listener) {
  var timer = void 0,
      args = Array.prototype.slice.call(arguments, 3);
  (0, _jquery2.default)(window).off(trigger).on(trigger, function (e) {
    if (timer) {
      clearTimeout(timer);
    }
    timer = setTimeout(function () {
      listener.apply(null, args);
    }, debounce || 10); //default time to emit scroll event
  });
}

Triggers.Initializers.addResizeListener = function (debounce) {
  var $nodes = (0, _jquery2.default)('[data-resize]');
  if ($nodes.length) {
    debounceGlobalListener(debounce, 'resize.zf.trigger', Triggers.Listeners.Global.resizeListener, $nodes);
  }
};

Triggers.Initializers.addScrollListener = function (debounce) {
  var $nodes = (0, _jquery2.default)('[data-scroll]');
  if ($nodes.length) {
    debounceGlobalListener(debounce, 'scroll.zf.trigger', Triggers.Listeners.Global.scrollListener, $nodes);
  }
};

Triggers.Initializers.addMutationEventsListener = function ($elem) {
  if (!MutationObserver) {
    return false;
  }
  var $nodes = $elem.find('[data-resize], [data-scroll], [data-mutate]');

  //element callback
  var listeningElementsMutation = function listeningElementsMutation(mutationRecordsList) {
    var $target = (0, _jquery2.default)(mutationRecordsList[0].target);

    //trigger the event handler for the element depending on type
    switch (mutationRecordsList[0].type) {
      case "attributes":
        if ($target.attr("data-events") === "scroll" && mutationRecordsList[0].attributeName === "data-events") {
          $target.triggerHandler('scrollme.zf.trigger', [$target, window.pageYOffset]);
        }
        if ($target.attr("data-events") === "resize" && mutationRecordsList[0].attributeName === "data-events") {
          $target.triggerHandler('resizeme.zf.trigger', [$target]);
        }
        if (mutationRecordsList[0].attributeName === "style") {
          $target.closest("[data-mutate]").attr("data-events", "mutate");
          $target.closest("[data-mutate]").triggerHandler('mutateme.zf.trigger', [$target.closest("[data-mutate]")]);
        }
        break;

      case "childList":
        $target.closest("[data-mutate]").attr("data-events", "mutate");
        $target.closest("[data-mutate]").triggerHandler('mutateme.zf.trigger', [$target.closest("[data-mutate]")]);
        break;

      default:
        return false;
      //nothing
    }
  };

  if ($nodes.length) {
    //for each element that needs to listen for resizing, scrolling, or mutation add a single observer
    for (var i = 0; i <= $nodes.length - 1; i++) {
      var elementObserver = new MutationObserver(listeningElementsMutation);
      elementObserver.observe($nodes[i], { attributes: true, childList: true, characterData: false, subtree: true, attributeFilter: ["data-events", "style"] });
    }
  }
};

Triggers.Initializers.addSimpleListeners = function () {
  var $document = (0, _jquery2.default)(document);

  Triggers.Initializers.addOpenListener($document);
  Triggers.Initializers.addCloseListener($document);
  Triggers.Initializers.addToggleListener($document);
  Triggers.Initializers.addCloseableListener($document);
  Triggers.Initializers.addToggleFocusListener($document);
};

Triggers.Initializers.addGlobalListeners = function () {
  var $document = (0, _jquery2.default)(document);
  Triggers.Initializers.addMutationEventsListener($document);
  Triggers.Initializers.addResizeListener();
  Triggers.Initializers.addScrollListener();
  Triggers.Initializers.addClosemeListener();
};

Triggers.init = function ($, Foundation) {
  if (typeof $.triggersInitialized === 'undefined') {
    var $document = $(document);

    if (document.readyState === "complete") {
      Triggers.Initializers.addSimpleListeners();
      Triggers.Initializers.addGlobalListeners();
    } else {
      $(window).on('load', function () {
        Triggers.Initializers.addSimpleListeners();
        Triggers.Initializers.addGlobalListeners();
      });
    }

    $.triggersInitialized = true;
  }

  if (Foundation) {
    Foundation.Triggers = Triggers;
    // Legacy included to be backwards compatible for now.
    Foundation.IHearYou = Triggers.Initializers.addGlobalListeners;
  }
};

exports.Triggers = Triggers;

/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Motion = exports.Move = undefined;

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _foundationUtil = __webpack_require__(1);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Motion module.
 * @module foundation.motion
 */

var initClasses = ['mui-enter', 'mui-leave'];
var activeClasses = ['mui-enter-active', 'mui-leave-active'];

var Motion = {
  animateIn: function animateIn(element, animation, cb) {
    animate(true, element, animation, cb);
  },

  animateOut: function animateOut(element, animation, cb) {
    animate(false, element, animation, cb);
  }
};

function Move(duration, elem, fn) {
  var anim,
      prog,
      start = null;
  // console.log('called');

  if (duration === 0) {
    fn.apply(elem);
    elem.trigger('finished.zf.animate', [elem]).triggerHandler('finished.zf.animate', [elem]);
    return;
  }

  function move(ts) {
    if (!start) start = ts;
    // console.log(start, ts);
    prog = ts - start;
    fn.apply(elem);

    if (prog < duration) {
      anim = window.requestAnimationFrame(move, elem);
    } else {
      window.cancelAnimationFrame(anim);
      elem.trigger('finished.zf.animate', [elem]).triggerHandler('finished.zf.animate', [elem]);
    }
  }
  anim = window.requestAnimationFrame(move);
}

/**
 * Animates an element in or out using a CSS transition class.
 * @function
 * @private
 * @param {Boolean} isIn - Defines if the animation is in or out.
 * @param {Object} element - jQuery or HTML object to animate.
 * @param {String} animation - CSS class to use.
 * @param {Function} cb - Callback to run when animation is finished.
 */
function animate(isIn, element, animation, cb) {
  element = (0, _jquery2.default)(element).eq(0);

  if (!element.length) return;

  var initClass = isIn ? initClasses[0] : initClasses[1];
  var activeClass = isIn ? activeClasses[0] : activeClasses[1];

  // Set up the animation
  reset();

  element.addClass(animation).css('transition', 'none');

  requestAnimationFrame(function () {
    element.addClass(initClass);
    if (isIn) element.show();
  });

  // Start the animation
  requestAnimationFrame(function () {
    element[0].offsetWidth;
    element.css('transition', '').addClass(activeClass);
  });

  // Clean up the animation when it finishes
  element.one((0, _foundationUtil.transitionend)(element), finish);

  // Hides the element (for out animations), resets the element, and runs a callback
  function finish() {
    if (!isIn) element.hide();
    reset();
    if (cb) cb.apply(element);
  }

  // Resets transitions and removes motion-specific classes
  function reset() {
    element[0].style.transitionDuration = 0;
    element.removeClass(initClass + ' ' + activeClass + ' ' + animation);
  }
}

exports.Move = Move;
exports.Motion = Motion;

/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Box = undefined;

var _foundationUtil = __webpack_require__(1);

var Box = {
  ImNotTouchingYou: ImNotTouchingYou,
  OverlapArea: OverlapArea,
  GetDimensions: GetDimensions,
  GetOffsets: GetOffsets,
  GetExplicitOffsets: GetExplicitOffsets

  /**
   * Compares the dimensions of an element to a container and determines collision events with container.
   * @function
   * @param {jQuery} element - jQuery object to test for collisions.
   * @param {jQuery} parent - jQuery object to use as bounding container.
   * @param {Boolean} lrOnly - set to true to check left and right values only.
   * @param {Boolean} tbOnly - set to true to check top and bottom values only.
   * @default if no parent object passed, detects collisions with `window`.
   * @returns {Boolean} - true if collision free, false if a collision in any direction.
   */
};function ImNotTouchingYou(element, parent, lrOnly, tbOnly, ignoreBottom) {
  return OverlapArea(element, parent, lrOnly, tbOnly, ignoreBottom) === 0;
};

function OverlapArea(element, parent, lrOnly, tbOnly, ignoreBottom) {
  var eleDims = GetDimensions(element),
      topOver,
      bottomOver,
      leftOver,
      rightOver;
  if (parent) {
    var parDims = GetDimensions(parent);

    bottomOver = parDims.height + parDims.offset.top - (eleDims.offset.top + eleDims.height);
    topOver = eleDims.offset.top - parDims.offset.top;
    leftOver = eleDims.offset.left - parDims.offset.left;
    rightOver = parDims.width + parDims.offset.left - (eleDims.offset.left + eleDims.width);
  } else {
    bottomOver = eleDims.windowDims.height + eleDims.windowDims.offset.top - (eleDims.offset.top + eleDims.height);
    topOver = eleDims.offset.top - eleDims.windowDims.offset.top;
    leftOver = eleDims.offset.left - eleDims.windowDims.offset.left;
    rightOver = eleDims.windowDims.width - (eleDims.offset.left + eleDims.width);
  }

  bottomOver = ignoreBottom ? 0 : Math.min(bottomOver, 0);
  topOver = Math.min(topOver, 0);
  leftOver = Math.min(leftOver, 0);
  rightOver = Math.min(rightOver, 0);

  if (lrOnly) {
    return leftOver + rightOver;
  }
  if (tbOnly) {
    return topOver + bottomOver;
  }

  // use sum of squares b/c we care about overlap area.
  return Math.sqrt(topOver * topOver + bottomOver * bottomOver + leftOver * leftOver + rightOver * rightOver);
}

/**
 * Uses native methods to return an object of dimension values.
 * @function
 * @param {jQuery || HTML} element - jQuery object or DOM element for which to get the dimensions. Can be any element other that document or window.
 * @returns {Object} - nested object of integer pixel values
 * TODO - if element is window, return only those values.
 */
function GetDimensions(elem) {
  elem = elem.length ? elem[0] : elem;

  if (elem === window || elem === document) {
    throw new Error("I'm sorry, Dave. I'm afraid I can't do that.");
  }

  var rect = elem.getBoundingClientRect(),
      parRect = elem.parentNode.getBoundingClientRect(),
      winRect = document.body.getBoundingClientRect(),
      winY = window.pageYOffset,
      winX = window.pageXOffset;

  return {
    width: rect.width,
    height: rect.height,
    offset: {
      top: rect.top + winY,
      left: rect.left + winX
    },
    parentDims: {
      width: parRect.width,
      height: parRect.height,
      offset: {
        top: parRect.top + winY,
        left: parRect.left + winX
      }
    },
    windowDims: {
      width: winRect.width,
      height: winRect.height,
      offset: {
        top: winY,
        left: winX
      }
    }
  };
}

/**
 * Returns an object of top and left integer pixel values for dynamically rendered elements,
 * such as: Tooltip, Reveal, and Dropdown. Maintained for backwards compatibility, and where
 * you don't know alignment, but generally from
 * 6.4 forward you should use GetExplicitOffsets, as GetOffsets conflates position and alignment.
 * @function
 * @param {jQuery} element - jQuery object for the element being positioned.
 * @param {jQuery} anchor - jQuery object for the element's anchor point.
 * @param {String} position - a string relating to the desired position of the element, relative to it's anchor
 * @param {Number} vOffset - integer pixel value of desired vertical separation between anchor and element.
 * @param {Number} hOffset - integer pixel value of desired horizontal separation between anchor and element.
 * @param {Boolean} isOverflow - if a collision event is detected, sets to true to default the element to full width - any desired offset.
 * TODO alter/rewrite to work with `em` values as well/instead of pixels
 */
function GetOffsets(element, anchor, position, vOffset, hOffset, isOverflow) {
  console.log("NOTE: GetOffsets is deprecated in favor of GetExplicitOffsets and will be removed in 6.5");
  switch (position) {
    case 'top':
      return (0, _foundationUtil.rtl)() ? GetExplicitOffsets(element, anchor, 'top', 'left', vOffset, hOffset, isOverflow) : GetExplicitOffsets(element, anchor, 'top', 'right', vOffset, hOffset, isOverflow);
    case 'bottom':
      return (0, _foundationUtil.rtl)() ? GetExplicitOffsets(element, anchor, 'bottom', 'left', vOffset, hOffset, isOverflow) : GetExplicitOffsets(element, anchor, 'bottom', 'right', vOffset, hOffset, isOverflow);
    case 'center top':
      return GetExplicitOffsets(element, anchor, 'top', 'center', vOffset, hOffset, isOverflow);
    case 'center bottom':
      return GetExplicitOffsets(element, anchor, 'bottom', 'center', vOffset, hOffset, isOverflow);
    case 'center left':
      return GetExplicitOffsets(element, anchor, 'left', 'center', vOffset, hOffset, isOverflow);
    case 'center right':
      return GetExplicitOffsets(element, anchor, 'right', 'center', vOffset, hOffset, isOverflow);
    case 'left bottom':
      return GetExplicitOffsets(element, anchor, 'bottom', 'left', vOffset, hOffset, isOverflow);
    case 'right bottom':
      return GetExplicitOffsets(element, anchor, 'bottom', 'right', vOffset, hOffset, isOverflow);
    // Backwards compatibility... this along with the reveal and reveal full
    // classes are the only ones that didn't reference anchor
    case 'center':
      return {
        left: $eleDims.windowDims.offset.left + $eleDims.windowDims.width / 2 - $eleDims.width / 2 + hOffset,
        top: $eleDims.windowDims.offset.top + $eleDims.windowDims.height / 2 - ($eleDims.height / 2 + vOffset)
      };
    case 'reveal':
      return {
        left: ($eleDims.windowDims.width - $eleDims.width) / 2 + hOffset,
        top: $eleDims.windowDims.offset.top + vOffset
      };
    case 'reveal full':
      return {
        left: $eleDims.windowDims.offset.left,
        top: $eleDims.windowDims.offset.top
      };
      break;
    default:
      return {
        left: (0, _foundationUtil.rtl)() ? $anchorDims.offset.left - $eleDims.width + $anchorDims.width - hOffset : $anchorDims.offset.left + hOffset,
        top: $anchorDims.offset.top + $anchorDims.height + vOffset
      };

  }
}

function GetExplicitOffsets(element, anchor, position, alignment, vOffset, hOffset, isOverflow) {
  var $eleDims = GetDimensions(element),
      $anchorDims = anchor ? GetDimensions(anchor) : null;

  var topVal, leftVal;

  // set position related attribute

  switch (position) {
    case 'top':
      topVal = $anchorDims.offset.top - ($eleDims.height + vOffset);
      break;
    case 'bottom':
      topVal = $anchorDims.offset.top + $anchorDims.height + vOffset;
      break;
    case 'left':
      leftVal = $anchorDims.offset.left - ($eleDims.width + hOffset);
      break;
    case 'right':
      leftVal = $anchorDims.offset.left + $anchorDims.width + hOffset;
      break;
  }

  // set alignment related attribute
  switch (position) {
    case 'top':
    case 'bottom':
      switch (alignment) {
        case 'left':
          leftVal = $anchorDims.offset.left + hOffset;
          break;
        case 'right':
          leftVal = $anchorDims.offset.left - $eleDims.width + $anchorDims.width - hOffset;
          break;
        case 'center':
          leftVal = isOverflow ? hOffset : $anchorDims.offset.left + $anchorDims.width / 2 - $eleDims.width / 2 + hOffset;
          break;
      }
      break;
    case 'right':
    case 'left':
      switch (alignment) {
        case 'bottom':
          topVal = $anchorDims.offset.top - vOffset + $anchorDims.height - $eleDims.height;
          break;
        case 'top':
          topVal = $anchorDims.offset.top + vOffset;
          break;
        case 'center':
          topVal = $anchorDims.offset.top + vOffset + $anchorDims.height / 2 - $eleDims.height / 2;
          break;
      }
      break;
  }
  return { top: topVal, left: leftVal };
}

exports.Box = Box;

/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.onImagesLoaded = undefined;

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Runs a callback function when images are fully loaded.
 * @param {Object} images - Image(s) to check if loaded.
 * @param {Func} callback - Function to execute when image is fully loaded.
 */
function onImagesLoaded(images, callback) {
  var self = this,
      unloaded = images.length;

  if (unloaded === 0) {
    callback();
  }

  images.each(function () {
    // Check if image is loaded
    if (this.complete && this.naturalWidth !== undefined) {
      singleImageLoaded();
    } else {
      // If the above check failed, simulate loading on detached element.
      var image = new Image();
      // Still count image as loaded if it finalizes with an error.
      var events = "load.zf.images error.zf.images";
      (0, _jquery2.default)(image).one(events, function me(event) {
        // Unbind the event listeners. We're using 'one' but only one of the two events will have fired.
        (0, _jquery2.default)(this).off(events, me);
        singleImageLoaded();
      });
      image.src = (0, _jquery2.default)(this).attr('src');
    }
  });

  function singleImageLoaded() {
    unloaded--;
    if (unloaded === 0) {
      callback();
    }
  }
}

exports.onImagesLoaded = onImagesLoaded;

/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Nest = undefined;

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var Nest = {
  Feather: function Feather(menu) {
    var type = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'zf';

    menu.attr('role', 'menubar');

    var items = menu.find('li').attr({ 'role': 'menuitem' }),
        subMenuClass = 'is-' + type + '-submenu',
        subItemClass = subMenuClass + '-item',
        hasSubClass = 'is-' + type + '-submenu-parent',
        applyAria = type !== 'accordion'; // Accordions handle their own ARIA attriutes.

    items.each(function () {
      var $item = (0, _jquery2.default)(this),
          $sub = $item.children('ul');

      if ($sub.length) {
        $item.addClass(hasSubClass);
        $sub.addClass('submenu ' + subMenuClass).attr({ 'data-submenu': '' });
        if (applyAria) {
          $item.attr({
            'aria-haspopup': true,
            'aria-label': $item.children('a:first').text()
          });
          // Note:  Drilldowns behave differently in how they hide, and so need
          // additional attributes.  We should look if this possibly over-generalized
          // utility (Nest) is appropriate when we rework menus in 6.4
          if (type === 'drilldown') {
            $item.attr({ 'aria-expanded': false });
          }
        }
        $sub.addClass('submenu ' + subMenuClass).attr({
          'data-submenu': '',
          'role': 'menu'
        });
        if (type === 'drilldown') {
          $sub.attr({ 'aria-hidden': true });
        }
      }

      if ($item.parent('[data-submenu]').length) {
        $item.addClass('is-submenu-item ' + subItemClass);
      }
    });

    return;
  },
  Burn: function Burn(menu, type) {
    var //items = menu.find('li'),
    subMenuClass = 'is-' + type + '-submenu',
        subItemClass = subMenuClass + '-item',
        hasSubClass = 'is-' + type + '-submenu-parent';

    menu.find('>li, .menu, .menu > li').removeClass(subMenuClass + ' ' + subItemClass + ' ' + hasSubClass + ' is-submenu-item submenu is-active').removeAttr('data-submenu').css('display', '');
  }
};

exports.Nest = Nest;

/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Touch = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); //**************************************************
//**Work inspired by multiple jquery swipe plugins**
//**Done by Yohai Ararat ***************************
//**************************************************

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Touch = {};

var startPosX,
    startPosY,
    startTime,
    elapsedTime,
    isMoving = false;

function onTouchEnd() {
  //  alert(this);
  this.removeEventListener('touchmove', onTouchMove);
  this.removeEventListener('touchend', onTouchEnd);
  isMoving = false;
}

function onTouchMove(e) {
  if (_jquery2.default.spotSwipe.preventDefault) {
    e.preventDefault();
  }
  if (isMoving) {
    var x = e.touches[0].pageX;
    var y = e.touches[0].pageY;
    var dx = startPosX - x;
    var dy = startPosY - y;
    var dir;
    elapsedTime = new Date().getTime() - startTime;
    if (Math.abs(dx) >= _jquery2.default.spotSwipe.moveThreshold && elapsedTime <= _jquery2.default.spotSwipe.timeThreshold) {
      dir = dx > 0 ? 'left' : 'right';
    }
    // else if(Math.abs(dy) >= $.spotSwipe.moveThreshold && elapsedTime <= $.spotSwipe.timeThreshold) {
    //   dir = dy > 0 ? 'down' : 'up';
    // }
    if (dir) {
      e.preventDefault();
      onTouchEnd.call(this);
      (0, _jquery2.default)(this).trigger('swipe', dir).trigger('swipe' + dir);
    }
  }
}

function onTouchStart(e) {
  if (e.touches.length == 1) {
    startPosX = e.touches[0].pageX;
    startPosY = e.touches[0].pageY;
    isMoving = true;
    startTime = new Date().getTime();
    this.addEventListener('touchmove', onTouchMove, false);
    this.addEventListener('touchend', onTouchEnd, false);
  }
}

function init() {
  this.addEventListener && this.addEventListener('touchstart', onTouchStart, false);
}

function teardown() {
  this.removeEventListener('touchstart', onTouchStart);
}

var SpotSwipe = function () {
  function SpotSwipe($) {
    _classCallCheck(this, SpotSwipe);

    this.version = '1.0.0';
    this.enabled = 'ontouchstart' in document.documentElement;
    this.preventDefault = false;
    this.moveThreshold = 75;
    this.timeThreshold = 200;
    this.$ = $;
    this._init();
  }

  _createClass(SpotSwipe, [{
    key: '_init',
    value: function _init() {
      var $ = this.$;
      $.event.special.swipe = { setup: init };

      $.each(['left', 'up', 'down', 'right'], function () {
        $.event.special['swipe' + this] = { setup: function setup() {
            $(this).on('swipe', $.noop);
          } };
      });
    }
  }]);

  return SpotSwipe;
}();

/****************************************************
 * As far as I can tell, both setupSpotSwipe and    *
 * setupTouchHandler should be idempotent,          *
 * because they directly replace functions &        *
 * values, and do not add event handlers directly.  *
 ****************************************************/

Touch.setupSpotSwipe = function ($) {
  $.spotSwipe = new SpotSwipe($);
};

/****************************************************
 * Method for adding pseudo drag events to elements *
 ***************************************************/
Touch.setupTouchHandler = function ($) {
  $.fn.addTouch = function () {
    this.each(function (i, el) {
      $(el).bind('touchstart touchmove touchend touchcancel', function () {
        //we pass the original event object because the jQuery event
        //object is normalized to w3c specs and does not provide the TouchList
        handleTouch(event);
      });
    });

    var handleTouch = function handleTouch(event) {
      var touches = event.changedTouches,
          first = touches[0],
          eventTypes = {
        touchstart: 'mousedown',
        touchmove: 'mousemove',
        touchend: 'mouseup'
      },
          type = eventTypes[event.type],
          simulatedEvent;

      if ('MouseEvent' in window && typeof window.MouseEvent === 'function') {
        simulatedEvent = new window.MouseEvent(type, {
          'bubbles': true,
          'cancelable': true,
          'screenX': first.screenX,
          'screenY': first.screenY,
          'clientX': first.clientX,
          'clientY': first.clientY
        });
      } else {
        simulatedEvent = document.createEvent('MouseEvent');
        simulatedEvent.initMouseEvent(type, true, true, window, 1, first.screenX, first.screenY, first.clientX, first.clientY, false, false, false, false, 0 /*left*/, null);
      }
      first.target.dispatchEvent(simulatedEvent);
    };
  };
};

Touch.init = function ($) {
  if (typeof $.spotSwipe === 'undefined') {
    Touch.setupSpotSwipe($);
    Touch.setupTouchHandler($);
  }
};

exports.Touch = Touch;

/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Timer = undefined;

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function Timer(elem, options, cb) {
  var _this = this,
      duration = options.duration,
      //options is an object for easily adding features later.
  nameSpace = Object.keys(elem.data())[0] || 'timer',
      remain = -1,
      start,
      timer;

  this.isPaused = false;

  this.restart = function () {
    remain = -1;
    clearTimeout(timer);
    this.start();
  };

  this.start = function () {
    this.isPaused = false;
    // if(!elem.data('paused')){ return false; }//maybe implement this sanity check if used for other things.
    clearTimeout(timer);
    remain = remain <= 0 ? duration : remain;
    elem.data('paused', false);
    start = Date.now();
    timer = setTimeout(function () {
      if (options.infinite) {
        _this.restart(); //rerun the timer.
      }
      if (cb && typeof cb === 'function') {
        cb();
      }
    }, remain);
    elem.trigger('timerstart.zf.' + nameSpace);
  };

  this.pause = function () {
    this.isPaused = true;
    //if(elem.data('paused')){ return false; }//maybe implement this sanity check if used for other things.
    clearTimeout(timer);
    elem.data('paused', true);
    var end = Date.now();
    remain = remain - (end - start);
    elem.trigger('timerpaused.zf.' + nameSpace);
  };
}

exports.Timer = Timer;

/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Accordion = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _foundationUtil = __webpack_require__(4);

var _foundationUtil2 = __webpack_require__(1);

var _foundation = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * Accordion module.
 * @module foundation.accordion
 * @requires foundation.util.keyboard
 */

var Accordion = function (_Plugin) {
  _inherits(Accordion, _Plugin);

  function Accordion() {
    _classCallCheck(this, Accordion);

    return _possibleConstructorReturn(this, (Accordion.__proto__ || Object.getPrototypeOf(Accordion)).apply(this, arguments));
  }

  _createClass(Accordion, [{
    key: '_setup',

    /**
     * Creates a new instance of an accordion.
     * @class
     * @name Accordion
     * @fires Accordion#init
     * @param {jQuery} element - jQuery object to make into an accordion.
     * @param {Object} options - a plain object with settings to override the default options.
     */
    value: function _setup(element, options) {
      this.$element = element;
      this.options = _jquery2.default.extend({}, Accordion.defaults, this.$element.data(), options);

      this.className = 'Accordion'; // ie9 back compat
      this._init();

      _foundationUtil.Keyboard.register('Accordion', {
        'ENTER': 'toggle',
        'SPACE': 'toggle',
        'ARROW_DOWN': 'next',
        'ARROW_UP': 'previous'
      });
    }

    /**
     * Initializes the accordion by animating the preset active pane(s).
     * @private
     */

  }, {
    key: '_init',
    value: function _init() {
      var _this3 = this;

      this.$element.attr('role', 'tablist');
      this.$tabs = this.$element.children('[data-accordion-item]');

      this.$tabs.each(function (idx, el) {
        var $el = (0, _jquery2.default)(el),
            $content = $el.children('[data-tab-content]'),
            id = $content[0].id || (0, _foundationUtil2.GetYoDigits)(6, 'accordion'),
            linkId = el.id || id + '-label';

        $el.find('a:first').attr({
          'aria-controls': id,
          'role': 'tab',
          'id': linkId,
          'aria-expanded': false,
          'aria-selected': false
        });

        $content.attr({ 'role': 'tabpanel', 'aria-labelledby': linkId, 'aria-hidden': true, 'id': id });
      });
      var $initActive = this.$element.find('.is-active').children('[data-tab-content]');
      this.firstTimeInit = true;
      if ($initActive.length) {
        this.down($initActive, this.firstTimeInit);
        this.firstTimeInit = false;
      }

      this._checkDeepLink = function () {
        var anchor = window.location.hash;
        //need a hash and a relevant anchor in this tabset
        if (anchor.length) {
          var $link = _this3.$element.find('[href$="' + anchor + '"]'),
              $anchor = (0, _jquery2.default)(anchor);

          if ($link.length && $anchor) {
            if (!$link.parent('[data-accordion-item]').hasClass('is-active')) {
              _this3.down($anchor, _this3.firstTimeInit);
              _this3.firstTimeInit = false;
            };

            //roll up a little to show the titles
            if (_this3.options.deepLinkSmudge) {
              var _this = _this3;
              (0, _jquery2.default)(window).load(function () {
                var offset = _this.$element.offset();
                (0, _jquery2.default)('html, body').animate({ scrollTop: offset.top }, _this.options.deepLinkSmudgeDelay);
              });
            }

            /**
              * Fires when the zplugin has deeplinked at pageload
              * @event Accordion#deeplink
              */
            _this3.$element.trigger('deeplink.zf.accordion', [$link, $anchor]);
          }
        }
      };

      //use browser to open a tab, if it exists in this tabset
      if (this.options.deepLink) {
        this._checkDeepLink();
      }

      this._events();
    }

    /**
     * Adds event handlers for items within the accordion.
     * @private
     */

  }, {
    key: '_events',
    value: function _events() {
      var _this = this;

      this.$tabs.each(function () {
        var $elem = (0, _jquery2.default)(this);
        var $tabContent = $elem.children('[data-tab-content]');
        if ($tabContent.length) {
          $elem.children('a').off('click.zf.accordion keydown.zf.accordion').on('click.zf.accordion', function (e) {
            e.preventDefault();
            _this.toggle($tabContent);
          }).on('keydown.zf.accordion', function (e) {
            _foundationUtil.Keyboard.handleKey(e, 'Accordion', {
              toggle: function toggle() {
                _this.toggle($tabContent);
              },
              next: function next() {
                var $a = $elem.next().find('a').focus();
                if (!_this.options.multiExpand) {
                  $a.trigger('click.zf.accordion');
                }
              },
              previous: function previous() {
                var $a = $elem.prev().find('a').focus();
                if (!_this.options.multiExpand) {
                  $a.trigger('click.zf.accordion');
                }
              },
              handled: function handled() {
                e.preventDefault();
                e.stopPropagation();
              }
            });
          });
        }
      });
      if (this.options.deepLink) {
        (0, _jquery2.default)(window).on('popstate', this._checkDeepLink);
      }
    }

    /**
     * Toggles the selected content pane's open/close state.
     * @param {jQuery} $target - jQuery object of the pane to toggle (`.accordion-content`).
     * @function
     */

  }, {
    key: 'toggle',
    value: function toggle($target) {
      if ($target.closest('[data-accordion]').is('[disabled]')) {
        console.info('Cannot toggle an accordion that is disabled.');
        return;
      }
      if ($target.parent().hasClass('is-active')) {
        this.up($target);
      } else {
        this.down($target);
      }
      //either replace or update browser history
      if (this.options.deepLink) {
        var anchor = $target.prev('a').attr('href');

        if (this.options.updateHistory) {
          history.pushState({}, '', anchor);
        } else {
          history.replaceState({}, '', anchor);
        }
      }
    }

    /**
     * Opens the accordion tab defined by `$target`.
     * @param {jQuery} $target - Accordion pane to open (`.accordion-content`).
     * @param {Boolean} firstTime - flag to determine if reflow should happen.
     * @fires Accordion#down
     * @function
     */

  }, {
    key: 'down',
    value: function down($target, firstTime) {
      var _this4 = this;

      /**
       * checking firstTime allows for initial render of the accordion
       * to render preset is-active panes.
       */
      if ($target.closest('[data-accordion]').is('[disabled]') && !firstTime) {
        console.info('Cannot call down on an accordion that is disabled.');
        return;
      }
      $target.attr('aria-hidden', false).parent('[data-tab-content]').addBack().parent().addClass('is-active');

      if (!this.options.multiExpand && !firstTime) {
        var $currentActive = this.$element.children('.is-active').children('[data-tab-content]');
        if ($currentActive.length) {
          this.up($currentActive.not($target));
        }
      }

      $target.slideDown(this.options.slideSpeed, function () {
        /**
         * Fires when the tab is done opening.
         * @event Accordion#down
         */
        _this4.$element.trigger('down.zf.accordion', [$target]);
      });

      (0, _jquery2.default)('#' + $target.attr('aria-labelledby')).attr({
        'aria-expanded': true,
        'aria-selected': true
      });
    }

    /**
     * Closes the tab defined by `$target`.
     * @param {jQuery} $target - Accordion tab to close (`.accordion-content`).
     * @fires Accordion#up
     * @function
     */

  }, {
    key: 'up',
    value: function up($target) {
      if ($target.closest('[data-accordion]').is('[disabled]')) {
        console.info('Cannot call up on an accordion that is disabled.');
        return;
      }

      var $aunts = $target.parent().siblings(),
          _this = this;

      if (!this.options.allowAllClosed && !$aunts.hasClass('is-active') || !$target.parent().hasClass('is-active')) {
        return;
      }

      $target.slideUp(_this.options.slideSpeed, function () {
        /**
         * Fires when the tab is done collapsing up.
         * @event Accordion#up
         */
        _this.$element.trigger('up.zf.accordion', [$target]);
      });

      $target.attr('aria-hidden', true).parent().removeClass('is-active');

      (0, _jquery2.default)('#' + $target.attr('aria-labelledby')).attr({
        'aria-expanded': false,
        'aria-selected': false
      });
    }

    /**
     * Destroys an instance of an accordion.
     * @fires Accordion#destroyed
     * @function
     */

  }, {
    key: '_destroy',
    value: function _destroy() {
      this.$element.find('[data-tab-content]').stop(true).slideUp(0).css('display', '');
      this.$element.find('a').off('.zf.accordion');
      if (this.options.deepLink) {
        (0, _jquery2.default)(window).off('popstate', this._checkDeepLink);
      }
    }
  }]);

  return Accordion;
}(_foundation.Plugin);

Accordion.defaults = {
  /**
   * Amount of time to animate the opening of an accordion pane.
   * @option
   * @type {number}
   * @default 250
   */
  slideSpeed: 250,
  /**
   * Allow the accordion to have multiple open panes.
   * @option
   * @type {boolean}
   * @default false
   */
  multiExpand: false,
  /**
   * Allow the accordion to close all panes.
   * @option
   * @type {boolean}
   * @default false
   */
  allowAllClosed: false,
  /**
   * Allows the window to scroll to content of pane specified by hash anchor
   * @option
   * @type {boolean}
   * @default false
   */
  deepLink: false,

  /**
   * Adjust the deep link scroll to make sure the top of the accordion panel is visible
   * @option
   * @type {boolean}
   * @default false
   */
  deepLinkSmudge: false,

  /**
   * Animation time (ms) for the deep link adjustment
   * @option
   * @type {number}
   * @default 300
   */
  deepLinkSmudgeDelay: 300,

  /**
   * Update the browser history with the open accordion
   * @option
   * @type {boolean}
   * @default false
   */
  updateHistory: false
};

exports.Accordion = Accordion;

/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccordionMenu = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _foundationUtil = __webpack_require__(4);

var _foundationUtil2 = __webpack_require__(9);

var _foundationUtil3 = __webpack_require__(1);

var _foundation = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * AccordionMenu module.
 * @module foundation.accordionMenu
 * @requires foundation.util.keyboard
 * @requires foundation.util.nest
 */

var AccordionMenu = function (_Plugin) {
  _inherits(AccordionMenu, _Plugin);

  function AccordionMenu() {
    _classCallCheck(this, AccordionMenu);

    return _possibleConstructorReturn(this, (AccordionMenu.__proto__ || Object.getPrototypeOf(AccordionMenu)).apply(this, arguments));
  }

  _createClass(AccordionMenu, [{
    key: '_setup',

    /**
     * Creates a new instance of an accordion menu.
     * @class
     * @name AccordionMenu
     * @fires AccordionMenu#init
     * @param {jQuery} element - jQuery object to make into an accordion menu.
     * @param {Object} options - Overrides to the default plugin settings.
     */
    value: function _setup(element, options) {
      this.$element = element;
      this.options = _jquery2.default.extend({}, AccordionMenu.defaults, this.$element.data(), options);
      this.className = 'AccordionMenu'; // ie9 back compat

      this._init();

      _foundationUtil.Keyboard.register('AccordionMenu', {
        'ENTER': 'toggle',
        'SPACE': 'toggle',
        'ARROW_RIGHT': 'open',
        'ARROW_UP': 'up',
        'ARROW_DOWN': 'down',
        'ARROW_LEFT': 'close',
        'ESCAPE': 'closeAll'
      });
    }

    /**
     * Initializes the accordion menu by hiding all nested menus.
     * @private
     */

  }, {
    key: '_init',
    value: function _init() {
      _foundationUtil2.Nest.Feather(this.$element, 'accordion');

      var _this = this;

      this.$element.find('[data-submenu]').not('.is-active').slideUp(0); //.find('a').css('padding-left', '1rem');
      this.$element.attr({
        'role': 'tree',
        'aria-multiselectable': this.options.multiOpen
      });

      this.$menuLinks = this.$element.find('.is-accordion-submenu-parent');
      this.$menuLinks.each(function () {
        var linkId = this.id || (0, _foundationUtil3.GetYoDigits)(6, 'acc-menu-link'),
            $elem = (0, _jquery2.default)(this),
            $sub = $elem.children('[data-submenu]'),
            subId = $sub[0].id || (0, _foundationUtil3.GetYoDigits)(6, 'acc-menu'),
            isActive = $sub.hasClass('is-active');

        if (_this.options.submenuToggle) {
          $elem.addClass('has-submenu-toggle');
          $elem.children('a').after('<button id="' + linkId + '" class="submenu-toggle" aria-controls="' + subId + '" aria-expanded="' + isActive + '" title="' + _this.options.submenuToggleText + '"><span class="submenu-toggle-text">' + _this.options.submenuToggleText + '</span></button>');
        } else {
          $elem.attr({
            'aria-controls': subId,
            'aria-expanded': isActive,
            'id': linkId
          });
        }
        $sub.attr({
          'aria-labelledby': linkId,
          'aria-hidden': !isActive,
          'role': 'group',
          'id': subId
        });
      });
      this.$element.find('li').attr({
        'role': 'treeitem'
      });
      var initPanes = this.$element.find('.is-active');
      if (initPanes.length) {
        var _this = this;
        initPanes.each(function () {
          _this.down((0, _jquery2.default)(this));
        });
      }
      this._events();
    }

    /**
     * Adds event handlers for items within the menu.
     * @private
     */

  }, {
    key: '_events',
    value: function _events() {
      var _this = this;

      this.$element.find('li').each(function () {
        var $submenu = (0, _jquery2.default)(this).children('[data-submenu]');

        if ($submenu.length) {
          if (_this.options.submenuToggle) {
            (0, _jquery2.default)(this).children('.submenu-toggle').off('click.zf.accordionMenu').on('click.zf.accordionMenu', function (e) {
              _this.toggle($submenu);
            });
          } else {
            (0, _jquery2.default)(this).children('a').off('click.zf.accordionMenu').on('click.zf.accordionMenu', function (e) {
              e.preventDefault();
              _this.toggle($submenu);
            });
          }
        }
      }).on('keydown.zf.accordionmenu', function (e) {
        var $element = (0, _jquery2.default)(this),
            $elements = $element.parent('ul').children('li'),
            $prevElement,
            $nextElement,
            $target = $element.children('[data-submenu]');

        $elements.each(function (i) {
          if ((0, _jquery2.default)(this).is($element)) {
            $prevElement = $elements.eq(Math.max(0, i - 1)).find('a').first();
            $nextElement = $elements.eq(Math.min(i + 1, $elements.length - 1)).find('a').first();

            if ((0, _jquery2.default)(this).children('[data-submenu]:visible').length) {
              // has open sub menu
              $nextElement = $element.find('li:first-child').find('a').first();
            }
            if ((0, _jquery2.default)(this).is(':first-child')) {
              // is first element of sub menu
              $prevElement = $element.parents('li').first().find('a').first();
            } else if ($prevElement.parents('li').first().children('[data-submenu]:visible').length) {
              // if previous element has open sub menu
              $prevElement = $prevElement.parents('li').find('li:last-child').find('a').first();
            }
            if ((0, _jquery2.default)(this).is(':last-child')) {
              // is last element of sub menu
              $nextElement = $element.parents('li').first().next('li').find('a').first();
            }

            return;
          }
        });

        _foundationUtil.Keyboard.handleKey(e, 'AccordionMenu', {
          open: function open() {
            if ($target.is(':hidden')) {
              _this.down($target);
              $target.find('li').first().find('a').first().focus();
            }
          },
          close: function close() {
            if ($target.length && !$target.is(':hidden')) {
              // close active sub of this item
              _this.up($target);
            } else if ($element.parent('[data-submenu]').length) {
              // close currently open sub
              _this.up($element.parent('[data-submenu]'));
              $element.parents('li').first().find('a').first().focus();
            }
          },
          up: function up() {
            $prevElement.focus();
            return true;
          },
          down: function down() {
            $nextElement.focus();
            return true;
          },
          toggle: function toggle() {
            if (_this.options.submenuToggle) {
              return false;
            }
            if ($element.children('[data-submenu]').length) {
              _this.toggle($element.children('[data-submenu]'));
              return true;
            }
          },
          closeAll: function closeAll() {
            _this.hideAll();
          },
          handled: function handled(preventDefault) {
            if (preventDefault) {
              e.preventDefault();
            }
            e.stopImmediatePropagation();
          }
        });
      }); //.attr('tabindex', 0);
    }

    /**
     * Closes all panes of the menu.
     * @function
     */

  }, {
    key: 'hideAll',
    value: function hideAll() {
      this.up(this.$element.find('[data-submenu]'));
    }

    /**
     * Opens all panes of the menu.
     * @function
     */

  }, {
    key: 'showAll',
    value: function showAll() {
      this.down(this.$element.find('[data-submenu]'));
    }

    /**
     * Toggles the open/close state of a submenu.
     * @function
     * @param {jQuery} $target - the submenu to toggle
     */

  }, {
    key: 'toggle',
    value: function toggle($target) {
      if (!$target.is(':animated')) {
        if (!$target.is(':hidden')) {
          this.up($target);
        } else {
          this.down($target);
        }
      }
    }

    /**
     * Opens the sub-menu defined by `$target`.
     * @param {jQuery} $target - Sub-menu to open.
     * @fires AccordionMenu#down
     */

  }, {
    key: 'down',
    value: function down($target) {
      var _this = this;

      if (!this.options.multiOpen) {
        this.up(this.$element.find('.is-active').not($target.parentsUntil(this.$element).add($target)));
      }

      $target.addClass('is-active').attr({ 'aria-hidden': false });

      if (this.options.submenuToggle) {
        $target.prev('.submenu-toggle').attr({ 'aria-expanded': true });
      } else {
        $target.parent('.is-accordion-submenu-parent').attr({ 'aria-expanded': true });
      }

      $target.slideDown(_this.options.slideSpeed, function () {
        /**
         * Fires when the menu is done opening.
         * @event AccordionMenu#down
         */
        _this.$element.trigger('down.zf.accordionMenu', [$target]);
      });
    }

    /**
     * Closes the sub-menu defined by `$target`. All sub-menus inside the target will be closed as well.
     * @param {jQuery} $target - Sub-menu to close.
     * @fires AccordionMenu#up
     */

  }, {
    key: 'up',
    value: function up($target) {
      var _this = this;
      $target.slideUp(_this.options.slideSpeed, function () {
        /**
         * Fires when the menu is done collapsing up.
         * @event AccordionMenu#up
         */
        _this.$element.trigger('up.zf.accordionMenu', [$target]);
      });

      var $menus = $target.find('[data-submenu]').slideUp(0).addBack().attr('aria-hidden', true);

      if (this.options.submenuToggle) {
        $menus.prev('.submenu-toggle').attr('aria-expanded', false);
      } else {
        $menus.parent('.is-accordion-submenu-parent').attr('aria-expanded', false);
      }
    }

    /**
     * Destroys an instance of accordion menu.
     * @fires AccordionMenu#destroyed
     */

  }, {
    key: '_destroy',
    value: function _destroy() {
      this.$element.find('[data-submenu]').slideDown(0).css('display', '');
      this.$element.find('a').off('click.zf.accordionMenu');

      if (this.options.submenuToggle) {
        this.$element.find('.has-submenu-toggle').removeClass('has-submenu-toggle');
        this.$element.find('.submenu-toggle').remove();
      }

      _foundationUtil2.Nest.Burn(this.$element, 'accordion');
    }
  }]);

  return AccordionMenu;
}(_foundation.Plugin);

AccordionMenu.defaults = {
  /**
   * Amount of time to animate the opening of a submenu in ms.
   * @option
   * @type {number}
   * @default 250
   */
  slideSpeed: 250,
  /**
   * Adds a separate submenu toggle button. This allows the parent item to have a link.
   * @option
   * @example true
   */
  submenuToggle: false,
  /**
   * The text used for the submenu toggle if enabled. This is used for screen readers only.
   * @option
   * @example true
   */
  submenuToggleText: 'Toggle menu',
  /**
   * Allow the menu to have multiple open panes.
   * @option
   * @type {boolean}
   * @default true
   */
  multiOpen: true
};

exports.AccordionMenu = AccordionMenu;

/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Drilldown = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _foundationUtil = __webpack_require__(4);

var _foundationUtil2 = __webpack_require__(9);

var _foundationUtil3 = __webpack_require__(1);

var _foundationUtil4 = __webpack_require__(7);

var _foundation = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * Drilldown module.
 * @module foundation.drilldown
 * @requires foundation.util.keyboard
 * @requires foundation.util.nest
 * @requires foundation.util.box
 */

var Drilldown = function (_Plugin) {
  _inherits(Drilldown, _Plugin);

  function Drilldown() {
    _classCallCheck(this, Drilldown);

    return _possibleConstructorReturn(this, (Drilldown.__proto__ || Object.getPrototypeOf(Drilldown)).apply(this, arguments));
  }

  _createClass(Drilldown, [{
    key: '_setup',

    /**
     * Creates a new instance of a drilldown menu.
     * @class
     * @name Drilldown
     * @param {jQuery} element - jQuery object to make into an accordion menu.
     * @param {Object} options - Overrides to the default plugin settings.
     */
    value: function _setup(element, options) {
      this.$element = element;
      this.options = _jquery2.default.extend({}, Drilldown.defaults, this.$element.data(), options);
      this.className = 'Drilldown'; // ie9 back compat

      this._init();

      _foundationUtil.Keyboard.register('Drilldown', {
        'ENTER': 'open',
        'SPACE': 'open',
        'ARROW_RIGHT': 'next',
        'ARROW_UP': 'up',
        'ARROW_DOWN': 'down',
        'ARROW_LEFT': 'previous',
        'ESCAPE': 'close',
        'TAB': 'down',
        'SHIFT_TAB': 'up'
      });
    }

    /**
     * Initializes the drilldown by creating jQuery collections of elements
     * @private
     */

  }, {
    key: '_init',
    value: function _init() {
      _foundationUtil2.Nest.Feather(this.$element, 'drilldown');

      if (this.options.autoApplyClass) {
        this.$element.addClass('drilldown');
      }

      this.$element.attr({
        'role': 'tree',
        'aria-multiselectable': false
      });
      this.$submenuAnchors = this.$element.find('li.is-drilldown-submenu-parent').children('a');
      this.$submenus = this.$submenuAnchors.parent('li').children('[data-submenu]').attr('role', 'group');
      this.$menuItems = this.$element.find('li').not('.js-drilldown-back').attr('role', 'treeitem').find('a');
      this.$element.attr('data-mutate', this.$element.attr('data-drilldown') || (0, _foundationUtil3.GetYoDigits)(6, 'drilldown'));

      this._prepareMenu();
      this._registerEvents();

      this._keyboardEvents();
    }

    /**
     * prepares drilldown menu by setting attributes to links and elements
     * sets a min height to prevent content jumping
     * wraps the element if not already wrapped
     * @private
     * @function
     */

  }, {
    key: '_prepareMenu',
    value: function _prepareMenu() {
      var _this = this;
      // if(!this.options.holdOpen){
      //   this._menuLinkEvents();
      // }
      this.$submenuAnchors.each(function () {
        var $link = (0, _jquery2.default)(this);
        var $sub = $link.parent();
        if (_this.options.parentLink) {
          $link.clone().prependTo($sub.children('[data-submenu]')).wrap('<li class="is-submenu-parent-item is-submenu-item is-drilldown-submenu-item" role="menuitem"></li>');
        }
        $link.data('savedHref', $link.attr('href')).removeAttr('href').attr('tabindex', 0);
        $link.children('[data-submenu]').attr({
          'aria-hidden': true,
          'tabindex': 0,
          'role': 'group'
        });
        _this._events($link);
      });
      this.$submenus.each(function () {
        var $menu = (0, _jquery2.default)(this),
            $back = $menu.find('.js-drilldown-back');
        if (!$back.length) {
          switch (_this.options.backButtonPosition) {
            case "bottom":
              $menu.append(_this.options.backButton);
              break;
            case "top":
              $menu.prepend(_this.options.backButton);
              break;
            default:
              console.error("Unsupported backButtonPosition value '" + _this.options.backButtonPosition + "'");
          }
        }
        _this._back($menu);
      });

      this.$submenus.addClass('invisible');
      if (!this.options.autoHeight) {
        this.$submenus.addClass('drilldown-submenu-cover-previous');
      }

      // create a wrapper on element if it doesn't exist.
      if (!this.$element.parent().hasClass('is-drilldown')) {
        this.$wrapper = (0, _jquery2.default)(this.options.wrapper).addClass('is-drilldown');
        if (this.options.animateHeight) this.$wrapper.addClass('animate-height');
        this.$element.wrap(this.$wrapper);
      }
      // set wrapper
      this.$wrapper = this.$element.parent();
      this.$wrapper.css(this._getMaxDims());
    }
  }, {
    key: '_resize',
    value: function _resize() {
      this.$wrapper.css({ 'max-width': 'none', 'min-height': 'none' });
      // _getMaxDims has side effects (boo) but calling it should update all other necessary heights & widths
      this.$wrapper.css(this._getMaxDims());
    }

    /**
     * Adds event handlers to elements in the menu.
     * @function
     * @private
     * @param {jQuery} $elem - the current menu item to add handlers to.
     */

  }, {
    key: '_events',
    value: function _events($elem) {
      var _this = this;

      $elem.off('click.zf.drilldown').on('click.zf.drilldown', function (e) {
        if ((0, _jquery2.default)(e.target).parentsUntil('ul', 'li').hasClass('is-drilldown-submenu-parent')) {
          e.stopImmediatePropagation();
          e.preventDefault();
        }

        // if(e.target !== e.currentTarget.firstElementChild){
        //   return false;
        // }
        _this._show($elem.parent('li'));

        if (_this.options.closeOnClick) {
          var $body = (0, _jquery2.default)('body');
          $body.off('.zf.drilldown').on('click.zf.drilldown', function (e) {
            if (e.target === _this.$element[0] || _jquery2.default.contains(_this.$element[0], e.target)) {
              return;
            }
            e.preventDefault();
            _this._hideAll();
            $body.off('.zf.drilldown');
          });
        }
      });
    }

    /**
     * Adds event handlers to the menu element.
     * @function
     * @private
     */

  }, {
    key: '_registerEvents',
    value: function _registerEvents() {
      if (this.options.scrollTop) {
        this._bindHandler = this._scrollTop.bind(this);
        this.$element.on('open.zf.drilldown hide.zf.drilldown closed.zf.drilldown', this._bindHandler);
      }
      this.$element.on('mutateme.zf.trigger', this._resize.bind(this));
    }

    /**
     * Scroll to Top of Element or data-scroll-top-element
     * @function
     * @fires Drilldown#scrollme
     */

  }, {
    key: '_scrollTop',
    value: function _scrollTop() {
      var _this = this;
      var $scrollTopElement = _this.options.scrollTopElement != '' ? (0, _jquery2.default)(_this.options.scrollTopElement) : _this.$element,
          scrollPos = parseInt($scrollTopElement.offset().top + _this.options.scrollTopOffset, 10);
      (0, _jquery2.default)('html, body').stop(true).animate({ scrollTop: scrollPos }, _this.options.animationDuration, _this.options.animationEasing, function () {
        /**
          * Fires after the menu has scrolled
          * @event Drilldown#scrollme
          */
        if (this === (0, _jquery2.default)('html')[0]) _this.$element.trigger('scrollme.zf.drilldown');
      });
    }

    /**
     * Adds keydown event listener to `li`'s in the menu.
     * @private
     */

  }, {
    key: '_keyboardEvents',
    value: function _keyboardEvents() {
      var _this = this;

      this.$menuItems.add(this.$element.find('.js-drilldown-back > a, .is-submenu-parent-item > a')).on('keydown.zf.drilldown', function (e) {
        var $element = (0, _jquery2.default)(this),
            $elements = $element.parent('li').parent('ul').children('li').children('a'),
            $prevElement,
            $nextElement;

        $elements.each(function (i) {
          if ((0, _jquery2.default)(this).is($element)) {
            $prevElement = $elements.eq(Math.max(0, i - 1));
            $nextElement = $elements.eq(Math.min(i + 1, $elements.length - 1));
            return;
          }
        });

        _foundationUtil.Keyboard.handleKey(e, 'Drilldown', {
          next: function next() {
            if ($element.is(_this.$submenuAnchors)) {
              _this._show($element.parent('li'));
              $element.parent('li').one((0, _foundationUtil3.transitionend)($element), function () {
                $element.parent('li').find('ul li a').filter(_this.$menuItems).first().focus();
              });
              return true;
            }
          },
          previous: function previous() {
            _this._hide($element.parent('li').parent('ul'));
            $element.parent('li').parent('ul').one((0, _foundationUtil3.transitionend)($element), function () {
              setTimeout(function () {
                $element.parent('li').parent('ul').parent('li').children('a').first().focus();
              }, 1);
            });
            return true;
          },
          up: function up() {
            $prevElement.focus();
            // Don't tap focus on first element in root ul
            return !$element.is(_this.$element.find('> li:first-child > a'));
          },
          down: function down() {
            $nextElement.focus();
            // Don't tap focus on last element in root ul
            return !$element.is(_this.$element.find('> li:last-child > a'));
          },
          close: function close() {
            // Don't close on element in root ul
            if (!$element.is(_this.$element.find('> li > a'))) {
              _this._hide($element.parent().parent());
              $element.parent().parent().siblings('a').focus();
            }
          },
          open: function open() {
            if (!$element.is(_this.$menuItems)) {
              // not menu item means back button
              _this._hide($element.parent('li').parent('ul'));
              $element.parent('li').parent('ul').one((0, _foundationUtil3.transitionend)($element), function () {
                setTimeout(function () {
                  $element.parent('li').parent('ul').parent('li').children('a').first().focus();
                }, 1);
              });
              return true;
            } else if ($element.is(_this.$submenuAnchors)) {
              _this._show($element.parent('li'));
              $element.parent('li').one((0, _foundationUtil3.transitionend)($element), function () {
                $element.parent('li').find('ul li a').filter(_this.$menuItems).first().focus();
              });
              return true;
            }
          },
          handled: function handled(preventDefault) {
            if (preventDefault) {
              e.preventDefault();
            }
            e.stopImmediatePropagation();
          }
        });
      }); // end keyboardAccess
    }

    /**
     * Closes all open elements, and returns to root menu.
     * @function
     * @fires Drilldown#closed
     */

  }, {
    key: '_hideAll',
    value: function _hideAll() {
      var $elem = this.$element.find('.is-drilldown-submenu.is-active').addClass('is-closing');
      if (this.options.autoHeight) this.$wrapper.css({ height: $elem.parent().closest('ul').data('calcHeight') });
      $elem.one((0, _foundationUtil3.transitionend)($elem), function (e) {
        $elem.removeClass('is-active is-closing');
      });
      /**
       * Fires when the menu is fully closed.
       * @event Drilldown#closed
       */
      this.$element.trigger('closed.zf.drilldown');
    }

    /**
     * Adds event listener for each `back` button, and closes open menus.
     * @function
     * @fires Drilldown#back
     * @param {jQuery} $elem - the current sub-menu to add `back` event.
     */

  }, {
    key: '_back',
    value: function _back($elem) {
      var _this = this;
      $elem.off('click.zf.drilldown');
      $elem.children('.js-drilldown-back').on('click.zf.drilldown', function (e) {
        e.stopImmediatePropagation();
        // console.log('mouseup on back');
        _this._hide($elem);

        // If there is a parent submenu, call show
        var parentSubMenu = $elem.parent('li').parent('ul').parent('li');
        if (parentSubMenu.length) {
          _this._show(parentSubMenu);
        }
      });
    }

    /**
     * Adds event listener to menu items w/o submenus to close open menus on click.
     * @function
     * @private
     */

  }, {
    key: '_menuLinkEvents',
    value: function _menuLinkEvents() {
      var _this = this;
      this.$menuItems.not('.is-drilldown-submenu-parent').off('click.zf.drilldown').on('click.zf.drilldown', function (e) {
        // e.stopImmediatePropagation();
        setTimeout(function () {
          _this._hideAll();
        }, 0);
      });
    }

    /**
     * Opens a submenu.
     * @function
     * @fires Drilldown#open
     * @param {jQuery} $elem - the current element with a submenu to open, i.e. the `li` tag.
     */

  }, {
    key: '_show',
    value: function _show($elem) {
      if (this.options.autoHeight) this.$wrapper.css({ height: $elem.children('[data-submenu]').data('calcHeight') });
      $elem.attr('aria-expanded', true);
      $elem.children('[data-submenu]').addClass('is-active').removeClass('invisible').attr('aria-hidden', false);
      /**
       * Fires when the submenu has opened.
       * @event Drilldown#open
       */
      this.$element.trigger('open.zf.drilldown', [$elem]);
    }
  }, {
    key: '_hide',


    /**
     * Hides a submenu
     * @function
     * @fires Drilldown#hide
     * @param {jQuery} $elem - the current sub-menu to hide, i.e. the `ul` tag.
     */
    value: function _hide($elem) {
      if (this.options.autoHeight) this.$wrapper.css({ height: $elem.parent().closest('ul').data('calcHeight') });
      var _this = this;
      $elem.parent('li').attr('aria-expanded', false);
      $elem.attr('aria-hidden', true).addClass('is-closing');
      $elem.addClass('is-closing').one((0, _foundationUtil3.transitionend)($elem), function () {
        $elem.removeClass('is-active is-closing');
        $elem.blur().addClass('invisible');
      });
      /**
       * Fires when the submenu has closed.
       * @event Drilldown#hide
       */
      $elem.trigger('hide.zf.drilldown', [$elem]);
    }

    /**
     * Iterates through the nested menus to calculate the min-height, and max-width for the menu.
     * Prevents content jumping.
     * @function
     * @private
     */

  }, {
    key: '_getMaxDims',
    value: function _getMaxDims() {
      var maxHeight = 0,
          result = {},
          _this = this;
      this.$submenus.add(this.$element).each(function () {
        var numOfElems = (0, _jquery2.default)(this).children('li').length;
        var height = _foundationUtil4.Box.GetDimensions(this).height;
        maxHeight = height > maxHeight ? height : maxHeight;
        if (_this.options.autoHeight) {
          (0, _jquery2.default)(this).data('calcHeight', height);
          if (!(0, _jquery2.default)(this).hasClass('is-drilldown-submenu')) result['height'] = height;
        }
      });

      if (!this.options.autoHeight) result['min-height'] = maxHeight + 'px';

      result['max-width'] = this.$element[0].getBoundingClientRect().width + 'px';

      return result;
    }

    /**
     * Destroys the Drilldown Menu
     * @function
     */

  }, {
    key: '_destroy',
    value: function _destroy() {
      if (this.options.scrollTop) this.$element.off('.zf.drilldown', this._bindHandler);
      this._hideAll();
      this.$element.off('mutateme.zf.trigger');
      _foundationUtil2.Nest.Burn(this.$element, 'drilldown');
      this.$element.unwrap().find('.js-drilldown-back, .is-submenu-parent-item').remove().end().find('.is-active, .is-closing, .is-drilldown-submenu').removeClass('is-active is-closing is-drilldown-submenu').end().find('[data-submenu]').removeAttr('aria-hidden tabindex role');
      this.$submenuAnchors.each(function () {
        (0, _jquery2.default)(this).off('.zf.drilldown');
      });

      this.$submenus.removeClass('drilldown-submenu-cover-previous invisible');

      this.$element.find('a').each(function () {
        var $link = (0, _jquery2.default)(this);
        $link.removeAttr('tabindex');
        if ($link.data('savedHref')) {
          $link.attr('href', $link.data('savedHref')).removeData('savedHref');
        } else {
          return;
        }
      });
    }
  }]);

  return Drilldown;
}(_foundation.Plugin);

Drilldown.defaults = {
  /**
   * Drilldowns depend on styles in order to function properly; in the default build of Foundation these are
   * on the `drilldown` class. This option auto-applies this class to the drilldown upon initialization.
   * @option
   * @type {boolian}
   * @default true
   */
  autoApplyClass: true,
  /**
   * Markup used for JS generated back button. Prepended  or appended (see backButtonPosition) to submenu lists and deleted on `destroy` method, 'js-drilldown-back' class required. Remove the backslash (`\`) if copy and pasting.
   * @option
   * @type {string}
   * @default '<li class="js-drilldown-back"><a tabindex="0">Back</a></li>'
   */
  backButton: '<li class="js-drilldown-back"><a tabindex="0">Back</a></li>',
  /**
   * Position the back button either at the top or bottom of drilldown submenus. Can be `'left'` or `'bottom'`.
   * @option
   * @type {string}
   * @default top
   */
  backButtonPosition: 'top',
  /**
   * Markup used to wrap drilldown menu. Use a class name for independent styling; the JS applied class: `is-drilldown` is required. Remove the backslash (`\`) if copy and pasting.
   * @option
   * @type {string}
   * @default '<div></div>'
   */
  wrapper: '<div></div>',
  /**
   * Adds the parent link to the submenu.
   * @option
   * @type {boolean}
   * @default false
   */
  parentLink: false,
  /**
   * Allow the menu to return to root list on body click.
   * @option
   * @type {boolean}
   * @default false
   */
  closeOnClick: false,
  /**
   * Allow the menu to auto adjust height.
   * @option
   * @type {boolean}
   * @default false
   */
  autoHeight: false,
  /**
   * Animate the auto adjust height.
   * @option
   * @type {boolean}
   * @default false
   */
  animateHeight: false,
  /**
   * Scroll to the top of the menu after opening a submenu or navigating back using the menu back button
   * @option
   * @type {boolean}
   * @default false
   */
  scrollTop: false,
  /**
   * String jquery selector (for example 'body') of element to take offset().top from, if empty string the drilldown menu offset().top is taken
   * @option
   * @type {string}
   * @default ''
   */
  scrollTopElement: '',
  /**
   * ScrollTop offset
   * @option
   * @type {number}
   * @default 0
   */
  scrollTopOffset: 0,
  /**
   * Scroll animation duration
   * @option
   * @type {number}
   * @default 500
   */
  animationDuration: 500,
  /**
   * Scroll animation easing. Can be `'swing'` or `'linear'`.
   * @option
   * @type {string}
   * @see {@link https://api.jquery.com/animate|JQuery animate}
   * @default 'swing'
   */
  animationEasing: 'swing'
  // holdOpen: false
};

exports.Drilldown = Drilldown;

/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Positionable = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _foundationUtil = __webpack_require__(7);

var _foundation = __webpack_require__(2);

var _foundationUtil2 = __webpack_require__(1);

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var POSITIONS = ['left', 'right', 'top', 'bottom'];
var VERTICAL_ALIGNMENTS = ['top', 'bottom', 'center'];
var HORIZONTAL_ALIGNMENTS = ['left', 'right', 'center'];

var ALIGNMENTS = {
  'left': VERTICAL_ALIGNMENTS,
  'right': VERTICAL_ALIGNMENTS,
  'top': HORIZONTAL_ALIGNMENTS,
  'bottom': HORIZONTAL_ALIGNMENTS
};

function nextItem(item, array) {
  var currentIdx = array.indexOf(item);
  if (currentIdx === array.length - 1) {
    return array[0];
  } else {
    return array[currentIdx + 1];
  }
}

var Positionable = function (_Plugin) {
  _inherits(Positionable, _Plugin);

  function Positionable() {
    _classCallCheck(this, Positionable);

    return _possibleConstructorReturn(this, (Positionable.__proto__ || Object.getPrototypeOf(Positionable)).apply(this, arguments));
  }

  _createClass(Positionable, [{
    key: '_init',

    /**
     * Abstract class encapsulating the tether-like explicit positioning logic
     * including repositioning based on overlap.
     * Expects classes to define defaults for vOffset, hOffset, position,
     * alignment, allowOverlap, and allowBottomOverlap. They can do this by
     * extending the defaults, or (for now recommended due to the way docs are
     * generated) by explicitly declaring them.
     *
     **/

    value: function _init() {
      this.triedPositions = {};
      this.position = this.options.position === 'auto' ? this._getDefaultPosition() : this.options.position;
      this.alignment = this.options.alignment === 'auto' ? this._getDefaultAlignment() : this.options.alignment;
    }
  }, {
    key: '_getDefaultPosition',
    value: function _getDefaultPosition() {
      return 'bottom';
    }
  }, {
    key: '_getDefaultAlignment',
    value: function _getDefaultAlignment() {
      switch (this.position) {
        case 'bottom':
        case 'top':
          return (0, _foundationUtil2.rtl)() ? 'right' : 'left';
        case 'left':
        case 'right':
          return 'bottom';
      }
    }

    /**
     * Adjusts the positionable possible positions by iterating through alignments
     * and positions.
     * @function
     * @private
     */

  }, {
    key: '_reposition',
    value: function _reposition() {
      if (this._alignmentsExhausted(this.position)) {
        this.position = nextItem(this.position, POSITIONS);
        this.alignment = ALIGNMENTS[this.position][0];
      } else {
        this._realign();
      }
    }

    /**
     * Adjusts the dropdown pane possible positions by iterating through alignments
     * on the current position.
     * @function
     * @private
     */

  }, {
    key: '_realign',
    value: function _realign() {
      this._addTriedPosition(this.position, this.alignment);
      this.alignment = nextItem(this.alignment, ALIGNMENTS[this.position]);
    }
  }, {
    key: '_addTriedPosition',
    value: function _addTriedPosition(position, alignment) {
      this.triedPositions[position] = this.triedPositions[position] || [];
      this.triedPositions[position].push(alignment);
    }
  }, {
    key: '_positionsExhausted',
    value: function _positionsExhausted() {
      var isExhausted = true;
      for (var i = 0; i < POSITIONS.length; i++) {
        isExhausted = isExhausted && this._alignmentsExhausted(POSITIONS[i]);
      }
      return isExhausted;
    }
  }, {
    key: '_alignmentsExhausted',
    value: function _alignmentsExhausted(position) {
      return this.triedPositions[position] && this.triedPositions[position].length == ALIGNMENTS[position].length;
    }

    // When we're trying to center, we don't want to apply offset that's going to
    // take us just off center, so wrap around to return 0 for the appropriate
    // offset in those alignments.  TODO: Figure out if we want to make this
    // configurable behavior... it feels more intuitive, especially for tooltips, but
    // it's possible someone might actually want to start from center and then nudge
    // slightly off.

  }, {
    key: '_getVOffset',
    value: function _getVOffset() {
      return this.options.vOffset;
    }
  }, {
    key: '_getHOffset',
    value: function _getHOffset() {
      return this.options.hOffset;
    }
  }, {
    key: '_setPosition',
    value: function _setPosition($anchor, $element, $parent) {
      if ($anchor.attr('aria-expanded') === 'false') {
        return false;
      }
      var $eleDims = _foundationUtil.Box.GetDimensions($element),
          $anchorDims = _foundationUtil.Box.GetDimensions($anchor);

      $element.offset(_foundationUtil.Box.GetExplicitOffsets($element, $anchor, this.position, this.alignment, this._getVOffset(), this._getHOffset()));

      if (!this.options.allowOverlap) {
        var overlaps = {};
        var minOverlap = 100000000;
        // default coordinates to how we start, in case we can't figure out better
        var minCoordinates = { position: this.position, alignment: this.alignment };
        while (!this._positionsExhausted()) {
          var overlap = _foundationUtil.Box.OverlapArea($element, $parent, false, false, this.options.allowBottomOverlap);
          if (overlap === 0) {
            return;
          }

          if (overlap < minOverlap) {
            minOverlap = overlap;
            minCoordinates = { position: this.position, alignment: this.alignment };
          }

          this._reposition();

          $element.offset(_foundationUtil.Box.GetExplicitOffsets($element, $anchor, this.position, this.alignment, this._getVOffset(), this._getHOffset()));
        }
        // If we get through the entire loop, there was no non-overlapping
        // position available. Pick the version with least overlap.
        this.position = minCoordinates.position;
        this.alignment = minCoordinates.alignment;
        $element.offset(_foundationUtil.Box.GetExplicitOffsets($element, $anchor, this.position, this.alignment, this._getVOffset(), this._getHOffset()));
      }
    }
  }]);

  return Positionable;
}(_foundation.Plugin);

Positionable.defaults = {
  /**
   * Position of positionable relative to anchor. Can be left, right, bottom, top, or auto.
   * @option
   * @type {string}
   * @default 'auto'
   */
  position: 'auto',
  /**
   * Alignment of positionable relative to anchor. Can be left, right, bottom, top, center, or auto.
   * @option
   * @type {string}
   * @default 'auto'
   */
  alignment: 'auto',
  /**
   * Allow overlap of container/window. If false, dropdown positionable first
   * try to position as defined by data-position and data-alignment, but
   * reposition if it would cause an overflow.
   * @option
   * @type {boolean}
   * @default false
   */
  allowOverlap: false,
  /**
   * Allow overlap of only the bottom of the container. This is the most common
   * behavior for dropdowns, allowing the dropdown to extend the bottom of the
   * screen but not otherwise influence or break out of the container.
   * @option
   * @type {boolean}
   * @default true
   */
  allowBottomOverlap: true,
  /**
   * Number of pixels the positionable should be separated vertically from anchor
   * @option
   * @type {number}
   * @default 0
   */
  vOffset: 0,
  /**
   * Number of pixels the positionable should be separated horizontally from anchor
   * @option
   * @type {number}
   * @default 0
   */
  hOffset: 0
};

exports.Positionable = Positionable;

/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DropdownMenu = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _foundationUtil = __webpack_require__(4);

var _foundationUtil2 = __webpack_require__(9);

var _foundationUtil3 = __webpack_require__(7);

var _foundationUtil4 = __webpack_require__(1);

var _foundation = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * DropdownMenu module.
 * @module foundation.dropdown-menu
 * @requires foundation.util.keyboard
 * @requires foundation.util.box
 * @requires foundation.util.nest
 */

var DropdownMenu = function (_Plugin) {
  _inherits(DropdownMenu, _Plugin);

  function DropdownMenu() {
    _classCallCheck(this, DropdownMenu);

    return _possibleConstructorReturn(this, (DropdownMenu.__proto__ || Object.getPrototypeOf(DropdownMenu)).apply(this, arguments));
  }

  _createClass(DropdownMenu, [{
    key: '_setup',

    /**
     * Creates a new instance of DropdownMenu.
     * @class
     * @name DropdownMenu
     * @fires DropdownMenu#init
     * @param {jQuery} element - jQuery object to make into a dropdown menu.
     * @param {Object} options - Overrides to the default plugin settings.
     */
    value: function _setup(element, options) {
      this.$element = element;
      this.options = _jquery2.default.extend({}, DropdownMenu.defaults, this.$element.data(), options);
      this.className = 'DropdownMenu'; // ie9 back compat

      this._init();

      _foundationUtil.Keyboard.register('DropdownMenu', {
        'ENTER': 'open',
        'SPACE': 'open',
        'ARROW_RIGHT': 'next',
        'ARROW_UP': 'up',
        'ARROW_DOWN': 'down',
        'ARROW_LEFT': 'previous',
        'ESCAPE': 'close'
      });
    }

    /**
     * Initializes the plugin, and calls _prepareMenu
     * @private
     * @function
     */

  }, {
    key: '_init',
    value: function _init() {
      _foundationUtil2.Nest.Feather(this.$element, 'dropdown');

      var subs = this.$element.find('li.is-dropdown-submenu-parent');
      this.$element.children('.is-dropdown-submenu-parent').children('.is-dropdown-submenu').addClass('first-sub');

      this.$menuItems = this.$element.find('[role="menuitem"]');
      this.$tabs = this.$element.children('[role="menuitem"]');
      this.$tabs.find('ul.is-dropdown-submenu').addClass(this.options.verticalClass);

      if (this.options.alignment === 'auto') {
        if (this.$element.hasClass(this.options.rightClass) || (0, _foundationUtil4.rtl)() || this.$element.parents('.top-bar-right').is('*')) {
          this.options.alignment = 'right';
          subs.addClass('opens-left');
        } else {
          this.options.alignment = 'left';
          subs.addClass('opens-right');
        }
      } else {
        if (this.options.alignment === 'right') {
          subs.addClass('opens-left');
        } else {
          subs.addClass('opens-right');
        }
      }
      this.changed = false;
      this._events();
    }
  }, {
    key: '_isVertical',
    value: function _isVertical() {
      return this.$tabs.css('display') === 'block' || this.$element.css('flex-direction') === 'column';
    }
  }, {
    key: '_isRtl',
    value: function _isRtl() {
      return this.$element.hasClass('align-right') || (0, _foundationUtil4.rtl)() && !this.$element.hasClass('align-left');
    }

    /**
     * Adds event listeners to elements within the menu
     * @private
     * @function
     */

  }, {
    key: '_events',
    value: function _events() {
      var _this = this,
          hasTouch = 'ontouchstart' in window || typeof window.ontouchstart !== 'undefined',
          parClass = 'is-dropdown-submenu-parent';

      // used for onClick and in the keyboard handlers
      var handleClickFn = function handleClickFn(e) {
        var $elem = (0, _jquery2.default)(e.target).parentsUntil('ul', '.' + parClass),
            hasSub = $elem.hasClass(parClass),
            hasClicked = $elem.attr('data-is-click') === 'true',
            $sub = $elem.children('.is-dropdown-submenu');

        if (hasSub) {
          if (hasClicked) {
            if (!_this.options.closeOnClick || !_this.options.clickOpen && !hasTouch || _this.options.forceFollow && hasTouch) {
              return;
            } else {
              e.stopImmediatePropagation();
              e.preventDefault();
              _this._hide($elem);
            }
          } else {
            e.preventDefault();
            e.stopImmediatePropagation();
            _this._show($sub);
            $elem.add($elem.parentsUntil(_this.$element, '.' + parClass)).attr('data-is-click', true);
          }
        }
      };

      if (this.options.clickOpen || hasTouch) {
        this.$menuItems.on('click.zf.dropdownmenu touchstart.zf.dropdownmenu', handleClickFn);
      }

      // Handle Leaf element Clicks
      if (_this.options.closeOnClickInside) {
        this.$menuItems.on('click.zf.dropdownmenu', function (e) {
          var $elem = (0, _jquery2.default)(this),
              hasSub = $elem.hasClass(parClass);
          if (!hasSub) {
            _this._hide();
          }
        });
      }

      if (!this.options.disableHover) {
        this.$menuItems.on('mouseenter.zf.dropdownmenu', function (e) {
          var $elem = (0, _jquery2.default)(this),
              hasSub = $elem.hasClass(parClass);

          if (hasSub) {
            clearTimeout($elem.data('_delay'));
            $elem.data('_delay', setTimeout(function () {
              _this._show($elem.children('.is-dropdown-submenu'));
            }, _this.options.hoverDelay));
          }
        }).on('mouseleave.zf.dropdownmenu', function (e) {
          var $elem = (0, _jquery2.default)(this),
              hasSub = $elem.hasClass(parClass);
          if (hasSub && _this.options.autoclose) {
            if ($elem.attr('data-is-click') === 'true' && _this.options.clickOpen) {
              return false;
            }

            clearTimeout($elem.data('_delay'));
            $elem.data('_delay', setTimeout(function () {
              _this._hide($elem);
            }, _this.options.closingTime));
          }
        });
      }
      this.$menuItems.on('keydown.zf.dropdownmenu', function (e) {
        var $element = (0, _jquery2.default)(e.target).parentsUntil('ul', '[role="menuitem"]'),
            isTab = _this.$tabs.index($element) > -1,
            $elements = isTab ? _this.$tabs : $element.siblings('li').add($element),
            $prevElement,
            $nextElement;

        $elements.each(function (i) {
          if ((0, _jquery2.default)(this).is($element)) {
            $prevElement = $elements.eq(i - 1);
            $nextElement = $elements.eq(i + 1);
            return;
          }
        });

        var nextSibling = function nextSibling() {
          $nextElement.children('a:first').focus();
          e.preventDefault();
        },
            prevSibling = function prevSibling() {
          $prevElement.children('a:first').focus();
          e.preventDefault();
        },
            openSub = function openSub() {
          var $sub = $element.children('ul.is-dropdown-submenu');
          if ($sub.length) {
            _this._show($sub);
            $element.find('li > a:first').focus();
            e.preventDefault();
          } else {
            return;
          }
        },
            closeSub = function closeSub() {
          //if ($element.is(':first-child')) {
          var close = $element.parent('ul').parent('li');
          close.children('a:first').focus();
          _this._hide(close);
          e.preventDefault();
          //}
        };
        var functions = {
          open: openSub,
          close: function close() {
            _this._hide(_this.$element);
            _this.$menuItems.eq(0).children('a').focus(); // focus to first element
            e.preventDefault();
          },
          handled: function handled() {
            e.stopImmediatePropagation();
          }
        };

        if (isTab) {
          if (_this._isVertical()) {
            // vertical menu
            if (_this._isRtl()) {
              // right aligned
              _jquery2.default.extend(functions, {
                down: nextSibling,
                up: prevSibling,
                next: closeSub,
                previous: openSub
              });
            } else {
              // left aligned
              _jquery2.default.extend(functions, {
                down: nextSibling,
                up: prevSibling,
                next: openSub,
                previous: closeSub
              });
            }
          } else {
            // horizontal menu
            if (_this._isRtl()) {
              // right aligned
              _jquery2.default.extend(functions, {
                next: prevSibling,
                previous: nextSibling,
                down: openSub,
                up: closeSub
              });
            } else {
              // left aligned
              _jquery2.default.extend(functions, {
                next: nextSibling,
                previous: prevSibling,
                down: openSub,
                up: closeSub
              });
            }
          }
        } else {
          // not tabs -> one sub
          if (_this._isRtl()) {
            // right aligned
            _jquery2.default.extend(functions, {
              next: closeSub,
              previous: openSub,
              down: nextSibling,
              up: prevSibling
            });
          } else {
            // left aligned
            _jquery2.default.extend(functions, {
              next: openSub,
              previous: closeSub,
              down: nextSibling,
              up: prevSibling
            });
          }
        }
        _foundationUtil.Keyboard.handleKey(e, 'DropdownMenu', functions);
      });
    }

    /**
     * Adds an event handler to the body to close any dropdowns on a click.
     * @function
     * @private
     */

  }, {
    key: '_addBodyHandler',
    value: function _addBodyHandler() {
      var $body = (0, _jquery2.default)(document.body),
          _this = this;
      $body.off('mouseup.zf.dropdownmenu touchend.zf.dropdownmenu').on('mouseup.zf.dropdownmenu touchend.zf.dropdownmenu', function (e) {
        var $link = _this.$element.find(e.target);
        if ($link.length) {
          return;
        }

        _this._hide();
        $body.off('mouseup.zf.dropdownmenu touchend.zf.dropdownmenu');
      });
    }

    /**
     * Opens a dropdown pane, and checks for collisions first.
     * @param {jQuery} $sub - ul element that is a submenu to show
     * @function
     * @private
     * @fires DropdownMenu#show
     */

  }, {
    key: '_show',
    value: function _show($sub) {
      var idx = this.$tabs.index(this.$tabs.filter(function (i, el) {
        return (0, _jquery2.default)(el).find($sub).length > 0;
      }));
      var $sibs = $sub.parent('li.is-dropdown-submenu-parent').siblings('li.is-dropdown-submenu-parent');
      this._hide($sibs, idx);
      $sub.css('visibility', 'hidden').addClass('js-dropdown-active').parent('li.is-dropdown-submenu-parent').addClass('is-active');
      var clear = _foundationUtil3.Box.ImNotTouchingYou($sub, null, true);
      if (!clear) {
        var oldClass = this.options.alignment === 'left' ? '-right' : '-left',
            $parentLi = $sub.parent('.is-dropdown-submenu-parent');
        $parentLi.removeClass('opens' + oldClass).addClass('opens-' + this.options.alignment);
        clear = _foundationUtil3.Box.ImNotTouchingYou($sub, null, true);
        if (!clear) {
          $parentLi.removeClass('opens-' + this.options.alignment).addClass('opens-inner');
        }
        this.changed = true;
      }
      $sub.css('visibility', '');
      if (this.options.closeOnClick) {
        this._addBodyHandler();
      }
      /**
       * Fires when the new dropdown pane is visible.
       * @event DropdownMenu#show
       */
      this.$element.trigger('show.zf.dropdownmenu', [$sub]);
    }

    /**
     * Hides a single, currently open dropdown pane, if passed a parameter, otherwise, hides everything.
     * @function
     * @param {jQuery} $elem - element with a submenu to hide
     * @param {Number} idx - index of the $tabs collection to hide
     * @private
     */

  }, {
    key: '_hide',
    value: function _hide($elem, idx) {
      var $toClose;
      if ($elem && $elem.length) {
        $toClose = $elem;
      } else if (idx !== undefined) {
        $toClose = this.$tabs.not(function (i, el) {
          return i === idx;
        });
      } else {
        $toClose = this.$element;
      }
      var somethingToClose = $toClose.hasClass('is-active') || $toClose.find('.is-active').length > 0;

      if (somethingToClose) {
        $toClose.find('li.is-active').add($toClose).attr({
          'data-is-click': false
        }).removeClass('is-active');

        $toClose.find('ul.js-dropdown-active').removeClass('js-dropdown-active');

        if (this.changed || $toClose.find('opens-inner').length) {
          var oldClass = this.options.alignment === 'left' ? 'right' : 'left';
          $toClose.find('li.is-dropdown-submenu-parent').add($toClose).removeClass('opens-inner opens-' + this.options.alignment).addClass('opens-' + oldClass);
          this.changed = false;
        }
        /**
         * Fires when the open menus are closed.
         * @event DropdownMenu#hide
         */
        this.$element.trigger('hide.zf.dropdownmenu', [$toClose]);
      }
    }

    /**
     * Destroys the plugin.
     * @function
     */

  }, {
    key: '_destroy',
    value: function _destroy() {
      this.$menuItems.off('.zf.dropdownmenu').removeAttr('data-is-click').removeClass('is-right-arrow is-left-arrow is-down-arrow opens-right opens-left opens-inner');
      (0, _jquery2.default)(document.body).off('.zf.dropdownmenu');
      _foundationUtil2.Nest.Burn(this.$element, 'dropdown');
    }
  }]);

  return DropdownMenu;
}(_foundation.Plugin);

/**
 * Default settings for plugin
 */


DropdownMenu.defaults = {
  /**
   * Disallows hover events from opening submenus
   * @option
   * @type {boolean}
   * @default false
   */
  disableHover: false,
  /**
   * Allow a submenu to automatically close on a mouseleave event, if not clicked open.
   * @option
   * @type {boolean}
   * @default true
   */
  autoclose: true,
  /**
   * Amount of time to delay opening a submenu on hover event.
   * @option
   * @type {number}
   * @default 50
   */
  hoverDelay: 50,
  /**
   * Allow a submenu to open/remain open on parent click event. Allows cursor to move away from menu.
   * @option
   * @type {boolean}
   * @default false
   */
  clickOpen: false,
  /**
   * Amount of time to delay closing a submenu on a mouseleave event.
   * @option
   * @type {number}
   * @default 500
   */

  closingTime: 500,
  /**
   * Position of the menu relative to what direction the submenus should open. Handled by JS. Can be `'auto'`, `'left'` or `'right'`.
   * @option
   * @type {string}
   * @default 'auto'
   */
  alignment: 'auto',
  /**
   * Allow clicks on the body to close any open submenus.
   * @option
   * @type {boolean}
   * @default true
   */
  closeOnClick: true,
  /**
   * Allow clicks on leaf anchor links to close any open submenus.
   * @option
   * @type {boolean}
   * @default true
   */
  closeOnClickInside: true,
  /**
   * Class applied to vertical oriented menus, Foundation default is `vertical`. Update this if using your own class.
   * @option
   * @type {string}
   * @default 'vertical'
   */
  verticalClass: 'vertical',
  /**
   * Class applied to right-side oriented menus, Foundation default is `align-right`. Update this if using your own class.
   * @option
   * @type {string}
   * @default 'align-right'
   */
  rightClass: 'align-right',
  /**
   * Boolean to force overide the clicking of links to perform default action, on second touch event for mobile.
   * @option
   * @type {boolean}
   * @default true
   */
  forceFollow: true
};

exports.DropdownMenu = DropdownMenu;

/***/ }),
/* 17 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.SmoothScroll = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _foundationUtil = __webpack_require__(1);

var _foundation = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * SmoothScroll module.
 * @module foundation.smooth-scroll
 */
var SmoothScroll = function (_Plugin) {
    _inherits(SmoothScroll, _Plugin);

    function SmoothScroll() {
        _classCallCheck(this, SmoothScroll);

        return _possibleConstructorReturn(this, (SmoothScroll.__proto__ || Object.getPrototypeOf(SmoothScroll)).apply(this, arguments));
    }

    _createClass(SmoothScroll, [{
        key: '_setup',

        /**
         * Creates a new instance of SmoothScroll.
         * @class
         * @name SmoothScroll
         * @fires SmoothScroll#init
         * @param {Object} element - jQuery object to add the trigger to.
         * @param {Object} options - Overrides to the default plugin settings.
         */
        value: function _setup(element, options) {
            this.$element = element;
            this.options = _jquery2.default.extend({}, SmoothScroll.defaults, this.$element.data(), options);
            this.className = 'SmoothScroll'; // ie9 back compat

            this._init();
        }

        /**
         * Initialize the SmoothScroll plugin
         * @private
         */

    }, {
        key: '_init',
        value: function _init() {
            var id = this.$element[0].id || (0, _foundationUtil.GetYoDigits)(6, 'smooth-scroll');
            var _this = this;
            this.$element.attr({
                'id': id
            });

            this._events();
        }

        /**
         * Initializes events for SmoothScroll.
         * @private
         */

    }, {
        key: '_events',
        value: function _events() {
            var _this = this;

            // click handler function.
            var handleLinkClick = function handleLinkClick(e) {
                // exit function if the event source isn't coming from an anchor with href attribute starts with '#'
                if (!(0, _jquery2.default)(this).is('a[href^="#"]')) {
                    return false;
                }

                var arrival = this.getAttribute('href');

                _this._inTransition = true;

                SmoothScroll.scrollToLoc(arrival, _this.options, function () {
                    _this._inTransition = false;
                });

                e.preventDefault();
            };

            this.$element.on('click.zf.smoothScroll', handleLinkClick);
            this.$element.on('click.zf.smoothScroll', 'a[href^="#"]', handleLinkClick);
        }

        /**
         * Function to scroll to a given location on the page.
         * @param {String} loc - A properly formatted jQuery id selector. Example: '#foo'
         * @param {Object} options - The options to use.
         * @param {Function} callback - The callback function.
         * @static
         * @function
         */

    }], [{
        key: 'scrollToLoc',
        value: function scrollToLoc(loc) {
            var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : SmoothScroll.defaults;
            var callback = arguments[2];

            // Do nothing if target does not exist to prevent errors
            if (!(0, _jquery2.default)(loc).length) {
                return false;
            }

            var scrollPos = Math.round((0, _jquery2.default)(loc).offset().top - options.threshold / 2 - options.offset);

            (0, _jquery2.default)('html, body').stop(true).animate({ scrollTop: scrollPos }, options.animationDuration, options.animationEasing, function () {
                if (callback && typeof callback == "function") {
                    callback();
                }
            });
        }
    }]);

    return SmoothScroll;
}(_foundation.Plugin);

/**
 * Default settings for plugin.
 */


SmoothScroll.defaults = {
    /**
     * Amount of time, in ms, the animated scrolling should take between locations.
     * @option
     * @type {number}
     * @default 500
     */
    animationDuration: 500,
    /**
     * Animation style to use when scrolling between locations. Can be `'swing'` or `'linear'`.
     * @option
     * @type {string}
     * @default 'linear'
     * @see {@link https://api.jquery.com/animate|Jquery animate}
     */
    animationEasing: 'linear',
    /**
     * Number of pixels to use as a marker for location changes.
     * @option
     * @type {number}
     * @default 50
     */
    threshold: 50,
    /**
     * Number of pixels to offset the scroll of the page on item click if using a sticky nav bar.
     * @option
     * @type {number}
     * @default 0
     */
    offset: 0
};

exports.SmoothScroll = SmoothScroll;

/***/ }),
/* 18 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tabs = undefined;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _foundationUtil = __webpack_require__(4);

var _foundationUtil2 = __webpack_require__(8);

var _foundation = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * Tabs module.
 * @module foundation.tabs
 * @requires foundation.util.keyboard
 * @requires foundation.util.imageLoader if tabs contain images
 */

var Tabs = function (_Plugin) {
  _inherits(Tabs, _Plugin);

  function Tabs() {
    _classCallCheck(this, Tabs);

    return _possibleConstructorReturn(this, (Tabs.__proto__ || Object.getPrototypeOf(Tabs)).apply(this, arguments));
  }

  _createClass(Tabs, [{
    key: '_setup',

    /**
     * Creates a new instance of tabs.
     * @class
     * @name Tabs
     * @fires Tabs#init
     * @param {jQuery} element - jQuery object to make into tabs.
     * @param {Object} options - Overrides to the default plugin settings.
     */
    value: function _setup(element, options) {
      this.$element = element;
      this.options = _jquery2.default.extend({}, Tabs.defaults, this.$element.data(), options);
      this.className = 'Tabs'; // ie9 back compat

      this._init();
      _foundationUtil.Keyboard.register('Tabs', {
        'ENTER': 'open',
        'SPACE': 'open',
        'ARROW_RIGHT': 'next',
        'ARROW_UP': 'previous',
        'ARROW_DOWN': 'next',
        'ARROW_LEFT': 'previous'
        // 'TAB': 'next',
        // 'SHIFT_TAB': 'previous'
      });
    }

    /**
     * Initializes the tabs by showing and focusing (if autoFocus=true) the preset active tab.
     * @private
     */

  }, {
    key: '_init',
    value: function _init() {
      var _this3 = this;

      var _this = this;

      this.$element.attr({ 'role': 'tablist' });
      this.$tabTitles = this.$element.find('.' + this.options.linkClass);
      this.$tabContent = (0, _jquery2.default)('[data-tabs-content="' + this.$element[0].id + '"]');

      this.$tabTitles.each(function () {
        var $elem = (0, _jquery2.default)(this),
            $link = $elem.find('a'),
            isActive = $elem.hasClass('' + _this.options.linkActiveClass),
            hash = $link.attr('data-tabs-target') || $link[0].hash.slice(1),
            linkId = $link[0].id ? $link[0].id : hash + '-label',
            $tabContent = (0, _jquery2.default)('#' + hash);

        $elem.attr({ 'role': 'presentation' });

        $link.attr({
          'role': 'tab',
          'aria-controls': hash,
          'aria-selected': isActive,
          'id': linkId,
          'tabindex': isActive ? '0' : '-1'
        });

        $tabContent.attr({
          'role': 'tabpanel',
          'aria-labelledby': linkId
        });

        if (!isActive) {
          $tabContent.attr('aria-hidden', 'true');
        }

        if (isActive && _this.options.autoFocus) {
          (0, _jquery2.default)(window).load(function () {
            (0, _jquery2.default)('html, body').animate({ scrollTop: $elem.offset().top }, _this.options.deepLinkSmudgeDelay, function () {
              $link.focus();
            });
          });
        }
      });
      if (this.options.matchHeight) {
        var $images = this.$tabContent.find('img');

        if ($images.length) {
          (0, _foundationUtil2.onImagesLoaded)($images, this._setHeight.bind(this));
        } else {
          this._setHeight();
        }
      }

      //current context-bound function to open tabs on page load or history popstate
      this._checkDeepLink = function () {
        var anchor = window.location.hash;
        //need a hash and a relevant anchor in this tabset
        if (anchor.length) {
          var $link = _this3.$element.find('[href$="' + anchor + '"]');
          if ($link.length) {
            _this3.selectTab((0, _jquery2.default)(anchor), true);

            //roll up a little to show the titles
            if (_this3.options.deepLinkSmudge) {
              var offset = _this3.$element.offset();
              (0, _jquery2.default)('html, body').animate({ scrollTop: offset.top }, _this3.options.deepLinkSmudgeDelay);
            }

            /**
              * Fires when the zplugin has deeplinked at pageload
              * @event Tabs#deeplink
              */
            _this3.$element.trigger('deeplink.zf.tabs', [$link, (0, _jquery2.default)(anchor)]);
          }
        }
      };

      //use browser to open a tab, if it exists in this tabset
      if (this.options.deepLink) {
        this._checkDeepLink();
      }

      this._events();
    }

    /**
     * Adds event handlers for items within the tabs.
     * @private
     */

  }, {
    key: '_events',
    value: function _events() {
      this._addKeyHandler();
      this._addClickHandler();
      this._setHeightMqHandler = null;

      if (this.options.matchHeight) {
        this._setHeightMqHandler = this._setHeight.bind(this);

        (0, _jquery2.default)(window).on('changed.zf.mediaquery', this._setHeightMqHandler);
      }

      if (this.options.deepLink) {
        (0, _jquery2.default)(window).on('popstate', this._checkDeepLink);
      }
    }

    /**
     * Adds click handlers for items within the tabs.
     * @private
     */

  }, {
    key: '_addClickHandler',
    value: function _addClickHandler() {
      var _this = this;

      this.$element.off('click.zf.tabs').on('click.zf.tabs', '.' + this.options.linkClass, function (e) {
        e.preventDefault();
        e.stopPropagation();
        _this._handleTabChange((0, _jquery2.default)(this));
      });
    }

    /**
     * Adds keyboard event handlers for items within the tabs.
     * @private
     */

  }, {
    key: '_addKeyHandler',
    value: function _addKeyHandler() {
      var _this = this;

      this.$tabTitles.off('keydown.zf.tabs').on('keydown.zf.tabs', function (e) {
        if (e.which === 9) return;

        var $element = (0, _jquery2.default)(this),
            $elements = $element.parent('ul').children('li'),
            $prevElement,
            $nextElement;

        $elements.each(function (i) {
          if ((0, _jquery2.default)(this).is($element)) {
            if (_this.options.wrapOnKeys) {
              $prevElement = i === 0 ? $elements.last() : $elements.eq(i - 1);
              $nextElement = i === $elements.length - 1 ? $elements.first() : $elements.eq(i + 1);
            } else {
              $prevElement = $elements.eq(Math.max(0, i - 1));
              $nextElement = $elements.eq(Math.min(i + 1, $elements.length - 1));
            }
            return;
          }
        });

        // handle keyboard event with keyboard util
        _foundationUtil.Keyboard.handleKey(e, 'Tabs', {
          open: function open() {
            $element.find('[role="tab"]').focus();
            _this._handleTabChange($element);
          },
          previous: function previous() {
            $prevElement.find('[role="tab"]').focus();
            _this._handleTabChange($prevElement);
          },
          next: function next() {
            $nextElement.find('[role="tab"]').focus();
            _this._handleTabChange($nextElement);
          },
          handled: function handled() {
            e.stopPropagation();
            e.preventDefault();
          }
        });
      });
    }

    /**
     * Opens the tab `$targetContent` defined by `$target`. Collapses active tab.
     * @param {jQuery} $target - Tab to open.
     * @param {boolean} historyHandled - browser has already handled a history update
     * @fires Tabs#change
     * @function
     */

  }, {
    key: '_handleTabChange',
    value: function _handleTabChange($target, historyHandled) {

      /**
       * Check for active class on target. Collapse if exists.
       */
      if ($target.hasClass('' + this.options.linkActiveClass)) {
        if (this.options.activeCollapse) {
          this._collapseTab($target);

          /**
           * Fires when the zplugin has successfully collapsed tabs.
           * @event Tabs#collapse
           */
          this.$element.trigger('collapse.zf.tabs', [$target]);
        }
        return;
      }

      var $oldTab = this.$element.find('.' + this.options.linkClass + '.' + this.options.linkActiveClass),
          $tabLink = $target.find('[role="tab"]'),
          hash = $tabLink.attr('data-tabs-target') || $tabLink[0].hash.slice(1),
          $targetContent = this.$tabContent.find('#' + hash);

      //close old tab
      this._collapseTab($oldTab);

      //open new tab
      this._openTab($target);

      //either replace or update browser history
      if (this.options.deepLink && !historyHandled) {
        var anchor = $target.find('a').attr('href');

        if (this.options.updateHistory) {
          history.pushState({}, '', anchor);
        } else {
          history.replaceState({}, '', anchor);
        }
      }

      /**
       * Fires when the plugin has successfully changed tabs.
       * @event Tabs#change
       */
      this.$element.trigger('change.zf.tabs', [$target, $targetContent]);

      //fire to children a mutation event
      $targetContent.find("[data-mutate]").trigger("mutateme.zf.trigger");
    }

    /**
     * Opens the tab `$targetContent` defined by `$target`.
     * @param {jQuery} $target - Tab to Open.
     * @function
     */

  }, {
    key: '_openTab',
    value: function _openTab($target) {
      var $tabLink = $target.find('[role="tab"]'),
          hash = $tabLink.attr('data-tabs-target') || $tabLink[0].hash.slice(1),
          $targetContent = this.$tabContent.find('#' + hash);

      $target.addClass('' + this.options.linkActiveClass);

      $tabLink.attr({
        'aria-selected': 'true',
        'tabindex': '0'
      });

      $targetContent.addClass('' + this.options.panelActiveClass).removeAttr('aria-hidden');
    }

    /**
     * Collapses `$targetContent` defined by `$target`.
     * @param {jQuery} $target - Tab to Open.
     * @function
     */

  }, {
    key: '_collapseTab',
    value: function _collapseTab($target) {
      var $target_anchor = $target.removeClass('' + this.options.linkActiveClass).find('[role="tab"]').attr({
        'aria-selected': 'false',
        'tabindex': -1
      });

      (0, _jquery2.default)('#' + $target_anchor.attr('aria-controls')).removeClass('' + this.options.panelActiveClass).attr({ 'aria-hidden': 'true' });
    }

    /**
     * Public method for selecting a content pane to display.
     * @param {jQuery | String} elem - jQuery object or string of the id of the pane to display.
     * @param {boolean} historyHandled - browser has already handled a history update
     * @function
     */

  }, {
    key: 'selectTab',
    value: function selectTab(elem, historyHandled) {
      var idStr;

      if ((typeof elem === 'undefined' ? 'undefined' : _typeof(elem)) === 'object') {
        idStr = elem[0].id;
      } else {
        idStr = elem;
      }

      if (idStr.indexOf('#') < 0) {
        idStr = '#' + idStr;
      }

      var $target = this.$tabTitles.find('[href$="' + idStr + '"]').parent('.' + this.options.linkClass);

      this._handleTabChange($target, historyHandled);
    }
  }, {
    key: '_setHeight',

    /**
     * Sets the height of each panel to the height of the tallest panel.
     * If enabled in options, gets called on media query change.
     * If loading content via external source, can be called directly or with _reflow.
     * If enabled with `data-match-height="true"`, tabs sets to equal height
     * @function
     * @private
     */
    value: function _setHeight() {
      var max = 0,
          _this = this; // Lock down the `this` value for the root tabs object

      this.$tabContent.find('.' + this.options.panelClass).css('height', '').each(function () {

        var panel = (0, _jquery2.default)(this),
            isActive = panel.hasClass('' + _this.options.panelActiveClass); // get the options from the parent instead of trying to get them from the child

        if (!isActive) {
          panel.css({ 'visibility': 'hidden', 'display': 'block' });
        }

        var temp = this.getBoundingClientRect().height;

        if (!isActive) {
          panel.css({
            'visibility': '',
            'display': ''
          });
        }

        max = temp > max ? temp : max;
      }).css('height', max + 'px');
    }

    /**
     * Destroys an instance of an tabs.
     * @fires Tabs#destroyed
     */

  }, {
    key: '_destroy',
    value: function _destroy() {
      this.$element.find('.' + this.options.linkClass).off('.zf.tabs').hide().end().find('.' + this.options.panelClass).hide();

      if (this.options.matchHeight) {
        if (this._setHeightMqHandler != null) {
          (0, _jquery2.default)(window).off('changed.zf.mediaquery', this._setHeightMqHandler);
        }
      }

      if (this.options.deepLink) {
        (0, _jquery2.default)(window).off('popstate', this._checkDeepLink);
      }
    }
  }]);

  return Tabs;
}(_foundation.Plugin);

Tabs.defaults = {
  /**
   * Allows the window to scroll to content of pane specified by hash anchor
   * @option
   * @type {boolean}
   * @default false
   */
  deepLink: false,

  /**
   * Adjust the deep link scroll to make sure the top of the tab panel is visible
   * @option
   * @type {boolean}
   * @default false
   */
  deepLinkSmudge: false,

  /**
   * Animation time (ms) for the deep link adjustment
   * @option
   * @type {number}
   * @default 300
   */
  deepLinkSmudgeDelay: 300,

  /**
   * Update the browser history with the open tab
   * @option
   * @type {boolean}
   * @default false
   */
  updateHistory: false,

  /**
   * Allows the window to scroll to content of active pane on load if set to true.
   * Not recommended if more than one tab panel per page.
   * @option
   * @type {boolean}
   * @default false
   */
  autoFocus: false,

  /**
   * Allows keyboard input to 'wrap' around the tab links.
   * @option
   * @type {boolean}
   * @default true
   */
  wrapOnKeys: true,

  /**
   * Allows the tab content panes to match heights if set to true.
   * @option
   * @type {boolean}
   * @default false
   */
  matchHeight: false,

  /**
   * Allows active tabs to collapse when clicked.
   * @option
   * @type {boolean}
   * @default false
   */
  activeCollapse: false,

  /**
   * Class applied to `li`'s in tab link list.
   * @option
   * @type {string}
   * @default 'tabs-title'
   */
  linkClass: 'tabs-title',

  /**
   * Class applied to the active `li` in tab link list.
   * @option
   * @type {string}
   * @default 'is-active'
   */
  linkActiveClass: 'is-active',

  /**
   * Class applied to the content containers.
   * @option
   * @type {string}
   * @default 'tabs-panel'
   */
  panelClass: 'tabs-panel',

  /**
   * Class applied to the active content container.
   * @option
   * @type {string}
   * @default 'is-active'
   */
  panelActiveClass: 'is-active'
};

exports.Tabs = Tabs;

/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(20);


/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _whatInput = __webpack_require__(21);

var _whatInput2 = _interopRequireDefault(_whatInput);

var _foundationSites = __webpack_require__(22);

var _foundationSites2 = _interopRequireDefault(_foundationSites);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

window.$ = _jquery2.default;

// If you want to pick and choose which modules to include, comment out the above and uncomment
// the line below
//import './lib/foundation-explicit-pieces';

(0, _jquery2.default)(document).foundation();

(0, _jquery2.default)(document).ready(function () {

  var url = window.location.pathname;

  (0, _jquery2.default)('#menu-main-menu li').has('ul').addClass('ul-carrot');

  if (url === '../category/security/index.html') {
    (0, _jquery2.default)('.category-security').addClass('active-tab');
  } else if (url === '../category/tips/index.html') {
    (0, _jquery2.default)('.category-tips').addClass('active-tab');
  } else if (url === '../category/news/index.html') {
    (0, _jquery2.default)('.category-news').addClass('active-tab');
  } else if (url === '../category/automation/index.html') {
    (0, _jquery2.default)('.category-automation').addClass('active-tab');
  } else if (url === '../category/safety/index.html') {
    (0, _jquery2.default)('.category-safety').addClass('active-tab');
  }
});

/***/ }),
/* 21 */
/***/ (function(module, exports, __webpack_require__) {

/**
 * what-input - A global utility for tracking the current input method (mouse, keyboard or touch).
 * @version v4.3.1
 * @link https://github.com/ten1seven/what-input
 * @license MIT
 */
(function webpackUniversalModuleDefinition(root, factory) {
	if(true)
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define("whatInput", [], factory);
	else if(typeof exports === 'object')
		exports["whatInput"] = factory();
	else
		root["whatInput"] = factory();
})(this, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};

/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {

/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;

/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};

/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);

/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;

/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}


/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;

/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;

/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";

/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ function(module, exports) {

	'use strict';

	module.exports = function () {
	  /*
	   * variables
	   */

	  // last used input type
	  var currentInput = 'initial';

	  // last used input intent
	  var currentIntent = null;

	  // cache document.documentElement
	  var doc = document.documentElement;

	  // form input types
	  var formInputs = ['input', 'select', 'textarea'];

	  var functionList = [];

	  // list of modifier keys commonly used with the mouse and
	  // can be safely ignored to prevent false keyboard detection
	  var ignoreMap = [16, // shift
	  17, // control
	  18, // alt
	  91, // Windows key / left Apple cmd
	  93 // Windows menu / right Apple cmd
	  ];

	  // list of keys for which we change intent even for form inputs
	  var changeIntentMap = [9 // tab
	  ];

	  // mapping of events to input types
	  var inputMap = {
	    keydown: 'keyboard',
	    keyup: 'keyboard',
	    mousedown: 'mouse',
	    mousemove: 'mouse',
	    MSPointerDown: 'pointer',
	    MSPointerMove: 'pointer',
	    pointerdown: 'pointer',
	    pointermove: 'pointer',
	    touchstart: 'touch'
	  };

	  // array of all used input types
	  var inputTypes = [];

	  // boolean: true if touch buffer is active
	  var isBuffering = false;

	  // boolean: true if the page is being scrolled
	  var isScrolling = false;

	  // store current mouse position
	  var mousePos = {
	    x: null,
	    y: null
	  };

	  // map of IE 10 pointer events
	  var pointerMap = {
	    2: 'touch',
	    3: 'touch', // treat pen like touch
	    4: 'mouse'
	  };

	  var supportsPassive = false;

	  try {
	    var opts = Object.defineProperty({}, 'passive', {
	      get: function get() {
	        supportsPassive = true;
	      }
	    });

	    window.addEventListener('test', null, opts);
	  } catch (e) {}

	  /*
	   * set up
	   */

	  var setUp = function setUp() {
	    // add correct mouse wheel event mapping to `inputMap`
	    inputMap[detectWheel()] = 'mouse';

	    addListeners();
	    setInput();
	  };

	  /*
	   * events
	   */

	  var addListeners = function addListeners() {
	    // `pointermove`, `MSPointerMove`, `mousemove` and mouse wheel event binding
	    // can only demonstrate potential, but not actual, interaction
	    // and are treated separately
	    var options = supportsPassive ? { passive: true } : false;

	    // pointer events (mouse, pen, touch)
	    if (window.PointerEvent) {
	      doc.addEventListener('pointerdown', updateInput);
	      doc.addEventListener('pointermove', setIntent);
	    } else if (window.MSPointerEvent) {
	      doc.addEventListener('MSPointerDown', updateInput);
	      doc.addEventListener('MSPointerMove', setIntent);
	    } else {
	      // mouse events
	      doc.addEventListener('mousedown', updateInput);
	      doc.addEventListener('mousemove', setIntent);

	      // touch events
	      if ('ontouchstart' in window) {
	        doc.addEventListener('touchstart', touchBuffer, options);
	        doc.addEventListener('touchend', touchBuffer);
	      }
	    }

	    // mouse wheel
	    doc.addEventListener(detectWheel(), setIntent, options);

	    // keyboard events
	    doc.addEventListener('keydown', updateInput);
	    doc.addEventListener('keyup', updateInput);
	  };

	  // checks conditions before updating new input
	  var updateInput = function updateInput(event) {
	    // only execute if the touch buffer timer isn't running
	    if (!isBuffering) {
	      var eventKey = event.which;
	      var value = inputMap[event.type];
	      if (value === 'pointer') value = pointerType(event);

	      if (currentInput !== value || currentIntent !== value) {
	        var activeElem = document.activeElement;
	        var activeInput = false;
	        var notFormInput = activeElem && activeElem.nodeName && formInputs.indexOf(activeElem.nodeName.toLowerCase()) === -1;

	        if (notFormInput || changeIntentMap.indexOf(eventKey) !== -1) {
	          activeInput = true;
	        }

	        if (value === 'touch' ||
	        // ignore mouse modifier keys
	        value === 'mouse' ||
	        // don't switch if the current element is a form input
	        value === 'keyboard' && eventKey && activeInput && ignoreMap.indexOf(eventKey) === -1) {
	          // set the current and catch-all variable
	          currentInput = currentIntent = value;

	          setInput();
	        }
	      }
	    }
	  };

	  // updates the doc and `inputTypes` array with new input
	  var setInput = function setInput() {
	    doc.setAttribute('data-whatinput', currentInput);
	    doc.setAttribute('data-whatintent', currentInput);

	    if (inputTypes.indexOf(currentInput) === -1) {
	      inputTypes.push(currentInput);
	      doc.className += ' whatinput-types-' + currentInput;
	    }

	    fireFunctions('input');
	  };

	  // updates input intent for `mousemove` and `pointermove`
	  var setIntent = function setIntent(event) {
	    // test to see if `mousemove` happened relative to the screen
	    // to detect scrolling versus mousemove
	    if (mousePos['x'] !== event.screenX || mousePos['y'] !== event.screenY) {
	      isScrolling = false;

	      mousePos['x'] = event.screenX;
	      mousePos['y'] = event.screenY;
	    } else {
	      isScrolling = true;
	    }

	    // only execute if the touch buffer timer isn't running
	    // or scrolling isn't happening
	    if (!isBuffering && !isScrolling) {
	      var value = inputMap[event.type];
	      if (value === 'pointer') value = pointerType(event);

	      if (currentIntent !== value) {
	        currentIntent = value;

	        doc.setAttribute('data-whatintent', currentIntent);

	        fireFunctions('intent');
	      }
	    }
	  };

	  // buffers touch events because they frequently also fire mouse events
	  var touchBuffer = function touchBuffer(event) {
	    if (event.type === 'touchstart') {
	      isBuffering = false;

	      // set the current input
	      updateInput(event);
	    } else {
	      isBuffering = true;
	    }
	  };

	  var fireFunctions = function fireFunctions(type) {
	    for (var i = 0, len = functionList.length; i < len; i++) {
	      if (functionList[i].type === type) {
	        functionList[i].fn.call(undefined, currentIntent);
	      }
	    }
	  };

	  /*
	   * utilities
	   */

	  var pointerType = function pointerType(event) {
	    if (typeof event.pointerType === 'number') {
	      return pointerMap[event.pointerType];
	    } else {
	      // treat pen like touch
	      return event.pointerType === 'pen' ? 'touch' : event.pointerType;
	    }
	  };

	  // detect version of mouse wheel event to use
	  // via https://developer.mozilla.org/en-US/docs/Web/Events/wheel
	  var detectWheel = function detectWheel() {
	    var wheelType = void 0;

	    // Modern browsers support "wheel"
	    if ('onwheel' in document.createElement('div')) {
	      wheelType = 'wheel';
	    } else {
	      // Webkit and IE support at least "mousewheel"
	      // or assume that remaining browsers are older Firefox
	      wheelType = document.onmousewheel !== undefined ? 'mousewheel' : 'DOMMouseScroll';
	    }

	    return wheelType;
	  };

	  var objPos = function objPos(match) {
	    for (var i = 0, len = functionList.length; i < len; i++) {
	      if (functionList[i].fn === match) {
	        return i;
	      }
	    }
	  };

	  /*
	   * init
	   */

	  // don't start script unless browser cuts the mustard
	  // (also passes if polyfills are used)
	  if ('addEventListener' in window && Array.prototype.indexOf) {
	    setUp();
	  }

	  /*
	   * api
	   */

	  return {
	    // returns string: the current input type
	    // opt: 'loose'|'strict'
	    // 'strict' (default): returns the same value as the `data-whatinput` attribute
	    // 'loose': includes `data-whatintent` value if it's more current than `data-whatinput`
	    ask: function ask(opt) {
	      return opt === 'loose' ? currentIntent : currentInput;
	    },

	    // returns array: all the detected input types
	    types: function types() {
	      return inputTypes;
	    },

	    // overwrites ignored keys with provided array
	    ignoreKeys: function ignoreKeys(arr) {
	      ignoreMap = arr;
	    },

	    // attach functions to input and intent "events"
	    // funct: function to fire on change
	    // eventType: 'input'|'intent'
	    registerOnChange: function registerOnChange(fn, eventType) {
	      functionList.push({
	        fn: fn,
	        type: eventType || 'input'
	      });
	    },

	    unRegisterOnChange: function unRegisterOnChange(fn) {
	      var position = objPos(fn);

	      if (position) {
	        functionList.splice(position, 1);
	      }
	    }
	  };
	}();

/***/ }
/******/ ])
});
;

/***/ }),
/* 22 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _foundation = __webpack_require__(23);

var _foundationUtil = __webpack_require__(1);

var _foundationUtil2 = __webpack_require__(7);

var _foundationUtil3 = __webpack_require__(8);

var _foundationUtil4 = __webpack_require__(4);

var _foundationUtil5 = __webpack_require__(3);

var _foundationUtil6 = __webpack_require__(6);

var _foundationUtil7 = __webpack_require__(9);

var _foundationUtil8 = __webpack_require__(11);

var _foundationUtil9 = __webpack_require__(10);

var _foundationUtil10 = __webpack_require__(5);

var _foundation2 = __webpack_require__(24);

var _foundation3 = __webpack_require__(12);

var _foundation4 = __webpack_require__(13);

var _foundation5 = __webpack_require__(14);

var _foundation6 = __webpack_require__(25);

var _foundation7 = __webpack_require__(16);

var _foundation8 = __webpack_require__(26);

var _foundation9 = __webpack_require__(27);

var _foundation10 = __webpack_require__(28);

var _foundation11 = __webpack_require__(29);

var _foundation12 = __webpack_require__(30);

var _foundation13 = __webpack_require__(31);

var _foundation14 = __webpack_require__(32);

var _foundation15 = __webpack_require__(33);

var _foundation16 = __webpack_require__(34);

var _foundation17 = __webpack_require__(17);

var _foundation18 = __webpack_require__(35);

var _foundation19 = __webpack_require__(18);

var _foundation20 = __webpack_require__(36);

var _foundation21 = __webpack_require__(37);

var _foundation22 = __webpack_require__(38);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

_foundation.Foundation.addToJquery(_jquery2.default);

// Add Foundation Utils to Foundation global namespace for backwards
// compatibility.

_foundation.Foundation.rtl = _foundationUtil.rtl;
_foundation.Foundation.GetYoDigits = _foundationUtil.GetYoDigits;
_foundation.Foundation.transitionend = _foundationUtil.transitionend;

_foundation.Foundation.Box = _foundationUtil2.Box;
_foundation.Foundation.onImagesLoaded = _foundationUtil3.onImagesLoaded;
_foundation.Foundation.Keyboard = _foundationUtil4.Keyboard;
_foundation.Foundation.MediaQuery = _foundationUtil5.MediaQuery;
_foundation.Foundation.Motion = _foundationUtil6.Motion;
_foundation.Foundation.Move = _foundationUtil6.Move;
_foundation.Foundation.Nest = _foundationUtil7.Nest;
_foundation.Foundation.Timer = _foundationUtil8.Timer;

// Touch and Triggers previously were almost purely sede effect driven,
// so n../../js// need to add it to Foundation, just init them.

_foundationUtil9.Touch.init(_jquery2.default);

_foundationUtil10.Triggers.init(_jquery2.default, _foundation.Foundation);

_foundation.Foundation.plugin(_foundation2.Abide, 'Abide');

_foundation.Foundation.plugin(_foundation3.Accordion, 'Accordion');

_foundation.Foundation.plugin(_foundation4.AccordionMenu, 'AccordionMenu');

_foundation.Foundation.plugin(_foundation5.Drilldown, 'Drilldown');

_foundation.Foundation.plugin(_foundation6.Dropdown, 'Dropdown');

_foundation.Foundation.plugin(_foundation7.DropdownMenu, 'DropdownMenu');

_foundation.Foundation.plugin(_foundation8.Equalizer, 'Equalizer');

_foundation.Foundation.plugin(_foundation9.Interchange, 'Interchange');

_foundation.Foundation.plugin(_foundation10.Magellan, 'Magellan');

_foundation.Foundation.plugin(_foundation11.OffCanvas, 'OffCanvas');

_foundation.Foundation.plugin(_foundation12.Orbit, 'Orbit');

_foundation.Foundation.plugin(_foundation13.ResponsiveMenu, 'ResponsiveMenu');

_foundation.Foundation.plugin(_foundation14.ResponsiveToggle, 'ResponsiveToggle');

_foundation.Foundation.plugin(_foundation15.Reveal, 'Reveal');

_foundation.Foundation.plugin(_foundation16.Slider, 'Slider');

_foundation.Foundation.plugin(_foundation17.SmoothScroll, 'SmoothScroll');

_foundation.Foundation.plugin(_foundation18.Sticky, 'Sticky');

_foundation.Foundation.plugin(_foundation19.Tabs, 'Tabs');

_foundation.Foundation.plugin(_foundation20.Toggler, 'Toggler');

_foundation.Foundation.plugin(_foundation21.Tooltip, 'Tooltip');

_foundation.Foundation.plugin(_foundation22.ResponsiveAccordionTabs, 'ResponsiveAccordionTabs');

exports.default = _foundation.Foundation;

/***/ }),
/* 23 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Foundation = undefined;

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _foundationUtil = __webpack_require__(1);

var _foundationUtil2 = __webpack_require__(3);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var FOUNDATION_VERSION = '6.4.3';

// Global Foundation object
// This is attached to the window, or used as a module for AMD/Browserify
var Foundation = {
  version: FOUNDATION_VERSION,

  /**
   * Stores initialized plugins.
   */
  _plugins: {},

  /**
   * Stores generated unique ids for plugin instances
   */
  _uuids: [],

  /**
   * Defines a Foundation plugin, adding it to the `Foundation` namespace and the list of plugins to initialize when reflowing.
   * @param {Object} plugin - The constructor of the plugin.
   */
  plugin: function plugin(_plugin, name) {
    // Object key to use when adding to global Foundation object
    // Examples: Foundation.Reveal, Foundation.OffCanvas
    var className = name || functionName(_plugin);
    // Object key to use when storing the plugin, also used to create the identifying data attribute for the plugin
    // Examples: data-reveal, data-off-canvas
    var attrName = hyphenate(className);

    // Add to the Foundation object and the plugins list (for reflowing)
    this._plugins[attrName] = this[className] = _plugin;
  },
  /**
   * @function
   * Populates the _uuids array with pointers to each individual plugin instance.
   * Adds the `zfPlugin` data-attribute to programmatically created plugins to allow use of $(selector).foundation(method) calls.
   * Also fires the initialization event for each plugin, consolidating repetitive code.
   * @param {Object} plugin - an instance of a plugin, usually `this` in context.
   * @param {String} name - the name of the plugin, passed as a camelCased string.
   * @fires Plugin#init
   */
  registerPlugin: function registerPlugin(plugin, name) {
    var pluginName = name ? hyphenate(name) : functionName(plugin.constructor).toLowerCase();
    plugin.uuid = (0, _foundationUtil.GetYoDigits)(6, pluginName);

    if (!plugin.$element.attr('data-' + pluginName)) {
      plugin.$element.attr('data-' + pluginName, plugin.uuid);
    }
    if (!plugin.$element.data('zfPlugin')) {
      plugin.$element.data('zfPlugin', plugin);
    }
    /**
     * Fires when the plugin has initialized.
     * @event Plugin#init
     */
    plugin.$element.trigger('init.zf.' + pluginName);

    this._uuids.push(plugin.uuid);

    return;
  },
  /**
   * @function
   * Removes the plugins uuid from the _uuids array.
   * Removes the zfPlugin data attribute, as well as the data-plugin-name attribute.
   * Also fires the destroyed event for the plugin, consolidating repetitive code.
   * @param {Object} plugin - an instance of a plugin, usually `this` in context.
   * @fires Plugin#destroyed
   */
  unregisterPlugin: function unregisterPlugin(plugin) {
    var pluginName = hyphenate(functionName(plugin.$element.data('zfPlugin').constructor));

    this._uuids.splice(this._uuids.indexOf(plugin.uuid), 1);
    plugin.$element.removeAttr('data-' + pluginName).removeData('zfPlugin')
    /**
     * Fires when the plugin has been destroyed.
     * @event Plugin#destroyed
     */
    .trigger('destroyed.zf.' + pluginName);
    for (var prop in plugin) {
      plugin[prop] = null; //clean up script to prep for garbage collection.
    }
    return;
  },

  /**
   * @function
   * Causes one or more active plugins to re-initialize, resetting event listeners, recalculating positions, etc.
   * @param {String} plugins - optional string of an individual plugin key, attained by calling `$(element).data('pluginName')`, or string of a plugin class i.e. `'dropdown'`
   * @default If no argument is passed, reflow all currently active plugins.
   */
  reInit: function reInit(plugins) {
    var isJQ = plugins instanceof _jquery2.default;
    try {
      if (isJQ) {
        plugins.each(function () {
          (0, _jquery2.default)(this).data('zfPlugin')._init();
        });
      } else {
        var type = typeof plugins === 'undefined' ? 'undefined' : _typeof(plugins),
            _this = this,
            fns = {
          'object': function object(plgs) {
            plgs.forEach(function (p) {
              p = hyphenate(p);
              (0, _jquery2.default)('[data-' + p + ']').foundation('_init');
            });
          },
          'string': function string() {
            plugins = hyphenate(plugins);
            (0, _jquery2.default)('[data-' + plugins + ']').foundation('_init');
          },
          'undefined': function undefined() {
            this['object'](Object.keys(_this._plugins));
          }
        };
        fns[type](plugins);
      }
    } catch (err) {
      console.error(err);
    } finally {
      return plugins;
    }
  },

  /**
   * Initialize plugins on any elements within `elem` (and `elem` itself) that aren't already initialized.
   * @param {Object} elem - jQuery object containing the element to check inside. Also checks the element itself, unless it's the `document` object.
   * @param {String|Array} plugins - A list of plugins to initialize. Leave this out to initialize everything.
   */
  reflow: function reflow(elem, plugins) {

    // If plugins is undefined, just grab everything
    if (typeof plugins === 'undefined') {
      plugins = Object.keys(this._plugins);
    }
    // If plugins is a string, convert it to an array with one item
    else if (typeof plugins === 'string') {
        plugins = [plugins];
      }

    var _this = this;

    // Iterate through each plugin
    _jquery2.default.each(plugins, function (i, name) {
      // Get the current plugin
      var plugin = _this._plugins[name];

      // Localize the search to all elements inside elem, as well as elem itself, unless elem === document
      var $elem = (0, _jquery2.default)(elem).find('[data-' + name + ']').addBack('[data-' + name + ']');

      // For each plugin found, initialize it
      $elem.each(function () {
        var $el = (0, _jquery2.default)(this),
            opts = {};
        // Don't double-dip on plugins
        if ($el.data('zfPlugin')) {
          console.warn("Tried to initialize " + name + " on an element that already has a Foundation plugin.");
          return;
        }

        if ($el.attr('data-options')) {
          var thing = $el.attr('data-options').split(';').forEach(function (e, i) {
            var opt = e.split(':').map(function (el) {
              return el.trim();
            });
            if (opt[0]) opts[opt[0]] = parseValue(opt[1]);
          });
        }
        try {
          $el.data('zfPlugin', new plugin((0, _jquery2.default)(this), opts));
        } catch (er) {
          console.error(er);
        } finally {
          return;
        }
      });
    });
  },
  getFnName: functionName,

  addToJquery: function addToJquery($) {
    // TODO: consider not making this a jQuery function
    // TODO: need way to reflow vs. re-initialize
    /**
     * The Foundation jQuery method.
     * @param {String|Array} method - An action to perform on the current jQuery object.
     */
    var foundation = function foundation(method) {
      var type = typeof method === 'undefined' ? 'undefined' : _typeof(method),
          $noJS = $('.no-js');

      if ($noJS.length) {
        $noJS.removeClass('no-js');
      }

      if (type === 'undefined') {
        //needs to initialize the Foundation object, or an individual plugin.
        _foundationUtil2.MediaQuery._init();
        Foundation.reflow(this);
      } else if (type === 'string') {
        //an individual method to invoke on a plugin or group of plugins
        var args = Array.prototype.slice.call(arguments, 1); //collect all the arguments, if necessary
        var plugClass = this.data('zfPlugin'); //determine the class of plugin

        if (plugClass !== undefined && plugClass[method] !== undefined) {
          //make sure both the class and method exist
          if (this.length === 1) {
            //if there's only one, call it directly.
            plugClass[method].apply(plugClass, args);
          } else {
            this.each(function (i, el) {
              //otherwise loop through the jQuery collection and invoke the method on each
              plugClass[method].apply($(el).data('zfPlugin'), args);
            });
          }
        } else {
          //error for no class or no method
          throw new ReferenceError("We're sorry, '" + method + "' is not an available method for " + (plugClass ? functionName(plugClass) : 'this element') + '.');
        }
      } else {
        //error for invalid argument type
        throw new TypeError('We\'re sorry, ' + type + ' is not a valid parameter. You must use a string representing the method you wish to invoke.');
      }
      return this;
    };
    $.fn.foundation = foundation;
    return $;
  }
};

Foundation.util = {
  /**
   * Function for applying a debounce effect to a function call.
   * @function
   * @param {Function} func - Function to be called at end of timeout.
   * @param {Number} delay - Time in ms to delay the call of `func`.
   * @returns function
   */
  throttle: function throttle(func, delay) {
    var timer = null;

    return function () {
      var context = this,
          args = arguments;

      if (timer === null) {
        timer = setTimeout(function () {
          func.apply(context, args);
          timer = null;
        }, delay);
      }
    };
  }
};

window.Foundation = Foundation;

// Polyfill for requestAnimationFrame
(function () {
  if (!Date.now || !window.Date.now) window.Date.now = Date.now = function () {
    return new Date().getTime();
  };

  var vendors = ['webkit', 'moz'];
  for (var i = 0; i < vendors.length && !window.requestAnimationFrame; ++i) {
    var vp = vendors[i];
    window.requestAnimationFrame = window[vp + 'RequestAnimationFrame'];
    window.cancelAnimationFrame = window[vp + 'CancelAnimationFrame'] || window[vp + 'CancelRequestAnimationFrame'];
  }
  if (/iP(ad|hone|od).*OS 6/.test(window.navigator.userAgent) || !window.requestAnimationFrame || !window.cancelAnimationFrame) {
    var lastTime = 0;
    window.requestAnimationFrame = function (callback) {
      var now = Date.now();
      var nextTime = Math.max(lastTime + 16, now);
      return setTimeout(function () {
        callback(lastTime = nextTime);
      }, nextTime - now);
    };
    window.cancelAnimationFrame = clearTimeout;
  }
  /**
   * Polyfill for performance.now, required by rAF
   */
  if (!window.performance || !window.performance.now) {
    window.performance = {
      start: Date.now(),
      now: function now() {
        return Date.now() - this.start;
      }
    };
  }
})();
if (!Function.prototype.bind) {
  Function.prototype.bind = function (oThis) {
    if (typeof this !== 'function') {
      // closest thing possible to the ECMAScript 5
      // internal IsCallable function
      throw new TypeError('Function.prototype.bind - what is trying to be bound is not callable');
    }

    var aArgs = Array.prototype.slice.call(arguments, 1),
        fToBind = this,
        fNOP = function fNOP() {},
        fBound = function fBound() {
      return fToBind.apply(this instanceof fNOP ? this : oThis, aArgs.concat(Array.prototype.slice.call(arguments)));
    };

    if (this.prototype) {
      // native functions don't have a prototype
      fNOP.prototype = this.prototype;
    }
    fBound.prototype = new fNOP();

    return fBound;
  };
}
// Polyfill to get the name of a function in IE9
function functionName(fn) {
  if (Function.prototype.name === undefined) {
    var funcNameRegex = /function\s([^(]{1,})\(/;
    var results = funcNameRegex.exec(fn.toString());
    return results && results.length > 1 ? results[1].trim() : "";
  } else if (fn.prototype === undefined) {
    return fn.constructor.name;
  } else {
    return fn.prototype.constructor.name;
  }
}
function parseValue(str) {
  if ('true' === str) return true;else if ('false' === str) return false;else if (!isNaN(str * 1)) return parseFloat(str);
  return str;
}
// Convert PascalCase to kebab-case
// Thank you: http://stackoverflow.com/a/8955580
function hyphenate(str) {
  return str.replace(/([a-z])([A-Z])/g, '$1-$2').toLowerCase();
}

exports.Foundation = Foundation;

/***/ }),
/* 24 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Abide = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _foundation = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * Abide module.
 * @module foundation.abide
 */

var Abide = function (_Plugin) {
  _inherits(Abide, _Plugin);

  function Abide() {
    _classCallCheck(this, Abide);

    return _possibleConstructorReturn(this, (Abide.__proto__ || Object.getPrototypeOf(Abide)).apply(this, arguments));
  }

  _createClass(Abide, [{
    key: '_setup',

    /**
     * Creates a new instance of Abide.
     * @class
     * @name Abide
     * @fires Abide#init
     * @param {Object} element - jQuery object to add the trigger to.
     * @param {Object} options - Overrides to the default plugin settings.
     */
    value: function _setup(element) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      this.$element = element;
      this.options = _jquery2.default.extend(true, {}, Abide.defaults, this.$element.data(), options);

      this.className = 'Abide'; // ie9 back compat
      this._init();
    }

    /**
     * Initializes the Abide plugin and calls functions to get Abide functioning on load.
     * @private
     */

  }, {
    key: '_init',
    value: function _init() {
      this.$inputs = this.$element.find('input, textarea, select');

      this._events();
    }

    /**
     * Initializes events for Abide.
     * @private
     */

  }, {
    key: '_events',
    value: function _events() {
      var _this3 = this;

      this.$element.off('.abide').on('reset.zf.abide', function () {
        _this3.resetForm();
      }).on('submit.zf.abide', function () {
        return _this3.validateForm();
      });

      if (this.options.validateOn === 'fieldChange') {
        this.$inputs.off('change.zf.abide').on('change.zf.abide', function (e) {
          _this3.validateInput((0, _jquery2.default)(e.target));
        });
      }

      if (this.options.liveValidate) {
        this.$inputs.off('input.zf.abide').on('input.zf.abide', function (e) {
          _this3.validateInput((0, _jquery2.default)(e.target));
        });
      }

      if (this.options.validateOnBlur) {
        this.$inputs.off('blur.zf.abide').on('blur.zf.abide', function (e) {
          _this3.validateInput((0, _jquery2.default)(e.target));
        });
      }
    }

    /**
     * Calls necessary functions to update Abide upon DOM change
     * @private
     */

  }, {
    key: '_reflow',
    value: function _reflow() {
      this._init();
    }

    /**
     * Checks whether or not a form element has the required attribute and if it's checked or not
     * @param {Object} element - jQuery object to check for required attribute
     * @returns {Boolean} Boolean value depends on whether or not attribute is checked or empty
     */

  }, {
    key: 'requiredCheck',
    value: function requiredCheck($el) {
      if (!$el.attr('required')) return true;

      var isGood = true;

      switch ($el[0].type) {
        case 'checkbox':
          isGood = $el[0].checked;
          break;

        case 'select':
        case 'select-one':
        case 'select-multiple':
          var opt = $el.find('option:selected');
          if (!opt.length || !opt.val()) isGood = false;
          break;

        default:
          if (!$el.val() || !$el.val().length) isGood = false;
      }

      return isGood;
    }

    /**
     * Get:
     * - Based on $el, the first element(s) corresponding to `formErrorSelector` in this order:
     *   1. The element's direct sibling('s).
     *   2. The element's parent's children.
     * - Element(s) with the attribute `[data-form-error-for]` set with the element's id.
     *
     * This allows for multiple form errors per input, though if none are found, no form errors will be shown.
     *
     * @param {Object} $el - jQuery object to use as reference to find the form error selector.
     * @returns {Object} jQuery object with the selector.
     */

  }, {
    key: 'findFormError',
    value: function findFormError($el) {
      var id = $el[0].id;
      var $error = $el.siblings(this.options.formErrorSelector);

      if (!$error.length) {
        $error = $el.parent().find(this.options.formErrorSelector);
      }

      $error = $error.add(this.$element.find('[data-form-error-for="' + id + '"]'));

      return $error;
    }

    /**
     * Get the first element in this order:
     * 2. The <label> with the attribute `[for="someInputId"]`
     * 3. The `.closest()` <label>
     *
     * @param {Object} $el - jQuery object to check for required attribute
     * @returns {Boolean} Boolean value depends on whether or not attribute is checked or empty
     */

  }, {
    key: 'findLabel',
    value: function findLabel($el) {
      var id = $el[0].id;
      var $label = this.$element.find('label[for="' + id + '"]');

      if (!$label.length) {
        return $el.closest('label');
      }

      return $label;
    }

    /**
     * Get the set of labels associated with a set of radio els in this order
     * 2. The <label> with the attribute `[for="someInputId"]`
     * 3. The `.closest()` <label>
     *
     * @param {Object} $el - jQuery object to check for required attribute
     * @returns {Boolean} Boolean value depends on whether or not attribute is checked or empty
     */

  }, {
    key: 'findRadioLabels',
    value: function findRadioLabels($els) {
      var _this4 = this;

      var labels = $els.map(function (i, el) {
        var id = el.id;
        var $label = _this4.$element.find('label[for="' + id + '"]');

        if (!$label.length) {
          $label = (0, _jquery2.default)(el).closest('label');
        }
        return $label[0];
      });

      return (0, _jquery2.default)(labels);
    }

    /**
     * Adds the CSS error class as specified by the Abide settings to the label, input, and the form
     * @param {Object} $el - jQuery object to add the class to
     */

  }, {
    key: 'addErrorClasses',
    value: function addErrorClasses($el) {
      var $label = this.findLabel($el);
      var $formError = this.findFormError($el);

      if ($label.length) {
        $label.addClass(this.options.labelErrorClass);
      }

      if ($formError.length) {
        $formError.addClass(this.options.formErrorClass);
      }

      $el.addClass(this.options.inputErrorClass).attr('data-invalid', '');
    }

    /**
     * Remove CSS error classes etc from an entire radio button group
     * @param {String} groupName - A string that specifies the name of a radio button group
     *
     */

  }, {
    key: 'removeRadioErrorClasses',
    value: function removeRadioErrorClasses(groupName) {
      var $els = this.$element.find(':radio[name="' + groupName + '"]');
      var $labels = this.findRadioLabels($els);
      var $formErrors = this.findFormError($els);

      if ($labels.length) {
        $labels.removeClass(this.options.labelErrorClass);
      }

      if ($formErrors.length) {
        $formErrors.removeClass(this.options.formErrorClass);
      }

      $els.removeClass(this.options.inputErrorClass).removeAttr('data-invalid');
    }

    /**
     * Removes CSS error class as specified by the Abide settings from the label, input, and the form
     * @param {Object} $el - jQuery object to remove the class from
     */

  }, {
    key: 'removeErrorClasses',
    value: function removeErrorClasses($el) {
      // radios need to clear all of the els
      if ($el[0].type == 'radio') {
        return this.removeRadioErrorClasses($el.attr('name'));
      }

      var $label = this.findLabel($el);
      var $formError = this.findFormError($el);

      if ($label.length) {
        $label.removeClass(this.options.labelErrorClass);
      }

      if ($formError.length) {
        $formError.removeClass(this.options.formErrorClass);
      }

      $el.removeClass(this.options.inputErrorClass).removeAttr('data-invalid');
    }

    /**
     * Goes through a form to find inputs and proceeds to validate them in ways specific to their type.
     * Ignores inputs with data-abide-ignore, type="hidden" or disabled attributes set
     * @fires Abide#invalid
     * @fires Abide#valid
     * @param {Object} element - jQuery object to validate, should be an HTML input
     * @returns {Boolean} goodToGo - If the input is valid or not.
     */

  }, {
    key: 'validateInput',
    value: function validateInput($el) {
      var clearRequire = this.requiredCheck($el),
          validated = false,
          customValidator = true,
          validator = $el.attr('data-validator'),
          equalTo = true;

      // don't validate ignored inputs or hidden inputs or disabled inputs
      if ($el.is('[data-abide-ignore]') || $el.is('[type="hidden"]') || $el.is('[disabled]')) {
        return true;
      }

      switch ($el[0].type) {
        case 'radio':
          validated = this.validateRadio($el.attr('name'));
          break;

        case 'checkbox':
          validated = clearRequire;
          break;

        case 'select':
        case 'select-one':
        case 'select-multiple':
          validated = clearRequire;
          break;

        default:
          validated = this.validateText($el);
      }

      if (validator) {
        customValidator = this.matchValidation($el, validator, $el.attr('required'));
      }

      if ($el.attr('data-equalto')) {
        equalTo = this.options.validators.equalTo($el);
      }

      var goodToGo = [clearRequire, validated, customValidator, equalTo].indexOf(false) === -1;
      var message = (goodToGo ? 'valid' : 'invalid') + '.zf.abide';

      if (goodToGo) {
        // Re-validate inputs that depend on this one with equalto
        var dependentElements = this.$element.find('[data-equalto="' + $el.attr('id') + '"]');
        if (dependentElements.length) {
          var _this = this;
          dependentElements.each(function () {
            if ((0, _jquery2.default)(this).val()) {
              _this.validateInput((0, _jquery2.default)(this));
            }
          });
        }
      }

      this[goodToGo ? 'removeErrorClasses' : 'addErrorClasses']($el);

      /**
       * Fires when the input is done checking for validation. Event trigger is either `valid.zf.abide` or `invalid.zf.abide`
       * Trigger includes the DOM element of the input.
       * @event Abide#valid
       * @event Abide#invalid
       */
      $el.trigger(message, [$el]);

      return goodToGo;
    }

    /**
     * Goes through a form and if there are any invalid inputs, it will display the form error element
     * @returns {Boolean} noError - true if no errors were detected...
     * @fires Abide#formvalid
     * @fires Abide#forminvalid
     */

  }, {
    key: 'validateForm',
    value: function validateForm() {
      var acc = [];
      var _this = this;

      this.$inputs.each(function () {
        acc.push(_this.validateInput((0, _jquery2.default)(this)));
      });

      var noError = acc.indexOf(false) === -1;

      this.$element.find('[data-abide-error]').css('display', noError ? 'none' : 'block');

      /**
       * Fires when the form is finished validating. Event trigger is either `formvalid.zf.abide` or `forminvalid.zf.abide`.
       * Trigger includes the element of the form.
       * @event Abide#formvalid
       * @event Abide#forminvalid
       */
      this.$element.trigger((noError ? 'formvalid' : 'forminvalid') + '.zf.abide', [this.$element]);

      return noError;
    }

    /**
     * Determines whether or a not a text input is valid based on the pattern specified in the attribute. If no matching pattern is found, returns true.
     * @param {Object} $el - jQuery object to validate, should be a text input HTML element
     * @param {String} pattern - string value of one of the RegEx patterns in Abide.options.patterns
     * @returns {Boolean} Boolean value depends on whether or not the input value matches the pattern specified
     */

  }, {
    key: 'validateText',
    value: function validateText($el, pattern) {
      // A pattern can be passed to this function, or it will be infered from the input's "pattern" attribute, or it's "type" attribute
      pattern = pattern || $el.attr('pattern') || $el.attr('type');
      var inputText = $el.val();
      var valid = false;

      if (inputText.length) {
        // If the pattern attribute on the element is in Abide's list of patterns, then test that regexp
        if (this.options.patterns.hasOwnProperty(pattern)) {
          valid = this.options.patterns[pattern].test(inputText);
        }
        // If the pattern name isn't also the type attribute of the field, then test it as a regexp
        else if (pattern !== $el.attr('type')) {
            valid = new RegExp(pattern).test(inputText);
          } else {
            valid = true;
          }
      }
      // An empty field is valid if it's not required
      else if (!$el.prop('required')) {
          valid = true;
        }

      return valid;
    }

    /**
     * Determines whether or a not a radio input is valid based on whether or not it is required and selected. Although the function targets a single `<input>`, it validates by checking the `required` and `checked` properties of all radio buttons in its group.
     * @param {String} groupName - A string that specifies the name of a radio button group
     * @returns {Boolean} Boolean value depends on whether or not at least one radio input has been selected (if it's required)
     */

  }, {
    key: 'validateRadio',
    value: function validateRadio(groupName) {
      // If at least one radio in the group has the `required` attribute, the group is considered required
      // Per W3C spec, all radio buttons in a group should have `required`, but we're being nice
      var $group = this.$element.find(':radio[name="' + groupName + '"]');
      var valid = false,
          required = false;

      // For the group to be required, at least one radio needs to be required
      $group.each(function (i, e) {
        if ((0, _jquery2.default)(e).attr('required')) {
          required = true;
        }
      });
      if (!required) valid = true;

      if (!valid) {
        // For the group to be valid, at least one radio needs to be checked
        $group.each(function (i, e) {
          if ((0, _jquery2.default)(e).prop('checked')) {
            valid = true;
          }
        });
      };

      return valid;
    }

    /**
     * Determines if a selected input passes a custom validation function. Multiple validations can be used, if passed to the element with `data-validator="foo bar baz"` in a space separated listed.
     * @param {Object} $el - jQuery input element.
     * @param {String} validators - a string of function names matching functions in the Abide.options.validators object.
     * @param {Boolean} required - self explanatory?
     * @returns {Boolean} - true if validations passed.
     */

  }, {
    key: 'matchValidation',
    value: function matchValidation($el, validators, required) {
      var _this5 = this;

      required = required ? true : false;

      var clear = validators.split(' ').map(function (v) {
        return _this5.options.validators[v]($el, required, $el.parent());
      });
      return clear.indexOf(false) === -1;
    }

    /**
     * Resets form inputs and styles
     * @fires Abide#formreset
     */

  }, {
    key: 'resetForm',
    value: function resetForm() {
      var $form = this.$element,
          opts = this.options;

      (0, _jquery2.default)('.' + opts.labelErrorClass, $form).not('small').removeClass(opts.labelErrorClass);
      (0, _jquery2.default)('.' + opts.inputErrorClass, $form).not('small').removeClass(opts.inputErrorClass);
      (0, _jquery2.default)(opts.formErrorSelector + '.' + opts.formErrorClass).removeClass(opts.formErrorClass);
      $form.find('[data-abide-error]').css('display', 'none');
      (0, _jquery2.default)(':input', $form).not(':button, :submit, :reset, :hidden, :radio, :checkbox, [data-abide-ignore]').val('').removeAttr('data-invalid');
      (0, _jquery2.default)(':input:radio', $form).not('[data-abide-ignore]').prop('checked', false).removeAttr('data-invalid');
      (0, _jquery2.default)(':input:checkbox', $form).not('[data-abide-ignore]').prop('checked', false).removeAttr('data-invalid');
      /**
       * Fires when the form has been reset.
       * @event Abide#formreset
       */
      $form.trigger('formreset.zf.abide', [$form]);
    }

    /**
     * Destroys an instance of Abide.
     * Removes error styles and classes from elements, without resetting their values.
     */

  }, {
    key: '_destroy',
    value: function _destroy() {
      var _this = this;
      this.$element.off('.abide').find('[data-abide-error]').css('display', 'none');

      this.$inputs.off('.abide').each(function () {
        _this.removeErrorClasses((0, _jquery2.default)(this));
      });
    }
  }]);

  return Abide;
}(_foundation.Plugin);

/**
 * Default settings for plugin
 */


Abide.defaults = {
  /**
   * The default event to validate inputs. Checkboxes and radios validate immediately.
   * Remove or change this value for manual validation.
   * @option
   * @type {?string}
   * @default 'fieldChange'
   */
  validateOn: 'fieldChange',

  /**
   * Class to be applied to input labels on failed validation.
   * @option
   * @type {string}
   * @default 'is-invalid-label'
   */
  labelErrorClass: 'is-invalid-label',

  /**
   * Class to be applied to inputs on failed validation.
   * @option
   * @type {string}
   * @default 'is-invalid-input'
   */
  inputErrorClass: 'is-invalid-input',

  /**
   * Class selector to use to target Form Errors for show/hide.
   * @option
   * @type {string}
   * @default '.form-error'
   */
  formErrorSelector: '.form-error',

  /**
   * Class added to Form Errors on failed validation.
   * @option
   * @type {string}
   * @default 'is-visible'
   */
  formErrorClass: 'is-visible',

  /**
   * Set to true to validate text inputs on any value change.
   * @option
   * @type {boolean}
   * @default false
   */
  liveValidate: false,

  /**
   * Set to true to validate inputs on blur.
   * @option
   * @type {boolean}
   * @default false
   */
  validateOnBlur: false,

  patterns: {
    alpha: /^[a-zA-Z]+$/,
    alpha_numeric: /^[a-zA-Z0-9]+$/,
    integer: /^[-+]?\d+$/,
    number: /^[-+]?\d*(?:[\.\,]\d+)?$/,

    // amex, visa, diners
    card: /^(?:4[0-9]{12}(?:[0-9]{3})?|5[1-5][0-9]{14}|(?:222[1-9]|2[3-6][0-9]{2}|27[0-1][0-9]|2720)[0-9]{12}|6(?:011|5[0-9][0-9])[0-9]{12}|3[47][0-9]{13}|3(?:0[0-5]|[68][0-9])[0-9]{11}|(?:2131|1800|35\d{3})\d{11})$/,
    cvv: /^([0-9]){3,4}$/,

    // http://www.whatwg.org/specs/web-apps/current-work/multipage/states-of-the-type-attribute.html#valid-e-mail-address
    email: /^[a-zA-Z0-9.!#$%&'*+\/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)+$/,

    url: /^(https?|ftp|file|ssh):\/\/(((([a-zA-Z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-zA-Z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-zA-Z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-zA-Z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-zA-Z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-zA-Z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-zA-Z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-zA-Z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-zA-Z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-zA-Z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)+(\/(([a-zA-Z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-zA-Z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(\#((([a-zA-Z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/,
    // abc.de
    domain: /^([a-zA-Z0-9]([a-zA-Z0-9\-]{0,61}[a-zA-Z0-9])?\.)+[a-zA-Z]{2,8}$/,

    datetime: /^([0-2][0-9]{3})\-([0-1][0-9])\-([0-3][0-9])T([0-5][0-9])\:([0-5][0-9])\:([0-5][0-9])(Z|([\-\+]([0-1][0-9])\:00))$/,
    // YYYY-MM-DD
    date: /(?:19|20)[0-9]{2}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1[0-9]|2[0-9])|(?:(?!02)(?:0[1-9]|1[0-2])-(?:30))|(?:(?:0[13578]|1[02])-31))$/,
    // HH:MM:SS
    time: /^(0[0-9]|1[0-9]|2[0-3])(:[0-5][0-9]){2}$/,
    dateISO: /^\d{4}[\/\-]\d{1,2}[\/\-]\d{1,2}$/,
    // MM/DD/YYYY
    month_day_year: /^(0[1-9]|1[012])[- \/.](0[1-9]|[12][0-9]|3[01])[- \/.]\d{4}$/,
    // DD/MM/YYYY
    day_month_year: /^(0[1-9]|[12][0-9]|3[01])[- \/.](0[1-9]|1[012])[- \/.]\d{4}$/,

    // #FFF or #FFFFFF
    color: /^#?([a-fA-F0-9]{6}|[a-fA-F0-9]{3})$/,

    // Domain || URL
    website: {
      test: function test(text) {
        return Abide.defaults.patterns['domain'].test(text) || Abide.defaults.patterns['url'].test(text);
      }
    }
  },

  /**
   * Optional validation functions to be used. `equalTo` being the only default included function.
   * Functions should return only a boolean if the input is valid or not. Functions are given the following arguments:
   * el : The jQuery element to validate.
   * required : Boolean value of the required attribute be present or not.
   * parent : The direct parent of the input.
   * @option
   */
  validators: {
    equalTo: function equalTo(el, required, parent) {
      return (0, _jquery2.default)('#' + el.attr('data-equalto')).val() === el.val();
    }
  }
};

exports.Abide = Abide;

/***/ }),
/* 25 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Dropdown = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _foundationUtil = __webpack_require__(4);

var _foundationUtil2 = __webpack_require__(1);

var _foundation = __webpack_require__(15);

var _foundationUtil3 = __webpack_require__(5);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * Dropdown module.
 * @module foundation.dropdown
 * @requires foundation.util.keyboard
 * @requires foundation.util.box
 * @requires foundation.util.triggers
 */
var Dropdown = function (_Positionable) {
  _inherits(Dropdown, _Positionable);

  function Dropdown() {
    _classCallCheck(this, Dropdown);

    return _possibleConstructorReturn(this, (Dropdown.__proto__ || Object.getPrototypeOf(Dropdown)).apply(this, arguments));
  }

  _createClass(Dropdown, [{
    key: '_setup',

    /**
     * Creates a new instance of a dropdown.
     * @class
     * @name Dropdown
     * @param {jQuery} element - jQuery object to make into a dropdown.
     *        Object should be of the dropdown panel, rather than its anchor.
     * @param {Object} options - Overrides to the default plugin settings.
     */
    value: function _setup(element, options) {
      this.$element = element;
      this.options = _jquery2.default.extend({}, Dropdown.defaults, this.$element.data(), options);
      this.className = 'Dropdown'; // ie9 back compat

      // Triggers init is idempotent, just need to make sure it is initialized
      _foundationUtil3.Triggers.init(_jquery2.default);

      this._init();

      _foundationUtil.Keyboard.register('Dropdown', {
        'ENTER': 'open',
        'SPACE': 'open',
        'ESCAPE': 'close'
      });
    }

    /**
     * Initializes the plugin by setting/checking options and attributes, adding helper variables, and saving the anchor.
     * @function
     * @private
     */

  }, {
    key: '_init',
    value: function _init() {
      var $id = this.$element.attr('id');

      this.$anchors = (0, _jquery2.default)('[data-toggle="' + $id + '"]').length ? (0, _jquery2.default)('[data-toggle="' + $id + '"]') : (0, _jquery2.default)('[data-open="' + $id + '"]');
      this.$anchors.attr({
        'aria-controls': $id,
        'data-is-focus': false,
        'data-yeti-box': $id,
        'aria-haspopup': true,
        'aria-expanded': false
      });

      this._setCurrentAnchor(this.$anchors.first());

      if (this.options.parentClass) {
        this.$parent = this.$element.parents('.' + this.options.parentClass);
      } else {
        this.$parent = null;
      }

      this.$element.attr({
        'aria-hidden': 'true',
        'data-yeti-box': $id,
        'data-resize': $id,
        'aria-labelledby': this.$currentAnchor.id || (0, _foundationUtil2.GetYoDigits)(6, 'dd-anchor')
      });
      _get(Dropdown.prototype.__proto__ || Object.getPrototypeOf(Dropdown.prototype), '_init', this).call(this);
      this._events();
    }
  }, {
    key: '_getDefaultPosition',
    value: function _getDefaultPosition() {
      // handle legacy classnames
      var position = this.$element[0].className.match(/(top|left|right|bottom)/g);
      if (position) {
        return position[0];
      } else {
        return 'bottom';
      }
    }
  }, {
    key: '_getDefaultAlignment',
    value: function _getDefaultAlignment() {
      // handle legacy float approach
      var horizontalPosition = /float-(\S+)/.exec(this.$currentAnchor.className);
      if (horizontalPosition) {
        return horizontalPosition[1];
      }

      return _get(Dropdown.prototype.__proto__ || Object.getPrototypeOf(Dropdown.prototype), '_getDefaultAlignment', this).call(this);
    }

    /**
     * Sets the position and orientation of the dropdown pane, checks for collisions if allow-overlap is not true.
     * Recursively calls itself if a collision is detected, with a new position class.
     * @function
     * @private
     */

  }, {
    key: '_setPosition',
    value: function _setPosition() {
      _get(Dropdown.prototype.__proto__ || Object.getPrototypeOf(Dropdown.prototype), '_setPosition', this).call(this, this.$currentAnchor, this.$element, this.$parent);
    }

    /**
     * Make it a current anchor.
     * Current anchor as the reference for the position of Dropdown panes.
     * @param {HTML} el - DOM element of the anchor.
     * @function
     * @private
     */

  }, {
    key: '_setCurrentAnchor',
    value: function _setCurrentAnchor(el) {
      this.$currentAnchor = (0, _jquery2.default)(el);
    }

    /**
     * Adds event listeners to the element utilizing the triggers utility library.
     * @function
     * @private
     */

  }, {
    key: '_events',
    value: function _events() {
      var _this = this;
      this.$element.on({
        'open.zf.trigger': this.open.bind(this),
        'close.zf.trigger': this.close.bind(this),
        'toggle.zf.trigger': this.toggle.bind(this),
        'resizeme.zf.trigger': this._setPosition.bind(this)
      });

      this.$anchors.off('click.zf.trigger').on('click.zf.trigger', function () {
        _this._setCurrentAnchor(this);
      });

      if (this.options.hover) {
        this.$anchors.off('mouseenter.zf.dropdown mouseleave.zf.dropdown').on('mouseenter.zf.dropdown', function () {
          _this._setCurrentAnchor(this);

          var bodyData = (0, _jquery2.default)('body').data();
          if (typeof bodyData.whatinput === 'undefined' || bodyData.whatinput === 'mouse') {
            clearTimeout(_this.timeout);
            _this.timeout = setTimeout(function () {
              _this.open();
              _this.$anchors.data('hover', true);
            }, _this.options.hoverDelay);
          }
        }).on('mouseleave.zf.dropdown', function () {
          clearTimeout(_this.timeout);
          _this.timeout = setTimeout(function () {
            _this.close();
            _this.$anchors.data('hover', false);
          }, _this.options.hoverDelay);
        });
        if (this.options.hoverPane) {
          this.$element.off('mouseenter.zf.dropdown mouseleave.zf.dropdown').on('mouseenter.zf.dropdown', function () {
            clearTimeout(_this.timeout);
          }).on('mouseleave.zf.dropdown', function () {
            clearTimeout(_this.timeout);
            _this.timeout = setTimeout(function () {
              _this.close();
              _this.$anchors.data('hover', false);
            }, _this.options.hoverDelay);
          });
        }
      }
      this.$anchors.add(this.$element).on('keydown.zf.dropdown', function (e) {

        var $target = (0, _jquery2.default)(this),
            visibleFocusableElements = _foundationUtil.Keyboard.findFocusable(_this.$element);

        _foundationUtil.Keyboard.handleKey(e, 'Dropdown', {
          open: function open() {
            if ($target.is(_this.$anchors)) {
              _this.open();
              _this.$element.attr('tabindex', -1).focus();
              e.preventDefault();
            }
          },
          close: function close() {
            _this.close();
            _this.$anchors.focus();
          }
        });
      });
    }

    /**
     * Adds an event handler to the body to close any dropdowns on a click.
     * @function
     * @private
     */

  }, {
    key: '_addBodyHandler',
    value: function _addBodyHandler() {
      var $body = (0, _jquery2.default)(document.body).not(this.$element),
          _this = this;
      $body.off('click.zf.dropdown').on('click.zf.dropdown', function (e) {
        if (_this.$anchors.is(e.target) || _this.$anchors.find(e.target).length) {
          return;
        }
        if (_this.$element.find(e.target).length) {
          return;
        }
        _this.close();
        $body.off('click.zf.dropdown');
      });
    }

    /**
     * Opens the dropdown pane, and fires a bubbling event to close other dropdowns.
     * @function
     * @fires Dropdown#closeme
     * @fires Dropdown#show
     */

  }, {
    key: 'open',
    value: function open() {
      // var _this = this;
      /**
       * Fires to close other open dropdowns, typically when dropdown is opening
       * @event Dropdown#closeme
       */
      this.$element.trigger('closeme.zf.dropdown', this.$element.attr('id'));
      this.$anchors.addClass('hover').attr({ 'aria-expanded': true });
      // this.$element/*.show()*/;

      this.$element.addClass('is-opening');
      this._setPosition();
      this.$element.removeClass('is-opening').addClass('is-open').attr({ 'aria-hidden': false });

      if (this.options.autoFocus) {
        var $focusable = _foundationUtil.Keyboard.findFocusable(this.$element);
        if ($focusable.length) {
          $focusable.eq(0).focus();
        }
      }

      if (this.options.closeOnClick) {
        this._addBodyHandler();
      }

      if (this.options.trapFocus) {
        _foundationUtil.Keyboard.trapFocus(this.$element);
      }

      /**
       * Fires once the dropdown is visible.
       * @event Dropdown#show
       */
      this.$element.trigger('show.zf.dropdown', [this.$element]);
    }

    /**
     * Closes the open dropdown pane.
     * @function
     * @fires Dropdown#hide
     */

  }, {
    key: 'close',
    value: function close() {
      if (!this.$element.hasClass('is-open')) {
        return false;
      }
      this.$element.removeClass('is-open').attr({ 'aria-hidden': true });

      this.$anchors.removeClass('hover').attr('aria-expanded', false);

      /**
       * Fires once the dropdown is no longer visible.
       * @event Dropdown#hide
       */
      this.$element.trigger('hide.zf.dropdown', [this.$element]);

      if (this.options.trapFocus) {
        _foundationUtil.Keyboard.releaseFocus(this.$element);
      }
    }

    /**
     * Toggles the dropdown pane's visibility.
     * @function
     */

  }, {
    key: 'toggle',
    value: function toggle() {
      if (this.$element.hasClass('is-open')) {
        if (this.$anchors.data('hover')) return;
        this.close();
      } else {
        this.open();
      }
    }

    /**
     * Destroys the dropdown.
     * @function
     */

  }, {
    key: '_destroy',
    value: function _destroy() {
      this.$element.off('.zf.trigger').hide();
      this.$anchors.off('.zf.dropdown');
      (0, _jquery2.default)(document.body).off('click.zf.dropdown');
    }
  }]);

  return Dropdown;
}(_foundation.Positionable);

Dropdown.defaults = {
  /**
   * Class that designates bounding container of Dropdown (default: window)
   * @option
   * @type {?string}
   * @default null
   */
  parentClass: null,
  /**
   * Amount of time to delay opening a submenu on hover event.
   * @option
   * @type {number}
   * @default 250
   */
  hoverDelay: 250,
  /**
   * Allow submenus to open on hover events
   * @option
   * @type {boolean}
   * @default false
   */
  hover: false,
  /**
   * Don't close dropdown when hovering over dropdown pane
   * @option
   * @type {boolean}
   * @default false
   */
  hoverPane: false,
  /**
   * Number of pixels between the dropdown pane and the triggering element on open.
   * @option
   * @type {number}
   * @default 0
   */
  vOffset: 0,
  /**
   * Number of pixels between the dropdown pane and the triggering element on open.
   * @option
   * @type {number}
   * @default 0
   */
  hOffset: 0,
  /**
   * DEPRECATED: Class applied to adjust open position.
   * @option
   * @type {string}
   * @default ''
   */
  positionClass: '',

  /**
   * Position of dropdown. Can be left, right, bottom, top, or auto.
   * @option
   * @type {string}
   * @default 'auto'
   */
  position: 'auto',
  /**
   * Alignment of dropdown relative to anchor. Can be left, right, bottom, top, center, or auto.
   * @option
   * @type {string}
   * @default 'auto'
   */
  alignment: 'auto',
  /**
   * Allow overlap of container/window. If false, dropdown will first try to position as defined by data-position and data-alignment, but reposition if it would cause an overflow.
   * @option
   * @type {boolean}
   * @default false
   */
  allowOverlap: false,
  /**
   * Allow overlap of only the bottom of the container. This is the most common
   * behavior for dropdowns, allowing the dropdown to extend the bottom of the
   * screen but not otherwise influence or break out of the container.
   * @option
   * @type {boolean}
   * @default true
   */
  allowBottomOverlap: true,
  /**
   * Allow the plugin to trap focus to the dropdown pane if opened with keyboard commands.
   * @option
   * @type {boolean}
   * @default false
   */
  trapFocus: false,
  /**
   * Allow the plugin to set focus to the first focusable element within the pane, regardless of method of opening.
   * @option
   * @type {boolean}
   * @default false
   */
  autoFocus: false,
  /**
   * Allows a click on the body to close the dropdown.
   * @option
   * @type {boolean}
   * @default false
   */
  closeOnClick: false
};

exports.Dropdown = Dropdown;

/***/ }),
/* 26 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Equalizer = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _foundationUtil = __webpack_require__(3);

var _foundationUtil2 = __webpack_require__(8);

var _foundationUtil3 = __webpack_require__(1);

var _foundation = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * Equalizer module.
 * @module foundation.equalizer
 * @requires foundation.util.mediaQuery
 * @requires foundation.util.imageLoader if equalizer contains images
 */

var Equalizer = function (_Plugin) {
  _inherits(Equalizer, _Plugin);

  function Equalizer() {
    _classCallCheck(this, Equalizer);

    return _possibleConstructorReturn(this, (Equalizer.__proto__ || Object.getPrototypeOf(Equalizer)).apply(this, arguments));
  }

  _createClass(Equalizer, [{
    key: '_setup',

    /**
     * Creates a new instance of Equalizer.
     * @class
     * @name Equalizer
     * @fires Equalizer#init
     * @param {Object} element - jQuery object to add the trigger to.
     * @param {Object} options - Overrides to the default plugin settings.
     */
    value: function _setup(element, options) {
      this.$element = element;
      this.options = _jquery2.default.extend({}, Equalizer.defaults, this.$element.data(), options);
      this.className = 'Equalizer'; // ie9 back compat

      this._init();
    }

    /**
     * Initializes the Equalizer plugin and calls functions to get equalizer functioning on load.
     * @private
     */

  }, {
    key: '_init',
    value: function _init() {
      var eqId = this.$element.attr('data-equalizer') || '';
      var $watched = this.$element.find('[data-equalizer-watch="' + eqId + '"]');

      _foundationUtil.MediaQuery._init();

      this.$watched = $watched.length ? $watched : this.$element.find('[data-equalizer-watch]');
      this.$element.attr('data-resize', eqId || (0, _foundationUtil3.GetYoDigits)(6, 'eq'));
      this.$element.attr('data-mutate', eqId || (0, _foundationUtil3.GetYoDigits)(6, 'eq'));

      this.hasNested = this.$element.find('[data-equalizer]').length > 0;
      this.isNested = this.$element.parentsUntil(document.body, '[data-equalizer]').length > 0;
      this.isOn = false;
      this._bindHandler = {
        onResizeMeBound: this._onResizeMe.bind(this),
        onPostEqualizedBound: this._onPostEqualized.bind(this)
      };

      var imgs = this.$element.find('img');
      var tooSmall;
      if (this.options.equalizeOn) {
        tooSmall = this._checkMQ();
        (0, _jquery2.default)(window).on('changed.zf.mediaquery', this._checkMQ.bind(this));
      } else {
        this._events();
      }
      if (tooSmall !== undefined && tooSmall === false || tooSmall === undefined) {
        if (imgs.length) {
          (0, _foundationUtil2.onImagesLoaded)(imgs, this._reflow.bind(this));
        } else {
          this._reflow();
        }
      }
    }

    /**
     * Removes event listeners if the breakpoint is too small.
     * @private
     */

  }, {
    key: '_pauseEvents',
    value: function _pauseEvents() {
      this.isOn = false;
      this.$element.off({
        '.zf.equalizer': this._bindHandler.onPostEqualizedBound,
        'resizeme.zf.trigger': this._bindHandler.onResizeMeBound,
        'mutateme.zf.trigger': this._bindHandler.onResizeMeBound
      });
    }

    /**
     * function to handle $elements resizeme.zf.trigger, with bound this on _bindHandler.onResizeMeBound
     * @private
     */

  }, {
    key: '_onResizeMe',
    value: function _onResizeMe(e) {
      this._reflow();
    }

    /**
     * function to handle $elements postequalized.zf.equalizer, with bound this on _bindHandler.onPostEqualizedBound
     * @private
     */

  }, {
    key: '_onPostEqualized',
    value: function _onPostEqualized(e) {
      if (e.target !== this.$element[0]) {
        this._reflow();
      }
    }

    /**
     * Initializes events for Equalizer.
     * @private
     */

  }, {
    key: '_events',
    value: function _events() {
      var _this = this;
      this._pauseEvents();
      if (this.hasNested) {
        this.$element.on('postequalized.zf.equalizer', this._bindHandler.onPostEqualizedBound);
      } else {
        this.$element.on('resizeme.zf.trigger', this._bindHandler.onResizeMeBound);
        this.$element.on('mutateme.zf.trigger', this._bindHandler.onResizeMeBound);
      }
      this.isOn = true;
    }

    /**
     * Checks the current breakpoint to the minimum required size.
     * @private
     */

  }, {
    key: '_checkMQ',
    value: function _checkMQ() {
      var tooSmall = !_foundationUtil.MediaQuery.is(this.options.equalizeOn);
      if (tooSmall) {
        if (this.isOn) {
          this._pauseEvents();
          this.$watched.css('height', 'auto');
        }
      } else {
        if (!this.isOn) {
          this._events();
        }
      }
      return tooSmall;
    }

    /**
     * A noop version for the plugin
     * @private
     */

  }, {
    key: '_killswitch',
    value: function _killswitch() {
      return;
    }

    /**
     * Calls necessary functions to update Equalizer upon DOM change
     * @private
     */

  }, {
    key: '_reflow',
    value: function _reflow() {
      if (!this.options.equalizeOnStack) {
        if (this._isStacked()) {
          this.$watched.css('height', 'auto');
          return false;
        }
      }
      if (this.options.equalizeByRow) {
        this.getHeightsByRow(this.applyHeightByRow.bind(this));
      } else {
        this.getHeights(this.applyHeight.bind(this));
      }
    }

    /**
     * Manually determines if the first 2 elements are *NOT* stacked.
     * @private
     */

  }, {
    key: '_isStacked',
    value: function _isStacked() {
      if (!this.$watched[0] || !this.$watched[1]) {
        return true;
      }
      return this.$watched[0].getBoundingClientRect().top !== this.$watched[1].getBoundingClientRect().top;
    }

    /**
     * Finds the outer heights of children contained within an Equalizer parent and returns them in an array
     * @param {Function} cb - A non-optional callback to return the heights array to.
     * @returns {Array} heights - An array of heights of children within Equalizer container
     */

  }, {
    key: 'getHeights',
    value: function getHeights(cb) {
      var heights = [];
      for (var i = 0, len = this.$watched.length; i < len; i++) {
        this.$watched[i].style.height = 'auto';
        heights.push(this.$watched[i].offsetHeight);
      }
      cb(heights);
    }

    /**
     * Finds the outer heights of children contained within an Equalizer parent and returns them in an array
     * @param {Function} cb - A non-optional callback to return the heights array to.
     * @returns {Array} groups - An array of heights of children within Equalizer container grouped by row with element,height and max as last child
     */

  }, {
    key: 'getHeightsByRow',
    value: function getHeightsByRow(cb) {
      var lastElTopOffset = this.$watched.length ? this.$watched.first().offset().top : 0,
          groups = [],
          group = 0;
      //group by Row
      groups[group] = [];
      for (var i = 0, len = this.$watched.length; i < len; i++) {
        this.$watched[i].style.height = 'auto';
        //maybe could use this.$watched[i].offsetTop
        var elOffsetTop = (0, _jquery2.default)(this.$watched[i]).offset().top;
        if (elOffsetTop != lastElTopOffset) {
          group++;
          groups[group] = [];
          lastElTopOffset = elOffsetTop;
        }
        groups[group].push([this.$watched[i], this.$watched[i].offsetHeight]);
      }

      for (var j = 0, ln = groups.length; j < ln; j++) {
        var heights = (0, _jquery2.default)(groups[j]).map(function () {
          return this[1];
        }).get();
        var max = Math.max.apply(null, heights);
        groups[j].push(max);
      }
      cb(groups);
    }

    /**
     * Changes the CSS height property of each child in an Equalizer parent to match the tallest
     * @param {array} heights - An array of heights of children within Equalizer container
     * @fires Equalizer#preequalized
     * @fires Equalizer#postequalized
     */

  }, {
    key: 'applyHeight',
    value: function applyHeight(heights) {
      var max = Math.max.apply(null, heights);
      /**
       * Fires before the heights are applied
       * @event Equalizer#preequalized
       */
      this.$element.trigger('preequalized.zf.equalizer');

      this.$watched.css('height', max);

      /**
       * Fires when the heights have been applied
       * @event Equalizer#postequalized
       */
      this.$element.trigger('postequalized.zf.equalizer');
    }

    /**
     * Changes the CSS height property of each child in an Equalizer parent to match the tallest by row
     * @param {array} groups - An array of heights of children within Equalizer container grouped by row with element,height and max as last child
     * @fires Equalizer#preequalized
     * @fires Equalizer#preequalizedrow
     * @fires Equalizer#postequalizedrow
     * @fires Equalizer#postequalized
     */

  }, {
    key: 'applyHeightByRow',
    value: function applyHeightByRow(groups) {
      /**
       * Fires before the heights are applied
       */
      this.$element.trigger('preequalized.zf.equalizer');
      for (var i = 0, len = groups.length; i < len; i++) {
        var groupsILength = groups[i].length,
            max = groups[i][groupsILength - 1];
        if (groupsILength <= 2) {
          (0, _jquery2.default)(groups[i][0][0]).css({ 'height': 'auto' });
          continue;
        }
        /**
          * Fires before the heights per row are applied
          * @event Equalizer#preequalizedrow
          */
        this.$element.trigger('preequalizedrow.zf.equalizer');
        for (var j = 0, lenJ = groupsILength - 1; j < lenJ; j++) {
          (0, _jquery2.default)(groups[i][j][0]).css({ 'height': max });
        }
        /**
          * Fires when the heights per row have been applied
          * @event Equalizer#postequalizedrow
          */
        this.$element.trigger('postequalizedrow.zf.equalizer');
      }
      /**
       * Fires when the heights have been applied
       */
      this.$element.trigger('postequalized.zf.equalizer');
    }

    /**
     * Destroys an instance of Equalizer.
     * @function
     */

  }, {
    key: '_destroy',
    value: function _destroy() {
      this._pauseEvents();
      this.$watched.css('height', 'auto');
    }
  }]);

  return Equalizer;
}(_foundation.Plugin);

/**
 * Default settings for plugin
 */


Equalizer.defaults = {
  /**
   * Enable height equalization when stacked on smaller screens.
   * @option
   * @type {boolean}
   * @default false
   */
  equalizeOnStack: false,
  /**
   * Enable height equalization row by row.
   * @option
   * @type {boolean}
   * @default false
   */
  equalizeByRow: false,
  /**
   * String representing the minimum breakpoint size the plugin should equalize heights on.
   * @option
   * @type {string}
   * @default ''
   */
  equalizeOn: ''
};

exports.Equalizer = Equalizer;

/***/ }),
/* 27 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Interchange = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _foundationUtil = __webpack_require__(3);

var _foundation = __webpack_require__(2);

var _foundationUtil2 = __webpack_require__(1);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * Interchange module.
 * @module foundation.interchange
 * @requires foundation.util.mediaQuery
 */

var Interchange = function (_Plugin) {
  _inherits(Interchange, _Plugin);

  function Interchange() {
    _classCallCheck(this, Interchange);

    return _possibleConstructorReturn(this, (Interchange.__proto__ || Object.getPrototypeOf(Interchange)).apply(this, arguments));
  }

  _createClass(Interchange, [{
    key: '_setup',

    /**
     * Creates a new instance of Interchange.
     * @class
     * @name Interchange
     * @fires Interchange#init
     * @param {Object} element - jQuery object to add the trigger to.
     * @param {Object} options - Overrides to the default plugin settings.
     */
    value: function _setup(element, options) {
      this.$element = element;
      this.options = _jquery2.default.extend({}, Interchange.defaults, options);
      this.rules = [];
      this.currentPath = '';
      this.className = 'Interchange'; // ie9 back compat

      this._init();
      this._events();
    }

    /**
     * Initializes the Interchange plugin and calls functions to get interchange functioning on load.
     * @function
     * @private
     */

  }, {
    key: '_init',
    value: function _init() {
      _foundationUtil.MediaQuery._init();

      var id = this.$element[0].id || (0, _foundationUtil2.GetYoDigits)(6, 'interchange');
      this.$element.attr({
        'data-resize': id,
        'id': id
      });

      this._addBreakpoints();
      this._generateRules();
      this._reflow();
    }

    /**
     * Initializes events for Interchange.
     * @function
     * @private
     */

  }, {
    key: '_events',
    value: function _events() {
      var _this3 = this;

      this.$element.off('resizeme.zf.trigger').on('resizeme.zf.trigger', function () {
        return _this3._reflow();
      });
    }

    /**
     * Calls necessary functions to update Interchange upon DOM change
     * @function
     * @private
     */

  }, {
    key: '_reflow',
    value: function _reflow() {
      var match;

      // Iterate through each rule, but only save the last match
      for (var i in this.rules) {
        if (this.rules.hasOwnProperty(i)) {
          var rule = this.rules[i];
          if (window.matchMedia(rule.query).matches) {
            match = rule;
          }
        }
      }

      if (match) {
        this.replace(match.path);
      }
    }

    /**
     * Gets the Foundation breakpoints and adds them to the Interchange.SPECIAL_QUERIES object.
     * @function
     * @private
     */

  }, {
    key: '_addBreakpoints',
    value: function _addBreakpoints() {
      for (var i in _foundationUtil.MediaQuery.queries) {
        if (_foundationUtil.MediaQuery.queries.hasOwnProperty(i)) {
          var query = _foundationUtil.MediaQuery.queries[i];
          Interchange.SPECIAL_QUERIES[query.name] = query.value;
        }
      }
    }

    /**
     * Checks the Interchange element for the provided media query + content pairings
     * @function
     * @private
     * @param {Object} element - jQuery object that is an Interchange instance
     * @returns {Array} scenarios - Array of objects that have 'mq' and 'path' keys with corresponding keys
     */

  }, {
    key: '_generateRules',
    value: function _generateRules(element) {
      var rulesList = [];
      var rules;

      if (this.options.rules) {
        rules = this.options.rules;
      } else {
        rules = this.$element.data('interchange');
      }

      rules = typeof rules === 'string' ? rules.match(/\[.*?\]/g) : rules;

      for (var i in rules) {
        if (rules.hasOwnProperty(i)) {
          var rule = rules[i].slice(1, -1).split(', ');
          var path = rule.slice(0, -1).join('');
          var query = rule[rule.length - 1];

          if (Interchange.SPECIAL_QUERIES[query]) {
            query = Interchange.SPECIAL_QUERIES[query];
          }

          rulesList.push({
            path: path,
            query: query
          });
        }
      }

      this.rules = rulesList;
    }

    /**
     * Update the `src` property of an image, or change the HTML of a container, to the specified path.
     * @function
     * @param {String} path - Path to the image or HTML partial.
     * @fires Interchange#replaced
     */

  }, {
    key: 'replace',
    value: function replace(path) {
      if (this.currentPath === path) return;

      var _this = this,
          trigger = 'replaced.zf.interchange';

      // Replacing images
      if (this.$element[0].nodeName === 'IMG') {
        this.$element.attr('src', path).on('load', function () {
          _this.currentPath = path;
        }).trigger(trigger);
      }
      // Replacing background images
      else if (path.match(/\.(gif|jpg|jpeg|png|svg|tiff)([?#].*)?/i)) {
          path = path.replace(/\(/g, '%28').replace(/\)/g, '%29');
          this.$element.css({ 'background-image': 'url(' + path + ')' }).trigger(trigger);
        }
        // Replacing HTML
        else {
            _jquery2.default.get(path, function (response) {
              _this.$element.html(response).trigger(trigger);
              (0, _jquery2.default)(response).foundation();
              _this.currentPath = path;
            });
          }

      /**
       * Fires when content in an Interchange element is done being loaded.
       * @event Interchange#replaced
       */
      // this.$element.trigger('replaced.zf.interchange');
    }

    /**
     * Destroys an instance of interchange.
     * @function
     */

  }, {
    key: '_destroy',
    value: function _destroy() {
      this.$element.off('resizeme.zf.trigger');
    }
  }]);

  return Interchange;
}(_foundation.Plugin);

/**
 * Default settings for plugin
 */


Interchange.defaults = {
  /**
   * Rules to be applied to Interchange elements. Set with the `data-interchange` array notation.
   * @option
   * @type {?array}
   * @default null
   */
  rules: null
};

Interchange.SPECIAL_QUERIES = {
  'landscape': 'screen and (orientation: landscape)',
  'portrait': 'screen and (orientation: portrait)',
  'retina': 'only screen and (-webkit-min-device-pixel-ratio: 2), only screen and (min--moz-device-pixel-ratio: 2), only screen and (-o-min-device-pixel-ratio: 2/1), only screen and (min-device-pixel-ratio: 2), only screen and (min-resolution: 192dpi), only screen and (min-resolution: 2dppx)'
};

exports.Interchange = Interchange;

/***/ }),
/* 28 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Magellan = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _foundationUtil = __webpack_require__(1);

var _foundation = __webpack_require__(2);

var _foundation2 = __webpack_require__(17);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * Magellan module.
 * @module foundation.magellan
 * @requires foundation.smoothScroll
 */

var Magellan = function (_Plugin) {
  _inherits(Magellan, _Plugin);

  function Magellan() {
    _classCallCheck(this, Magellan);

    return _possibleConstructorReturn(this, (Magellan.__proto__ || Object.getPrototypeOf(Magellan)).apply(this, arguments));
  }

  _createClass(Magellan, [{
    key: '_setup',

    /**
     * Creates a new instance of Magellan.
     * @class
     * @name Magellan
     * @fires Magellan#init
     * @param {Object} element - jQuery object to add the trigger to.
     * @param {Object} options - Overrides to the default plugin settings.
     */
    value: function _setup(element, options) {
      this.$element = element;
      this.options = _jquery2.default.extend({}, Magellan.defaults, this.$element.data(), options);
      this.className = 'Magellan'; // ie9 back compat

      this._init();
      this.calcPoints();
    }

    /**
     * Initializes the Magellan plugin and calls functions to get equalizer functioning on load.
     * @private
     */

  }, {
    key: '_init',
    value: function _init() {
      var id = this.$element[0].id || (0, _foundationUtil.GetYoDigits)(6, 'magellan');
      var _this = this;
      this.$targets = (0, _jquery2.default)('[data-magellan-target]');
      this.$links = this.$element.find('a');
      this.$element.attr({
        'data-resize': id,
        'data-scroll': id,
        'id': id
      });
      this.$active = (0, _jquery2.default)();
      this.scrollPos = parseInt(window.pageYOffset, 10);

      this._events();
    }

    /**
     * Calculates an array of pixel values that are the demarcation lines between locations on the page.
     * Can be invoked if new elements are added or the size of a location changes.
     * @function
     */

  }, {
    key: 'calcPoints',
    value: function calcPoints() {
      var _this = this,
          body = document.body,
          html = document.documentElement;

      this.points = [];
      this.winHeight = Math.round(Math.max(window.innerHeight, html.clientHeight));
      this.docHeight = Math.round(Math.max(body.scrollHeight, body.offsetHeight, html.clientHeight, html.scrollHeight, html.offsetHeight));

      this.$targets.each(function () {
        var $tar = (0, _jquery2.default)(this),
            pt = Math.round($tar.offset().top - _this.options.threshold);
        $tar.targetPoint = pt;
        _this.points.push(pt);
      });
    }

    /**
     * Initializes events for Magellan.
     * @private
     */

  }, {
    key: '_events',
    value: function _events() {
      var _this = this,
          $body = (0, _jquery2.default)('html, body'),
          opts = {
        duration: _this.options.animationDuration,
        easing: _this.options.animationEasing
      };
      (0, _jquery2.default)(window).one('load', function () {
        if (_this.options.deepLinking) {
          if (location.hash) {
            _this.scrollToLoc(location.hash);
          }
        }
        _this.calcPoints();
        _this._updateActive();
      });

      this.$element.on({
        'resizeme.zf.trigger': this.reflow.bind(this),
        'scrollme.zf.trigger': this._updateActive.bind(this)
      }).on('click.zf.magellan', 'a[href^="#"]', function (e) {
        e.preventDefault();
        var arrival = this.getAttribute('href');
        _this.scrollToLoc(arrival);
      });

      this._deepLinkScroll = function (e) {
        if (_this.options.deepLinking) {
          _this.scrollToLoc(window.location.hash);
        }
      };

      (0, _jquery2.default)(window).on('popstate', this._deepLinkScroll);
    }

    /**
     * Function to scroll to a given location on the page.
     * @param {String} loc - a properly formatted jQuery id selector. Example: '#foo'
     * @function
     */

  }, {
    key: 'scrollToLoc',
    value: function scrollToLoc(loc) {
      this._inTransition = true;
      var _this = this;

      var options = {
        animationEasing: this.options.animationEasing,
        animationDuration: this.options.animationDuration,
        threshold: this.options.threshold,
        offset: this.options.offset
      };

      _foundation2.SmoothScroll.scrollToLoc(loc, options, function () {
        _this._inTransition = false;
        _this._updateActive();
      });
    }

    /**
     * Calls necessary functions to update Magellan upon DOM change
     * @function
     */

  }, {
    key: 'reflow',
    value: function reflow() {
      this.calcPoints();
      this._updateActive();
    }

    /**
     * Updates the visibility of an active location link, and updates the url hash for the page, if deepLinking enabled.
     * @private
     * @function
     * @fires Magellan#update
     */

  }, {
    key: '_updateActive',
    value: function _updateActive() /*evt, elem, scrollPos*/{
      if (this._inTransition) {
        return;
      }
      var winPos = /*scrollPos ||*/parseInt(window.pageYOffset, 10),
          curIdx;

      if (winPos + this.winHeight === this.docHeight) {
        curIdx = this.points.length - 1;
      } else if (winPos < this.points[0]) {
        curIdx = undefined;
      } else {
        var isDown = this.scrollPos < winPos,
            _this = this,
            curVisible = this.points.filter(function (p, i) {
          return isDown ? p - _this.options.offset <= winPos : p - _this.options.offset - _this.options.threshold <= winPos;
        });
        curIdx = curVisible.length ? curVisible.length - 1 : 0;
      }

      this.$active.removeClass(this.options.activeClass);
      this.$active = this.$links.filter('[href="#' + this.$targets.eq(curIdx).data('magellan-target') + '"]').addClass(this.options.activeClass);

      if (this.options.deepLinking) {
        var hash = "";
        if (curIdx != undefined) {
          hash = this.$active[0].getAttribute('href');
        }
        if (hash !== window.location.hash) {
          if (window.history.pushState) {
            window.history.pushState(null, null, hash);
          } else {
            window.location.hash = hash;
          }
        }
      }

      this.scrollPos = winPos;
      /**
       * Fires when magellan is finished updating to the new active element.
       * @event Magellan#update
       */
      this.$element.trigger('update.zf.magellan', [this.$active]);
    }

    /**
     * Destroys an instance of Magellan and resets the url of the window.
     * @function
     */

  }, {
    key: '_destroy',
    value: function _destroy() {
      this.$element.off('.zf.trigger .zf.magellan').find('.' + this.options.activeClass).removeClass(this.options.activeClass);

      if (this.options.deepLinking) {
        var hash = this.$active[0].getAttribute('href');
        window.location.hash.replace(hash, '');
      }
      (0, _jquery2.default)(window).off('popstate', this._deepLinkScroll);
    }
  }]);

  return Magellan;
}(_foundation.Plugin);

/**
 * Default settings for plugin
 */


Magellan.defaults = {
  /**
   * Amount of time, in ms, the animated scrolling should take between locations.
   * @option
   * @type {number}
   * @default 500
   */
  animationDuration: 500,
  /**
   * Animation style to use when scrolling between locations. Can be `'swing'` or `'linear'`.
   * @option
   * @type {string}
   * @default 'linear'
   * @see {@link https://api.jquery.com/animate|Jquery animate}
   */
  animationEasing: 'linear',
  /**
   * Number of pixels to use as a marker for location changes.
   * @option
   * @type {number}
   * @default 50
   */
  threshold: 50,
  /**
   * Class applied to the active locations link on the magellan container.
   * @option
   * @type {string}
   * @default 'is-active'
   */
  activeClass: 'is-active',
  /**
   * Allows the script to manipulate the url of the current page, and if supported, alter the history.
   * @option
   * @type {boolean}
   * @default false
   */
  deepLinking: false,
  /**
   * Number of pixels to offset the scroll of the page on item click if using a sticky nav bar.
   * @option
   * @type {number}
   * @default 0
   */
  offset: 0
};

exports.Magellan = Magellan;

/***/ }),
/* 29 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OffCanvas = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _foundationUtil = __webpack_require__(4);

var _foundationUtil2 = __webpack_require__(3);

var _foundationUtil3 = __webpack_require__(1);

var _foundation = __webpack_require__(2);

var _foundationUtil4 = __webpack_require__(5);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * OffCanvas module.
 * @module foundation.offcanvas
 * @requires foundation.util.keyboard
 * @requires foundation.util.mediaQuery
 * @requires foundation.util.triggers
 */

var OffCanvas = function (_Plugin) {
  _inherits(OffCanvas, _Plugin);

  function OffCanvas() {
    _classCallCheck(this, OffCanvas);

    return _possibleConstructorReturn(this, (OffCanvas.__proto__ || Object.getPrototypeOf(OffCanvas)).apply(this, arguments));
  }

  _createClass(OffCanvas, [{
    key: '_setup',

    /**
     * Creates a new instance of an off-canvas wrapper.
     * @class
     * @name OffCanvas
     * @fires OffCanvas#init
     * @param {Object} element - jQuery object to initialize.
     * @param {Object} options - Overrides to the default plugin settings.
     */
    value: function _setup(element, options) {
      var _this3 = this;

      this.className = 'OffCanvas'; // ie9 back compat
      this.$element = element;
      this.options = _jquery2.default.extend({}, OffCanvas.defaults, this.$element.data(), options);
      this.contentClasses = { base: [], reveal: [] };
      this.$lastTrigger = (0, _jquery2.default)();
      this.$triggers = (0, _jquery2.default)();
      this.position = 'left';
      this.$content = (0, _jquery2.default)();
      this.nested = !!this.options.nested;

      // Defines the CSS transition/position classes of the off-canvas content container.
      (0, _jquery2.default)(['push', 'overlap']).each(function (index, val) {
        _this3.contentClasses.base.push('has-transition-' + val);
      });
      (0, _jquery2.default)(['left', 'right', 'top', 'bottom']).each(function (index, val) {
        _this3.contentClasses.base.push('has-position-' + val);
        _this3.contentClasses.reveal.push('has-reveal-' + val);
      });

      // Triggers init is idempotent, just need to make sure it is initialized
      _foundationUtil4.Triggers.init(_jquery2.default);
      _foundationUtil2.MediaQuery._init();

      this._init();
      this._events();

      _foundationUtil.Keyboard.register('OffCanvas', {
        'ESCAPE': 'close'
      });
    }

    /**
     * Initializes the off-canvas wrapper by adding the exit overlay (if needed).
     * @function
     * @private
     */

  }, {
    key: '_init',
    value: function _init() {
      var id = this.$element.attr('id');

      this.$element.attr('aria-hidden', 'true');

      // Find off-canvas content, either by ID (if specified), by siblings or by closest selector (fallback)
      if (this.options.contentId) {
        this.$content = (0, _jquery2.default)('#' + this.options.contentId);
      } else if (this.$element.siblings('[data-off-canvas-content]').length) {
        this.$content = this.$element.siblings('[data-off-canvas-content]').first();
      } else {
        this.$content = this.$element.closest('[data-off-canvas-content]').first();
      }

      if (!this.options.contentId) {
        // Assume that the off-canvas element is nested if it isn't a sibling of the content
        this.nested = this.$element.siblings('[data-off-canvas-content]').length === 0;
      } else if (this.options.contentId && this.options.nested === null) {
        // Warning if using content ID without setting the nested option
        // Once the element is nested it is required to work properly in this case
        console.warn('Remember to use the nested option if using the content ID option!');
      }

      if (this.nested === true) {
        // Force transition overlap if nested
        this.options.transition = 'overlap';
        // Remove appropriate classes if already assigned in markup
        this.$element.removeClass('is-transition-push');
      }

      this.$element.addClass('is-transition-' + this.options.transition + ' is-closed');

      // Find triggers that affect this element and add aria-expanded to them
      this.$triggers = (0, _jquery2.default)(document).find('[data-open="' + id + '"], [data-close="' + id + '"], [data-toggle="' + id + '"]').attr('aria-expanded', 'false').attr('aria-controls', id);

      // Get position by checking for related CSS class
      this.position = this.$element.is('.position-left, .position-top, .position-right, .position-bottom') ? this.$element.attr('class').match(/position\-(left|top|right|bottom)/)[1] : this.position;

      // Add an overlay over the content if necessary
      if (this.options.contentOverlay === true) {
        var overlay = document.createElement('div');
        var overlayPosition = (0, _jquery2.default)(this.$element).css("position") === 'fixed' ? 'is-overlay-fixed' : 'is-overlay-absolute';
        overlay.setAttribute('class', 'js-off-canvas-overlay ' + overlayPosition);
        this.$overlay = (0, _jquery2.default)(overlay);
        if (overlayPosition === 'is-overlay-fixed') {
          (0, _jquery2.default)(this.$overlay).insertAfter(this.$element);
        } else {
          this.$content.append(this.$overlay);
        }
      }

      this.options.isRevealed = this.options.isRevealed || new RegExp(this.options.revealClass, 'g').test(this.$element[0].className);

      if (this.options.isRevealed === true) {
        this.options.revealOn = this.options.revealOn || this.$element[0].className.match(/(reveal-for-medium|reveal-for-large)/g)[0].split('-')[2];
        this._setMQChecker();
      }

      if (this.options.transitionTime) {
        this.$element.css('transition-duration', this.options.transitionTime);
      }

      // Initally remove all transition/position CSS classes from off-canvas content container.
      this._removeContentClasses();
    }

    /**
     * Adds event handlers to the off-canvas wrapper and the exit overlay.
     * @function
     * @private
     */

  }, {
    key: '_events',
    value: function _events() {
      this.$element.off('.zf.trigger .zf.offcanvas').on({
        'open.zf.trigger': this.open.bind(this),
        'close.zf.trigger': this.close.bind(this),
        'toggle.zf.trigger': this.toggle.bind(this),
        'keydown.zf.offcanvas': this._handleKeyboard.bind(this)
      });

      if (this.options.closeOnClick === true) {
        var $target = this.options.contentOverlay ? this.$overlay : this.$content;
        $target.on({ 'click.zf.offcanvas': this.close.bind(this) });
      }
    }

    /**
     * Applies event listener for elements that will reveal at certain breakpoints.
     * @private
     */

  }, {
    key: '_setMQChecker',
    value: function _setMQChecker() {
      var _this = this;

      (0, _jquery2.default)(window).on('changed.zf.mediaquery', function () {
        if (_foundationUtil2.MediaQuery.atLeast(_this.options.revealOn)) {
          _this.reveal(true);
        } else {
          _this.reveal(false);
        }
      }).one('load.zf.offcanvas', function () {
        if (_foundationUtil2.MediaQuery.atLeast(_this.options.revealOn)) {
          _this.reveal(true);
        }
      });
    }

    /**
     * Removes the CSS transition/position classes of the off-canvas content container.
     * Removing the classes is important when another off-canvas gets opened that uses the same content container.
     * @param {Boolean} hasReveal - true if related off-canvas element is revealed.
     * @private
     */

  }, {
    key: '_removeContentClasses',
    value: function _removeContentClasses(hasReveal) {
      if (typeof hasReveal !== 'boolean') {
        this.$content.removeClass(this.contentClasses.base.join(' '));
      } else if (hasReveal === false) {
        this.$content.removeClass('has-reveal-' + this.position);
      }
    }

    /**
     * Adds the CSS transition/position classes of the off-canvas content container, based on the opening off-canvas element.
     * Beforehand any transition/position class gets removed.
     * @param {Boolean} hasReveal - true if related off-canvas element is revealed.
     * @private
     */

  }, {
    key: '_addContentClasses',
    value: function _addContentClasses(hasReveal) {
      this._removeContentClasses(hasReveal);
      if (typeof hasReveal !== 'boolean') {
        this.$content.addClass('has-transition-' + this.options.transition + ' has-position-' + this.position);
      } else if (hasReveal === true) {
        this.$content.addClass('has-reveal-' + this.position);
      }
    }

    /**
     * Handles the revealing/hiding the off-canvas at breakpoints, not the same as open.
     * @param {Boolean} isRevealed - true if element should be revealed.
     * @function
     */

  }, {
    key: 'reveal',
    value: function reveal(isRevealed) {
      if (isRevealed) {
        this.close();
        this.isRevealed = true;
        this.$element.attr('aria-hidden', 'false');
        this.$element.off('open.zf.trigger toggle.zf.trigger');
        this.$element.removeClass('is-closed');
      } else {
        this.isRevealed = false;
        this.$element.attr('aria-hidden', 'true');
        this.$element.off('open.zf.trigger toggle.zf.trigger').on({
          'open.zf.trigger': this.open.bind(this),
          'toggle.zf.trigger': this.toggle.bind(this)
        });
        this.$element.addClass('is-closed');
      }
      this._addContentClasses(isRevealed);
    }

    /**
     * Stops scrolling of the body when offcanvas is open on mobile Safari and other troublesome browsers.
     * @private
     */

  }, {
    key: '_stopScrolling',
    value: function _stopScrolling(event) {
      return false;
    }

    // Taken and adapted from http://stackoverflow.com/questions/16889447/prevent-full-page-scrolling-ios
    // Only really works for y, not sure how to extend to x or if we need to.

  }, {
    key: '_recordScrollable',
    value: function _recordScrollable(event) {
      var elem = this; // called from event handler context with this as elem

      // If the element is scrollable (content overflows), then...
      if (elem.scrollHeight !== elem.clientHeight) {
        // If we're at the top, scroll down one pixel to allow scrolling up
        if (elem.scrollTop === 0) {
          elem.scrollTop = 1;
        }
        // If we're at the bottom, scroll up one pixel to allow scrolling down
        if (elem.scrollTop === elem.scrollHeight - elem.clientHeight) {
          elem.scrollTop = elem.scrollHeight - elem.clientHeight - 1;
        }
      }
      elem.allowUp = elem.scrollTop > 0;
      elem.allowDown = elem.scrollTop < elem.scrollHeight - elem.clientHeight;
      elem.lastY = event.originalEvent.pageY;
    }
  }, {
    key: '_stopScrollPropagation',
    value: function _stopScrollPropagation(event) {
      var elem = this; // called from event handler context with this as elem
      var up = event.pageY < elem.lastY;
      var down = !up;
      elem.lastY = event.pageY;

      if (up && elem.allowUp || down && elem.allowDown) {
        event.stopPropagation();
      } else {
        event.preventDefault();
      }
    }

    /**
     * Opens the off-canvas menu.
     * @function
     * @param {Object} event - Event object passed from listener.
     * @param {jQuery} trigger - element that triggered the off-canvas to open.
     * @fires OffCanvas#opened
     */

  }, {
    key: 'open',
    value: function open(event, trigger) {
      if (this.$element.hasClass('is-open') || this.isRevealed) {
        return;
      }
      var _this = this;

      if (trigger) {
        this.$lastTrigger = trigger;
      }

      if (this.options.forceTo === 'top') {
        window.scrollTo(0, 0);
      } else if (this.options.forceTo === 'bottom') {
        window.scrollTo(0, document.body.scrollHeight);
      }

      if (this.options.transitionTime && this.options.transition !== 'overlap') {
        this.$element.siblings('[data-off-canvas-content]').css('transition-duration', this.options.transitionTime);
      } else {
        this.$element.siblings('[data-off-canvas-content]').css('transition-duration', '');
      }

      /**
       * Fires when the off-canvas menu opens.
       * @event OffCanvas#opened
       */
      this.$element.addClass('is-open').removeClass('is-closed');

      this.$triggers.attr('aria-expanded', 'true');
      this.$element.attr('aria-hidden', 'false').trigger('opened.zf.offcanvas');

      this.$content.addClass('is-open-' + this.position);

      // If `contentScroll` is set to false, add class and disable scrolling on touch devices.
      if (this.options.contentScroll === false) {
        (0, _jquery2.default)('body').addClass('is-off-canvas-open').on('touchmove', this._stopScrolling);
        this.$element.on('touchstart', this._recordScrollable);
        this.$element.on('touchmove', this._stopScrollPropagation);
      }

      if (this.options.contentOverlay === true) {
        this.$overlay.addClass('is-visible');
      }

      if (this.options.closeOnClick === true && this.options.contentOverlay === true) {
        this.$overlay.addClass('is-closable');
      }

      if (this.options.autoFocus === true) {
        this.$element.one((0, _foundationUtil3.transitionend)(this.$element), function () {
          if (!_this.$element.hasClass('is-open')) {
            return; // exit if prematurely closed
          }
          var canvasFocus = _this.$element.find('[data-autofocus]');
          if (canvasFocus.length) {
            canvasFocus.eq(0).focus();
          } else {
            _this.$element.find('a, button').eq(0).focus();
          }
        });
      }

      if (this.options.trapFocus === true) {
        this.$content.attr('tabindex', '-1');
        _foundationUtil.Keyboard.trapFocus(this.$element);
      }

      this._addContentClasses();
    }

    /**
     * Closes the off-canvas menu.
     * @function
     * @param {Function} cb - optional cb to fire after closure.
     * @fires OffCanvas#closed
     */

  }, {
    key: 'close',
    value: function close(cb) {
      if (!this.$element.hasClass('is-open') || this.isRevealed) {
        return;
      }

      var _this = this;

      this.$element.removeClass('is-open');

      this.$element.attr('aria-hidden', 'true')
      /**
       * Fires when the off-canvas menu opens.
       * @event OffCanvas#closed
       */
      .trigger('closed.zf.offcanvas');

      this.$content.removeClass('is-open-left is-open-top is-open-right is-open-bottom');

      // If `contentScroll` is set to false, remove class and re-enable scrolling on touch devices.
      if (this.options.contentScroll === false) {
        (0, _jquery2.default)('body').removeClass('is-off-canvas-open').off('touchmove', this._stopScrolling);
        this.$element.off('touchstart', this._recordScrollable);
        this.$element.off('touchmove', this._stopScrollPropagation);
      }

      if (this.options.contentOverlay === true) {
        this.$overlay.removeClass('is-visible');
      }

      if (this.options.closeOnClick === true && this.options.contentOverlay === true) {
        this.$overlay.removeClass('is-closable');
      }

      this.$triggers.attr('aria-expanded', 'false');

      if (this.options.trapFocus === true) {
        this.$content.removeAttr('tabindex');
        _foundationUtil.Keyboard.releaseFocus(this.$element);
      }

      // Listen to transitionEnd and add class when done.
      this.$element.one((0, _foundationUtil3.transitionend)(this.$element), function (e) {
        _this.$element.addClass('is-closed');
        _this._removeContentClasses();
      });
    }

    /**
     * Toggles the off-canvas menu open or closed.
     * @function
     * @param {Object} event - Event object passed from listener.
     * @param {jQuery} trigger - element that triggered the off-canvas to open.
     */

  }, {
    key: 'toggle',
    value: function toggle(event, trigger) {
      if (this.$element.hasClass('is-open')) {
        this.close(event, trigger);
      } else {
        this.open(event, trigger);
      }
    }

    /**
     * Handles keyboard input when detected. When the escape key is pressed, the off-canvas menu closes, and focus is restored to the element that opened the menu.
     * @function
     * @private
     */

  }, {
    key: '_handleKeyboard',
    value: function _handleKeyboard(e) {
      var _this4 = this;

      _foundationUtil.Keyboard.handleKey(e, 'OffCanvas', {
        close: function close() {
          _this4.close();
          _this4.$lastTrigger.focus();
          return true;
        },
        handled: function handled() {
          e.stopPropagation();
          e.preventDefault();
        }
      });
    }

    /**
     * Destroys the offcanvas plugin.
     * @function
     */

  }, {
    key: '_destroy',
    value: function _destroy() {
      this.close();
      this.$element.off('.zf.trigger .zf.offcanvas');
      this.$overlay.off('.zf.offcanvas');
    }
  }]);

  return OffCanvas;
}(_foundation.Plugin);

OffCanvas.defaults = {
  /**
   * Allow the user to click outside of the menu to close it.
   * @option
   * @type {boolean}
   * @default true
   */
  closeOnClick: true,

  /**
   * Adds an overlay on top of `[data-off-canvas-content]`.
   * @option
   * @type {boolean}
   * @default true
   */
  contentOverlay: true,

  /**
   * Target an off-canvas content container by ID that may be placed anywhere. If null the closest content container will be taken.
   * @option
   * @type {?string}
   * @default null
   */
  contentId: null,

  /**
   * Define the off-canvas element is nested in an off-canvas content. This is required when using the contentId option for a nested element.
   * @option
   * @type {boolean}
   * @default null
   */
  nested: null,

  /**
   * Enable/disable scrolling of the main content when an off canvas panel is open.
   * @option
   * @type {boolean}
   * @default true
   */
  contentScroll: true,

  /**
   * Amount of time in ms the open and close transition requires. If none selected, pulls from body style.
   * @option
   * @type {number}
   * @default null
   */
  transitionTime: null,

  /**
   * Type of transition for the offcanvas menu. Options are 'push', 'detached' or 'slide'.
   * @option
   * @type {string}
   * @default push
   */
  transition: 'push',

  /**
   * Force the page to scroll to top or bottom on open.
   * @option
   * @type {?string}
   * @default null
   */
  forceTo: null,

  /**
   * Allow the offcanvas to remain open for certain breakpoints.
   * @option
   * @type {boolean}
   * @default false
   */
  isRevealed: false,

  /**
   * Breakpoint at which to reveal. JS will use a RegExp to target standard classes, if changing classnames, pass your class with the `revealClass` option.
   * @option
   * @type {?string}
   * @default null
   */
  revealOn: null,

  /**
   * Force focus to the offcanvas on open. If true, will focus the opening trigger on close.
   * @option
   * @type {boolean}
   * @default true
   */
  autoFocus: true,

  /**
   * Class used to force an offcanvas to remain open. Foundation defaults for this are `reveal-for-large` & `reveal-for-medium`.
   * @option
   * @type {string}
   * @default reveal-for-
   * @todo improve the regex testing for this.
   */
  revealClass: 'reveal-for-',

  /**
   * Triggers optional focus trapping when opening an offcanvas. Sets tabindex of [data-off-canvas-content] to -1 for accessibility purposes.
   * @option
   * @type {boolean}
   * @default false
   */
  trapFocus: false
};

exports.OffCanvas = OffCanvas;

/***/ }),
/* 30 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Orbit = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _foundationUtil = __webpack_require__(4);

var _foundationUtil2 = __webpack_require__(6);

var _foundationUtil3 = __webpack_require__(11);

var _foundationUtil4 = __webpack_require__(8);

var _foundationUtil5 = __webpack_require__(1);

var _foundation = __webpack_require__(2);

var _foundationUtil6 = __webpack_require__(10);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * Orbit module.
 * @module foundation.orbit
 * @requires foundation.util.keyboard
 * @requires foundation.util.motion
 * @requires foundation.util.timer
 * @requires foundation.util.imageLoader
 * @requires foundation.util.touch
 */

var Orbit = function (_Plugin) {
  _inherits(Orbit, _Plugin);

  function Orbit() {
    _classCallCheck(this, Orbit);

    return _possibleConstructorReturn(this, (Orbit.__proto__ || Object.getPrototypeOf(Orbit)).apply(this, arguments));
  }

  _createClass(Orbit, [{
    key: '_setup',

    /**
    * Creates a new instance of an orbit carousel.
    * @class
    * @name Orbit
    * @param {jQuery} element - jQuery object to make into an Orbit Carousel.
    * @param {Object} options - Overrides to the default plugin settings.
    */
    value: function _setup(element, options) {
      this.$element = element;
      this.options = _jquery2.default.extend({}, Orbit.defaults, this.$element.data(), options);
      this.className = 'Orbit'; // ie9 back compat

      _foundationUtil6.Touch.init(_jquery2.default); // Touch init is idempotent, we just need to make sure it's initialied.

      this._init();

      _foundationUtil.Keyboard.register('Orbit', {
        'ltr': {
          'ARROW_RIGHT': 'next',
          'ARROW_LEFT': 'previous'
        },
        'rtl': {
          'ARROW_LEFT': 'next',
          'ARROW_RIGHT': 'previous'
        }
      });
    }

    /**
    * Initializes the plugin by creating jQuery collections, setting attributes, and starting the animation.
    * @function
    * @private
    */

  }, {
    key: '_init',
    value: function _init() {
      // @TODO: consider discussion on PR #9278 about DOM pollution by changeSlide
      this._reset();

      this.$wrapper = this.$element.find('.' + this.options.containerClass);
      this.$slides = this.$element.find('.' + this.options.slideClass);

      var $images = this.$element.find('img'),
          initActive = this.$slides.filter('.is-active'),
          id = this.$element[0].id || (0, _foundationUtil5.GetYoDigits)(6, 'orbit');

      this.$element.attr({
        'data-resize': id,
        'id': id
      });

      if (!initActive.length) {
        this.$slides.eq(0).addClass('is-active');
      }

      if (!this.options.useMUI) {
        this.$slides.addClass('no-motionui');
      }

      if ($images.length) {
        (0, _foundationUtil4.onImagesLoaded)($images, this._prepareForOrbit.bind(this));
      } else {
        this._prepareForOrbit(); //hehe
      }

      if (this.options.bullets) {
        this._loadBullets();
      }

      this._events();

      if (this.options.autoPlay && this.$slides.length > 1) {
        this.geoSync();
      }

      if (this.options.accessible) {
        // allow wrapper to be focusable to enable arrow navigation
        this.$wrapper.attr('tabindex', 0);
      }
    }

    /**
    * Creates a jQuery collection of bullets, if they are being used.
    * @function
    * @private
    */

  }, {
    key: '_loadBullets',
    value: function _loadBullets() {
      this.$bullets = this.$element.find('.' + this.options.boxOfBullets).find('button');
    }

    /**
    * Sets a `timer` object on the orbit, and starts the counter for the next slide.
    * @function
    */

  }, {
    key: 'geoSync',
    value: function geoSync() {
      var _this = this;
      this.timer = new _foundationUtil3.Timer(this.$element, {
        duration: this.options.timerDelay,
        infinite: false
      }, function () {
        _this.changeSlide(true);
      });
      this.timer.start();
    }

    /**
    * Sets wrapper and slide heights for the orbit.
    * @function
    * @private
    */

  }, {
    key: '_prepareForOrbit',
    value: function _prepareForOrbit() {
      var _this = this;
      this._setWrapperHeight();
    }

    /**
    * Calulates the height of each slide in the collection, and uses the tallest one for the wrapper height.
    * @function
    * @private
    * @param {Function} cb - a callback function to fire when complete.
    */

  }, {
    key: '_setWrapperHeight',
    value: function _setWrapperHeight(cb) {
      //rewrite this to `for` loop
      var max = 0,
          temp,
          counter = 0,
          _this = this;

      this.$slides.each(function () {
        temp = this.getBoundingClientRect().height;
        (0, _jquery2.default)(this).attr('data-slide', counter);

        if (!/mui/g.test((0, _jquery2.default)(this)[0].className) && _this.$slides.filter('.is-active')[0] !== _this.$slides.eq(counter)[0]) {
          //if not the active slide, set css position and display property
          (0, _jquery2.default)(this).css({ 'position': 'relative', 'display': 'none' });
        }
        max = temp > max ? temp : max;
        counter++;
      });

      if (counter === this.$slides.length) {
        this.$wrapper.css({ 'height': max }); //only change the wrapper height property once.
        if (cb) {
          cb(max);
        } //fire callback with max height dimension.
      }
    }

    /**
    * Sets the max-height of each slide.
    * @function
    * @private
    */

  }, {
    key: '_setSlideHeight',
    value: function _setSlideHeight(height) {
      this.$slides.each(function () {
        (0, _jquery2.default)(this).css('max-height', height);
      });
    }

    /**
    * Adds event listeners to basically everything within the element.
    * @function
    * @private
    */

  }, {
    key: '_events',
    value: function _events() {
      var _this = this;

      //***************************************
      //**Now using custom event - thanks to:**
      //**      Yohai Ararat of Toronto      **
      //***************************************
      //
      this.$element.off('.resizeme.zf.trigger').on({
        'resizeme.zf.trigger': this._prepareForOrbit.bind(this)
      });
      if (this.$slides.length > 1) {

        if (this.options.swipe) {
          this.$slides.off('swipeleft.zf.orbit swiperight.zf.orbit').on('swipeleft.zf.orbit', function (e) {
            e.preventDefault();
            _this.changeSlide(true);
          }).on('swiperight.zf.orbit', function (e) {
            e.preventDefault();
            _this.changeSlide(false);
          });
        }
        //***************************************

        if (this.options.autoPlay) {
          this.$slides.on('click.zf.orbit', function () {
            _this.$element.data('clickedOn', _this.$element.data('clickedOn') ? false : true);
            _this.timer[_this.$element.data('clickedOn') ? 'pause' : 'start']();
          });

          if (this.options.pauseOnHover) {
            this.$element.on('mouseenter.zf.orbit', function () {
              _this.timer.pause();
            }).on('mouseleave.zf.orbit', function () {
              if (!_this.$element.data('clickedOn')) {
                _this.timer.start();
              }
            });
          }
        }

        if (this.options.navButtons) {
          var $controls = this.$element.find('.' + this.options.nextClass + ', .' + this.options.prevClass);
          $controls.attr('tabindex', 0)
          //also need to handle enter/return and spacebar key presses
          .on('click.zf.orbit touchend.zf.orbit', function (e) {
            e.preventDefault();
            _this.changeSlide((0, _jquery2.default)(this).hasClass(_this.options.nextClass));
          });
        }

        if (this.options.bullets) {
          this.$bullets.on('click.zf.orbit touchend.zf.orbit', function () {
            if (/is-active/g.test(this.className)) {
              return false;
            } //if this is active, kick out of function.
            var idx = (0, _jquery2.default)(this).data('slide'),
                ltr = idx > _this.$slides.filter('.is-active').data('slide'),
                $slide = _this.$slides.eq(idx);

            _this.changeSlide(ltr, $slide, idx);
          });
        }

        if (this.options.accessible) {
          this.$wrapper.add(this.$bullets).on('keydown.zf.orbit', function (e) {
            // handle keyboard event with keyboard util
            _foundationUtil.Keyboard.handleKey(e, 'Orbit', {
              next: function next() {
                _this.changeSlide(true);
              },
              previous: function previous() {
                _this.changeSlide(false);
              },
              handled: function handled() {
                // if bullet is focused, make sure focus moves
                if ((0, _jquery2.default)(e.target).is(_this.$bullets)) {
                  _this.$bullets.filter('.is-active').focus();
                }
              }
            });
          });
        }
      }
    }

    /**
     * Resets Orbit so it can be reinitialized
     */

  }, {
    key: '_reset',
    value: function _reset() {
      // Don't do anything if there are no slides (first run)
      if (typeof this.$slides == 'undefined') {
        return;
      }

      if (this.$slides.length > 1) {
        // Remove old events
        this.$element.off('.zf.orbit').find('*').off('.zf.orbit');

        // Restart timer if autoPlay is enabled
        if (this.options.autoPlay) {
          this.timer.restart();
        }

        // Reset all sliddes
        this.$slides.each(function (el) {
          (0, _jquery2.default)(el).removeClass('is-active is-active is-in').removeAttr('aria-live').hide();
        });

        // Show the first slide
        this.$slides.first().addClass('is-active').show();

        // Triggers when the slide has finished animating
        this.$element.trigger('slidechange.zf.orbit', [this.$slides.first()]);

        // Select first bullet if bullets are present
        if (this.options.bullets) {
          this._updateBullets(0);
        }
      }
    }

    /**
    * Changes the current slide to a new one.
    * @function
    * @param {Boolean} isLTR - flag if the slide should move left to right.
    * @param {jQuery} chosenSlide - the jQuery element of the slide to show next, if one is selected.
    * @param {Number} idx - the index of the new slide in its collection, if one chosen.
    * @fires Orbit#slidechange
    */

  }, {
    key: 'changeSlide',
    value: function changeSlide(isLTR, chosenSlide, idx) {
      if (!this.$slides) {
        return;
      } // Don't freak out if we're in the middle of cleanup
      var $curSlide = this.$slides.filter('.is-active').eq(0);

      if (/mui/g.test($curSlide[0].className)) {
        return false;
      } //if the slide is currently animating, kick out of the function

      var $firstSlide = this.$slides.first(),
          $lastSlide = this.$slides.last(),
          dirIn = isLTR ? 'Right' : 'Left',
          dirOut = isLTR ? 'Left' : 'Right',
          _this = this,
          $newSlide;

      if (!chosenSlide) {
        //most of the time, this will be auto played or clicked from the navButtons.
        $newSlide = isLTR ? //if wrapping enabled, check to see if there is a `next` or `prev` sibling, if not, select the first or last slide to fill in. if wrapping not enabled, attempt to select `next` or `prev`, if there's nothing there, the function will kick out on next step. CRAZY NESTED TERNARIES!!!!!
        this.options.infiniteWrap ? $curSlide.next('.' + this.options.slideClass).length ? $curSlide.next('.' + this.options.slideClass) : $firstSlide : $curSlide.next('.' + this.options.slideClass) : //pick next slide if moving left to right
        this.options.infiniteWrap ? $curSlide.prev('.' + this.options.slideClass).length ? $curSlide.prev('.' + this.options.slideClass) : $lastSlide : $curSlide.prev('.' + this.options.slideClass); //pick prev slide if moving right to left
      } else {
        $newSlide = chosenSlide;
      }

      if ($newSlide.length) {
        /**
        * Triggers before the next slide starts animating in and only if a next slide has been found.
        * @event Orbit#beforeslidechange
        */
        this.$element.trigger('beforeslidechange.zf.orbit', [$curSlide, $newSlide]);

        if (this.options.bullets) {
          idx = idx || this.$slides.index($newSlide); //grab index to update bullets
          this._updateBullets(idx);
        }

        if (this.options.useMUI && !this.$element.is(':hidden')) {
          _foundationUtil2.Motion.animateIn($newSlide.addClass('is-active').css({ 'position': 'absolute', 'top': 0 }), this.options['animInFrom' + dirIn], function () {
            $newSlide.css({ 'position': 'relative', 'display': 'block' }).attr('aria-live', 'polite');
          });

          _foundationUtil2.Motion.animateOut($curSlide.removeClass('is-active'), this.options['animOutTo' + dirOut], function () {
            $curSlide.removeAttr('aria-live');
            if (_this.options.autoPlay && !_this.timer.isPaused) {
              _this.timer.restart();
            }
            //do stuff?
          });
        } else {
          $curSlide.removeClass('is-active is-in').removeAttr('aria-live').hide();
          $newSlide.addClass('is-active is-in').attr('aria-live', 'polite').show();
          if (this.options.autoPlay && !this.timer.isPaused) {
            this.timer.restart();
          }
        }
        /**
        * Triggers when the slide has finished animating in.
        * @event Orbit#slidechange
        */
        this.$element.trigger('slidechange.zf.orbit', [$newSlide]);
      }
    }

    /**
    * Updates the active state of the bullets, if displayed.
    * @function
    * @private
    * @param {Number} idx - the index of the current slide.
    */

  }, {
    key: '_updateBullets',
    value: function _updateBullets(idx) {
      var $oldBullet = this.$element.find('.' + this.options.boxOfBullets).find('.is-active').removeClass('is-active').blur(),
          span = $oldBullet.find('span:last').detach(),
          $newBullet = this.$bullets.eq(idx).addClass('is-active').append(span);
    }

    /**
    * Destroys the carousel and hides the element.
    * @function
    */

  }, {
    key: '_destroy',
    value: function _destroy() {
      this.$element.off('.zf.orbit').find('*').off('.zf.orbit').end().hide();
    }
  }]);

  return Orbit;
}(_foundation.Plugin);

Orbit.defaults = {
  /**
  * Tells the JS to look for and loadBullets.
  * @option
   * @type {boolean}
  * @default true
  */
  bullets: true,
  /**
  * Tells the JS to apply event listeners to nav buttons
  * @option
   * @type {boolean}
  * @default true
  */
  navButtons: true,
  /**
  * motion-ui animation class to apply
  * @option
   * @type {string}
  * @default 'slide-in-right'
  */
  animInFromRight: 'slide-in-right',
  /**
  * motion-ui animation class to apply
  * @option
   * @type {string}
  * @default 'slide-out-right'
  */
  animOutToRight: 'slide-out-right',
  /**
  * motion-ui animation class to apply
  * @option
   * @type {string}
  * @default 'slide-in-left'
  *
  */
  animInFromLeft: 'slide-in-left',
  /**
  * motion-ui animation class to apply
  * @option
   * @type {string}
  * @default 'slide-out-left'
  */
  animOutToLeft: 'slide-out-left',
  /**
  * Allows Orbit to automatically animate on page load.
  * @option
   * @type {boolean}
  * @default true
  */
  autoPlay: true,
  /**
  * Amount of time, in ms, between slide transitions
  * @option
   * @type {number}
  * @default 5000
  */
  timerDelay: 5000,
  /**
  * Allows Orbit to infinitely loop through the slides
  * @option
   * @type {boolean}
  * @default true
  */
  infiniteWrap: true,
  /**
  * Allows the Orbit slides to bind to swipe events for mobile, requires an additional util library
  * @option
   * @type {boolean}
  * @default true
  */
  swipe: true,
  /**
  * Allows the timing function to pause animation on hover.
  * @option
   * @type {boolean}
  * @default true
  */
  pauseOnHover: true,
  /**
  * Allows Orbit to bind keyboard events to the slider, to animate frames with arrow keys
  * @option
   * @type {boolean}
  * @default true
  */
  accessible: true,
  /**
  * Class applied to the container of Orbit
  * @option
   * @type {string}
  * @default 'orbit-container'
  */
  containerClass: 'orbit-container',
  /**
  * Class applied to individual slides.
  * @option
   * @type {string}
  * @default 'orbit-slide'
  */
  slideClass: 'orbit-slide',
  /**
  * Class applied to the bullet container. You're welcome.
  * @option
   * @type {string}
  * @default 'orbit-bullets'
  */
  boxOfBullets: 'orbit-bullets',
  /**
  * Class applied to the `next` navigation button.
  * @option
   * @type {string}
  * @default 'orbit-next'
  */
  nextClass: 'orbit-next',
  /**
  * Class applied to the `previous` navigation button.
  * @option
   * @type {string}
  * @default 'orbit-previous'
  */
  prevClass: 'orbit-previous',
  /**
  * Boolean to flag the js to use motion ui classes or not. Default to true for backwards compatability.
  * @option
   * @type {boolean}
  * @default true
  */
  useMUI: true
};

exports.Orbit = Orbit;

/***/ }),
/* 31 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResponsiveMenu = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _foundationUtil = __webpack_require__(3);

var _foundationUtil2 = __webpack_require__(1);

var _foundation = __webpack_require__(2);

var _foundation2 = __webpack_require__(16);

var _foundation3 = __webpack_require__(14);

var _foundation4 = __webpack_require__(13);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var MenuPlugins = {
  dropdown: {
    cssClass: 'dropdown',
    plugin: _foundation2.DropdownMenu
  },
  drilldown: {
    cssClass: 'drilldown',
    plugin: _foundation3.Drilldown
  },
  accordion: {
    cssClass: 'accordion-menu',
    plugin: _foundation4.AccordionMenu
  }
};

// import "foundation.util.triggers.js";


/**
 * ResponsiveMenu module.
 * @module foundation.responsiveMenu
 * @requires foundation.util.triggers
 * @requires foundation.util.mediaQuery
 */

var ResponsiveMenu = function (_Plugin) {
  _inherits(ResponsiveMenu, _Plugin);

  function ResponsiveMenu() {
    _classCallCheck(this, ResponsiveMenu);

    return _possibleConstructorReturn(this, (ResponsiveMenu.__proto__ || Object.getPrototypeOf(ResponsiveMenu)).apply(this, arguments));
  }

  _createClass(ResponsiveMenu, [{
    key: '_setup',

    /**
     * Creates a new instance of a responsive menu.
     * @class
     * @name ResponsiveMenu
     * @fires ResponsiveMenu#init
     * @param {jQuery} element - jQuery object to make into a dropdown menu.
     * @param {Object} options - Overrides to the default plugin settings.
     */
    value: function _setup(element, options) {
      this.$element = (0, _jquery2.default)(element);
      this.rules = this.$element.data('responsive-menu');
      this.currentMq = null;
      this.currentPlugin = null;
      this.className = 'ResponsiveMenu'; // ie9 back compat

      this._init();
      this._events();
    }

    /**
     * Initializes the Menu by parsing the classes from the 'data-ResponsiveMenu' attribute on the element.
     * @function
     * @private
     */

  }, {
    key: '_init',
    value: function _init() {

      _foundationUtil.MediaQuery._init();
      // The first time an Interchange plugin is initialized, this.rules is converted from a string of "classes" to an object of rules
      if (typeof this.rules === 'string') {
        var rulesTree = {};

        // Parse rules from "classes" pulled from data attribute
        var rules = this.rules.split(' ');

        // Iterate through every rule found
        for (var i = 0; i < rules.length; i++) {
          var rule = rules[i].split('-');
          var ruleSize = rule.length > 1 ? rule[0] : 'small';
          var rulePlugin = rule.length > 1 ? rule[1] : rule[0];

          if (MenuPlugins[rulePlugin] !== null) {
            rulesTree[ruleSize] = MenuPlugins[rulePlugin];
          }
        }

        this.rules = rulesTree;
      }

      if (!_jquery2.default.isEmptyObject(this.rules)) {
        this._checkMediaQueries();
      }
      // Add data-mutate since children may need it.
      this.$element.attr('data-mutate', this.$element.attr('data-mutate') || (0, _foundationUtil2.GetYoDigits)(6, 'responsive-menu'));
    }

    /**
     * Initializes events for the Menu.
     * @function
     * @private
     */

  }, {
    key: '_events',
    value: function _events() {
      var _this = this;

      (0, _jquery2.default)(window).on('changed.zf.mediaquery', function () {
        _this._checkMediaQueries();
      });
      // $(window).on('resize.zf.ResponsiveMenu', function() {
      //   _this._checkMediaQueries();
      // });
    }

    /**
     * Checks the current screen width against available media queries. If the media query has changed, and the plugin needed has changed, the plugins will swap out.
     * @function
     * @private
     */

  }, {
    key: '_checkMediaQueries',
    value: function _checkMediaQueries() {
      var matchedMq,
          _this = this;
      // Iterate through each rule and find the last matching rule
      _jquery2.default.each(this.rules, function (key) {
        if (_foundationUtil.MediaQuery.atLeast(key)) {
          matchedMq = key;
        }
      });

      // No match? No dice
      if (!matchedMq) return;

      // Plugin already initialized? We good
      if (this.currentPlugin instanceof this.rules[matchedMq].plugin) return;

      // Remove existing plugin-specific CSS classes
      _jquery2.default.each(MenuPlugins, function (key, value) {
        _this.$element.removeClass(value.cssClass);
      });

      // Add the CSS class for the new plugin
      this.$element.addClass(this.rules[matchedMq].cssClass);

      // Create an instance of the new plugin
      if (this.currentPlugin) this.currentPlugin.destroy();
      this.currentPlugin = new this.rules[matchedMq].plugin(this.$element, {});
    }

    /**
     * Destroys the instance of the current plugin on this element, as well as the window resize handler that switches the plugins out.
     * @function
     */

  }, {
    key: '_destroy',
    value: function _destroy() {
      this.currentPlugin.destroy();
      (0, _jquery2.default)(window).off('.zf.ResponsiveMenu');
    }
  }]);

  return ResponsiveMenu;
}(_foundation.Plugin);

ResponsiveMenu.defaults = {};

exports.ResponsiveMenu = ResponsiveMenu;

/***/ }),
/* 32 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResponsiveToggle = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _foundationUtil = __webpack_require__(3);

var _foundationUtil2 = __webpack_require__(6);

var _foundation = __webpack_require__(2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * ResponsiveToggle module.
 * @module foundation.responsiveToggle
 * @requires foundation.util.mediaQuery
 * @requires foundation.util.motion
 */

var ResponsiveToggle = function (_Plugin) {
  _inherits(ResponsiveToggle, _Plugin);

  function ResponsiveToggle() {
    _classCallCheck(this, ResponsiveToggle);

    return _possibleConstructorReturn(this, (ResponsiveToggle.__proto__ || Object.getPrototypeOf(ResponsiveToggle)).apply(this, arguments));
  }

  _createClass(ResponsiveToggle, [{
    key: '_setup',

    /**
     * Creates a new instance of Tab Bar.
     * @class
     * @name ResponsiveToggle
     * @fires ResponsiveToggle#init
     * @param {jQuery} element - jQuery object to attach tab bar functionality to.
     * @param {Object} options - Overrides to the default plugin settings.
     */
    value: function _setup(element, options) {
      this.$element = (0, _jquery2.default)(element);
      this.options = _jquery2.default.extend({}, ResponsiveToggle.defaults, this.$element.data(), options);
      this.className = 'ResponsiveToggle'; // ie9 back compat

      this._init();
      this._events();
    }

    /**
     * Initializes the tab bar by finding the target element, toggling element, and running update().
     * @function
     * @private
     */

  }, {
    key: '_init',
    value: function _init() {
      _foundationUtil.MediaQuery._init();
      var targetID = this.$element.data('responsive-toggle');
      if (!targetID) {
        console.error('Your tab bar needs an ID of a Menu as the value of data-tab-bar.');
      }

      this.$targetMenu = (0, _jquery2.default)('#' + targetID);
      this.$toggler = this.$element.find('[data-toggle]').filter(function () {
        var target = (0, _jquery2.default)(this).data('toggle');
        return target === targetID || target === "";
      });
      this.options = _jquery2.default.extend({}, this.options, this.$targetMenu.data());

      // If they were set, parse the animation classes
      if (this.options.animate) {
        var input = this.options.animate.split(' ');

        this.animationIn = input[0];
        this.animationOut = input[1] || null;
      }

      this._update();
    }

    /**
     * Adds necessary event handlers for the tab bar to work.
     * @function
     * @private
     */

  }, {
    key: '_events',
    value: function _events() {
      var _this = this;

      this._updateMqHandler = this._update.bind(this);

      (0, _jquery2.default)(window).on('changed.zf.mediaquery', this._updateMqHandler);

      this.$toggler.on('click.zf.responsiveToggle', this.toggleMenu.bind(this));
    }

    /**
     * Checks the current media query to determine if the tab bar should be visible or hidden.
     * @function
     * @private
     */

  }, {
    key: '_update',
    value: function _update() {
      // Mobile
      if (!_foundationUtil.MediaQuery.atLeast(this.options.hideFor)) {
        this.$element.show();
        this.$targetMenu.hide();
      }

      // Desktop
      else {
          this.$element.hide();
          this.$targetMenu.show();
        }
    }

    /**
     * Toggles the element attached to the tab bar. The toggle only happens if the screen is small enough to allow it.
     * @function
     * @fires ResponsiveToggle#toggled
     */

  }, {
    key: 'toggleMenu',
    value: function toggleMenu() {
      var _this3 = this;

      if (!_foundationUtil.MediaQuery.atLeast(this.options.hideFor)) {
        /**
         * Fires when the element attached to the tab bar toggles.
         * @event ResponsiveToggle#toggled
         */
        if (this.options.animate) {
          if (this.$targetMenu.is(':hidden')) {
            _foundationUtil2.Motion.animateIn(this.$targetMenu, this.animationIn, function () {
              _this3.$element.trigger('toggled.zf.responsiveToggle');
              _this3.$targetMenu.find('[data-mutate]').triggerHandler('mutateme.zf.trigger');
            });
          } else {
            _foundationUtil2.Motion.animateOut(this.$targetMenu, this.animationOut, function () {
              _this3.$element.trigger('toggled.zf.responsiveToggle');
            });
          }
        } else {
          this.$targetMenu.toggle(0);
          this.$targetMenu.find('[data-mutate]').trigger('mutateme.zf.trigger');
          this.$element.trigger('toggled.zf.responsiveToggle');
        }
      }
    }
  }, {
    key: '_destroy',
    value: function _destroy() {
      this.$element.off('.zf.responsiveToggle');
      this.$toggler.off('.zf.responsiveToggle');

      (0, _jquery2.default)(window).off('changed.zf.mediaquery', this._updateMqHandler);
    }
  }]);

  return ResponsiveToggle;
}(_foundation.Plugin);

ResponsiveToggle.defaults = {
  /**
   * The breakpoint after which the menu is always shown, and the tab bar is hidden.
   * @option
   * @type {string}
   * @default 'medium'
   */
  hideFor: 'medium',

  /**
   * To decide if the toggle should be animated or not.
   * @option
   * @type {boolean}
   * @default false
   */
  animate: false
};

exports.ResponsiveToggle = ResponsiveToggle;

/***/ }),
/* 33 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Reveal = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _foundationUtil = __webpack_require__(4);

var _foundationUtil2 = __webpack_require__(3);

var _foundationUtil3 = __webpack_require__(6);

var _foundation = __webpack_require__(2);

var _foundationUtil4 = __webpack_require__(5);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * Reveal module.
 * @module foundation.reveal
 * @requires foundation.util.keyboard
 * @requires foundation.util.triggers
 * @requires foundation.util.mediaQuery
 * @requires foundation.util.motion if using animations
 */

var Reveal = function (_Plugin) {
  _inherits(Reveal, _Plugin);

  function Reveal() {
    _classCallCheck(this, Reveal);

    return _possibleConstructorReturn(this, (Reveal.__proto__ || Object.getPrototypeOf(Reveal)).apply(this, arguments));
  }

  _createClass(Reveal, [{
    key: '_setup',

    /**
     * Creates a new instance of Reveal.
     * @class
     * @name Reveal
     * @param {jQuery} element - jQuery object to use for the modal.
     * @param {Object} options - optional parameters.
     */
    value: function _setup(element, options) {
      this.$element = element;
      this.options = _jquery2.default.extend({}, Reveal.defaults, this.$element.data(), options);
      this.className = 'Reveal'; // ie9 back compat
      this._init();

      // Triggers init is idempotent, just need to make sure it is initialized
      _foundationUtil4.Triggers.init(_jquery2.default);

      _foundationUtil.Keyboard.register('Reveal', {
        'ESCAPE': 'close'
      });
    }

    /**
     * Initializes the modal by adding the overlay and close buttons, (if selected).
     * @private
     */

  }, {
    key: '_init',
    value: function _init() {
      _foundationUtil2.MediaQuery._init();
      this.id = this.$element.attr('id');
      this.isActive = false;
      this.cached = { mq: _foundationUtil2.MediaQuery.current };
      this.isMobile = mobileSniff();

      this.$anchor = (0, _jquery2.default)('[data-open="' + this.id + '"]').length ? (0, _jquery2.default)('[data-open="' + this.id + '"]') : (0, _jquery2.default)('[data-toggle="' + this.id + '"]');
      this.$anchor.attr({
        'aria-controls': this.id,
        'aria-haspopup': true,
        'tabindex': 0
      });

      if (this.options.fullScreen || this.$element.hasClass('full')) {
        this.options.fullScreen = true;
        this.options.overlay = false;
      }
      if (this.options.overlay && !this.$overlay) {
        this.$overlay = this._makeOverlay(this.id);
      }

      this.$element.attr({
        'role': 'dialog',
        'aria-hidden': true,
        'data-yeti-box': this.id,
        'data-resize': this.id
      });

      if (this.$overlay) {
        this.$element.detach().appendTo(this.$overlay);
      } else {
        this.$element.detach().appendTo((0, _jquery2.default)(this.options.appendTo));
        this.$element.addClass('without-overlay');
      }
      this._events();
      if (this.options.deepLink && window.location.hash === '#' + this.id) {
        (0, _jquery2.default)(window).one('load.zf.reveal', this.open.bind(this));
      }
    }

    /**
     * Creates an overlay div to display behind the modal.
     * @private
     */

  }, {
    key: '_makeOverlay',
    value: function _makeOverlay() {
      var additionalOverlayClasses = '';

      if (this.options.additionalOverlayClasses) {
        additionalOverlayClasses = ' ' + this.options.additionalOverlayClasses;
      }

      return (0, _jquery2.default)('<div></div>').addClass('reveal-overlay' + additionalOverlayClasses).appendTo(this.options.appendTo);
    }

    /**
     * Updates position of modal
     * TODO:  Figure out if we actually need to cache these values or if it doesn't matter
     * @private
     */

  }, {
    key: '_updatePosition',
    value: function _updatePosition() {
      var width = this.$element.outerWidth();
      var outerWidth = (0, _jquery2.default)(window).width();
      var height = this.$element.outerHeight();
      var outerHeight = (0, _jquery2.default)(window).height();
      var left, top;
      if (this.options.hOffset === 'auto') {
        left = parseInt((outerWidth - width) / 2, 10);
      } else {
        left = parseInt(this.options.hOffset, 10);
      }
      if (this.options.vOffset === 'auto') {
        if (height > outerHeight) {
          top = parseInt(Math.min(100, outerHeight / 10), 10);
        } else {
          top = parseInt((outerHeight - height) / 4, 10);
        }
      } else {
        top = parseInt(this.options.vOffset, 10);
      }
      this.$element.css({ top: top + 'px' });
      // only worry about left if we don't have an overlay or we havea  horizontal offset,
      // otherwise we're perfectly in the middle
      if (!this.$overlay || this.options.hOffset !== 'auto') {
        this.$element.css({ left: left + 'px' });
        this.$element.css({ margin: '0px' });
      }
    }

    /**
     * Adds event handlers for the modal.
     * @private
     */

  }, {
    key: '_events',
    value: function _events() {
      var _this3 = this;

      var _this = this;

      this.$element.on({
        'open.zf.trigger': this.open.bind(this),
        'close.zf.trigger': function closeZfTrigger(event, $element) {
          if (event.target === _this.$element[0] || (0, _jquery2.default)(event.target).parents('[data-closable]')[0] === $element) {
            // only close reveal when it's explicitly called
            return _this3.close.apply(_this3);
          }
        },
        'toggle.zf.trigger': this.toggle.bind(this),
        'resizeme.zf.trigger': function resizemeZfTrigger() {
          _this._updatePosition();
        }
      });

      if (this.options.closeOnClick && this.options.overlay) {
        this.$overlay.off('.zf.reveal').on('click.zf.reveal', function (e) {
          if (e.target === _this.$element[0] || _jquery2.default.contains(_this.$element[0], e.target) || !_jquery2.default.contains(document, e.target)) {
            return;
          }
          _this.close();
        });
      }
      if (this.options.deepLink) {
        (0, _jquery2.default)(window).on('popstate.zf.reveal:' + this.id, this._handleState.bind(this));
      }
    }

    /**
     * Handles modal methods on back/forward button clicks or any other event that triggers popstate.
     * @private
     */

  }, {
    key: '_handleState',
    value: function _handleState(e) {
      if (window.location.hash === '#' + this.id && !this.isActive) {
        this.open();
      } else {
        this.close();
      }
    }

    /**
     * Opens the modal controlled by `this.$anchor`, and closes all others by default.
     * @function
     * @fires Reveal#closeme
     * @fires Reveal#open
     */

  }, {
    key: 'open',
    value: function open() {
      var _this4 = this;

      // either update or replace browser history
      if (this.options.deepLink) {
        var hash = '#' + this.id;

        if (window.history.pushState) {
          if (this.options.updateHistory) {
            window.history.pushState({}, '', hash);
          } else {
            window.history.replaceState({}, '', hash);
          }
        } else {
          window.location.hash = hash;
        }
      }

      this.isActive = true;

      // Make elements invisible, but remove display: none so we can get size and positioning
      this.$element.css({ 'visibility': 'hidden' }).show().scrollTop(0);
      if (this.options.overlay) {
        this.$overlay.css({ 'visibility': 'hidden' }).show();
      }

      this._updatePosition();

      this.$element.hide().css({ 'visibility': '' });

      if (this.$overlay) {
        this.$overlay.css({ 'visibility': '' }).hide();
        if (this.$element.hasClass('fast')) {
          this.$overlay.addClass('fast');
        } else if (this.$element.hasClass('slow')) {
          this.$overlay.addClass('slow');
        }
      }

      if (!this.options.multipleOpened) {
        /**
         * Fires immediately before the modal opens.
         * Closes any other modals that are currently open
         * @event Reveal#closeme
         */
        this.$element.trigger('closeme.zf.reveal', this.id);
      }

      var _this = this;

      function addRevealOpenClasses() {
        if (_this.isMobile) {
          if (!_this.originalScrollPos) {
            _this.originalScrollPos = window.pageYOffset;
          }
          (0, _jquery2.default)('html, body').addClass('is-reveal-open');
        } else {
          (0, _jquery2.default)('body').addClass('is-reveal-open');
        }
      }
      // Motion UI method of reveal
      if (this.options.animationIn) {
        var afterAnimation = function afterAnimation() {
          _this.$element.attr({
            'aria-hidden': false,
            'tabindex': -1
          }).focus();
          addRevealOpenClasses();
          _foundationUtil.Keyboard.trapFocus(_this.$element);
        };

        if (this.options.overlay) {
          _foundationUtil3.Motion.animateIn(this.$overlay, 'fade-in');
        }
        _foundationUtil3.Motion.animateIn(this.$element, this.options.animationIn, function () {
          if (_this4.$element) {
            // protect against object having been removed
            _this4.focusableElements = _foundationUtil.Keyboard.findFocusable(_this4.$element);
            afterAnimation();
          }
        });
      }
      // jQuery method of reveal
      else {
          if (this.options.overlay) {
            this.$overlay.show(0);
          }
          this.$element.show(this.options.showDelay);
        }

      // handle accessibility
      this.$element.attr({
        'aria-hidden': false,
        'tabindex': -1
      }).focus();
      _foundationUtil.Keyboard.trapFocus(this.$element);

      addRevealOpenClasses();

      this._extraHandlers();

      /**
       * Fires when the modal has successfully opened.
       * @event Reveal#open
       */
      this.$element.trigger('open.zf.reveal');
    }

    /**
     * Adds extra event handlers for the body and window if necessary.
     * @private
     */

  }, {
    key: '_extraHandlers',
    value: function _extraHandlers() {
      var _this = this;
      if (!this.$element) {
        return;
      } // If we're in the middle of cleanup, don't freak out
      this.focusableElements = _foundationUtil.Keyboard.findFocusable(this.$element);

      if (!this.options.overlay && this.options.closeOnClick && !this.options.fullScreen) {
        (0, _jquery2.default)('body').on('click.zf.reveal', function (e) {
          if (e.target === _this.$element[0] || _jquery2.default.contains(_this.$element[0], e.target) || !_jquery2.default.contains(document, e.target)) {
            return;
          }
          _this.close();
        });
      }

      if (this.options.closeOnEsc) {
        (0, _jquery2.default)(window).on('keydown.zf.reveal', function (e) {
          _foundationUtil.Keyboard.handleKey(e, 'Reveal', {
            close: function close() {
              if (_this.options.closeOnEsc) {
                _this.close();
              }
            }
          });
        });
      }
    }

    /**
     * Closes the modal.
     * @function
     * @fires Reveal#closed
     */

  }, {
    key: 'close',
    value: function close() {
      if (!this.isActive || !this.$element.is(':visible')) {
        return false;
      }
      var _this = this;

      // Motion UI method of hiding
      if (this.options.animationOut) {
        if (this.options.overlay) {
          _foundationUtil3.Motion.animateOut(this.$overlay, 'fade-out');
        }

        _foundationUtil3.Motion.animateOut(this.$element, this.options.animationOut, finishUp);
      }
      // jQuery method of hiding
      else {
          this.$element.hide(this.options.hideDelay);

          if (this.options.overlay) {
            this.$overlay.hide(0, finishUp);
          } else {
            finishUp();
          }
        }

      // Conditionals to remove extra event listeners added on open
      if (this.options.closeOnEsc) {
        (0, _jquery2.default)(window).off('keydown.zf.reveal');
      }

      if (!this.options.overlay && this.options.closeOnClick) {
        (0, _jquery2.default)('body').off('click.zf.reveal');
      }

      this.$element.off('keydown.zf.reveal');

      function finishUp() {
        if (_this.isMobile) {
          if ((0, _jquery2.default)('.reveal:visible').length === 0) {
            (0, _jquery2.default)('html, body').removeClass('is-reveal-open');
          }
          if (_this.originalScrollPos) {
            (0, _jquery2.default)('body').scrollTop(_this.originalScrollPos);
            _this.originalScrollPos = null;
          }
        } else {
          if ((0, _jquery2.default)('.reveal:visible').length === 0) {
            (0, _jquery2.default)('body').removeClass('is-reveal-open');
          }
        }

        _foundationUtil.Keyboard.releaseFocus(_this.$element);

        _this.$element.attr('aria-hidden', true);

        /**
        * Fires when the modal is done closing.
        * @event Reveal#closed
        */
        _this.$element.trigger('closed.zf.reveal');
      }

      /**
      * Resets the modal content
      * This prevents a running video to keep going in the background
      */
      if (this.options.resetOnClose) {
        this.$element.html(this.$element.html());
      }

      this.isActive = false;
      if (_this.options.deepLink) {
        if (window.history.replaceState) {
          window.history.replaceState('', document.title, window.location.href.replace('#' + this.id, ''));
        } else {
          window.location.hash = '';
        }
      }

      this.$anchor.focus();
    }

    /**
     * Toggles the open/closed state of a modal.
     * @function
     */

  }, {
    key: 'toggle',
    value: function toggle() {
      if (this.isActive) {
        this.close();
      } else {
        this.open();
      }
    }
  }, {
    key: '_destroy',


    /**
     * Destroys an instance of a modal.
     * @function
     */
    value: function _destroy() {
      if (this.options.overlay) {
        this.$element.appendTo((0, _jquery2.default)(this.options.appendTo)); // move $element outside of $overlay to prevent error unregisterPlugin()
        this.$overlay.hide().off().remove();
      }
      this.$element.hide().off();
      this.$anchor.off('.zf');
      (0, _jquery2.default)(window).off('.zf.reveal:' + this.id);
    }
  }]);

  return Reveal;
}(_foundation.Plugin);

Reveal.defaults = {
  /**
   * Motion-UI class to use for animated elements. If none used, defaults to simple show/hide.
   * @option
   * @type {string}
   * @default ''
   */
  animationIn: '',
  /**
   * Motion-UI class to use for animated elements. If none used, defaults to simple show/hide.
   * @option
   * @type {string}
   * @default ''
   */
  animationOut: '',
  /**
   * Time, in ms, to delay the opening of a modal after a click if no animation used.
   * @option
   * @type {number}
   * @default 0
   */
  showDelay: 0,
  /**
   * Time, in ms, to delay the closing of a modal after a click if no animation used.
   * @option
   * @type {number}
   * @default 0
   */
  hideDelay: 0,
  /**
   * Allows a click on the body/overlay to close the modal.
   * @option
   * @type {boolean}
   * @default true
   */
  closeOnClick: true,
  /**
   * Allows the modal to close if the user presses the `ESCAPE` key.
   * @option
   * @type {boolean}
   * @default true
   */
  closeOnEsc: true,
  /**
   * If true, allows multiple modals to be displayed at once.
   * @option
   * @type {boolean}
   * @default false
   */
  multipleOpened: false,
  /**
   * Distance, in pixels, the modal should push down from the top of the screen.
   * @option
   * @type {number|string}
   * @default auto
   */
  vOffset: 'auto',
  /**
   * Distance, in pixels, the modal should push in from the side of the screen.
   * @option
   * @type {number|string}
   * @default auto
   */
  hOffset: 'auto',
  /**
   * Allows the modal to be fullscreen, completely blocking out the rest of the view. JS checks for this as well.
   * @option
   * @type {boolean}
   * @default false
   */
  fullScreen: false,
  /**
   * Percentage of screen height the modal should push up from the bottom of the view.
   * @option
   * @type {number}
   * @default 10
   */
  btmOffsetPct: 10,
  /**
   * Allows the modal to generate an overlay div, which will cover the view when modal opens.
   * @option
   * @type {boolean}
   * @default true
   */
  overlay: true,
  /**
   * Allows the modal to remove and reinject markup on close. Should be true if using video elements w/o using provider's api, otherwise, videos will continue to play in the background.
   * @option
   * @type {boolean}
   * @default false
   */
  resetOnClose: false,
  /**
   * Allows the modal to alter the url on open/close, and allows the use of the `back` button to close modals. ALSO, allows a modal to auto-maniacally open on page load IF the hash === the modal's user-set id.
   * @option
   * @type {boolean}
   * @default false
   */
  deepLink: false,
  /**
   * Update the browser history with the open modal
   * @option
   * @default false
   */
  updateHistory: false,
  /**
  * Allows the modal to append to custom div.
  * @option
  * @type {string}
  * @default "body"
  */
  appendTo: "body",
  /**
   * Allows adding additional class names to the reveal overlay.
   * @option
   * @type {string}
   * @default ''
   */
  additionalOverlayClasses: ''
};

function iPhoneSniff() {
  return (/iP(ad|hone|od).*OS/.test(window.navigator.userAgent)
  );
}

function androidSniff() {
  return (/Android/.test(window.navigator.userAgent)
  );
}

function mobileSniff() {
  return iPhoneSniff() || androidSniff();
}

exports.Reveal = Reveal;

/***/ }),
/* 34 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Slider = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _foundationUtil = __webpack_require__(4);

var _foundationUtil2 = __webpack_require__(6);

var _foundationUtil3 = __webpack_require__(1);

var _foundation = __webpack_require__(2);

var _foundationUtil4 = __webpack_require__(10);

var _foundationUtil5 = __webpack_require__(5);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * Slider module.
 * @module foundation.slider
 * @requires foundation.util.motion
 * @requires foundation.util.triggers
 * @requires foundation.util.keyboard
 * @requires foundation.util.touch
 */

var Slider = function (_Plugin) {
  _inherits(Slider, _Plugin);

  function Slider() {
    _classCallCheck(this, Slider);

    return _possibleConstructorReturn(this, (Slider.__proto__ || Object.getPrototypeOf(Slider)).apply(this, arguments));
  }

  _createClass(Slider, [{
    key: '_setup',

    /**
     * Creates a new instance of a slider control.
     * @class
     * @name Slider
     * @param {jQuery} element - jQuery object to make into a slider control.
     * @param {Object} options - Overrides to the default plugin settings.
     */
    value: function _setup(element, options) {
      this.$element = element;
      this.options = _jquery2.default.extend({}, Slider.defaults, this.$element.data(), options);
      this.className = 'Slider'; // ie9 back compat

      // Touch and Triggers inits are idempotent, we just need to make sure it's initialied.
      _foundationUtil4.Touch.init(_jquery2.default);
      _foundationUtil5.Triggers.init(_jquery2.default);

      this._init();

      _foundationUtil.Keyboard.register('Slider', {
        'ltr': {
          'ARROW_RIGHT': 'increase',
          'ARROW_UP': 'increase',
          'ARROW_DOWN': 'decrease',
          'ARROW_LEFT': 'decrease',
          'SHIFT_ARROW_RIGHT': 'increase_fast',
          'SHIFT_ARROW_UP': 'increase_fast',
          'SHIFT_ARROW_DOWN': 'decrease_fast',
          'SHIFT_ARROW_LEFT': 'decrease_fast',
          'HOME': 'min',
          'END': 'max'
        },
        'rtl': {
          'ARROW_LEFT': 'increase',
          'ARROW_RIGHT': 'decrease',
          'SHIFT_ARROW_LEFT': 'increase_fast',
          'SHIFT_ARROW_RIGHT': 'decrease_fast'
        }
      });
    }

    /**
     * Initilizes the plugin by reading/setting attributes, creating collections and setting the initial position of the handle(s).
     * @function
     * @private
     */

  }, {
    key: '_init',
    value: function _init() {
      this.inputs = this.$element.find('input');
      this.handles = this.$element.find('[data-slider-handle]');

      this.$handle = this.handles.eq(0);
      this.$input = this.inputs.length ? this.inputs.eq(0) : (0, _jquery2.default)('#' + this.$handle.attr('aria-controls'));
      this.$fill = this.$element.find('[data-slider-fill]').css(this.options.vertical ? 'height' : 'width', 0);

      var isDbl = false,
          _this = this;
      if (this.options.disabled || this.$element.hasClass(this.options.disabledClass)) {
        this.options.disabled = true;
        this.$element.addClass(this.options.disabledClass);
      }
      if (!this.inputs.length) {
        this.inputs = (0, _jquery2.default)().add(this.$input);
        this.options.binding = true;
      }

      this._setInitAttr(0);

      if (this.handles[1]) {
        this.options.doubleSided = true;
        this.$handle2 = this.handles.eq(1);
        this.$input2 = this.inputs.length > 1 ? this.inputs.eq(1) : (0, _jquery2.default)('#' + this.$handle2.attr('aria-controls'));

        if (!this.inputs[1]) {
          this.inputs = this.inputs.add(this.$input2);
        }
        isDbl = true;

        // this.$handle.triggerHandler('click.zf.slider');
        this._setInitAttr(1);
      }

      // Set handle positions
      this.setHandles();

      this._events();
    }
  }, {
    key: 'setHandles',
    value: function setHandles() {
      var _this3 = this;

      if (this.handles[1]) {
        this._setHandlePos(this.$handle, this.inputs.eq(0).val(), true, function () {
          _this3._setHandlePos(_this3.$handle2, _this3.inputs.eq(1).val(), true);
        });
      } else {
        this._setHandlePos(this.$handle, this.inputs.eq(0).val(), true);
      }
    }
  }, {
    key: '_reflow',
    value: function _reflow() {
      this.setHandles();
    }
    /**
    * @function
    * @private
    * @param {Number} value - floating point (the value) to be transformed using to a relative position on the slider (the inverse of _value)
    */

  }, {
    key: '_pctOfBar',
    value: function _pctOfBar(value) {
      var pctOfBar = percent(value - this.options.start, this.options.end - this.options.start);

      switch (this.options.positionValueFunction) {
        case "pow":
          pctOfBar = this._logTransform(pctOfBar);
          break;
        case "log":
          pctOfBar = this._powTransform(pctOfBar);
          break;
      }

      return pctOfBar.toFixed(2);
    }

    /**
    * @function
    * @private
    * @param {Number} pctOfBar - floating point, the relative position of the slider (typically between 0-1) to be transformed to a value
    */

  }, {
    key: '_value',
    value: function _value(pctOfBar) {
      switch (this.options.positionValueFunction) {
        case "pow":
          pctOfBar = this._powTransform(pctOfBar);
          break;
        case "log":
          pctOfBar = this._logTransform(pctOfBar);
          break;
      }
      var value = (this.options.end - this.options.start) * pctOfBar + this.options.start;

      return value;
    }

    /**
    * @function
    * @private
    * @param {Number} value - floating point (typically between 0-1) to be transformed using the log function
    */

  }, {
    key: '_logTransform',
    value: function _logTransform(value) {
      return baseLog(this.options.nonLinearBase, value * (this.options.nonLinearBase - 1) + 1);
    }

    /**
    * @function
    * @private
    * @param {Number} value - floating point (typically between 0-1) to be transformed using the power function
    */

  }, {
    key: '_powTransform',
    value: function _powTransform(value) {
      return (Math.pow(this.options.nonLinearBase, value) - 1) / (this.options.nonLinearBase - 1);
    }

    /**
     * Sets the position of the selected handle and fill bar.
     * @function
     * @private
     * @param {jQuery} $hndl - the selected handle to move.
     * @param {Number} location - floating point between the start and end values of the slider bar.
     * @param {Function} cb - callback function to fire on completion.
     * @fires Slider#moved
     * @fires Slider#changed
     */

  }, {
    key: '_setHandlePos',
    value: function _setHandlePos($hndl, location, noInvert, cb) {
      // don't move if the slider has been disabled since its initialization
      if (this.$element.hasClass(this.options.disabledClass)) {
        return;
      }
      //might need to alter that slightly for bars that will have odd number selections.
      location = parseFloat(location); //on input change events, convert string to number...grumble.

      // prevent slider from running out of bounds, if value exceeds the limits set through options, override the value to min/max
      if (location < this.options.start) {
        location = this.options.start;
      } else if (location > this.options.end) {
        location = this.options.end;
      }

      var isDbl = this.options.doubleSided;

      //this is for single-handled vertical sliders, it adjusts the value to account for the slider being "upside-down"
      //for click and drag events, it's weird due to the scale(-1, 1) css property
      if (this.options.vertical && !noInvert) {
        location = this.options.end - location;
      }

      if (isDbl) {
        //this block is to prevent 2 handles from crossing eachother. Could/should be improved.
        if (this.handles.index($hndl) === 0) {
          var h2Val = parseFloat(this.$handle2.attr('aria-valuenow'));
          location = location >= h2Val ? h2Val - this.options.step : location;
        } else {
          var h1Val = parseFloat(this.$handle.attr('aria-valuenow'));
          location = location <= h1Val ? h1Val + this.options.step : location;
        }
      }

      var _this = this,
          vert = this.options.vertical,
          hOrW = vert ? 'height' : 'width',
          lOrT = vert ? 'top' : 'left',
          handleDim = $hndl[0].getBoundingClientRect()[hOrW],
          elemDim = this.$element[0].getBoundingClientRect()[hOrW],

      //percentage of bar min/max value based on click or drag point
      pctOfBar = this._pctOfBar(location),

      //number of actual pixels to shift the handle, based on the percentage obtained above
      pxToMove = (elemDim - handleDim) * pctOfBar,

      //percentage of bar to shift the handle
      movement = (percent(pxToMove, elemDim) * 100).toFixed(this.options.decimal);
      //fixing the decimal value for the location number, is passed to other methods as a fixed floating-point value
      location = parseFloat(location.toFixed(this.options.decimal));
      // declare empty object for css adjustments, only used with 2 handled-sliders
      var css = {};

      this._setValues($hndl, location);

      // TODO update to calculate based on values set to respective inputs??
      if (isDbl) {
        var isLeftHndl = this.handles.index($hndl) === 0,

        //empty variable, will be used for min-height/width for fill bar
        dim,

        //percentage w/h of the handle compared to the slider bar
        handlePct = ~~(percent(handleDim, elemDim) * 100);
        //if left handle, the math is slightly different than if it's the right handle, and the left/top property needs to be changed for the fill bar
        if (isLeftHndl) {
          //left or top percentage value to apply to the fill bar.
          css[lOrT] = movement + '%';
          //calculate the new min-height/width for the fill bar.
          dim = parseFloat(this.$handle2[0].style[lOrT]) - movement + handlePct;
          //this callback is necessary to prevent errors and allow the proper placement and initialization of a 2-handled slider
          //plus, it means we don't care if 'dim' isNaN on init, it won't be in the future.
          if (cb && typeof cb === 'function') {
            cb();
          } //this is only needed for the initialization of 2 handled sliders
        } else {
          //just caching the value of the left/bottom handle's left/top property
          var handlePos = parseFloat(this.$handle[0].style[lOrT]);
          //calculate the new min-height/width for the fill bar. Use isNaN to prevent false positives for numbers <= 0
          //based on the percentage of movement of the handle being manipulated, less the opposing handle's left/top position, plus the percentage w/h of the handle itself
          dim = movement - (isNaN(handlePos) ? (this.options.initialStart - this.options.start) / ((this.options.end - this.options.start) / 100) : handlePos) + handlePct;
        }
        // assign the min-height/width to our css object
        css['min-' + hOrW] = dim + '%';
      }

      this.$element.one('finished.zf.animate', function () {
        /**
         * Fires when the handle is done moving.
         * @event Slider#moved
         */
        _this.$element.trigger('moved.zf.slider', [$hndl]);
      });

      //because we don't know exactly how the handle will be moved, check the amount of time it should take to move.
      var moveTime = this.$element.data('dragging') ? 1000 / 60 : this.options.moveTime;

      (0, _foundationUtil2.Move)(moveTime, $hndl, function () {
        // adjusting the left/top property of the handle, based on the percentage calculated above
        // if movement isNaN, that is because the slider is hidden and we cannot determine handle width,
        // fall back to next best guess.
        if (isNaN(movement)) {
          $hndl.css(lOrT, pctOfBar * 100 + '%');
        } else {
          $hndl.css(lOrT, movement + '%');
        }

        if (!_this.options.doubleSided) {
          //if single-handled, a simple method to expand the fill bar
          _this.$fill.css(hOrW, pctOfBar * 100 + '%');
        } else {
          //otherwise, use the css object we created above
          _this.$fill.css(css);
        }
      });

      /**
       * Fires when the value has not been change for a given time.
       * @event Slider#changed
       */
      clearTimeout(_this.timeout);
      _this.timeout = setTimeout(function () {
        _this.$element.trigger('changed.zf.slider', [$hndl]);
      }, _this.options.changedDelay);
    }

    /**
     * Sets the initial attribute for the slider element.
     * @function
     * @private
     * @param {Number} idx - index of the current handle/input to use.
     */

  }, {
    key: '_setInitAttr',
    value: function _setInitAttr(idx) {
      var initVal = idx === 0 ? this.options.initialStart : this.options.initialEnd;
      var id = this.inputs.eq(idx).attr('id') || (0, _foundationUtil3.GetYoDigits)(6, 'slider');
      this.inputs.eq(idx).attr({
        'id': id,
        'max': this.options.end,
        'min': this.options.start,
        'step': this.options.step
      });
      this.inputs.eq(idx).val(initVal);
      this.handles.eq(idx).attr({
        'role': 'slider',
        'aria-controls': id,
        'aria-valuemax': this.options.end,
        'aria-valuemin': this.options.start,
        'aria-valuenow': initVal,
        'aria-orientation': this.options.vertical ? 'vertical' : 'horizontal',
        'tabindex': 0
      });
    }

    /**
     * Sets the input and `aria-valuenow` values for the slider element.
     * @function
     * @private
     * @param {jQuery} $handle - the currently selected handle.
     * @param {Number} val - floating point of the new value.
     */

  }, {
    key: '_setValues',
    value: function _setValues($handle, val) {
      var idx = this.options.doubleSided ? this.handles.index($handle) : 0;
      this.inputs.eq(idx).val(val);
      $handle.attr('aria-valuenow', val);
    }

    /**
     * Handles events on the slider element.
     * Calculates the new location of the current handle.
     * If there are two handles and the bar was clicked, it determines which handle to move.
     * @function
     * @private
     * @param {Object} e - the `event` object passed from the listener.
     * @param {jQuery} $handle - the current handle to calculate for, if selected.
     * @param {Number} val - floating point number for the new value of the slider.
     * TODO clean this up, there's a lot of repeated code between this and the _setHandlePos fn.
     */

  }, {
    key: '_handleEvent',
    value: function _handleEvent(e, $handle, val) {
      var value, hasVal;
      if (!val) {
        //click or drag events
        e.preventDefault();
        var _this = this,
            vertical = this.options.vertical,
            param = vertical ? 'height' : 'width',
            direction = vertical ? 'top' : 'left',
            eventOffset = vertical ? e.pageY : e.pageX,
            halfOfHandle = this.$handle[0].getBoundingClientRect()[param] / 2,
            barDim = this.$element[0].getBoundingClientRect()[param],
            windowScroll = vertical ? (0, _jquery2.default)(window).scrollTop() : (0, _jquery2.default)(window).scrollLeft();

        var elemOffset = this.$element.offset()[direction];

        // touch events emulated by the touch util give position relative to screen, add window.scroll to event coordinates...
        // best way to guess this is simulated is if clientY == pageY
        if (e.clientY === e.pageY) {
          eventOffset = eventOffset + windowScroll;
        }
        var eventFromBar = eventOffset - elemOffset;
        var barXY;
        if (eventFromBar < 0) {
          barXY = 0;
        } else if (eventFromBar > barDim) {
          barXY = barDim;
        } else {
          barXY = eventFromBar;
        }
        var offsetPct = percent(barXY, barDim);

        value = this._value(offsetPct);

        // turn everything around for RTL, yay math!
        if ((0, _foundationUtil3.rtl)() && !this.options.vertical) {
          value = this.options.end - value;
        }

        value = _this._adjustValue(null, value);
        //boolean flag for the setHandlePos fn, specifically for vertical sliders
        hasVal = false;

        if (!$handle) {
          //figure out which handle it is, pass it to the next function.
          var firstHndlPos = absPosition(this.$handle, direction, barXY, param),
              secndHndlPos = absPosition(this.$handle2, direction, barXY, param);
          $handle = firstHndlPos <= secndHndlPos ? this.$handle : this.$handle2;
        }
      } else {
        //change event on input
        value = this._adjustValue(null, val);
        hasVal = true;
      }

      this._setHandlePos($handle, value, hasVal);
    }

    /**
     * Adjustes value for handle in regard to step value. returns adjusted value
     * @function
     * @private
     * @param {jQuery} $handle - the selected handle.
     * @param {Number} value - value to adjust. used if $handle is falsy
     */

  }, {
    key: '_adjustValue',
    value: function _adjustValue($handle, value) {
      var val,
          step = this.options.step,
          div = parseFloat(step / 2),
          left,
          prev_val,
          next_val;
      if (!!$handle) {
        val = parseFloat($handle.attr('aria-valuenow'));
      } else {
        val = value;
      }
      left = val % step;
      prev_val = val - left;
      next_val = prev_val + step;
      if (left === 0) {
        return val;
      }
      val = val >= prev_val + div ? next_val : prev_val;
      return val;
    }

    /**
     * Adds event listeners to the slider elements.
     * @function
     * @private
     */

  }, {
    key: '_events',
    value: function _events() {
      this._eventsForHandle(this.$handle);
      if (this.handles[1]) {
        this._eventsForHandle(this.$handle2);
      }
    }

    /**
     * Adds event listeners a particular handle
     * @function
     * @private
     * @param {jQuery} $handle - the current handle to apply listeners to.
     */

  }, {
    key: '_eventsForHandle',
    value: function _eventsForHandle($handle) {
      var _this = this,
          curHandle,
          timer;

      this.inputs.off('change.zf.slider').on('change.zf.slider', function (e) {
        var idx = _this.inputs.index((0, _jquery2.default)(this));
        _this._handleEvent(e, _this.handles.eq(idx), (0, _jquery2.default)(this).val());
      });

      if (this.options.clickSelect) {
        this.$element.off('click.zf.slider').on('click.zf.slider', function (e) {
          if (_this.$element.data('dragging')) {
            return false;
          }

          if (!(0, _jquery2.default)(e.target).is('[data-slider-handle]')) {
            if (_this.options.doubleSided) {
              _this._handleEvent(e);
            } else {
              _this._handleEvent(e, _this.$handle);
            }
          }
        });
      }

      if (this.options.draggable) {
        this.handles.addTouch();

        var $body = (0, _jquery2.default)('body');
        $handle.off('mousedown.zf.slider').on('mousedown.zf.slider', function (e) {
          $handle.addClass('is-dragging');
          _this.$fill.addClass('is-dragging'); //
          _this.$element.data('dragging', true);

          curHandle = (0, _jquery2.default)(e.currentTarget);

          $body.on('mousemove.zf.slider', function (e) {
            e.preventDefault();
            _this._handleEvent(e, curHandle);
          }).on('mouseup.zf.slider', function (e) {
            _this._handleEvent(e, curHandle);

            $handle.removeClass('is-dragging');
            _this.$fill.removeClass('is-dragging');
            _this.$element.data('dragging', false);

            $body.off('mousemove.zf.slider mouseup.zf.slider');
          });
        })
        // prevent events triggered by touch
        .on('selectstart.zf.slider touchmove.zf.slider', function (e) {
          e.preventDefault();
        });
      }

      $handle.off('keydown.zf.slider').on('keydown.zf.slider', function (e) {
        var _$handle = (0, _jquery2.default)(this),
            idx = _this.options.doubleSided ? _this.handles.index(_$handle) : 0,
            oldValue = parseFloat(_this.inputs.eq(idx).val()),
            newValue;

        // handle keyboard event with keyboard util
        _foundationUtil.Keyboard.handleKey(e, 'Slider', {
          decrease: function decrease() {
            newValue = oldValue - _this.options.step;
          },
          increase: function increase() {
            newValue = oldValue + _this.options.step;
          },
          decrease_fast: function decrease_fast() {
            newValue = oldValue - _this.options.step * 10;
          },
          increase_fast: function increase_fast() {
            newValue = oldValue + _this.options.step * 10;
          },
          min: function min() {
            newValue = _this.options.start;
          },
          max: function max() {
            newValue = _this.options.end;
          },
          handled: function handled() {
            // only set handle pos when event was handled specially
            e.preventDefault();
            _this._setHandlePos(_$handle, newValue, true);
          }
        });
        /*if (newValue) { // if pressed key has special function, update value
          e.preventDefault();
          _this._setHandlePos(_$handle, newValue);
        }*/
      });
    }

    /**
     * Destroys the slider plugin.
     */

  }, {
    key: '_destroy',
    value: function _destroy() {
      this.handles.off('.zf.slider');
      this.inputs.off('.zf.slider');
      this.$element.off('.zf.slider');

      clearTimeout(this.timeout);
    }
  }]);

  return Slider;
}(_foundation.Plugin);

Slider.defaults = {
  /**
   * Minimum value for the slider scale.
   * @option
   * @type {number}
   * @default 0
   */
  start: 0,
  /**
   * Maximum value for the slider scale.
   * @option
   * @type {number}
   * @default 100
   */
  end: 100,
  /**
   * Minimum value change per change event.
   * @option
   * @type {number}
   * @default 1
   */
  step: 1,
  /**
   * Value at which the handle/input *(left handle/first input)* should be set to on initialization.
   * @option
   * @type {number}
   * @default 0
   */
  initialStart: 0,
  /**
   * Value at which the right handle/second input should be set to on initialization.
   * @option
   * @type {number}
   * @default 100
   */
  initialEnd: 100,
  /**
   * Allows the input to be located outside the container and visible. Set to by the JS
   * @option
   * @type {boolean}
   * @default false
   */
  binding: false,
  /**
   * Allows the user to click/tap on the slider bar to select a value.
   * @option
   * @type {boolean}
   * @default true
   */
  clickSelect: true,
  /**
   * Set to true and use the `vertical` class to change alignment to vertical.
   * @option
   * @type {boolean}
   * @default false
   */
  vertical: false,
  /**
   * Allows the user to drag the slider handle(s) to select a value.
   * @option
   * @type {boolean}
   * @default true
   */
  draggable: true,
  /**
   * Disables the slider and prevents event listeners from being applied. Double checked by JS with `disabledClass`.
   * @option
   * @type {boolean}
   * @default false
   */
  disabled: false,
  /**
   * Allows the use of two handles. Double checked by the JS. Changes some logic handling.
   * @option
   * @type {boolean}
   * @default false
   */
  doubleSided: false,
  /**
   * Potential future feature.
   */
  // steps: 100,
  /**
   * Number of decimal places the plugin should go to for floating point precision.
   * @option
   * @type {number}
   * @default 2
   */
  decimal: 2,
  /**
   * Time delay for dragged elements.
   */
  // dragDelay: 0,
  /**
   * Time, in ms, to animate the movement of a slider handle if user clicks/taps on the bar. Needs to be manually set if updating the transition time in the Sass settings.
   * @option
   * @type {number}
   * @default 200
   */
  moveTime: 200, //update this if changing the transition time in the sass
  /**
   * Class applied to disabled sliders.
   * @option
   * @type {string}
   * @default 'disabled'
   */
  disabledClass: 'disabled',
  /**
   * Will invert the default layout for a vertical<span data-tooltip title="who would do this???"> </span>slider.
   * @option
   * @type {boolean}
   * @default false
   */
  invertVertical: false,
  /**
   * Milliseconds before the `changed.zf-slider` event is triggered after value change.
   * @option
   * @type {number}
   * @default 500
   */
  changedDelay: 500,
  /**
  * Basevalue for non-linear sliders
  * @option
  * @type {number}
  * @default 5
  */
  nonLinearBase: 5,
  /**
  * Basevalue for non-linear sliders, possible values are: `'linear'`, `'pow'` & `'log'`. Pow and Log use the nonLinearBase setting.
  * @option
  * @type {string}
  * @default 'linear'
  */
  positionValueFunction: 'linear'
};

function percent(frac, num) {
  return frac / num;
}
function absPosition($handle, dir, clickPos, param) {
  return Math.abs($handle.position()[dir] + $handle[param]() / 2 - clickPos);
}
function baseLog(base, value) {
  return Math.log(value) / Math.log(base);
}

exports.Slider = Slider;

/***/ }),
/* 35 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Sticky = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _foundationUtil = __webpack_require__(1);

var _foundationUtil2 = __webpack_require__(3);

var _foundation = __webpack_require__(2);

var _foundationUtil3 = __webpack_require__(5);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * Sticky module.
 * @module foundation.sticky
 * @requires foundation.util.triggers
 * @requires foundation.util.mediaQuery
 */

var Sticky = function (_Plugin) {
  _inherits(Sticky, _Plugin);

  function Sticky() {
    _classCallCheck(this, Sticky);

    return _possibleConstructorReturn(this, (Sticky.__proto__ || Object.getPrototypeOf(Sticky)).apply(this, arguments));
  }

  _createClass(Sticky, [{
    key: '_setup',

    /**
     * Creates a new instance of a sticky thing.
     * @class
     * @name Sticky
     * @param {jQuery} element - jQuery object to make sticky.
     * @param {Object} options - options object passed when creating the element programmatically.
     */
    value: function _setup(element, options) {
      this.$element = element;
      this.options = _jquery2.default.extend({}, Sticky.defaults, this.$element.data(), options);
      this.className = 'Sticky'; // ie9 back compat

      // Triggers init is idempotent, just need to make sure it is initialized
      _foundationUtil3.Triggers.init(_jquery2.default);

      this._init();
    }

    /**
     * Initializes the sticky element by adding classes, getting/setting dimensions, breakpoints and attributes
     * @function
     * @private
     */

  }, {
    key: '_init',
    value: function _init() {
      _foundationUtil2.MediaQuery._init();

      var $parent = this.$element.parent('[data-sticky-container]'),
          id = this.$element[0].id || (0, _foundationUtil.GetYoDigits)(6, 'sticky'),
          _this = this;

      if ($parent.length) {
        this.$container = $parent;
      } else {
        this.wasWrapped = true;
        this.$element.wrap(this.options.container);
        this.$container = this.$element.parent();
      }
      this.$container.addClass(this.options.containerClass);

      this.$element.addClass(this.options.stickyClass).attr({ 'data-resize': id, 'data-mutate': id });
      if (this.options.anchor !== '') {
        (0, _jquery2.default)('#' + _this.options.anchor).attr({ 'data-mutate': id });
      }

      this.scrollCount = this.options.checkEvery;
      this.isStuck = false;
      (0, _jquery2.default)(window).one('load.zf.sticky', function () {
        //We calculate the container height to have correct values for anchor points offset calculation.
        _this.containerHeight = _this.$element.css("display") == "none" ? 0 : _this.$element[0].getBoundingClientRect().height;
        _this.$container.css('height', _this.containerHeight);
        _this.elemHeight = _this.containerHeight;
        if (_this.options.anchor !== '') {
          _this.$anchor = (0, _jquery2.default)('#' + _this.options.anchor);
        } else {
          _this._parsePoints();
        }

        _this._setSizes(function () {
          var scroll = window.pageYOffset;
          _this._calc(false, scroll);
          //Unstick the element will ensure that proper classes are set.
          if (!_this.isStuck) {
            _this._removeSticky(scroll >= _this.topPoint ? false : true);
          }
        });
        _this._events(id.split('-').reverse().join('-'));
      });
    }

    /**
     * If using multiple elements as anchors, calculates the top and bottom pixel values the sticky thing should stick and unstick on.
     * @function
     * @private
     */

  }, {
    key: '_parsePoints',
    value: function _parsePoints() {
      var top = this.options.topAnchor == "" ? 1 : this.options.topAnchor,
          btm = this.options.btmAnchor == "" ? document.documentElement.scrollHeight : this.options.btmAnchor,
          pts = [top, btm],
          breaks = {};
      for (var i = 0, len = pts.length; i < len && pts[i]; i++) {
        var pt;
        if (typeof pts[i] === 'number') {
          pt = pts[i];
        } else {
          var place = pts[i].split(':'),
              anchor = (0, _jquery2.default)('#' + place[0]);

          pt = anchor.offset().top;
          if (place[1] && place[1].toLowerCase() === 'bottom') {
            pt += anchor[0].getBoundingClientRect().height;
          }
        }
        breaks[i] = pt;
      }

      this.points = breaks;
      return;
    }

    /**
     * Adds event handlers for the scrolling element.
     * @private
     * @param {String} id - pseudo-random id for unique scroll event listener.
     */

  }, {
    key: '_events',
    value: function _events(id) {
      var _this = this,
          scrollListener = this.scrollListener = 'scroll.zf.' + id;
      if (this.isOn) {
        return;
      }
      if (this.canStick) {
        this.isOn = true;
        (0, _jquery2.default)(window).off(scrollListener).on(scrollListener, function (e) {
          if (_this.scrollCount === 0) {
            _this.scrollCount = _this.options.checkEvery;
            _this._setSizes(function () {
              _this._calc(false, window.pageYOffset);
            });
          } else {
            _this.scrollCount--;
            _this._calc(false, window.pageYOffset);
          }
        });
      }

      this.$element.off('resizeme.zf.trigger').on('resizeme.zf.trigger', function (e, el) {
        _this._eventsHandler(id);
      });

      this.$element.on('mutateme.zf.trigger', function (e, el) {
        _this._eventsHandler(id);
      });

      if (this.$anchor) {
        this.$anchor.on('mutateme.zf.trigger', function (e, el) {
          _this._eventsHandler(id);
        });
      }
    }

    /**
     * Handler for events.
     * @private
     * @param {String} id - pseudo-random id for unique scroll event listener.
     */

  }, {
    key: '_eventsHandler',
    value: function _eventsHandler(id) {
      var _this = this,
          scrollListener = this.scrollListener = 'scroll.zf.' + id;

      _this._setSizes(function () {
        _this._calc(false);
        if (_this.canStick) {
          if (!_this.isOn) {
            _this._events(id);
          }
        } else if (_this.isOn) {
          _this._pauseListeners(scrollListener);
        }
      });
    }

    /**
     * Removes event handlers for scroll and change events on anchor.
     * @fires Sticky#pause
     * @param {String} scrollListener - unique, namespaced scroll listener attached to `window`
     */

  }, {
    key: '_pauseListeners',
    value: function _pauseListeners(scrollListener) {
      this.isOn = false;
      (0, _jquery2.default)(window).off(scrollListener);

      /**
       * Fires when the plugin is paused due to resize event shrinking the view.
       * @event Sticky#pause
       * @private
       */
      this.$element.trigger('pause.zf.sticky');
    }

    /**
     * Called on every `scroll` event and on `_init`
     * fires functions based on booleans and cached values
     * @param {Boolean} checkSizes - true if plugin should recalculate sizes and breakpoints.
     * @param {Number} scroll - current scroll position passed from scroll event cb function. If not passed, defaults to `window.pageYOffset`.
     */

  }, {
    key: '_calc',
    value: function _calc(checkSizes, scroll) {
      if (checkSizes) {
        this._setSizes();
      }

      if (!this.canStick) {
        if (this.isStuck) {
          this._removeSticky(true);
        }
        return false;
      }

      if (!scroll) {
        scroll = window.pageYOffset;
      }

      if (scroll >= this.topPoint) {
        if (scroll <= this.bottomPoint) {
          if (!this.isStuck) {
            this._setSticky();
          }
        } else {
          if (this.isStuck) {
            this._removeSticky(false);
          }
        }
      } else {
        if (this.isStuck) {
          this._removeSticky(true);
        }
      }
    }

    /**
     * Causes the $element to become stuck.
     * Adds `position: fixed;`, and helper classes.
     * @fires Sticky#stuckto
     * @function
     * @private
     */

  }, {
    key: '_setSticky',
    value: function _setSticky() {
      var _this = this,
          stickTo = this.options.stickTo,
          mrgn = stickTo === 'top' ? 'marginTop' : 'marginBottom',
          notStuckTo = stickTo === 'top' ? 'bottom' : 'top',
          css = {};

      css[mrgn] = this.options[mrgn] + 'em';
      css[stickTo] = 0;
      css[notStuckTo] = 'auto';
      this.isStuck = true;
      this.$element.removeClass('is-anchored is-at-' + notStuckTo).addClass('is-stuck is-at-' + stickTo).css(css)
      /**
       * Fires when the $element has become `position: fixed;`
       * Namespaced to `top` or `bottom`, e.g. `sticky.zf.stuckto:top`
       * @event Sticky#stuckto
       */
      .trigger('sticky.zf.stuckto:' + stickTo);
      this.$element.on("transitionend webkitTransitionEnd oTransitionEnd otransitionend MSTransitionEnd", function () {
        _this._setSizes();
      });
    }

    /**
     * Causes the $element to become unstuck.
     * Removes `position: fixed;`, and helper classes.
     * Adds other helper classes.
     * @param {Boolean} isTop - tells the function if the $element should anchor to the top or bottom of its $anchor element.
     * @fires Sticky#unstuckfrom
     * @private
     */

  }, {
    key: '_removeSticky',
    value: function _removeSticky(isTop) {
      var stickTo = this.options.stickTo,
          stickToTop = stickTo === 'top',
          css = {},
          anchorPt = (this.points ? this.points[1] - this.points[0] : this.anchorHeight) - this.elemHeight,
          mrgn = stickToTop ? 'marginTop' : 'marginBottom',
          notStuckTo = stickToTop ? 'bottom' : 'top',
          topOrBottom = isTop ? 'top' : 'bottom';

      css[mrgn] = 0;

      css['bottom'] = 'auto';
      if (isTop) {
        css['top'] = 0;
      } else {
        css['top'] = anchorPt;
      }

      this.isStuck = false;
      this.$element.removeClass('is-stuck is-at-' + stickTo).addClass('is-anchored is-at-' + topOrBottom).css(css)
      /**
       * Fires when the $element has become anchored.
       * Namespaced to `top` or `bottom`, e.g. `sticky.zf.unstuckfrom:bottom`
       * @event Sticky#unstuckfrom
       */
      .trigger('sticky.zf.unstuckfrom:' + topOrBottom);
    }

    /**
     * Sets the $element and $container sizes for plugin.
     * Calls `_setBreakPoints`.
     * @param {Function} cb - optional callback function to fire on completion of `_setBreakPoints`.
     * @private
     */

  }, {
    key: '_setSizes',
    value: function _setSizes(cb) {
      this.canStick = _foundationUtil2.MediaQuery.is(this.options.stickyOn);
      if (!this.canStick) {
        if (cb && typeof cb === 'function') {
          cb();
        }
      }
      var _this = this,
          newElemWidth = this.$container[0].getBoundingClientRect().width,
          comp = window.getComputedStyle(this.$container[0]),
          pdngl = parseInt(comp['padding-left'], 10),
          pdngr = parseInt(comp['padding-right'], 10);

      if (this.$anchor && this.$anchor.length) {
        this.anchorHeight = this.$anchor[0].getBoundingClientRect().height;
      } else {
        this._parsePoints();
      }

      this.$element.css({
        'max-width': newElemWidth - pdngl - pdngr + 'px'
      });

      var newContainerHeight = this.$element[0].getBoundingClientRect().height || this.containerHeight;
      if (this.$element.css("display") == "none") {
        newContainerHeight = 0;
      }
      this.containerHeight = newContainerHeight;
      this.$container.css({
        height: newContainerHeight
      });
      this.elemHeight = newContainerHeight;

      if (!this.isStuck) {
        if (this.$element.hasClass('is-at-bottom')) {
          var anchorPt = (this.points ? this.points[1] - this.$container.offset().top : this.anchorHeight) - this.elemHeight;
          this.$element.css('top', anchorPt);
        }
      }

      this._setBreakPoints(newContainerHeight, function () {
        if (cb && typeof cb === 'function') {
          cb();
        }
      });
    }

    /**
     * Sets the upper and lower breakpoints for the element to become sticky/unsticky.
     * @param {Number} elemHeight - px value for sticky.$element height, calculated by `_setSizes`.
     * @param {Function} cb - optional callback function to be called on completion.
     * @private
     */

  }, {
    key: '_setBreakPoints',
    value: function _setBreakPoints(elemHeight, cb) {
      if (!this.canStick) {
        if (cb && typeof cb === 'function') {
          cb();
        } else {
          return false;
        }
      }
      var mTop = emCalc(this.options.marginTop),
          mBtm = emCalc(this.options.marginBottom),
          topPoint = this.points ? this.points[0] : this.$anchor.offset().top,
          bottomPoint = this.points ? this.points[1] : topPoint + this.anchorHeight,

      // topPoint = this.$anchor.offset().top || this.points[0],
      // bottomPoint = topPoint + this.anchorHeight || this.points[1],
      winHeight = window.innerHeight;

      if (this.options.stickTo === 'top') {
        topPoint -= mTop;
        bottomPoint -= elemHeight + mTop;
      } else if (this.options.stickTo === 'bottom') {
        topPoint -= winHeight - (elemHeight + mBtm);
        bottomPoint -= winHeight - mBtm;
      } else {
        //this would be the stickTo: both option... tricky
      }

      this.topPoint = topPoint;
      this.bottomPoint = bottomPoint;

      if (cb && typeof cb === 'function') {
        cb();
      }
    }

    /**
     * Destroys the current sticky element.
     * Resets the element to the top position first.
     * Removes event listeners, JS-added css properties and classes, and unwraps the $element if the JS added the $container.
     * @function
     */

  }, {
    key: '_destroy',
    value: function _destroy() {
      this._removeSticky(true);

      this.$element.removeClass(this.options.stickyClass + ' is-anchored is-at-top').css({
        height: '',
        top: '',
        bottom: '',
        'max-width': ''
      }).off('resizeme.zf.trigger').off('mutateme.zf.trigger');
      if (this.$anchor && this.$anchor.length) {
        this.$anchor.off('change.zf.sticky');
      }
      (0, _jquery2.default)(window).off(this.scrollListener);

      if (this.wasWrapped) {
        this.$element.unwrap();
      } else {
        this.$container.removeClass(this.options.containerClass).css({
          height: ''
        });
      }
    }
  }]);

  return Sticky;
}(_foundation.Plugin);

Sticky.defaults = {
  /**
   * Customizable container template. Add your own classes for styling and sizing.
   * @option
   * @type {string}
   * @default '&lt;div data-sticky-container&gt;&lt;/div&gt;'
   */
  container: '<div data-sticky-container></div>',
  /**
   * Location in the view the element sticks to. Can be `'top'` or `'bottom'`.
   * @option
   * @type {string}
   * @default 'top'
   */
  stickTo: 'top',
  /**
   * If anchored to a single element, the id of that element.
   * @option
   * @type {string}
   * @default ''
   */
  anchor: '',
  /**
   * If using more than one element as anchor points, the id of the top anchor.
   * @option
   * @type {string}
   * @default ''
   */
  topAnchor: '',
  /**
   * If using more than one element as anchor points, the id of the bottom anchor.
   * @option
   * @type {string}
   * @default ''
   */
  btmAnchor: '',
  /**
   * Margin, in `em`'s to apply to the top of the element when it becomes sticky.
   * @option
   * @type {number}
   * @default 1
   */
  marginTop: 1,
  /**
   * Margin, in `em`'s to apply to the bottom of the element when it becomes sticky.
   * @option
   * @type {number}
   * @default 1
   */
  marginBottom: 1,
  /**
   * Breakpoint string that is the minimum screen size an element should become sticky.
   * @option
   * @type {string}
   * @default 'medium'
   */
  stickyOn: 'medium',
  /**
   * Class applied to sticky element, and removed on destruction. Foundation defaults to `sticky`.
   * @option
   * @type {string}
   * @default 'sticky'
   */
  stickyClass: 'sticky',
  /**
   * Class applied to sticky container. Foundation defaults to `sticky-container`.
   * @option
   * @type {string}
   * @default 'sticky-container'
   */
  containerClass: 'sticky-container',
  /**
   * Number of scroll events between the plugin's recalculating sticky points. Setting it to `0` will cause it to recalc every scroll event, setting it to `-1` will prevent recalc on scroll.
   * @option
   * @type {number}
   * @default -1
   */
  checkEvery: -1
};

/**
 * Helper function to calculate em values
 * @param Number {em} - number of em's to calculate into pixels
 */
function emCalc(em) {
  return parseInt(window.getComputedStyle(document.body, null).fontSize, 10) * em;
}

exports.Sticky = Sticky;

/***/ }),
/* 36 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Toggler = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _foundationUtil = __webpack_require__(6);

var _foundation = __webpack_require__(2);

var _foundationUtil2 = __webpack_require__(5);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * Toggler module.
 * @module foundation.toggler
 * @requires foundation.util.motion
 * @requires foundation.util.triggers
 */

var Toggler = function (_Plugin) {
  _inherits(Toggler, _Plugin);

  function Toggler() {
    _classCallCheck(this, Toggler);

    return _possibleConstructorReturn(this, (Toggler.__proto__ || Object.getPrototypeOf(Toggler)).apply(this, arguments));
  }

  _createClass(Toggler, [{
    key: '_setup',

    /**
     * Creates a new instance of Toggler.
     * @class
     * @name Toggler
     * @fires Toggler#init
     * @param {Object} element - jQuery object to add the trigger to.
     * @param {Object} options - Overrides to the default plugin settings.
     */
    value: function _setup(element, options) {
      this.$element = element;
      this.options = _jquery2.default.extend({}, Toggler.defaults, element.data(), options);
      this.className = '';
      this.className = 'Toggler'; // ie9 back compat

      // Triggers init is idempotent, just need to make sure it is initialized
      _foundationUtil2.Triggers.init(_jquery2.default);

      this._init();
      this._events();
    }

    /**
     * Initializes the Toggler plugin by parsing the toggle class from data-toggler, or animation classes from data-animate.
     * @function
     * @private
     */

  }, {
    key: '_init',
    value: function _init() {
      var input;
      // Parse animation classes if they were set
      if (this.options.animate) {
        input = this.options.animate.split(' ');

        this.animationIn = input[0];
        this.animationOut = input[1] || null;
      }
      // Otherwise, parse toggle class
      else {
          input = this.$element.data('toggler');
          // Allow for a . at the beginning of the string
          this.className = input[0] === '.' ? input.slice(1) : input;
        }

      // Add ARIA attributes to triggers
      var id = this.$element[0].id;
      (0, _jquery2.default)('[data-open="' + id + '"], [data-close="' + id + '"], [data-toggle="' + id + '"]').attr('aria-controls', id);
      // If the target is hidden, add aria-hidden
      this.$element.attr('aria-expanded', this.$element.is(':hidden') ? false : true);
    }

    /**
     * Initializes events for the toggle trigger.
     * @function
     * @private
     */

  }, {
    key: '_events',
    value: function _events() {
      this.$element.off('toggle.zf.trigger').on('toggle.zf.trigger', this.toggle.bind(this));
    }

    /**
     * Toggles the target class on the target element. An event is fired from the original trigger depending on if the resultant state was "on" or "off".
     * @function
     * @fires Toggler#on
     * @fires Toggler#off
     */

  }, {
    key: 'toggle',
    value: function toggle() {
      this[this.options.animate ? '_toggleAnimate' : '_toggleClass']();
    }
  }, {
    key: '_toggleClass',
    value: function _toggleClass() {
      this.$element.toggleClass(this.className);

      var isOn = this.$element.hasClass(this.className);
      if (isOn) {
        /**
         * Fires if the target element has the class after a toggle.
         * @event Toggler#on
         */
        this.$element.trigger('on.zf.toggler');
      } else {
        /**
         * Fires if the target element does not have the class after a toggle.
         * @event Toggler#off
         */
        this.$element.trigger('off.zf.toggler');
      }

      this._updateARIA(isOn);
      this.$element.find('[data-mutate]').trigger('mutateme.zf.trigger');
    }
  }, {
    key: '_toggleAnimate',
    value: function _toggleAnimate() {
      var _this = this;

      if (this.$element.is(':hidden')) {
        _foundationUtil.Motion.animateIn(this.$element, this.animationIn, function () {
          _this._updateARIA(true);
          this.trigger('on.zf.toggler');
          this.find('[data-mutate]').trigger('mutateme.zf.trigger');
        });
      } else {
        _foundationUtil.Motion.animateOut(this.$element, this.animationOut, function () {
          _this._updateARIA(false);
          this.trigger('off.zf.toggler');
          this.find('[data-mutate]').trigger('mutateme.zf.trigger');
        });
      }
    }
  }, {
    key: '_updateARIA',
    value: function _updateARIA(isOn) {
      this.$element.attr('aria-expanded', isOn ? true : false);
    }

    /**
     * Destroys the instance of Toggler on the element.
     * @function
     */

  }, {
    key: '_destroy',
    value: function _destroy() {
      this.$element.off('.zf.toggler');
    }
  }]);

  return Toggler;
}(_foundation.Plugin);

Toggler.defaults = {
  /**
   * Tells the plugin if the element should animated when toggled.
   * @option
   * @type {boolean}
   * @default false
   */
  animate: false
};

exports.Toggler = Toggler;

/***/ }),
/* 37 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tooltip = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _foundationUtil = __webpack_require__(1);

var _foundationUtil2 = __webpack_require__(3);

var _foundationUtil3 = __webpack_require__(5);

var _foundation = __webpack_require__(15);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * Tooltip module.
 * @module foundation.tooltip
 * @requires foundation.util.box
 * @requires foundation.util.mediaQuery
 * @requires foundation.util.triggers
 */

var Tooltip = function (_Positionable) {
  _inherits(Tooltip, _Positionable);

  function Tooltip() {
    _classCallCheck(this, Tooltip);

    return _possibleConstructorReturn(this, (Tooltip.__proto__ || Object.getPrototypeOf(Tooltip)).apply(this, arguments));
  }

  _createClass(Tooltip, [{
    key: '_setup',

    /**
     * Creates a new instance of a Tooltip.
     * @class
     * @name Tooltip
     * @fires Tooltip#init
     * @param {jQuery} element - jQuery object to attach a tooltip to.
     * @param {Object} options - object to extend the default configuration.
     */
    value: function _setup(element, options) {
      this.$element = element;
      this.options = _jquery2.default.extend({}, Tooltip.defaults, this.$element.data(), options);
      this.className = 'Tooltip'; // ie9 back compat

      this.isActive = false;
      this.isClick = false;

      // Triggers init is idempotent, just need to make sure it is initialized
      _foundationUtil3.Triggers.init(_jquery2.default);

      this._init();
    }

    /**
     * Initializes the tooltip by setting the creating the tip element, adding it's text, setting private variables and setting attributes on the anchor.
     * @private
     */

  }, {
    key: '_init',
    value: function _init() {
      _foundationUtil2.MediaQuery._init();
      var elemId = this.$element.attr('aria-describedby') || (0, _foundationUtil.GetYoDigits)(6, 'tooltip');

      this.options.tipText = this.options.tipText || this.$element.attr('title');
      this.template = this.options.template ? (0, _jquery2.default)(this.options.template) : this._buildTemplate(elemId);

      if (this.options.allowHtml) {
        this.template.appendTo(document.body).html(this.options.tipText).hide();
      } else {
        this.template.appendTo(document.body).text(this.options.tipText).hide();
      }

      this.$element.attr({
        'title': '',
        'aria-describedby': elemId,
        'data-yeti-box': elemId,
        'data-toggle': elemId,
        'data-resize': elemId
      }).addClass(this.options.triggerClass);

      _get(Tooltip.prototype.__proto__ || Object.getPrototypeOf(Tooltip.prototype), '_init', this).call(this);
      this._events();
    }
  }, {
    key: '_getDefaultPosition',
    value: function _getDefaultPosition() {
      // handle legacy classnames
      var position = this.$element[0].className.match(/\b(top|left|right|bottom)\b/g);
      return position ? position[0] : 'top';
    }
  }, {
    key: '_getDefaultAlignment',
    value: function _getDefaultAlignment() {
      return 'center';
    }
  }, {
    key: '_getHOffset',
    value: function _getHOffset() {
      if (this.position === 'left' || this.position === 'right') {
        return this.options.hOffset + this.options.tooltipWidth;
      } else {
        return this.options.hOffset;
      }
    }
  }, {
    key: '_getVOffset',
    value: function _getVOffset() {
      if (this.position === 'top' || this.position === 'bottom') {
        return this.options.vOffset + this.options.tooltipHeight;
      } else {
        return this.options.vOffset;
      }
    }

    /**
     * builds the tooltip element, adds attributes, and returns the template.
     * @private
     */

  }, {
    key: '_buildTemplate',
    value: function _buildTemplate(id) {
      var templateClasses = (this.options.tooltipClass + ' ' + this.options.positionClass + ' ' + this.options.templateClasses).trim();
      var $template = (0, _jquery2.default)('<div></div>').addClass(templateClasses).attr({
        'role': 'tooltip',
        'aria-hidden': true,
        'data-is-active': false,
        'data-is-focus': false,
        'id': id
      });
      return $template;
    }

    /**
     * sets the position class of an element and recursively calls itself until there are no more possible positions to attempt, or the tooltip element is no longer colliding.
     * if the tooltip is larger than the screen width, default to full width - any user selected margin
     * @private
     */

  }, {
    key: '_setPosition',
    value: function _setPosition() {
      _get(Tooltip.prototype.__proto__ || Object.getPrototypeOf(Tooltip.prototype), '_setPosition', this).call(this, this.$element, this.template);
    }

    /**
     * reveals the tooltip, and fires an event to close any other open tooltips on the page
     * @fires Tooltip#closeme
     * @fires Tooltip#show
     * @function
     */

  }, {
    key: 'show',
    value: function show() {
      if (this.options.showOn !== 'all' && !_foundationUtil2.MediaQuery.is(this.options.showOn)) {
        // console.error('The screen is too small to display this tooltip');
        return false;
      }

      var _this = this;
      this.template.css('visibility', 'hidden').show();
      this._setPosition();
      this.template.removeClass('top bottom left right').addClass(this.position);
      this.template.removeClass('align-top align-bottom align-left align-right align-center').addClass('align-' + this.alignment);

      /**
       * Fires to close all other open tooltips on the page
       * @event Closeme#tooltip
       */
      this.$element.trigger('closeme.zf.tooltip', this.template.attr('id'));

      this.template.attr({
        'data-is-active': true,
        'aria-hidden': false
      });
      _this.isActive = true;
      // console.log(this.template);
      this.template.stop().hide().css('visibility', '').fadeIn(this.options.fadeInDuration, function () {
        //maybe do stuff?
      });
      /**
       * Fires when the tooltip is shown
       * @event Tooltip#show
       */
      this.$element.trigger('show.zf.tooltip');
    }

    /**
     * Hides the current tooltip, and resets the positioning class if it was changed due to collision
     * @fires Tooltip#hide
     * @function
     */

  }, {
    key: 'hide',
    value: function hide() {
      // console.log('hiding', this.$element.data('yeti-box'));
      var _this = this;
      this.template.stop().attr({
        'aria-hidden': true,
        'data-is-active': false
      }).fadeOut(this.options.fadeOutDuration, function () {
        _this.isActive = false;
        _this.isClick = false;
      });
      /**
       * fires when the tooltip is hidden
       * @event Tooltip#hide
       */
      this.$element.trigger('hide.zf.tooltip');
    }

    /**
     * adds event listeners for the tooltip and its anchor
     * TODO combine some of the listeners like focus and mouseenter, etc.
     * @private
     */

  }, {
    key: '_events',
    value: function _events() {
      var _this = this;
      var $template = this.template;
      var isFocus = false;

      if (!this.options.disableHover) {

        this.$element.on('mouseenter.zf.tooltip', function (e) {
          if (!_this.isActive) {
            _this.timeout = setTimeout(function () {
              _this.show();
            }, _this.options.hoverDelay);
          }
        }).on('mouseleave.zf.tooltip', function (e) {
          clearTimeout(_this.timeout);
          if (!isFocus || _this.isClick && !_this.options.clickOpen) {
            _this.hide();
          }
        });
      }

      if (this.options.clickOpen) {
        this.$element.on('mousedown.zf.tooltip', function (e) {
          e.stopImmediatePropagation();
          if (_this.isClick) {
            //_this.hide();
            // _this.isClick = false;
          } else {
            _this.isClick = true;
            if ((_this.options.disableHover || !_this.$element.attr('tabindex')) && !_this.isActive) {
              _this.show();
            }
          }
        });
      } else {
        this.$element.on('mousedown.zf.tooltip', function (e) {
          e.stopImmediatePropagation();
          _this.isClick = true;
        });
      }

      if (!this.options.disableForTouch) {
        this.$element.on('tap.zf.tooltip touchend.zf.tooltip', function (e) {
          _this.isActive ? _this.hide() : _this.show();
        });
      }

      this.$element.on({
        // 'toggle.zf.trigger': this.toggle.bind(this),
        // 'close.zf.trigger': this.hide.bind(this)
        'close.zf.trigger': this.hide.bind(this)
      });

      this.$element.on('focus.zf.tooltip', function (e) {
        isFocus = true;
        if (_this.isClick) {
          // If we're not showing open on clicks, we need to pretend a click-launched focus isn't
          // a real focus, otherwise on hover and come back we get bad behavior
          if (!_this.options.clickOpen) {
            isFocus = false;
          }
          return false;
        } else {
          _this.show();
        }
      }).on('focusout.zf.tooltip', function (e) {
        isFocus = false;
        _this.isClick = false;
        _this.hide();
      }).on('resizeme.zf.trigger', function () {
        if (_this.isActive) {
          _this._setPosition();
        }
      });
    }

    /**
     * adds a toggle method, in addition to the static show() & hide() functions
     * @function
     */

  }, {
    key: 'toggle',
    value: function toggle() {
      if (this.isActive) {
        this.hide();
      } else {
        this.show();
      }
    }

    /**
     * Destroys an instance of tooltip, removes template element from the view.
     * @function
     */

  }, {
    key: '_destroy',
    value: function _destroy() {
      this.$element.attr('title', this.template.text()).off('.zf.trigger .zf.tooltip').removeClass('has-tip top right left').removeAttr('aria-describedby aria-haspopup data-disable-hover data-resize data-toggle data-tooltip data-yeti-box');

      this.template.remove();
    }
  }]);

  return Tooltip;
}(_foundation.Positionable);

Tooltip.defaults = {
  disableForTouch: false,
  /**
   * Time, in ms, before a tooltip should open on hover.
   * @option
   * @type {number}
   * @default 200
   */
  hoverDelay: 200,
  /**
   * Time, in ms, a tooltip should take to fade into view.
   * @option
   * @type {number}
   * @default 150
   */
  fadeInDuration: 150,
  /**
   * Time, in ms, a tooltip should take to fade out of view.
   * @option
   * @type {number}
   * @default 150
   */
  fadeOutDuration: 150,
  /**
   * Disables hover events from opening the tooltip if set to true
   * @option
   * @type {boolean}
   * @default false
   */
  disableHover: false,
  /**
   * Optional addtional classes to apply to the tooltip template on init.
   * @option
   * @type {string}
   * @default ''
   */
  templateClasses: '',
  /**
   * Non-optional class added to tooltip templates. Foundation default is 'tooltip'.
   * @option
   * @type {string}
   * @default 'tooltip'
   */
  tooltipClass: 'tooltip',
  /**
   * Class applied to the tooltip anchor element.
   * @option
   * @type {string}
   * @default 'has-tip'
   */
  triggerClass: 'has-tip',
  /**
   * Minimum breakpoint size at which to open the tooltip.
   * @option
   * @type {string}
   * @default 'small'
   */
  showOn: 'small',
  /**
   * Custom template to be used to generate markup for tooltip.
   * @option
   * @type {string}
   * @default ''
   */
  template: '',
  /**
   * Text displayed in the tooltip template on open.
   * @option
   * @type {string}
   * @default ''
   */
  tipText: '',
  touchCloseText: 'Tap to close.',
  /**
   * Allows the tooltip to remain open if triggered with a click or touch event.
   * @option
   * @type {boolean}
   * @default true
   */
  clickOpen: true,
  /**
   * DEPRECATED Additional positioning classes, set by the JS
   * @option
   * @type {string}
   * @default ''
   */
  positionClass: '',
  /**
   * Position of tooltip. Can be left, right, bottom, top, or auto.
   * @option
   * @type {string}
   * @default 'auto'
   */
  position: 'auto',
  /**
   * Alignment of tooltip relative to anchor. Can be left, right, bottom, top, center, or auto.
   * @option
   * @type {string}
   * @default 'auto'
   */
  alignment: 'auto',
  /**
   * Allow overlap of container/window. If false, tooltip will first try to
   * position as defined by data-position and data-alignment, but reposition if
   * it would cause an overflow.  @option
   * @type {boolean}
   * @default false
   */
  allowOverlap: false,
  /**
   * Allow overlap of only the bottom of the container. This is the most common
   * behavior for dropdowns, allowing the dropdown to extend the bottom of the
   * screen but not otherwise influence or break out of the container.
   * Less common for tooltips.
   * @option
   * @type {boolean}
   * @default false
   */
  allowBottomOverlap: false,
  /**
   * Distance, in pixels, the template should push away from the anchor on the Y axis.
   * @option
   * @type {number}
   * @default 0
   */
  vOffset: 0,
  /**
   * Distance, in pixels, the template should push away from the anchor on the X axis
   * @option
   * @type {number}
   * @default 0
   */
  hOffset: 0,
  /**
   * Distance, in pixels, the template spacing auto-adjust for a vertical tooltip
   * @option
   * @type {number}
   * @default 14
   */
  tooltipHeight: 14,
  /**
   * Distance, in pixels, the template spacing auto-adjust for a horizontal tooltip
   * @option
   * @type {number}
   * @default 12
   */
  tooltipWidth: 12,
  /**
  * Allow HTML in tooltip. Warning: If you are loading user-generated content into tooltips,
  * allowing HTML may open yourself up to XSS attacks.
  * @option
  * @type {boolean}
  * @default false
  */
  allowHtml: false
};

/**
 * TODO utilize resize event trigger
 */

exports.Tooltip = Tooltip;

/***/ }),
/* 38 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResponsiveAccordionTabs = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _jquery = __webpack_require__(0);

var _jquery2 = _interopRequireDefault(_jquery);

var _foundationUtil = __webpack_require__(3);

var _foundationUtil2 = __webpack_require__(1);

var _foundation = __webpack_require__(2);

var _foundation2 = __webpack_require__(12);

var _foundation3 = __webpack_require__(18);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// The plugin matches the plugin classes with these plugin instances.
var MenuPlugins = {
  tabs: {
    cssClass: 'tabs',
    plugin: _foundation3.Tabs
  },
  accordion: {
    cssClass: 'accordion',
    plugin: _foundation2.Accordion
  }
};

/**
 * ResponsiveAccordionTabs module.
 * @module foundation.responsiveAccordionTabs
 * @requires foundation.util.motion
 * @requires foundation.accordion
 * @requires foundation.tabs
 */

var ResponsiveAccordionTabs = function (_Plugin) {
  _inherits(ResponsiveAccordionTabs, _Plugin);

  function ResponsiveAccordionTabs() {
    _classCallCheck(this, ResponsiveAccordionTabs);

    return _possibleConstructorReturn(this, (ResponsiveAccordionTabs.__proto__ || Object.getPrototypeOf(ResponsiveAccordionTabs)).apply(this, arguments));
  }

  _createClass(ResponsiveAccordionTabs, [{
    key: '_setup',

    /**
     * Creates a new instance of a responsive accordion tabs.
     * @class
     * @name ResponsiveAccordionTabs
     * @fires ResponsiveAccordionTabs#init
     * @param {jQuery} element - jQuery object to make into Responsive Accordion Tabs.
     * @param {Object} options - Overrides to the default plugin settings.
     */
    value: function _setup(element, options) {
      this.$element = (0, _jquery2.default)(element);
      this.options = _jquery2.default.extend({}, this.$element.data(), options);
      this.rules = this.$element.data('responsive-accordion-tabs');
      this.currentMq = null;
      this.currentPlugin = null;
      this.className = 'ResponsiveAccordionTabs'; // ie9 back compat
      if (!this.$element.attr('id')) {
        this.$element.attr('id', (0, _foundationUtil2.GetYoDigits)(6, 'responsiveaccordiontabs'));
      };

      this._init();
      this._events();
    }

    /**
     * Initializes the Menu by parsing the classes from the 'data-responsive-accordion-tabs' attribute on the element.
     * @function
     * @private
     */

  }, {
    key: '_init',
    value: function _init() {
      _foundationUtil.MediaQuery._init();

      // The first time an Interchange plugin is initialized, this.rules is converted from a string of "classes" to an object of rules
      if (typeof this.rules === 'string') {
        var rulesTree = {};

        // Parse rules from "classes" pulled from data attribute
        var rules = this.rules.split(' ');

        // Iterate through every rule found
        for (var i = 0; i < rules.length; i++) {
          var rule = rules[i].split('-');
          var ruleSize = rule.length > 1 ? rule[0] : 'small';
          var rulePlugin = rule.length > 1 ? rule[1] : rule[0];

          if (MenuPlugins[rulePlugin] !== null) {
            rulesTree[ruleSize] = MenuPlugins[rulePlugin];
          }
        }

        this.rules = rulesTree;
      }

      this._getAllOptions();

      if (!_jquery2.default.isEmptyObject(this.rules)) {
        this._checkMediaQueries();
      }
    }
  }, {
    key: '_getAllOptions',
    value: function _getAllOptions() {
      //get all defaults and options
      var _this = this;
      _this.allOptions = {};
      for (var key in MenuPlugins) {
        if (MenuPlugins.hasOwnProperty(key)) {
          var obj = MenuPlugins[key];
          try {
            var dummyPlugin = (0, _jquery2.default)('<ul></ul>');
            var tmpPlugin = new obj.plugin(dummyPlugin, _this.options);
            for (var keyKey in tmpPlugin.options) {
              if (tmpPlugin.options.hasOwnProperty(keyKey) && keyKey !== 'zfPlugin') {
                var objObj = tmpPlugin.options[keyKey];
                _this.allOptions[keyKey] = objObj;
              }
            }
            tmpPlugin.destroy();
          } catch (e) {}
        }
      }
    }

    /**
     * Initializes events for the Menu.
     * @function
     * @private
     */

  }, {
    key: '_events',
    value: function _events() {
      var _this = this;

      (0, _jquery2.default)(window).on('changed.zf.mediaquery', function () {
        _this._checkMediaQueries();
      });
    }

    /**
     * Checks the current screen width against available media queries. If the media query has changed, and the plugin needed has changed, the plugins will swap out.
     * @function
     * @private
     */

  }, {
    key: '_checkMediaQueries',
    value: function _checkMediaQueries() {
      var matchedMq,
          _this = this;
      // Iterate through each rule and find the last matching rule
      _jquery2.default.each(this.rules, function (key) {
        if (_foundationUtil.MediaQuery.atLeast(key)) {
          matchedMq = key;
        }
      });

      // No match? No dice
      if (!matchedMq) return;

      // Plugin already initialized? We good
      if (this.currentPlugin instanceof this.rules[matchedMq].plugin) return;

      // Remove existing plugin-specific CSS classes
      _jquery2.default.each(MenuPlugins, function (key, value) {
        _this.$element.removeClass(value.cssClass);
      });

      // Add the CSS class for the new plugin
      this.$element.addClass(this.rules[matchedMq].cssClass);

      // Create an instance of the new plugin
      if (this.currentPlugin) {
        //don't know why but on nested elements data zfPlugin get's lost
        if (!this.currentPlugin.$element.data('zfPlugin') && this.storezfData) this.currentPlugin.$element.data('zfPlugin', this.storezfData);
        this.currentPlugin.destroy();
      }
      this._handleMarkup(this.rules[matchedMq].cssClass);
      this.currentPlugin = new this.rules[matchedMq].plugin(this.$element, {});
      this.storezfData = this.currentPlugin.$element.data('zfPlugin');
    }
  }, {
    key: '_handleMarkup',
    value: function _handleMarkup(toSet) {
      var _this = this,
          fromString = 'accordion';
      var $panels = (0, _jquery2.default)('[data-tabs-content=' + this.$element.attr('id') + ']');
      if ($panels.length) fromString = 'tabs';
      if (fromString === toSet) {
        return;
      };

      var tabsTitle = _this.allOptions.linkClass ? _this.allOptions.linkClass : 'tabs-title';
      var tabsPanel = _this.allOptions.panelClass ? _this.allOptions.panelClass : 'tabs-panel';

      this.$element.removeAttr('role');
      var $liHeads = this.$element.children('.' + tabsTitle + ',[data-accordion-item]').removeClass(tabsTitle).removeClass('accordion-item').removeAttr('data-accordion-item');
      var $liHeadsA = $liHeads.children('a').removeClass('accordion-title');

      if (fromString === 'tabs') {
        $panels = $panels.children('.' + tabsPanel).removeClass(tabsPanel).removeAttr('role').removeAttr('aria-hidden').removeAttr('aria-labelledby');
        $panels.children('a').removeAttr('role').removeAttr('aria-controls').removeAttr('aria-selected');
      } else {
        $panels = $liHeads.children('[data-tab-content]').removeClass('accordion-content');
      };

      $panels.css({ display: '', visibility: '' });
      $liHeads.css({ display: '', visibility: '' });
      if (toSet === 'accordion') {
        $panels.each(function (key, value) {
          (0, _jquery2.default)(value).appendTo($liHeads.get(key)).addClass('accordion-content').attr('data-tab-content', '').removeClass('is-active').css({ height: '' });
          (0, _jquery2.default)('[data-tabs-content=' + _this.$element.attr('id') + ']').after('<div id="tabs-placeholder-' + _this.$element.attr('id') + '"></div>').detach();
          $liHeads.addClass('accordion-item').attr('data-accordion-item', '');
          $liHeadsA.addClass('accordion-title');
        });
      } else if (toSet === 'tabs') {
        var $tabsContent = (0, _jquery2.default)('[data-tabs-content=' + _this.$element.attr('id') + ']');
        var $placeholder = (0, _jquery2.default)('#tabs-placeholder-' + _this.$element.attr('id'));
        if ($placeholder.length) {
          $tabsContent = (0, _jquery2.default)('<div class="tabs-content"></div>').insertAfter($placeholder).attr('data-tabs-content', _this.$element.attr('id'));
          $placeholder.remove();
        } else {
          $tabsContent = (0, _jquery2.default)('<div class="tabs-content"></div>').insertAfter(_this.$element).attr('data-tabs-content', _this.$element.attr('id'));
        };
        $panels.each(function (key, value) {
          var tempValue = (0, _jquery2.default)(value).appendTo($tabsContent).addClass(tabsPanel);
          var hash = $liHeadsA.get(key).hash.slice(1);
          var id = (0, _jquery2.default)(value).attr('id') || (0, _foundationUtil2.GetYoDigits)(6, 'accordion');
          if (hash !== id) {
            if (hash !== '') {
              (0, _jquery2.default)(value).attr('id', hash);
            } else {
              hash = id;
              (0, _jquery2.default)(value).attr('id', hash);
              (0, _jquery2.default)($liHeadsA.get(key)).attr('href', (0, _jquery2.default)($liHeadsA.get(key)).attr('href').replace('#', '') + '#' + hash);
            };
          };
          var isActive = (0, _jquery2.default)($liHeads.get(key)).hasClass('is-active');
          if (isActive) {
            tempValue.addClass('is-active');
          };
        });
        $liHeads.addClass(tabsTitle);
      };
    }

    /**
     * Destroys the instance of the current plugin on this element, as well as the window resize handler that switches the plugins out.
     * @function
     */

  }, {
    key: '_destroy',
    value: function _destroy() {
      if (this.currentPlugin) this.currentPlugin.destroy();
      (0, _jquery2.default)(window).off('.zf.ResponsiveAccordionTabs');
    }
  }]);

  return ResponsiveAccordionTabs;
}(_foundation.Plugin);

ResponsiveAccordionTabs.defaults = {};

exports.ResponsiveAccordionTabs = ResponsiveAccordionTabs;

/***/ })
/******/ ]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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