(function() {
    function getKbid() {
        var promo = parseQueryString().kbid;
        if(promo) Cookies.set('kbid', promo);

        return promo;
    }

    var parsedQuery = null;
    function parseQueryString() {
        if(!parsedQuery) {
            parsedQuery = parseQuery(location.search);
        }

        return parsedQuery;
    }

    function parseQuery(query) {
        var split = query.replace(/^\?/, '').split("&");

        var qValues = {};
        for(var i = 0; i < split.length; i++) {
            if(!split[i] || !split[i].length) continue;

            var param = split[i].split("=");
            qValues[param[0]] = decodeURIComponent(param[1]);
        }

        return qValues;
    }

    function buildQuery(params) {
        var components = [];

        params = params || {};
        for(var key in params) {
            if(!params.hasOwnProperty(key)) continue;

            components.push(encodeURIComponent(key) + '=' + encodeURIComponent(params[key]));
        }

        return components.join('&');
    }

    function replaceQueryParameters(url, newParams) {
        var parsed = parseUrl(url);
        var query = parseQuery(parsed.search);

        // Merge in new parameters
        for(var key in newParams) {
            if(!newParams.hasOwnProperty(key)) continue;

            query[key] = newParams[key];
        }

        var newQuery = buildQuery(query);

        return parsed.protocol + '//' + parsed.hostname + parsed.pathname
            + (newQuery.length ? ('?' + newQuery) : '');
    }

    function parseUrl(url) {
        var a = document.createElement('a');
        a.href = url;

        return {
            hostname: a.hostname,
            pathname: a.pathname.replace(/(^\/?)/,"/"),
            port: a.port,
            search: a.search,
            protocol: a.protocol
        };
    }

    window.Promo = {
        getKbid: getKbid,
        parseQueryString: parseQueryString,
        parseQuery: parseQuery,
        replaceQueryParameters: replaceQueryParameters,
        parseUrl: parseUrl,
        buildQuery: buildQuery
    };
})();
