<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if (! class_exists ( 'CreedyPlusFooterPostType' ) ) {

	class CreedyPlusFooterPostType {

        private static $_instance = null;

        public static function instance() {
            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

		function __construct() {

			add_action ( 'init', array( $this, 'creedy_register_cpt' ) );
			add_filter ( 'template_include', array ( $this, 'creedy_template_include' ) );
		}

		function creedy_register_cpt() {

			$labels = array (
				'name'				 => __( 'Footers', 'creedy-plus' ),
				'singular_name'		 => __( 'Footer', 'creedy-plus' ),
				'menu_name'			 => __( 'Footers', 'creedy-plus' ),
				'add_new'			 => __( 'Add Footer', 'creedy-plus' ),
				'add_new_item'		 => __( 'Add New Footer', 'creedy-plus' ),
				'edit'				 => __( 'Edit Footer', 'creedy-plus' ),
				'edit_item'			 => __( 'Edit Footer', 'creedy-plus' ),
				'new_item'			 => __( 'New Footer', 'creedy-plus' ),
				'view'				 => __( 'View Footer', 'creedy-plus' ),
				'view_item' 		 => __( 'View Footer', 'creedy-plus' ),
				'search_items' 		 => __( 'Search Footers', 'creedy-plus' ),
				'not_found' 		 => __( 'No Footers found', 'creedy-plus' ),
				'not_found_in_trash' => __( 'No Footers found in Trash', 'creedy-plus' ),
			);

			$args = array (
				'labels' 				=> $labels,
				'public' 				=> true,
				'exclude_from_search'	=> true,
				'show_in_nav_menus' 	=> false,
				'show_in_rest' 			=> true,
				'menu_position'			=> 26,
				'menu_icon' 			=> 'dashicons-editor-insertmore',
				'hierarchical' 			=> false,
				'supports' 				=> array ( 'title', 'editor', 'revisions' ),
			);

			register_post_type ( 'wdt_footers', $args );
		}

		function creedy_template_include($template) {
			if ( is_singular( 'wdt_footers' ) ) {
				if ( ! file_exists ( get_stylesheet_directory () . '/single-wdt_footers.php' ) ) {
					$template = CREEDY_PLUS_DIR_PATH . 'post-types/templates/single-wdt_footers.php';
				}
			}

			return $template;
		}
	}
}

CreedyPlusFooterPostType::instance();