<?php

namespace CreedyElementor\Widgets;
use CreedyElementor\Widgets\Creedy_Shop_Widget_Product_Summary;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;


class Creedy_Shop_Widget_Product_Summary_Extend extends Creedy_Shop_Widget_Product_Summary {

	function dynamic_register_controls() {

		$this->start_controls_section( 'product_summary_extend_section', array(
			'label' => esc_html__( 'Social Options', 'creedy-pro' ),
		) );

			$this->add_control( 'share_follow_type', array(
				'label'   => esc_html__( 'Share / Follow Type', 'creedy-pro' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'share',
				'options' => array(
					''       => esc_html__('None', 'creedy-pro'),
					'share'  => esc_html__('Share', 'creedy-pro'),
					'follow' => esc_html__('Follow', 'creedy-pro'),
				),
				'description' => esc_html__( 'Choose between Share / Follow you would like to use.', 'creedy-pro' ),
			) );

			$this->add_control( 'social_icon_style', array(
				'label'   => esc_html__( 'Social Icon Style', 'creedy-pro' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
					'simple'        => esc_html__( 'Simple', 'creedy-pro' ),
					'bgfill'        => esc_html__( 'BG Fill', 'creedy-pro' ),
					'brdrfill'      => esc_html__( 'Border Fill', 'creedy-pro' ),
					'skin-bgfill'   => esc_html__( 'Skin BG Fill', 'creedy-pro' ),
					'skin-brdrfill' => esc_html__( 'Skin Border Fill', 'creedy-pro' ),
				),
				'description' => esc_html__( 'This option is applicable for all buttons used in product summary.', 'creedy-pro' ),
				'condition'   => array( 'share_follow_type' => array ('share', 'follow') )
			) );

			$this->add_control( 'social_icon_radius', array(
				'label'   => esc_html__( 'Social Icon Radius', 'creedy-pro' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
					'square'  => esc_html__( 'Square', 'creedy-pro' ),
					'rounded' => esc_html__( 'Rounded', 'creedy-pro' ),
					'circle'  => esc_html__( 'Circle', 'creedy-pro' ),
				),
				'condition'   => array(
					'social_icon_style' => array ('bgfill', 'brdrfill', 'skin-bgfill', 'skin-brdrfill'),
					'share_follow_type' => array ('share', 'follow')
				),
			) );

			$this->add_control( 'social_icon_inline_alignment', array(
				'label'        => esc_html__( 'Social Icon Inline Alignment', 'creedy-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'yes', 'creedy-pro' ),
				'label_off'    => esc_html__( 'no', 'creedy-pro' ),
				'default'      => '',
				'return_value' => 'true',
				'description'  => esc_html__( 'This option is applicable for all buttons used in product summary.', 'creedy-pro' ),
				'condition'   => array( 'share_follow_type' => array ('share', 'follow') )
			) );

		$this->end_controls_section();

	}

}