/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2026-02-05 06:13:14 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=21947 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=6056 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=2697 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aioseo_ai_insights_keyword_reports` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(40) NOT NULL,
  `keyword` varchar(255) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  `brands` longtext DEFAULT NULL,
  `brands_mentioned` int(11) DEFAULT 0,
  `results` longtext DEFAULT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ndx_aioseo_ai_insights_keyword_reports_uuid` (`uuid`),
  KEY `ndx_aioseo_ai_insights_keyword_reports_keyword` (`keyword`),
  KEY `ndx_aioseo_ai_insights_keyword_reports_status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aioseo_cache` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(80) NOT NULL,
  `value` longtext NOT NULL,
  `is_object` tinyint(1) DEFAULT 0,
  `expiration` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ndx_aioseo_cache_key` (`key`),
  KEY `ndx_aioseo_cache_expiration` (`expiration`)
) ENGINE=InnoDB AUTO_INCREMENT=701 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aioseo_crawl_cleanup_blocked_args` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `key` text DEFAULT NULL,
  `value` text DEFAULT NULL,
  `key_value_hash` varchar(40) DEFAULT NULL,
  `regex` varchar(150) DEFAULT NULL,
  `hits` int(20) NOT NULL DEFAULT 0,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ndx_aioseo_crawl_cleanup_blocked_args_key_value_hash` (`key_value_hash`),
  UNIQUE KEY `ndx_aioseo_crawl_cleanup_blocked_args_regex` (`regex`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aioseo_crawl_cleanup_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` text NOT NULL,
  `key` text NOT NULL,
  `value` text DEFAULT NULL,
  `hash` varchar(40) NOT NULL,
  `hits` int(20) NOT NULL DEFAULT 1,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ndx_aioseo_crawl_cleanup_logs_hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aioseo_notifications` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(13) NOT NULL,
  `addon` varchar(64) DEFAULT NULL,
  `title` text NOT NULL,
  `content` longtext NOT NULL,
  `type` varchar(64) NOT NULL,
  `level` text NOT NULL,
  `notification_id` bigint(20) unsigned DEFAULT NULL,
  `notification_name` varchar(255) DEFAULT NULL,
  `start` datetime DEFAULT NULL,
  `end` datetime DEFAULT NULL,
  `button1_label` varchar(255) DEFAULT NULL,
  `button1_action` varchar(255) DEFAULT NULL,
  `button2_label` varchar(255) DEFAULT NULL,
  `button2_action` varchar(255) DEFAULT NULL,
  `dismissed` tinyint(1) NOT NULL DEFAULT 0,
  `new` tinyint(1) NOT NULL DEFAULT 1,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ndx_aioseo_notifications_slug` (`slug`),
  KEY `ndx_aioseo_notifications_dates` (`start`,`end`),
  KEY `ndx_aioseo_notifications_type` (`type`),
  KEY `ndx_aioseo_notifications_dismissed` (`dismissed`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aioseo_posts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL,
  `title` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `keywords` mediumtext DEFAULT NULL,
  `keyphrases` longtext DEFAULT NULL,
  `page_analysis` longtext DEFAULT NULL,
  `primary_term` longtext DEFAULT NULL,
  `canonical_url` text DEFAULT NULL,
  `og_title` text DEFAULT NULL,
  `og_description` text DEFAULT NULL,
  `og_object_type` varchar(64) DEFAULT 'default',
  `og_image_type` varchar(64) DEFAULT 'default',
  `og_image_url` text DEFAULT NULL,
  `og_image_width` int(11) DEFAULT NULL,
  `og_image_height` int(11) DEFAULT NULL,
  `og_image_custom_url` text DEFAULT NULL,
  `og_image_custom_fields` text DEFAULT NULL,
  `og_video` varchar(255) DEFAULT NULL,
  `og_custom_url` text DEFAULT NULL,
  `og_article_section` text DEFAULT NULL,
  `og_article_tags` text DEFAULT NULL,
  `twitter_use_og` tinyint(1) DEFAULT 0,
  `twitter_card` varchar(64) DEFAULT 'default',
  `twitter_image_type` varchar(64) DEFAULT 'default',
  `twitter_image_url` text DEFAULT NULL,
  `twitter_image_custom_url` text DEFAULT NULL,
  `twitter_image_custom_fields` text DEFAULT NULL,
  `twitter_title` text DEFAULT NULL,
  `twitter_description` text DEFAULT NULL,
  `seo_score` int(11) NOT NULL DEFAULT 0,
  `schema` longtext DEFAULT NULL,
  `schema_type` varchar(20) DEFAULT 'default',
  `schema_type_options` longtext DEFAULT NULL,
  `pillar_content` tinyint(1) DEFAULT NULL,
  `robots_default` tinyint(1) NOT NULL DEFAULT 1,
  `robots_noindex` tinyint(1) NOT NULL DEFAULT 0,
  `robots_noarchive` tinyint(1) NOT NULL DEFAULT 0,
  `robots_nosnippet` tinyint(1) NOT NULL DEFAULT 0,
  `robots_nofollow` tinyint(1) NOT NULL DEFAULT 0,
  `robots_noimageindex` tinyint(1) NOT NULL DEFAULT 0,
  `robots_noodp` tinyint(1) NOT NULL DEFAULT 0,
  `robots_notranslate` tinyint(1) NOT NULL DEFAULT 0,
  `robots_max_snippet` int(11) DEFAULT NULL,
  `robots_max_videopreview` int(11) DEFAULT NULL,
  `robots_max_imagepreview` varchar(20) DEFAULT 'large',
  `images` longtext DEFAULT NULL,
  `image_scan_date` datetime DEFAULT NULL,
  `priority` float DEFAULT NULL,
  `frequency` tinytext DEFAULT NULL,
  `videos` longtext DEFAULT NULL,
  `video_thumbnail` text DEFAULT NULL,
  `video_scan_date` datetime DEFAULT NULL,
  `local_seo` longtext DEFAULT NULL,
  `breadcrumb_settings` longtext DEFAULT NULL,
  `limit_modified_date` tinyint(1) NOT NULL DEFAULT 0,
  `options` longtext DEFAULT NULL,
  `ai` longtext DEFAULT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ndx_aioseo_posts_post_id` (`post_id`),
  KEY `ndx_aioseo_posts_pillar_content` (`pillar_content`)
) ENGINE=InnoDB AUTO_INCREMENT=981 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aioseo_seo_analyzer_results` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `data` text NOT NULL,
  `score` varchar(255) DEFAULT NULL,
  `competitor_url` varchar(255) DEFAULT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ndx_aioseo_seo_analyzer_results_competitor_url` (`competitor_url`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aioseo_writing_assistant_keywords` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(40) NOT NULL,
  `keyword` varchar(255) NOT NULL,
  `country` varchar(10) NOT NULL DEFAULT 'us',
  `language` varchar(10) NOT NULL DEFAULT 'en',
  `progress` tinyint(3) DEFAULT 0,
  `keywords` mediumtext DEFAULT NULL,
  `competitors` mediumtext DEFAULT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ndx_aioseo_writing_assistant_keywords_uuid` (`uuid`),
  KEY `ndx_aioseo_writing_assistant_keywords_keyword` (`keyword`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_aioseo_writing_assistant_posts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `keyword_id` bigint(20) unsigned DEFAULT NULL,
  `content_analysis_hash` varchar(40) DEFAULT NULL,
  `content_analysis` text DEFAULT NULL,
  `created` datetime NOT NULL,
  `updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ndx_aioseo_writing_assistant_posts_post_id` (`post_id`),
  KEY `ndx_aioseo_writing_assistant_posts_keyword_id` (`keyword_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`),
  KEY `woo_idx_comment_date_type` (`comment_date_gmt`,`comment_type`,`comment_approved`,`comment_post_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_give_campaign_forms` (
  `campaign_id` int(10) unsigned NOT NULL,
  `form_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`campaign_id`,`form_id`),
  KEY `form_id` (`form_id`),
  KEY `campaign_id` (`campaign_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_give_campaigns` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `campaign_page_id` int(10) unsigned DEFAULT NULL,
  `form_id` int(11) NOT NULL,
  `campaign_type` varchar(12) NOT NULL DEFAULT '',
  `campaign_title` text NOT NULL,
  `campaign_url` text NOT NULL,
  `short_desc` text NOT NULL,
  `long_desc` text NOT NULL,
  `campaign_logo` text NOT NULL,
  `campaign_image` text NOT NULL,
  `primary_color` varchar(7) NOT NULL,
  `secondary_color` varchar(7) NOT NULL,
  `campaign_goal` int(10) unsigned NOT NULL,
  `goal_type` varchar(24) NOT NULL DEFAULT 'amount',
  `status` varchar(12) NOT NULL,
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `date_created` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_give_commentmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `give_comment_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `give_comment_id` (`give_comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_give_comments` (
  `comment_ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `comment_content` longtext NOT NULL,
  `comment_parent` mediumtext NOT NULL,
  `comment_type` mediumtext NOT NULL,
  `comment_date` datetime NOT NULL,
  `comment_date_gmt` datetime NOT NULL,
  PRIMARY KEY (`comment_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_give_donationmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `donation_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `donation_id` (`donation_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_give_donormeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `donor_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `donor_id` (`donor_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_give_donors` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `email` varchar(255) NOT NULL,
  `name` mediumtext NOT NULL,
  `phone` varchar(50) NOT NULL DEFAULT '',
  `purchase_value` mediumtext NOT NULL,
  `purchase_count` bigint(20) NOT NULL,
  `payment_ids` longtext NOT NULL,
  `date_created` datetime NOT NULL,
  `token` varchar(255) NOT NULL,
  `verify_key` varchar(255) NOT NULL,
  `verify_throttle` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  KEY `user` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `wp_give_formmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `form_id` (`form_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_give_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `log_type` varchar(16) NOT NULL,
  `data` text NOT NULL,
  `category` varchar(64) NOT NULL,
  `source` varchar(64) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `log_type` (`log_type`),
  KEY `category` (`category`),
  KEY `source` (`source`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_give_migrations` (
  `id` varchar(180) NOT NULL,
  `status` varchar(16) NOT NULL,
  `error` text DEFAULT NULL,
  `last_run` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_give_revenue` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `donation_id` bigint(20) unsigned NOT NULL,
  `form_id` bigint(20) unsigned NOT NULL,
  `amount` int(10) unsigned NOT NULL,
  `campaign_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `campaign_id` (`campaign_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_give_sequential_ordering` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `payment_id` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_give_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_key`),
  UNIQUE KEY `session_id` (`session_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_give_subscriptionmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `subscription_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `subscription_id` (`subscription_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_give_subscriptions` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `customer_id` bigint(20) NOT NULL,
  `period` varchar(20) NOT NULL,
  `frequency` bigint(20) NOT NULL DEFAULT 1,
  `initial_amount` decimal(18,10) NOT NULL,
  `recurring_amount` decimal(18,10) NOT NULL,
  `recurring_fee_amount` decimal(18,10) NOT NULL,
  `bill_times` bigint(20) NOT NULL,
  `transaction_id` varchar(60) NOT NULL,
  `parent_payment_id` bigint(20) NOT NULL,
  `payment_mode` varchar(20) NOT NULL DEFAULT '',
  `product_id` bigint(20) NOT NULL,
  `created` datetime NOT NULL,
  `expiration` datetime NOT NULL,
  `status` varchar(20) NOT NULL,
  `profile_id` varchar(60) NOT NULL,
  `notes` longtext NOT NULL,
  `campaign_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `profile_id` (`profile_id`),
  KEY `customer` (`customer_id`),
  KEY `transaction` (`transaction_id`),
  KEY `customer_and_status` (`customer_id`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_litespeed_url` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `url` varchar(500) NOT NULL,
  `cache_tags` varchar(1000) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `url` (`url`(191)),
  KEY `cache_tags` (`cache_tags`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_litespeed_url_file` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `url_id` bigint(20) NOT NULL,
  `vary` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of final vary',
  `filename` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of file content',
  `type` tinyint(4) NOT NULL COMMENT 'css=1,js=2,ccss=3,ucss=4',
  `mobile` tinyint(4) NOT NULL COMMENT 'mobile=1',
  `webp` tinyint(4) NOT NULL COMMENT 'webp=1',
  `expired` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `filename` (`filename`),
  KEY `type` (`type`),
  KEY `url_id_2` (`url_id`,`vary`,`type`),
  KEY `filename_2` (`filename`,`expired`),
  KEY `url_id` (`url_id`,`expired`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=9903 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=25701 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `type_status_author` (`post_type`,`post_status`,`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=24029 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_shepherd_tec_tasks` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `class_hash` varchar(191) NOT NULL,
  `args_hash` varchar(191) NOT NULL,
  `data` text DEFAULT NULL,
  `current_try` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `action_id` (`action_id`),
  KEY `class_hash` (`class_hash`),
  KEY `args_hash` (`args_hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_tec_events` (
  `event_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL,
  `start_date` varchar(19) NOT NULL,
  `end_date` varchar(19) DEFAULT NULL,
  `timezone` varchar(30) NOT NULL DEFAULT 'UTC',
  `start_date_utc` varchar(19) NOT NULL,
  `end_date_utc` varchar(19) DEFAULT NULL,
  `duration` mediumint(9) DEFAULT 7200,
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `hash` varchar(40) NOT NULL,
  PRIMARY KEY (`event_id`),
  UNIQUE KEY `post_id` (`post_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_tec_kv_cache` (
  `cache_key` varchar(191) NOT NULL,
  `value` longtext DEFAULT NULL,
  `expiration` bigint(20) unsigned DEFAULT 0,
  PRIMARY KEY (`cache_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_tec_occurrences` (
  `occurrence_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_id` bigint(20) unsigned NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `start_date` datetime NOT NULL,
  `start_date_utc` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `end_date_utc` datetime NOT NULL,
  `duration` mediumint(9) DEFAULT 7200,
  `hash` varchar(40) NOT NULL,
  `updated_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`occurrence_id`),
  UNIQUE KEY `hash` (`hash`),
  KEY `event_id` (`event_id`),
  KEY `idx_wp_tec_occurrences_post_id_dates` (`post_id`,`end_date`,`start_date`),
  KEY `idx_wp_tec_occurrences_post_id_dates_utc` (`post_id`,`end_date_utc`,`start_date_utc`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=56 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_trp_gettext_en_us` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `original` longtext NOT NULL,
  `translated` longtext DEFAULT NULL,
  `domain` longtext DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `original_id` bigint(20) DEFAULT NULL,
  `plural_form` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `index_name` (`original`(100)),
  FULLTEXT KEY `original_fulltext` (`original`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_trp_gettext_original_meta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `original_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  UNIQUE KEY `meta_id` (`meta_id`),
  KEY `gettext_index_original_id` (`original_id`),
  KEY `gettext_meta_key` (`meta_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_trp_gettext_original_strings` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `original` text NOT NULL,
  `domain` text NOT NULL,
  `context` text DEFAULT NULL,
  `original_plural` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gettext_index_original` (`original`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_trustindex_google_reviews` (
  `id` tinyint(1) NOT NULL AUTO_INCREMENT,
  `hidden` tinyint(1) NOT NULL DEFAULT 0,
  `user` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `user_photo` text DEFAULT NULL,
  `text` text DEFAULT NULL,
  `rating` decimal(3,1) DEFAULT NULL,
  `highlight` varchar(11) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `reviewId` text DEFAULT NULL,
  `reply` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_trustindex_google_views` (
  `date` date NOT NULL,
  `viewed` bigint(20) NOT NULL,
  PRIMARY KEY (`date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=83 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2922 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT current_timestamp(),
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_product_date` (`customer_id`,`product_id`,`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`),
  KEY `idx_date_paid_status_parent` (`date_paid`,`status`,`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `payment_method_title` text DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `global_unique_id` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(6) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(6) NOT NULL,
  `failure_count` smallint(6) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(11) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(6) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`),
  KEY `session_expiry` (`session_expiry`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `zone_id` (`zone_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(11) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(11) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yith_wcwl` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `prod_id` bigint(20) NOT NULL,
  `quantity` int(11) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `wishlist_id` bigint(20) DEFAULT NULL,
  `position` int(11) DEFAULT 0,
  `original_price` decimal(9,3) DEFAULT NULL,
  `original_currency` char(3) DEFAULT NULL,
  `dateadded` timestamp NOT NULL DEFAULT current_timestamp(),
  `on_sale` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `prod_id` (`prod_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `wp_yith_wcwl_itemmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `yith_wcwl_item_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `item_id` (`yith_wcwl_item_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yith_wcwl_lists` (
  `ID` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `session_id` varchar(255) DEFAULT NULL,
  `wishlist_slug` varchar(200) NOT NULL,
  `wishlist_name` text DEFAULT NULL,
  `wishlist_token` varchar(64) NOT NULL,
  `wishlist_privacy` tinyint(1) NOT NULL DEFAULT 0,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `dateadded` timestamp NOT NULL DEFAULT current_timestamp(),
  `expiration` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `wishlist_token` (`wishlist_token`),
  KEY `wishlist_slug` (`wishlist_slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("21032", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-13 06:59:04", "2026-01-13 06:59:04", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768287544;s:18:\"\0*\0first_timestamp\";i:1768287544;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768287544;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2026-01-13 06:59:09", "2026-01-13 06:59:09", "1", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21033", "action_scheduler/migration_hook", "complete", "2026-01-13 07:00:09", "2026-01-13 07:00:09", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768287609;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768287609;}", "2", "1", "2026-01-13 07:00:12", "2026-01-13 07:00:12", "6", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21034", "woocommerce_scheduled_sales", "complete", "2026-01-14 00:00:00", "2026-01-14 00:00:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768348800;s:18:\"\0*\0first_timestamp\";i:1768348800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768348800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-14 02:51:30", "2026-01-14 02:51:30", "314", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21035", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-13 07:59:09", "2026-01-13 07:59:09", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768291149;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768291149;}", "3", "1", "2026-01-13 07:59:13", "2026-01-13 07:59:13", "66", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21036", "woocommerce_cleanup_personal_data", "complete", "2026-01-13 06:59:19", "2026-01-13 06:59:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768287559;s:18:\"\0*\0first_timestamp\";i:1768287559;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768287559;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-13 07:00:11", "2026-01-13 07:00:11", "6", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21037", "woocommerce_cleanup_logs", "complete", "2026-01-14 03:00:00", "2026-01-14 03:00:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768359600;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768359600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-14 05:27:13", "2026-01-14 05:27:13", "316", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21038", "woocommerce_cleanup_sessions", "complete", "2026-01-14 06:00:00", "2026-01-14 06:00:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768370400;s:18:\"\0*\0first_timestamp\";i:1768370400;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768370400;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "3", "1", "2026-01-14 06:00:08", "2026-01-14 06:00:08", "325", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21039", "woocommerce_geoip_updater", "complete", "2026-01-14 06:00:00", "2026-01-14 06:00:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768370400;s:18:\"\0*\0first_timestamp\";i:1768370400;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768370400;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}", "3", "1", "2026-01-14 06:00:08", "2026-01-14 06:00:08", "325", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21040", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-14 03:00:00", "2026-01-14 03:00:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768359600;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768359600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-14 05:27:13", "2026-01-14 05:27:13", "316", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21041", "wc_admin_daily_wrapper", "complete", "2026-01-13 06:59:09", "2026-01-13 06:59:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768287549;s:18:\"\0*\0first_timestamp\";i:1768287549;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768287549;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-13 06:59:11", "2026-01-13 06:59:11", "2", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21042", "generate_category_lookup_table_wrapper", "complete", "2026-01-13 06:59:19", "2026-01-13 06:59:19", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768287559;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768287559;}", "3", "1", "2026-01-13 07:00:12", "2026-01-13 07:00:12", "6", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21043", "woocommerce_refresh_order_count_cache", "complete", "2026-01-13 18:59:09", "2026-01-13 18:59:09", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768330749;s:18:\"\0*\0first_timestamp\";i:1768330749;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768330749;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "4", "1", "2026-01-14 02:51:30", "2026-01-14 02:51:30", "314", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21044", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-14 06:59:09", "2026-01-14 06:59:09", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768373949;s:18:\"\0*\0first_timestamp\";i:1768287544;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768373949;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2026-01-14 06:59:21", "2026-01-14 06:59:21", "370", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21045", "woocommerce_cleanup_draft_orders", "complete", "2026-01-13 06:59:10", "2026-01-13 06:59:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768287550;s:18:\"\0*\0first_timestamp\";i:1768287550;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768287550;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-13 06:59:11", "2026-01-13 06:59:11", "3", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21046", "wc_admin_daily_wrapper", "complete", "2026-01-14 06:59:11", "2026-01-14 06:59:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768373951;s:18:\"\0*\0first_timestamp\";i:1768287549;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768373951;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-14 06:59:21", "2026-01-14 06:59:21", "370", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21047", "woocommerce_cleanup_draft_orders", "complete", "2026-01-14 06:59:11", "2026-01-14 06:59:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768373951;s:18:\"\0*\0first_timestamp\";i:1768287550;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768373951;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-14 06:59:21", "2026-01-14 06:59:21", "370", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21048", "woocommerce_update_marketplace_suggestions", "complete", "2026-01-13 06:59:16", "2026-01-13 06:59:16", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768287556;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768287556;}", "5", "1", "2026-01-13 07:00:10", "2026-01-13 07:00:10", "6", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21049", "tec_clear_expired_key_value_cache", "complete", "2026-01-13 18:59:57", "2026-01-13 18:59:57", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768330797;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768330797;}", "5", "1", "2026-01-14 02:51:30", "2026-01-14 02:51:30", "314", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21050", "woocommerce_cleanup_personal_data", "complete", "2026-01-14 07:00:11", "2026-01-14 07:00:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768374011;s:18:\"\0*\0first_timestamp\";i:1768287559;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768374011;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-14 07:01:20", "2026-01-14 07:01:20", "372", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21051", "action_scheduler/migration_hook", "failed", "2026-01-13 07:01:12", "2026-01-13 07:01:12", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768287672;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768287672;}", "2", "1", "2026-01-13 07:01:17", "2026-01-13 07:01:17", "9", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21052", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "failed", "2026-01-13 07:03:18", "2026-01-13 07:03:18", "10", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "5", "1", "2026-01-13 07:03:26", "2026-01-13 07:03:26", "12", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21053", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-13 08:59:13", "2026-01-13 08:59:13", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768294753;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768294753;}", "3", "1", "2026-01-13 08:59:27", "2026-01-13 08:59:27", "91", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21054", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-13 09:59:27", "2026-01-13 09:59:27", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768298367;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768298367;}", "3", "1", "2026-01-13 09:59:40", "2026-01-13 09:59:40", "151", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21055", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-13 10:59:40", "2026-01-13 10:59:40", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768301980;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768301980;}", "3", "1", "2026-01-13 11:00:25", "2026-01-13 11:00:25", "209", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21056", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-13 12:00:25", "2026-01-13 12:00:25", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768305625;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768305625;}", "3", "1", "2026-01-13 12:01:13", "2026-01-13 12:01:13", "265", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21057", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-13 13:01:13", "2026-01-13 13:01:13", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768309273;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768309273;}", "3", "1", "2026-01-14 02:51:30", "2026-01-14 02:51:30", "314", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21058", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-14 03:51:30", "2026-01-14 03:51:30", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768362690;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768362690;}", "3", "1", "2026-01-14 05:27:13", "2026-01-14 05:27:13", "316", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21059", "woocommerce_refresh_order_count_cache", "complete", "2026-01-14 14:51:30", "2026-01-14 14:51:30", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768402290;s:18:\"\0*\0first_timestamp\";i:1768330749;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768402290;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "4", "1", "2026-01-15 06:24:39", "2026-01-15 06:24:39", "616", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21060", "woocommerce_scheduled_sales", "complete", "2026-01-15 02:51:30", "2026-01-15 02:51:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768445490;s:18:\"\0*\0first_timestamp\";i:1768348800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768445490;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-15 06:24:39", "2026-01-15 06:24:39", "616", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21061", "tec_clear_expired_key_value_cache", "complete", "2026-01-14 17:27:08", "2026-01-14 17:27:08", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768411628;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768411628;}", "5", "1", "2026-01-15 06:24:39", "2026-01-15 06:24:39", "616", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21062", "woocommerce_cleanup_logs", "complete", "2026-01-15 05:27:13", "2026-01-15 05:27:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768454833;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768454833;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-15 06:24:39", "2026-01-15 06:24:39", "616", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21063", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-15 05:27:13", "2026-01-15 05:27:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768454833;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768454833;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-15 06:24:39", "2026-01-15 06:24:39", "616", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21064", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-14 06:27:13", "2026-01-14 06:27:13", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768372033;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768372033;}", "3", "1", "2026-01-14 06:29:05", "2026-01-14 06:29:05", "353", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21066", "woocommerce_geoip_updater", "complete", "2026-01-29 06:00:08", "2026-01-29 06:00:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769666408;s:18:\"\0*\0first_timestamp\";i:1768370400;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769666408;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}", "3", "1", "2026-01-29 06:00:20", "2026-01-29 06:00:20", "3987", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21067", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-14 07:29:05", "2026-01-14 07:29:05", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768375745;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768375745;}", "3", "1", "2026-01-14 09:04:51", "2026-01-14 09:04:51", "386", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21068", "wc_admin_daily_wrapper", "complete", "2026-01-15 06:59:21", "2026-01-15 06:59:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768460361;s:18:\"\0*\0first_timestamp\";i:1768287549;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768460361;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-15 07:39:17", "2026-01-15 07:39:17", "635", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21069", "woocommerce_cleanup_draft_orders", "complete", "2026-01-15 06:59:21", "2026-01-15 06:59:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768460361;s:18:\"\0*\0first_timestamp\";i:1768287550;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768460361;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-15 07:39:17", "2026-01-15 07:39:17", "635", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21070", "woocommerce_cleanup_sessions", "complete", "2026-01-15 06:00:00", "2026-01-15 06:00:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768456800;s:18:\"\0*\0first_timestamp\";i:1768456800;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768456800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "3", "1", "2026-01-15 06:24:39", "2026-01-15 06:24:39", "616", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21071", "generate_category_lookup_table_wrapper", "complete", "2026-01-14 06:59:31", "2026-01-14 06:59:31", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768373971;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768373971;}", "3", "1", "2026-01-14 07:01:19", "2026-01-14 07:01:19", "372", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21072", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-15 06:59:21", "2026-01-15 06:59:21", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768460361;s:18:\"\0*\0first_timestamp\";i:1768287544;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768460361;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2026-01-15 07:39:18", "2026-01-15 07:39:18", "635", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21073", "woocommerce_cleanup_personal_data", "complete", "2026-01-15 07:01:20", "2026-01-15 07:01:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768460480;s:18:\"\0*\0first_timestamp\";i:1768287559;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768460480;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-15 07:39:18", "2026-01-15 07:39:18", "635", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21074", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-14 10:04:51", "2026-01-14 10:04:51", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768385091;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768385091;}", "3", "1", "2026-01-14 10:05:29", "2026-01-14 10:05:29", "441", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21075", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-14 11:05:29", "2026-01-14 11:05:29", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768388729;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768388729;}", "3", "1", "2026-01-14 11:05:40", "2026-01-14 11:05:40", "503", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21076", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-14 12:05:40", "2026-01-14 12:05:40", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768392340;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768392340;}", "3", "1", "2026-01-14 12:05:53", "2026-01-14 12:05:53", "562", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21077", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-14 13:05:53", "2026-01-14 13:05:53", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768395953;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768395953;}", "3", "1", "2026-01-15 06:24:39", "2026-01-15 06:24:39", "616", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21078", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-15 07:24:39", "2026-01-15 07:24:39", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768461879;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768461879;}", "3", "1", "2026-01-15 07:39:18", "2026-01-15 07:39:18", "635", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21079", "woocommerce_refresh_order_count_cache", "complete", "2026-01-15 18:24:39", "2026-01-15 18:24:39", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768501479;s:18:\"\0*\0first_timestamp\";i:1768330749;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768501479;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "4", "1", "2026-01-16 04:44:44", "2026-01-16 04:44:44", "908", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21080", "woocommerce_scheduled_sales", "complete", "2026-01-16 06:24:39", "2026-01-16 06:24:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768544679;s:18:\"\0*\0first_timestamp\";i:1768348800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768544679;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-16 06:25:05", "2026-01-16 06:25:05", "944", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21081", "woocommerce_cleanup_logs", "complete", "2026-01-16 06:24:39", "2026-01-16 06:24:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768544679;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768544679;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-16 06:25:05", "2026-01-16 06:25:05", "944", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21082", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-16 06:24:39", "2026-01-16 06:24:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768544679;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768544679;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-16 06:25:06", "2026-01-16 06:25:06", "944", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21084", "tec_clear_expired_key_value_cache", "complete", "2026-01-15 18:24:41", "2026-01-15 18:24:41", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768501481;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768501481;}", "5", "1", "2026-01-16 04:44:44", "2026-01-16 04:44:44", "908", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21085", "wc_admin_daily_wrapper", "complete", "2026-01-16 07:39:17", "2026-01-16 07:39:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768549157;s:18:\"\0*\0first_timestamp\";i:1768287549;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768549157;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-16 07:39:51", "2026-01-16 07:39:51", "1023", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21086", "woocommerce_cleanup_draft_orders", "complete", "2026-01-16 07:39:17", "2026-01-16 07:39:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768549157;s:18:\"\0*\0first_timestamp\";i:1768287550;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768549157;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-16 07:39:51", "2026-01-16 07:39:51", "1023", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21087", "woocommerce_cleanup_personal_data", "complete", "2026-01-16 07:39:18", "2026-01-16 07:39:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768549158;s:18:\"\0*\0first_timestamp\";i:1768287559;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768549158;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-16 07:39:51", "2026-01-16 07:39:51", "1023", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21088", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-15 08:39:18", "2026-01-15 08:39:18", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768466358;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768466358;}", "3", "1", "2026-01-15 08:40:10", "2026-01-15 08:40:10", "650", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21089", "woocommerce_cleanup_sessions", "complete", "2026-01-16 06:00:00", "2026-01-16 06:00:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768543200;s:18:\"\0*\0first_timestamp\";i:1768543200;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768543200;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "3", "1", "2026-01-16 06:06:27", "2026-01-16 06:06:27", "922", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21090", "generate_category_lookup_table_wrapper", "complete", "2026-01-15 07:39:28", "2026-01-15 07:39:28", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768462768;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768462768;}", "3", "1", "2026-01-15 07:40:08", "2026-01-15 07:40:08", "638", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21091", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-16 07:39:18", "2026-01-16 07:39:18", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768549158;s:18:\"\0*\0first_timestamp\";i:1768287544;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768549158;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2026-01-16 07:39:51", "2026-01-16 07:39:51", "1023", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21092", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-15 09:40:10", "2026-01-15 09:40:10", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768470010;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768470010;}", "3", "1", "2026-01-15 09:40:12", "2026-01-15 09:40:12", "711", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21093", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-15 10:40:12", "2026-01-15 10:40:12", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768473612;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768473612;}", "3", "1", "2026-01-15 10:41:06", "2026-01-15 10:41:06", "773", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21094", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-15 11:41:06", "2026-01-15 11:41:06", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768477266;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768477266;}", "3", "1", "2026-01-15 11:41:19", "2026-01-15 11:41:19", "837", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21095", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-15 12:41:19", "2026-01-15 12:41:19", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768480879;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768480879;}", "3", "1", "2026-01-15 12:41:40", "2026-01-15 12:41:40", "889", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21096", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-15 13:41:40", "2026-01-15 13:41:40", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768484500;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768484500;}", "3", "1", "2026-01-16 04:44:44", "2026-01-16 04:44:44", "908", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21097", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-16 05:44:44", "2026-01-16 05:44:44", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768542284;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768542284;}", "3", "1", "2026-01-16 06:06:27", "2026-01-16 06:06:27", "922", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21098", "woocommerce_refresh_order_count_cache", "complete", "2026-01-16 16:44:44", "2026-01-16 16:44:44", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768581884;s:18:\"\0*\0first_timestamp\";i:1768330749;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768581884;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "4", "1", "2026-01-17 17:13:58", "2026-01-17 17:13:58", "1330", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21099", "tec_clear_expired_key_value_cache", "complete", "2026-01-16 16:44:47", "2026-01-16 16:44:47", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768581887;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768581887;}", "5", "1", "2026-01-17 17:13:58", "2026-01-17 17:13:58", "1330", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21100", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-16 07:06:27", "2026-01-16 07:06:27", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768547187;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768547187;}", "3", "1", "2026-01-16 07:07:09", "2026-01-16 07:07:09", "988", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21102", "woocommerce_scheduled_sales", "complete", "2026-01-17 06:25:05", "2026-01-17 06:25:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768631105;s:18:\"\0*\0first_timestamp\";i:1768348800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768631105;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-17 17:13:58", "2026-01-17 17:13:58", "1330", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21103", "woocommerce_cleanup_logs", "complete", "2026-01-17 06:25:05", "2026-01-17 06:25:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768631105;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768631105;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-17 17:13:58", "2026-01-17 17:13:58", "1330", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21104", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-17 06:25:06", "2026-01-17 06:25:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768631106;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768631106;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-17 17:13:58", "2026-01-17 17:13:58", "1330", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21105", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-16 08:07:09", "2026-01-16 08:07:09", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768550829;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768550829;}", "3", "1", "2026-01-16 08:07:19", "2026-01-16 08:07:19", "1054", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21106", "wc_admin_daily_wrapper", "complete", "2026-01-17 07:39:51", "2026-01-17 07:39:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768635591;s:18:\"\0*\0first_timestamp\";i:1768287549;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768635591;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-17 17:14:00", "2026-01-17 17:14:00", "1330", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21107", "woocommerce_cleanup_draft_orders", "complete", "2026-01-17 07:39:51", "2026-01-17 07:39:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768635591;s:18:\"\0*\0first_timestamp\";i:1768287550;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768635591;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-17 17:14:00", "2026-01-17 17:14:00", "1330", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21108", "woocommerce_cleanup_personal_data", "complete", "2026-01-17 07:39:51", "2026-01-17 07:39:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768635591;s:18:\"\0*\0first_timestamp\";i:1768287559;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768635591;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-17 17:14:01", "2026-01-17 17:14:01", "1330", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21109", "woocommerce_cleanup_sessions", "complete", "2026-01-17 06:00:00", "2026-01-17 06:00:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768629600;s:18:\"\0*\0first_timestamp\";i:1768629600;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768629600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "3", "1", "2026-01-17 17:13:58", "2026-01-17 17:13:58", "1330", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21110", "generate_category_lookup_table_wrapper", "complete", "2026-01-16 07:40:01", "2026-01-16 07:40:01", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768549201;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768549201;}", "3", "1", "2026-01-16 07:40:06", "2026-01-16 07:40:06", "1025", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21111", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-17 07:39:51", "2026-01-17 07:39:51", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768635591;s:18:\"\0*\0first_timestamp\";i:1768287544;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768635591;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2026-01-17 17:14:01", "2026-01-17 17:14:01", "1330", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21112", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-16 09:07:19", "2026-01-16 09:07:19", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768554439;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768554439;}", "3", "1", "2026-01-16 09:08:15", "2026-01-16 09:08:15", "1092", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21113", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-16 10:08:15", "2026-01-16 10:08:15", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768558095;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768558095;}", "3", "1", "2026-01-16 10:08:30", "2026-01-16 10:08:30", "1154", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21114", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-16 11:08:30", "2026-01-16 11:08:30", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768561710;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768561710;}", "3", "1", "2026-01-16 11:08:39", "2026-01-16 11:08:39", "1216", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21115", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-16 12:08:39", "2026-01-16 12:08:39", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768565319;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768565319;}", "3", "1", "2026-01-16 12:09:05", "2026-01-16 12:09:05", "1281", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21116", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-16 13:09:05", "2026-01-16 13:09:05", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768568945;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768568945;}", "3", "1", "2026-01-17 17:13:58", "2026-01-17 17:13:58", "1330", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21117", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-17 18:13:58", "2026-01-17 18:13:58", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768673638;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768673638;}", "3", "1", "2026-01-19 11:03:15", "2026-01-19 11:03:15", "1344", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21118", "woocommerce_refresh_order_count_cache", "complete", "2026-01-18 05:13:58", "2026-01-18 05:13:58", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768713238;s:18:\"\0*\0first_timestamp\";i:1768330749;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768713238;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "4", "1", "2026-01-19 11:03:15", "2026-01-19 11:03:15", "1344", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21120", "woocommerce_scheduled_sales", "complete", "2026-01-18 17:13:58", "2026-01-18 17:13:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768756438;s:18:\"\0*\0first_timestamp\";i:1768348800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768756438;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-19 11:03:15", "2026-01-19 11:03:15", "1344", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21121", "woocommerce_cleanup_logs", "complete", "2026-01-18 17:13:58", "2026-01-18 17:13:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768756438;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768756438;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-19 11:03:15", "2026-01-19 11:03:15", "1344", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21122", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-18 17:13:58", "2026-01-18 17:13:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768756438;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768756438;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-19 11:03:16", "2026-01-19 11:03:16", "1344", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21123", "wc_admin_daily_wrapper", "complete", "2026-01-18 17:14:00", "2026-01-18 17:14:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768756440;s:18:\"\0*\0first_timestamp\";i:1768287549;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768756440;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-19 11:03:18", "2026-01-19 11:03:18", "1344", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21124", "woocommerce_cleanup_draft_orders", "complete", "2026-01-18 17:14:00", "2026-01-18 17:14:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768756440;s:18:\"\0*\0first_timestamp\";i:1768287550;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768756440;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-19 11:03:18", "2026-01-19 11:03:18", "1344", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21125", "woocommerce_cleanup_personal_data", "complete", "2026-01-18 17:14:01", "2026-01-18 17:14:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768756441;s:18:\"\0*\0first_timestamp\";i:1768287559;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768756441;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-19 11:03:19", "2026-01-19 11:03:19", "1344", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21126", "woocommerce_cleanup_sessions", "complete", "2026-01-18 06:00:00", "2026-01-18 06:00:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768716000;s:18:\"\0*\0first_timestamp\";i:1768716000;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768716000;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "3", "1", "2026-01-19 11:03:15", "2026-01-19 11:03:15", "1344", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21127", "generate_category_lookup_table_wrapper", "complete", "2026-01-17 17:14:11", "2026-01-17 17:14:11", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768670051;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768670051;}", "3", "1", "2026-01-17 17:15:24", "2026-01-17 17:15:24", "1332", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21128", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-18 17:14:01", "2026-01-18 17:14:01", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768756441;s:18:\"\0*\0first_timestamp\";i:1768287544;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768756441;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2026-01-19 11:03:19", "2026-01-19 11:03:19", "1344", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21129", "tec_clear_expired_key_value_cache", "complete", "2026-01-18 05:14:03", "2026-01-18 05:14:03", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768713243;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768713243;}", "5", "1", "2026-01-19 11:03:15", "2026-01-19 11:03:15", "1344", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21130", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-19 12:03:15", "2026-01-19 12:03:15", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768824195;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768824195;}", "3", "1", "2026-01-20 04:55:36", "2026-01-20 04:55:36", "1346", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21131", "woocommerce_refresh_order_count_cache", "complete", "2026-01-19 23:03:15", "2026-01-19 23:03:15", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768863795;s:18:\"\0*\0first_timestamp\";i:1768330749;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768863795;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "4", "1", "2026-01-20 04:55:36", "2026-01-20 04:55:36", "1346", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21133", "woocommerce_scheduled_sales", "complete", "2026-01-20 11:03:15", "2026-01-20 11:03:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768906995;s:18:\"\0*\0first_timestamp\";i:1768348800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768906995;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-20 11:03:25", "2026-01-20 11:03:25", "1684", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21134", "woocommerce_cleanup_logs", "complete", "2026-01-20 11:03:15", "2026-01-20 11:03:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768906995;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768906995;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-20 11:03:25", "2026-01-20 11:03:25", "1684", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21135", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-20 11:03:16", "2026-01-20 11:03:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768906996;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768906996;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-20 11:03:25", "2026-01-20 11:03:25", "1684", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21136", "tec_clear_expired_key_value_cache", "complete", "2026-01-19 23:03:16", "2026-01-19 23:03:16", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768863796;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768863796;}", "5", "1", "2026-01-20 04:55:36", "2026-01-20 04:55:36", "1346", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21137", "wc_admin_daily_wrapper", "complete", "2026-01-20 11:03:18", "2026-01-20 11:03:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768906998;s:18:\"\0*\0first_timestamp\";i:1768287549;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768906998;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-20 11:03:26", "2026-01-20 11:03:26", "1684", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21138", "woocommerce_cleanup_draft_orders", "complete", "2026-01-20 11:03:18", "2026-01-20 11:03:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768906998;s:18:\"\0*\0first_timestamp\";i:1768287550;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768906998;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-20 11:03:26", "2026-01-20 11:03:26", "1684", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21139", "woocommerce_cleanup_personal_data", "complete", "2026-01-20 11:03:19", "2026-01-20 11:03:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768906999;s:18:\"\0*\0first_timestamp\";i:1768287559;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768906999;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-20 11:03:27", "2026-01-20 11:03:27", "1684", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21140", "woocommerce_cleanup_sessions", "complete", "2026-01-20 06:00:00", "2026-01-20 06:00:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768888800;s:18:\"\0*\0first_timestamp\";i:1768888800;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768888800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "3", "1", "2026-01-20 06:00:07", "2026-01-20 06:00:07", "1410", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21141", "generate_category_lookup_table_wrapper", "complete", "2026-01-19 11:03:29", "2026-01-19 11:03:29", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768820609;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768820609;}", "3", "1", "2026-01-20 04:55:35", "2026-01-20 04:55:35", "1346", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21142", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-20 11:03:19", "2026-01-20 11:03:19", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768906999;s:18:\"\0*\0first_timestamp\";i:1768287544;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768906999;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2026-01-20 11:03:27", "2026-01-20 11:03:27", "1684", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21143", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-20 05:55:36", "2026-01-20 05:55:36", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768888536;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768888536;}", "3", "1", "2026-01-20 05:56:01", "2026-01-20 05:56:01", "1404", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21144", "woocommerce_refresh_order_count_cache", "complete", "2026-01-20 16:55:36", "2026-01-20 16:55:36", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768928136;s:18:\"\0*\0first_timestamp\";i:1768330749;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768928136;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "4", "1", "2026-01-21 04:50:06", "2026-01-21 04:50:06", "1785", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21145", "tec_clear_expired_key_value_cache", "complete", "2026-01-20 16:55:39", "2026-01-20 16:55:39", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768928139;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768928139;}", "5", "1", "2026-01-21 04:50:06", "2026-01-21 04:50:06", "1785", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21146", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-20 06:56:01", "2026-01-20 06:56:01", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768892161;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768892161;}", "3", "1", "2026-01-20 06:56:05", "2026-01-20 06:56:05", "1469", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21148", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-20 07:56:05", "2026-01-20 07:56:05", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768895765;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768895765;}", "3", "1", "2026-01-20 07:56:05", "2026-01-20 07:56:05", "1532", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21149", "action_scheduler/migration_hook", "complete", "2026-01-20 07:49:53", "2026-01-20 07:49:53", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768895393;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768895393;}", "2", "1", "2026-01-20 07:50:07", "2026-01-20 07:50:07", "1526", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21150", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-20 08:56:05", "2026-01-20 08:56:05", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768899365;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768899365;}", "3", "1", "2026-01-20 08:56:30", "2026-01-20 08:56:30", "1568", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21151", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-20 09:56:30", "2026-01-20 09:56:30", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768902990;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768902990;}", "3", "1", "2026-01-20 09:57:04", "2026-01-20 09:57:04", "1629", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21152", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-20 10:57:04", "2026-01-20 10:57:04", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768906624;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768906624;}", "3", "1", "2026-01-20 10:57:06", "2026-01-20 10:57:06", "1676", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21153", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-20 11:57:06", "2026-01-20 11:57:06", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768910226;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768910226;}", "3", "1", "2026-01-20 11:57:09", "2026-01-20 11:57:09", "1733", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21154", "woocommerce_scheduled_sales", "complete", "2026-01-21 11:03:25", "2026-01-21 11:03:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768993405;s:18:\"\0*\0first_timestamp\";i:1768348800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768993405;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-22 05:32:39", "2026-01-22 05:32:39", "1953", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21155", "woocommerce_cleanup_logs", "complete", "2026-01-21 11:03:25", "2026-01-21 11:03:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768993405;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768993405;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-22 05:32:39", "2026-01-22 05:32:39", "1953", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21156", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-21 11:03:25", "2026-01-21 11:03:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768993405;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768993405;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-22 05:32:39", "2026-01-22 05:32:39", "1953", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21157", "wc_admin_daily_wrapper", "complete", "2026-01-21 11:03:26", "2026-01-21 11:03:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768993406;s:18:\"\0*\0first_timestamp\";i:1768287549;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768993406;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-22 05:32:41", "2026-01-22 05:32:41", "1953", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21158", "woocommerce_cleanup_draft_orders", "complete", "2026-01-21 11:03:26", "2026-01-21 11:03:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768993406;s:18:\"\0*\0first_timestamp\";i:1768287550;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768993406;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-22 05:32:41", "2026-01-22 05:32:41", "1953", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21159", "woocommerce_cleanup_personal_data", "complete", "2026-01-21 11:03:27", "2026-01-21 11:03:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768993407;s:18:\"\0*\0first_timestamp\";i:1768287559;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768993407;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-22 05:32:42", "2026-01-22 05:32:42", "1953", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21160", "woocommerce_cleanup_sessions", "complete", "2026-01-21 06:00:00", "2026-01-21 06:00:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768975200;s:18:\"\0*\0first_timestamp\";i:1768975200;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768975200;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "3", "1", "2026-01-21 06:00:10", "2026-01-21 06:00:10", "1834", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21161", "generate_category_lookup_table_wrapper", "complete", "2026-01-20 11:03:37", "2026-01-20 11:03:37", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768907017;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768907017;}", "3", "1", "2026-01-20 11:04:07", "2026-01-20 11:04:07", "1686", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21162", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-21 11:03:27", "2026-01-21 11:03:27", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1768993407;s:18:\"\0*\0first_timestamp\";i:1768287544;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1768993407;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2026-01-22 05:32:42", "2026-01-22 05:32:42", "1953", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21163", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-20 12:57:09", "2026-01-20 12:57:09", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768913829;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768913829;}", "3", "1", "2026-01-20 12:58:17", "2026-01-20 12:58:17", "1781", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21164", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-20 13:58:17", "2026-01-20 13:58:17", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768917497;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768917497;}", "3", "1", "2026-01-21 04:50:06", "2026-01-21 04:50:06", "1785", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21165", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-21 05:50:06", "2026-01-21 05:50:06", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768974606;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768974606;}", "3", "1", "2026-01-21 05:50:08", "2026-01-21 05:50:08", "1824", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21166", "woocommerce_refresh_order_count_cache", "complete", "2026-01-21 16:50:06", "2026-01-21 16:50:06", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769014206;s:18:\"\0*\0first_timestamp\";i:1768330749;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769014206;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "4", "1", "2026-01-22 05:32:42", "2026-01-22 05:32:42", "1953", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21167", "tec_clear_expired_key_value_cache", "complete", "2026-01-21 16:50:07", "2026-01-21 16:50:07", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769014207;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769014207;}", "5", "1", "2026-01-22 05:32:42", "2026-01-22 05:32:42", "1953", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21168", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-21 06:50:08", "2026-01-21 06:50:08", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768978208;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768978208;}", "3", "1", "2026-01-21 06:51:10", "2026-01-21 06:51:10", "1887", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21169", "woocommerce_cleanup_sessions", "complete", "2026-01-21 18:00:10", "2026-01-21 18:00:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769018410;s:18:\"\0*\0first_timestamp\";i:1768975200;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769018410;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "3", "1", "2026-01-22 05:32:42", "2026-01-22 05:32:42", "1953", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21170", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-21 07:51:10", "2026-01-21 07:51:10", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768981870;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768981870;}", "3", "1", "2026-01-21 08:52:37", "2026-01-21 08:52:37", "1939", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21171", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-21 09:52:37", "2026-01-21 09:52:37", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1768989157;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1768989157;}", "3", "1", "2026-01-22 05:32:39", "2026-01-22 05:32:39", "1953", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21172", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-22 06:32:39", "2026-01-22 06:32:39", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769063559;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769063559;}", "3", "1", "2026-01-22 16:53:04", "2026-01-22 16:53:04", "1955", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21173", "woocommerce_scheduled_sales", "complete", "2026-01-23 05:32:39", "2026-01-23 05:32:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769146359;s:18:\"\0*\0first_timestamp\";i:1768348800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769146359;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-23 05:33:15", "2026-01-23 05:33:15", "1970", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21174", "woocommerce_cleanup_logs", "complete", "2026-01-23 05:32:39", "2026-01-23 05:32:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769146359;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769146359;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-23 05:33:15", "2026-01-23 05:33:15", "1970", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21175", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-23 05:32:39", "2026-01-23 05:32:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769146359;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769146359;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-23 05:33:15", "2026-01-23 05:33:15", "1970", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21176", "wc_admin_daily_wrapper", "complete", "2026-01-23 05:32:41", "2026-01-23 05:32:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769146361;s:18:\"\0*\0first_timestamp\";i:1768287549;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769146361;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-23 05:33:16", "2026-01-23 05:33:16", "1970", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21177", "woocommerce_cleanup_draft_orders", "complete", "2026-01-23 05:32:41", "2026-01-23 05:32:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769146361;s:18:\"\0*\0first_timestamp\";i:1768287550;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769146361;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-23 05:33:16", "2026-01-23 05:33:16", "1970", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21178", "woocommerce_cleanup_personal_data", "complete", "2026-01-23 05:32:42", "2026-01-23 05:32:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769146362;s:18:\"\0*\0first_timestamp\";i:1768287559;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769146362;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-23 05:33:17", "2026-01-23 05:33:17", "1970", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21179", "woocommerce_refresh_order_count_cache", "complete", "2026-01-22 17:32:42", "2026-01-22 17:32:42", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769103162;s:18:\"\0*\0first_timestamp\";i:1768330749;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769103162;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "4", "1", "2026-01-23 04:52:16", "2026-01-23 04:52:16", "1959", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21182", "generate_category_lookup_table_wrapper", "complete", "2026-01-22 05:32:52", "2026-01-22 05:32:52", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769059972;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769059972;}", "3", "1", "2026-01-22 16:53:03", "2026-01-22 16:53:03", "1955", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21183", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-23 05:32:42", "2026-01-23 05:32:42", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769146362;s:18:\"\0*\0first_timestamp\";i:1768287544;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769146362;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2026-01-23 05:33:17", "2026-01-23 05:33:17", "1970", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21184", "tec_clear_expired_key_value_cache", "complete", "2026-01-22 17:32:43", "2026-01-22 17:32:43", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769103163;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769103163;}", "5", "1", "2026-01-23 04:52:16", "2026-01-23 04:52:16", "1959", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21185", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-22 17:53:04", "2026-01-22 17:53:04", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769104384;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769104384;}", "3", "1", "2026-01-23 04:52:16", "2026-01-23 04:52:16", "1959", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21186", "woocommerce_refresh_order_count_cache", "complete", "2026-01-23 16:52:16", "2026-01-23 16:52:16", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769187136;s:18:\"\0*\0first_timestamp\";i:1768330749;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769187136;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "4", "1", "2026-01-23 16:54:52", "2026-01-23 16:54:52", "2422", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21187", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-23 05:52:16", "2026-01-23 05:52:16", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769147536;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769147536;}", "3", "1", "2026-01-23 06:36:36", "2026-01-23 06:36:36", "1977", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21188", "tec_clear_expired_key_value_cache", "complete", "2026-01-23 16:53:04", "2026-01-23 16:53:04", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769187184;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769187184;}", "5", "1", "2026-01-23 16:54:52", "2026-01-23 16:54:52", "2422", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21189", "woocommerce_scheduled_sales", "complete", "2026-01-24 05:33:15", "2026-01-24 05:33:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769232795;s:18:\"\0*\0first_timestamp\";i:1768348800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769232795;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-24 05:33:22", "2026-01-24 05:33:22", "2564", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21190", "woocommerce_cleanup_logs", "complete", "2026-01-24 05:33:15", "2026-01-24 05:33:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769232795;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769232795;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-24 05:33:22", "2026-01-24 05:33:22", "2564", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21191", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-24 05:33:15", "2026-01-24 05:33:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769232795;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769232795;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-24 05:33:22", "2026-01-24 05:33:22", "2564", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21192", "wc_admin_daily_wrapper", "complete", "2026-01-24 05:33:16", "2026-01-24 05:33:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769232796;s:18:\"\0*\0first_timestamp\";i:1768287549;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769232796;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-24 05:33:23", "2026-01-24 05:33:23", "2564", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21193", "woocommerce_cleanup_draft_orders", "complete", "2026-01-24 05:33:16", "2026-01-24 05:33:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769232796;s:18:\"\0*\0first_timestamp\";i:1768287550;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769232796;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-24 05:33:23", "2026-01-24 05:33:23", "2564", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21194", "woocommerce_cleanup_personal_data", "complete", "2026-01-24 05:33:17", "2026-01-24 05:33:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769232797;s:18:\"\0*\0first_timestamp\";i:1768287559;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769232797;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-24 05:33:24", "2026-01-24 05:33:24", "2564", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21196", "generate_category_lookup_table_wrapper", "complete", "2026-01-23 05:33:27", "2026-01-23 05:33:27", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769146407;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769146407;}", "3", "1", "2026-01-23 05:34:25", "2026-01-23 05:34:25", "1972", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21197", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-24 05:33:17", "2026-01-24 05:33:17", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769232797;s:18:\"\0*\0first_timestamp\";i:1768287544;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769232797;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2026-01-24 05:33:24", "2026-01-24 05:33:24", "2564", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21198", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-23 07:36:36", "2026-01-23 07:36:36", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769153796;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769153796;}", "3", "1", "2026-01-23 07:37:09", "2026-01-23 07:37:09", "2026", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21199", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-23 08:37:09", "2026-01-23 08:37:09", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769157429;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769157429;}", "3", "1", "2026-01-23 08:48:04", "2026-01-23 08:48:04", "2048", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21200", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-23 09:48:04", "2026-01-23 09:48:04", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769161684;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769161684;}", "3", "1", "2026-01-23 09:48:11", "2026-01-23 09:48:11", "2106", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21201", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-23 10:48:11", "2026-01-23 10:48:11", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769165291;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769165291;}", "3", "1", "2026-01-23 10:48:45", "2026-01-23 10:48:45", "2161", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21202", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-23 11:48:45", "2026-01-23 11:48:45", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769168925;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769168925;}", "3", "1", "2026-01-23 11:49:20", "2026-01-23 11:49:20", "2219", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21203", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-23 12:49:20", "2026-01-23 12:49:20", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769172560;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769172560;}", "3", "1", "2026-01-23 12:50:05", "2026-01-23 12:50:05", "2282", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21204", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-23 13:50:05", "2026-01-23 13:50:05", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769176205;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769176205;}", "3", "1", "2026-01-23 14:01:13", "2026-01-23 14:01:13", "2292", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21205", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-23 15:01:13", "2026-01-23 15:01:13", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769180473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769180473;}", "3", "1", "2026-01-23 15:01:16", "2026-01-23 15:01:16", "2339", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21206", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-23 16:01:16", "2026-01-23 16:01:16", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769184076;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769184076;}", "3", "1", "2026-01-23 16:02:28", "2026-01-23 16:02:28", "2394", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21207", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-23 17:02:28", "2026-01-23 17:02:28", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769187748;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769187748;}", "3", "1", "2026-01-23 17:02:39", "2026-01-23 17:02:39", "2433", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21208", "woocommerce_refresh_order_count_cache", "complete", "2026-01-24 04:54:52", "2026-01-24 04:54:52", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769230492;s:18:\"\0*\0first_timestamp\";i:1768330749;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769230492;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "4", "1", "2026-01-24 04:55:25", "2026-01-24 04:55:25", "2528", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21209", "tec_clear_expired_key_value_cache", "complete", "2026-01-24 04:54:53", "2026-01-24 04:54:53", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769230493;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769230493;}", "5", "1", "2026-01-24 04:55:25", "2026-01-24 04:55:25", "2528", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21210", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-23 18:02:39", "2026-01-23 18:02:39", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769191359;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769191359;}", "3", "1", "2026-01-23 18:03:28", "2026-01-23 18:03:28", "2494", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21211", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-23 19:03:28", "2026-01-23 19:03:28", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769195008;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769195008;}", "3", "1", "2026-01-24 04:45:11", "2026-01-24 04:45:11", "2515", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21212", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-24 05:45:11", "2026-01-24 05:45:11", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769233511;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769233511;}", "3", "1", "2026-01-24 05:45:47", "2026-01-24 05:45:47", "2579", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21213", "woocommerce_refresh_order_count_cache", "complete", "2026-01-24 16:55:25", "2026-01-24 16:55:25", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769273725;s:18:\"\0*\0first_timestamp\";i:1768330749;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769273725;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "4", "1", "2026-01-27 04:02:59", "2026-01-27 04:02:59", "2986", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21214", "tec_clear_expired_key_value_cache", "complete", "2026-01-24 16:55:38", "2026-01-24 16:55:38", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769273738;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769273738;}", "5", "1", "2026-01-27 04:02:59", "2026-01-27 04:02:59", "2986", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21215", "woocommerce_scheduled_sales", "complete", "2026-01-25 05:33:22", "2026-01-25 05:33:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769319202;s:18:\"\0*\0first_timestamp\";i:1768348800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769319202;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-27 04:02:59", "2026-01-27 04:02:59", "2986", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21216", "woocommerce_cleanup_logs", "complete", "2026-01-25 05:33:22", "2026-01-25 05:33:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769319202;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769319202;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-27 04:02:59", "2026-01-27 04:02:59", "2986", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21217", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-25 05:33:22", "2026-01-25 05:33:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769319202;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769319202;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-27 04:02:59", "2026-01-27 04:02:59", "2986", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21218", "wc_admin_daily_wrapper", "complete", "2026-01-25 05:33:23", "2026-01-25 05:33:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769319203;s:18:\"\0*\0first_timestamp\";i:1768287549;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769319203;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-27 04:03:00", "2026-01-27 04:03:00", "2986", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21219", "woocommerce_cleanup_draft_orders", "complete", "2026-01-25 05:33:23", "2026-01-25 05:33:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769319203;s:18:\"\0*\0first_timestamp\";i:1768287550;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769319203;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-27 04:03:00", "2026-01-27 04:03:00", "2986", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21220", "woocommerce_cleanup_personal_data", "complete", "2026-01-25 05:33:24", "2026-01-25 05:33:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769319204;s:18:\"\0*\0first_timestamp\";i:1768287559;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769319204;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-27 04:03:01", "2026-01-27 04:03:01", "2986", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21221", "woocommerce_cleanup_sessions", "complete", "2026-01-25 06:00:00", "2026-01-25 06:00:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769320800;s:18:\"\0*\0first_timestamp\";i:1769320800;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769320800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "3", "1", "2026-01-27 04:03:01", "2026-01-27 04:03:01", "2986", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21222", "generate_category_lookup_table_wrapper", "complete", "2026-01-24 05:33:34", "2026-01-24 05:33:34", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769232814;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769232814;}", "3", "1", "2026-01-24 05:34:15", "2026-01-24 05:34:15", "2566", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21223", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-25 05:33:24", "2026-01-25 05:33:24", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769319204;s:18:\"\0*\0first_timestamp\";i:1768287544;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769319204;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2026-01-27 04:03:01", "2026-01-27 04:03:01", "2986", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21224", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-24 06:45:47", "2026-01-24 06:45:47", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769237147;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769237147;}", "3", "1", "2026-01-24 06:47:12", "2026-01-24 06:47:12", "2635", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21225", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-24 07:47:12", "2026-01-24 07:47:12", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769240832;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769240832;}", "3", "1", "2026-01-24 07:47:23", "2026-01-24 07:47:23", "2695", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21226", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-24 08:47:23", "2026-01-24 08:47:23", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769244443;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769244443;}", "3", "1", "2026-01-24 08:47:29", "2026-01-24 08:47:29", "2722", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21227", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-24 09:47:29", "2026-01-24 09:47:29", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769248049;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769248049;}", "3", "1", "2026-01-24 09:48:16", "2026-01-24 09:48:16", "2785", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21228", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-24 10:48:16", "2026-01-24 10:48:16", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769251696;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769251696;}", "3", "1", "2026-01-24 10:48:26", "2026-01-24 10:48:26", "2841", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21229", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-24 11:48:26", "2026-01-24 11:48:26", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769255306;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769255306;}", "3", "1", "2026-01-24 11:48:27", "2026-01-24 11:48:27", "2900", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21230", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-24 12:48:27", "2026-01-24 12:48:27", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769258907;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769258907;}", "3", "1", "2026-01-24 12:48:55", "2026-01-24 12:48:55", "2953", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21231", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-24 13:48:55", "2026-01-24 13:48:55", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769262535;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769262535;}", "3", "1", "2026-01-24 13:49:28", "2026-01-24 13:49:28", "2973", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21232", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-24 14:49:28", "2026-01-24 14:49:28", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769266168;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769266168;}", "3", "1", "2026-01-27 04:02:59", "2026-01-27 04:02:59", "2986", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21233", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-27 05:02:59", "2026-01-27 05:02:59", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769490179;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769490179;}", "3", "1", "2026-01-27 05:03:24", "2026-01-27 05:03:24", "3031", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21234", "woocommerce_refresh_order_count_cache", "complete", "2026-01-27 16:02:59", "2026-01-27 16:02:59", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769529779;s:18:\"\0*\0first_timestamp\";i:1768330749;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769529779;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "4", "1", "2026-01-27 16:40:42", "2026-01-27 16:40:42", "3330", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21235", "woocommerce_scheduled_sales", "complete", "2026-01-28 04:02:59", "2026-01-28 04:02:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769572979;s:18:\"\0*\0first_timestamp\";i:1768348800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769572979;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-28 04:57:39", "2026-01-28 04:57:39", "3372", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21236", "woocommerce_cleanup_logs", "complete", "2026-01-28 04:02:59", "2026-01-28 04:02:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769572979;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769572979;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-28 04:57:39", "2026-01-28 04:57:39", "3372", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21237", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-28 04:02:59", "2026-01-28 04:02:59", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769572979;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769572979;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-28 04:57:39", "2026-01-28 04:57:39", "3372", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21238", "wc_admin_daily_wrapper", "complete", "2026-01-28 04:03:00", "2026-01-28 04:03:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769572980;s:18:\"\0*\0first_timestamp\";i:1768287549;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769572980;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-28 04:57:39", "2026-01-28 04:57:39", "3372", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21239", "woocommerce_cleanup_draft_orders", "complete", "2026-01-28 04:03:00", "2026-01-28 04:03:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769572980;s:18:\"\0*\0first_timestamp\";i:1768287550;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769572980;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-28 04:57:39", "2026-01-28 04:57:39", "3372", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21240", "woocommerce_cleanup_personal_data", "complete", "2026-01-28 04:03:01", "2026-01-28 04:03:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769572981;s:18:\"\0*\0first_timestamp\";i:1768287559;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769572981;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-28 04:57:40", "2026-01-28 04:57:40", "3372", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21243", "generate_category_lookup_table_wrapper", "complete", "2026-01-27 04:03:11", "2026-01-27 04:03:11", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769486591;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769486591;}", "3", "1", "2026-01-27 04:03:48", "2026-01-27 04:03:48", "2988", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21244", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-28 04:03:01", "2026-01-28 04:03:01", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769572981;s:18:\"\0*\0first_timestamp\";i:1768287544;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769572981;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2026-01-28 04:57:40", "2026-01-28 04:57:40", "3372", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21245", "tec_clear_expired_key_value_cache", "complete", "2026-01-27 16:03:02", "2026-01-27 16:03:02", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769529782;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769529782;}", "5", "1", "2026-01-27 16:40:42", "2026-01-27 16:40:42", "3330", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21246", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-27 06:03:24", "2026-01-27 06:03:24", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769493804;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769493804;}", "3", "1", "2026-01-27 06:03:34", "2026-01-27 06:03:34", "3085", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21247", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-27 07:03:34", "2026-01-27 07:03:34", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769497414;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769497414;}", "3", "1", "2026-01-27 07:03:50", "2026-01-27 07:03:50", "3146", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21248", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-27 08:03:50", "2026-01-27 08:03:50", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769501030;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769501030;}", "3", "1", "2026-01-27 08:32:38", "2026-01-27 08:32:38", "3205", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21249", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-27 09:32:38", "2026-01-27 09:32:38", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769506358;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769506358;}", "3", "1", "2026-01-27 11:17:08", "2026-01-27 11:17:08", "3238", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21250", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-27 12:17:08", "2026-01-27 12:17:08", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769516228;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769516228;}", "3", "1", "2026-01-27 12:17:11", "2026-01-27 12:17:11", "3287", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21251", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-27 13:17:11", "2026-01-27 13:17:11", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769519831;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769519831;}", "3", "1", "2026-01-27 15:21:56", "2026-01-27 15:21:56", "3327", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21252", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-27 16:21:56", "2026-01-27 16:21:56", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769530916;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769530916;}", "3", "1", "2026-01-27 16:40:42", "2026-01-27 16:40:42", "3330", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21253", "woocommerce_refresh_order_count_cache", "complete", "2026-01-28 04:40:42", "2026-01-28 04:40:42", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769575242;s:18:\"\0*\0first_timestamp\";i:1768330749;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769575242;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "4", "1", "2026-01-28 04:57:40", "2026-01-28 04:57:40", "3372", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21254", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-27 17:40:42", "2026-01-27 17:40:42", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769535642;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769535642;}", "3", "1", "2026-01-27 17:46:22", "2026-01-27 17:46:22", "3334", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21255", "tec_clear_expired_key_value_cache", "complete", "2026-01-28 04:40:45", "2026-01-28 04:40:45", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769575245;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769575245;}", "5", "1", "2026-01-28 04:57:40", "2026-01-28 04:57:40", "3372", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21256", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-27 18:46:22", "2026-01-27 18:46:22", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769539582;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769539582;}", "3", "1", "2026-01-27 19:07:02", "2026-01-27 19:07:02", "3338", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21257", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-27 20:07:02", "2026-01-27 20:07:02", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769544422;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769544422;}", "3", "1", "2026-01-27 20:12:14", "2026-01-27 20:12:14", "3340", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21258", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-27 21:12:14", "2026-01-27 21:12:14", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769548334;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769548334;}", "3", "1", "2026-01-27 22:14:49", "2026-01-27 22:14:49", "3346", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21259", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-27 23:14:49", "2026-01-27 23:14:49", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769555689;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769555689;}", "3", "1", "2026-01-27 23:20:27", "2026-01-27 23:20:27", "3349", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21260", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-28 00:20:27", "2026-01-28 00:20:27", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769559627;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769559627;}", "3", "1", "2026-01-28 01:13:43", "2026-01-28 01:13:43", "3357", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21261", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-28 02:13:43", "2026-01-28 02:13:43", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769566423;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769566423;}", "3", "1", "2026-01-28 02:19:27", "2026-01-28 02:19:27", "3370", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21262", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-28 03:19:27", "2026-01-28 03:19:27", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769570367;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769570367;}", "3", "1", "2026-01-28 04:57:39", "2026-01-28 04:57:39", "3372", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21263", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-28 05:57:39", "2026-01-28 05:57:39", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769579859;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769579859;}", "3", "1", "2026-01-28 05:58:20", "2026-01-28 05:58:20", "3427", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21264", "woocommerce_scheduled_sales", "complete", "2026-01-29 04:57:39", "2026-01-29 04:57:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769662659;s:18:\"\0*\0first_timestamp\";i:1768348800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769662659;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-29 04:57:39", "2026-01-29 04:57:39", "3918", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21265", "woocommerce_cleanup_logs", "complete", "2026-01-29 04:57:39", "2026-01-29 04:57:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769662659;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769662659;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-29 04:57:39", "2026-01-29 04:57:39", "3918", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21266", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-29 04:57:39", "2026-01-29 04:57:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769662659;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769662659;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-29 04:57:39", "2026-01-29 04:57:39", "3918", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21267", "wc_admin_daily_wrapper", "complete", "2026-01-29 04:57:39", "2026-01-29 04:57:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769662659;s:18:\"\0*\0first_timestamp\";i:1768287549;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769662659;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-29 04:57:40", "2026-01-29 04:57:40", "3918", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21268", "woocommerce_cleanup_draft_orders", "complete", "2026-01-29 04:57:39", "2026-01-29 04:57:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769662659;s:18:\"\0*\0first_timestamp\";i:1768287550;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769662659;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-29 04:57:40", "2026-01-29 04:57:40", "3918", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21269", "woocommerce_cleanup_personal_data", "complete", "2026-01-29 04:57:40", "2026-01-29 04:57:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769662660;s:18:\"\0*\0first_timestamp\";i:1768287559;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769662660;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-29 04:57:41", "2026-01-29 04:57:41", "3919", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21270", "woocommerce_refresh_order_count_cache", "complete", "2026-01-28 16:57:40", "2026-01-28 16:57:40", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769619460;s:18:\"\0*\0first_timestamp\";i:1768330749;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769619460;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "4", "1", "2026-01-28 16:58:19", "2026-01-28 16:58:19", "3866", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21272", "generate_category_lookup_table_wrapper", "complete", "2026-01-28 04:57:50", "2026-01-28 04:57:50", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769576270;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769576270;}", "3", "1", "2026-01-28 04:59:53", "2026-01-28 04:59:53", "3374", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21273", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-29 04:57:40", "2026-01-29 04:57:40", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769662660;s:18:\"\0*\0first_timestamp\";i:1768287544;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769662660;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2026-01-29 04:57:41", "2026-01-29 04:57:41", "3919", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21274", "tec_clear_expired_key_value_cache", "complete", "2026-01-28 16:57:40", "2026-01-28 16:57:40", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769619460;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769619460;}", "5", "1", "2026-01-28 16:58:19", "2026-01-28 16:58:19", "3866", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21275", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-28 06:58:20", "2026-01-28 06:58:20", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769583500;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769583500;}", "3", "1", "2026-01-28 06:58:20", "2026-01-28 06:58:20", "3487", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21276", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-28 07:58:20", "2026-01-28 07:58:20", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769587100;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769587100;}", "3", "1", "2026-01-28 07:58:30", "2026-01-28 07:58:30", "3548", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21277", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-28 08:58:30", "2026-01-28 08:58:30", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769590710;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769590710;}", "3", "1", "2026-01-28 08:58:54", "2026-01-28 08:58:54", "3575", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21278", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-28 09:58:54", "2026-01-28 09:58:54", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769594334;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769594334;}", "3", "1", "2026-01-28 09:59:18", "2026-01-28 09:59:18", "3643", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21279", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-28 10:59:18", "2026-01-28 10:59:18", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769597958;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769597958;}", "3", "1", "2026-01-28 10:59:20", "2026-01-28 10:59:20", "3701", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21280", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-28 11:59:20", "2026-01-28 11:59:20", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769601560;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769601560;}", "3", "1", "2026-01-28 11:59:22", "2026-01-28 11:59:22", "3761", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21281", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-28 12:59:22", "2026-01-28 12:59:22", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769605162;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769605162;}", "3", "1", "2026-01-28 12:59:40", "2026-01-28 12:59:40", "3821", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21282", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-28 13:59:40", "2026-01-28 13:59:40", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769608780;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769608780;}", "3", "1", "2026-01-28 16:17:48", "2026-01-28 16:17:48", "3826", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21283", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-28 17:17:48", "2026-01-28 17:17:48", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769620668;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769620668;}", "3", "1", "2026-01-28 17:18:42", "2026-01-28 17:18:42", "3884", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21284", "woocommerce_refresh_order_count_cache", "complete", "2026-01-29 04:58:19", "2026-01-29 04:58:19", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769662699;s:18:\"\0*\0first_timestamp\";i:1768330749;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769662699;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "4", "1", "2026-01-29 04:58:19", "2026-01-29 04:58:19", "3921", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21285", "tec_clear_expired_key_value_cache", "complete", "2026-01-29 04:58:29", "2026-01-29 04:58:29", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769662709;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769662709;}", "5", "1", "2026-01-29 04:58:44", "2026-01-29 04:58:44", "3923", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21286", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-28 18:18:42", "2026-01-28 18:18:42", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769624322;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769624322;}", "3", "1", "2026-01-29 04:42:57", "2026-01-29 04:42:57", "3906", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21287", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-29 05:42:57", "2026-01-29 05:42:57", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769665377;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769665377;}", "3", "1", "2026-01-29 05:43:22", "2026-01-29 05:43:22", "3968", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21288", "woocommerce_scheduled_sales", "complete", "2026-01-30 04:57:39", "2026-01-30 04:57:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769749059;s:18:\"\0*\0first_timestamp\";i:1768348800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769749059;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-30 05:16:33", "2026-01-30 05:16:33", "4444", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21289", "woocommerce_cleanup_logs", "complete", "2026-01-30 04:57:39", "2026-01-30 04:57:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769749059;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769749059;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-30 05:16:33", "2026-01-30 05:16:33", "4444", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21290", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-30 04:57:39", "2026-01-30 04:57:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769749059;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769749059;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-30 05:16:33", "2026-01-30 05:16:33", "4444", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21291", "wc_admin_daily_wrapper", "complete", "2026-01-30 04:57:40", "2026-01-30 04:57:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769749060;s:18:\"\0*\0first_timestamp\";i:1768287549;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769749060;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-30 05:16:33", "2026-01-30 05:16:33", "4444", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21292", "woocommerce_cleanup_draft_orders", "complete", "2026-01-30 04:57:40", "2026-01-30 04:57:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769749060;s:18:\"\0*\0first_timestamp\";i:1768287550;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769749060;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-30 05:16:33", "2026-01-30 05:16:33", "4444", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21293", "woocommerce_cleanup_personal_data", "complete", "2026-01-30 04:57:41", "2026-01-30 04:57:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769749061;s:18:\"\0*\0first_timestamp\";i:1768287559;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769749061;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-30 05:16:34", "2026-01-30 05:16:34", "4444", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21295", "generate_category_lookup_table_wrapper", "complete", "2026-01-29 04:57:51", "2026-01-29 04:57:51", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769662671;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769662671;}", "3", "1", "2026-01-29 04:58:19", "2026-01-29 04:58:19", "3921", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21296", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-30 04:57:41", "2026-01-30 04:57:41", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769749061;s:18:\"\0*\0first_timestamp\";i:1768287544;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769749061;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2026-01-30 05:16:34", "2026-01-30 05:16:34", "4444", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21297", "woocommerce_refresh_order_count_cache", "complete", "2026-01-29 16:58:19", "2026-01-29 16:58:19", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769705899;s:18:\"\0*\0first_timestamp\";i:1768330749;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769705899;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "4", "1", "2026-01-29 22:28:04", "2026-01-29 22:28:04", "4404", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21298", "tec_clear_expired_key_value_cache", "complete", "2026-01-29 16:58:45", "2026-01-29 16:58:45", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769705925;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769705925;}", "5", "1", "2026-01-29 22:28:04", "2026-01-29 22:28:04", "4404", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21299", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-29 06:43:22", "2026-01-29 06:43:22", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769669002;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769669002;}", "3", "1", "2026-01-29 06:43:30", "2026-01-29 06:43:30", "4037", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21300", "woocommerce_geoip_updater", "pending", "2026-02-13 06:00:20", "2026-02-13 06:00:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770962420;s:18:\"\0*\0first_timestamp\";i:1768370400;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770962420;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21301", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-29 07:43:30", "2026-01-29 07:43:30", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769672610;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769672610;}", "3", "1", "2026-01-29 07:44:15", "2026-01-29 07:44:15", "4099", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21302", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-29 08:44:15", "2026-01-29 08:44:15", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769676255;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769676255;}", "3", "1", "2026-01-29 08:44:24", "2026-01-29 08:44:24", "4155", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21303", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-29 09:44:24", "2026-01-29 09:44:24", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769679864;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769679864;}", "3", "1", "2026-01-29 09:45:12", "2026-01-29 09:45:12", "4217", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21304", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-29 10:45:12", "2026-01-29 10:45:12", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769683512;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769683512;}", "3", "1", "2026-01-29 10:45:20", "2026-01-29 10:45:20", "4278", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21305", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-29 11:45:20", "2026-01-29 11:45:20", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769687120;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769687120;}", "3", "1", "2026-01-29 11:45:22", "2026-01-29 11:45:22", "4333", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21306", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-29 12:45:22", "2026-01-29 12:45:22", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769690722;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769690722;}", "3", "1", "2026-01-29 12:45:25", "2026-01-29 12:45:25", "4386", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21307", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-29 13:45:25", "2026-01-29 13:45:25", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769694325;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769694325;}", "3", "1", "2026-01-29 13:50:42", "2026-01-29 13:50:42", "4397", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21308", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-29 14:50:42", "2026-01-29 14:50:42", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769698242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769698242;}", "3", "1", "2026-01-29 22:28:04", "2026-01-29 22:28:04", "4404", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21309", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-29 23:28:04", "2026-01-29 23:28:04", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769729284;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769729284;}", "3", "1", "2026-01-29 23:42:50", "2026-01-29 23:42:50", "4429", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21310", "woocommerce_refresh_order_count_cache", "complete", "2026-01-30 10:28:04", "2026-01-30 10:28:04", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769768884;s:18:\"\0*\0first_timestamp\";i:1768330749;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769768884;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "4", "1", "2026-01-30 10:28:06", "2026-01-30 10:28:06", "4634", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21311", "tec_clear_expired_key_value_cache", "complete", "2026-01-30 10:28:15", "2026-01-30 10:28:15", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769768895;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769768895;}", "5", "1", "2026-01-30 10:30:08", "2026-01-30 10:30:08", "4637", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21312", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-30 00:42:50", "2026-01-30 00:42:50", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769733770;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769733770;}", "3", "1", "2026-01-30 04:43:50", "2026-01-30 04:43:50", "4440", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21313", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-30 05:43:50", "2026-01-30 05:43:50", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769751830;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769751830;}", "3", "1", "2026-01-30 05:43:57", "2026-01-30 05:43:57", "4470", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21314", "woocommerce_scheduled_sales", "complete", "2026-01-31 05:16:33", "2026-01-31 05:16:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769836593;s:18:\"\0*\0first_timestamp\";i:1768348800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769836593;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-31 08:56:16", "2026-01-31 08:56:16", "4669", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21315", "woocommerce_cleanup_logs", "complete", "2026-01-31 05:16:33", "2026-01-31 05:16:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769836593;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769836593;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-31 08:56:16", "2026-01-31 08:56:16", "4669", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21316", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-01-31 05:16:33", "2026-01-31 05:16:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769836593;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769836593;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-31 08:56:16", "2026-01-31 08:56:16", "4669", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21317", "wc_admin_daily_wrapper", "complete", "2026-01-31 05:16:33", "2026-01-31 05:16:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769836593;s:18:\"\0*\0first_timestamp\";i:1768287549;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769836593;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-31 08:56:16", "2026-01-31 08:56:16", "4669", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21318", "woocommerce_cleanup_draft_orders", "complete", "2026-01-31 05:16:33", "2026-01-31 05:16:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769836593;s:18:\"\0*\0first_timestamp\";i:1768287550;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769836593;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-01-31 08:56:16", "2026-01-31 08:56:16", "4669", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21319", "woocommerce_cleanup_personal_data", "complete", "2026-01-31 05:16:34", "2026-01-31 05:16:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769836594;s:18:\"\0*\0first_timestamp\";i:1768287559;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769836594;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-01-31 08:56:17", "2026-01-31 08:56:17", "4669", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21320", "woocommerce_cleanup_sessions", "complete", "2026-01-31 06:00:00", "2026-01-31 06:00:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769839200;s:18:\"\0*\0first_timestamp\";i:1769839200;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769839200;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "3", "1", "2026-01-31 08:56:18", "2026-01-31 08:56:18", "4669", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21321", "generate_category_lookup_table_wrapper", "complete", "2026-01-30 05:16:44", "2026-01-30 05:16:44", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769750204;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769750204;}", "3", "1", "2026-01-30 05:18:59", "2026-01-30 05:18:59", "4446", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21322", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-01-31 05:16:34", "2026-01-31 05:16:34", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769836594;s:18:\"\0*\0first_timestamp\";i:1768287544;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769836594;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2026-01-31 08:56:18", "2026-01-31 08:56:18", "4669", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21323", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-30 06:43:57", "2026-01-30 06:43:57", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769755437;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769755437;}", "3", "1", "2026-01-30 06:44:05", "2026-01-30 06:44:05", "4530", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21324", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-30 07:44:05", "2026-01-30 07:44:05", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769759045;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769759045;}", "3", "1", "2026-01-30 07:45:44", "2026-01-30 07:45:44", "4568", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21325", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-30 08:45:44", "2026-01-30 08:45:44", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769762744;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769762744;}", "3", "1", "2026-01-30 08:47:23", "2026-01-30 08:47:23", "4582", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21326", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-30 09:47:23", "2026-01-30 09:47:23", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769766443;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769766443;}", "3", "1", "2026-01-30 09:47:27", "2026-01-30 09:47:27", "4614", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21327", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-30 10:47:27", "2026-01-30 10:47:27", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769770047;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769770047;}", "3", "1", "2026-01-30 11:06:55", "2026-01-30 11:06:55", "4642", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21328", "woocommerce_refresh_order_count_cache", "complete", "2026-01-30 22:28:06", "2026-01-30 22:28:06", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769812086;s:18:\"\0*\0first_timestamp\";i:1768330749;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769812086;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "4", "1", "2026-01-31 04:47:22", "2026-01-31 04:47:22", "4666", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21329", "tec_clear_expired_key_value_cache", "complete", "2026-01-30 22:30:09", "2026-01-30 22:30:09", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769812209;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769812209;}", "5", "1", "2026-01-31 04:47:22", "2026-01-31 04:47:22", "4666", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21330", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-30 12:06:55", "2026-01-30 12:06:55", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769774815;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769774815;}", "3", "1", "2026-01-30 12:08:32", "2026-01-30 12:08:32", "4657", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21331", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-30 13:08:32", "2026-01-30 13:08:32", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769778512;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769778512;}", "3", "1", "2026-01-31 04:47:22", "2026-01-31 04:47:22", "4666", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21332", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-31 05:47:22", "2026-01-31 05:47:22", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769838442;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769838442;}", "3", "1", "2026-01-31 08:56:17", "2026-01-31 08:56:17", "4669", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21333", "woocommerce_refresh_order_count_cache", "complete", "2026-01-31 16:47:22", "2026-01-31 16:47:22", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769878042;s:18:\"\0*\0first_timestamp\";i:1768330749;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769878042;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "4", "1", "2026-02-02 04:52:23", "2026-02-02 04:52:23", "5069", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21334", "tec_clear_expired_key_value_cache", "complete", "2026-01-31 16:47:23", "2026-01-31 16:47:23", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769878043;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769878043;}", "5", "1", "2026-02-02 04:52:23", "2026-02-02 04:52:23", "5069", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21335", "woocommerce_scheduled_sales", "complete", "2026-02-01 08:56:16", "2026-02-01 08:56:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769936176;s:18:\"\0*\0first_timestamp\";i:1768348800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769936176;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-02-02 04:52:23", "2026-02-02 04:52:23", "5069", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21336", "woocommerce_cleanup_logs", "complete", "2026-02-01 08:56:16", "2026-02-01 08:56:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769936176;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769936176;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-02-02 04:52:23", "2026-02-02 04:52:23", "5069", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21337", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-02-01 08:56:16", "2026-02-01 08:56:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769936176;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769936176;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-02-02 04:52:23", "2026-02-02 04:52:23", "5069", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21338", "wc_admin_daily_wrapper", "complete", "2026-02-01 08:56:16", "2026-02-01 08:56:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769936176;s:18:\"\0*\0first_timestamp\";i:1768287549;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769936176;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-02-02 04:52:23", "2026-02-02 04:52:23", "5069", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21339", "woocommerce_cleanup_draft_orders", "complete", "2026-02-01 08:56:16", "2026-02-01 08:56:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769936176;s:18:\"\0*\0first_timestamp\";i:1768287550;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769936176;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-02-02 04:52:23", "2026-02-02 04:52:23", "5069", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21340", "woocommerce_cleanup_personal_data", "complete", "2026-02-01 08:56:17", "2026-02-01 08:56:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769936177;s:18:\"\0*\0first_timestamp\";i:1768287559;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769936177;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-02-02 04:52:24", "2026-02-02 04:52:24", "5069", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21341", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-31 09:56:17", "2026-01-31 09:56:17", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769853377;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769853377;}", "3", "1", "2026-01-31 09:57:02", "2026-01-31 09:57:02", "4784", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21343", "woocommerce_cleanup_sessions", "complete", "2026-02-01 06:00:00", "2026-02-01 06:00:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769925600;s:18:\"\0*\0first_timestamp\";i:1769925600;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769925600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "3", "1", "2026-02-02 04:52:23", "2026-02-02 04:52:23", "5069", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21344", "generate_category_lookup_table_wrapper", "complete", "2026-01-31 08:56:28", "2026-01-31 08:56:28", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769849788;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769849788;}", "3", "1", "2026-01-31 08:57:25", "2026-01-31 08:57:25", "4673", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21345", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-02-01 08:56:18", "2026-02-01 08:56:18", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1769936178;s:18:\"\0*\0first_timestamp\";i:1768287544;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1769936178;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2026-02-02 04:53:28", "2026-02-02 04:53:28", "5070", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21354", "aioseo_email_reports_enable_reminder", "pending", "2026-02-14 09:06:20", "2026-02-14 09:06:20", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1771059980;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1771059980;}", "6", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21409", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-31 10:57:02", "2026-01-31 10:57:02", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769857022;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769857022;}", "3", "1", "2026-01-31 10:57:42", "2026-01-31 10:57:42", "4902", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21482", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-31 11:57:42", "2026-01-31 11:57:42", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769860662;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769860662;}", "3", "1", "2026-01-31 11:57:58", "2026-01-31 11:57:58", "4995", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21555", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-31 12:57:58", "2026-01-31 12:57:58", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769864278;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769864278;}", "3", "1", "2026-01-31 12:58:06", "2026-01-31 12:58:06", "5061", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21576", "woocommerce_update_marketplace_suggestions", "complete", "2026-01-31 12:37:44", "2026-01-31 12:37:44", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769863064;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769863064;}", "5", "1", "2026-01-31 12:39:28", "2026-01-31 12:39:28", "5039", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21585", "woocommerce_cancel_unpaid_orders", "complete", "2026-01-31 13:58:06", "2026-01-31 13:58:06", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1769867886;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1769867886;}", "3", "1", "2026-02-02 04:52:23", "2026-02-02 04:52:23", "5069", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21590", "woocommerce_cancel_unpaid_orders", "complete", "2026-02-02 05:52:23", "2026-02-02 05:52:23", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770011543;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770011543;}", "3", "1", "2026-02-02 05:52:38", "2026-02-02 05:52:38", "5133", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21591", "woocommerce_refresh_order_count_cache", "complete", "2026-02-02 16:52:23", "2026-02-02 16:52:23", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770051143;s:18:\"\0*\0first_timestamp\";i:1768330749;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770051143;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "4", "1", "2026-02-03 04:48:25", "2026-02-03 04:48:25", "5460", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21593", "woocommerce_scheduled_sales", "complete", "2026-02-03 04:52:23", "2026-02-03 04:52:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770094343;s:18:\"\0*\0first_timestamp\";i:1768348800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770094343;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-02-03 04:52:35", "2026-02-03 04:52:35", "5466", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21594", "woocommerce_cleanup_logs", "complete", "2026-02-03 04:52:23", "2026-02-03 04:52:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770094343;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770094343;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-02-03 04:52:35", "2026-02-03 04:52:35", "5466", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21595", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-02-03 04:52:23", "2026-02-03 04:52:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770094343;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770094343;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-02-03 04:52:35", "2026-02-03 04:52:35", "5466", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21596", "wc_admin_daily_wrapper", "complete", "2026-02-03 04:52:23", "2026-02-03 04:52:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770094343;s:18:\"\0*\0first_timestamp\";i:1768287549;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770094343;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-02-03 04:52:35", "2026-02-03 04:52:35", "5466", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21597", "woocommerce_cleanup_draft_orders", "complete", "2026-02-03 04:52:23", "2026-02-03 04:52:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770094343;s:18:\"\0*\0first_timestamp\";i:1768287550;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770094343;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-02-03 04:52:35", "2026-02-03 04:52:35", "5466", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21598", "tec_clear_expired_key_value_cache", "complete", "2026-02-02 16:52:24", "2026-02-02 16:52:24", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770051144;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770051144;}", "5", "1", "2026-02-03 04:48:25", "2026-02-03 04:48:25", "5460", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21599", "woocommerce_cleanup_personal_data", "complete", "2026-02-03 04:52:24", "2026-02-03 04:52:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770094344;s:18:\"\0*\0first_timestamp\";i:1768287559;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770094344;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-02-03 04:52:36", "2026-02-03 04:52:36", "5466", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21604", "generate_category_lookup_table_wrapper", "complete", "2026-02-02 04:53:38", "2026-02-02 04:53:38", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770008018;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770008018;}", "3", "1", "2026-02-02 04:56:37", "2026-02-02 04:56:37", "5073", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21605", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-02-03 04:53:28", "2026-02-03 04:53:28", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770094408;s:18:\"\0*\0first_timestamp\";i:1768287544;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770094408;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2026-02-03 04:54:27", "2026-02-03 04:54:27", "5469", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21624", "woocommerce_cancel_unpaid_orders", "complete", "2026-02-02 06:52:38", "2026-02-02 06:52:38", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770015158;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770015158;}", "3", "1", "2026-02-02 06:53:55", "2026-02-02 06:53:55", "5206", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21656", "woocommerce_cancel_unpaid_orders", "complete", "2026-02-02 07:53:55", "2026-02-02 07:53:55", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770018835;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770018835;}", "3", "1", "2026-02-02 07:54:13", "2026-02-02 07:54:13", "5273", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21674", "woocommerce_cancel_unpaid_orders", "complete", "2026-02-02 08:54:13", "2026-02-02 08:54:13", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770022453;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770022453;}", "3", "1", "2026-02-02 08:54:38", "2026-02-02 08:54:38", "5307", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21679", "woocommerce_cancel_unpaid_orders", "complete", "2026-02-02 09:54:38", "2026-02-02 09:54:38", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770026078;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770026078;}", "3", "1", "2026-02-02 09:56:35", "2026-02-02 09:56:35", "5331", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21683", "woocommerce_cancel_unpaid_orders", "complete", "2026-02-02 10:56:35", "2026-02-02 10:56:35", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770029795;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770029795;}", "3", "1", "2026-02-02 10:57:08", "2026-02-02 10:57:08", "5344", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21686", "woocommerce_cancel_unpaid_orders", "complete", "2026-02-02 11:57:08", "2026-02-02 11:57:08", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770033428;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770033428;}", "3", "1", "2026-02-02 11:57:54", "2026-02-02 11:57:54", "5382", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21690", "woocommerce_cancel_unpaid_orders", "complete", "2026-02-02 12:57:54", "2026-02-02 12:57:54", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770037074;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770037074;}", "3", "1", "2026-02-02 14:46:27", "2026-02-02 14:46:27", "5434", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21706", "woocommerce_cancel_unpaid_orders", "complete", "2026-02-02 15:46:27", "2026-02-02 15:46:27", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770047187;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770047187;}", "3", "1", "2026-02-02 15:47:18", "2026-02-02 15:47:18", "5443", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21711", "woocommerce_cancel_unpaid_orders", "complete", "2026-02-02 16:47:18", "2026-02-02 16:47:18", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770050838;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770050838;}", "3", "1", "2026-02-03 04:48:25", "2026-02-03 04:48:25", "5460", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21714", "woocommerce_cancel_unpaid_orders", "complete", "2026-02-03 05:48:25", "2026-02-03 05:48:25", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770097705;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770097705;}", "3", "1", "2026-02-03 05:48:26", "2026-02-03 05:48:26", "5529", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21715", "woocommerce_refresh_order_count_cache", "complete", "2026-02-03 16:48:25", "2026-02-03 16:48:25", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770137305;s:18:\"\0*\0first_timestamp\";i:1768330749;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770137305;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "4", "1", "2026-02-03 17:36:11", "2026-02-03 17:36:11", "5755", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21716", "aioseo_report_summary", "pending", "2026-02-10 04:48:25", "2026-02-10 04:48:25", "10", "{\"frequency\":\"weekly\"}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770698905;s:18:\"\0*\0first_timestamp\";i:1770064740;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770698905;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "6", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21717", "tec_clear_expired_key_value_cache", "complete", "2026-02-03 16:48:29", "2026-02-03 16:48:29", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770137309;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770137309;}", "5", "1", "2026-02-03 17:36:11", "2026-02-03 17:36:11", "5755", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21719", "woocommerce_scheduled_sales", "complete", "2026-02-04 04:52:35", "2026-02-04 04:52:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770180755;s:18:\"\0*\0first_timestamp\";i:1768348800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770180755;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-02-04 05:11:28", "2026-02-04 05:11:28", "5759", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21720", "woocommerce_cleanup_logs", "complete", "2026-02-04 04:52:35", "2026-02-04 04:52:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770180755;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770180755;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-02-04 05:11:28", "2026-02-04 05:11:28", "5759", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21721", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-02-04 04:52:35", "2026-02-04 04:52:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770180755;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770180755;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-02-04 05:11:28", "2026-02-04 05:11:28", "5759", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21722", "wc_admin_daily_wrapper", "complete", "2026-02-04 04:52:35", "2026-02-04 04:52:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770180755;s:18:\"\0*\0first_timestamp\";i:1768287549;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770180755;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-02-04 05:11:29", "2026-02-04 05:11:29", "5759", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21723", "woocommerce_cleanup_draft_orders", "complete", "2026-02-04 04:52:35", "2026-02-04 04:52:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770180755;s:18:\"\0*\0first_timestamp\";i:1768287550;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770180755;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-02-04 05:11:29", "2026-02-04 05:11:29", "5759", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21724", "woocommerce_cleanup_personal_data", "complete", "2026-02-04 04:52:36", "2026-02-04 04:52:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770180756;s:18:\"\0*\0first_timestamp\";i:1768287559;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770180756;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-02-04 05:11:30", "2026-02-04 05:11:30", "5759", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21729", "generate_category_lookup_table_wrapper", "complete", "2026-02-03 04:54:37", "2026-02-03 04:54:37", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770094477;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770094477;}", "3", "1", "2026-02-03 04:54:55", "2026-02-03 04:54:55", "5471", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21730", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-02-04 04:54:27", "2026-02-04 04:54:27", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770180867;s:18:\"\0*\0first_timestamp\";i:1768287544;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770180867;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2026-02-04 05:12:29", "2026-02-04 05:12:29", "5760", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21757", "woocommerce_cancel_unpaid_orders", "complete", "2026-02-03 06:48:26", "2026-02-03 06:48:26", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770101306;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770101306;}", "3", "1", "2026-02-03 06:48:32", "2026-02-03 06:48:32", "5606", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21794", "woocommerce_cancel_unpaid_orders", "complete", "2026-02-03 07:48:32", "2026-02-03 07:48:32", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770104912;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770104912;}", "3", "1", "2026-02-03 07:49:54", "2026-02-03 07:49:54", "5639", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21799", "woocommerce_cancel_unpaid_orders", "complete", "2026-02-03 08:49:54", "2026-02-03 08:49:54", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770108594;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770108594;}", "3", "1", "2026-02-03 08:50:49", "2026-02-03 08:50:49", "5665", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21803", "woocommerce_cancel_unpaid_orders", "complete", "2026-02-03 09:50:49", "2026-02-03 09:50:49", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770112249;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770112249;}", "3", "1", "2026-02-03 12:00:08", "2026-02-03 12:00:08", "5678", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21806", "woocommerce_cancel_unpaid_orders", "complete", "2026-02-03 13:00:08", "2026-02-03 13:00:08", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770123608;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770123608;}", "3", "1", "2026-02-03 13:02:04", "2026-02-03 13:02:04", "5746", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21833", "woocommerce_cancel_unpaid_orders", "complete", "2026-02-03 14:02:04", "2026-02-03 14:02:04", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770127324;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770127324;}", "3", "1", "2026-02-03 17:36:11", "2026-02-03 17:36:11", "5755", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21837", "woocommerce_cancel_unpaid_orders", "complete", "2026-02-03 18:36:11", "2026-02-03 18:36:11", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770143771;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770143771;}", "3", "1", "2026-02-04 04:52:08", "2026-02-04 04:52:08", "5757", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21838", "woocommerce_refresh_order_count_cache", "complete", "2026-02-04 05:36:11", "2026-02-04 05:36:11", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770183371;s:18:\"\0*\0first_timestamp\";i:1768330749;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770183371;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "4", "1", "2026-02-04 05:36:50", "2026-02-04 05:36:50", "5780", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21839", "tec_clear_expired_key_value_cache", "complete", "2026-02-04 05:36:14", "2026-02-04 05:36:14", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770183374;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770183374;}", "5", "1", "2026-02-04 05:36:50", "2026-02-04 05:36:50", "5780", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21841", "woocommerce_cancel_unpaid_orders", "complete", "2026-02-04 05:52:08", "2026-02-04 05:52:08", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770184328;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770184328;}", "3", "1", "2026-02-04 05:56:59", "2026-02-04 05:56:59", "5784", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21842", "aioseo_report_summary", "pending", "2026-03-06 04:52:08", "2026-03-06 04:52:08", "10", "{\"frequency\":\"monthly\"}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1772772728;s:18:\"\0*\0first_timestamp\";i:1770151140;s:13:\"\0*\0recurrence\";i:2592000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1772772728;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:2592000;}", "6", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21843", "woocommerce_scheduled_sales", "complete", "2026-02-05 05:11:28", "2026-02-05 05:11:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770268288;s:18:\"\0*\0first_timestamp\";i:1768348800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770268288;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-02-05 05:12:25", "2026-02-05 05:12:25", "5993", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21844", "woocommerce_cleanup_logs", "complete", "2026-02-05 05:11:28", "2026-02-05 05:11:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770268288;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770268288;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-02-05 05:12:25", "2026-02-05 05:12:25", "5993", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21845", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2026-02-05 05:11:28", "2026-02-05 05:11:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770268288;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770268288;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-02-05 05:12:25", "2026-02-05 05:12:25", "5993", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21846", "wc_admin_daily_wrapper", "complete", "2026-02-05 05:11:29", "2026-02-05 05:11:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770268289;s:18:\"\0*\0first_timestamp\";i:1768287549;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770268289;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-02-05 05:12:26", "2026-02-05 05:12:26", "5993", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21847", "woocommerce_cleanup_draft_orders", "complete", "2026-02-05 05:11:29", "2026-02-05 05:11:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770268289;s:18:\"\0*\0first_timestamp\";i:1768287550;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770268289;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2026-02-05 05:12:26", "2026-02-05 05:12:26", "5993", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21848", "woocommerce_cleanup_personal_data", "complete", "2026-02-05 05:11:30", "2026-02-05 05:11:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770268290;s:18:\"\0*\0first_timestamp\";i:1768287559;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770268290;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2026-02-05 05:12:27", "2026-02-05 05:12:27", "5993", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21849", "aioseo_ai_update_credits", "complete", "2026-02-05 05:11:30", "2026-02-05 05:11:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770268290;s:18:\"\0*\0first_timestamp\";i:1769936779;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770268290;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2026-02-05 05:12:27", "2026-02-05 05:12:27", "5993", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21850", "aioseo_cache_prune", "complete", "2026-02-05 05:11:30", "2026-02-05 05:11:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770268290;s:18:\"\0*\0first_timestamp\";i:1769850379;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770268290;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2026-02-05 05:12:27", "2026-02-05 05:12:27", "5993", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21852", "aioseo_generate_llms_txt", "complete", "2026-02-05 05:12:27", "2026-02-05 05:12:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770268347;s:18:\"\0*\0first_timestamp\";i:1769850389;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770268347;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2026-02-05 05:12:39", "2026-02-05 05:12:39", "5994", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21855", "generate_category_lookup_table_wrapper", "complete", "2026-02-04 05:12:39", "2026-02-04 05:12:39", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770181959;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770181959;}", "3", "1", "2026-02-04 05:13:25", "2026-02-04 05:13:25", "5762", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21856", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2026-02-05 05:12:29", "2026-02-05 05:12:29", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770268349;s:18:\"\0*\0first_timestamp\";i:1768287544;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770268349;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "1", "2026-02-05 05:12:39", "2026-02-05 05:12:39", "5995", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21859", "woocommerce_refresh_order_count_cache", "complete", "2026-02-04 17:36:50", "2026-02-04 17:36:50", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770226610;s:18:\"\0*\0first_timestamp\";i:1768330749;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770226610;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "4", "1", "2026-02-05 05:12:25", "2026-02-05 05:12:25", "5993", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21860", "tec_clear_expired_key_value_cache", "complete", "2026-02-04 17:36:50", "2026-02-04 17:36:50", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770226610;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770226610;}", "5", "1", "2026-02-05 05:12:25", "2026-02-05 05:12:25", "5993", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21862", "woocommerce_cancel_unpaid_orders", "complete", "2026-02-04 06:56:59", "2026-02-04 06:56:59", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770188219;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770188219;}", "3", "1", "2026-02-04 06:57:59", "2026-02-04 06:57:59", "5845", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21882", "woocommerce_cancel_unpaid_orders", "complete", "2026-02-04 07:57:58", "2026-02-04 07:57:58", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770191878;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770191878;}", "3", "1", "2026-02-04 08:00:44", "2026-02-04 08:00:44", "5920", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21907", "woocommerce_cancel_unpaid_orders", "complete", "2026-02-04 09:00:44", "2026-02-04 09:00:44", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770195644;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770195644;}", "3", "1", "2026-02-04 09:02:14", "2026-02-04 09:02:14", "5969", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21916", "woocommerce_cancel_unpaid_orders", "complete", "2026-02-04 10:02:14", "2026-02-04 10:02:14", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770199334;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770199334;}", "3", "1", "2026-02-04 10:20:00", "2026-02-04 10:20:00", "5976", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21918", "woocommerce_cancel_unpaid_orders", "complete", "2026-02-04 11:20:00", "2026-02-04 11:20:00", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770204000;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770204000;}", "3", "1", "2026-02-04 12:35:18", "2026-02-04 12:35:18", "5980", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21921", "woocommerce_cancel_unpaid_orders", "complete", "2026-02-04 13:35:18", "2026-02-04 13:35:18", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770212118;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770212118;}", "3", "1", "2026-02-04 14:58:18", "2026-02-04 14:58:18", "5984", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21924", "woocommerce_cancel_unpaid_orders", "complete", "2026-02-04 15:58:18", "2026-02-04 15:58:18", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770220698;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770220698;}", "3", "1", "2026-02-05 05:12:25", "2026-02-05 05:12:25", "5993", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21925", "aioseo_image_sitemap_scan", "complete", "2026-02-04 16:00:48", "2026-02-04 16:00:48", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770220848;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770220848;}", "6", "1", "2026-02-05 05:12:25", "2026-02-05 05:12:25", "5993", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21926", "woocommerce_cancel_unpaid_orders", "complete", "2026-02-05 06:12:25", "2026-02-05 06:12:25", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770271945;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770271945;}", "3", "1", "2026-02-05 06:13:05", "2026-02-05 06:13:05", "6054", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21927", "aioseo_image_sitemap_scan", "complete", "2026-02-05 05:27:25", "2026-02-05 05:27:25", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770269245;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770269245;}", "6", "1", "2026-02-05 05:27:46", "2026-02-05 05:27:46", "6009", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21928", "woocommerce_refresh_order_count_cache", "pending", "2026-02-05 17:12:25", "2026-02-05 17:12:25", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770311545;s:18:\"\0*\0first_timestamp\";i:1768330749;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770311545;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "4", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21929", "woocommerce_scheduled_sales", "pending", "2026-02-06 05:12:25", "2026-02-06 05:12:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770354745;s:18:\"\0*\0first_timestamp\";i:1768348800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770354745;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21930", "woocommerce_cleanup_logs", "pending", "2026-02-06 05:12:25", "2026-02-06 05:12:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770354745;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770354745;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21931", "woocommerce_cleanup_rate_limits_wrapper", "pending", "2026-02-06 05:12:25", "2026-02-06 05:12:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770354745;s:18:\"\0*\0first_timestamp\";i:1768359600;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770354745;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21932", "wc_admin_daily_wrapper", "pending", "2026-02-06 05:12:26", "2026-02-06 05:12:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770354746;s:18:\"\0*\0first_timestamp\";i:1768287549;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770354746;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21933", "woocommerce_cleanup_draft_orders", "pending", "2026-02-06 05:12:26", "2026-02-06 05:12:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770354746;s:18:\"\0*\0first_timestamp\";i:1768287550;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770354746;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21934", "woocommerce_cleanup_personal_data", "pending", "2026-02-06 05:12:27", "2026-02-06 05:12:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770354747;s:18:\"\0*\0first_timestamp\";i:1768287559;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770354747;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21935", "aioseo_admin_notifications_update", "complete", "2026-02-05 05:12:27", "2026-02-05 05:12:27", "10", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2026-02-05 05:12:39", "2026-02-05 05:12:39", "5994", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21936", "aioseo_ai_update_credits", "pending", "2026-02-06 05:12:27", "2026-02-06 05:12:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770354747;s:18:\"\0*\0first_timestamp\";i:1769936779;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770354747;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21937", "aioseo_cache_prune", "pending", "2026-02-06 05:12:27", "2026-02-06 05:12:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770354747;s:18:\"\0*\0first_timestamp\";i:1769850379;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770354747;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21938", "tec_clear_expired_key_value_cache", "pending", "2026-02-05 17:12:28", "2026-02-05 17:12:28", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770311548;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770311548;}", "5", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21939", "aioseo_generate_llms_txt", "pending", "2026-02-06 05:12:39", "2026-02-06 05:12:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770354759;s:18:\"\0*\0first_timestamp\";i:1769850389;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770354759;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21940", "woocommerce_cleanup_sessions", "pending", "2026-02-06 06:00:00", "2026-02-06 06:00:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770357600;s:18:\"\0*\0first_timestamp\";i:1770357600;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770357600;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21941", "generate_category_lookup_table_wrapper", "complete", "2026-02-05 05:12:49", "2026-02-05 05:12:49", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770268369;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770268369;}", "3", "1", "2026-02-05 05:15:29", "2026-02-05 05:15:29", "5997", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21942", "action_scheduler_run_recurring_actions_schedule_hook", "pending", "2026-02-06 05:12:39", "2026-02-06 05:12:39", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1770354759;s:18:\"\0*\0first_timestamp\";i:1768287544;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1770354759;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "1", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21943", "aioseo_image_sitemap_scan", "complete", "2026-02-05 05:42:46", "2026-02-05 05:42:46", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770270166;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770270166;}", "6", "1", "2026-02-05 05:42:55", "2026-02-05 05:42:55", "6025", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21944", "aioseo_image_sitemap_scan", "complete", "2026-02-05 05:57:55", "2026-02-05 05:57:55", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770271075;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770271075;}", "6", "1", "2026-02-05 05:59:00", "2026-02-05 05:59:00", "6040", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21945", "aioseo_image_sitemap_scan", "pending", "2026-02-05 06:14:00", "2026-02-05 06:14:00", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770272040;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770272040;}", "6", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("21946", "woocommerce_cancel_unpaid_orders", "pending", "2026-02-05 07:13:05", "2026-02-05 07:13:05", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1770275585;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1770275585;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);

/* INSERT TABLE DATA: wp_actionscheduler_claims */
INSERT INTO `wp_actionscheduler_claims` VALUES("4986", "2026-01-31 11:48:27");
INSERT INTO `wp_actionscheduler_claims` VALUES("5019", "2026-01-31 12:17:37");

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "ActionScheduler");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "woocommerce");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "count");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "");
INSERT INTO `wp_actionscheduler_groups` VALUES("6", "aioseo");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("1", "21032", "action created", "2026-01-13 06:59:04", "2026-01-13 06:59:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2", "21033", "action created", "2026-01-13 06:59:09", "2026-01-13 06:59:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("3", "21032", "action started via WP Cron", "2026-01-13 06:59:09", "2026-01-13 06:59:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4", "21034", "action created", "2026-01-13 06:59:09", "2026-01-13 06:59:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("5", "21035", "action created", "2026-01-13 06:59:09", "2026-01-13 06:59:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("6", "21036", "action created", "2026-01-13 06:59:09", "2026-01-13 06:59:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("7", "21037", "action created", "2026-01-13 06:59:09", "2026-01-13 06:59:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("8", "21038", "action created", "2026-01-13 06:59:09", "2026-01-13 06:59:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("9", "21039", "action created", "2026-01-13 06:59:09", "2026-01-13 06:59:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("10", "21040", "action created", "2026-01-13 06:59:09", "2026-01-13 06:59:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11", "21041", "action created", "2026-01-13 06:59:09", "2026-01-13 06:59:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("12", "21042", "action created", "2026-01-13 06:59:09", "2026-01-13 06:59:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("13", "21043", "action created", "2026-01-13 06:59:09", "2026-01-13 06:59:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("14", "21032", "action complete via WP Cron", "2026-01-13 06:59:09", "2026-01-13 06:59:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("15", "21044", "action created", "2026-01-13 06:59:09", "2026-01-13 06:59:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("16", "21041", "action started via WP Cron", "2026-01-13 06:59:09", "2026-01-13 06:59:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("17", "21045", "action created", "2026-01-13 06:59:10", "2026-01-13 06:59:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("18", "21041", "action complete via WP Cron", "2026-01-13 06:59:11", "2026-01-13 06:59:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("19", "21046", "action created", "2026-01-13 06:59:11", "2026-01-13 06:59:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("20", "21045", "action started via WP Cron", "2026-01-13 06:59:11", "2026-01-13 06:59:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("21", "21045", "action complete via WP Cron", "2026-01-13 06:59:11", "2026-01-13 06:59:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("22", "21047", "action created", "2026-01-13 06:59:11", "2026-01-13 06:59:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("23", "21048", "action created", "2026-01-13 06:59:16", "2026-01-13 06:59:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("24", "21049", "action created", "2026-01-13 06:59:57", "2026-01-13 06:59:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("25", "21048", "action started via WP Cron", "2026-01-13 07:00:10", "2026-01-13 07:00:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("26", "21048", "action complete via WP Cron", "2026-01-13 07:00:10", "2026-01-13 07:00:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("27", "21036", "action started via WP Cron", "2026-01-13 07:00:10", "2026-01-13 07:00:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("28", "21036", "action complete via WP Cron", "2026-01-13 07:00:11", "2026-01-13 07:00:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("29", "21050", "action created", "2026-01-13 07:00:11", "2026-01-13 07:00:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("30", "21042", "action started via WP Cron", "2026-01-13 07:00:12", "2026-01-13 07:00:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("31", "21042", "action complete via WP Cron", "2026-01-13 07:00:12", "2026-01-13 07:00:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("32", "21033", "action started via WP Cron", "2026-01-13 07:00:12", "2026-01-13 07:00:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("33", "21033", "action complete via WP Cron", "2026-01-13 07:00:12", "2026-01-13 07:00:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("34", "21051", "action created", "2026-01-13 07:00:12", "2026-01-13 07:00:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("35", "21051", "action started via Async Request", "2026-01-13 07:01:17", "2026-01-13 07:01:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("36", "21051", "action failed via Async Request: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2026-01-13 07:01:17", "2026-01-13 07:01:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("37", "21052", "action created", "2026-01-13 07:03:18", "2026-01-13 07:03:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("38", "21052", "action started via Async Request", "2026-01-13 07:03:26", "2026-01-13 07:03:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("39", "21052", "action failed via Async Request: Scheduled action for woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications will not be executed as no callbacks are registered.", "2026-01-13 07:03:26", "2026-01-13 07:03:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("40", "21035", "action started via WP Cron", "2026-01-13 07:59:13", "2026-01-13 07:59:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("41", "21053", "action created", "2026-01-13 07:59:13", "2026-01-13 07:59:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("42", "21035", "action complete via WP Cron", "2026-01-13 07:59:13", "2026-01-13 07:59:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("43", "21053", "action started via WP Cron", "2026-01-13 08:59:27", "2026-01-13 08:59:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("44", "21054", "action created", "2026-01-13 08:59:27", "2026-01-13 08:59:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("45", "21053", "action complete via WP Cron", "2026-01-13 08:59:27", "2026-01-13 08:59:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("46", "21054", "action started via Async Request", "2026-01-13 09:59:40", "2026-01-13 09:59:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("47", "21055", "action created", "2026-01-13 09:59:40", "2026-01-13 09:59:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("48", "21054", "action complete via Async Request", "2026-01-13 09:59:40", "2026-01-13 09:59:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("49", "21055", "action started via Async Request", "2026-01-13 11:00:25", "2026-01-13 11:00:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("50", "21056", "action created", "2026-01-13 11:00:25", "2026-01-13 11:00:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("51", "21055", "action complete via Async Request", "2026-01-13 11:00:25", "2026-01-13 11:00:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("52", "21056", "action started via Async Request", "2026-01-13 12:01:13", "2026-01-13 12:01:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("53", "21057", "action created", "2026-01-13 12:01:13", "2026-01-13 12:01:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("54", "21056", "action complete via Async Request", "2026-01-13 12:01:13", "2026-01-13 12:01:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("55", "21057", "action started via WP Cron", "2026-01-14 02:51:30", "2026-01-14 02:51:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("56", "21058", "action created", "2026-01-14 02:51:30", "2026-01-14 02:51:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("57", "21057", "action complete via WP Cron", "2026-01-14 02:51:30", "2026-01-14 02:51:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("58", "21043", "action started via WP Cron", "2026-01-14 02:51:30", "2026-01-14 02:51:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("59", "21043", "action complete via WP Cron", "2026-01-14 02:51:30", "2026-01-14 02:51:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("60", "21059", "action created", "2026-01-14 02:51:30", "2026-01-14 02:51:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("61", "21049", "action started via WP Cron", "2026-01-14 02:51:30", "2026-01-14 02:51:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("62", "21049", "action complete via WP Cron", "2026-01-14 02:51:30", "2026-01-14 02:51:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("63", "21034", "action started via WP Cron", "2026-01-14 02:51:30", "2026-01-14 02:51:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("64", "21034", "action complete via WP Cron", "2026-01-14 02:51:30", "2026-01-14 02:51:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("65", "21060", "action created", "2026-01-14 02:51:30", "2026-01-14 02:51:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("66", "21061", "action created", "2026-01-14 05:27:08", "2026-01-14 05:27:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("67", "21037", "action started via WP Cron", "2026-01-14 05:27:13", "2026-01-14 05:27:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("68", "21037", "action complete via WP Cron", "2026-01-14 05:27:13", "2026-01-14 05:27:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("69", "21062", "action created", "2026-01-14 05:27:13", "2026-01-14 05:27:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("70", "21040", "action started via WP Cron", "2026-01-14 05:27:13", "2026-01-14 05:27:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("71", "21040", "action complete via WP Cron", "2026-01-14 05:27:13", "2026-01-14 05:27:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("72", "21063", "action created", "2026-01-14 05:27:13", "2026-01-14 05:27:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("73", "21058", "action started via WP Cron", "2026-01-14 05:27:13", "2026-01-14 05:27:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("74", "21064", "action created", "2026-01-14 05:27:13", "2026-01-14 05:27:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("75", "21058", "action complete via WP Cron", "2026-01-14 05:27:13", "2026-01-14 05:27:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("76", "21038", "action started via WP Cron", "2026-01-14 06:00:08", "2026-01-14 06:00:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("77", "21038", "action complete via WP Cron", "2026-01-14 06:00:08", "2026-01-14 06:00:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("79", "21039", "action started via WP Cron", "2026-01-14 06:00:08", "2026-01-14 06:00:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("80", "21039", "action complete via WP Cron", "2026-01-14 06:00:08", "2026-01-14 06:00:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("81", "21066", "action created", "2026-01-14 06:00:08", "2026-01-14 06:00:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("82", "21064", "action started via Async Request", "2026-01-14 06:29:04", "2026-01-14 06:29:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("83", "21067", "action created", "2026-01-14 06:29:05", "2026-01-14 06:29:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("84", "21064", "action complete via Async Request", "2026-01-14 06:29:05", "2026-01-14 06:29:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("85", "21046", "action started via Async Request", "2026-01-14 06:59:19", "2026-01-14 06:59:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("86", "21046", "action complete via Async Request", "2026-01-14 06:59:21", "2026-01-14 06:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("87", "21068", "action created", "2026-01-14 06:59:21", "2026-01-14 06:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("88", "21047", "action started via Async Request", "2026-01-14 06:59:21", "2026-01-14 06:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("89", "21047", "action complete via Async Request", "2026-01-14 06:59:21", "2026-01-14 06:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("90", "21069", "action created", "2026-01-14 06:59:21", "2026-01-14 06:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("91", "21044", "action started via Async Request", "2026-01-14 06:59:21", "2026-01-14 06:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("93", "21070", "action created", "2026-01-14 06:59:21", "2026-01-14 06:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("94", "21071", "action created", "2026-01-14 06:59:21", "2026-01-14 06:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("95", "21044", "action complete via Async Request", "2026-01-14 06:59:21", "2026-01-14 06:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("96", "21072", "action created", "2026-01-14 06:59:21", "2026-01-14 06:59:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("97", "21071", "action started via Async Request", "2026-01-14 07:01:19", "2026-01-14 07:01:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("98", "21071", "action complete via Async Request", "2026-01-14 07:01:19", "2026-01-14 07:01:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("99", "21050", "action started via Async Request", "2026-01-14 07:01:19", "2026-01-14 07:01:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("100", "21050", "action complete via Async Request", "2026-01-14 07:01:20", "2026-01-14 07:01:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("101", "21073", "action created", "2026-01-14 07:01:20", "2026-01-14 07:01:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("102", "21067", "action started via WP Cron", "2026-01-14 09:04:51", "2026-01-14 09:04:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("103", "21074", "action created", "2026-01-14 09:04:51", "2026-01-14 09:04:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("104", "21067", "action complete via WP Cron", "2026-01-14 09:04:51", "2026-01-14 09:04:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("105", "21074", "action started via WP Cron", "2026-01-14 10:05:29", "2026-01-14 10:05:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("106", "21075", "action created", "2026-01-14 10:05:29", "2026-01-14 10:05:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("107", "21074", "action complete via WP Cron", "2026-01-14 10:05:29", "2026-01-14 10:05:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("108", "21075", "action started via WP Cron", "2026-01-14 11:05:40", "2026-01-14 11:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("109", "21076", "action created", "2026-01-14 11:05:40", "2026-01-14 11:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("110", "21075", "action complete via WP Cron", "2026-01-14 11:05:40", "2026-01-14 11:05:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("111", "21076", "action started via Async Request", "2026-01-14 12:05:52", "2026-01-14 12:05:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("112", "21077", "action created", "2026-01-14 12:05:53", "2026-01-14 12:05:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("113", "21076", "action complete via Async Request", "2026-01-14 12:05:53", "2026-01-14 12:05:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("114", "21077", "action started via WP Cron", "2026-01-15 06:24:39", "2026-01-15 06:24:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("115", "21078", "action created", "2026-01-15 06:24:39", "2026-01-15 06:24:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("116", "21077", "action complete via WP Cron", "2026-01-15 06:24:39", "2026-01-15 06:24:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("117", "21059", "action started via WP Cron", "2026-01-15 06:24:39", "2026-01-15 06:24:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("118", "21059", "action complete via WP Cron", "2026-01-15 06:24:39", "2026-01-15 06:24:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("119", "21079", "action created", "2026-01-15 06:24:39", "2026-01-15 06:24:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("120", "21061", "action started via WP Cron", "2026-01-15 06:24:39", "2026-01-15 06:24:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("121", "21061", "action complete via WP Cron", "2026-01-15 06:24:39", "2026-01-15 06:24:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("122", "21060", "action started via WP Cron", "2026-01-15 06:24:39", "2026-01-15 06:24:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("123", "21060", "action complete via WP Cron", "2026-01-15 06:24:39", "2026-01-15 06:24:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("124", "21080", "action created", "2026-01-15 06:24:39", "2026-01-15 06:24:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("125", "21062", "action started via WP Cron", "2026-01-15 06:24:39", "2026-01-15 06:24:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("126", "21062", "action complete via WP Cron", "2026-01-15 06:24:39", "2026-01-15 06:24:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("127", "21081", "action created", "2026-01-15 06:24:39", "2026-01-15 06:24:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("128", "21063", "action started via WP Cron", "2026-01-15 06:24:39", "2026-01-15 06:24:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("129", "21063", "action complete via WP Cron", "2026-01-15 06:24:39", "2026-01-15 06:24:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("130", "21082", "action created", "2026-01-15 06:24:39", "2026-01-15 06:24:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("131", "21070", "action started via WP Cron", "2026-01-15 06:24:39", "2026-01-15 06:24:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("132", "21070", "action complete via WP Cron", "2026-01-15 06:24:39", "2026-01-15 06:24:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("134", "21084", "action created", "2026-01-15 06:24:41", "2026-01-15 06:24:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("135", "21068", "action started via Async Request", "2026-01-15 07:39:15", "2026-01-15 07:39:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("136", "21068", "action complete via Async Request", "2026-01-15 07:39:17", "2026-01-15 07:39:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("137", "21085", "action created", "2026-01-15 07:39:17", "2026-01-15 07:39:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("138", "21069", "action started via Async Request", "2026-01-15 07:39:17", "2026-01-15 07:39:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("139", "21069", "action complete via Async Request", "2026-01-15 07:39:17", "2026-01-15 07:39:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("140", "21086", "action created", "2026-01-15 07:39:17", "2026-01-15 07:39:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("141", "21073", "action started via Async Request", "2026-01-15 07:39:17", "2026-01-15 07:39:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("142", "21073", "action complete via Async Request", "2026-01-15 07:39:18", "2026-01-15 07:39:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("143", "21087", "action created", "2026-01-15 07:39:18", "2026-01-15 07:39:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("144", "21078", "action started via Async Request", "2026-01-15 07:39:18", "2026-01-15 07:39:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("145", "21088", "action created", "2026-01-15 07:39:18", "2026-01-15 07:39:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("146", "21078", "action complete via Async Request", "2026-01-15 07:39:18", "2026-01-15 07:39:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("147", "21072", "action started via Async Request", "2026-01-15 07:39:18", "2026-01-15 07:39:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("149", "21089", "action created", "2026-01-15 07:39:18", "2026-01-15 07:39:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("150", "21090", "action created", "2026-01-15 07:39:18", "2026-01-15 07:39:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("151", "21072", "action complete via Async Request", "2026-01-15 07:39:18", "2026-01-15 07:39:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("152", "21091", "action created", "2026-01-15 07:39:18", "2026-01-15 07:39:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("153", "21090", "action started via WP Cron", "2026-01-15 07:40:08", "2026-01-15 07:40:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("154", "21090", "action complete via WP Cron", "2026-01-15 07:40:08", "2026-01-15 07:40:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("155", "21088", "action started via Async Request", "2026-01-15 08:40:10", "2026-01-15 08:40:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("156", "21092", "action created", "2026-01-15 08:40:10", "2026-01-15 08:40:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("157", "21088", "action complete via Async Request", "2026-01-15 08:40:10", "2026-01-15 08:40:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("158", "21092", "action started via WP Cron", "2026-01-15 09:40:12", "2026-01-15 09:40:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("159", "21093", "action created", "2026-01-15 09:40:12", "2026-01-15 09:40:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("160", "21092", "action complete via WP Cron", "2026-01-15 09:40:12", "2026-01-15 09:40:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("161", "21093", "action started via Async Request", "2026-01-15 10:41:06", "2026-01-15 10:41:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("162", "21094", "action created", "2026-01-15 10:41:06", "2026-01-15 10:41:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("163", "21093", "action complete via Async Request", "2026-01-15 10:41:06", "2026-01-15 10:41:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("164", "21094", "action started via Async Request", "2026-01-15 11:41:19", "2026-01-15 11:41:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("165", "21095", "action created", "2026-01-15 11:41:19", "2026-01-15 11:41:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("166", "21094", "action complete via Async Request", "2026-01-15 11:41:19", "2026-01-15 11:41:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("167", "21095", "action started via Async Request", "2026-01-15 12:41:40", "2026-01-15 12:41:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("168", "21096", "action created", "2026-01-15 12:41:40", "2026-01-15 12:41:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("169", "21095", "action complete via Async Request", "2026-01-15 12:41:40", "2026-01-15 12:41:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("170", "21096", "action started via WP Cron", "2026-01-16 04:44:44", "2026-01-16 04:44:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("171", "21097", "action created", "2026-01-16 04:44:44", "2026-01-16 04:44:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("172", "21096", "action complete via WP Cron", "2026-01-16 04:44:44", "2026-01-16 04:44:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("173", "21079", "action started via WP Cron", "2026-01-16 04:44:44", "2026-01-16 04:44:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("174", "21079", "action complete via WP Cron", "2026-01-16 04:44:44", "2026-01-16 04:44:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("175", "21098", "action created", "2026-01-16 04:44:44", "2026-01-16 04:44:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("176", "21084", "action started via WP Cron", "2026-01-16 04:44:44", "2026-01-16 04:44:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("177", "21084", "action complete via WP Cron", "2026-01-16 04:44:44", "2026-01-16 04:44:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("178", "21099", "action created", "2026-01-16 04:44:47", "2026-01-16 04:44:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("179", "21097", "action started via Async Request", "2026-01-16 06:06:27", "2026-01-16 06:06:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("180", "21100", "action created", "2026-01-16 06:06:27", "2026-01-16 06:06:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("181", "21097", "action complete via Async Request", "2026-01-16 06:06:27", "2026-01-16 06:06:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("182", "21089", "action started via Async Request", "2026-01-16 06:06:27", "2026-01-16 06:06:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("183", "21089", "action complete via Async Request", "2026-01-16 06:06:27", "2026-01-16 06:06:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("185", "21080", "action started via WP Cron", "2026-01-16 06:25:05", "2026-01-16 06:25:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("186", "21080", "action complete via WP Cron", "2026-01-16 06:25:05", "2026-01-16 06:25:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("187", "21102", "action created", "2026-01-16 06:25:05", "2026-01-16 06:25:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("188", "21081", "action started via WP Cron", "2026-01-16 06:25:05", "2026-01-16 06:25:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("189", "21081", "action complete via WP Cron", "2026-01-16 06:25:05", "2026-01-16 06:25:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("190", "21103", "action created", "2026-01-16 06:25:06", "2026-01-16 06:25:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("191", "21082", "action started via WP Cron", "2026-01-16 06:25:06", "2026-01-16 06:25:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("192", "21082", "action complete via WP Cron", "2026-01-16 06:25:06", "2026-01-16 06:25:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("193", "21104", "action created", "2026-01-16 06:25:06", "2026-01-16 06:25:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("194", "21100", "action started via WP Cron", "2026-01-16 07:07:09", "2026-01-16 07:07:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("195", "21105", "action created", "2026-01-16 07:07:09", "2026-01-16 07:07:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("196", "21100", "action complete via WP Cron", "2026-01-16 07:07:09", "2026-01-16 07:07:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("197", "21085", "action started via Async Request", "2026-01-16 07:39:49", "2026-01-16 07:39:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("198", "21085", "action complete via Async Request", "2026-01-16 07:39:51", "2026-01-16 07:39:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("199", "21106", "action created", "2026-01-16 07:39:51", "2026-01-16 07:39:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("200", "21086", "action started via Async Request", "2026-01-16 07:39:51", "2026-01-16 07:39:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("201", "21086", "action complete via Async Request", "2026-01-16 07:39:51", "2026-01-16 07:39:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("202", "21107", "action created", "2026-01-16 07:39:51", "2026-01-16 07:39:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("203", "21087", "action started via Async Request", "2026-01-16 07:39:51", "2026-01-16 07:39:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("204", "21087", "action complete via Async Request", "2026-01-16 07:39:51", "2026-01-16 07:39:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("205", "21108", "action created", "2026-01-16 07:39:51", "2026-01-16 07:39:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("206", "21091", "action started via Async Request", "2026-01-16 07:39:51", "2026-01-16 07:39:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("208", "21109", "action created", "2026-01-16 07:39:51", "2026-01-16 07:39:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("209", "21110", "action created", "2026-01-16 07:39:51", "2026-01-16 07:39:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("210", "21091", "action complete via Async Request", "2026-01-16 07:39:51", "2026-01-16 07:39:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("211", "21111", "action created", "2026-01-16 07:39:51", "2026-01-16 07:39:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("212", "21110", "action started via WP Cron", "2026-01-16 07:40:06", "2026-01-16 07:40:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("213", "21110", "action complete via WP Cron", "2026-01-16 07:40:06", "2026-01-16 07:40:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("214", "21105", "action started via Async Request", "2026-01-16 08:07:19", "2026-01-16 08:07:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("215", "21112", "action created", "2026-01-16 08:07:19", "2026-01-16 08:07:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("216", "21105", "action complete via Async Request", "2026-01-16 08:07:19", "2026-01-16 08:07:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("217", "21112", "action started via Async Request", "2026-01-16 09:08:15", "2026-01-16 09:08:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("218", "21113", "action created", "2026-01-16 09:08:15", "2026-01-16 09:08:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("219", "21112", "action complete via Async Request", "2026-01-16 09:08:15", "2026-01-16 09:08:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("220", "21113", "action started via WP Cron", "2026-01-16 10:08:30", "2026-01-16 10:08:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("221", "21114", "action created", "2026-01-16 10:08:30", "2026-01-16 10:08:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("222", "21113", "action complete via WP Cron", "2026-01-16 10:08:30", "2026-01-16 10:08:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("223", "21114", "action started via Async Request", "2026-01-16 11:08:39", "2026-01-16 11:08:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("224", "21115", "action created", "2026-01-16 11:08:39", "2026-01-16 11:08:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("225", "21114", "action complete via Async Request", "2026-01-16 11:08:39", "2026-01-16 11:08:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("226", "21115", "action started via WP Cron", "2026-01-16 12:09:05", "2026-01-16 12:09:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("227", "21116", "action created", "2026-01-16 12:09:05", "2026-01-16 12:09:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("228", "21115", "action complete via WP Cron", "2026-01-16 12:09:05", "2026-01-16 12:09:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("229", "21116", "action started via WP Cron", "2026-01-17 17:13:58", "2026-01-17 17:13:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("230", "21117", "action created", "2026-01-17 17:13:58", "2026-01-17 17:13:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("231", "21116", "action complete via WP Cron", "2026-01-17 17:13:58", "2026-01-17 17:13:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("232", "21098", "action started via WP Cron", "2026-01-17 17:13:58", "2026-01-17 17:13:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("233", "21098", "action complete via WP Cron", "2026-01-17 17:13:58", "2026-01-17 17:13:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("234", "21118", "action created", "2026-01-17 17:13:58", "2026-01-17 17:13:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("235", "21099", "action started via WP Cron", "2026-01-17 17:13:58", "2026-01-17 17:13:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("236", "21099", "action complete via WP Cron", "2026-01-17 17:13:58", "2026-01-17 17:13:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("237", "21109", "action started via WP Cron", "2026-01-17 17:13:58", "2026-01-17 17:13:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("238", "21109", "action complete via WP Cron", "2026-01-17 17:13:58", "2026-01-17 17:13:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("240", "21102", "action started via WP Cron", "2026-01-17 17:13:58", "2026-01-17 17:13:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("241", "21102", "action complete via WP Cron", "2026-01-17 17:13:58", "2026-01-17 17:13:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("242", "21120", "action created", "2026-01-17 17:13:58", "2026-01-17 17:13:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("243", "21103", "action started via WP Cron", "2026-01-17 17:13:58", "2026-01-17 17:13:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("244", "21103", "action complete via WP Cron", "2026-01-17 17:13:58", "2026-01-17 17:13:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("245", "21121", "action created", "2026-01-17 17:13:58", "2026-01-17 17:13:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("246", "21104", "action started via WP Cron", "2026-01-17 17:13:58", "2026-01-17 17:13:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("247", "21104", "action complete via WP Cron", "2026-01-17 17:13:58", "2026-01-17 17:13:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("248", "21122", "action created", "2026-01-17 17:13:58", "2026-01-17 17:13:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("249", "21106", "action started via WP Cron", "2026-01-17 17:13:58", "2026-01-17 17:13:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("250", "21106", "action complete via WP Cron", "2026-01-17 17:14:00", "2026-01-17 17:14:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("251", "21123", "action created", "2026-01-17 17:14:00", "2026-01-17 17:14:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("252", "21107", "action started via WP Cron", "2026-01-17 17:14:00", "2026-01-17 17:14:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("253", "21107", "action complete via WP Cron", "2026-01-17 17:14:00", "2026-01-17 17:14:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("254", "21124", "action created", "2026-01-17 17:14:00", "2026-01-17 17:14:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("255", "21108", "action started via WP Cron", "2026-01-17 17:14:00", "2026-01-17 17:14:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("256", "21108", "action complete via WP Cron", "2026-01-17 17:14:01", "2026-01-17 17:14:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("257", "21125", "action created", "2026-01-17 17:14:01", "2026-01-17 17:14:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("258", "21111", "action started via WP Cron", "2026-01-17 17:14:01", "2026-01-17 17:14:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("260", "21126", "action created", "2026-01-17 17:14:01", "2026-01-17 17:14:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("261", "21127", "action created", "2026-01-17 17:14:01", "2026-01-17 17:14:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("262", "21111", "action complete via WP Cron", "2026-01-17 17:14:01", "2026-01-17 17:14:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("263", "21128", "action created", "2026-01-17 17:14:01", "2026-01-17 17:14:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("264", "21129", "action created", "2026-01-17 17:14:03", "2026-01-17 17:14:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("265", "21127", "action started via WP Cron", "2026-01-17 17:15:24", "2026-01-17 17:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("266", "21127", "action complete via WP Cron", "2026-01-17 17:15:24", "2026-01-17 17:15:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("267", "21117", "action started via WP Cron", "2026-01-19 11:03:15", "2026-01-19 11:03:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("268", "21130", "action created", "2026-01-19 11:03:15", "2026-01-19 11:03:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("269", "21117", "action complete via WP Cron", "2026-01-19 11:03:15", "2026-01-19 11:03:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("270", "21118", "action started via WP Cron", "2026-01-19 11:03:15", "2026-01-19 11:03:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("271", "21118", "action complete via WP Cron", "2026-01-19 11:03:15", "2026-01-19 11:03:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("272", "21131", "action created", "2026-01-19 11:03:15", "2026-01-19 11:03:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("273", "21129", "action started via WP Cron", "2026-01-19 11:03:15", "2026-01-19 11:03:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("274", "21129", "action complete via WP Cron", "2026-01-19 11:03:15", "2026-01-19 11:03:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("275", "21126", "action started via WP Cron", "2026-01-19 11:03:15", "2026-01-19 11:03:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("276", "21126", "action complete via WP Cron", "2026-01-19 11:03:15", "2026-01-19 11:03:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("278", "21120", "action started via WP Cron", "2026-01-19 11:03:15", "2026-01-19 11:03:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("279", "21120", "action complete via WP Cron", "2026-01-19 11:03:15", "2026-01-19 11:03:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("280", "21133", "action created", "2026-01-19 11:03:15", "2026-01-19 11:03:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("281", "21121", "action started via WP Cron", "2026-01-19 11:03:15", "2026-01-19 11:03:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("282", "21121", "action complete via WP Cron", "2026-01-19 11:03:15", "2026-01-19 11:03:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("283", "21134", "action created", "2026-01-19 11:03:16", "2026-01-19 11:03:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("284", "21122", "action started via WP Cron", "2026-01-19 11:03:16", "2026-01-19 11:03:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("285", "21122", "action complete via WP Cron", "2026-01-19 11:03:16", "2026-01-19 11:03:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("286", "21135", "action created", "2026-01-19 11:03:16", "2026-01-19 11:03:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("287", "21123", "action started via WP Cron", "2026-01-19 11:03:16", "2026-01-19 11:03:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("288", "21136", "action created", "2026-01-19 11:03:16", "2026-01-19 11:03:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("289", "21123", "action complete via WP Cron", "2026-01-19 11:03:18", "2026-01-19 11:03:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("290", "21137", "action created", "2026-01-19 11:03:18", "2026-01-19 11:03:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("291", "21124", "action started via WP Cron", "2026-01-19 11:03:18", "2026-01-19 11:03:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("292", "21124", "action complete via WP Cron", "2026-01-19 11:03:18", "2026-01-19 11:03:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("293", "21138", "action created", "2026-01-19 11:03:18", "2026-01-19 11:03:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("294", "21125", "action started via WP Cron", "2026-01-19 11:03:18", "2026-01-19 11:03:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("295", "21125", "action complete via WP Cron", "2026-01-19 11:03:19", "2026-01-19 11:03:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("296", "21139", "action created", "2026-01-19 11:03:19", "2026-01-19 11:03:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("297", "21128", "action started via WP Cron", "2026-01-19 11:03:19", "2026-01-19 11:03:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("299", "21140", "action created", "2026-01-19 11:03:19", "2026-01-19 11:03:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("300", "21141", "action created", "2026-01-19 11:03:19", "2026-01-19 11:03:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("301", "21128", "action complete via WP Cron", "2026-01-19 11:03:19", "2026-01-19 11:03:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("302", "21142", "action created", "2026-01-19 11:03:19", "2026-01-19 11:03:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("303", "21141", "action started via WP Cron", "2026-01-20 04:55:35", "2026-01-20 04:55:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("304", "21141", "action complete via WP Cron", "2026-01-20 04:55:35", "2026-01-20 04:55:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("305", "21130", "action started via WP Cron", "2026-01-20 04:55:35", "2026-01-20 04:55:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("306", "21143", "action created", "2026-01-20 04:55:36", "2026-01-20 04:55:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("307", "21130", "action complete via WP Cron", "2026-01-20 04:55:36", "2026-01-20 04:55:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("308", "21131", "action started via WP Cron", "2026-01-20 04:55:36", "2026-01-20 04:55:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("309", "21131", "action complete via WP Cron", "2026-01-20 04:55:36", "2026-01-20 04:55:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("310", "21144", "action created", "2026-01-20 04:55:36", "2026-01-20 04:55:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("311", "21136", "action started via WP Cron", "2026-01-20 04:55:36", "2026-01-20 04:55:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("312", "21136", "action complete via WP Cron", "2026-01-20 04:55:36", "2026-01-20 04:55:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("313", "21145", "action created", "2026-01-20 04:55:39", "2026-01-20 04:55:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("314", "21143", "action started via Async Request", "2026-01-20 05:56:01", "2026-01-20 05:56:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("315", "21146", "action created", "2026-01-20 05:56:01", "2026-01-20 05:56:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("316", "21143", "action complete via Async Request", "2026-01-20 05:56:01", "2026-01-20 05:56:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("317", "21140", "action started via Async Request", "2026-01-20 06:00:07", "2026-01-20 06:00:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("318", "21140", "action complete via Async Request", "2026-01-20 06:00:07", "2026-01-20 06:00:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("320", "21146", "action started via WP Cron", "2026-01-20 06:56:05", "2026-01-20 06:56:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("321", "21148", "action created", "2026-01-20 06:56:05", "2026-01-20 06:56:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("322", "21146", "action complete via WP Cron", "2026-01-20 06:56:05", "2026-01-20 06:56:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("323", "21149", "action created", "2026-01-20 07:48:53", "2026-01-20 07:48:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("324", "21149", "action started via WP Cron", "2026-01-20 07:50:07", "2026-01-20 07:50:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("325", "21149", "action complete via WP Cron", "2026-01-20 07:50:07", "2026-01-20 07:50:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("326", "21148", "action started via WP Cron", "2026-01-20 07:56:05", "2026-01-20 07:56:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("327", "21150", "action created", "2026-01-20 07:56:05", "2026-01-20 07:56:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("328", "21148", "action complete via WP Cron", "2026-01-20 07:56:05", "2026-01-20 07:56:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("329", "21150", "action started via WP Cron", "2026-01-20 08:56:30", "2026-01-20 08:56:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("330", "21151", "action created", "2026-01-20 08:56:30", "2026-01-20 08:56:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("331", "21150", "action complete via WP Cron", "2026-01-20 08:56:30", "2026-01-20 08:56:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("332", "21151", "action started via WP Cron", "2026-01-20 09:57:04", "2026-01-20 09:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("333", "21152", "action created", "2026-01-20 09:57:04", "2026-01-20 09:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("334", "21151", "action complete via WP Cron", "2026-01-20 09:57:04", "2026-01-20 09:57:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("335", "21152", "action started via WP Cron", "2026-01-20 10:57:06", "2026-01-20 10:57:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("336", "21153", "action created", "2026-01-20 10:57:06", "2026-01-20 10:57:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("337", "21152", "action complete via WP Cron", "2026-01-20 10:57:06", "2026-01-20 10:57:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("338", "21133", "action started via Async Request", "2026-01-20 11:03:25", "2026-01-20 11:03:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("339", "21133", "action complete via Async Request", "2026-01-20 11:03:25", "2026-01-20 11:03:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("340", "21154", "action created", "2026-01-20 11:03:25", "2026-01-20 11:03:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("341", "21134", "action started via Async Request", "2026-01-20 11:03:25", "2026-01-20 11:03:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("342", "21134", "action complete via Async Request", "2026-01-20 11:03:25", "2026-01-20 11:03:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("343", "21155", "action created", "2026-01-20 11:03:25", "2026-01-20 11:03:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("344", "21135", "action started via Async Request", "2026-01-20 11:03:25", "2026-01-20 11:03:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("345", "21135", "action complete via Async Request", "2026-01-20 11:03:25", "2026-01-20 11:03:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("346", "21156", "action created", "2026-01-20 11:03:25", "2026-01-20 11:03:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("347", "21137", "action started via Async Request", "2026-01-20 11:03:25", "2026-01-20 11:03:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("348", "21137", "action complete via Async Request", "2026-01-20 11:03:26", "2026-01-20 11:03:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("349", "21157", "action created", "2026-01-20 11:03:26", "2026-01-20 11:03:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("350", "21138", "action started via Async Request", "2026-01-20 11:03:26", "2026-01-20 11:03:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("351", "21138", "action complete via Async Request", "2026-01-20 11:03:26", "2026-01-20 11:03:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("352", "21158", "action created", "2026-01-20 11:03:26", "2026-01-20 11:03:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("353", "21139", "action started via Async Request", "2026-01-20 11:03:26", "2026-01-20 11:03:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("354", "21139", "action complete via Async Request", "2026-01-20 11:03:27", "2026-01-20 11:03:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("355", "21159", "action created", "2026-01-20 11:03:27", "2026-01-20 11:03:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("356", "21142", "action started via Async Request", "2026-01-20 11:03:27", "2026-01-20 11:03:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("358", "21160", "action created", "2026-01-20 11:03:27", "2026-01-20 11:03:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("359", "21161", "action created", "2026-01-20 11:03:27", "2026-01-20 11:03:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("360", "21142", "action complete via Async Request", "2026-01-20 11:03:27", "2026-01-20 11:03:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("361", "21162", "action created", "2026-01-20 11:03:27", "2026-01-20 11:03:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("362", "21161", "action started via WP Cron", "2026-01-20 11:04:06", "2026-01-20 11:04:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("363", "21161", "action complete via WP Cron", "2026-01-20 11:04:07", "2026-01-20 11:04:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("364", "21153", "action started via Async Request", "2026-01-20 11:57:09", "2026-01-20 11:57:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("365", "21163", "action created", "2026-01-20 11:57:09", "2026-01-20 11:57:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("366", "21153", "action complete via Async Request", "2026-01-20 11:57:09", "2026-01-20 11:57:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("367", "21163", "action started via Async Request", "2026-01-20 12:58:17", "2026-01-20 12:58:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("368", "21164", "action created", "2026-01-20 12:58:17", "2026-01-20 12:58:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("369", "21163", "action complete via Async Request", "2026-01-20 12:58:17", "2026-01-20 12:58:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("370", "21164", "action started via WP Cron", "2026-01-21 04:50:06", "2026-01-21 04:50:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("371", "21165", "action created", "2026-01-21 04:50:06", "2026-01-21 04:50:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("372", "21164", "action complete via WP Cron", "2026-01-21 04:50:06", "2026-01-21 04:50:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("373", "21144", "action started via WP Cron", "2026-01-21 04:50:06", "2026-01-21 04:50:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("374", "21144", "action complete via WP Cron", "2026-01-21 04:50:06", "2026-01-21 04:50:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("375", "21166", "action created", "2026-01-21 04:50:06", "2026-01-21 04:50:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("376", "21145", "action started via WP Cron", "2026-01-21 04:50:06", "2026-01-21 04:50:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("377", "21145", "action complete via WP Cron", "2026-01-21 04:50:06", "2026-01-21 04:50:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("378", "21167", "action created", "2026-01-21 04:50:07", "2026-01-21 04:50:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("379", "21165", "action started via WP Cron", "2026-01-21 05:50:08", "2026-01-21 05:50:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("380", "21168", "action created", "2026-01-21 05:50:08", "2026-01-21 05:50:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("381", "21165", "action complete via WP Cron", "2026-01-21 05:50:08", "2026-01-21 05:50:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("382", "21160", "action started via WP Cron", "2026-01-21 06:00:10", "2026-01-21 06:00:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("383", "21160", "action complete via WP Cron", "2026-01-21 06:00:10", "2026-01-21 06:00:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("384", "21169", "action created", "2026-01-21 06:00:10", "2026-01-21 06:00:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("385", "21168", "action started via WP Cron", "2026-01-21 06:51:10", "2026-01-21 06:51:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("386", "21170", "action created", "2026-01-21 06:51:10", "2026-01-21 06:51:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("387", "21168", "action complete via WP Cron", "2026-01-21 06:51:10", "2026-01-21 06:51:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("388", "21170", "action started via WP Cron", "2026-01-21 08:52:37", "2026-01-21 08:52:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("389", "21171", "action created", "2026-01-21 08:52:37", "2026-01-21 08:52:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("390", "21170", "action complete via WP Cron", "2026-01-21 08:52:37", "2026-01-21 08:52:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("391", "21171", "action started via WP Cron", "2026-01-22 05:32:39", "2026-01-22 05:32:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("392", "21172", "action created", "2026-01-22 05:32:39", "2026-01-22 05:32:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("393", "21171", "action complete via WP Cron", "2026-01-22 05:32:39", "2026-01-22 05:32:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("394", "21154", "action started via WP Cron", "2026-01-22 05:32:39", "2026-01-22 05:32:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("395", "21154", "action complete via WP Cron", "2026-01-22 05:32:39", "2026-01-22 05:32:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("396", "21173", "action created", "2026-01-22 05:32:39", "2026-01-22 05:32:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("397", "21155", "action started via WP Cron", "2026-01-22 05:32:39", "2026-01-22 05:32:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("398", "21155", "action complete via WP Cron", "2026-01-22 05:32:39", "2026-01-22 05:32:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("399", "21174", "action created", "2026-01-22 05:32:39", "2026-01-22 05:32:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("400", "21156", "action started via WP Cron", "2026-01-22 05:32:39", "2026-01-22 05:32:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("401", "21156", "action complete via WP Cron", "2026-01-22 05:32:39", "2026-01-22 05:32:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("402", "21175", "action created", "2026-01-22 05:32:39", "2026-01-22 05:32:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("403", "21157", "action started via WP Cron", "2026-01-22 05:32:39", "2026-01-22 05:32:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("404", "21157", "action complete via WP Cron", "2026-01-22 05:32:41", "2026-01-22 05:32:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("405", "21176", "action created", "2026-01-22 05:32:41", "2026-01-22 05:32:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("406", "21158", "action started via WP Cron", "2026-01-22 05:32:41", "2026-01-22 05:32:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("407", "21158", "action complete via WP Cron", "2026-01-22 05:32:41", "2026-01-22 05:32:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("408", "21177", "action created", "2026-01-22 05:32:41", "2026-01-22 05:32:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("409", "21159", "action started via WP Cron", "2026-01-22 05:32:41", "2026-01-22 05:32:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("410", "21159", "action complete via WP Cron", "2026-01-22 05:32:42", "2026-01-22 05:32:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("411", "21178", "action created", "2026-01-22 05:32:42", "2026-01-22 05:32:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("412", "21166", "action started via WP Cron", "2026-01-22 05:32:42", "2026-01-22 05:32:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("413", "21166", "action complete via WP Cron", "2026-01-22 05:32:42", "2026-01-22 05:32:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("414", "21179", "action created", "2026-01-22 05:32:42", "2026-01-22 05:32:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("415", "21167", "action started via WP Cron", "2026-01-22 05:32:42", "2026-01-22 05:32:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("416", "21167", "action complete via WP Cron", "2026-01-22 05:32:42", "2026-01-22 05:32:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("417", "21169", "action started via WP Cron", "2026-01-22 05:32:42", "2026-01-22 05:32:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("418", "21169", "action complete via WP Cron", "2026-01-22 05:32:42", "2026-01-22 05:32:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("420", "21162", "action started via WP Cron", "2026-01-22 05:32:42", "2026-01-22 05:32:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("423", "21182", "action created", "2026-01-22 05:32:42", "2026-01-22 05:32:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("424", "21162", "action complete via WP Cron", "2026-01-22 05:32:42", "2026-01-22 05:32:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("425", "21183", "action created", "2026-01-22 05:32:42", "2026-01-22 05:32:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("426", "21184", "action created", "2026-01-22 05:32:43", "2026-01-22 05:32:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("427", "21182", "action started via Async Request", "2026-01-22 16:53:03", "2026-01-22 16:53:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("428", "21182", "action complete via Async Request", "2026-01-22 16:53:03", "2026-01-22 16:53:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("429", "21172", "action started via Async Request", "2026-01-22 16:53:03", "2026-01-22 16:53:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("430", "21185", "action created", "2026-01-22 16:53:04", "2026-01-22 16:53:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("431", "21172", "action complete via Async Request", "2026-01-22 16:53:04", "2026-01-22 16:53:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("432", "21179", "action started via WP Cron", "2026-01-23 04:52:16", "2026-01-23 04:52:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("433", "21179", "action complete via WP Cron", "2026-01-23 04:52:16", "2026-01-23 04:52:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("434", "21186", "action created", "2026-01-23 04:52:16", "2026-01-23 04:52:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("435", "21184", "action started via WP Cron", "2026-01-23 04:52:16", "2026-01-23 04:52:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("436", "21184", "action complete via WP Cron", "2026-01-23 04:52:16", "2026-01-23 04:52:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("437", "21185", "action started via WP Cron", "2026-01-23 04:52:16", "2026-01-23 04:52:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("438", "21187", "action created", "2026-01-23 04:52:16", "2026-01-23 04:52:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("439", "21185", "action complete via WP Cron", "2026-01-23 04:52:16", "2026-01-23 04:52:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("440", "21188", "action created", "2026-01-23 04:53:04", "2026-01-23 04:53:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("441", "21173", "action started via WP Cron", "2026-01-23 05:33:15", "2026-01-23 05:33:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("442", "21173", "action complete via WP Cron", "2026-01-23 05:33:15", "2026-01-23 05:33:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("443", "21189", "action created", "2026-01-23 05:33:15", "2026-01-23 05:33:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("444", "21174", "action started via WP Cron", "2026-01-23 05:33:15", "2026-01-23 05:33:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("445", "21174", "action complete via WP Cron", "2026-01-23 05:33:15", "2026-01-23 05:33:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("446", "21190", "action created", "2026-01-23 05:33:15", "2026-01-23 05:33:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("447", "21175", "action started via WP Cron", "2026-01-23 05:33:15", "2026-01-23 05:33:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("448", "21175", "action complete via WP Cron", "2026-01-23 05:33:15", "2026-01-23 05:33:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("449", "21191", "action created", "2026-01-23 05:33:15", "2026-01-23 05:33:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("450", "21176", "action started via WP Cron", "2026-01-23 05:33:15", "2026-01-23 05:33:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("451", "21176", "action complete via WP Cron", "2026-01-23 05:33:16", "2026-01-23 05:33:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("452", "21192", "action created", "2026-01-23 05:33:16", "2026-01-23 05:33:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("453", "21177", "action started via WP Cron", "2026-01-23 05:33:16", "2026-01-23 05:33:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("454", "21177", "action complete via WP Cron", "2026-01-23 05:33:16", "2026-01-23 05:33:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("455", "21193", "action created", "2026-01-23 05:33:16", "2026-01-23 05:33:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("456", "21178", "action started via WP Cron", "2026-01-23 05:33:16", "2026-01-23 05:33:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("457", "21178", "action complete via WP Cron", "2026-01-23 05:33:17", "2026-01-23 05:33:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("458", "21194", "action created", "2026-01-23 05:33:17", "2026-01-23 05:33:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("459", "21183", "action started via WP Cron", "2026-01-23 05:33:17", "2026-01-23 05:33:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("462", "21196", "action created", "2026-01-23 05:33:17", "2026-01-23 05:33:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("463", "21183", "action complete via WP Cron", "2026-01-23 05:33:17", "2026-01-23 05:33:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("464", "21197", "action created", "2026-01-23 05:33:17", "2026-01-23 05:33:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("465", "21196", "action started via WP Cron", "2026-01-23 05:34:24", "2026-01-23 05:34:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("466", "21196", "action complete via WP Cron", "2026-01-23 05:34:25", "2026-01-23 05:34:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("467", "21187", "action started via WP Cron", "2026-01-23 06:36:36", "2026-01-23 06:36:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("468", "21198", "action created", "2026-01-23 06:36:36", "2026-01-23 06:36:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("469", "21187", "action complete via WP Cron", "2026-01-23 06:36:36", "2026-01-23 06:36:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("470", "21198", "action started via WP Cron", "2026-01-23 07:37:09", "2026-01-23 07:37:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("471", "21199", "action created", "2026-01-23 07:37:09", "2026-01-23 07:37:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("472", "21198", "action complete via WP Cron", "2026-01-23 07:37:09", "2026-01-23 07:37:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("473", "21199", "action started via Async Request", "2026-01-23 08:48:04", "2026-01-23 08:48:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("474", "21200", "action created", "2026-01-23 08:48:04", "2026-01-23 08:48:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("475", "21199", "action complete via Async Request", "2026-01-23 08:48:04", "2026-01-23 08:48:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("476", "21200", "action started via WP Cron", "2026-01-23 09:48:11", "2026-01-23 09:48:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("477", "21201", "action created", "2026-01-23 09:48:11", "2026-01-23 09:48:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("478", "21200", "action complete via WP Cron", "2026-01-23 09:48:11", "2026-01-23 09:48:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("479", "21201", "action started via Async Request", "2026-01-23 10:48:45", "2026-01-23 10:48:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("480", "21202", "action created", "2026-01-23 10:48:45", "2026-01-23 10:48:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("481", "21201", "action complete via Async Request", "2026-01-23 10:48:45", "2026-01-23 10:48:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("482", "21202", "action started via WP Cron", "2026-01-23 11:49:20", "2026-01-23 11:49:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("483", "21203", "action created", "2026-01-23 11:49:20", "2026-01-23 11:49:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("484", "21202", "action complete via WP Cron", "2026-01-23 11:49:20", "2026-01-23 11:49:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("485", "21203", "action started via WP Cron", "2026-01-23 12:50:05", "2026-01-23 12:50:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("486", "21204", "action created", "2026-01-23 12:50:05", "2026-01-23 12:50:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("487", "21203", "action complete via WP Cron", "2026-01-23 12:50:05", "2026-01-23 12:50:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("488", "21204", "action started via WP Cron", "2026-01-23 14:01:13", "2026-01-23 14:01:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("489", "21205", "action created", "2026-01-23 14:01:13", "2026-01-23 14:01:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("490", "21204", "action complete via WP Cron", "2026-01-23 14:01:13", "2026-01-23 14:01:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("491", "21205", "action started via Async Request", "2026-01-23 15:01:16", "2026-01-23 15:01:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("492", "21206", "action created", "2026-01-23 15:01:16", "2026-01-23 15:01:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("493", "21205", "action complete via Async Request", "2026-01-23 15:01:16", "2026-01-23 15:01:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("494", "21206", "action started via Async Request", "2026-01-23 16:02:28", "2026-01-23 16:02:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("495", "21207", "action created", "2026-01-23 16:02:28", "2026-01-23 16:02:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("496", "21206", "action complete via Async Request", "2026-01-23 16:02:28", "2026-01-23 16:02:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("497", "21186", "action started via Async Request", "2026-01-23 16:54:52", "2026-01-23 16:54:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("498", "21186", "action complete via Async Request", "2026-01-23 16:54:52", "2026-01-23 16:54:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("499", "21208", "action created", "2026-01-23 16:54:52", "2026-01-23 16:54:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("500", "21188", "action started via Async Request", "2026-01-23 16:54:52", "2026-01-23 16:54:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("501", "21188", "action complete via Async Request", "2026-01-23 16:54:52", "2026-01-23 16:54:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("502", "21209", "action created", "2026-01-23 16:54:53", "2026-01-23 16:54:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("503", "21207", "action started via Async Request", "2026-01-23 17:02:39", "2026-01-23 17:02:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("504", "21210", "action created", "2026-01-23 17:02:39", "2026-01-23 17:02:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("505", "21207", "action complete via Async Request", "2026-01-23 17:02:39", "2026-01-23 17:02:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("506", "21210", "action started via Async Request", "2026-01-23 18:03:28", "2026-01-23 18:03:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("507", "21211", "action created", "2026-01-23 18:03:28", "2026-01-23 18:03:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("508", "21210", "action complete via Async Request", "2026-01-23 18:03:28", "2026-01-23 18:03:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("509", "21211", "action started via Async Request", "2026-01-24 04:45:11", "2026-01-24 04:45:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("510", "21212", "action created", "2026-01-24 04:45:11", "2026-01-24 04:45:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("511", "21211", "action complete via Async Request", "2026-01-24 04:45:11", "2026-01-24 04:45:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("512", "21208", "action started via WP Cron", "2026-01-24 04:55:25", "2026-01-24 04:55:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("513", "21208", "action complete via WP Cron", "2026-01-24 04:55:25", "2026-01-24 04:55:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("514", "21213", "action created", "2026-01-24 04:55:25", "2026-01-24 04:55:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("515", "21209", "action started via WP Cron", "2026-01-24 04:55:25", "2026-01-24 04:55:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("516", "21209", "action complete via WP Cron", "2026-01-24 04:55:25", "2026-01-24 04:55:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("517", "21214", "action created", "2026-01-24 04:55:38", "2026-01-24 04:55:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("518", "21189", "action started via WP Cron", "2026-01-24 05:33:22", "2026-01-24 05:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("519", "21189", "action complete via WP Cron", "2026-01-24 05:33:22", "2026-01-24 05:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("520", "21215", "action created", "2026-01-24 05:33:22", "2026-01-24 05:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("521", "21190", "action started via WP Cron", "2026-01-24 05:33:22", "2026-01-24 05:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("522", "21190", "action complete via WP Cron", "2026-01-24 05:33:22", "2026-01-24 05:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("523", "21216", "action created", "2026-01-24 05:33:22", "2026-01-24 05:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("524", "21191", "action started via WP Cron", "2026-01-24 05:33:22", "2026-01-24 05:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("525", "21191", "action complete via WP Cron", "2026-01-24 05:33:22", "2026-01-24 05:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("526", "21217", "action created", "2026-01-24 05:33:22", "2026-01-24 05:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("527", "21192", "action started via WP Cron", "2026-01-24 05:33:22", "2026-01-24 05:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("528", "21192", "action complete via WP Cron", "2026-01-24 05:33:23", "2026-01-24 05:33:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("529", "21218", "action created", "2026-01-24 05:33:23", "2026-01-24 05:33:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("530", "21193", "action started via WP Cron", "2026-01-24 05:33:23", "2026-01-24 05:33:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("531", "21193", "action complete via WP Cron", "2026-01-24 05:33:23", "2026-01-24 05:33:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("532", "21219", "action created", "2026-01-24 05:33:23", "2026-01-24 05:33:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("533", "21194", "action started via WP Cron", "2026-01-24 05:33:23", "2026-01-24 05:33:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("534", "21194", "action complete via WP Cron", "2026-01-24 05:33:24", "2026-01-24 05:33:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("535", "21220", "action created", "2026-01-24 05:33:24", "2026-01-24 05:33:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("536", "21197", "action started via WP Cron", "2026-01-24 05:33:24", "2026-01-24 05:33:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("538", "21221", "action created", "2026-01-24 05:33:24", "2026-01-24 05:33:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("539", "21222", "action created", "2026-01-24 05:33:24", "2026-01-24 05:33:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("540", "21197", "action complete via WP Cron", "2026-01-24 05:33:24", "2026-01-24 05:33:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("541", "21223", "action created", "2026-01-24 05:33:24", "2026-01-24 05:33:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("542", "21222", "action started via Async Request", "2026-01-24 05:34:15", "2026-01-24 05:34:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("543", "21222", "action complete via Async Request", "2026-01-24 05:34:15", "2026-01-24 05:34:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("544", "21212", "action started via Async Request", "2026-01-24 05:45:47", "2026-01-24 05:45:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("545", "21224", "action created", "2026-01-24 05:45:47", "2026-01-24 05:45:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("546", "21212", "action complete via Async Request", "2026-01-24 05:45:47", "2026-01-24 05:45:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("547", "21224", "action started via Async Request", "2026-01-24 06:47:12", "2026-01-24 06:47:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("548", "21225", "action created", "2026-01-24 06:47:12", "2026-01-24 06:47:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("549", "21224", "action complete via Async Request", "2026-01-24 06:47:12", "2026-01-24 06:47:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("550", "21225", "action started via WP Cron", "2026-01-24 07:47:23", "2026-01-24 07:47:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("551", "21226", "action created", "2026-01-24 07:47:23", "2026-01-24 07:47:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("552", "21225", "action complete via WP Cron", "2026-01-24 07:47:23", "2026-01-24 07:47:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("553", "21226", "action started via Async Request", "2026-01-24 08:47:29", "2026-01-24 08:47:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("554", "21227", "action created", "2026-01-24 08:47:29", "2026-01-24 08:47:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("555", "21226", "action complete via Async Request", "2026-01-24 08:47:29", "2026-01-24 08:47:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("556", "21227", "action started via Async Request", "2026-01-24 09:48:16", "2026-01-24 09:48:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("557", "21228", "action created", "2026-01-24 09:48:16", "2026-01-24 09:48:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("558", "21227", "action complete via Async Request", "2026-01-24 09:48:16", "2026-01-24 09:48:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("559", "21228", "action started via WP Cron", "2026-01-24 10:48:26", "2026-01-24 10:48:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("560", "21229", "action created", "2026-01-24 10:48:26", "2026-01-24 10:48:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("561", "21228", "action complete via WP Cron", "2026-01-24 10:48:26", "2026-01-24 10:48:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("562", "21229", "action started via Async Request", "2026-01-24 11:48:27", "2026-01-24 11:48:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("563", "21230", "action created", "2026-01-24 11:48:27", "2026-01-24 11:48:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("564", "21229", "action complete via Async Request", "2026-01-24 11:48:27", "2026-01-24 11:48:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("565", "21230", "action started via WP Cron", "2026-01-24 12:48:55", "2026-01-24 12:48:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("566", "21231", "action created", "2026-01-24 12:48:55", "2026-01-24 12:48:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("567", "21230", "action complete via WP Cron", "2026-01-24 12:48:55", "2026-01-24 12:48:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("568", "21231", "action started via WP Cron", "2026-01-24 13:49:28", "2026-01-24 13:49:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("569", "21232", "action created", "2026-01-24 13:49:28", "2026-01-24 13:49:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("570", "21231", "action complete via WP Cron", "2026-01-24 13:49:28", "2026-01-24 13:49:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("571", "21232", "action started via WP Cron", "2026-01-27 04:02:59", "2026-01-27 04:02:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("572", "21233", "action created", "2026-01-27 04:02:59", "2026-01-27 04:02:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("573", "21232", "action complete via WP Cron", "2026-01-27 04:02:59", "2026-01-27 04:02:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("574", "21213", "action started via WP Cron", "2026-01-27 04:02:59", "2026-01-27 04:02:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("575", "21213", "action complete via WP Cron", "2026-01-27 04:02:59", "2026-01-27 04:02:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("576", "21234", "action created", "2026-01-27 04:02:59", "2026-01-27 04:02:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("577", "21214", "action started via WP Cron", "2026-01-27 04:02:59", "2026-01-27 04:02:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("578", "21214", "action complete via WP Cron", "2026-01-27 04:02:59", "2026-01-27 04:02:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("579", "21215", "action started via WP Cron", "2026-01-27 04:02:59", "2026-01-27 04:02:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("580", "21215", "action complete via WP Cron", "2026-01-27 04:02:59", "2026-01-27 04:02:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("581", "21235", "action created", "2026-01-27 04:02:59", "2026-01-27 04:02:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("582", "21216", "action started via WP Cron", "2026-01-27 04:02:59", "2026-01-27 04:02:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("583", "21216", "action complete via WP Cron", "2026-01-27 04:02:59", "2026-01-27 04:02:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("584", "21236", "action created", "2026-01-27 04:02:59", "2026-01-27 04:02:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("585", "21217", "action started via WP Cron", "2026-01-27 04:02:59", "2026-01-27 04:02:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("586", "21217", "action complete via WP Cron", "2026-01-27 04:02:59", "2026-01-27 04:02:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("587", "21237", "action created", "2026-01-27 04:02:59", "2026-01-27 04:02:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("588", "21218", "action started via WP Cron", "2026-01-27 04:02:59", "2026-01-27 04:02:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("589", "21218", "action complete via WP Cron", "2026-01-27 04:03:00", "2026-01-27 04:03:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("590", "21238", "action created", "2026-01-27 04:03:00", "2026-01-27 04:03:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("591", "21219", "action started via WP Cron", "2026-01-27 04:03:00", "2026-01-27 04:03:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("592", "21219", "action complete via WP Cron", "2026-01-27 04:03:00", "2026-01-27 04:03:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("593", "21239", "action created", "2026-01-27 04:03:00", "2026-01-27 04:03:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("594", "21220", "action started via WP Cron", "2026-01-27 04:03:00", "2026-01-27 04:03:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("595", "21220", "action complete via WP Cron", "2026-01-27 04:03:01", "2026-01-27 04:03:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("596", "21240", "action created", "2026-01-27 04:03:01", "2026-01-27 04:03:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("597", "21221", "action started via WP Cron", "2026-01-27 04:03:01", "2026-01-27 04:03:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("598", "21221", "action complete via WP Cron", "2026-01-27 04:03:01", "2026-01-27 04:03:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("600", "21223", "action started via WP Cron", "2026-01-27 04:03:01", "2026-01-27 04:03:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("603", "21243", "action created", "2026-01-27 04:03:01", "2026-01-27 04:03:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("604", "21223", "action complete via WP Cron", "2026-01-27 04:03:01", "2026-01-27 04:03:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("605", "21244", "action created", "2026-01-27 04:03:01", "2026-01-27 04:03:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("606", "21245", "action created", "2026-01-27 04:03:02", "2026-01-27 04:03:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("607", "21243", "action started via WP Cron", "2026-01-27 04:03:48", "2026-01-27 04:03:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("608", "21243", "action complete via WP Cron", "2026-01-27 04:03:48", "2026-01-27 04:03:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("609", "21233", "action started via Async Request", "2026-01-27 05:03:24", "2026-01-27 05:03:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("610", "21246", "action created", "2026-01-27 05:03:24", "2026-01-27 05:03:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("611", "21233", "action complete via Async Request", "2026-01-27 05:03:24", "2026-01-27 05:03:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("612", "21246", "action started via WP Cron", "2026-01-27 06:03:34", "2026-01-27 06:03:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("613", "21247", "action created", "2026-01-27 06:03:34", "2026-01-27 06:03:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("614", "21246", "action complete via WP Cron", "2026-01-27 06:03:34", "2026-01-27 06:03:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("615", "21247", "action started via Async Request", "2026-01-27 07:03:50", "2026-01-27 07:03:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("616", "21248", "action created", "2026-01-27 07:03:50", "2026-01-27 07:03:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("617", "21247", "action complete via Async Request", "2026-01-27 07:03:50", "2026-01-27 07:03:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("618", "21248", "action started via WP Cron", "2026-01-27 08:32:38", "2026-01-27 08:32:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("619", "21249", "action created", "2026-01-27 08:32:38", "2026-01-27 08:32:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("620", "21248", "action complete via WP Cron", "2026-01-27 08:32:38", "2026-01-27 08:32:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("621", "21249", "action started via Async Request", "2026-01-27 11:17:08", "2026-01-27 11:17:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("622", "21250", "action created", "2026-01-27 11:17:08", "2026-01-27 11:17:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("623", "21249", "action complete via Async Request", "2026-01-27 11:17:08", "2026-01-27 11:17:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("624", "21250", "action started via Async Request", "2026-01-27 12:17:11", "2026-01-27 12:17:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("625", "21251", "action created", "2026-01-27 12:17:11", "2026-01-27 12:17:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("626", "21250", "action complete via Async Request", "2026-01-27 12:17:11", "2026-01-27 12:17:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("627", "21251", "action started via WP Cron", "2026-01-27 15:21:56", "2026-01-27 15:21:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("628", "21252", "action created", "2026-01-27 15:21:56", "2026-01-27 15:21:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("629", "21251", "action complete via WP Cron", "2026-01-27 15:21:56", "2026-01-27 15:21:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("630", "21234", "action started via WP Cron", "2026-01-27 16:40:42", "2026-01-27 16:40:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("631", "21234", "action complete via WP Cron", "2026-01-27 16:40:42", "2026-01-27 16:40:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("632", "21253", "action created", "2026-01-27 16:40:42", "2026-01-27 16:40:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("633", "21245", "action started via WP Cron", "2026-01-27 16:40:42", "2026-01-27 16:40:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("634", "21245", "action complete via WP Cron", "2026-01-27 16:40:42", "2026-01-27 16:40:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("635", "21252", "action started via WP Cron", "2026-01-27 16:40:42", "2026-01-27 16:40:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("636", "21254", "action created", "2026-01-27 16:40:42", "2026-01-27 16:40:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("637", "21252", "action complete via WP Cron", "2026-01-27 16:40:42", "2026-01-27 16:40:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("638", "21255", "action created", "2026-01-27 16:40:45", "2026-01-27 16:40:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("639", "21254", "action started via WP Cron", "2026-01-27 17:46:22", "2026-01-27 17:46:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("640", "21256", "action created", "2026-01-27 17:46:22", "2026-01-27 17:46:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("641", "21254", "action complete via WP Cron", "2026-01-27 17:46:22", "2026-01-27 17:46:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("642", "21256", "action started via WP Cron", "2026-01-27 19:07:02", "2026-01-27 19:07:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("643", "21257", "action created", "2026-01-27 19:07:02", "2026-01-27 19:07:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("644", "21256", "action complete via WP Cron", "2026-01-27 19:07:02", "2026-01-27 19:07:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("645", "21257", "action started via WP Cron", "2026-01-27 20:12:14", "2026-01-27 20:12:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("646", "21258", "action created", "2026-01-27 20:12:14", "2026-01-27 20:12:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("647", "21257", "action complete via WP Cron", "2026-01-27 20:12:14", "2026-01-27 20:12:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("648", "21258", "action started via WP Cron", "2026-01-27 22:14:49", "2026-01-27 22:14:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("649", "21259", "action created", "2026-01-27 22:14:49", "2026-01-27 22:14:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("650", "21258", "action complete via WP Cron", "2026-01-27 22:14:49", "2026-01-27 22:14:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("651", "21259", "action started via WP Cron", "2026-01-27 23:20:27", "2026-01-27 23:20:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("652", "21260", "action created", "2026-01-27 23:20:27", "2026-01-27 23:20:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("653", "21259", "action complete via WP Cron", "2026-01-27 23:20:27", "2026-01-27 23:20:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("654", "21260", "action started via WP Cron", "2026-01-28 01:13:43", "2026-01-28 01:13:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("655", "21261", "action created", "2026-01-28 01:13:43", "2026-01-28 01:13:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("656", "21260", "action complete via WP Cron", "2026-01-28 01:13:43", "2026-01-28 01:13:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("657", "21261", "action started via WP Cron", "2026-01-28 02:19:27", "2026-01-28 02:19:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("658", "21262", "action created", "2026-01-28 02:19:27", "2026-01-28 02:19:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("659", "21261", "action complete via WP Cron", "2026-01-28 02:19:27", "2026-01-28 02:19:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("660", "21262", "action started via WP Cron", "2026-01-28 04:57:39", "2026-01-28 04:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("661", "21263", "action created", "2026-01-28 04:57:39", "2026-01-28 04:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("662", "21262", "action complete via WP Cron", "2026-01-28 04:57:39", "2026-01-28 04:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("663", "21235", "action started via WP Cron", "2026-01-28 04:57:39", "2026-01-28 04:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("664", "21235", "action complete via WP Cron", "2026-01-28 04:57:39", "2026-01-28 04:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("665", "21264", "action created", "2026-01-28 04:57:39", "2026-01-28 04:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("666", "21236", "action started via WP Cron", "2026-01-28 04:57:39", "2026-01-28 04:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("667", "21236", "action complete via WP Cron", "2026-01-28 04:57:39", "2026-01-28 04:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("668", "21265", "action created", "2026-01-28 04:57:39", "2026-01-28 04:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("669", "21237", "action started via WP Cron", "2026-01-28 04:57:39", "2026-01-28 04:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("670", "21237", "action complete via WP Cron", "2026-01-28 04:57:39", "2026-01-28 04:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("671", "21266", "action created", "2026-01-28 04:57:39", "2026-01-28 04:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("672", "21238", "action started via WP Cron", "2026-01-28 04:57:39", "2026-01-28 04:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("673", "21238", "action complete via WP Cron", "2026-01-28 04:57:39", "2026-01-28 04:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("674", "21267", "action created", "2026-01-28 04:57:39", "2026-01-28 04:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("675", "21239", "action started via WP Cron", "2026-01-28 04:57:39", "2026-01-28 04:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("676", "21239", "action complete via WP Cron", "2026-01-28 04:57:39", "2026-01-28 04:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("677", "21268", "action created", "2026-01-28 04:57:39", "2026-01-28 04:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("678", "21240", "action started via WP Cron", "2026-01-28 04:57:39", "2026-01-28 04:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("679", "21240", "action complete via WP Cron", "2026-01-28 04:57:40", "2026-01-28 04:57:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("680", "21269", "action created", "2026-01-28 04:57:40", "2026-01-28 04:57:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("681", "21253", "action started via WP Cron", "2026-01-28 04:57:40", "2026-01-28 04:57:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("682", "21253", "action complete via WP Cron", "2026-01-28 04:57:40", "2026-01-28 04:57:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("683", "21270", "action created", "2026-01-28 04:57:40", "2026-01-28 04:57:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("684", "21255", "action started via WP Cron", "2026-01-28 04:57:40", "2026-01-28 04:57:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("685", "21255", "action complete via WP Cron", "2026-01-28 04:57:40", "2026-01-28 04:57:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("686", "21244", "action started via WP Cron", "2026-01-28 04:57:40", "2026-01-28 04:57:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("689", "21272", "action created", "2026-01-28 04:57:40", "2026-01-28 04:57:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("690", "21244", "action complete via WP Cron", "2026-01-28 04:57:40", "2026-01-28 04:57:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("691", "21273", "action created", "2026-01-28 04:57:40", "2026-01-28 04:57:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("692", "21274", "action created", "2026-01-28 04:57:40", "2026-01-28 04:57:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("693", "21272", "action started via WP Cron", "2026-01-28 04:59:53", "2026-01-28 04:59:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("694", "21272", "action complete via WP Cron", "2026-01-28 04:59:53", "2026-01-28 04:59:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("695", "21263", "action started via Async Request", "2026-01-28 05:58:20", "2026-01-28 05:58:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("696", "21275", "action created", "2026-01-28 05:58:20", "2026-01-28 05:58:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("697", "21263", "action complete via Async Request", "2026-01-28 05:58:20", "2026-01-28 05:58:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("698", "21275", "action started via WP Cron", "2026-01-28 06:58:20", "2026-01-28 06:58:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("699", "21276", "action created", "2026-01-28 06:58:20", "2026-01-28 06:58:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("700", "21275", "action complete via WP Cron", "2026-01-28 06:58:20", "2026-01-28 06:58:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("701", "21276", "action started via WP Cron", "2026-01-28 07:58:30", "2026-01-28 07:58:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("702", "21277", "action created", "2026-01-28 07:58:30", "2026-01-28 07:58:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("703", "21276", "action complete via WP Cron", "2026-01-28 07:58:30", "2026-01-28 07:58:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("704", "21277", "action started via Async Request", "2026-01-28 08:58:54", "2026-01-28 08:58:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("705", "21278", "action created", "2026-01-28 08:58:54", "2026-01-28 08:58:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("706", "21277", "action complete via Async Request", "2026-01-28 08:58:54", "2026-01-28 08:58:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("707", "21278", "action started via WP Cron", "2026-01-28 09:59:18", "2026-01-28 09:59:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("708", "21279", "action created", "2026-01-28 09:59:18", "2026-01-28 09:59:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("709", "21278", "action complete via WP Cron", "2026-01-28 09:59:18", "2026-01-28 09:59:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("710", "21279", "action started via WP Cron", "2026-01-28 10:59:20", "2026-01-28 10:59:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("711", "21280", "action created", "2026-01-28 10:59:20", "2026-01-28 10:59:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("712", "21279", "action complete via WP Cron", "2026-01-28 10:59:20", "2026-01-28 10:59:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("713", "21280", "action started via WP Cron", "2026-01-28 11:59:22", "2026-01-28 11:59:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("714", "21281", "action created", "2026-01-28 11:59:22", "2026-01-28 11:59:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("715", "21280", "action complete via WP Cron", "2026-01-28 11:59:22", "2026-01-28 11:59:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("716", "21281", "action started via Async Request", "2026-01-28 12:59:40", "2026-01-28 12:59:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("717", "21282", "action created", "2026-01-28 12:59:40", "2026-01-28 12:59:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("718", "21281", "action complete via Async Request", "2026-01-28 12:59:40", "2026-01-28 12:59:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("719", "21282", "action started via WP Cron", "2026-01-28 16:17:48", "2026-01-28 16:17:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("720", "21283", "action created", "2026-01-28 16:17:48", "2026-01-28 16:17:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("721", "21282", "action complete via WP Cron", "2026-01-28 16:17:48", "2026-01-28 16:17:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("722", "21270", "action started via WP Cron", "2026-01-28 16:58:19", "2026-01-28 16:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("723", "21270", "action complete via WP Cron", "2026-01-28 16:58:19", "2026-01-28 16:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("724", "21284", "action created", "2026-01-28 16:58:19", "2026-01-28 16:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("725", "21274", "action started via WP Cron", "2026-01-28 16:58:19", "2026-01-28 16:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("726", "21274", "action complete via WP Cron", "2026-01-28 16:58:19", "2026-01-28 16:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("727", "21285", "action created", "2026-01-28 16:58:29", "2026-01-28 16:58:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("728", "21283", "action started via Async Request", "2026-01-28 17:18:42", "2026-01-28 17:18:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("729", "21286", "action created", "2026-01-28 17:18:42", "2026-01-28 17:18:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("730", "21283", "action complete via Async Request", "2026-01-28 17:18:42", "2026-01-28 17:18:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("731", "21286", "action started via WP Cron", "2026-01-29 04:42:57", "2026-01-29 04:42:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("732", "21287", "action created", "2026-01-29 04:42:57", "2026-01-29 04:42:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("733", "21286", "action complete via WP Cron", "2026-01-29 04:42:57", "2026-01-29 04:42:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("734", "21264", "action started via WP Cron", "2026-01-29 04:57:39", "2026-01-29 04:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("735", "21264", "action complete via WP Cron", "2026-01-29 04:57:39", "2026-01-29 04:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("736", "21288", "action created", "2026-01-29 04:57:39", "2026-01-29 04:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("737", "21265", "action started via WP Cron", "2026-01-29 04:57:39", "2026-01-29 04:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("738", "21265", "action complete via WP Cron", "2026-01-29 04:57:39", "2026-01-29 04:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("739", "21289", "action created", "2026-01-29 04:57:39", "2026-01-29 04:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("740", "21266", "action started via WP Cron", "2026-01-29 04:57:39", "2026-01-29 04:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("741", "21266", "action complete via WP Cron", "2026-01-29 04:57:39", "2026-01-29 04:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("742", "21290", "action created", "2026-01-29 04:57:39", "2026-01-29 04:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("743", "21267", "action started via WP Cron", "2026-01-29 04:57:39", "2026-01-29 04:57:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("744", "21267", "action complete via WP Cron", "2026-01-29 04:57:40", "2026-01-29 04:57:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("745", "21291", "action created", "2026-01-29 04:57:40", "2026-01-29 04:57:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("746", "21268", "action started via WP Cron", "2026-01-29 04:57:40", "2026-01-29 04:57:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("747", "21268", "action complete via WP Cron", "2026-01-29 04:57:40", "2026-01-29 04:57:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("748", "21292", "action created", "2026-01-29 04:57:40", "2026-01-29 04:57:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("749", "21269", "action started via WP Cron", "2026-01-29 04:57:40", "2026-01-29 04:57:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("750", "21269", "action complete via WP Cron", "2026-01-29 04:57:41", "2026-01-29 04:57:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("751", "21293", "action created", "2026-01-29 04:57:41", "2026-01-29 04:57:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("752", "21273", "action started via WP Cron", "2026-01-29 04:57:41", "2026-01-29 04:57:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("755", "21295", "action created", "2026-01-29 04:57:41", "2026-01-29 04:57:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("756", "21273", "action complete via WP Cron", "2026-01-29 04:57:41", "2026-01-29 04:57:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("757", "21296", "action created", "2026-01-29 04:57:41", "2026-01-29 04:57:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("758", "21295", "action started via WP Cron", "2026-01-29 04:58:19", "2026-01-29 04:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("759", "21295", "action complete via WP Cron", "2026-01-29 04:58:19", "2026-01-29 04:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("760", "21284", "action started via WP Cron", "2026-01-29 04:58:19", "2026-01-29 04:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("761", "21284", "action complete via WP Cron", "2026-01-29 04:58:19", "2026-01-29 04:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("762", "21297", "action created", "2026-01-29 04:58:19", "2026-01-29 04:58:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("763", "21285", "action started via Async Request", "2026-01-29 04:58:44", "2026-01-29 04:58:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("764", "21285", "action complete via Async Request", "2026-01-29 04:58:44", "2026-01-29 04:58:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("765", "21298", "action created", "2026-01-29 04:58:45", "2026-01-29 04:58:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("766", "21287", "action started via Async Request", "2026-01-29 05:43:22", "2026-01-29 05:43:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("767", "21299", "action created", "2026-01-29 05:43:22", "2026-01-29 05:43:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("768", "21287", "action complete via Async Request", "2026-01-29 05:43:22", "2026-01-29 05:43:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("769", "21066", "action started via Async Request", "2026-01-29 06:00:20", "2026-01-29 06:00:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("770", "21066", "action complete via Async Request", "2026-01-29 06:00:20", "2026-01-29 06:00:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("771", "21300", "action created", "2026-01-29 06:00:20", "2026-01-29 06:00:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("772", "21299", "action started via Async Request", "2026-01-29 06:43:30", "2026-01-29 06:43:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("773", "21301", "action created", "2026-01-29 06:43:30", "2026-01-29 06:43:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("774", "21299", "action complete via Async Request", "2026-01-29 06:43:30", "2026-01-29 06:43:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("775", "21301", "action started via Async Request", "2026-01-29 07:44:15", "2026-01-29 07:44:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("776", "21302", "action created", "2026-01-29 07:44:15", "2026-01-29 07:44:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("777", "21301", "action complete via Async Request", "2026-01-29 07:44:15", "2026-01-29 07:44:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("778", "21302", "action started via Async Request", "2026-01-29 08:44:24", "2026-01-29 08:44:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("779", "21303", "action created", "2026-01-29 08:44:24", "2026-01-29 08:44:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("780", "21302", "action complete via Async Request", "2026-01-29 08:44:24", "2026-01-29 08:44:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("781", "21303", "action started via Async Request", "2026-01-29 09:45:12", "2026-01-29 09:45:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("782", "21304", "action created", "2026-01-29 09:45:12", "2026-01-29 09:45:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("783", "21303", "action complete via Async Request", "2026-01-29 09:45:12", "2026-01-29 09:45:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("784", "21304", "action started via WP Cron", "2026-01-29 10:45:20", "2026-01-29 10:45:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("785", "21305", "action created", "2026-01-29 10:45:20", "2026-01-29 10:45:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("786", "21304", "action complete via WP Cron", "2026-01-29 10:45:20", "2026-01-29 10:45:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("787", "21305", "action started via WP Cron", "2026-01-29 11:45:22", "2026-01-29 11:45:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("788", "21306", "action created", "2026-01-29 11:45:22", "2026-01-29 11:45:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("789", "21305", "action complete via WP Cron", "2026-01-29 11:45:22", "2026-01-29 11:45:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("790", "21306", "action started via WP Cron", "2026-01-29 12:45:25", "2026-01-29 12:45:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("791", "21307", "action created", "2026-01-29 12:45:25", "2026-01-29 12:45:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("792", "21306", "action complete via WP Cron", "2026-01-29 12:45:25", "2026-01-29 12:45:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("793", "21307", "action started via WP Cron", "2026-01-29 13:50:42", "2026-01-29 13:50:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("794", "21308", "action created", "2026-01-29 13:50:42", "2026-01-29 13:50:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("795", "21307", "action complete via WP Cron", "2026-01-29 13:50:42", "2026-01-29 13:50:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("796", "21308", "action started via WP Cron", "2026-01-29 22:28:04", "2026-01-29 22:28:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("797", "21309", "action created", "2026-01-29 22:28:04", "2026-01-29 22:28:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("798", "21308", "action complete via WP Cron", "2026-01-29 22:28:04", "2026-01-29 22:28:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("799", "21297", "action started via WP Cron", "2026-01-29 22:28:04", "2026-01-29 22:28:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("800", "21297", "action complete via WP Cron", "2026-01-29 22:28:04", "2026-01-29 22:28:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("801", "21310", "action created", "2026-01-29 22:28:04", "2026-01-29 22:28:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("802", "21298", "action started via WP Cron", "2026-01-29 22:28:04", "2026-01-29 22:28:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("803", "21298", "action complete via WP Cron", "2026-01-29 22:28:04", "2026-01-29 22:28:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("804", "21311", "action created", "2026-01-29 22:28:15", "2026-01-29 22:28:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("805", "21309", "action started via WP Cron", "2026-01-29 23:42:50", "2026-01-29 23:42:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("806", "21312", "action created", "2026-01-29 23:42:50", "2026-01-29 23:42:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("807", "21309", "action complete via WP Cron", "2026-01-29 23:42:50", "2026-01-29 23:42:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("808", "21312", "action started via Async Request", "2026-01-30 04:43:50", "2026-01-30 04:43:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("809", "21313", "action created", "2026-01-30 04:43:50", "2026-01-30 04:43:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("810", "21312", "action complete via Async Request", "2026-01-30 04:43:50", "2026-01-30 04:43:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("811", "21288", "action started via WP Cron", "2026-01-30 05:16:33", "2026-01-30 05:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("812", "21288", "action complete via WP Cron", "2026-01-30 05:16:33", "2026-01-30 05:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("813", "21314", "action created", "2026-01-30 05:16:33", "2026-01-30 05:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("814", "21289", "action started via WP Cron", "2026-01-30 05:16:33", "2026-01-30 05:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("815", "21289", "action complete via WP Cron", "2026-01-30 05:16:33", "2026-01-30 05:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("816", "21315", "action created", "2026-01-30 05:16:33", "2026-01-30 05:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("817", "21290", "action started via WP Cron", "2026-01-30 05:16:33", "2026-01-30 05:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("818", "21290", "action complete via WP Cron", "2026-01-30 05:16:33", "2026-01-30 05:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("819", "21316", "action created", "2026-01-30 05:16:33", "2026-01-30 05:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("820", "21291", "action started via WP Cron", "2026-01-30 05:16:33", "2026-01-30 05:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("821", "21291", "action complete via WP Cron", "2026-01-30 05:16:33", "2026-01-30 05:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("822", "21317", "action created", "2026-01-30 05:16:33", "2026-01-30 05:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("823", "21292", "action started via WP Cron", "2026-01-30 05:16:33", "2026-01-30 05:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("824", "21292", "action complete via WP Cron", "2026-01-30 05:16:33", "2026-01-30 05:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("825", "21318", "action created", "2026-01-30 05:16:33", "2026-01-30 05:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("826", "21293", "action started via WP Cron", "2026-01-30 05:16:33", "2026-01-30 05:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("827", "21293", "action complete via WP Cron", "2026-01-30 05:16:34", "2026-01-30 05:16:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("828", "21319", "action created", "2026-01-30 05:16:34", "2026-01-30 05:16:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("829", "21296", "action started via WP Cron", "2026-01-30 05:16:34", "2026-01-30 05:16:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("831", "21320", "action created", "2026-01-30 05:16:34", "2026-01-30 05:16:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("832", "21321", "action created", "2026-01-30 05:16:34", "2026-01-30 05:16:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("833", "21296", "action complete via WP Cron", "2026-01-30 05:16:34", "2026-01-30 05:16:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("834", "21322", "action created", "2026-01-30 05:16:34", "2026-01-30 05:16:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("835", "21321", "action started via Async Request", "2026-01-30 05:18:59", "2026-01-30 05:18:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("836", "21321", "action complete via Async Request", "2026-01-30 05:18:59", "2026-01-30 05:18:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("837", "21313", "action started via WP Cron", "2026-01-30 05:43:57", "2026-01-30 05:43:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("838", "21323", "action created", "2026-01-30 05:43:57", "2026-01-30 05:43:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("839", "21313", "action complete via WP Cron", "2026-01-30 05:43:57", "2026-01-30 05:43:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("840", "21323", "action started via Async Request", "2026-01-30 06:44:05", "2026-01-30 06:44:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("841", "21324", "action created", "2026-01-30 06:44:05", "2026-01-30 06:44:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("842", "21323", "action complete via Async Request", "2026-01-30 06:44:05", "2026-01-30 06:44:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("843", "21324", "action started via Async Request", "2026-01-30 07:45:44", "2026-01-30 07:45:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("844", "21325", "action created", "2026-01-30 07:45:44", "2026-01-30 07:45:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("845", "21324", "action complete via Async Request", "2026-01-30 07:45:44", "2026-01-30 07:45:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("846", "21325", "action started via Async Request", "2026-01-30 08:47:23", "2026-01-30 08:47:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("847", "21326", "action created", "2026-01-30 08:47:23", "2026-01-30 08:47:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("848", "21325", "action complete via Async Request", "2026-01-30 08:47:23", "2026-01-30 08:47:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("849", "21326", "action started via Async Request", "2026-01-30 09:47:27", "2026-01-30 09:47:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("850", "21327", "action created", "2026-01-30 09:47:27", "2026-01-30 09:47:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("851", "21326", "action complete via Async Request", "2026-01-30 09:47:27", "2026-01-30 09:47:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("852", "21310", "action started via Async Request", "2026-01-30 10:28:06", "2026-01-30 10:28:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("853", "21310", "action complete via Async Request", "2026-01-30 10:28:06", "2026-01-30 10:28:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("854", "21328", "action created", "2026-01-30 10:28:06", "2026-01-30 10:28:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("855", "21311", "action started via Async Request", "2026-01-30 10:30:08", "2026-01-30 10:30:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("856", "21311", "action complete via Async Request", "2026-01-30 10:30:08", "2026-01-30 10:30:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("857", "21329", "action created", "2026-01-30 10:30:09", "2026-01-30 10:30:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("858", "21327", "action started via Async Request", "2026-01-30 11:06:55", "2026-01-30 11:06:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("859", "21330", "action created", "2026-01-30 11:06:55", "2026-01-30 11:06:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("860", "21327", "action complete via Async Request", "2026-01-30 11:06:55", "2026-01-30 11:06:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("861", "21330", "action started via Async Request", "2026-01-30 12:08:32", "2026-01-30 12:08:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("862", "21331", "action created", "2026-01-30 12:08:32", "2026-01-30 12:08:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("863", "21330", "action complete via Async Request", "2026-01-30 12:08:32", "2026-01-30 12:08:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("864", "21331", "action started via Async Request", "2026-01-31 04:47:22", "2026-01-31 04:47:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("865", "21332", "action created", "2026-01-31 04:47:22", "2026-01-31 04:47:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("866", "21331", "action complete via Async Request", "2026-01-31 04:47:22", "2026-01-31 04:47:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("867", "21328", "action started via Async Request", "2026-01-31 04:47:22", "2026-01-31 04:47:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("868", "21328", "action complete via Async Request", "2026-01-31 04:47:22", "2026-01-31 04:47:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("869", "21333", "action created", "2026-01-31 04:47:22", "2026-01-31 04:47:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("870", "21329", "action started via Async Request", "2026-01-31 04:47:22", "2026-01-31 04:47:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("871", "21329", "action complete via Async Request", "2026-01-31 04:47:22", "2026-01-31 04:47:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("872", "21334", "action created", "2026-01-31 04:47:23", "2026-01-31 04:47:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("873", "21314", "action started via Async Request", "2026-01-31 08:56:16", "2026-01-31 08:56:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("874", "21314", "action complete via Async Request", "2026-01-31 08:56:16", "2026-01-31 08:56:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("875", "21335", "action created", "2026-01-31 08:56:16", "2026-01-31 08:56:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("876", "21315", "action started via Async Request", "2026-01-31 08:56:16", "2026-01-31 08:56:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("877", "21315", "action complete via Async Request", "2026-01-31 08:56:16", "2026-01-31 08:56:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("878", "21336", "action created", "2026-01-31 08:56:16", "2026-01-31 08:56:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("879", "21316", "action started via Async Request", "2026-01-31 08:56:16", "2026-01-31 08:56:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("880", "21316", "action complete via Async Request", "2026-01-31 08:56:16", "2026-01-31 08:56:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("881", "21337", "action created", "2026-01-31 08:56:16", "2026-01-31 08:56:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("882", "21317", "action started via Async Request", "2026-01-31 08:56:16", "2026-01-31 08:56:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("883", "21317", "action complete via Async Request", "2026-01-31 08:56:16", "2026-01-31 08:56:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("884", "21338", "action created", "2026-01-31 08:56:16", "2026-01-31 08:56:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("885", "21318", "action started via Async Request", "2026-01-31 08:56:16", "2026-01-31 08:56:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("886", "21318", "action complete via Async Request", "2026-01-31 08:56:16", "2026-01-31 08:56:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("887", "21339", "action created", "2026-01-31 08:56:16", "2026-01-31 08:56:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("888", "21319", "action started via Async Request", "2026-01-31 08:56:16", "2026-01-31 08:56:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("889", "21319", "action complete via Async Request", "2026-01-31 08:56:17", "2026-01-31 08:56:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("890", "21340", "action created", "2026-01-31 08:56:17", "2026-01-31 08:56:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("891", "21332", "action started via Async Request", "2026-01-31 08:56:17", "2026-01-31 08:56:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("892", "21341", "action created", "2026-01-31 08:56:17", "2026-01-31 08:56:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("893", "21332", "action complete via Async Request", "2026-01-31 08:56:17", "2026-01-31 08:56:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("894", "21320", "action started via Async Request", "2026-01-31 08:56:17", "2026-01-31 08:56:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("895", "21320", "action complete via Async Request", "2026-01-31 08:56:17", "2026-01-31 08:56:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("897", "21322", "action started via Async Request", "2026-01-31 08:56:18", "2026-01-31 08:56:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("899", "21343", "action created", "2026-01-31 08:56:18", "2026-01-31 08:56:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("900", "21344", "action created", "2026-01-31 08:56:18", "2026-01-31 08:56:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("901", "21322", "action complete via Async Request", "2026-01-31 08:56:18", "2026-01-31 08:56:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("902", "21345", "action created", "2026-01-31 08:56:18", "2026-01-31 08:56:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("903", "21344", "action started via WP Cron", "2026-01-31 08:57:25", "2026-01-31 08:57:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("904", "21344", "action complete via WP Cron", "2026-01-31 08:57:25", "2026-01-31 08:57:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("915", "21354", "action created", "2026-01-31 09:06:20", "2026-01-31 09:06:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("1075", "21341", "action started via WP Cron", "2026-01-31 09:57:02", "2026-01-31 09:57:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1076", "21409", "action created", "2026-01-31 09:57:02", "2026-01-31 09:57:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1077", "21341", "action complete via WP Cron", "2026-01-31 09:57:02", "2026-01-31 09:57:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1298", "21409", "action started via Async Request", "2026-01-31 10:57:42", "2026-01-31 10:57:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("1299", "21482", "action created", "2026-01-31 10:57:42", "2026-01-31 10:57:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("1300", "21409", "action complete via Async Request", "2026-01-31 10:57:42", "2026-01-31 10:57:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("1520", "21482", "action started via Async Request", "2026-01-31 11:57:58", "2026-01-31 11:57:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1521", "21555", "action created", "2026-01-31 11:57:58", "2026-01-31 11:57:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1522", "21482", "action complete via Async Request", "2026-01-31 11:57:58", "2026-01-31 11:57:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1587", "21576", "action created", "2026-01-31 12:37:44", "2026-01-31 12:37:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1593", "21576", "action started via WP Cron", "2026-01-31 12:39:28", "2026-01-31 12:39:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1594", "21576", "action complete via WP Cron", "2026-01-31 12:39:28", "2026-01-31 12:39:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1615", "21555", "action started via Async Request", "2026-01-31 12:58:06", "2026-01-31 12:58:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1616", "21585", "action created", "2026-01-31 12:58:06", "2026-01-31 12:58:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1617", "21555", "action complete via Async Request", "2026-01-31 12:58:06", "2026-01-31 12:58:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1628", "21585", "action started via Async Request", "2026-02-02 04:52:23", "2026-02-02 04:52:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1629", "21590", "action created", "2026-02-02 04:52:23", "2026-02-02 04:52:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1630", "21585", "action complete via Async Request", "2026-02-02 04:52:23", "2026-02-02 04:52:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1631", "21333", "action started via Async Request", "2026-02-02 04:52:23", "2026-02-02 04:52:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1632", "21333", "action complete via Async Request", "2026-02-02 04:52:23", "2026-02-02 04:52:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1633", "21591", "action created", "2026-02-02 04:52:23", "2026-02-02 04:52:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1634", "21334", "action started via Async Request", "2026-02-02 04:52:23", "2026-02-02 04:52:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1635", "21334", "action complete via Async Request", "2026-02-02 04:52:23", "2026-02-02 04:52:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1636", "21343", "action started via Async Request", "2026-02-02 04:52:23", "2026-02-02 04:52:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1637", "21343", "action complete via Async Request", "2026-02-02 04:52:23", "2026-02-02 04:52:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1639", "21335", "action started via Async Request", "2026-02-02 04:52:23", "2026-02-02 04:52:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1640", "21335", "action complete via Async Request", "2026-02-02 04:52:23", "2026-02-02 04:52:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1641", "21593", "action created", "2026-02-02 04:52:23", "2026-02-02 04:52:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1642", "21336", "action started via Async Request", "2026-02-02 04:52:23", "2026-02-02 04:52:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1643", "21336", "action complete via Async Request", "2026-02-02 04:52:23", "2026-02-02 04:52:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1644", "21594", "action created", "2026-02-02 04:52:23", "2026-02-02 04:52:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1645", "21337", "action started via Async Request", "2026-02-02 04:52:23", "2026-02-02 04:52:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1646", "21337", "action complete via Async Request", "2026-02-02 04:52:23", "2026-02-02 04:52:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1647", "21595", "action created", "2026-02-02 04:52:23", "2026-02-02 04:52:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1648", "21338", "action started via Async Request", "2026-02-02 04:52:23", "2026-02-02 04:52:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1649", "21338", "action complete via Async Request", "2026-02-02 04:52:23", "2026-02-02 04:52:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1650", "21596", "action created", "2026-02-02 04:52:23", "2026-02-02 04:52:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1651", "21339", "action started via Async Request", "2026-02-02 04:52:23", "2026-02-02 04:52:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1652", "21339", "action complete via Async Request", "2026-02-02 04:52:23", "2026-02-02 04:52:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1653", "21597", "action created", "2026-02-02 04:52:23", "2026-02-02 04:52:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1654", "21340", "action started via Async Request", "2026-02-02 04:52:23", "2026-02-02 04:52:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1655", "21598", "action created", "2026-02-02 04:52:24", "2026-02-02 04:52:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("1656", "21340", "action complete via Async Request", "2026-02-02 04:52:24", "2026-02-02 04:52:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("1657", "21599", "action created", "2026-02-02 04:52:24", "2026-02-02 04:52:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("1669", "21345", "action started via Async Request", "2026-02-02 04:53:28", "2026-02-02 04:53:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1672", "21604", "action created", "2026-02-02 04:53:28", "2026-02-02 04:53:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1673", "21345", "action complete via Async Request", "2026-02-02 04:53:28", "2026-02-02 04:53:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1674", "21605", "action created", "2026-02-02 04:53:28", "2026-02-02 04:53:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1675", "21604", "action started via WP Cron", "2026-02-02 04:56:37", "2026-02-02 04:56:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1676", "21604", "action complete via WP Cron", "2026-02-02 04:56:37", "2026-02-02 04:56:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1731", "21590", "action started via WP Cron", "2026-02-02 05:52:38", "2026-02-02 05:52:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("1732", "21624", "action created", "2026-02-02 05:52:38", "2026-02-02 05:52:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("1733", "21590", "action complete via WP Cron", "2026-02-02 05:52:38", "2026-02-02 05:52:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("1827", "21624", "action started via Async Request", "2026-02-02 06:53:55", "2026-02-02 06:53:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1828", "21656", "action created", "2026-02-02 06:53:55", "2026-02-02 06:53:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1829", "21624", "action complete via Async Request", "2026-02-02 06:53:55", "2026-02-02 06:53:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1881", "21656", "action started via Async Request", "2026-02-02 07:54:13", "2026-02-02 07:54:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("1882", "21674", "action created", "2026-02-02 07:54:13", "2026-02-02 07:54:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("1883", "21656", "action complete via Async Request", "2026-02-02 07:54:13", "2026-02-02 07:54:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("1896", "21674", "action started via Async Request", "2026-02-02 08:54:38", "2026-02-02 08:54:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("1897", "21679", "action created", "2026-02-02 08:54:38", "2026-02-02 08:54:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("1898", "21674", "action complete via Async Request", "2026-02-02 08:54:38", "2026-02-02 08:54:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("1908", "21679", "action started via Async Request", "2026-02-02 09:56:35", "2026-02-02 09:56:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1909", "21683", "action created", "2026-02-02 09:56:35", "2026-02-02 09:56:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1910", "21679", "action complete via Async Request", "2026-02-02 09:56:35", "2026-02-02 09:56:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1917", "21683", "action started via WP Cron", "2026-02-02 10:57:08", "2026-02-02 10:57:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1918", "21686", "action created", "2026-02-02 10:57:08", "2026-02-02 10:57:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1919", "21683", "action complete via WP Cron", "2026-02-02 10:57:08", "2026-02-02 10:57:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("1929", "21686", "action started via Async Request", "2026-02-02 11:57:54", "2026-02-02 11:57:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("1930", "21690", "action created", "2026-02-02 11:57:54", "2026-02-02 11:57:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("1931", "21686", "action complete via Async Request", "2026-02-02 11:57:54", "2026-02-02 11:57:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("1977", "21690", "action started via WP Cron", "2026-02-02 14:46:27", "2026-02-02 14:46:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1978", "21706", "action created", "2026-02-02 14:46:27", "2026-02-02 14:46:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1979", "21690", "action complete via WP Cron", "2026-02-02 14:46:27", "2026-02-02 14:46:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1992", "21706", "action started via WP Cron", "2026-02-02 15:47:18", "2026-02-02 15:47:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1993", "21711", "action created", "2026-02-02 15:47:18", "2026-02-02 15:47:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1994", "21706", "action complete via WP Cron", "2026-02-02 15:47:18", "2026-02-02 15:47:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("2001", "21711", "action started via WP Cron", "2026-02-03 04:48:25", "2026-02-03 04:48:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2002", "21714", "action created", "2026-02-03 04:48:25", "2026-02-03 04:48:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2003", "21711", "action complete via WP Cron", "2026-02-03 04:48:25", "2026-02-03 04:48:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2004", "21591", "action started via WP Cron", "2026-02-03 04:48:25", "2026-02-03 04:48:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2005", "21591", "action complete via WP Cron", "2026-02-03 04:48:25", "2026-02-03 04:48:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2006", "21715", "action created", "2026-02-03 04:48:25", "2026-02-03 04:48:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2007", "21598", "action started via WP Cron", "2026-02-03 04:48:25", "2026-02-03 04:48:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2008", "21598", "action complete via WP Cron", "2026-02-03 04:48:25", "2026-02-03 04:48:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2011", "21716", "action created", "2026-02-03 04:48:25", "2026-02-03 04:48:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2012", "21717", "action created", "2026-02-03 04:48:29", "2026-02-03 04:48:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("2016", "21593", "action started via WP Cron", "2026-02-03 04:52:35", "2026-02-03 04:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2017", "21593", "action complete via WP Cron", "2026-02-03 04:52:35", "2026-02-03 04:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2018", "21719", "action created", "2026-02-03 04:52:35", "2026-02-03 04:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2019", "21594", "action started via WP Cron", "2026-02-03 04:52:35", "2026-02-03 04:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2020", "21594", "action complete via WP Cron", "2026-02-03 04:52:35", "2026-02-03 04:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2021", "21720", "action created", "2026-02-03 04:52:35", "2026-02-03 04:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2022", "21595", "action started via WP Cron", "2026-02-03 04:52:35", "2026-02-03 04:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2023", "21595", "action complete via WP Cron", "2026-02-03 04:52:35", "2026-02-03 04:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2024", "21721", "action created", "2026-02-03 04:52:35", "2026-02-03 04:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2025", "21596", "action started via WP Cron", "2026-02-03 04:52:35", "2026-02-03 04:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2026", "21596", "action complete via WP Cron", "2026-02-03 04:52:35", "2026-02-03 04:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2027", "21722", "action created", "2026-02-03 04:52:35", "2026-02-03 04:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2028", "21597", "action started via WP Cron", "2026-02-03 04:52:35", "2026-02-03 04:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2029", "21597", "action complete via WP Cron", "2026-02-03 04:52:35", "2026-02-03 04:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2030", "21723", "action created", "2026-02-03 04:52:35", "2026-02-03 04:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2031", "21599", "action started via WP Cron", "2026-02-03 04:52:35", "2026-02-03 04:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2032", "21599", "action complete via WP Cron", "2026-02-03 04:52:36", "2026-02-03 04:52:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("2033", "21724", "action created", "2026-02-03 04:52:36", "2026-02-03 04:52:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("2043", "21605", "action started via WP Cron", "2026-02-03 04:54:27", "2026-02-03 04:54:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("2046", "21729", "action created", "2026-02-03 04:54:27", "2026-02-03 04:54:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("2047", "21605", "action complete via WP Cron", "2026-02-03 04:54:27", "2026-02-03 04:54:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("2048", "21730", "action created", "2026-02-03 04:54:27", "2026-02-03 04:54:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("2049", "21729", "action started via Async Request", "2026-02-03 04:54:55", "2026-02-03 04:54:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2050", "21729", "action complete via Async Request", "2026-02-03 04:54:55", "2026-02-03 04:54:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2129", "21714", "action started via WP Cron", "2026-02-03 05:48:26", "2026-02-03 05:48:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2130", "21757", "action created", "2026-02-03 05:48:26", "2026-02-03 05:48:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2131", "21714", "action complete via WP Cron", "2026-02-03 05:48:26", "2026-02-03 05:48:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2240", "21757", "action started via WP Cron", "2026-02-03 06:48:32", "2026-02-03 06:48:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2241", "21794", "action created", "2026-02-03 06:48:32", "2026-02-03 06:48:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2242", "21757", "action complete via WP Cron", "2026-02-03 06:48:32", "2026-02-03 06:48:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2255", "21794", "action started via Async Request", "2026-02-03 07:49:54", "2026-02-03 07:49:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("2256", "21799", "action created", "2026-02-03 07:49:54", "2026-02-03 07:49:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("2257", "21794", "action complete via Async Request", "2026-02-03 07:49:54", "2026-02-03 07:49:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("2267", "21799", "action started via Async Request", "2026-02-03 08:50:49", "2026-02-03 08:50:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("2268", "21803", "action created", "2026-02-03 08:50:49", "2026-02-03 08:50:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("2269", "21799", "action complete via Async Request", "2026-02-03 08:50:49", "2026-02-03 08:50:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("2276", "21803", "action started via Async Request", "2026-02-03 12:00:08", "2026-02-03 12:00:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2277", "21806", "action created", "2026-02-03 12:00:08", "2026-02-03 12:00:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2278", "21803", "action complete via Async Request", "2026-02-03 12:00:08", "2026-02-03 12:00:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2357", "21806", "action started via Async Request", "2026-02-03 13:02:04", "2026-02-03 13:02:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2358", "21833", "action created", "2026-02-03 13:02:04", "2026-02-03 13:02:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2359", "21806", "action complete via Async Request", "2026-02-03 13:02:04", "2026-02-03 13:02:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2369", "21833", "action started via WP Cron", "2026-02-03 17:36:11", "2026-02-03 17:36:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2370", "21837", "action created", "2026-02-03 17:36:11", "2026-02-03 17:36:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2371", "21833", "action complete via WP Cron", "2026-02-03 17:36:11", "2026-02-03 17:36:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2372", "21715", "action started via WP Cron", "2026-02-03 17:36:11", "2026-02-03 17:36:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2373", "21715", "action complete via WP Cron", "2026-02-03 17:36:11", "2026-02-03 17:36:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2374", "21838", "action created", "2026-02-03 17:36:11", "2026-02-03 17:36:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2375", "21717", "action started via WP Cron", "2026-02-03 17:36:11", "2026-02-03 17:36:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2376", "21717", "action complete via WP Cron", "2026-02-03 17:36:11", "2026-02-03 17:36:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2377", "21839", "action created", "2026-02-03 17:36:14", "2026-02-03 17:36:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2381", "21837", "action started via WP Cron", "2026-02-04 04:52:08", "2026-02-04 04:52:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2382", "21841", "action created", "2026-02-04 04:52:08", "2026-02-04 04:52:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2383", "21837", "action complete via WP Cron", "2026-02-04 04:52:08", "2026-02-04 04:52:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2386", "21842", "action created", "2026-02-04 04:52:08", "2026-02-04 04:52:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2387", "21719", "action started via WP Cron", "2026-02-04 05:11:28", "2026-02-04 05:11:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2388", "21719", "action complete via WP Cron", "2026-02-04 05:11:28", "2026-02-04 05:11:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2389", "21843", "action created", "2026-02-04 05:11:28", "2026-02-04 05:11:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2390", "21720", "action started via WP Cron", "2026-02-04 05:11:28", "2026-02-04 05:11:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2391", "21720", "action complete via WP Cron", "2026-02-04 05:11:28", "2026-02-04 05:11:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2392", "21844", "action created", "2026-02-04 05:11:28", "2026-02-04 05:11:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2393", "21721", "action started via WP Cron", "2026-02-04 05:11:28", "2026-02-04 05:11:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2394", "21721", "action complete via WP Cron", "2026-02-04 05:11:28", "2026-02-04 05:11:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2395", "21845", "action created", "2026-02-04 05:11:28", "2026-02-04 05:11:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2396", "21722", "action started via WP Cron", "2026-02-04 05:11:28", "2026-02-04 05:11:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2397", "21722", "action complete via WP Cron", "2026-02-04 05:11:29", "2026-02-04 05:11:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("2398", "21846", "action created", "2026-02-04 05:11:29", "2026-02-04 05:11:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("2399", "21723", "action started via WP Cron", "2026-02-04 05:11:29", "2026-02-04 05:11:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("2400", "21723", "action complete via WP Cron", "2026-02-04 05:11:29", "2026-02-04 05:11:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("2401", "21847", "action created", "2026-02-04 05:11:29", "2026-02-04 05:11:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("2402", "21724", "action started via WP Cron", "2026-02-04 05:11:29", "2026-02-04 05:11:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("2403", "21724", "action complete via WP Cron", "2026-02-04 05:11:30", "2026-02-04 05:11:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("2404", "21848", "action created", "2026-02-04 05:11:30", "2026-02-04 05:11:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("2407", "21849", "action created", "2026-02-04 05:11:30", "2026-02-04 05:11:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("2410", "21850", "action created", "2026-02-04 05:11:30", "2026-02-04 05:11:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("2414", "21852", "action created", "2026-02-04 05:12:27", "2026-02-04 05:12:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("2420", "21730", "action started via WP Cron", "2026-02-04 05:12:29", "2026-02-04 05:12:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("2423", "21855", "action created", "2026-02-04 05:12:29", "2026-02-04 05:12:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("2424", "21730", "action complete via WP Cron", "2026-02-04 05:12:29", "2026-02-04 05:12:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("2425", "21856", "action created", "2026-02-04 05:12:29", "2026-02-04 05:12:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("2426", "21855", "action started via WP Cron", "2026-02-04 05:13:25", "2026-02-04 05:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2427", "21855", "action complete via WP Cron", "2026-02-04 05:13:25", "2026-02-04 05:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2434", "21838", "action started via Async Request", "2026-02-04 05:36:50", "2026-02-04 05:36:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("2435", "21838", "action complete via Async Request", "2026-02-04 05:36:50", "2026-02-04 05:36:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("2436", "21859", "action created", "2026-02-04 05:36:50", "2026-02-04 05:36:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("2437", "21839", "action started via Async Request", "2026-02-04 05:36:50", "2026-02-04 05:36:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("2438", "21839", "action complete via Async Request", "2026-02-04 05:36:50", "2026-02-04 05:36:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("2439", "21860", "action created", "2026-02-04 05:36:50", "2026-02-04 05:36:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("2443", "21841", "action started via Async Request", "2026-02-04 05:56:59", "2026-02-04 05:56:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2444", "21862", "action created", "2026-02-04 05:56:59", "2026-02-04 05:56:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2445", "21841", "action complete via Async Request", "2026-02-04 05:56:59", "2026-02-04 05:56:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2503", "21862", "action started via Async Request", "2026-02-04 06:57:58", "2026-02-04 06:57:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("2504", "21882", "action created", "2026-02-04 06:57:58", "2026-02-04 06:57:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("2505", "21862", "action complete via Async Request", "2026-02-04 06:57:58", "2026-02-04 06:57:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("2578", "21882", "action started via Async Request", "2026-02-04 08:00:44", "2026-02-04 08:00:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("2579", "21907", "action created", "2026-02-04 08:00:44", "2026-02-04 08:00:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("2580", "21882", "action complete via Async Request", "2026-02-04 08:00:44", "2026-02-04 08:00:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("2605", "21907", "action started via Async Request", "2026-02-04 09:02:14", "2026-02-04 09:02:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2606", "21916", "action created", "2026-02-04 09:02:14", "2026-02-04 09:02:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2607", "21907", "action complete via Async Request", "2026-02-04 09:02:14", "2026-02-04 09:02:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2611", "21916", "action started via Async Request", "2026-02-04 10:20:00", "2026-02-04 10:20:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("2612", "21918", "action created", "2026-02-04 10:20:00", "2026-02-04 10:20:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("2613", "21916", "action complete via Async Request", "2026-02-04 10:20:00", "2026-02-04 10:20:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("2620", "21918", "action started via WP Cron", "2026-02-04 12:35:18", "2026-02-04 12:35:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("2621", "21921", "action created", "2026-02-04 12:35:18", "2026-02-04 12:35:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("2622", "21918", "action complete via WP Cron", "2026-02-04 12:35:18", "2026-02-04 12:35:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("2629", "21921", "action started via WP Cron", "2026-02-04 14:58:18", "2026-02-04 14:58:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("2630", "21924", "action created", "2026-02-04 14:58:18", "2026-02-04 14:58:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("2631", "21921", "action complete via WP Cron", "2026-02-04 14:58:18", "2026-02-04 14:58:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("2633", "21925", "action created", "2026-02-04 15:45:48", "2026-02-04 15:45:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("2635", "21924", "action started via WP Cron", "2026-02-05 05:12:25", "2026-02-05 05:12:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2636", "21926", "action created", "2026-02-05 05:12:25", "2026-02-05 05:12:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2637", "21924", "action complete via WP Cron", "2026-02-05 05:12:25", "2026-02-05 05:12:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2638", "21925", "action started via WP Cron", "2026-02-05 05:12:25", "2026-02-05 05:12:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2639", "21927", "action created", "2026-02-05 05:12:25", "2026-02-05 05:12:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2640", "21925", "action complete via WP Cron", "2026-02-05 05:12:25", "2026-02-05 05:12:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2641", "21859", "action started via WP Cron", "2026-02-05 05:12:25", "2026-02-05 05:12:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2642", "21859", "action complete via WP Cron", "2026-02-05 05:12:25", "2026-02-05 05:12:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2643", "21928", "action created", "2026-02-05 05:12:25", "2026-02-05 05:12:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2644", "21860", "action started via WP Cron", "2026-02-05 05:12:25", "2026-02-05 05:12:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2645", "21860", "action complete via WP Cron", "2026-02-05 05:12:25", "2026-02-05 05:12:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2646", "21843", "action started via WP Cron", "2026-02-05 05:12:25", "2026-02-05 05:12:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2647", "21843", "action complete via WP Cron", "2026-02-05 05:12:25", "2026-02-05 05:12:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2648", "21929", "action created", "2026-02-05 05:12:25", "2026-02-05 05:12:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2649", "21844", "action started via WP Cron", "2026-02-05 05:12:25", "2026-02-05 05:12:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2650", "21844", "action complete via WP Cron", "2026-02-05 05:12:25", "2026-02-05 05:12:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2651", "21930", "action created", "2026-02-05 05:12:25", "2026-02-05 05:12:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2652", "21845", "action started via WP Cron", "2026-02-05 05:12:25", "2026-02-05 05:12:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2653", "21845", "action complete via WP Cron", "2026-02-05 05:12:25", "2026-02-05 05:12:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2654", "21931", "action created", "2026-02-05 05:12:25", "2026-02-05 05:12:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2655", "21846", "action started via WP Cron", "2026-02-05 05:12:25", "2026-02-05 05:12:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2656", "21846", "action complete via WP Cron", "2026-02-05 05:12:26", "2026-02-05 05:12:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2657", "21932", "action created", "2026-02-05 05:12:26", "2026-02-05 05:12:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2658", "21847", "action started via WP Cron", "2026-02-05 05:12:26", "2026-02-05 05:12:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2659", "21847", "action complete via WP Cron", "2026-02-05 05:12:26", "2026-02-05 05:12:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2660", "21933", "action created", "2026-02-05 05:12:26", "2026-02-05 05:12:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2661", "21848", "action started via WP Cron", "2026-02-05 05:12:26", "2026-02-05 05:12:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2662", "21848", "action complete via WP Cron", "2026-02-05 05:12:27", "2026-02-05 05:12:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("2663", "21934", "action created", "2026-02-05 05:12:27", "2026-02-05 05:12:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("2664", "21849", "action started via WP Cron", "2026-02-05 05:12:27", "2026-02-05 05:12:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("2665", "21935", "action created", "2026-02-05 05:12:27", "2026-02-05 05:12:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("2666", "21849", "action complete via WP Cron", "2026-02-05 05:12:27", "2026-02-05 05:12:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("2667", "21936", "action created", "2026-02-05 05:12:27", "2026-02-05 05:12:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("2668", "21850", "action started via WP Cron", "2026-02-05 05:12:27", "2026-02-05 05:12:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("2669", "21850", "action complete via WP Cron", "2026-02-05 05:12:27", "2026-02-05 05:12:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("2670", "21937", "action created", "2026-02-05 05:12:27", "2026-02-05 05:12:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("2671", "21852", "action started via WP Cron", "2026-02-05 05:12:27", "2026-02-05 05:12:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("2672", "21938", "action created", "2026-02-05 05:12:28", "2026-02-05 05:12:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2673", "21852", "action complete via WP Cron", "2026-02-05 05:12:39", "2026-02-05 05:12:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("2674", "21939", "action created", "2026-02-05 05:12:39", "2026-02-05 05:12:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("2675", "21935", "action started via WP Cron", "2026-02-05 05:12:39", "2026-02-05 05:12:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("2676", "21935", "action complete via WP Cron", "2026-02-05 05:12:39", "2026-02-05 05:12:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("2677", "21856", "action started via WP Cron", "2026-02-05 05:12:39", "2026-02-05 05:12:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("2679", "21940", "action created", "2026-02-05 05:12:39", "2026-02-05 05:12:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("2680", "21941", "action created", "2026-02-05 05:12:39", "2026-02-05 05:12:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("2681", "21856", "action complete via WP Cron", "2026-02-05 05:12:39", "2026-02-05 05:12:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("2682", "21942", "action created", "2026-02-05 05:12:39", "2026-02-05 05:12:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("2683", "21941", "action started via WP Cron", "2026-02-05 05:15:29", "2026-02-05 05:15:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("2684", "21941", "action complete via WP Cron", "2026-02-05 05:15:29", "2026-02-05 05:15:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("2685", "21927", "action started via Async Request", "2026-02-05 05:27:46", "2026-02-05 05:27:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("2686", "21943", "action created", "2026-02-05 05:27:46", "2026-02-05 05:27:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("2687", "21927", "action complete via Async Request", "2026-02-05 05:27:46", "2026-02-05 05:27:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("2688", "21943", "action started via WP Cron", "2026-02-05 05:42:55", "2026-02-05 05:42:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2689", "21944", "action created", "2026-02-05 05:42:55", "2026-02-05 05:42:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2690", "21943", "action complete via WP Cron", "2026-02-05 05:42:55", "2026-02-05 05:42:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2691", "21944", "action started via Async Request", "2026-02-05 05:59:00", "2026-02-05 05:59:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("2692", "21945", "action created", "2026-02-05 05:59:00", "2026-02-05 05:59:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("2693", "21944", "action complete via Async Request", "2026-02-05 05:59:00", "2026-02-05 05:59:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("2694", "21926", "action started via Async Request", "2026-02-05 06:13:05", "2026-02-05 06:13:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("2695", "21946", "action created", "2026-02-05 06:13:05", "2026-02-05 06:13:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("2696", "21926", "action complete via Async Request", "2026-02-05 06:13:05", "2026-02-05 06:13:05");

/* INSERT TABLE DATA: wp_aioseo_cache */
INSERT INTO `wp_aioseo_cache` VALUES("2", "db_schema", "{\"wp_posts\":[\"ID\",\"post_author\",\"post_date\",\"post_date_gmt\",\"post_content\",\"post_title\",\"post_excerpt\",\"post_status\",\"comment_status\",\"ping_status\",\"post_password\",\"post_name\",\"to_ping\",\"pinged\",\"post_modified\",\"post_modified_gmt\",\"post_content_filtered\",\"post_parent\",\"guid\",\"menu_order\",\"post_type\",\"post_mime_type\",\"comment_count\"],\"wp_options\":[\"option_id\",\"option_name\",\"option_value\",\"autoload\"],\"wp_give_sequential_ordering\":[\"id\",\"payment_id\"],\"wp_woocommerce_tax_rate_locations\":[\"location_id\",\"location_code\",\"tax_rate_id\",\"location_type\"],\"wp_woocommerce_payment_tokenmeta\":[\"meta_id\",\"payment_token_id\",\"meta_key\",\"meta_value\"],\"wp_wc_order_stats\":[\"order_id\",\"parent_id\",\"date_created\",\"date_created_gmt\",\"date_paid\",\"date_completed\",\"num_items_sold\",\"total_sales\",\"tax_total\",\"shipping_total\",\"net_total\",\"returning_customer\",\"status\",\"customer_id\"],\"wp_give_campaigns\":[\"id\",\"campaign_page_id\",\"form_id\",\"campaign_type\",\"campaign_title\",\"campaign_url\",\"short_desc\",\"long_desc\",\"campaign_logo\",\"campaign_image\",\"primary_color\",\"secondary_color\",\"campaign_goal\",\"goal_type\",\"status\",\"start_date\",\"end_date\",\"date_created\"],\"wp_trp_gettext_en_us\":[\"id\",\"original\",\"translated\",\"domain\",\"status\",\"original_id\",\"plural_form\"],\"wp_give_donors\":[\"id\",\"user_id\",\"email\",\"name\",\"phone\",\"purchase_value\",\"purchase_count\",\"payment_ids\",\"date_created\",\"token\",\"verify_key\",\"verify_throttle\"],\"wp_wc_order_coupon_lookup\":[\"order_id\",\"coupon_id\",\"date_created\",\"discount_amount\"],\"wp_terms\":[\"term_id\",\"name\",\"slug\",\"term_group\"],\"wp_aioseo_writing_assistant_posts\":[\"id\",\"post_id\",\"keyword_id\",\"content_analysis_hash\",\"content_analysis\",\"created\",\"updated\"],\"wp_give_subscriptions\":[\"id\",\"customer_id\",\"period\",\"frequency\",\"initial_amount\",\"recurring_amount\",\"recurring_fee_amount\",\"bill_times\",\"transaction_id\",\"parent_payment_id\",\"payment_mode\",\"product_id\",\"created\",\"expiration\",\"status\",\"profile_id\",\"notes\",\"campaign_id\"],\"wp_wc_category_lookup\":[\"category_tree_id\",\"category_id\"],\"wp_e_events\":[\"id\",\"event_data\",\"created_at\"],\"wp_termmeta\":[\"meta_id\",\"term_id\",\"meta_key\",\"meta_value\"],\"wp_woocommerce_order_items\":[\"order_item_id\",\"order_item_name\",\"order_item_type\",\"order_id\"],\"wp_woocommerce_downloadable_product_permissions\":[\"permission_id\",\"download_id\",\"product_id\",\"order_id\",\"order_key\",\"user_email\",\"user_id\",\"downloads_remaining\",\"access_granted\",\"access_expires\",\"download_count\"],\"wp_tec_occurrences\":[\"occurrence_id\",\"event_id\",\"post_id\",\"start_date\",\"start_date_utc\",\"end_date\",\"end_date_utc\",\"duration\",\"hash\",\"updated_at\"],\"wp_wc_product_attributes_lookup\":[\"product_id\",\"product_or_parent_id\",\"taxonomy\",\"term_id\",\"is_variation_attribute\",\"in_stock\"],\"wp_woocommerce_attribute_taxonomies\":[\"attribute_id\",\"attribute_name\",\"attribute_label\",\"attribute_type\",\"attribute_orderby\",\"attribute_public\"],\"wp_woocommerce_shipping_zone_methods\":[\"zone_id\",\"instance_id\",\"method_id\",\"method_order\",\"is_enabled\"],\"wp_actionscheduler_groups\":[\"group_id\",\"slug\"],\"wp_term_relationships\":[\"object_id\",\"term_taxonomy_id\",\"term_order\"],\"wp_actionscheduler_logs\":[\"log_id\",\"action_id\",\"message\",\"log_date_gmt\",\"log_date_local\"],\"wp_aioseo_writing_assistant_keywords\":[\"id\",\"uuid\",\"keyword\",\"country\",\"language\",\"progress\",\"keywords\",\"competitors\",\"created\",\"updated\"],\"wp_actionscheduler_actions\":[\"action_id\",\"hook\",\"status\",\"scheduled_date_gmt\",\"scheduled_date_local\",\"priority\",\"args\",\"schedule\",\"group_id\",\"attempts\",\"last_attempt_gmt\",\"last_attempt_local\",\"claim_id\",\"extended_args\"],\"wp_tec_events\":[\"event_id\",\"post_id\",\"start_date\",\"end_date\",\"timezone\",\"start_date_utc\",\"end_date_utc\",\"duration\",\"updated_at\",\"hash\"],\"wp_trustindex_google_views\":[\"date\",\"viewed\"],\"wp_give_subscriptionmeta\":[\"meta_id\",\"subscription_id\",\"meta_key\",\"meta_value\"],\"wp_wc_product_download_directories\":[\"url_id\",\"url\",\"enabled\"],\"wp_give_formmeta\":[\"meta_id\",\"form_id\",\"meta_key\",\"meta_value\"],\"wp_give_commentmeta\":[\"meta_id\",\"give_comment_id\",\"meta_key\",\"meta_value\"],\"wp_give_revenue\":[\"id\",\"donation_id\",\"form_id\",\"amount\",\"campaign_id\"],\"wp_wc_webhooks\":[\"webhook_id\",\"status\",\"name\",\"user_id\",\"delivery_url\",\"secret\",\"topic\",\"date_created\",\"date_created_gmt\",\"date_modified\",\"date_modified_gmt\",\"api_version\",\"failure_count\",\"pending_delivery\"],\"wp_yith_wcwl\":[\"ID\",\"prod_id\",\"quantity\",\"user_id\",\"wishlist_id\",\"position\",\"original_price\",\"original_currency\",\"dateadded\",\"on_sale\"],\"wp_woocommerce_shipping_zone_locations\":[\"location_id\",\"zone_id\",\"location_code\",\"location_type\"],\"wp_woocommerce_api_keys\":[\"key_id\",\"user_id\",\"description\",\"permissions\",\"consumer_key\",\"consumer_secret\",\"nonces\",\"truncated_key\",\"last_access\"],\"wp_woocommerce_tax_rates\":[\"tax_rate_id\",\"tax_rate_country\",\"tax_rate_state\",\"tax_rate\",\"tax_rate_name\",\"tax_rate_priority\",\"tax_rate_compound\",\"tax_rate_shipping\",\"tax_rate_order\",\"tax_rate_class\"],\"wp_woocommerce_order_itemmeta\":[\"meta_id\",\"order_item_id\",\"meta_key\",\"meta_value\"],\"wp_comments\":[\"comment_ID\",\"comment_post_ID\",\"comment_author\",\"comment_author_email\",\"comment_author_url\",\"comment_author_IP\",\"comment_date\",\"comment_date_gmt\",\"comment_content\",\"comment_karma\",\"comment_approved\",\"comment_agent\",\"comment_type\",\"comment_parent\",\"user_id\"],\"wp_aioseo_crawl_cleanup_logs\":[\"id\",\"slug\",\"key\",\"value\",\"hash\",\"hits\",\"created\",\"updated\"],\"wp_shepherd_tec_tasks\":[\"id\",\"action_id\",\"class_hash\",\"args_hash\",\"data\",\"current_try\"],\"wp_usermeta\":[\"umeta_id\",\"user_id\",\"meta_key\",\"meta_value\"],\"wp_trustindex_google_reviews\":[\"id\",\"hidden\",\"user\",\"user_photo\",\"text\",\"rating\",\"highlight\",\"date\",\"reviewId\",\"reply\"],\"wp_litespeed_url\":[\"id\",\"url\",\"cache_tags\"],\"wp_give_sessions\":[\"session_id\",\"session_key\",\"session_value\",\"session_expiry\"],\"wp_wc_order_operational_data\":[\"id\",\"order_id\",\"created_via\",\"woocommerce_version\",\"prices_include_tax\",\"coupon_usages_are_counted\",\"download_permission_granted\",\"cart_hash\",\"new_order_email_sent\",\"order_key\",\"order_stock_reduced\",\"date_paid_gmt\",\"date_completed_gmt\",\"shipping_tax_amount\",\"shipping_total_amount\",\"discount_tax_amount\",\"discount_total_amount\",\"recorded_sales\"],\"wp_wc_admin_notes\":[\"note_id\",\"name\",\"type\",\"locale\",\"title\",\"content\",\"content_data\",\"status\",\"source\",\"date_created\",\"date_reminder\",\"is_snoozable\",\"layout\",\"image\",\"is_deleted\",\"is_read\",\"icon\"],\"wp_aioseo_posts\":[\"id\",\"post_id\",\"title\",\"description\",\"keywords\",\"keyphrases\",\"page_analysis\",\"primary_term\",\"canonical_url\",\"og_title\",\"og_description\",\"og_object_type\",\"og_image_type\",\"og_image_url\",\"og_image_width\",\"og_image_height\",\"og_image_custom_url\",\"og_image_custom_fields\",\"og_video\",\"og_custom_url\",\"og_article_section\",\"og_article_tags\",\"twitter_use_og\",\"twitter_card\",\"twitter_image_type\",\"twitter_image_url\",\"twitter_image_custom_url\",\"twitter_image_custom_fields\",\"twitter_title\",\"twitter_description\",\"seo_score\",\"schema\",\"schema_type\",\"schema_type_options\",\"pillar_content\",\"robots_default\",\"robots_noindex\",\"robots_noarchive\",\"robots_nosnippet\",\"robots_nofollow\",\"robots_noimageindex\",\"robots_noodp\",\"robots_notranslate\",\"robots_max_snippet\",\"robots_max_videopreview\",\"robots_max_imagepreview\",\"images\",\"image_scan_date\",\"priority\",\"frequency\",\"videos\",\"video_thumbnail\",\"video_scan_date\",\"local_seo\",\"breadcrumb_settings\",\"limit_modified_date\",\"options\",\"ai\",\"created\",\"updated\"],\"wp_yith_wcwl_itemmeta\":[\"meta_id\",\"yith_wcwl_item_id\",\"meta_key\",\"meta_value\"],\"wp_aioseo_ai_insights_keyword_reports\":[\"id\",\"uuid\",\"keyword\",\"status\",\"brands\",\"brands_mentioned\",\"results\",\"created\",\"updated\"],\"wp_give_donationmeta\":[\"meta_id\",\"donation_id\",\"meta_key\",\"meta_value\"],\"wp_litespeed_url_file\":[\"id\",\"url_id\",\"vary\",\"filename\",\"type\",\"mobile\",\"webp\",\"expired\"],\"wp_wc_download_log\":[\"download_log_id\",\"timestamp\",\"permission_id\",\"user_id\",\"user_ip_address\"],\"wp_term_taxonomy\":[\"term_taxonomy_id\",\"term_id\",\"taxonomy\",\"description\",\"parent\",\"count\"],\"wp_woocommerce_shipping_zones\":[\"zone_id\",\"zone_name\",\"zone_order\"],\"wp_aioseo_seo_analyzer_results\":[\"id\",\"data\",\"score\",\"competitor_url\",\"created\",\"updated\"],\"wp_wc_order_product_lookup\":[\"order_item_id\",\"order_id\",\"product_id\",\"variation_id\",\"customer_id\",\"date_created\",\"product_qty\",\"product_net_revenue\",\"product_gross_revenue\",\"coupon_amount\",\"tax_amount\",\"shipping_amount\",\"shipping_tax_amount\"],\"wp_wc_order_addresses\":[\"id\",\"order_id\",\"address_type\",\"first_name\",\"last_name\",\"company\",\"address_1\",\"address_2\",\"city\",\"state\",\"postcode\",\"country\",\"email\",\"phone\"],\"wp_users\":[\"ID\",\"user_login\",\"user_pass\",\"user_nicename\",\"user_email\",\"user_url\",\"user_registered\",\"user_activation_key\",\"user_status\",\"display_name\"],\"wp_actionscheduler_claims\":[\"claim_id\",\"date_created_gmt\"],\"wp_trp_gettext_original_strings\":[\"id\",\"original\",\"domain\",\"context\",\"original_plural\"],\"wp_give_migrations\":[\"id\",\"status\",\"error\",\"last_run\"],\"wp_woocommerce_payment_tokens\":[\"token_id\",\"gateway_id\",\"token\",\"user_id\",\"type\",\"is_default\"],\"wp_commentmeta\":[\"meta_id\",\"comment_id\",\"meta_key\",\"meta_value\"],\"wp_links\":[\"link_id\",\"link_url\",\"link_name\",\"link_image\",\"link_target\",\"link_description\",\"link_visible\",\"link_owner\",\"link_rating\",\"link_updated\",\"link_rel\",\"link_notes\",\"link_rss\"],\"wp_wc_order_tax_lookup\":[\"order_id\",\"tax_rate_id\",\"date_created\",\"shipping_tax\",\"order_tax\",\"total_tax\"],\"wp_wc_admin_note_actions\":[\"action_id\",\"note_id\",\"name\",\"label\",\"query\",\"status\",\"actioned_text\",\"nonce_action\",\"nonce_name\"],\"wp_wc_customer_lookup\":[\"customer_id\",\"user_id\",\"username\",\"first_name\",\"last_name\",\"email\",\"date_last_active\",\"date_registered\",\"country\",\"postcode\",\"city\",\"state\"],\"wp_wc_orders_meta\":[\"id\",\"order_id\",\"meta_key\",\"meta_value\"],\"wp_woocommerce_sessions\":[\"session_id\",\"session_key\",\"session_value\",\"session_expiry\"],\"wp_aioseo_crawl_cleanup_blocked_args\":[\"id\",\"key\",\"value\",\"key_value_hash\",\"regex\",\"hits\",\"created\",\"updated\"],\"wp_aioseo_notifications\":[\"id\",\"slug\",\"addon\",\"title\",\"content\",\"type\",\"level\",\"notification_id\",\"notification_name\",\"start\",\"end\",\"button1_label\",\"button1_action\",\"button2_label\",\"button2_action\",\"dismissed\",\"new\",\"created\",\"updated\"],\"wp_wc_reserved_stock\":[\"order_id\",\"product_id\",\"stock_quantity\",\"timestamp\",\"expires\"],\"wp_wc_tax_rate_classes\":[\"tax_rate_class_id\",\"name\",\"slug\"],\"wp_wc_rate_limits\":[\"rate_limit_id\",\"rate_limit_key\",\"rate_limit_expiry\",\"rate_limit_remaining\"],\"wp_give_comments\":[\"comment_ID\",\"user_id\",\"comment_content\",\"comment_parent\",\"comment_type\",\"comment_date\",\"comment_date_gmt\"],\"wp_aioseo_cache\":[\"id\",\"key\",\"value\",\"is_object\",\"expiration\",\"created\",\"updated\"],\"wp_yith_wcwl_lists\":[\"ID\",\"user_id\",\"session_id\",\"wishlist_slug\",\"wishlist_name\",\"wishlist_token\",\"wishlist_privacy\",\"is_default\",\"dateadded\",\"expiration\"],\"wp_wc_orders\":[\"id\",\"status\",\"currency\",\"type\",\"tax_amount\",\"total_amount\",\"customer_id\",\"billing_email\",\"date_created_gmt\",\"date_updated_gmt\",\"parent_order_id\",\"payment_method\",\"payment_method_title\",\"transaction_id\",\"ip_address\",\"user_agent\",\"customer_note\"],\"wp_give_log\":[\"id\",\"log_type\",\"data\",\"category\",\"source\",\"date\"],\"wp_postmeta\":[\"meta_id\",\"post_id\",\"meta_key\",\"meta_value\"],\"wp_trp_gettext_original_meta\":[\"meta_id\",\"original_id\",\"meta_key\",\"meta_value\"],\"wp_give_campaign_forms\":[\"campaign_id\",\"form_id\"],\"wp_woocommerce_log\":[\"log_id\",\"timestamp\",\"level\",\"source\",\"message\",\"context\"],\"wp_wc_product_meta_lookup\":[\"product_id\",\"sku\",\"global_unique_id\",\"virtual\",\"downloadable\",\"min_price\",\"max_price\",\"onsale\",\"stock_quantity\",\"stock_status\",\"rating_count\",\"average_rating\",\"total_sales\",\"tax_status\",\"tax_class\"],\"wp_give_donormeta\":[\"meta_id\",\"donor_id\",\"meta_key\",\"meta_value\"],\"wp_tec_kv_cache\":[\"cache_key\",\"value\",\"expiration\"]}", "0", "2026-02-06 05:11:31", "2026-01-31 09:06:20", "2026-02-05 05:11:31");
INSERT INTO `wp_aioseo_cache` VALUES("3", "addons", "[{\"sku\":\"aioseo-redirects\",\"name\":\"Redirection Manager\",\"version\":\"1.4.15\",\"image\":null,\"icon\":\"PHN2ZyB2aWV3Qm94PSIwIDAgMjQgMjQiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyIgY2xhc3M9ImFpb3Nlby1yZWRpcmVjdCI+PHBhdGggZmlsbC1ydWxlPSJldmVub2RkIiBjbGlwLXJ1bGU9ImV2ZW5vZGQiIGQ9Ik0xMC41OSA5LjE3TDUuNDEgNEw0IDUuNDFMOS4xNyAxMC41OEwxMC41OSA5LjE3Wk0xNC41IDRMMTYuNTQgNi4wNEw0IDE4LjU5TDUuNDEgMjBMMTcuOTYgNy40NkwyMCA5LjVWNEgxNC41Wk0xMy40MiAxNC44MkwxNC44MyAxMy40MUwxNy45NiAxNi41NEwyMCAxNC41VjIwSDE0LjVMMTYuNTUgMTcuOTVMMTMuNDIgMTQuODJaIiBmaWxsPSJjdXJyZW50Q29sb3IiIC8+PC9zdmc+\",\"levels\":[\"business\",\"agency\",\"pro\",\"elite\"],\"currentLevels\":[\"pro\",\"elite\"],\"requiresUpgrade\":true,\"description\":\"<p>Our Redirection Manager allows you to create and manage redirects for 404s or modified posts.<\\/p>\\n\",\"descriptionVersion\":0,\"downloadUrl\":\"\",\"productUrl\":\"https:\\/\\/aioseo.com\\/features\\/redirection-manager\\/\",\"learnMoreUrl\":\"https:\\/\\/aioseo.com\\/features\\/redirection-manager\\/\",\"manageUrl\":\"https:\\/\\/route#aioseo-redirects:redirects\",\"features\":[{\"license_level\":\"elite\",\"feature\":\"404-parent-redirect\"}]},{\"sku\":\"aioseo-link-assistant\",\"name\":\"Link Assistant\",\"version\":\"1.1.11\",\"image\":null,\"icon\":\"PHN2ZyB2aWV3Qm94PSIwIDAgMjQgMjQiIGZpbGw9Im5vbmUiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHBhdGggZmlsbC1ydWxlPSJldmVub2RkIiBjbGlwLXJ1bGU9ImV2ZW5vZGQiIGQ9Ik0xMSAxNUg3QzUuMzUgMTUgNCAxMy42NSA0IDEyQzQgMTAuMzUgNS4zNSA5IDcgOUgxMVY3SDdDNC4yNCA3IDIgOS4yNCAyIDEyQzIgMTQuNzYgNC4yNCAxNyA3IDE3SDExVjE1Wk0xNyA3SDEzVjlIMTdDMTguNjUgOSAyMCAxMC4zNSAyMCAxMkMyMCAxMy42NSAxOC42NSAxNSAxNyAxNUgxM1YxN0gxN0MxOS43NiAxNyAyMiAxNC43NiAyMiAxMkMyMiA5LjI0IDE5Ljc2IDcgMTcgN1pNMTYgMTFIOFYxM0gxNlYxMVoiIGZpbGw9ImN1cnJlbnRDb2xvciIvPjwvc3ZnPgo=\",\"levels\":[\"agency\",\"pro\",\"elite\"],\"currentLevels\":[\"pro\",\"elite\"],\"requiresUpgrade\":true,\"description\":\"<p>Super-charge your SEO with Link Assistant! Get relevant suggestions for adding internal links to older content as well as finding any orphaned posts that have no internal links. Use our reporting feature to see all link suggestions or add them directly from any page or post.<\\/p>\\n\",\"descriptionVersion\":0,\"downloadUrl\":\"\",\"productUrl\":\"https:\\/\\/aioseo.com\\/docs\\/link-assistant\\/\",\"learnMoreUrl\":\"https:\\/\\/aioseo.com\\/docs\\/link-assistant\\/\",\"manageUrl\":\"https:\\/\\/route#aioseo-link-assistant:overview\",\"features\":[]},{\"sku\":\"aioseo-video-sitemap\",\"name\":\"Video Sitemap\",\"version\":\"1.1.24\",\"image\":null,\"icon\":\"PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyMCAyMCI+PHBhdGggZmlsbC1ydWxlPSJldmVub2RkIiBkPSJNMy4zMzMgNWgxMGMuNDU5IDAgLjgzNC4zNzUuODM0LjgzM1Y4Ljc1TDE3LjUgNS40MTd2OS4xNjZsLTMuMzMzLTMuMzMzdjIuOTE3YS44MzYuODM2IDAgMCAxLS44MzQuODMzaC0xMGEuODM2LjgzNiAwIDAgMS0uODMzLS44MzNWNS44MzNjMC0uNDU4LjM3NS0uODMzLjgzMy0uODMzWm05LjE2NyA4LjMzM1Y2LjY2N0g0LjE2N3Y2LjY2NkgxMi41WiIgY2xpcC1ydWxlPSJldmVub2RkIi8+PC9zdmc+\",\"levels\":[\"individual\",\"business\",\"agency\",\"pro\",\"elite\"],\"currentLevels\":[\"pro\",\"elite\"],\"requiresUpgrade\":true,\"description\":\"<p>The Video Sitemap works in much the same way as the XML Sitemap module, it generates an XML Sitemap specifically for video content on your site. Search engines use this information to display rich snippet information in search results.<\\/p>\\n\",\"descriptionVersion\":0,\"downloadUrl\":\"\",\"productUrl\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-create-a-video-sitemap\\/\",\"learnMoreUrl\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-create-a-video-sitemap\\/\",\"manageUrl\":\"https:\\/\\/route#aioseo-sitemaps:video-sitemap\",\"features\":[]},{\"sku\":\"aioseo-local-business\",\"name\":\"Local Business SEO\",\"version\":\"1.3.12\",\"image\":null,\"icon\":\"svg-local-business\",\"levels\":[\"business\",\"agency\",\"plus\",\"pro\",\"elite\"],\"currentLevels\":[\"plus\",\"pro\",\"elite\"],\"requiresUpgrade\":true,\"description\":\"<p>Local Business schema markup enables you to tell Google about your business, including your business name, address and phone number, opening hours and price range. This information may be displayed as a Knowledge Graph card or business carousel.<\\/p>\\n\",\"descriptionVersion\":0,\"downloadUrl\":\"\",\"productUrl\":\"https:\\/\\/aioseo.com\\/docs\\/local-business-seo\\/\",\"learnMoreUrl\":\"https:\\/\\/aioseo.com\\/docs\\/local-business-seo\\/\",\"manageUrl\":\"https:\\/\\/route#aioseo-local-seo:locations\",\"features\":[]},{\"sku\":\"aioseo-news-sitemap\",\"name\":\"News Sitemap\",\"version\":\"1.0.20\",\"image\":null,\"icon\":\"svg-sitemaps-pro\",\"levels\":[\"business\",\"agency\",\"pro\",\"elite\"],\"currentLevels\":[\"pro\",\"elite\"],\"requiresUpgrade\":true,\"description\":\"<p>Our Google News Sitemap lets you control which content you submit to Google News and only contains articles that were published in the last 48 hours. In order to submit a News Sitemap to Google, you must have added your site to Google\\u2019s Publisher Center and had it approved.<\\/p>\\n\",\"descriptionVersion\":0,\"downloadUrl\":\"\",\"productUrl\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-create-a-google-news-sitemap\\/\",\"learnMoreUrl\":\"https:\\/\\/aioseo.com\\/docs\\/how-to-create-a-google-news-sitemap\\/\",\"manageUrl\":\"https:\\/\\/route#aioseo-sitemaps:news-sitemap\",\"features\":[]},{\"sku\":\"aioseo-index-now\",\"name\":\"IndexNow\",\"version\":\"1.0.13\",\"image\":null,\"icon\":\"PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyMCAyMCI+PHBhdGggZD0iTTE3LjY0NCAxMS42NTVjLS4zMjEtLjIyOS0uNjU0LS40NDYtLjk2NC0uNjk3LS42NDMtLjUzNC0uNjMxLTEuMzcyLjAyMy0xLjg4NC4zMS0uMjQuNjQyLS40NTguOTY0LS42OTcuMTg0LS4xMy4zMjEtLjI5NC4zMzMtLjUzNCAwLS4wMzIgMC0uMDc2LS4wMTItLjEyYTcuNDQyIDcuNDQyIDAgMCAwLTEuODkzLTMuMTQ3Yy0uMjA3LS4yMDctLjQ2LS4yNC0uNzQ2LS4xMmEyMi4wNSAyMi4wNSAwIDAgMS0xLjA2OC40MzZjLS45MTguMzQ4LTEuNjg3LS4wODctMS44MTMtMS4wMjQtLjA0Ni0uMzM4LS4wOC0uNjc1LS4xMTUtMS4wMTMtLjAzNC0uMzctLjI0LS41OTktLjYzLS42NzVhOC40NDYgOC40NDYgMCAwIDAtMy40NjcgMGMtLjM2Ny4wNzYtLjU3NC4yNzItLjYwOC42MzJhMTMuNzggMTMuNzggMCAwIDEtLjE2IDEuMTc2Yy0uMTYxLjgyOC0uOTE5IDEuMjMtMS43NDUuOTE1LS4zNTYtLjEzLS43MTItLjI5NC0xLjA2Ny0uNDQ3LS4zMzMtLjE0MS0uNjA5LS4wODctLjg1LjE2NGE3Ljc3OSA3Ljc3OSAwIDAgMC0xLjc3OSAyLjkxOGMtLjExNC4zMzgtLjAyMy42MS4yODcuODI4LjI5OS4yMDcuNjA5LjQxNC44OTUuNjMyLjc3LjU4OC43NTggMS40NDgtLjAyMiAyLjAxNC0uMjg3LjIwNy0uNTc0LjQxNC0uODYxLjYxLS4zMjIuMjE4LS40MTMuNTEyLS4yOTkuODZhNy44NyA3Ljg3IDAgMCAwIDEuNzQ1IDIuODg3Yy4yNC4yNS41MTYuMzE2Ljg1LjE4NS4zOS0uMTUzLjc2OC0uMzI3IDEuMTU4LS40NjguNzU4LS4yNzMgMS41MTUuMTIgMS42NzYuODcuMDguNDA0LjEyNi44MTguMTYgMS4yMi4wMzUuMzcuMjQxLjU2Ny41OTcuNjQzIDEuMTYuMjQgMi4zMDcuMjQgMy40NjYuMDExLjQxMy0uMDg3LjYwOC0uMzE2LjY0My0uNzA4LjAyMy0uMzI3LjA2OS0uNjUzLjEwMy0uOTcuMTE1LS45MjUuODk1LTEuMzgyIDEuODE0LTEuMDQ1LjM0NC4xMzEuNjg4LjI3MyAxLjAzMi40MjUuMzY4LjE1My42NjYuMDc2LjkxOC0uMjA3YTguNDk0IDguNDk0IDAgMCAwIDEuNzEtMi44MmMuMTUtLjMzOC4wNTgtLjYyMS0uMjc1LS44NXptLTkuNDguNjk3Yy0uMTAzLjEzLS4zMS4xMi0uNDEzLS4wMUw2LjAzIDEwLjE3M2EuMjIuMjIgMCAwIDEgMC0uMjgzbDEuOTI4LTIuNDI5IDEuNDY5IDEuNzItLjYzMS44NS41MjcuNzA4YS4yMDUuMjA1IDAgMCAxLS4wMTEuMjYyem01LjgzLTIuMTc4LTIuNDc5IDMuMDE3YS4yNi4yNiAwIDAgMS0uMjA2LjEwOUg5LjEwNWEuMjUuMjUgMCAwIDEtLjIwNi0uNDAzbDIuMzUzLTIuODY1LTIuNjc0LTMuMjY3aDIuODY5bDIuNTU5IDMuMTI2YS4yMzYuMjM2IDAgMCAxLS4wMTEuMjgzeiIvPjwvc3ZnPg==\",\"levels\":[\"business\",\"agency\",\"basic\",\"plus\",\"pro\",\"elite\"],\"currentLevels\":[\"basic\",\"plus\",\"pro\",\"elite\"],\"requiresUpgrade\":true,\"description\":\"<p>Add IndexNow support to instantly notify search engines when your content has changed. This helps the search engines to prioritize the changes on your website and helps you rank faster.<\\/p>\\n\",\"descriptionVersion\":0,\"downloadUrl\":\"\",\"productUrl\":\"https:\\/\\/aioseo.com\\/index-now\",\"learnMoreUrl\":\"https:\\/\\/aioseo.com\\/index-now\",\"manageUrl\":\"https:\\/\\/route#aioseo-settings:webmaster-tools\",\"features\":[]},{\"sku\":\"aioseo-rest-api\",\"name\":\"REST API\",\"version\":\"1.0.9\",\"image\":null,\"icon\":\"PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCIgY2xhc3M9ImFpb3Nlby1jb2RlIj48cGF0aCBkPSJNOS40IDE2LjZMNC44IDEybDQuNi00LjZMOCA2bC02IDYgNiA2IDEuNC0xLjR6bTUuMiAwbDQuNi00LjYtNC42LTQuNkwxNiA2bDYgNi02IDYtMS40LTEuNHoiIGZpbGw9ImN1cnJlbnRDb2xvciIvPjwvc3ZnPg==\",\"levels\":[\"plus\",\"pro\",\"elite\"],\"currentLevels\":[\"plus\",\"pro\",\"elite\"],\"requiresUpgrade\":true,\"description\":\"<p>Manage your post and term SEO meta via the WordPress REST API. This addon also works seamlessly with headless WordPress installs.<\\/p>\\n\",\"descriptionVersion\":0,\"downloadUrl\":\"\",\"productUrl\":\"https:\\/\\/aioseo.com\\/feature\\/rest-api\\/\",\"learnMoreUrl\":\"https:\\/\\/aioseo.com\\/feature\\/rest-api\\/\",\"manageUrl\":\"\",\"features\":[]},{\"sku\":\"aioseo-image-seo\",\"name\":\"Image SEO\",\"version\":\"1.2.2\",\"image\":null,\"icon\":\"PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyMCAyMCI+PHBhdGggZD0iTTE1LjgzMyA0LjE2N3YxMS42NjZINC4xNjdWNC4xNjdoMTEuNjY2Wm0wLTEuNjY3SDQuMTY3QzMuMjUgMi41IDIuNSAzLjI1IDIuNSA0LjE2N3YxMS42NjZjMCAuOTE3Ljc1IDEuNjY3IDEuNjY3IDEuNjY3aDExLjY2NmMuOTE3IDAgMS42NjctLjc1IDEuNjY3LTEuNjY3VjQuMTY3YzAtLjkxNy0uNzUtMS42NjctMS42NjctMS42NjdabS00LjA1IDcuMzgzLTIuNSAzLjIyNUw3LjUgMTAuOTUgNSAxNC4xNjdoMTBsLTMuMjE3LTQuMjg0WiIvPjwvc3ZnPg==\",\"levels\":[\"business\",\"agency\",\"plus\",\"pro\",\"elite\"],\"currentLevels\":[\"plus\",\"pro\",\"elite\"],\"requiresUpgrade\":true,\"description\":\"<p>Globally control the Title, Alt Text, Caption and Descriptions for images in your content. These attributes are essential for both accessibility and SEO.<\\/p>\\n\",\"descriptionVersion\":0,\"downloadUrl\":\"\",\"productUrl\":\"https:\\/\\/aioseo.com\\/docs\\/using-the-image-seo-features-in-all-in-one-seo\\/\",\"learnMoreUrl\":\"https:\\/\\/aioseo.com\\/docs\\/using-the-image-seo-features-in-all-in-one-seo\\/\",\"manageUrl\":\"https:\\/\\/route#aioseo-search-appearance:media\",\"features\":[]},{\"sku\":\"aioseo-eeat\",\"name\":\"Author SEO (E-E-A-T)\",\"version\":\"1.2.9\",\"image\":null,\"icon\":\"PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIGhlaWdodD0iMjQiIHZpZXdCb3g9IjAgLTk2MCA5NjAgOTYwIiB3aWR0aD0iMjQiPjxwYXRoIGQ9Ik00NDAuMTE4LTU2MHEzMy44MzkgMCA1Ny44MTctMjQuMDk3dDIzLjk3OC01Ny45MzVxMC0zMy44MzgtMjMuOTc4LTU3LjY5Ni0yMy45NzgtMjMuODU5LTU3LjgxNy0yMy44NTktMzMuODM4IDAtNTcuOTM0IDIzLjg1OS0yNC4wOTcgMjMuODU4LTI0LjA5NyA1Ny42OTYgMCAzMy44MzggMjQuMDk3IDU3LjkzNVE0MDYuMjgtNTYwIDQ0MC4xMTgtNTYwWk00NDAtMzk2LjQxM3E0NS43MTcgMCA4NS41NzYtMTkuNDc4IDM5Ljg1OS0xOS40NzkgNjkuNTc2LTU2LjE1Mi0zNS45NTYtMjMuNzE4LTc0LjkzNS0zNS44MzdRNDgxLjIzOS01MjAgNDQwLTUyMHQtODAuMjE3IDEyLjEycS0zOC45NzkgMTIuMTE5LTc0LjkzNSAzNS44MzcgMjkuNzE3IDM2LjY3MyA2OS41NzYgNTYuMTUyIDM5Ljg1OSAxOS40NzggODUuNTc2IDE5LjQ3OFptMzg2LjM5MSAyODYuOTM1TDYzNy45MTMtMjk3Ljk1NnEtNDEuNzE3IDMxLjc2MS05MS42OTYgNDkuNDAyUTQ5Ni4yMzktMjMwLjkxMyA0NDAtMjMwLjkxM3EtMTM3LjU4NyAwLTIzMy4zMzctOTUuNzVUMTEwLjkxMy01NjBxMC0xMzcuNTg3IDk1Ljc1LTIzMy4zMzdUNDQwLTg4OS4wODdxMTM3LjU4NyAwIDIzMy4zMzcgOTUuNzVUNzY5LjA4Ny01NjBxMCA1NS43NjEtMTcuNzYxIDEwNS45NzgtMTcuNzYxIDUwLjIxOC00OS41MjEgOTIuMTc0TDg5MC4yODMtMTczLjM3bC02My44OTIgNjMuODkyWk00NDAuMTEzLTMyMS45MTNxOTkuMTU2IDAgMTY4LjU2NS02OS41MjIgNjkuNDA5LTY5LjUyMiA2OS40MDktMTY4LjY3OCAwLTk5LjE1Ni02OS40MDktMTY4LjU2NS02OS40MDktNjkuNDA5LTE2OC41NjUtNjkuNDA5LTk5LjE1NiAwLTE2OC42NzggNjkuNDA5LTY5LjUyMiA2OS40MDktNjkuNTIyIDE2OC41NjUgMCA5OS4xNTYgNjkuNTIyIDE2OC42NzggNjkuNTIyIDY5LjUyMiAxNjguNjc4IDY5LjUyMlpNNDQwLTU2MFoiLz48L3N2Zz4=\",\"levels\":[\"plus\",\"pro\",\"elite\"],\"currentLevels\":[\"plus\",\"pro\",\"elite\"],\"requiresUpgrade\":true,\"description\":\"<p>Optimize your site for Google\'s E-E-A-T ranking factor by proving your writer\'s expertise through author schema markup and new UI elements.<\\/p>\\n\",\"descriptionVersion\":0,\"downloadUrl\":\"\",\"productUrl\":\"https:\\/\\/aioseo.com\\/features\\/eeat\\/\",\"learnMoreUrl\":\"https:\\/\\/aioseo.com\\/features\\/eeat\\/\",\"manageUrl\":\"https:\\/\\/route#aioseo-search-appearance:author-seo\",\"features\":[]}]", "0", "2026-02-06 05:12:11", "2026-01-31 09:06:20", "2026-02-05 05:12:11");
INSERT INTO `wp_aioseo_cache` VALUES("6", "admin_help_docs", "\"{\\\"categories\\\":{\\\"getting-started\\\":\\\"Getting Started\\\",\\\"advanced-settings\\\":\\\"Advanced Settings\\\",\\\"display-settings\\\":\\\"Display Settings\\\",\\\"general-seo-topics\\\":\\\"General SEO Topics\\\",\\\"feature-manager\\\":\\\"Feature Manager\\\",\\\"installation\\\":\\\"Installation\\\"},\\\"docs\\\":{\\\"401534\\\":{\\\"title\\\":\\\"How to Generate Your SEO Email Reports\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-generate-your-seo-email-reports\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"general-settings\\\",\\\"search-statistics\\\"]},\\\"389367\\\":{\\\"title\\\":\\\"Using the Keyword Rank Tracker feature in Search Statistics\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-the-keyword-rank-tracker-feature-in-search-statistics\\\\\\/\\\",\\\"categories\\\":[\\\"keyword-settings\\\",\\\"search-statistics\\\"]},\\\"379863\\\":{\\\"title\\\":\\\"Setting Vehicle (Car) Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-vehicle-car-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"379713\\\":{\\\"title\\\":\\\"Setting Product Review Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-product-review-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"332691\\\":{\\\"title\\\":\\\"Google Permissions for oAuth\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/google-permissions-for-the-aioseo-google-search-console-integration\\\\\\/\\\",\\\"categories\\\":[]},\\\"326862\\\":{\\\"title\\\":\\\"aioseo_user_profile_tab_allowed_user_ids\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_user_profile_tab_allowed_user_ids\\\\\\/\\\",\\\"categories\\\":[\\\"developer-documentation\\\",\\\"filter-hooks\\\"]},\\\"326858\\\":{\\\"title\\\":\\\"aioseo_import_yoast_seo_posts_per_action\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_import_yoast_seo_posts_per_action\\\\\\/\\\",\\\"categories\\\":[\\\"developer-documentation\\\",\\\"filter-hooks\\\"]},\\\"326856\\\":{\\\"title\\\":\\\"aioseo_import_seopress_posts_per_action\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_import_seopress_posts_per_action\\\\\\/\\\",\\\"categories\\\":[\\\"developer-documentation\\\",\\\"filter-hooks\\\"]},\\\"326850\\\":{\\\"title\\\":\\\"aioseo_import_rank_math_posts_per_action\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_import_rank_math_posts_per_action\\\\\\/\\\",\\\"categories\\\":[\\\"developer-documentation\\\",\\\"filter-hooks\\\"]},\\\"298356\\\":{\\\"title\\\":\\\"aioseo_redirects_log_skip\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_redirects_log_skip\\\\\\/\\\",\\\"categories\\\":[\\\"developer-documentation\\\",\\\"filter-hooks\\\"]},\\\"294047\\\":{\\\"title\\\":\\\"Using the Query Arg Monitoring in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-the-query-arg-monitoring-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\"]},\\\"279241\\\":{\\\"title\\\":\\\"How to Schedule a Redirect in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-schedule-a-redirect-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"269732\\\":{\\\"title\\\":\\\"Displaying Detailed Author Information on Your Site\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/displaying-detailed-author-information-on-your-site\\\\\\/\\\",\\\"categories\\\":[\\\"author-seo\\\",\\\"content-blocks\\\"]},\\\"267254\\\":{\\\"title\\\":\\\"Adding Author SEO (E-E-A-T) to Your Site\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/adding-author-seo-e-e-a-t-to-your-site\\\\\\/\\\",\\\"categories\\\":[\\\"author-seo\\\"]},\\\"262344\\\":{\\\"title\\\":\\\"How to Get Your Images to Appear in Search Results\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-get-your-images-to-appear-in-search-results\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\",\\\"general-seo-topics\\\",\\\"image-seo\\\"]},\\\"261932\\\":{\\\"title\\\":\\\"Sharing Content on Slack\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/sharing-content-on-slack\\\\\\/\\\",\\\"categories\\\":[\\\"social-networks\\\"]},\\\"261923\\\":{\\\"title\\\":\\\"Sharing Content on WhatsApp\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/sharing-content-on-whatsapp\\\\\\/\\\",\\\"categories\\\":[\\\"social-networks\\\"]},\\\"261517\\\":{\\\"title\\\":\\\"Importing Locations From Other Plugins\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/importing-locations-from-other-plugins\\\\\\/\\\",\\\"categories\\\":[\\\"importer-exporter\\\",\\\"local-business-seo\\\"]},\\\"244975\\\":{\\\"title\\\":\\\"Checking the Index Status of Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/checking-the-index-status-of-content\\\\\\/\\\",\\\"categories\\\":[\\\"post-page-settings\\\",\\\"search-statistics\\\"]},\\\"242346\\\":{\\\"title\\\":\\\"Using AIOSEO Details on the Posts Screen\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-aioseo-details-on-the-posts-screen\\\\\\/\\\",\\\"categories\\\":[\\\"category-tag-settings\\\",\\\"post-page-settings\\\"]},\\\"240583\\\":{\\\"title\\\":\\\"Setting WP_HOME and WP_SITEURL in the wp-config.php File\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-wp_home-and-wp_siteurl-in-the-wp-config-php-file\\\\\\/\\\",\\\"categories\\\":[\\\"troubleshooting\\\"]},\\\"240452\\\":{\\\"title\\\":\\\"Should I Use Meta Keywords?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/should-i-use-meta-keywords\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\",\\\"general-seo-topics\\\"]},\\\"235044\\\":{\\\"title\\\":\\\"Setting Cornerstone Content in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/cornerstone-content\\\\\\/\\\",\\\"categories\\\":[\\\"link-assistant\\\",\\\"post-page-settings\\\"]},\\\"222363\\\":{\\\"title\\\":\\\"aioseo_get_post_id\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_get_post_id\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"200603\\\":{\\\"title\\\":\\\"Viewing Detailed Search Statistics For Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/viewing-detailed-search-statistics-for-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"search-statistics\\\"]},\\\"200304\\\":{\\\"title\\\":\\\"Tracking Changes to Your SEO Using SEO Revisions\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/tracking-changes-to-your-seo-using-seo-revisions\\\\\\/\\\",\\\"categories\\\":[\\\"seo-revisions\\\"]},\\\"188167\\\":{\\\"title\\\":\\\"WPCode Snippet Library\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/wpcode-snippet-library\\\\\\/\\\",\\\"categories\\\":[\\\"tools\\\"]},\\\"186946\\\":{\\\"title\\\":\\\"aioseo_hide_version_number\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_hide_version_number\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"178887\\\":{\\\"title\\\":\\\"Setting the Primary Term for Breadcrumbs\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-primary-term-for-breadcrumbs\\\\\\/\\\",\\\"categories\\\":[\\\"breadcrumbs\\\"]},\\\"178727\\\":{\\\"title\\\":\\\"Using Broken Link Checker to Find and Fix Broken Links and Images\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-broken-link-checker-to-find-and-fix-broken-links-and-images\\\\\\/\\\",\\\"categories\\\":[\\\"broken-link-checker\\\"]},\\\"163922\\\":{\\\"title\\\":\\\"aioseo_schema_json_flags\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_schema_json_flags\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"163519\\\":{\\\"title\\\":\\\"Using OpenAI to Generate SEO Titles and Meta Descriptions\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-openai-to-generate-seo-titles-and-meta-descriptions\\\\\\/\\\",\\\"categories\\\":[]},\\\"145363\\\":{\\\"title\\\":\\\"Using the Search Statistics in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-the-search-statistics-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"google-search-console\\\",\\\"search-statistics\\\"]},\\\"145281\\\":{\\\"title\\\":\\\"Connecting Search Statistics to Google Search Console\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/connecting-search-statistics-to-google-search-console\\\\\\/\\\",\\\"categories\\\":[\\\"google-search-console\\\",\\\"search-statistics\\\"]},\\\"139798\\\":{\\\"title\\\":\\\"Checking Your SEO Using the SEO Preview\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/checking-your-seo-using-the-seo-preview\\\\\\/\\\",\\\"categories\\\":[\\\"facebook-settings\\\",\\\"post-page-settings\\\",\\\"seo-preview\\\",\\\"truseo\\\",\\\"twitter-settings\\\"]},\\\"136509\\\":{\\\"title\\\":\\\"aioseo_sitemap_lastmod_disable\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_sitemap_lastmod_disable\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"135249\\\":{\\\"title\\\":\\\"aioseo_sitemap_rss\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_sitemap_rss\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"133251\\\":{\\\"title\\\":\\\"aioseo_user_profile_tab_disable\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_user_profile_tab_disable\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"131885\\\":{\\\"title\\\":\\\"Setting Web Page Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-web-page-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"129515\\\":{\\\"title\\\":\\\"Editing the .htaccess file Using All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/editing-the-htaccess-file-using-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"file-editor\\\",\\\"tools\\\"]},\\\"124292\\\":{\\\"title\\\":\\\"Using the Emojis in Titles and Descriptions\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-the-emojis-in-titles-and-descriptions\\\\\\/\\\",\\\"categories\\\":[\\\"facebook-settings\\\",\\\"post-page-settings\\\",\\\"search-appearance\\\",\\\"social-networks\\\",\\\"twitter-settings\\\"]},\\\"123164\\\":{\\\"title\\\":\\\"Google Permissions for the AIOSEO Google Search Console Integration\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/google-permissions-for-oauth\\\\\\/\\\",\\\"categories\\\":[\\\"google-search-console\\\",\\\"search-statistics\\\"]},\\\"112137\\\":{\\\"title\\\":\\\"Setting the Schema Type for Individual Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-schema-type-for-individual-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112145\\\":{\\\"title\\\":\\\"Configuring the Schema Settings in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/configuring-the-schema-settings-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112153\\\":{\\\"title\\\":\\\"A Guide to Schema.org Markup for Rich Snippets\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/a-guide-to-schema-org-markup-for-rich-snippets\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112438\\\":{\\\"title\\\":\\\"Creating Reusable Schema Templates in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/creating-reusable-schema-templates-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112428\\\":{\\\"title\\\":\\\"Creating Custom Schema Markup with All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/creating-custom-schema-markup-with-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112889\\\":{\\\"title\\\":\\\"Setting Event Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-event-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112735\\\":{\\\"title\\\":\\\"Setting Dataset Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-dataset-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112711\\\":{\\\"title\\\":\\\"Setting Article Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-article-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112164\\\":{\\\"title\\\":\\\"Setting Course Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-course-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112933\\\":{\\\"title\\\":\\\"Setting Job Posting Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-job-posting-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112926\\\":{\\\"title\\\":\\\"Setting How-To Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-how-to-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112916\\\":{\\\"title\\\":\\\"Setting Fact Check Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-fact-check-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112727\\\":{\\\"title\\\":\\\"Setting Book Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-book-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112243\\\":{\\\"title\\\":\\\"Setting FAQ Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-faq-page-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112958\\\":{\\\"title\\\":\\\"Setting Service Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-service-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112949\\\":{\\\"title\\\":\\\"Setting Person Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-person-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112944\\\":{\\\"title\\\":\\\"Setting Music Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-music-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112941\\\":{\\\"title\\\":\\\"Setting Movie Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-movie-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112212\\\":{\\\"title\\\":\\\"Setting Recipe Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-recipe-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112962\\\":{\\\"title\\\":\\\"Setting Video Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-video-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112403\\\":{\\\"title\\\":\\\"Testing Your Schema in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/testing-your-schema-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112226\\\":{\\\"title\\\":\\\"Setting Software Application Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-software-application-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"112197\\\":{\\\"title\\\":\\\"Setting Product Schema Markup in Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-product-schema-markup-in-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"119555\\\":{\\\"title\\\":\\\"How to Use the AIOSEO Feature Manager on a Multisite Network\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-use-the-aioseo-feature-manager-on-a-multisite-network\\\\\\/\\\",\\\"categories\\\":[\\\"feature-manager\\\",\\\"multisite-networks\\\"]},\\\"119550\\\":{\\\"title\\\":\\\"How to Reset the AIOSEO Site Settings on a Multisite Network\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-reset-the-aioseo-site-settings-on-a-multisite-network\\\\\\/\\\",\\\"categories\\\":[\\\"multisite-networks\\\",\\\"network-tools\\\"]},\\\"119543\\\":{\\\"title\\\":\\\"How to Backup and Restore AIOSEO Site Settings on a Multisite Network\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-backup-and-restore-aioseo-site-settings-on-a-multisite-network\\\\\\/\\\",\\\"categories\\\":[\\\"multisite-networks\\\",\\\"network-tools\\\"]},\\\"119531\\\":{\\\"title\\\":\\\"How to Import Settings from Other Plugins on a Multisite Network\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-import-settings-from-other-plugins-on-a-multisite-network\\\\\\/\\\",\\\"categories\\\":[\\\"multisite-networks\\\",\\\"network-tools\\\"]},\\\"119519\\\":{\\\"title\\\":\\\"How to Import and Export AIOSEO Settings and Meta Data on a Multisite Network\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-import-and-export-aioseo-settings-and-meta-data-on-a-multisite-network\\\\\\/\\\",\\\"categories\\\":[\\\"multisite-networks\\\",\\\"network-tools\\\"]},\\\"119497\\\":{\\\"title\\\":\\\"How to Add Your AIOSEO License Key on a WordPress Multisite Network\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-add-your-aioseo-license-key-on-a-wordpress-multisite-network\\\\\\/\\\",\\\"categories\\\":[\\\"multisite-networks\\\",\\\"network-settings\\\"]},\\\"111476\\\":{\\\"title\\\":\\\"Displaying a List of Locations on Your Site\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/displaying-a-list-of-locations-on-your-site\\\\\\/\\\",\\\"categories\\\":[\\\"content-blocks\\\",\\\"local-business-seo\\\"]},\\\"111473\\\":{\\\"title\\\":\\\"Displaying Your Business Location Information on Your Site\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/displaying-your-business-location-information-on-your-site\\\\\\/\\\",\\\"categories\\\":[\\\"content-blocks\\\",\\\"local-business-seo\\\"]},\\\"111459\\\":{\\\"title\\\":\\\"Displaying Opening Hours on Your Site\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/displaying-opening-hours-on-your-site\\\\\\/\\\",\\\"categories\\\":[\\\"content-blocks\\\",\\\"local-business-seo\\\"]},\\\"111455\\\":{\\\"title\\\":\\\"Adding a Map of Your Location to Your Site\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/adding-a-map-of-your-location-to-your-site\\\\\\/\\\",\\\"categories\\\":[\\\"content-blocks\\\",\\\"local-business-seo\\\"]},\\\"111450\\\":{\\\"title\\\":\\\"Adding Breadcrumbs to Your Site Using the AIOSEO Breadcrumbs Block\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/adding-breadcrumbs-to-your-site-using-the-aioseo-breadcrumbs-block\\\\\\/\\\",\\\"categories\\\":[\\\"breadcrumbs\\\",\\\"content-blocks\\\"]},\\\"109878\\\":{\\\"title\\\":\\\"Adding a Redirect When You Delete Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/adding-a-redirect-when-you-delete-content\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"109829\\\":{\\\"title\\\":\\\"Redirecting 404 Content Not Found Using All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/redirecting-404-content-not-found-using-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"109916\\\":{\\\"title\\\":\\\"Using the Image SEO Features in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-the-image-seo-features-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"image-seo\\\"]},\\\"104857\\\":{\\\"title\\\":\\\"Adding a Table of Contents to Your Site Using All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/adding-a-table-of-contents-to-your-site-using-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"content-blocks\\\"]},\\\"104616\\\":{\\\"title\\\":\\\"Adding FAQs to Your Site Using All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/adding-faqs-to-your-site-using-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"content-blocks\\\"]},\\\"104595\\\":{\\\"title\\\":\\\"Automatic Redirects When Changing the Post Slug\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/automatic-redirects-when-changing-the-post-slug\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"103415\\\":{\\\"title\\\":\\\"Removing Published Date from Article Schema\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/removing-published-date-from-article-schema\\\\\\/\\\",\\\"categories\\\":[\\\"developer-documentation\\\"]},\\\"101250\\\":{\\\"title\\\":\\\"Outputting AIOSEO\'s data in the HEAD without using wp_head()\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/outputting-aioseos-data-in-the-head-without-using-wp_head\\\\\\/\\\",\\\"categories\\\":[\\\"developer-documentation\\\"]},\\\"100154\\\":{\\\"title\\\":\\\"Automatic Redirects When You Delete Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/automatic-redirects-when-you-delete-content\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"98532\\\":{\\\"title\\\":\\\"Localizing AIOSEO Data via the Translations API\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/localizing-aioseo-data-via-the-translations-api\\\\\\/\\\",\\\"categories\\\":[\\\"developer-documentation\\\"]},\\\"98576\\\":{\\\"title\\\":\\\"aioseo_sitemap_term\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_sitemap_term\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"98575\\\":{\\\"title\\\":\\\"aioseo_sitemap_post\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_sitemap_post\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"98566\\\":{\\\"title\\\":\\\"aioseo_save_term\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_save_term\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"98565\\\":{\\\"title\\\":\\\"aioseo_save_post\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_save_post\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"98557\\\":{\\\"title\\\":\\\"aioseo_get_term\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_get_term\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"98554\\\":{\\\"title\\\":\\\"aioseo_get_post\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_get_post\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"93967\\\":{\\\"title\\\":\\\"Importing URLs into the XML Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/importing-urls-into-the-xml-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"xml-sitemap\\\"]},\\\"93822\\\":{\\\"title\\\":\\\"How to Use Crawl Cleanup to Increase Search Engine Crawl Quota\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/crawl-cleanup-best-practices\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\"]},\\\"90584\\\":{\\\"title\\\":\\\"How to Add a Temporary Administrator Login to Your Site\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-add-a-temporary-administrator-login-to-your-site\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\",\\\"troubleshooting\\\"]},\\\"88927\\\":{\\\"title\\\":\\\"Dashboard Widgets in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/dashboard-widgets-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"dashboard\\\"]},\\\"86198\\\":{\\\"title\\\":\\\"How to Strip the Category Base in WordPress\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-strip-the-category-base-in-wordpress\\\\\\/\\\",\\\"categories\\\":[\\\"category-tag-settings\\\"]},\\\"84322\\\":{\\\"title\\\":\\\"Running shortcodes in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/running-shortcodes\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\"]},\\\"84156\\\":{\\\"title\\\":\\\"Translating Your SEO with WPML\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/translating-your-seo-with-wpml\\\\\\/\\\",\\\"categories\\\":[\\\"post-page-settings\\\"]},\\\"80219\\\":{\\\"title\\\":\\\"How to Verify Your Site with Microsoft Clarity\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-verify-your-site-with-microsoft-clarity\\\\\\/\\\",\\\"categories\\\":[\\\"webmaster-tools\\\"]},\\\"79928\\\":{\\\"title\\\":\\\"How to Handle Issues With Installing All in One SEO Pro\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-handle-issues-with-installing-all-in-one-seo-pro\\\\\\/\\\",\\\"categories\\\":[\\\"installation\\\"]},\\\"79149\\\":{\\\"title\\\":\\\"Fetching &amp; Updating AIOSEO Data via the WordPress REST API\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/fetching-updating-aioseo-data-via-the-wordpress-rest-api\\\\\\/\\\",\\\"categories\\\":[\\\"developer-documentation\\\",\\\"rest-api\\\"]},\\\"77593\\\":{\\\"title\\\":\\\"How To Fix JavaScript Errors\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-fix-javascript-errors\\\\\\/\\\",\\\"categories\\\":[\\\"troubleshooting\\\"]},\\\"77589\\\":{\\\"title\\\":\\\"Browser Support Policy\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/browser-support-policy\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\"]},\\\"75143\\\":{\\\"title\\\":\\\"How to Redirect a Post from the Edit Post Screen\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-redirect-a-post-from-the-edit-post-screen\\\\\\/\\\",\\\"categories\\\":[\\\"post-page-settings\\\",\\\"redirection-manager\\\"]},\\\"75686\\\":{\\\"title\\\":\\\"Preventing the Modified Date for Content from Changing\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/preventing-the-modified-date-for-content-from-changing\\\\\\/\\\",\\\"categories\\\":[\\\"post-page-settings\\\"]},\\\"73002\\\":{\\\"title\\\":\\\"Page Builder Integrations\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/page-builder-integrations\\\\\\/\\\",\\\"categories\\\":[\\\"home-page-settings\\\",\\\"post-page-settings\\\",\\\"third-party-integrations\\\",\\\"truseo\\\"]},\\\"73003\\\":{\\\"title\\\":\\\"Integrating with IndexNow to Instantly Re-index Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/integrating-with-indexnow-to-instantly-re-index-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"indexnow\\\",\\\"webmaster-tools\\\"]},\\\"72711\\\":{\\\"title\\\":\\\"aioseo_page_builder_integration_disable\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_page_builder_integration_disable\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"68444\\\":{\\\"title\\\":\\\"An Introduction to Link Assistant \\\\u2014 The Easy Way to Manage Onsite Links\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/introduction-to-link-assistant\\\\\\/\\\",\\\"categories\\\":[\\\"link-assistant\\\"]},\\\"69559\\\":{\\\"title\\\":\\\"Using the Link Assistant in All in One SEO Pro\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/link-assistant\\\\\\/\\\",\\\"categories\\\":[\\\"link-assistant\\\"]},\\\"69594\\\":{\\\"title\\\":\\\"Internal Links in the Links Report in Link Assistant\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/internal-links-in-the-links-report-in-link-assistant\\\\\\/\\\",\\\"categories\\\":[\\\"link-assistant\\\"]},\\\"69596\\\":{\\\"title\\\":\\\"External Links in the Links Report in Link Assistant\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/external-links-in-the-links-report-in-link-assistant\\\\\\/\\\",\\\"categories\\\":[\\\"link-assistant\\\"]},\\\"69921\\\":{\\\"title\\\":\\\"Link Suggestions in the Links Report in Link Assistant\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/link-suggestions-in-the-links-report-in-link-assistant\\\\\\/\\\",\\\"categories\\\":[\\\"link-assistant\\\"]},\\\"69602\\\":{\\\"title\\\":\\\"Affiliate Links in the Links Report in Link Assistant\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/affiliate-links-in-the-links-report-in-link-assistant\\\\\\/\\\",\\\"categories\\\":[\\\"link-assistant\\\"]},\\\"69761\\\":{\\\"title\\\":\\\"Using the Domains Report in Link Assistant\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-the-domains-report-in-link-assistant\\\\\\/\\\",\\\"categories\\\":[\\\"link-assistant\\\"]},\\\"69770\\\":{\\\"title\\\":\\\"Link Assistant Settings\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/link-assistant-settings\\\\\\/\\\",\\\"categories\\\":[\\\"link-assistant\\\"]},\\\"68431\\\":{\\\"title\\\":\\\"aioseo_sitemap_images\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_sitemap_images\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"66833\\\":{\\\"title\\\":\\\"Why Is N\\\\\\/A Displayed Instead of a Score For My Content?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/why-is-na-displayed-instead-of-a-score-for-my-content\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\",\\\"truseo\\\"]},\\\"18824\\\":{\\\"title\\\":\\\"Local Business SEO for a Single Location\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/local-business-seo-for-a-single-location\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\",\\\"schema-settings\\\"]},\\\"35828\\\":{\\\"title\\\":\\\"Local Business SEO for Multiple Locations\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/local-business-seo-for-multiple-locations\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"58476\\\":{\\\"title\\\":\\\"aioseo_public_taxonomies\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_public_taxonomies\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"58475\\\":{\\\"title\\\":\\\"aioseo_public_post_types\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_public_post_types\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"64776\\\":{\\\"title\\\":\\\"How Long Does it Take For My Content to Appear on Google?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-long-does-it-take-for-my-content-to-appear-on-google\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\"]},\\\"35926\\\":{\\\"title\\\":\\\"Adding a Location in Local SEO Addon\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/adding-a-location-in-local-seo-addon\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"61020\\\":{\\\"title\\\":\\\"How to Display a Favicon in Search Results\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-display-a-favicon-in-search-results\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\",\\\"general-seo-topics\\\"]},\\\"35956\\\":{\\\"title\\\":\\\"Displaying Locations on Your Site\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/displaying-locations-on-your-site\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"56330\\\":{\\\"title\\\":\\\"aioseo_sitemap_indexes\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_sitemap_indexes\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"56011\\\":{\\\"title\\\":\\\"Redirect Manager - Configuration Reload\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/redirect-manager-configuration-reload\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"52689\\\":{\\\"title\\\":\\\"aioseo_flyout_menu_enable\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_flyout_menu_disable\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"45698\\\":{\\\"title\\\":\\\"Displaying your Business Information and Star Ratings on a Map\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-places-on-your-maps\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"49268\\\":{\\\"title\\\":\\\"aioseo_access_control_excluded_roles\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_access_control_excluded_roles\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"44555\\\":{\\\"title\\\":\\\"Setting up Google Maps for Local SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-up-google-maps\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"48189\\\":{\\\"title\\\":\\\"How to Create an HTML Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/html-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"html-sitemap\\\"]},\\\"48365\\\":{\\\"title\\\":\\\"Using a Widget to Display Your HTML Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-a-widget-to-display-your-html-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"html-sitemap\\\"]},\\\"48361\\\":{\\\"title\\\":\\\"Using PHP Code to Display Your HTML Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/function-html-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"html-sitemap\\\"]},\\\"48260\\\":{\\\"title\\\":\\\"Using a Block to Display Your HTML Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-a-block-to-display-your-html-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"content-blocks\\\",\\\"html-sitemap\\\"]},\\\"48222\\\":{\\\"title\\\":\\\"aioseo_breadcrumbs_separator_symbol\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_breadcrumbs_separator_symbol\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"48227\\\":{\\\"title\\\":\\\"aioseo_breadcrumbs_template\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_breadcrumbs_template\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"48231\\\":{\\\"title\\\":\\\"aioseo_breadcrumbs_trail\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_breadcrumbs_trail\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"48232\\\":{\\\"title\\\":\\\"aioseo_breadcrumbs_link_current_item\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_breadcrumbs_link_current_item\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"48233\\\":{\\\"title\\\":\\\"aioseo_breadcrumbs_show_current_item\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_breadcrumbs_show_current_item\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"48219\\\":{\\\"title\\\":\\\"aioseo_breadcrumbs_output\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_breadcrumbs_output\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"48223\\\":{\\\"title\\\":\\\"aioseo_breadcrumbs_separator\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_breadcrumbs_separator\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"48238\\\":{\\\"title\\\":\\\"Using a Shortcode to Display Your HTML Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/shortcode-html-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"html-sitemap\\\"]},\\\"45805\\\":{\\\"title\\\":\\\"aioseo_sitemap_exclude_terms\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_sitemap_exclude_terms\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"45804\\\":{\\\"title\\\":\\\"aioseo_sitemap_exclude_posts\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_sitemap_exclude_posts\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"61002\\\":{\\\"title\\\":\\\"How to Create a Google Maps API Key\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-create-a-google-maps-api-key\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"45528\\\":{\\\"title\\\":\\\"aioseo_schema_output\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_schema_output\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"42995\\\":{\\\"title\\\":\\\"Using the Headline Analyzer in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-the-headline-analyzer-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"headline-analyzer\\\"]},\\\"42683\\\":{\\\"title\\\":\\\"How to Perform a Full Site Redirect\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/full-site-redirects\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"50988\\\":{\\\"title\\\":\\\"Displaying Maps on Your Site\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/displaying-maps-on-your-site\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"42999\\\":{\\\"title\\\":\\\"How to Disable the Headline Analyzer\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-disable-the-headline-analyzer\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"headline-analyzer\\\"]},\\\"42975\\\":{\\\"title\\\":\\\"Installing Addons for All in One SEO Pro\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/installing-addons-for-all-in-one-seo-pro\\\\\\/\\\",\\\"categories\\\":[\\\"installation\\\"]},\\\"42854\\\":{\\\"title\\\":\\\"Creating a Pass Through Redirect\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/creating-a-pass-through-redirect\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"41800\\\":{\\\"title\\\":\\\"Using Custom Rules in the Redirection Manager\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/redirection-manager-custom-rules\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"42224\\\":{\\\"title\\\":\\\"Resetting the Settings in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/resetting-the-settings-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"database-tools\\\",\\\"tools\\\"]},\\\"41884\\\":{\\\"title\\\":\\\"Setting the Site Name for Facebook\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-site-name-for-facebook\\\\\\/\\\",\\\"categories\\\":[\\\"facebook-settings\\\",\\\"social-networks\\\"]},\\\"41862\\\":{\\\"title\\\":\\\"How to Get Google to Display the Sitelinks Search Box\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-get-google-to-display-the-sitelinks-search-box\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\"]},\\\"41851\\\":{\\\"title\\\":\\\"Setting the SEO Title and Description Format for the Search Results Page\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-seo-title-and-description-format-for-the-search-results-page\\\\\\/\\\",\\\"categories\\\":[\\\"content-type-settings\\\",\\\"search-appearance\\\"]},\\\"41811\\\":{\\\"title\\\":\\\"SEO Analysis Unable to Connect to Your Site\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/seo-analysis-unable-to-connect-to-your-site\\\\\\/\\\",\\\"categories\\\":[\\\"seo-analysis\\\",\\\"troubleshooting\\\"]},\\\"41280\\\":{\\\"title\\\":\\\"How to Renew Your AIOSEO License\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-renew-your-aioseo-license\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\",\\\"getting-started\\\"]},\\\"41077\\\":{\\\"title\\\":\\\"Update WordPress: WordPress Versions Supported by AIOSEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/update-wordpress\\\\\\/\\\",\\\"categories\\\":[\\\"troubleshooting\\\"]},\\\"40587\\\":{\\\"title\\\":\\\"How to Open the Browser Error Console\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-open-the-browser-error-console\\\\\\/\\\",\\\"categories\\\":[\\\"troubleshooting\\\"]},\\\"40582\\\":{\\\"title\\\":\\\"How to Enable Debugging in WordPress\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-enable-debugging-in-wordpress\\\\\\/\\\",\\\"categories\\\":[\\\"troubleshooting\\\"]},\\\"40148\\\":{\\\"title\\\":\\\"What is TruSEO?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/what-is-truseo\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\",\\\"truseo\\\"]},\\\"39494\\\":{\\\"title\\\":\\\"Redirecting Attachment Pages\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/redirecting-attachment-pages\\\\\\/\\\",\\\"categories\\\":[\\\"media-settings\\\",\\\"search-appearance\\\"]},\\\"66310\\\":{\\\"title\\\":\\\"Selecting the Google Maps APIs to use with All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/selecting-the-google-maps-apis-to-use-with-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"38915\\\":{\\\"title\\\":\\\"Setting Up and Using Breadcrumbs Templates\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-up-and-using-breadcrumbs-templates\\\\\\/\\\",\\\"categories\\\":[\\\"breadcrumbs\\\"]},\\\"38610\\\":{\\\"title\\\":\\\"Displaying Breadcrumbs On Your Site\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/displaying-breadcrumbs-on-your-site\\\\\\/\\\",\\\"categories\\\":[\\\"breadcrumbs\\\"]},\\\"36048\\\":{\\\"title\\\":\\\"Function: aioseo_breadcrumbs()\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/function-aioseo_breadcrumbs\\\\\\/\\\",\\\"categories\\\":[\\\"breadcrumbs\\\"]},\\\"36047\\\":{\\\"title\\\":\\\"Shortcode: [aioseo_breadcrumbs]\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/shortcode-aioseo_breadcrumbs\\\\\\/\\\",\\\"categories\\\":[\\\"breadcrumbs\\\"]},\\\"38240\\\":{\\\"title\\\":\\\"aioseo_social_image_ignore_cover_block\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_social_image_ignore_cover_block\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"34923\\\":{\\\"title\\\":\\\"How to Redirect a Post or Page in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-redirect-a-post-or-page-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"34977\\\":{\\\"title\\\":\\\"How to Redirect Multiple URLs to the Same Destination\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-redirect-multiple-urls-to-the-same-destination\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"35604\\\":{\\\"title\\\":\\\"Automatic Redirects When URLs Change in Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/automatic-redirects-when-urls-change-in-content\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"31460\\\":{\\\"title\\\":\\\"Enhanced Search Query Conflict\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/enhanced-search-query-conflict\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"30850\\\":{\\\"title\\\":\\\"aioseo_local_business_info_email_icon\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_info_email_icon\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"30839\\\":{\\\"title\\\":\\\"aioseo_local_business_info_location_icon\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_info_location_icon\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"30759\\\":{\\\"title\\\":\\\"aioseo_local_business_output_business_info_instance\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_output_business_info_instance\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"30760\\\":{\\\"title\\\":\\\"aioseo_local_business_output_business_info_location_data\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_output_business_info_location_data\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"30765\\\":{\\\"title\\\":\\\"aioseo_local_business_output_opening_hours_instance\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_output_opening_hours_instance\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"30766\\\":{\\\"title\\\":\\\"aioseo_local_business_output_opening_hours_data\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_output_opening_hours_data\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"30849\\\":{\\\"title\\\":\\\"aioseo_local_business_info_phone_icon\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_info_phone_icon\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"30851\\\":{\\\"title\\\":\\\"aioseo_local_business_opening_hours_icon\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_opening_hours_icon\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"30398\\\":{\\\"title\\\":\\\"aioseo_local_business_post_type_name\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_post_type_name\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"30551\\\":{\\\"title\\\":\\\"aioseo_local_business_post_type_slug\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_post_type_slug\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"30556\\\":{\\\"title\\\":\\\"aioseo_local_business_post_type_single_label\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_post_type_single_label\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"30559\\\":{\\\"title\\\":\\\"aioseo_local_business_post_type_plural_label\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_post_type_plural_label\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"30560\\\":{\\\"title\\\":\\\"aioseo_local_business_post_type\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_post_type\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"30563\\\":{\\\"title\\\":\\\"aioseo_local_business_taxonomy_name\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_taxonomy_name\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"30564\\\":{\\\"title\\\":\\\"aioseo_local_business_taxonomy_slug\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_taxonomy_slug\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"35609\\\":{\\\"title\\\":\\\"Choosing Which Redirect Type to Use\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/choosing-which-redirect-type-to-use\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"35599\\\":{\\\"title\\\":\\\"Importing Redirects From Other Plugins\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/importing-redirects-from-other-plugins\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"35588\\\":{\\\"title\\\":\\\"Exporting and Importing Redirects\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/exporting-and-importing-redirects\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"35579\\\":{\\\"title\\\":\\\"Logging 404 Errors in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/logging-404-errors-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"35552\\\":{\\\"title\\\":\\\"Logging Redirects in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/logging-redirects-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"35570\\\":{\\\"title\\\":\\\"Redirect GDPR Privacy Information\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/redirect-gdpr-privacy-information\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"30863\\\":{\\\"title\\\":\\\"Local Business SEO - Template overrides\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/local-business-seo-template-overrides\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"35133\\\":{\\\"title\\\":\\\"aioseo_twitter_tags\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_twitter_tags\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"35132\\\":{\\\"title\\\":\\\"aioseo_facebook_tags\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_facebook_tags\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"34993\\\":{\\\"title\\\":\\\"Ignoring Case Sensitivity in Redirects\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/ignoring-case-sensitivity-in-redirects\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"34983\\\":{\\\"title\\\":\\\"Ignoring the Trailing Slash in Redirects\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/ignoring-the-trailing-slash-in-redirects\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"36104\\\":{\\\"title\\\":\\\"Using Query Parameters With Redirects\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-query-parameters-with-redirects\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"30565\\\":{\\\"title\\\":\\\"aioseo_local_business_taxonomy\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_taxonomy\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"36115\\\":{\\\"title\\\":\\\"Caching of Redirects in the Browser\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/caching-of-redirects-in-the-browser\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"34701\\\":{\\\"title\\\":\\\"Adding WooCommerce Product Attributes to SEO Title or Description\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/adding-woocommerce-product-attributes-to-seo-title-or-description\\\\\\/\\\",\\\"categories\\\":[\\\"post-page-settings\\\",\\\"search-appearance\\\",\\\"woocommerce\\\"]},\\\"36111\\\":{\\\"title\\\":\\\"Selecting the Redirect Method in Redirects\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/selecting-the-redirect-method-in-redirects\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"40115\\\":{\\\"title\\\":\\\"Redirect Manager Cannot Detect Your Server\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/redirect-manager-unknown-web-server\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"36369\\\":{\\\"title\\\":\\\"Using Regex in the Redirection Manager\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/redirect-manager-regex\\\\\\/\\\",\\\"categories\\\":[\\\"redirection-manager\\\"]},\\\"31442\\\":{\\\"title\\\":\\\"Shortcode: [aioseo_local_opening_hours]\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/shortcode-aioseo_local_opening_hours\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"31443\\\":{\\\"title\\\":\\\"Shortcode: [aioseo_local_locations]\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/shortcode-aioseo_local_locations\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"34179\\\":{\\\"title\\\":\\\"Using the Smart Tags in Titles and Descriptions\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-the-smart-tags-in-titles-and-descriptions\\\\\\/\\\",\\\"categories\\\":[\\\"post-page-settings\\\",\\\"search-appearance\\\"]},\\\"31441\\\":{\\\"title\\\":\\\"Shortcode: [aioseo_local_business_info]\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/shortcode-aioseo_local_business_info\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"46122\\\":{\\\"title\\\":\\\"Shortcode: [aioseo_local_map]\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/shortcode-aioseo_local_map\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"33507\\\":{\\\"title\\\":\\\"What\'s The Difference Between TruSEO and Page Analysis?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/whats-the-difference-between-truseo-and-page-analysis\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\",\\\"post-page-settings\\\",\\\"truseo\\\"]},\\\"33310\\\":{\\\"title\\\":\\\"Setting Noindex for RSS Feeds\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-noindex-for-rss-feeds\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"search-appearance\\\"]},\\\"33130\\\":{\\\"title\\\":\\\"aioseo_disable_shortcode_parsing\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_disable_shortcode_parsing\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"32085\\\":{\\\"title\\\":\\\"aioseo_conflicting_shortcodes\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_conflicting_shortcodes\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"31992\\\":{\\\"title\\\":\\\"aioseo_schema_graphs\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_schema_graphs\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"31589\\\":{\\\"title\\\":\\\"Understanding the TruSEO Page Analysis Recommendations\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/understanding-the-truseo-page-analysis-recommendations\\\\\\/\\\",\\\"categories\\\":[\\\"post-page-settings\\\",\\\"truseo\\\"]},\\\"31456\\\":{\\\"title\\\":\\\"Function: aioseo_local_locations()\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/function-aioseo_local_locations\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"31455\\\":{\\\"title\\\":\\\"Function: aioseo_local_opening_hours()\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/function-aioseo_local_opening_hours\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"31451\\\":{\\\"title\\\":\\\"Function: aioseo_local_business_info()\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/function-aioseo_local_business_info\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"46123\\\":{\\\"title\\\":\\\"Function: aioseo_local_map()\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/function-aioseo_local_map\\\\\\/\\\",\\\"categories\\\":[\\\"local-business-seo\\\"]},\\\"31042\\\":{\\\"title\\\":\\\"Getting Keyphrase Suggestions From Semrush\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/getting-keyphrase-suggestions-from-semrush\\\\\\/\\\",\\\"categories\\\":[\\\"post-page-settings\\\",\\\"truseo\\\"]},\\\"30773\\\":{\\\"title\\\":\\\"aioseo_local_business_address_tag_value\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_address_tag_value\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"30770\\\":{\\\"title\\\":\\\"aioseo_local_business_address_tags\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_address_tags\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"30752\\\":{\\\"title\\\":\\\"aioseo_local_business_get_location\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_local_business_get_location\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"30728\\\":{\\\"title\\\":\\\"Unable to Save Settings Due to Cloudflare Firewall Rules\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/unable-to-save-settings-due-to-cloudflare-firewall-rules\\\\\\/\\\",\\\"categories\\\":[\\\"troubleshooting\\\"]},\\\"30318\\\":{\\\"title\\\":\\\"aioseo_flush_output_buffer\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_flush_output_buffer\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"18813\\\":{\\\"title\\\":\\\"Installing All in One SEO Pro\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/installing-all-in-one-seo-pro\\\\\\/\\\",\\\"categories\\\":[\\\"getting-started\\\",\\\"installation\\\"]},\\\"18973\\\":{\\\"title\\\":\\\"Beginners Guide for All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/quick-start-guide\\\\\\/\\\",\\\"categories\\\":[\\\"getting-started\\\"]},\\\"18820\\\":{\\\"title\\\":\\\"Setting the SEO Title and Description for Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-seo-title-and-description-for-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"getting-started\\\",\\\"post-page-settings\\\"]},\\\"18902\\\":{\\\"title\\\":\\\"How to Create an XML Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-create-an-xml-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"getting-started\\\",\\\"xml-sitemap\\\"]},\\\"18859\\\":{\\\"title\\\":\\\"Beginners Guide to Social Networks Settings for Facebook\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/beginners-guide-to-social-networks-settings-for-facebook\\\\\\/\\\",\\\"categories\\\":[\\\"facebook-settings\\\",\\\"getting-started\\\",\\\"social-networks\\\"]},\\\"18857\\\":{\\\"title\\\":\\\"Beginners Guide to Social Networks Settings for Twitter\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/beginners-guide-to-social-networks-settings-for-twitter\\\\\\/\\\",\\\"categories\\\":[\\\"getting-started\\\",\\\"social-networks\\\",\\\"twitter-settings\\\"]},\\\"29991\\\":{\\\"title\\\":\\\"aioseo_disable_link_format\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_disable_link_format\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"27841\\\":{\\\"title\\\":\\\"aioseo_thumbnail_size\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_thumbnail_size\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"27844\\\":{\\\"title\\\":\\\"Displaying Additional Data for Written By and Reading Time\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/displaying-additional-data-for-written-by-and-reading-time\\\\\\/\\\",\\\"categories\\\":[\\\"social-networks\\\"]},\\\"27494\\\":{\\\"title\\\":\\\"aioseo_meta_views\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_meta_views\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"27363\\\":{\\\"title\\\":\\\"Using the SEO Analysis Tool\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-the-seo-analysis-tool\\\\\\/\\\",\\\"categories\\\":[\\\"seo-analysis\\\"]},\\\"27272\\\":{\\\"title\\\":\\\"Importing Settings From Other Plugins\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/importing-settings-from-other-plugins\\\\\\/\\\",\\\"categories\\\":[\\\"importer-exporter\\\",\\\"seo-data-importer\\\",\\\"tools\\\"]},\\\"27268\\\":{\\\"title\\\":\\\"Backing Up and Restoring AIOSEO Settings\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/backing-up-and-restoring-aioseo-settings\\\\\\/\\\",\\\"categories\\\":[\\\"importer-exporter\\\",\\\"tools\\\"]},\\\"27259\\\":{\\\"title\\\":\\\"Importing and Exporting AIOSEO Settings and Meta Data\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/importing-and-exporting-aioseo-settings-and-meta-data\\\\\\/\\\",\\\"categories\\\":[\\\"importer-exporter\\\",\\\"tools\\\"]},\\\"26450\\\":{\\\"title\\\":\\\"Blank Title Formats Have Been Detected\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/blank-title-formats-detected\\\\\\/\\\",\\\"categories\\\":[\\\"troubleshooting\\\"]},\\\"25802\\\":{\\\"title\\\":\\\"aioseo_sitemap_additional_pages\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_sitemap_additional_pages\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"24928\\\":{\\\"title\\\":\\\"Including Custom Fields in the TruSEO Page Analysis\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/including-custom-fields-in-the-seo-page-analysis\\\\\\/\\\",\\\"categories\\\":[\\\"content-type-settings\\\",\\\"search-appearance\\\",\\\"truseo\\\"]},\\\"24285\\\":{\\\"title\\\":\\\"aioseo_prev_link\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_prev_link\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"24284\\\":{\\\"title\\\":\\\"aioseo_next_link\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_next_link\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"23717\\\":{\\\"title\\\":\\\"aioseo_canonical_url\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_canonical_url\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"23604\\\":{\\\"title\\\":\\\"aioseo_schema_breadcrumbs_home\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_schema_breadcrumbs_home\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"23448\\\":{\\\"title\\\":\\\"aioseo_schema_disable\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_schema_disable\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"23447\\\":{\\\"title\\\":\\\"aioseo_robots_meta\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_robots_meta\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"23446\\\":{\\\"title\\\":\\\"aioseo_disable\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_disable\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"23438\\\":{\\\"title\\\":\\\"aioseo_disable_title_rewrites\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_disable_title_rewrites\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"23437\\\":{\\\"title\\\":\\\"aioseo_post_metabox_priority\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_post_metabox_priority\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"23436\\\":{\\\"title\\\":\\\"aioseo_show_seo_news\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_show_seo_news\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"23433\\\":{\\\"title\\\":\\\"aioseo_show_in_admin_bar\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_show_in_admin_bar\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"23423\\\":{\\\"title\\\":\\\"aioseo_keywords\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_keywords\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"23350\\\":{\\\"title\\\":\\\"aioseo_title\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_title\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"23351\\\":{\\\"title\\\":\\\"aioseo_description\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo_description\\\\\\/\\\",\\\"categories\\\":[\\\"filter-hooks\\\"]},\\\"23415\\\":{\\\"title\\\":\\\"Troubleshooting Action Scheduler issues with AIOSEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/troubleshooting-action-scheduler-issues\\\\\\/\\\",\\\"categories\\\":[\\\"troubleshooting\\\"]},\\\"20504\\\":{\\\"title\\\":\\\"Where Did my SEO Keywords go in All in One SEO v4.0?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/where-did-my-seo-keywords-go-in-all-in-one-seo-v4-0\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"frequently-asked-questions\\\",\\\"post-page-settings\\\",\\\"search-appearance\\\"]},\\\"18792\\\":{\\\"title\\\":\\\"Sitemap rewrite rules for NGINX\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/xml-sitemap-rewrite-rules-for-nginx\\\\\\/\\\",\\\"categories\\\":[\\\"rss-sitemap\\\",\\\"video-sitemap\\\",\\\"xml-sitemap\\\"]},\\\"18793\\\":{\\\"title\\\":\\\"Unfiltered HTML Capability is Required\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/unfiltered-html-capability\\\\\\/\\\",\\\"categories\\\":[\\\"troubleshooting\\\"]},\\\"18794\\\":{\\\"title\\\":\\\"Deprecated Open Graph Settings in All in One SEO version 4.0\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/deprecated-opengraph-settings\\\\\\/\\\",\\\"categories\\\":[\\\"social-networks\\\"]},\\\"18795\\\":{\\\"title\\\":\\\"Why does the character counter for SEO titles show a different count?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/why-does-the-character-counter-for-seo-titles-show-a-different-count\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\",\\\"post-page-settings\\\"]},\\\"18796\\\":{\\\"title\\\":\\\"Adding nofollow, sponsored, UGC and title attributes to links\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/adding-nofollow-sponsored-and-title-attributes-to-links\\\\\\/\\\",\\\"categories\\\":[\\\"post-page-settings\\\"]},\\\"18797\\\":{\\\"title\\\":\\\"Setting the SEO for WooCommerce Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-seo-for-woocommerce-content\\\\\\/\\\",\\\"categories\\\":[\\\"search-appearance\\\",\\\"woocommerce\\\"]},\\\"18798\\\":{\\\"title\\\":\\\"All in One SEO uses the WordPress REST API\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/aioseo-uses-rest-api\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\"]},\\\"18799\\\":{\\\"title\\\":\\\"How to Remove All Settings and Data When you Uninstall All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-remove-all-settings-and-data-when-you-uninstall-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"general-settings\\\"]},\\\"18800\\\":{\\\"title\\\":\\\"How to Disable TruSEO Content Analysis\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-disable-truseo-content-analysis\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"general-settings\\\",\\\"truseo\\\"]},\\\"18801\\\":{\\\"title\\\":\\\"Enabling Automatic Updates for All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/enabling-automatic-updates-for-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"general-settings\\\"]},\\\"18802\\\":{\\\"title\\\":\\\"Hiding Plugin Notifications in the Notifications Center\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/hiding-plugin-notifications-in-the-notifications-center\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"general-settings\\\"]},\\\"18803\\\":{\\\"title\\\":\\\"How to Hide the AIOSEO Settings on the Edit Content Screens in WordPress\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-hide-the-aioseo-settings-on-the-edit-content-screens-in-wordpress\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"content-type-settings\\\",\\\"post-page-settings\\\",\\\"search-appearance\\\"]},\\\"18804\\\":{\\\"title\\\":\\\"Setting Noindex and Nofollow on Paginated Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-noindex-and-nofollow-on-paginated-content\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"search-appearance\\\"]},\\\"18805\\\":{\\\"title\\\":\\\"Setting Unique SEO Titles and Descriptions for Paginated Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-unique-seo-titles-and-descriptions-for-paginated-content\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"search-appearance\\\"]},\\\"18806\\\":{\\\"title\\\":\\\"Setting the SEO Title and Description Format for Custom Post Type Archives\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-seo-title-and-description-format-for-custom-post-type-archives\\\\\\/\\\",\\\"categories\\\":[\\\"archive-settings\\\",\\\"search-appearance\\\"]},\\\"18807\\\":{\\\"title\\\":\\\"Meta Keyword Settings in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/keyword-settings\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"search-appearance\\\"]},\\\"18808\\\":{\\\"title\\\":\\\"Using the Quick Edit Feature in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-the-quick-edit-feature-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"post-page-settings\\\"]},\\\"18809\\\":{\\\"title\\\":\\\"How to FTP to your web server\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-ftp-to-your-web-server\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\"]},\\\"18810\\\":{\\\"title\\\":\\\"How to manually install All in One SEO Pro when the file is too big\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-manually-install-all-in-one-seo-pro-when-the-file-is-too-big\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\",\\\"installation\\\"]},\\\"18811\\\":{\\\"title\\\":\\\"How to Upgrade From All in One SEO Lite to Pro\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-upgrade-from-all-in-one-seo-lite-to-pro\\\\\\/\\\",\\\"categories\\\":[\\\"getting-started\\\",\\\"installation\\\"]},\\\"18812\\\":{\\\"title\\\":\\\"Installation instructions for WordPress.com Users\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/installation-instructions-for-wordpress-com-users\\\\\\/\\\",\\\"categories\\\":[\\\"installation\\\"]},\\\"18814\\\":{\\\"title\\\":\\\"Configuring the Twitter Settings for Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/configuring-the-twitter-settings-for-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"post-page-settings\\\",\\\"social-networks\\\",\\\"twitter-settings\\\"]},\\\"18815\\\":{\\\"title\\\":\\\"Configuring the Facebook Settings for Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/configuring-the-facebook-settings-for-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"facebook-settings\\\",\\\"post-page-settings\\\",\\\"social-networks\\\"]},\\\"18816\\\":{\\\"title\\\":\\\"Hiding the AIOSEO Column on Taxonomy Screens\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/hiding-the-aioseo-column-on-taxonomy-screens\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"category-tag-settings\\\",\\\"general-settings\\\"]},\\\"18818\\\":{\\\"title\\\":\\\"Setting the Sitemap Priority and Frequency for Individual Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-sitemap-priority-and-frequency-for-individual-content\\\\\\/\\\",\\\"categories\\\":[\\\"post-page-settings\\\",\\\"xml-sitemap\\\"]},\\\"18819\\\":{\\\"title\\\":\\\"Setting the Robots Meta for Individual Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-robots-meta-for-individual-content\\\\\\/\\\",\\\"categories\\\":[\\\"post-page-settings\\\"]},\\\"18821\\\":{\\\"title\\\":\\\"Individual Post\\\\\\/Page Settings\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/post-settings\\\\\\/\\\",\\\"categories\\\":[\\\"post-page-settings\\\"]},\\\"18822\\\":{\\\"title\\\":\\\"Bad Bot Blocker\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/bad-bot-blocker\\\\\\/\\\",\\\"categories\\\":[\\\"bad-bot-blocker\\\"]},\\\"18823\\\":{\\\"title\\\":\\\"How to Fix a 404 Error When Viewing Your Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-fix-a-404-error-when-viewing-your-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\",\\\"google-news-sitemap\\\",\\\"rss-sitemap\\\",\\\"troubleshooting\\\",\\\"video-sitemap\\\",\\\"xml-sitemap\\\"]},\\\"18825\\\":{\\\"title\\\":\\\"When to use NOINDEX or the robots.txt?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/when-to-use-noindex-or-the-robots-txt\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\",\\\"robots-txt\\\",\\\"search-appearance\\\",\\\"tools\\\"]},\\\"18826\\\":{\\\"title\\\":\\\"Support for Videos Embedded Using the Media Library\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/support-for-videos-embedded-using-the-media-library\\\\\\/\\\",\\\"categories\\\":[\\\"video-sitemap\\\"]},\\\"18827\\\":{\\\"title\\\":\\\"Supported Videos\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/supported-videos\\\\\\/\\\",\\\"categories\\\":[\\\"video-sitemap\\\"]},\\\"18828\\\":{\\\"title\\\":\\\"Performance Settings\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/performance-settings\\\\\\/\\\",\\\"categories\\\":[\\\"performance\\\"]},\\\"18830\\\":{\\\"title\\\":\\\"Setting the SEO Title and Description Format for Author and Date Archives\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-seo-title-and-description-format-for-author-and-date-archives\\\\\\/\\\",\\\"categories\\\":[\\\"archive-settings\\\",\\\"search-appearance\\\"]},\\\"18831\\\":{\\\"title\\\":\\\"Using Custom Fields in Titles and Descriptions\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/custom-fields-in-titles-and-descriptions\\\\\\/\\\",\\\"categories\\\":[\\\"content-type-settings\\\",\\\"post-page-settings\\\",\\\"search-appearance\\\"]},\\\"18832\\\":{\\\"title\\\":\\\"Using the Focus Keyphrase to Analyze Your Content\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-the-focus-keyphrase-to-analyze-your-content\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\",\\\"post-page-settings\\\",\\\"truseo\\\"]},\\\"18833\\\":{\\\"title\\\":\\\"Using the Robots.txt Tool in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-the-robots-txt-tool-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"robots-txt\\\",\\\"tools\\\"]},\\\"18834\\\":{\\\"title\\\":\\\"Using the Robots Meta Settings in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-the-robots-meta-settings-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"archive-settings\\\",\\\"category-tag-settings\\\",\\\"content-type-settings\\\",\\\"media-settings\\\",\\\"post-page-settings\\\",\\\"search-appearance\\\",\\\"taxonomy-settings\\\"]},\\\"18835\\\":{\\\"title\\\":\\\"Noindex Settings\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/noindex-settings\\\\\\/\\\",\\\"categories\\\":[\\\"search-appearance\\\"]},\\\"18838\\\":{\\\"title\\\":\\\"Hiding the AIOSEO Admin Bar Menu\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/hiding-the-aioseo-admin-bar-menu\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"general-settings\\\"]},\\\"18839\\\":{\\\"title\\\":\\\"Hiding the AIOSEO Dashboard Widgets\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/hiding-the-aioseo-dashboard-widget\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"general-settings\\\"]},\\\"18840\\\":{\\\"title\\\":\\\"Hiding the AIOSEO Column on All Posts Screens\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/hiding-the-aioseo-column-on-all-posts-screens\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"general-settings\\\"]},\\\"18841\\\":{\\\"title\\\":\\\"Display Settings\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/display-settings\\\\\\/\\\",\\\"categories\\\":[\\\"display-settings\\\"]},\\\"18842\\\":{\\\"title\\\":\\\"Setting the SEO Title and Description Format for Media Attachments\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-seo-title-and-description-format-for-media-attachments\\\\\\/\\\",\\\"categories\\\":[\\\"media-settings\\\",\\\"search-appearance\\\"]},\\\"18843\\\":{\\\"title\\\":\\\"Showing or Hiding Your Content in Search Results\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/showing-or-hiding-your-content-in-search-results\\\\\\/\\\",\\\"categories\\\":[\\\"archive-settings\\\",\\\"category-tag-settings\\\",\\\"content-type-settings\\\",\\\"media-settings\\\",\\\"post-page-settings\\\",\\\"search-appearance\\\",\\\"taxonomy-settings\\\"]},\\\"18844\\\":{\\\"title\\\":\\\"Content Type Settings\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/custom-post-type-settings\\\\\\/\\\",\\\"categories\\\":[\\\"content-type-settings\\\",\\\"search-appearance\\\"]},\\\"18845\\\":{\\\"title\\\":\\\"What Are Media Attachments and Should I Submit Them to Search Engines?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/what-are-media-attachments-and-should-i-submit-them-to-search-engines\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\",\\\"media-settings\\\"]},\\\"18846\\\":{\\\"title\\\":\\\"Setting the SEO Title and Description Format for Custom Taxonomies\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-seo-title-and-description-format-for-custom-taxonomies\\\\\\/\\\",\\\"categories\\\":[\\\"category-tag-settings\\\",\\\"search-appearance\\\",\\\"taxonomy-settings\\\"]},\\\"18847\\\":{\\\"title\\\":\\\"Setting the SEO Title and Description Format for Custom Post Types\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-seo-title-and-description-format-for-custom-post-types\\\\\\/\\\",\\\"categories\\\":[\\\"content-type-settings\\\",\\\"search-appearance\\\"]},\\\"18848\\\":{\\\"title\\\":\\\"Setting the SEO Title and Description Format for Tags\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-seo-title-and-description-format-for-tags\\\\\\/\\\",\\\"categories\\\":[\\\"category-tag-settings\\\",\\\"search-appearance\\\",\\\"taxonomy-settings\\\"]},\\\"18849\\\":{\\\"title\\\":\\\"Setting the SEO Title and Description Format for Categories\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-seo-title-and-description-format-for-categories\\\\\\/\\\",\\\"categories\\\":[\\\"category-tag-settings\\\",\\\"search-appearance\\\",\\\"taxonomy-settings\\\"]},\\\"18850\\\":{\\\"title\\\":\\\"Setting the SEO Title and Description Format for Pages\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-seo-title-and-description-format-for-pages\\\\\\/\\\",\\\"categories\\\":[\\\"content-type-settings\\\",\\\"post-page-settings\\\",\\\"search-appearance\\\"]},\\\"18851\\\":{\\\"title\\\":\\\"Setting the SEO Title and Description Format for Posts\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-seo-title-and-description-format-for-posts\\\\\\/\\\",\\\"categories\\\":[\\\"content-type-settings\\\",\\\"post-page-settings\\\",\\\"search-appearance\\\"]},\\\"18852\\\":{\\\"title\\\":\\\"Title Settings\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/title-settings\\\\\\/\\\",\\\"categories\\\":[\\\"search-appearance\\\"]},\\\"18853\\\":{\\\"title\\\":\\\"Setting the SEO for Your Home Page\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-seo-for-your-home-page\\\\\\/\\\",\\\"categories\\\":[\\\"home-page-settings\\\",\\\"search-appearance\\\"]},\\\"18854\\\":{\\\"title\\\":\\\"General Settings\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/general-settings\\\\\\/\\\",\\\"categories\\\":[\\\"general-settings\\\"]},\\\"18855\\\":{\\\"title\\\":\\\"How to Add Your License Key for All in One SEO Pro\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-add-your-license-key-in-all-in-one-seo-pro\\\\\\/\\\",\\\"categories\\\":[\\\"general-settings\\\",\\\"getting-started\\\"]},\\\"18856\\\":{\\\"title\\\":\\\"Canonical URLs in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/canonical-urls-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\",\\\"search-appearance\\\"]},\\\"18858\\\":{\\\"title\\\":\\\"Adding non-WordPress Content to the Video Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/adding-non-wordpress-content-to-the-video-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"video-sitemap\\\"]},\\\"18860\\\":{\\\"title\\\":\\\"Troubleshooting Problems With Sharing Content on Twitter\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/troubleshooting-problems-with-sharing-content-on-twitter\\\\\\/\\\",\\\"categories\\\":[\\\"social-networks\\\",\\\"troubleshooting\\\",\\\"twitter-settings\\\"]},\\\"18861\\\":{\\\"title\\\":\\\"Troubleshooting Problems With Sharing Content on Facebook\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/troubleshooting-problems-with-sharing-content-on-facebook\\\\\\/\\\",\\\"categories\\\":[\\\"facebook-settings\\\",\\\"social-networks\\\",\\\"troubleshooting\\\"]},\\\"18862\\\":{\\\"title\\\":\\\"Getting Started With Pinterest Rich Pins\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-social-meta-for-pinterest-rich-pins\\\\\\/\\\",\\\"categories\\\":[\\\"pinterest-settings\\\",\\\"social-networks\\\"]},\\\"18863\\\":{\\\"title\\\":\\\"Setting the Content Publisher for Twitter\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-content-publisher-for-twitter\\\\\\/\\\",\\\"categories\\\":[\\\"social-networks\\\",\\\"twitter-settings\\\"]},\\\"18865\\\":{\\\"title\\\":\\\"Submitting a Sitemap to Yandex\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/submitting-a-sitemap-to-yandex\\\\\\/\\\",\\\"categories\\\":[\\\"rss-sitemap\\\",\\\"video-sitemap\\\",\\\"xml-sitemap\\\"]},\\\"18866\\\":{\\\"title\\\":\\\"Submitting a Sitemap to Bing\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/submitting-a-sitemap-to-bing\\\\\\/\\\",\\\"categories\\\":[\\\"bing-webmaster-tools\\\",\\\"rss-sitemap\\\",\\\"video-sitemap\\\",\\\"xml-sitemap\\\"]},\\\"18867\\\":{\\\"title\\\":\\\"Submitting a Sitemap to Google\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/submitting-a-sitemap-to-google\\\\\\/\\\",\\\"categories\\\":[\\\"google-news-sitemap\\\",\\\"google-search-console\\\",\\\"rss-sitemap\\\",\\\"video-sitemap\\\",\\\"xml-sitemap\\\"]},\\\"18868\\\":{\\\"title\\\":\\\"Including Date and Author Archives in Your XML Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/including-date-and-author-archives-in-your-xml-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"xml-sitemap\\\"]},\\\"18869\\\":{\\\"title\\\":\\\"Choosing Which Content to Include in Your Video Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/choosing-which-content-to-include-in-your-video-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"video-sitemap\\\"]},\\\"18870\\\":{\\\"title\\\":\\\"Choosing Which Content to Include in Your XML Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/choosing-which-content-to-include-in-your-xml-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"xml-sitemap\\\"]},\\\"18871\\\":{\\\"title\\\":\\\"Using Sitemap Indexes and Pagination\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-sitemap-indexes-and-pagination\\\\\\/\\\",\\\"categories\\\":[\\\"video-sitemap\\\",\\\"xml-sitemap\\\"]},\\\"18872\\\":{\\\"title\\\":\\\"How to Disable Sitemaps in All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-disable-sitemaps-in-all-in-one-seo\\\\\\/\\\",\\\"categories\\\":[\\\"google-news-sitemap\\\",\\\"rss-sitemap\\\",\\\"video-sitemap\\\",\\\"xml-sitemap\\\"]},\\\"18873\\\":{\\\"title\\\":\\\"Baidu Webmaster Tools Verification\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/baidu-webmaster-tools-verification\\\\\\/\\\",\\\"categories\\\":[\\\"webmaster-tools\\\",\\\"webmaster-verification\\\"]},\\\"18874\\\":{\\\"title\\\":\\\"Setting Twitter Social Meta for Your Homepage\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-twitter-social-meta-for-your-homepage\\\\\\/\\\",\\\"categories\\\":[\\\"home-page-settings\\\",\\\"social-networks\\\",\\\"twitter-settings\\\"]},\\\"18875\\\":{\\\"title\\\":\\\"Setting Facebook Social Meta for Your Homepage\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-facebook-social-meta-for-your-homepage\\\\\\/\\\",\\\"categories\\\":[\\\"facebook-settings\\\",\\\"home-page-settings\\\",\\\"social-networks\\\"]},\\\"18876\\\":{\\\"title\\\":\\\"Setting the Card Type for Twitter\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-card-type-for-twitter\\\\\\/\\\",\\\"categories\\\":[\\\"social-networks\\\",\\\"twitter-settings\\\"]},\\\"18877\\\":{\\\"title\\\":\\\"Setting the Object Types for Facebook\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-object-types-for-facebook\\\\\\/\\\",\\\"categories\\\":[\\\"facebook-settings\\\",\\\"social-networks\\\"]},\\\"18879\\\":{\\\"title\\\":\\\"Setting the Priority and Frequency for Content in the Video Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-priority-and-frequency-for-content-in-the-video-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"video-sitemap\\\"]},\\\"18880\\\":{\\\"title\\\":\\\"Setting the Priority and Frequency for Content in the XML Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-priority-and-frequency-for-content-in-the-xml-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"xml-sitemap\\\"]},\\\"18881\\\":{\\\"title\\\":\\\"How to Exclude Content from Your RSS Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-exclude-content-from-your-rss-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"rss-sitemap\\\"]},\\\"18882\\\":{\\\"title\\\":\\\"How to Exclude Content from Your Google News Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-exclude-content-from-your-google-news-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"google-news-sitemap\\\"]},\\\"18883\\\":{\\\"title\\\":\\\"How to Exclude Content from Your Video Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-exclude-content-from-your-video-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"video-sitemap\\\"]},\\\"18884\\\":{\\\"title\\\":\\\"How to Exclude Content from Your XML Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-exclude-content-from-your-xml-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"xml-sitemap\\\"]},\\\"18885\\\":{\\\"title\\\":\\\"Setting Article Tags for Facebook\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-article-tags-for-facebook\\\\\\/\\\",\\\"categories\\\":[\\\"facebook-settings\\\",\\\"social-networks\\\"]},\\\"18886\\\":{\\\"title\\\":\\\"Setting the Content Author for Twitter\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-content-author-for-twitter\\\\\\/\\\",\\\"categories\\\":[\\\"social-networks\\\",\\\"twitter-settings\\\"]},\\\"18887\\\":{\\\"title\\\":\\\"Setting the Content Author for Facebook\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-content-author-for-facebook\\\\\\/\\\",\\\"categories\\\":[\\\"facebook-settings\\\",\\\"social-networks\\\"]},\\\"18888\\\":{\\\"title\\\":\\\"Setting the Content Publisher for Facebook\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-the-content-publisher-for-facebook\\\\\\/\\\",\\\"categories\\\":[\\\"facebook-settings\\\",\\\"social-networks\\\"]},\\\"18889\\\":{\\\"title\\\":\\\"How to Create a Google News Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-create-a-google-news-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"google-news-sitemap\\\"]},\\\"18890\\\":{\\\"title\\\":\\\"Including Videos in Custom Fields in Your Video Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/including-videos-in-custom-fields-in-your-video-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"video-sitemap\\\"]},\\\"18891\\\":{\\\"title\\\":\\\"What is a Dynamically Generated Sitemap and Why is it Better to Use?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/what-is-a-dynamically-generated-sitemap-and-why-is-it-better-to-use\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\",\\\"video-sitemap\\\",\\\"xml-sitemap\\\"]},\\\"18892\\\":{\\\"title\\\":\\\"How to Create a Video Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-create-a-video-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"video-sitemap\\\"]},\\\"18893\\\":{\\\"title\\\":\\\"Adding Your Facebook Admin ID\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/adding-your-facebook-admin-id\\\\\\/\\\",\\\"categories\\\":[\\\"facebook-settings\\\",\\\"social-networks\\\"]},\\\"18894\\\":{\\\"title\\\":\\\"Adding Your Facebook App ID\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/adding-your-facebook-app-id\\\\\\/\\\",\\\"categories\\\":[\\\"facebook-settings\\\",\\\"social-networks\\\"]},\\\"18895\\\":{\\\"title\\\":\\\"Access Control Settings\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/access-control-settings\\\\\\/\\\",\\\"categories\\\":[\\\"access-control-settings\\\"]},\\\"18896\\\":{\\\"title\\\":\\\"Advanced Settings for Google Analytics\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/advanced-settings-for-google-analytics\\\\\\/\\\",\\\"categories\\\":[\\\"google-analytics\\\"]},\\\"18897\\\":{\\\"title\\\":\\\"Miscellaneous Site Verification\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/miscellaneous-site-verification\\\\\\/\\\",\\\"categories\\\":[\\\"webmaster-tools\\\",\\\"webmaster-verification\\\"]},\\\"18898\\\":{\\\"title\\\":\\\"Displaying Your Social Media Profiles in Knowledge Panel\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/displaying-your-social-media-profiles-in-knowledge-panel\\\\\\/\\\",\\\"categories\\\":[\\\"schema-settings\\\",\\\"social-networks\\\"]},\\\"18899\\\":{\\\"title\\\":\\\"How to Create an RSS Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-create-an-rss-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"rss-sitemap\\\"]},\\\"18900\\\":{\\\"title\\\":\\\"Excluding Images from the XML Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/excluding-images-from-the-xml-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"xml-sitemap\\\"]},\\\"18901\\\":{\\\"title\\\":\\\"Adding non-WordPress Content to the XML Sitemap\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/adding-non-wordpress-content-to-the-xml-sitemap\\\\\\/\\\",\\\"categories\\\":[\\\"xml-sitemap\\\"]},\\\"18903\\\":{\\\"title\\\":\\\"Setting a Default Image for Twitter\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-a-default-image-for-twitter\\\\\\/\\\",\\\"categories\\\":[\\\"social-networks\\\",\\\"twitter-settings\\\"]},\\\"18904\\\":{\\\"title\\\":\\\"Setting a Default Image for Facebook\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-a-default-image-for-facebook\\\\\\/\\\",\\\"categories\\\":[\\\"facebook-settings\\\",\\\"social-networks\\\"]},\\\"18905\\\":{\\\"title\\\":\\\"Setting a Title Separator\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-a-title-separator\\\\\\/\\\",\\\"categories\\\":[\\\"search-appearance\\\"]},\\\"18906\\\":{\\\"title\\\":\\\"How to Protect Your Content With RSS Content Settings\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-protect-your-content-with-rss-content-settings\\\\\\/\\\",\\\"categories\\\":[\\\"rss-content-settings\\\"]},\\\"18907\\\":{\\\"title\\\":\\\"How to Connect Your Site with Google Tag Manager\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-connect-your-site-with-google-tag-manager\\\\\\/\\\",\\\"categories\\\":[\\\"google-analytics\\\"]},\\\"18908\\\":{\\\"title\\\":\\\"How to Connect Your Site with Google Analytics\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-connect-your-site-with-google-analytics\\\\\\/\\\",\\\"categories\\\":[\\\"google-analytics\\\"]},\\\"18909\\\":{\\\"title\\\":\\\"How to Verify Your Site with Pinterest\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-verify-your-site-with-pinterest\\\\\\/\\\",\\\"categories\\\":[\\\"pinterest-settings\\\",\\\"social-networks\\\",\\\"webmaster-tools\\\",\\\"webmaster-verification\\\"]},\\\"18910\\\":{\\\"title\\\":\\\"How to Verify Your Site with Yandex Webmaster Tools\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-verify-your-site-with-yandex-webmaster-tools\\\\\\/\\\",\\\"categories\\\":[\\\"webmaster-tools\\\",\\\"webmaster-verification\\\"]},\\\"18911\\\":{\\\"title\\\":\\\"How to Verify Your Site with Bing Webmaster Tools\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-verify-your-site-with-bing-webmaster-tools\\\\\\/\\\",\\\"categories\\\":[\\\"bing-webmaster-tools\\\",\\\"webmaster-tools\\\",\\\"webmaster-verification\\\"]},\\\"18912\\\":{\\\"title\\\":\\\"How to Verify Your Site with Google Search Console\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-verify-your-site-with-google-search-console\\\\\\/\\\",\\\"categories\\\":[\\\"google-search-console\\\",\\\"webmaster-tools\\\",\\\"webmaster-verification\\\"]},\\\"18913\\\":{\\\"title\\\":\\\"Usage Tracking\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/usage-tracking\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\"]},\\\"18915\\\":{\\\"title\\\":\\\"How do I use All in One SEO in my language?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-do-i-use-all-in-one-seo-in-my-language\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\"]},\\\"18920\\\":{\\\"title\\\":\\\"NGINX rewrite rules for Robots.txt\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/nginx-rewrite-rules-for-robots-txt\\\\\\/\\\",\\\"categories\\\":[\\\"robots-txt\\\",\\\"tools\\\"]},\\\"18927\\\":{\\\"title\\\":\\\"Supported PHP Versions for All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/supported-php-version\\\\\\/\\\",\\\"categories\\\":[\\\"troubleshooting\\\"]},\\\"18929\\\":{\\\"title\\\":\\\"Using a different CDN for script enqueuing\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/using-a-different-cdn-for-script-enqueuing\\\\\\/\\\",\\\"categories\\\":[\\\"troubleshooting\\\"]},\\\"18930\\\":{\\\"title\\\":\\\"How do I get Google to show sitelinks for my site?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-do-i-get-google-to-show-sitelinks-for-my-site\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\"]},\\\"18954\\\":{\\\"title\\\":\\\"How does the import process for SEO data work?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-does-the-import-process-for-seo-data-work\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\",\\\"importer-exporter\\\",\\\"tools\\\"]},\\\"18960\\\":{\\\"title\\\":\\\"Robots.txt Editor for Multisite Networks\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/robots-txt-editor-for-multisite-networks\\\\\\/\\\",\\\"categories\\\":[\\\"multisite-networks\\\",\\\"robots-txt\\\"]},\\\"18961\\\":{\\\"title\\\":\\\"What are the minimum requirements for All in One SEO?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/what-are-the-minimum-requirements-for-all-in-one-seo-pack\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\"]},\\\"18964\\\":{\\\"title\\\":\\\"How do I use your API code examples?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-do-i-use-your-api-code-examples\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\"]},\\\"18969\\\":{\\\"title\\\":\\\"XML Parsing Error - This page contains the following errors\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/this-page-contains-the-following-errors\\\\\\/\\\",\\\"categories\\\":[\\\"google-news-sitemap\\\",\\\"troubleshooting\\\",\\\"video-sitemap\\\",\\\"xml-sitemap\\\"]},\\\"18972\\\":{\\\"title\\\":\\\"The File Editor or Robots.txt modules are missing\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/the-file-editor-or-robots-txt-modules-are-missing\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\"]},\\\"18977\\\":{\\\"title\\\":\\\"Excluding the XML Sitemap from caching\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/excluding-the-xml-sitemap-from-caching\\\\\\/\\\",\\\"categories\\\":[\\\"xml-sitemap\\\"]},\\\"18982\\\":{\\\"title\\\":\\\"Why doesn\'t the title and description I set appear in search results?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/why-doesnt-the-title-and-description-i-set-appear-in-search-results\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\",\\\"post-page-settings\\\"]},\\\"18983\\\":{\\\"title\\\":\\\"Can I remove the date from Google search results?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/can-i-remove-the-date-from-google-search-results\\\\\\/\\\",\\\"categories\\\":[\\\"frequently-asked-questions\\\"]},\\\"18985\\\":{\\\"title\\\":\\\"Setting up HTTPS SSL\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/setting-up-https-ssl\\\\\\/\\\",\\\"categories\\\":[\\\"general-seo-topics\\\"]},\\\"18995\\\":{\\\"title\\\":\\\"How to Increase the WordPress PHP Memory Limit\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/increase-wordpress-php-memory-limit\\\\\\/\\\",\\\"categories\\\":[\\\"troubleshooting\\\"]},\\\"19002\\\":{\\\"title\\\":\\\"Checking Index Status in Google Search Results\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/checking-index-status-in-google-search-results\\\\\\/\\\",\\\"categories\\\":[\\\"general-seo-topics\\\"]},\\\"19006\\\":{\\\"title\\\":\\\"SEO Data Importer\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/seo-data-importer\\\\\\/\\\",\\\"categories\\\":[\\\"seo-data-importer\\\"]},\\\"19008\\\":{\\\"title\\\":\\\"How to troubleshoot issues with All in One SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/how-to-troubleshoot-issues-with-all-in-one-seo-pack\\\\\\/\\\",\\\"categories\\\":[\\\"troubleshooting\\\"]},\\\"19010\\\":{\\\"title\\\":\\\"Quality Guidelines for SEO Titles and Descriptions\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/quality-guidelines-for-seo-titles-and-descriptions\\\\\\/\\\",\\\"categories\\\":[\\\"general-seo-topics\\\"]},\\\"19016\\\":{\\\"title\\\":\\\"Top Tips for Good On-Page SEO\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/top-tips-for-good-on-page-seo\\\\\\/\\\",\\\"categories\\\":[\\\"general-seo-topics\\\"]},\\\"19017\\\":{\\\"title\\\":\\\"Meta Descriptions\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/meta-descriptions\\\\\\/\\\",\\\"categories\\\":[\\\"general-seo-topics\\\"]},\\\"19028\\\":{\\\"title\\\":\\\"What is SEO meta?\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/what-is-seo-meta\\\\\\/\\\",\\\"categories\\\":[\\\"getting-started\\\"]},\\\"19029\\\":{\\\"title\\\":\\\"Social Meta Settings - Individual Page\\\\\\/Post Settings\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/social-meta-settings-individual-pagepost-settings\\\\\\/\\\",\\\"categories\\\":[\\\"post-page-settings\\\",\\\"social-networks\\\"]},\\\"19030\\\":{\\\"title\\\":\\\"File Editor Module\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/file-editor-module\\\\\\/\\\",\\\"categories\\\":[\\\"file-editor\\\"]},\\\"19031\\\":{\\\"title\\\":\\\"Social Meta Settings\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/social-meta-module\\\\\\/\\\",\\\"categories\\\":[\\\"social-networks\\\"]},\\\"19032\\\":{\\\"title\\\":\\\"Importer &amp; Exporter Module\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/importer-exporter-module\\\\\\/\\\",\\\"categories\\\":[\\\"importer-exporter\\\",\\\"tools\\\"]},\\\"19034\\\":{\\\"title\\\":\\\"Feature Manager\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/feature-manager\\\\\\/\\\",\\\"categories\\\":[\\\"feature-manager\\\"]},\\\"19035\\\":{\\\"title\\\":\\\"Advanced Settings for All in One SEO Pack\\\",\\\"url\\\":\\\"https:\\\\\\/\\\\\\/aioseo.com\\\\\\/docs\\\\\\/all-in-one-seo-pack-advanced-settings\\\\\\/\\\",\\\"categories\\\":[\\\"advanced-settings\\\"]}}}\"", "0", "2026-02-07 09:06:22", "2026-01-31 09:06:22", "2026-01-31 09:06:22");
INSERT INTO `wp_aioseo_cache` VALUES("18", "action_scheduler_log_cleanup", "true", "0", "2026-02-06 05:12:25", "2026-01-31 09:07:41", "2026-02-05 05:12:25");
INSERT INTO `wp_aioseo_cache` VALUES("443", "wp_notices", "[]", "0", "2026-02-06 05:48:44", "2026-02-02 04:56:39", "2026-02-05 05:48:44");
INSERT INTO `wp_aioseo_cache` VALUES("444", "license_features", "[{\"license_level\":\"pro\",\"section\":\"schema\",\"feature\":\"event\"},{\"license_level\":\"elite\",\"section\":\"schema\",\"feature\":\"event\"},{\"license_level\":\"elite\",\"section\":\"schema\",\"feature\":\"job-posting\"},{\"license_level\":\"elite\",\"section\":\"tools\",\"feature\":\"network-tools-site-activation\"},{\"license_level\":\"elite\",\"section\":\"tools\",\"feature\":\"network-tools-database\"},{\"license_level\":\"elite\",\"section\":\"tools\",\"feature\":\"network-tools-import-export\"},{\"license_level\":\"elite\",\"section\":\"tools\",\"feature\":\"network-tools-robots\"},{\"license_level\":\"elite\",\"section\":\"search-statistics\",\"feature\":\"seo-statistics\"},{\"license_level\":\"elite\",\"section\":\"search-statistics\",\"feature\":\"keyword-rankings\"},{\"license_level\":\"elite\",\"section\":\"search-statistics\",\"feature\":\"keyword-rankings-pages\"},{\"license_level\":\"elite\",\"section\":\"search-statistics\",\"feature\":\"post-detail\"},{\"license_level\":\"elite\",\"section\":\"search-statistics\",\"feature\":\"post-detail-page-speed\"},{\"license_level\":\"elite\",\"section\":\"search-statistics\",\"feature\":\"post-detail-seo-statistics\"},{\"license_level\":\"elite\",\"section\":\"search-statistics\",\"feature\":\"post-detail-keywords\"},{\"license_level\":\"elite\",\"section\":\"search-statistics\",\"feature\":\"post-detail-focus-keyword-trend\"},{\"license_level\":\"elite\",\"section\":\"search-statistics\",\"feature\":\"keyword-tracking\"},{\"license_level\":\"elite\",\"section\":\"search-statistics\",\"feature\":\"post-detail-keyword-tracking\"},{\"license_level\":\"elite\",\"section\":\"search-statistics\",\"feature\":\"content-rankings\"},{\"license_level\":\"elite\",\"section\":\"seo-revisions\",\"feature\":\"revisions:-1\"},{\"license_level\":\"pro\",\"section\":\"seo-revisions\",\"feature\":\"revisions:30\"},{\"license_level\":\"plus\",\"section\":\"seo-revisions\",\"feature\":\"revisions:15\"},{\"license_level\":\"pro\",\"section\":\"general\",\"feature\":\"cornerstone-content\"},{\"license_level\":\"elite\",\"section\":\"general\",\"feature\":\"cornerstone-content\"},{\"license_level\":\"elite\",\"section\":\"search-statistics\",\"feature\":\"index-status\"},{\"license_level\":\"plus\",\"section\":\"aioseo-eeat\",\"feature\":\"author-info\"},{\"license_level\":\"pro\",\"section\":\"aioseo-eeat\",\"feature\":\"author-info\"},{\"license_level\":\"elite\",\"section\":\"aioseo-eeat\",\"feature\":\"author-info\"},{\"license_level\":\"pro\",\"section\":\"aioseo-eeat\",\"feature\":\"author-archive-bio\"},{\"license_level\":\"elite\",\"section\":\"aioseo-eeat\",\"feature\":\"author-archive-bio\"},{\"license_level\":\"pro\",\"section\":\"aioseo-eeat\",\"feature\":\"post-reviewer\"},{\"license_level\":\"elite\",\"section\":\"aioseo-eeat\",\"feature\":\"post-reviewer\"},{\"license_level\":\"elite\",\"section\":\"search-statistics\",\"feature\":\"keyword-rank-tracker:100\"},{\"license_level\":\"plus\",\"section\":\"redirects\",\"feature\":\"http-headers\"},{\"license_level\":\"pro\",\"section\":\"redirects\",\"feature\":\"http-headers\"},{\"license_level\":\"elite\",\"section\":\"redirects\",\"feature\":\"http-headers\"},{\"license_level\":\"pro\",\"section\":\"redirects\",\"feature\":\"logs\"},{\"license_level\":\"elite\",\"section\":\"redirects\",\"feature\":\"logs\"},{\"license_level\":\"pro\",\"section\":\"redirects\",\"feature\":\"advanced-404-settings\"},{\"license_level\":\"pro\",\"section\":\"redirects\",\"feature\":\"full-site-redirect\"},{\"license_level\":\"elite\",\"section\":\"redirects\",\"feature\":\"full-site-redirect\"},{\"license_level\":\"elite\",\"section\":\"redirects\",\"feature\":\"advanced-404-settings\"},{\"license_level\":\"agency\",\"section\":\"redirects\",\"feature\":\"http-headers\"},{\"license_level\":\"agency\",\"section\":\"redirects\",\"feature\":\"logs\"},{\"license_level\":\"agency\",\"section\":\"redirects\",\"feature\":\"full-site-redirect\"},{\"license_level\":\"business\",\"section\":\"redirects\",\"feature\":\"http-headers\"},{\"license_level\":\"business\",\"section\":\"redirects\",\"feature\":\"logs\"},{\"license_level\":\"business\",\"section\":\"redirects\",\"feature\":\"full-site-redirect\"},{\"license_level\":\"agency\",\"section\":\"redirects\",\"feature\":\"advanced-404-settings\"},{\"license_level\":\"business\",\"section\":\"redirects\",\"feature\":\"advanced-404-settings\"}]", "0", "2026-02-05 06:04:48", "2026-02-02 04:56:40", "2026-02-04 06:04:48");
INSERT INTO `wp_aioseo_cache` VALUES("457", "attachment_url_to_post_id_d99ed2ddbeefba28910cca4100f73b401b38bc49", "\"none\"", "0", "2026-02-05 05:29:22", "2026-02-02 04:56:43", "2026-02-04 05:29:22");
INSERT INTO `wp_aioseo_cache` VALUES("607", "admin_notifications_update", "1770354747", "0", "2026-02-06 05:12:27", "2026-02-04 05:11:30", "2026-02-05 05:12:27");
INSERT INTO `wp_aioseo_cache` VALUES("620", "rss_feed", "[{\"url\":\"https:\\/\\/aioseo.com\\/best-ai-blog-post-generators\\/\",\"title\":\"7 Best AI Blog Post Generators for 2026 (Tested &amp; Ranked)\",\"date\":\"January 22, 2026\",\"content\":\"We\\u2019ve all stared at a blank screen, waiting for inspiration to strike. Writer\\u2019s block is a real drain on productivity, especiall&hellip;\"},{\"url\":\"https:\\/\\/aioseo.com\\/multiple-table-of-contents-wordpress\\/\",\"title\":\"How to Add Multiple Table of Contents in WordPress (3 Steps)\",\"date\":\"January 13, 2026\",\"content\":\"Have you ever written a massive, comprehensive guide\\u2014maybe 3,000 or 5,000 words long? Long-form content is great for SEO, but it&hellip;\"},{\"url\":\"https:\\/\\/aioseo.com\\/how-to-add-products-to-wordpress\\/\",\"title\":\"How to Add Products to WordPress Without an Ecommerce Plugin\",\"date\":\"January 6, 2026\",\"content\":\"Do you want to add products to WordPress, but don\'t need a full-blown eCommerce platform? Many WordPress users need to display p&hellip;\"},{\"url\":\"https:\\/\\/aioseo.com\\/best-ai-image-generator-plugins\\/\",\"title\":\"7 Best AI Image Generator Plugins for WordPress [2026]\",\"date\":\"December 30, 2025\",\"content\":\"The search for the perfect blog post image is over. A new wave of AI image generator plugins lets you create exactly what you ne&hellip;\"}]", "0", "2026-02-06 05:16:32", "2026-02-04 05:13:27", "2026-02-05 05:16:32");
INSERT INTO `wp_aioseo_cache` VALUES("678", "seoboost_get_user_options_error", "1770354731", "0", "2026-03-07 05:12:11", "2026-02-05 05:12:11", "2026-02-05 05:12:11");
INSERT INTO `wp_aioseo_cache` VALUES("682", "post_overview_data", "{\"total\":0,\"withoutFocusKeyword\":0,\"withoutTruSeoScore\":0,\"needsImprovement\":0,\"okay\":0,\"good\":0}", "0", "2026-02-05 06:16:31", "2026-02-05 05:16:31", "2026-02-05 05:16:31");
INSERT INTO `wp_aioseo_cache` VALUES("683", "page_overview_data", "{\"total\":76,\"withoutFocusKeyword\":67,\"withoutTruSeoScore\":66,\"needsImprovement\":0,\"okay\":0,\"good\":10}", "0", "2026-02-05 06:16:31", "2026-02-05 05:16:31", "2026-02-05 05:16:31");
INSERT INTO `wp_aioseo_cache` VALUES("684", "e-floating-buttons_overview_data", "{\"total\":0,\"withoutFocusKeyword\":0,\"withoutTruSeoScore\":0,\"needsImprovement\":0,\"okay\":0,\"good\":0}", "0", "2026-02-05 06:16:31", "2026-02-05 05:16:31", "2026-02-05 05:16:31");
INSERT INTO `wp_aioseo_cache` VALUES("685", "give_forms_overview_data", "{\"total\":19,\"withoutFocusKeyword\":19,\"withoutTruSeoScore\":19,\"needsImprovement\":0,\"okay\":0,\"good\":0}", "0", "2026-02-05 06:16:31", "2026-02-05 05:16:31", "2026-02-05 05:16:31");
INSERT INTO `wp_aioseo_cache` VALUES("686", "wdt_headers_overview_data", "{\"total\":3,\"withoutFocusKeyword\":3,\"withoutTruSeoScore\":3,\"needsImprovement\":0,\"okay\":0,\"good\":0}", "0", "2026-02-05 06:16:31", "2026-02-05 05:16:31", "2026-02-05 05:16:31");
INSERT INTO `wp_aioseo_cache` VALUES("687", "product_overview_data", "{\"total\":12,\"withoutFocusKeyword\":12,\"withoutTruSeoScore\":12,\"needsImprovement\":0,\"okay\":0,\"good\":0}", "0", "2026-02-05 06:16:31", "2026-02-05 05:16:31", "2026-02-05 05:16:31");
INSERT INTO `wp_aioseo_cache` VALUES("688", "wdt_footers_overview_data", "{\"total\":3,\"withoutFocusKeyword\":3,\"withoutTruSeoScore\":3,\"needsImprovement\":0,\"okay\":0,\"good\":0}", "0", "2026-02-05 06:16:31", "2026-02-05 05:16:31", "2026-02-05 05:16:31");
INSERT INTO `wp_aioseo_cache` VALUES("689", "wdt_mega_menus_overview_data", "{\"total\":0,\"withoutFocusKeyword\":0,\"withoutTruSeoScore\":0,\"needsImprovement\":0,\"okay\":0,\"good\":0}", "0", "2026-02-05 06:16:31", "2026-02-05 05:16:31", "2026-02-05 05:16:31");
INSERT INTO `wp_aioseo_cache` VALUES("690", "wdt_listings_overview_data", "{\"total\":0,\"withoutFocusKeyword\":0,\"withoutTruSeoScore\":0,\"needsImprovement\":0,\"okay\":0,\"good\":0}", "0", "2026-02-05 06:16:31", "2026-02-05 05:16:31", "2026-02-05 05:16:31");
INSERT INTO `wp_aioseo_cache` VALUES("691", "tribe_events_overview_data", "{\"total\":12,\"withoutFocusKeyword\":12,\"withoutTruSeoScore\":12,\"needsImprovement\":0,\"okay\":0,\"good\":0}", "0", "2026-02-05 06:16:31", "2026-02-05 05:16:31", "2026-02-05 05:16:31");
INSERT INTO `wp_aioseo_cache` VALUES("692", "tec_calendar_embed_overview_data", "{\"total\":0,\"withoutFocusKeyword\":0,\"withoutTruSeoScore\":0,\"needsImprovement\":0,\"okay\":0,\"good\":0}", "0", "2026-02-05 06:16:31", "2026-02-05 05:16:31", "2026-02-05 05:16:31");

/* INSERT TABLE DATA: wp_aioseo_notifications */
INSERT INTO `wp_aioseo_notifications` VALUES("2", "697dc60bb56cb", NULL, "Advanced WooCommerce Support", "We have detected you are running WooCommerce. Upgrade to AIOSEO Pro to unlock our advanced eCommerce SEO features, including SEO for Product Categories and more.", "info", "[\"all\"]", NULL, "woo-upsell", "2026-01-31 09:06:19", NULL, "Upgrade to Pro", "https://aioseo.com/lite-upgrade/?utm_source=WordPress&utm_campaign=liteplugin&utm_medium=woo-notification-upsell", NULL, NULL, "0", "0", "2026-01-31 09:06:19", "2026-01-31 09:06:19");
INSERT INTO `wp_aioseo_notifications` VALUES("3", "697dc60bc2eb7", NULL, "Have you connected your site to Google Search Console?", "AIOSEO can now verify whether your site is correctly verified with Google Search Console and that your sitemaps have been submitted correctly. Connect with Google Search Console now to ensure your content is being added to Google as soon as possible for increased rankings.", "warning", "[\"all\"]", NULL, "search-console-site-not-connected", "2026-01-31 09:06:19", NULL, "Connect to Google Search Console", "https://route#aioseo-settings&aioseo-scroll=google-search-console-settings&aioseo-highlight=google-search-console-settings:webmaster-tools?activetool=googleSearchConsole", NULL, NULL, "0", "0", "2026-01-31 09:06:19", "2026-01-31 09:06:19");

/* INSERT TABLE DATA: wp_aioseo_posts */
INSERT INTO `wp_aioseo_posts` VALUES("1", "9", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", NULL, "2026-01-31 09:09:01", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:09:01", "2026-01-31 09:09:01");
INSERT INTO `wp_aioseo_posts` VALUES("2", "31", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/Clip@2x.jpg\"}]", "2026-01-31 09:09:01", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:09:01", "2026-01-31 09:09:01");
INSERT INTO `wp_aioseo_posts` VALUES("3", "53", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/Layer-114@2x.png\"}]", "2026-01-31 09:09:01", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:09:01", "2026-01-31 09:09:01");
INSERT INTO `wp_aioseo_posts` VALUES("4", "67", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/slider-1a.png\"}]", "2026-01-31 09:09:01", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:09:01", "2026-01-31 09:09:01");
INSERT INTO `wp_aioseo_posts` VALUES("5", "76", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/Layer-34@2x.jpg\"}]", "2026-01-31 09:09:01", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:09:01", "2026-01-31 09:09:01");
INSERT INTO `wp_aioseo_posts` VALUES("6", "87", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/Rectangle-1.png\"}]", "2026-01-31 09:09:01", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:09:01", "2026-01-31 09:09:01");
INSERT INTO `wp_aioseo_posts` VALUES("7", "88", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/Rectangle-1-1.png\"}]", "2026-01-31 09:09:01", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:09:01", "2026-01-31 09:09:01");
INSERT INTO `wp_aioseo_posts` VALUES("8", "89", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/Layer-2.png\"}]", "2026-01-31 09:09:01", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:09:01", "2026-01-31 09:09:01");
INSERT INTO `wp_aioseo_posts` VALUES("9", "91", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/Ellipse-1.svg\"}]", "2026-01-31 09:09:01", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:09:01", "2026-01-31 09:09:01");
INSERT INTO `wp_aioseo_posts` VALUES("10", "97", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/AdobeStock_348703273@2x-1.jpg\"}]", "2026-01-31 09:09:01", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:09:01", "2026-01-31 09:09:01");
INSERT INTO `wp_aioseo_posts` VALUES("11", "99", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/Layer-33@2x.jpg\"}]", "2026-01-31 09:09:43", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:09:43", "2026-01-31 09:09:43");
INSERT INTO `wp_aioseo_posts` VALUES("12", "101", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/Layer-36@2x.jpg\"}]", "2026-01-31 09:09:43", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:09:43", "2026-01-31 09:09:43");
INSERT INTO `wp_aioseo_posts` VALUES("13", "19680", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/10\\/Rectangle-10-copy-7-1.png\"}]", "2026-01-31 09:09:43", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:09:43", "2026-01-31 09:09:43");
INSERT INTO `wp_aioseo_posts` VALUES("14", "19681", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/10\\/Rectangle-10-copy-5-2.png\"}]", "2026-01-31 09:09:43", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:09:43", "2026-01-31 09:09:43");
INSERT INTO `wp_aioseo_posts` VALUES("15", "19682", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/10\\/Rectangle-10-copy-6-1.png\"}]", "2026-01-31 09:09:43", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:09:43", "2026-01-31 09:09:43");
INSERT INTO `wp_aioseo_posts` VALUES("16", "19685", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/one-half-image-scaled-1.jpg\"}]", "2026-01-31 09:09:43", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:09:43", "2026-01-31 09:09:43");
INSERT INTO `wp_aioseo_posts` VALUES("17", "19691", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/logo-light.png\"}]", "2026-01-31 09:09:43", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:09:43", "2026-01-31 09:09:43");
INSERT INTO `wp_aioseo_posts` VALUES("18", "19692", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/logo-dark.png\"}]", "2026-01-31 09:09:43", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:09:43", "2026-01-31 09:09:43");
INSERT INTO `wp_aioseo_posts` VALUES("19", "19698", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/Buddha2.jpg\"}]", "2026-01-31 09:09:43", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:09:43", "2026-01-31 09:09:43");
INSERT INTO `wp_aioseo_posts` VALUES("20", "19699", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/Buddha3.jpg\"}]", "2026-01-31 09:09:43", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:09:43", "2026-01-31 09:09:43");
INSERT INTO `wp_aioseo_posts` VALUES("21", "19700", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/Buddha4.jpg\"}]", "2026-01-31 09:10:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:10:21", "2026-01-31 09:10:21");
INSERT INTO `wp_aioseo_posts` VALUES("22", "19705", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/Rectangle-17.png\"}]", "2026-01-31 09:10:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:10:21", "2026-01-31 09:10:21");
INSERT INTO `wp_aioseo_posts` VALUES("23", "19710", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/hand-shape.svg\"}]", "2026-01-31 09:10:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:10:21", "2026-01-31 09:10:21");
INSERT INTO `wp_aioseo_posts` VALUES("24", "19721", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/Rectangle-17-copy-2.png\"}]", "2026-01-31 09:10:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:10:21", "2026-01-31 09:10:21");
INSERT INTO `wp_aioseo_posts` VALUES("25", "19722", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/Rectangle-17-copy.png\"}]", "2026-01-31 09:10:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:10:21", "2026-01-31 09:10:21");
INSERT INTO `wp_aioseo_posts` VALUES("26", "19724", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/Faq-second-half-image.jpg\"}]", "2026-01-31 09:10:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:10:21", "2026-01-31 09:10:21");
INSERT INTO `wp_aioseo_posts` VALUES("27", "19732", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/mantras-1.svg\"}]", "2026-01-31 09:10:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:10:21", "2026-01-31 09:10:21");
INSERT INTO `wp_aioseo_posts` VALUES("28", "19741", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/Rectangle-5@2x.png\"}]", "2026-01-31 09:10:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:10:21", "2026-01-31 09:10:21");
INSERT INTO `wp_aioseo_posts` VALUES("29", "19743", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/tripitaka.svg\"}]", "2026-01-31 09:10:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:10:21", "2026-01-31 09:10:21");
INSERT INTO `wp_aioseo_posts` VALUES("30", "19744", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/meditation.svg\"}]", "2026-01-31 09:10:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:10:21", "2026-01-31 09:10:21");
INSERT INTO `wp_aioseo_posts` VALUES("31", "19746", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/favicon.png\"}]", "2026-01-31 09:12:14", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:12:14", "2026-01-31 09:12:14");
INSERT INTO `wp_aioseo_posts` VALUES("32", "19748", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/cropped-favicon-1.png\"}]", "2026-01-31 09:12:14", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:12:14", "2026-01-31 09:12:14");
INSERT INTO `wp_aioseo_posts` VALUES("33", "19753", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/icon-list-1.svg\"}]", "2026-01-31 09:12:14", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:12:14", "2026-01-31 09:12:14");
INSERT INTO `wp_aioseo_posts` VALUES("34", "19756", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/buddha-statue-1.jpg\"}]", "2026-01-31 09:12:14", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:12:14", "2026-01-31 09:12:14");
INSERT INTO `wp_aioseo_posts` VALUES("35", "19757", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/monk-1.jpg\"}]", "2026-01-31 09:12:14", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:12:14", "2026-01-31 09:12:14");
INSERT INTO `wp_aioseo_posts` VALUES("36", "19759", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/contact-image.jpg\"}]", "2026-01-31 09:12:14", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:12:14", "2026-01-31 09:12:14");
INSERT INTO `wp_aioseo_posts` VALUES("37", "19768", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/creedy-right-arrow-svg-icon.svg\"}]", "2026-01-31 09:12:14", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:12:14", "2026-01-31 09:12:14");
INSERT INTO `wp_aioseo_posts` VALUES("38", "19800", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/AdobeStock_326117963-1@2x-scaled-1.jpg\"}]", "2026-01-31 09:12:14", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:12:14", "2026-01-31 09:12:14");
INSERT INTO `wp_aioseo_posts` VALUES("39", "19808", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/AdobeStock_234737823.png\"}]", "2026-01-31 09:12:14", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:12:14", "2026-01-31 09:12:14");
INSERT INTO `wp_aioseo_posts` VALUES("40", "19813", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/AdobeStock_286878653-1@2x.jpg\"}]", "2026-01-31 09:12:14", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:12:14", "2026-01-31 09:12:14");
INSERT INTO `wp_aioseo_posts` VALUES("41", "19814", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/star.svg\"}]", "2026-01-31 09:13:33", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:13:33", "2026-01-31 09:13:33");
INSERT INTO `wp_aioseo_posts` VALUES("42", "19815", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/phone.svg\"}]", "2026-01-31 09:13:33", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:13:33", "2026-01-31 09:13:33");
INSERT INTO `wp_aioseo_posts` VALUES("43", "19816", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/mail.svg\"}]", "2026-01-31 09:13:33", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:13:33", "2026-01-31 09:13:33");
INSERT INTO `wp_aioseo_posts` VALUES("44", "19817", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/location-marker.svg\"}]", "2026-01-31 09:13:33", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:13:33", "2026-01-31 09:13:33");
INSERT INTO `wp_aioseo_posts` VALUES("45", "19818", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/AdobeStock_287940846@2x.jpg\"}]", "2026-01-31 09:13:33", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:13:33", "2026-01-31 09:13:33");
INSERT INTO `wp_aioseo_posts` VALUES("46", "19819", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/AdobeStock_458532799@2x.jpg\"}]", "2026-01-31 09:13:33", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:13:33", "2026-01-31 09:13:33");
INSERT INTO `wp_aioseo_posts` VALUES("47", "19849", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/Rectangle-10-copy-5-2@2x.png\"}]", "2026-01-31 09:13:33", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:13:33", "2026-01-31 09:13:33");
INSERT INTO `wp_aioseo_posts` VALUES("48", "19851", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/blog-image-1.jpg\"}]", "2026-01-31 09:13:33", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:13:33", "2026-01-31 09:13:33");
INSERT INTO `wp_aioseo_posts` VALUES("49", "19859", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/12\\/AdobeStock_369892736.png\"}]", "2026-01-31 09:13:33", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:13:33", "2026-01-31 09:13:33");
INSERT INTO `wp_aioseo_posts` VALUES("50", "19860", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/12\\/AdobeStock_126830422.png\"}]", "2026-01-31 09:13:33", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:13:33", "2026-01-31 09:13:33");
INSERT INTO `wp_aioseo_posts` VALUES("51", "19861", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/12\\/AdobeStock_351605712.png\"}]", "2026-01-31 09:14:24", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:14:24", "2026-01-31 09:14:24");
INSERT INTO `wp_aioseo_posts` VALUES("52", "19869", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/12\\/Layer-114-copy.png\"}]", "2026-01-31 09:14:24", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:14:24", "2026-01-31 09:14:24");
INSERT INTO `wp_aioseo_posts` VALUES("53", "19876", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/12\\/Layer-113-copy.png\"}]", "2026-01-31 09:14:24", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:14:24", "2026-01-31 09:14:24");
INSERT INTO `wp_aioseo_posts` VALUES("54", "19878", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/12\\/Color-Fill-1-copy.png\"}]", "2026-01-31 09:14:24", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:14:24", "2026-01-31 09:14:24");
INSERT INTO `wp_aioseo_posts` VALUES("55", "19881", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/12\\/Layer-113-copy-1.png\"}]", "2026-01-31 09:14:24", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:14:24", "2026-01-31 09:14:24");
INSERT INTO `wp_aioseo_posts` VALUES("56", "19887", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/12\\/Rectangle-1.png\"}]", "2026-01-31 09:14:24", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:14:24", "2026-01-31 09:14:24");
INSERT INTO `wp_aioseo_posts` VALUES("57", "19891", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/12\\/AdobeStock_366521038.png\"}]", "2026-01-31 09:14:24", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:14:24", "2026-01-31 09:14:24");
INSERT INTO `wp_aioseo_posts` VALUES("58", "19892", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/12\\/AdobeStock_55914885.png\"}]", "2026-01-31 09:14:24", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:14:24", "2026-01-31 09:14:24");
INSERT INTO `wp_aioseo_posts` VALUES("59", "19894", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/12\\/Group-123.png\"}]", "2026-01-31 09:14:24", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:14:24", "2026-01-31 09:14:24");
INSERT INTO `wp_aioseo_posts` VALUES("60", "19908", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/Rectangle-5-copy-2.png\"}]", "2026-01-31 09:14:24", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:14:24", "2026-01-31 09:14:24");
INSERT INTO `wp_aioseo_posts` VALUES("61", "19911", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/donation-image.png\"}]", "2026-01-31 09:15:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:15:20", "2026-01-31 09:15:20");
INSERT INTO `wp_aioseo_posts` VALUES("62", "19919", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/12\\/menu-icon.png\"}]", "2026-01-31 09:15:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:15:20", "2026-01-31 09:15:20");
INSERT INTO `wp_aioseo_posts` VALUES("63", "19925", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/12\\/Rectangle-1.jpg\"}]", "2026-01-31 09:15:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:15:20", "2026-01-31 09:15:20");
INSERT INTO `wp_aioseo_posts` VALUES("64", "19927", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/12\\/Rectangle-1-1.jpg\"}]", "2026-01-31 09:15:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:15:20", "2026-01-31 09:15:20");
INSERT INTO `wp_aioseo_posts` VALUES("65", "19930", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/12\\/Rectangle-1-2.jpg\"}]", "2026-01-31 09:15:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:15:20", "2026-01-31 09:15:20");
INSERT INTO `wp_aioseo_posts` VALUES("66", "19931", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/12\\/Rectangle-1-3.jpg\"}]", "2026-01-31 09:15:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:15:20", "2026-01-31 09:15:20");
INSERT INTO `wp_aioseo_posts` VALUES("67", "19933", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/12\\/Rectangle-1-4.jpg\"}]", "2026-01-31 09:15:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:15:20", "2026-01-31 09:15:20");
INSERT INTO `wp_aioseo_posts` VALUES("68", "19934", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/12\\/Rectangle-1-5.jpg\"}]", "2026-01-31 09:15:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:15:20", "2026-01-31 09:15:20");
INSERT INTO `wp_aioseo_posts` VALUES("69", "19935", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/12\\/Rectangle-1-6.jpg\"}]", "2026-01-31 09:15:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:15:20", "2026-01-31 09:15:20");
INSERT INTO `wp_aioseo_posts` VALUES("70", "19936", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/12\\/Rectangle-1-7.jpg\"}]", "2026-01-31 09:15:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:15:20", "2026-01-31 09:15:20");
INSERT INTO `wp_aioseo_posts` VALUES("71", "19937", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/12\\/Rectangle-1-8.jpg\"}]", "2026-01-31 09:16:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:16:20", "2026-01-31 09:16:20");
INSERT INTO `wp_aioseo_posts` VALUES("72", "19945", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/10\\/blog-1.jpg\"}]", "2026-01-31 09:16:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:16:20", "2026-01-31 09:16:20");
INSERT INTO `wp_aioseo_posts` VALUES("73", "19946", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/10\\/blog-1a.jpg\"}]", "2026-01-31 09:16:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:16:20", "2026-01-31 09:16:20");
INSERT INTO `wp_aioseo_posts` VALUES("74", "19947", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/10\\/blog-3.jpg\"}]", "2026-01-31 09:16:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:16:20", "2026-01-31 09:16:20");
INSERT INTO `wp_aioseo_posts` VALUES("75", "19948", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/12\\/blog-2.jpg\"}]", "2026-01-31 09:16:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:16:20", "2026-01-31 09:16:20");
INSERT INTO `wp_aioseo_posts` VALUES("76", "19972", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Group-5706.png\"}]", "2026-01-31 09:16:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:16:20", "2026-01-31 09:16:20");
INSERT INTO `wp_aioseo_posts` VALUES("77", "19973", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Vector-Smart-Object.png\"}]", "2026-01-31 09:16:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:16:20", "2026-01-31 09:16:20");
INSERT INTO `wp_aioseo_posts` VALUES("78", "19982", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/slider-svg-3.svg\"}]", "2026-01-31 09:16:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:16:20", "2026-01-31 09:16:20");
INSERT INTO `wp_aioseo_posts` VALUES("79", "19987", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Body-bg-Sun.png\"}]", "2026-01-31 09:16:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:16:20", "2026-01-31 09:16:20");
INSERT INTO `wp_aioseo_posts` VALUES("80", "19993", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Ouran-Learning.svg\"}]", "2026-01-31 09:16:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:16:20", "2026-01-31 09:16:20");
INSERT INTO `wp_aioseo_posts` VALUES("81", "19999", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Ouran-Learning-with-bg.svg\"}]", "2026-01-31 09:16:52", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:16:52", "2026-01-31 09:16:52");
INSERT INTO `wp_aioseo_posts` VALUES("82", "20002", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Ramadan-Karreem.svg\"}]", "2026-01-31 09:16:52", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:16:52", "2026-01-31 09:16:52");
INSERT INTO `wp_aioseo_posts` VALUES("83", "20012", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Shape-45.png\"}]", "2026-01-31 09:16:52", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:16:52", "2026-01-31 09:16:52");
INSERT INTO `wp_aioseo_posts` VALUES("84", "20030", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Shape-51.png\"}]", "2026-01-31 09:16:52", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:16:52", "2026-01-31 09:16:52");
INSERT INTO `wp_aioseo_posts` VALUES("85", "20033", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Service-bg-image-1-scaled-1.jpeg\"}]", "2026-01-31 09:16:52", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:16:52", "2026-01-31 09:16:52");
INSERT INTO `wp_aioseo_posts` VALUES("86", "20045", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/service-icon-1.svg\"}]", "2026-01-31 09:16:52", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:16:52", "2026-01-31 09:16:52");
INSERT INTO `wp_aioseo_posts` VALUES("87", "20054", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/left-arrow.svg\"}]", "2026-01-31 09:16:52", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:16:52", "2026-01-31 09:16:52");
INSERT INTO `wp_aioseo_posts` VALUES("88", "20055", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/right-arrow.svg\"}]", "2026-01-31 09:16:52", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:16:52", "2026-01-31 09:16:52");
INSERT INTO `wp_aioseo_posts` VALUES("89", "20058", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/support-image.jpg\"}]", "2026-01-31 09:16:52", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:16:52", "2026-01-31 09:16:52");
INSERT INTO `wp_aioseo_posts` VALUES("90", "20060", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/islam-icon-1.svg\"}]", "2026-01-31 09:16:52", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:16:52", "2026-01-31 09:16:52");
INSERT INTO `wp_aioseo_posts` VALUES("91", "20061", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/islam-icon-2.svg\"}]", "2026-01-31 09:17:22", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:17:22", "2026-01-31 09:17:22");
INSERT INTO `wp_aioseo_posts` VALUES("92", "20062", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/islam-icon-3.svg\"}]", "2026-01-31 09:17:22", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:17:22", "2026-01-31 09:17:22");
INSERT INTO `wp_aioseo_posts` VALUES("93", "20063", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/islam-icon-4.svg\"}]", "2026-01-31 09:17:22", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:17:22", "2026-01-31 09:17:22");
INSERT INTO `wp_aioseo_posts` VALUES("94", "20064", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/islam-icon-5.svg\"}]", "2026-01-31 09:17:22", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:17:22", "2026-01-31 09:17:22");
INSERT INTO `wp_aioseo_posts` VALUES("95", "20066", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/islam-icon-hover-bg.svg\"}]", "2026-01-31 09:17:22", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:17:22", "2026-01-31 09:17:22");
INSERT INTO `wp_aioseo_posts` VALUES("96", "20128", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/home-2-logo-footer.png\"}]", "2026-01-31 09:17:22", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:17:22", "2026-01-31 09:17:22");
INSERT INTO `wp_aioseo_posts` VALUES("97", "20129", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/home-2-logo.png\"}]", "2026-01-31 09:17:22", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:17:22", "2026-01-31 09:17:22");
INSERT INTO `wp_aioseo_posts` VALUES("98", "20139", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Product-1.jpg\"}]", "2026-01-31 09:17:22", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:17:22", "2026-01-31 09:17:22");
INSERT INTO `wp_aioseo_posts` VALUES("99", "20140", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Product-2.jpg\"}]", "2026-01-31 09:17:22", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:17:22", "2026-01-31 09:17:22");
INSERT INTO `wp_aioseo_posts` VALUES("100", "20158", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Rectangle-17.jpg\"}]", "2026-01-31 09:17:22", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:17:22", "2026-01-31 09:17:22");
INSERT INTO `wp_aioseo_posts` VALUES("101", "20160", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/testimonial-image-1.jpg\"}]", "2026-01-31 09:18:02", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:18:02", "2026-01-31 09:18:02");
INSERT INTO `wp_aioseo_posts` VALUES("102", "20161", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/testimonial-image-2.jpg\"}]", "2026-01-31 09:18:02", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:18:02", "2026-01-31 09:18:02");
INSERT INTO `wp_aioseo_posts` VALUES("103", "20162", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/testimonial-image-3.jpg\"}]", "2026-01-31 09:18:02", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:18:02", "2026-01-31 09:18:02");
INSERT INTO `wp_aioseo_posts` VALUES("104", "20163", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Layer-4.png\"}]", "2026-01-31 09:18:02", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:18:02", "2026-01-31 09:18:02");
INSERT INTO `wp_aioseo_posts` VALUES("105", "20164", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Path-156.png\"}]", "2026-01-31 09:18:02", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:18:02", "2026-01-31 09:18:02");
INSERT INTO `wp_aioseo_posts` VALUES("106", "20170", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/testimonial-icon-1.svg\"}]", "2026-01-31 09:18:02", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:18:02", "2026-01-31 09:18:02");
INSERT INTO `wp_aioseo_posts` VALUES("107", "20171", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/testimonial-icon-2.svg\"}]", "2026-01-31 09:18:02", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:18:02", "2026-01-31 09:18:02");
INSERT INTO `wp_aioseo_posts` VALUES("108", "20173", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/testimonial-icon-4.svg\"}]", "2026-01-31 09:18:02", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:18:02", "2026-01-31 09:18:02");
INSERT INTO `wp_aioseo_posts` VALUES("109", "20180", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/flower-icon.svg\"}]", "2026-01-31 09:18:02", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:18:02", "2026-01-31 09:18:02");
INSERT INTO `wp_aioseo_posts` VALUES("110", "20181", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/image-content-svg-1a.svg\"}]", "2026-01-31 09:18:02", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:18:02", "2026-01-31 09:18:02");
INSERT INTO `wp_aioseo_posts` VALUES("111", "20182", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/lamp-svg-icon-1.svg\"}]", "2026-01-31 09:19:04", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:19:04", "2026-01-31 09:19:04");
INSERT INTO `wp_aioseo_posts` VALUES("112", "20183", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Mosque-Renovation-1.svg\"}]", "2026-01-31 09:19:04", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:19:04", "2026-01-31 09:19:04");
INSERT INTO `wp_aioseo_posts` VALUES("113", "20184", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/serivice-icon-1.svg\"}]", "2026-01-31 09:19:04", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:19:04", "2026-01-31 09:19:04");
INSERT INTO `wp_aioseo_posts` VALUES("114", "20185", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/serivice-icon-2.svg\"}]", "2026-01-31 09:19:04", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:19:04", "2026-01-31 09:19:04");
INSERT INTO `wp_aioseo_posts` VALUES("115", "20186", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/serivice-icon-3.svg\"}]", "2026-01-31 09:19:04", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:19:04", "2026-01-31 09:19:04");
INSERT INTO `wp_aioseo_posts` VALUES("116", "20187", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/serivice-icon-4.svg\"}]", "2026-01-31 09:19:04", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:19:04", "2026-01-31 09:19:04");
INSERT INTO `wp_aioseo_posts` VALUES("117", "20189", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/serivice-icon-5.svg\"}]", "2026-01-31 09:19:04", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:19:04", "2026-01-31 09:19:04");
INSERT INTO `wp_aioseo_posts` VALUES("118", "20190", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/serivice-icon-6.svg\"}]", "2026-01-31 09:19:04", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:19:04", "2026-01-31 09:19:04");
INSERT INTO `wp_aioseo_posts` VALUES("119", "20191", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/serivice-icon-1a.svg\"}]", "2026-01-31 09:19:04", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:19:04", "2026-01-31 09:19:04");
INSERT INTO `wp_aioseo_posts` VALUES("120", "20192", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/slider-svg-5a.svg\"}]", "2026-01-31 09:19:04", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:19:04", "2026-01-31 09:19:04");
INSERT INTO `wp_aioseo_posts` VALUES("121", "20194", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/slider-svg-2a.svg\"}]", "2026-01-31 09:19:37", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:19:37", "2026-01-31 09:19:37");
INSERT INTO `wp_aioseo_posts` VALUES("122", "20195", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/slider-svg-4a.svg\"}]", "2026-01-31 09:19:37", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:19:37", "2026-01-31 09:19:37");
INSERT INTO `wp_aioseo_posts` VALUES("123", "20196", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/donation-bg-image-svg.svg\"}]", "2026-01-31 09:19:37", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:19:37", "2026-01-31 09:19:37");
INSERT INTO `wp_aioseo_posts` VALUES("124", "20203", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/logo-icon.svg\"}]", "2026-01-31 09:19:37", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:19:37", "2026-01-31 09:19:37");
INSERT INTO `wp_aioseo_posts` VALUES("125", "20208", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/testimonial-background.svg\"}]", "2026-01-31 09:19:37", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:19:37", "2026-01-31 09:19:37");
INSERT INTO `wp_aioseo_posts` VALUES("126", "20211", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/amanah-mosque-bg-1a.svg\"}]", "2026-01-31 09:19:37", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:19:37", "2026-01-31 09:19:37");
INSERT INTO `wp_aioseo_posts` VALUES("127", "20218", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/donation-svg-1.svg\"}]", "2026-01-31 09:19:37", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:19:37", "2026-01-31 09:19:37");
INSERT INTO `wp_aioseo_posts` VALUES("128", "20219", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/donation-svg-2.svg\"}]", "2026-01-31 09:19:37", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:19:37", "2026-01-31 09:19:37");
INSERT INTO `wp_aioseo_posts` VALUES("129", "20235", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/h2-donation-image-1a.jpg\"}]", "2026-01-31 09:19:37", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:19:37", "2026-01-31 09:19:37");
INSERT INTO `wp_aioseo_posts` VALUES("130", "20237", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/h2-donation-image-2a.jpg\"}]", "2026-01-31 09:19:37", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:19:37", "2026-01-31 09:19:37");
INSERT INTO `wp_aioseo_posts` VALUES("131", "20238", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/h2-donation-image-3a.jpg\"}]", "2026-01-31 09:20:10", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:20:10", "2026-01-31 09:20:10");
INSERT INTO `wp_aioseo_posts` VALUES("132", "20239", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/h2-donation-image-1b.jpg\"}]", "2026-01-31 09:20:10", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:20:10", "2026-01-31 09:20:10");
INSERT INTO `wp_aioseo_posts` VALUES("133", "20244", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Church-Logo.svg\"}]", "2026-01-31 09:20:10", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:20:10", "2026-01-31 09:20:10");
INSERT INTO `wp_aioseo_posts` VALUES("134", "20261", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/slider-image-home-3.jpg\"}]", "2026-01-31 09:20:10", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:20:10", "2026-01-31 09:20:10");
INSERT INTO `wp_aioseo_posts` VALUES("135", "20264", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/plus-icon.png\"}]", "2026-01-31 09:20:10", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:20:10", "2026-01-31 09:20:10");
INSERT INTO `wp_aioseo_posts` VALUES("136", "20267", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/right-arrow-1.svg\"}]", "2026-01-31 09:20:10", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:20:10", "2026-01-31 09:20:10");
INSERT INTO `wp_aioseo_posts` VALUES("137", "20270", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/support-image-1.jpg\"}]", "2026-01-31 09:20:10", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:20:10", "2026-01-31 09:20:10");
INSERT INTO `wp_aioseo_posts` VALUES("138", "20271", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/support-image-2.jpg\"}]", "2026-01-31 09:20:10", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:20:10", "2026-01-31 09:20:10");
INSERT INTO `wp_aioseo_posts` VALUES("139", "20272", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/support-image-3.jpg\"}]", "2026-01-31 09:20:10", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:20:10", "2026-01-31 09:20:10");
INSERT INTO `wp_aioseo_posts` VALUES("140", "20276", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/image-1a.jpg\"}]", "2026-01-31 09:20:10", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:20:10", "2026-01-31 09:20:10");
INSERT INTO `wp_aioseo_posts` VALUES("141", "20277", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/image-2a.jpg\"}]", "2026-01-31 09:21:12", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:21:12", "2026-01-31 09:21:12");
INSERT INTO `wp_aioseo_posts` VALUES("142", "20278", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/image-3a.jpg\"}]", "2026-01-31 09:21:12", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:21:12", "2026-01-31 09:21:12");
INSERT INTO `wp_aioseo_posts` VALUES("143", "20280", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/image-5a.png\"}]", "2026-01-31 09:21:12", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:21:12", "2026-01-31 09:21:12");
INSERT INTO `wp_aioseo_posts` VALUES("144", "20281", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/image-6a.png\"}]", "2026-01-31 09:21:12", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:21:12", "2026-01-31 09:21:12");
INSERT INTO `wp_aioseo_posts` VALUES("145", "20283", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/svg-icon-church.svg\"}]", "2026-01-31 09:21:12", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:21:12", "2026-01-31 09:21:12");
INSERT INTO `wp_aioseo_posts` VALUES("146", "20293", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Product-3.jpg\"}]", "2026-01-31 09:21:12", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:21:12", "2026-01-31 09:21:12");
INSERT INTO `wp_aioseo_posts` VALUES("147", "20295", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Product-4.jpg\"}]", "2026-01-31 09:21:12", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:21:12", "2026-01-31 09:21:12");
INSERT INTO `wp_aioseo_posts` VALUES("148", "20298", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Rectangle-11.jpg\"}]", "2026-01-31 09:21:12", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:21:12", "2026-01-31 09:21:12");
INSERT INTO `wp_aioseo_posts` VALUES("149", "20299", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Rectangle-11-copy.jpg\"}]", "2026-01-31 09:21:12", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:21:12", "2026-01-31 09:21:12");
INSERT INTO `wp_aioseo_posts` VALUES("150", "20300", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Rectangle-11-1.jpg\"}]", "2026-01-31 09:21:12", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:21:12", "2026-01-31 09:21:12");
INSERT INTO `wp_aioseo_posts` VALUES("151", "21587", "Best Consultation in Numerology | Shri Sachin Joshi Guruji", "Get the best consultation in numerology by Shri Sachin Joshi Guruji in Nashik. Accurate guidance for career, business, marriage, and life success.", NULL, "{\"focus\":{\"keyphrase\":\"numerology\",\"score\":69,\"analysis\":{\"keyphraseInTitle\":{\"score\":9,\"maxScore\":9,\"error\":0},\"keyphraseInDescription\":{\"score\":9,\"maxScore\":9,\"error\":0},\"keyphraseLength\":{\"score\":9,\"maxScore\":9,\"error\":0,\"length\":1},\"keyphraseInURL\":{\"score\":5,\"maxScore\":5,\"error\":0},\"keyphraseInIntroduction\":{\"score\":3,\"maxScore\":9,\"error\":1},\"keyphraseInSubHeadings\":{\"score\":3,\"maxScore\":9,\"error\":1},\"keyphraseInImageAlt\":{\"score\":9,\"maxScore\":9,\"error\":0},\"keywordDensity\":{\"score\":0,\"type\":\"low\",\"maxScore\":9,\"error\":1}}},\"additional\":[]}", "{\"analysis\":{\"basic\":{\"keyphraseInContent\":{\"score\":3,\"maxScore\":9,\"error\":1},\"keyphraseInIntroduction\":{\"score\":3,\"maxScore\":9,\"error\":1},\"keyphraseInDescription\":{\"score\":9,\"maxScore\":9,\"error\":0},\"keyphraseInURL\":{\"score\":5,\"maxScore\":5,\"error\":0},\"keyphraseLength\":{\"score\":9,\"maxScore\":9,\"error\":0,\"length\":1},\"metadescriptionLength\":{\"score\":9,\"maxScore\":9,\"error\":0},\"lengthContent\":{\"score\":-20,\"maxScore\":9,\"error\":1},\"isInternalLink\":{\"score\":9,\"maxScore\":9,\"error\":0},\"isExternalLink\":{\"score\":9,\"maxScore\":9,\"error\":0},\"errors\":3},\"title\":{\"keyphraseInTitle\":{\"score\":9,\"maxScore\":9,\"error\":0},\"keyphraseInBeginningTitle\":{\"score\":9,\"maxScore\":9,\"error\":0},\"titleLength\":{\"score\":9,\"maxScore\":9,\"error\":0},\"errors\":0},\"readability\":{\"contentHasAssets\":{\"error\":0,\"score\":5,\"maxScore\":5},\"paragraphLength\":{\"score\":5,\"maxScore\":5,\"error\":0},\"sentenceLength\":{\"score\":9,\"maxScore\":9,\"error\":0},\"passiveVoice\":{\"score\":9,\"maxScore\":9,\"error\":0},\"transitionWords\":{\"score\":3,\"maxScore\":9,\"error\":1},\"consecutiveSentences\":{\"score\":9,\"maxScore\":9,\"error\":0},\"subheadingsDistribution\":{\"score\":9,\"maxScore\":9,\"error\":0},\"calculateFleschReading\":{\"score\":9,\"maxScore\":9,\"error\":0},\"errors\":1}}}", NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, "", NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "91", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"WebPage\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", "-1", "-1", "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/numerology-concept-still-life_23-2150171533.png\"},{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/numerology-concept-with-note-1-1.png\"},{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/high-angle-role-playing-game-elements-arrangement-2.png\"}]", "2026-02-03 05:39:54", NULL, "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", "{\"faqs\":[],\"keyPoints\":[],\"titles\":[],\"descriptions\":[],\"socialPosts\":{\"email\":[],\"linkedin\":[],\"twitter\":[],\"facebook\":[],\"instagram\":[]}}", "2026-01-31 09:22:47", "2026-02-03 05:39:54");
INSERT INTO `wp_aioseo_posts` VALUES("152", "20301", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Clip.jpg\"}]", "2026-01-31 09:24:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:24:21", "2026-01-31 09:24:21");
INSERT INTO `wp_aioseo_posts` VALUES("153", "20303", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/vdo-banner.jpg\"}]", "2026-01-31 09:24:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:24:21", "2026-01-31 09:24:21");
INSERT INTO `wp_aioseo_posts` VALUES("154", "20306", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Rectangle-13-copy.jpg\"}]", "2026-01-31 09:24:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:24:21", "2026-01-31 09:24:21");
INSERT INTO `wp_aioseo_posts` VALUES("155", "20308", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Rectangle-18.jpg\"}]", "2026-01-31 09:24:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:24:21", "2026-01-31 09:24:21");
INSERT INTO `wp_aioseo_posts` VALUES("156", "20310", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/blog-image-2.jpg\"}]", "2026-01-31 09:24:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:24:21", "2026-01-31 09:24:21");
INSERT INTO `wp_aioseo_posts` VALUES("157", "20313", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/play-icon-1.svg\"}]", "2026-01-31 09:24:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:24:21", "2026-01-31 09:24:21");
INSERT INTO `wp_aioseo_posts` VALUES("158", "20314", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/event-bg-image.png\"}]", "2026-01-31 09:24:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:24:21", "2026-01-31 09:24:21");
INSERT INTO `wp_aioseo_posts` VALUES("159", "20316", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/svg-icon-1.svg\"}]", "2026-01-31 09:24:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:24:21", "2026-01-31 09:24:21");
INSERT INTO `wp_aioseo_posts` VALUES("160", "20317", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/svg-icon-2.svg\"}]", "2026-01-31 09:24:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:24:21", "2026-01-31 09:24:21");
INSERT INTO `wp_aioseo_posts` VALUES("161", "20318", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/svg-icon-3.svg\"}]", "2026-01-31 09:24:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:24:21", "2026-01-31 09:24:21");
INSERT INTO `wp_aioseo_posts` VALUES("162", "20320", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Rectangle-19-copy.png\"}]", "2026-01-31 09:25:13", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:25:13", "2026-01-31 09:25:13");
INSERT INTO `wp_aioseo_posts` VALUES("163", "20321", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Rectangle-19-copy-2.png\"}]", "2026-01-31 09:25:13", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:25:13", "2026-01-31 09:25:13");
INSERT INTO `wp_aioseo_posts` VALUES("164", "20322", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Rectangle-19-copy-3.png\"}]", "2026-01-31 09:25:13", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:25:13", "2026-01-31 09:25:13");
INSERT INTO `wp_aioseo_posts` VALUES("165", "20323", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Rectangle-19-copy-4.png\"}]", "2026-01-31 09:25:13", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:25:13", "2026-01-31 09:25:13");
INSERT INTO `wp_aioseo_posts` VALUES("166", "20333", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/play-icon-image.svg\"}]", "2026-01-31 09:25:13", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:25:13", "2026-01-31 09:25:13");
INSERT INTO `wp_aioseo_posts` VALUES("167", "20377", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/tick-icon.svg\"}]", "2026-01-31 09:25:13", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:25:13", "2026-01-31 09:25:13");
INSERT INTO `wp_aioseo_posts` VALUES("168", "20378", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Rectangle-19-copy@2x.png\"}]", "2026-01-31 09:25:13", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:25:13", "2026-01-31 09:25:13");
INSERT INTO `wp_aioseo_posts` VALUES("169", "20385", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/blog01.jpg\"}]", "2026-01-31 09:25:13", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:25:13", "2026-01-31 09:25:13");
INSERT INTO `wp_aioseo_posts` VALUES("170", "20386", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/blog02.jpg\"}]", "2026-01-31 09:25:13", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:25:13", "2026-01-31 09:25:13");
INSERT INTO `wp_aioseo_posts` VALUES("171", "20387", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/blog03.jpg\"}]", "2026-01-31 09:25:13", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:25:13", "2026-01-31 09:25:13");
INSERT INTO `wp_aioseo_posts` VALUES("172", "20388", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/blog04.jpg\"}]", "2026-01-31 09:27:40", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:27:40", "2026-01-31 09:27:40");
INSERT INTO `wp_aioseo_posts` VALUES("173", "20389", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/blog05.jpg\"}]", "2026-01-31 09:27:40", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:27:40", "2026-01-31 09:27:40");
INSERT INTO `wp_aioseo_posts` VALUES("174", "20390", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/blog06.jpg\"}]", "2026-01-31 09:27:40", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:27:40", "2026-01-31 09:27:40");
INSERT INTO `wp_aioseo_posts` VALUES("175", "20391", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/blog07.jpg\"}]", "2026-01-31 09:27:40", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:27:40", "2026-01-31 09:27:40");
INSERT INTO `wp_aioseo_posts` VALUES("176", "20392", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/blog08.jpg\"}]", "2026-01-31 09:27:40", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:27:40", "2026-01-31 09:27:40");
INSERT INTO `wp_aioseo_posts` VALUES("177", "20393", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/10\\/blog09.jpg\"}]", "2026-01-31 09:27:40", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:27:40", "2026-01-31 09:27:40");
INSERT INTO `wp_aioseo_posts` VALUES("178", "20395", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/blog-detail-8.jpg\"}]", "2026-01-31 09:27:40", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:27:40", "2026-01-31 09:27:40");
INSERT INTO `wp_aioseo_posts` VALUES("179", "20396", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/blog-detail-15.jpg\"}]", "2026-01-31 09:27:40", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:27:40", "2026-01-31 09:27:40");
INSERT INTO `wp_aioseo_posts` VALUES("180", "20397", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/blog-detail-13.jpg\"}]", "2026-01-31 09:27:40", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:27:40", "2026-01-31 09:27:40");
INSERT INTO `wp_aioseo_posts` VALUES("181", "20399", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/blog-detail-16.jpg\"}]", "2026-01-31 09:27:40", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:27:40", "2026-01-31 09:27:40");
INSERT INTO `wp_aioseo_posts` VALUES("182", "20400", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/blog-detail-17.jpg\"}]", "2026-01-31 09:29:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:29:19", "2026-01-31 09:29:19");
INSERT INTO `wp_aioseo_posts` VALUES("183", "20402", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/blog-detail-11.jpg\"}]", "2026-01-31 09:29:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:29:19", "2026-01-31 09:29:19");
INSERT INTO `wp_aioseo_posts` VALUES("184", "20403", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/blog-detail-14.jpg\"}]", "2026-01-31 09:29:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:29:19", "2026-01-31 09:29:19");
INSERT INTO `wp_aioseo_posts` VALUES("185", "20404", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/blog-detail-10.jpg\"}]", "2026-01-31 09:29:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:29:19", "2026-01-31 09:29:19");
INSERT INTO `wp_aioseo_posts` VALUES("186", "20407", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/blog-detail-18.jpg\"}]", "2026-01-31 09:29:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:29:19", "2026-01-31 09:29:19");
INSERT INTO `wp_aioseo_posts` VALUES("187", "20409", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/blog-detail-12.jpg\"}]", "2026-01-31 09:29:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:29:19", "2026-01-31 09:29:19");
INSERT INTO `wp_aioseo_posts` VALUES("188", "20410", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/blog-detail-1.jpg\"}]", "2026-01-31 09:29:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:29:19", "2026-01-31 09:29:19");
INSERT INTO `wp_aioseo_posts` VALUES("189", "20412", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/blog-detail-2.jpg\"}]", "2026-01-31 09:29:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:29:19", "2026-01-31 09:29:19");
INSERT INTO `wp_aioseo_posts` VALUES("190", "20413", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/blog-detail-6.jpg\"}]", "2026-01-31 09:29:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:29:19", "2026-01-31 09:29:19");
INSERT INTO `wp_aioseo_posts` VALUES("191", "20414", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/blog-detail-7.jpg\"}]", "2026-01-31 09:29:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:29:19", "2026-01-31 09:29:19");
INSERT INTO `wp_aioseo_posts` VALUES("192", "20420", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/10\\/blog-detail-3.jpg\"}]", "2026-01-31 09:31:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:31:20", "2026-01-31 09:31:20");
INSERT INTO `wp_aioseo_posts` VALUES("193", "20421", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/10\\/blog-detail-4.jpg\"}]", "2026-01-31 09:31:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:31:20", "2026-01-31 09:31:20");
INSERT INTO `wp_aioseo_posts` VALUES("194", "20422", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/10\\/blog-detail-9.jpg\"}]", "2026-01-31 09:31:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:31:20", "2026-01-31 09:31:20");
INSERT INTO `wp_aioseo_posts` VALUES("195", "20435", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/AdobeStock_167399582-1@2x.jpg\"}]", "2026-01-31 09:31:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:31:20", "2026-01-31 09:31:20");
INSERT INTO `wp_aioseo_posts` VALUES("196", "20437", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/AdobeStock_485002495@2x.jpg\"}]", "2026-01-31 09:31:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:31:20", "2026-01-31 09:31:20");
INSERT INTO `wp_aioseo_posts` VALUES("197", "20439", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/AdobeStock_555386445@2x.jpg\"}]", "2026-01-31 09:31:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:31:20", "2026-01-31 09:31:20");
INSERT INTO `wp_aioseo_posts` VALUES("198", "20441", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/AdobeStock_457575250@2x.jpg\"}]", "2026-01-31 09:31:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:31:20", "2026-01-31 09:31:20");
INSERT INTO `wp_aioseo_posts` VALUES("199", "20447", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Rectangle-16.jpg\"}]", "2026-01-31 09:31:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:31:20", "2026-01-31 09:31:20");
INSERT INTO `wp_aioseo_posts` VALUES("200", "20452", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Rectangle-16-copy.jpg\"}]", "2026-01-31 09:31:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:31:20", "2026-01-31 09:31:20");
INSERT INTO `wp_aioseo_posts` VALUES("201", "20453", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Rectangle-16-copy-2.jpg\"}]", "2026-01-31 09:31:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:31:20", "2026-01-31 09:31:20");
INSERT INTO `wp_aioseo_posts` VALUES("202", "20454", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Rectangle-16-copy-3.jpg\"}]", "2026-01-31 09:32:26", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:32:26", "2026-01-31 09:32:26");
INSERT INTO `wp_aioseo_posts` VALUES("203", "20456", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Layer-139.png\"}]", "2026-01-31 09:32:26", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:32:26", "2026-01-31 09:32:26");
INSERT INTO `wp_aioseo_posts` VALUES("204", "20457", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Quate-icon.svg\"}]", "2026-01-31 09:32:26", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:32:26", "2026-01-31 09:32:26");
INSERT INTO `wp_aioseo_posts` VALUES("205", "20463", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Quate-icon-1.svg\"}]", "2026-01-31 09:32:26", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:32:26", "2026-01-31 09:32:26");
INSERT INTO `wp_aioseo_posts` VALUES("206", "20491", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/team-image-1.jpg\"}]", "2026-01-31 09:32:26", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:32:26", "2026-01-31 09:32:26");
INSERT INTO `wp_aioseo_posts` VALUES("207", "20492", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/team-image-2.jpg\"}]", "2026-01-31 09:32:26", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:32:26", "2026-01-31 09:32:26");
INSERT INTO `wp_aioseo_posts` VALUES("208", "20493", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/team-image-3.jpg\"}]", "2026-01-31 09:32:26", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:32:26", "2026-01-31 09:32:26");
INSERT INTO `wp_aioseo_posts` VALUES("209", "20494", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/home-section-1-1.jpg\"}]", "2026-01-31 09:32:26", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:32:26", "2026-01-31 09:32:26");
INSERT INTO `wp_aioseo_posts` VALUES("210", "20495", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/home-section-1-2.jpg\"}]", "2026-01-31 09:32:26", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:32:26", "2026-01-31 09:32:26");
INSERT INTO `wp_aioseo_posts` VALUES("211", "20497", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/home-section-2-1.jpg\"}]", "2026-01-31 09:32:26", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:32:26", "2026-01-31 09:32:26");
INSERT INTO `wp_aioseo_posts` VALUES("212", "20498", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/home-section-2-2.jpg\"}]", "2026-01-31 09:33:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:33:19", "2026-01-31 09:33:19");
INSERT INTO `wp_aioseo_posts` VALUES("213", "20499", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/home-section-2-3.jpg\"}]", "2026-01-31 09:33:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:33:19", "2026-01-31 09:33:19");
INSERT INTO `wp_aioseo_posts` VALUES("214", "20500", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/home-section-2-8.jpg\"}]", "2026-01-31 09:33:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:33:19", "2026-01-31 09:33:19");
INSERT INTO `wp_aioseo_posts` VALUES("215", "20501", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/home-section-2-4.jpg\"}]", "2026-01-31 09:33:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:33:19", "2026-01-31 09:33:19");
INSERT INTO `wp_aioseo_posts` VALUES("216", "20502", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/home-section-2-5.jpg\"}]", "2026-01-31 09:33:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:33:19", "2026-01-31 09:33:19");
INSERT INTO `wp_aioseo_posts` VALUES("217", "20503", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/home-section-2-6.jpg\"}]", "2026-01-31 09:33:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:33:19", "2026-01-31 09:33:19");
INSERT INTO `wp_aioseo_posts` VALUES("218", "20504", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/home-section-2-1-1.jpg\"}]", "2026-01-31 09:33:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:33:19", "2026-01-31 09:33:19");
INSERT INTO `wp_aioseo_posts` VALUES("219", "20543", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/shop-1.jpg\"}]", "2026-01-31 09:33:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:33:19", "2026-01-31 09:33:19");
INSERT INTO `wp_aioseo_posts` VALUES("220", "20544", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/shop-2.jpg\"}]", "2026-01-31 09:33:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:33:19", "2026-01-31 09:33:19");
INSERT INTO `wp_aioseo_posts` VALUES("221", "20545", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/shop-4.jpg\"}]", "2026-01-31 09:33:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:33:19", "2026-01-31 09:33:19");
INSERT INTO `wp_aioseo_posts` VALUES("222", "20546", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/shop-5.jpg\"}]", "2026-01-31 09:35:30", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:35:30", "2026-01-31 09:35:30");
INSERT INTO `wp_aioseo_posts` VALUES("223", "20547", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/shop-6.jpg\"}]", "2026-01-31 09:35:30", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:35:30", "2026-01-31 09:35:30");
INSERT INTO `wp_aioseo_posts` VALUES("224", "20548", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/shop-7.jpg\"}]", "2026-01-31 09:35:30", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:35:30", "2026-01-31 09:35:30");
INSERT INTO `wp_aioseo_posts` VALUES("225", "20549", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/shop-8.jpg\"}]", "2026-01-31 09:35:30", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:35:30", "2026-01-31 09:35:30");
INSERT INTO `wp_aioseo_posts` VALUES("226", "20550", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/shop-9.jpg\"}]", "2026-01-31 09:35:30", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:35:30", "2026-01-31 09:35:30");
INSERT INTO `wp_aioseo_posts` VALUES("227", "20551", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/shop-10.jpg\"}]", "2026-01-31 09:35:30", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:35:30", "2026-01-31 09:35:30");
INSERT INTO `wp_aioseo_posts` VALUES("228", "20552", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/shop-11.jpg\"}]", "2026-01-31 09:35:30", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:35:30", "2026-01-31 09:35:30");
INSERT INTO `wp_aioseo_posts` VALUES("229", "20553", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/shop-13.jpg\"}]", "2026-01-31 09:35:30", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:35:30", "2026-01-31 09:35:30");
INSERT INTO `wp_aioseo_posts` VALUES("230", "20554", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/shop-15.jpg\"}]", "2026-01-31 09:35:30", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:35:30", "2026-01-31 09:35:30");
INSERT INTO `wp_aioseo_posts` VALUES("231", "20561", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/slider-path-2.svg\"}]", "2026-01-31 09:35:30", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:35:30", "2026-01-31 09:35:30");
INSERT INTO `wp_aioseo_posts` VALUES("232", "20564", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/home-2-event-1.jpg\"}]", "2026-01-31 09:36:29", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:36:29", "2026-01-31 09:36:29");
INSERT INTO `wp_aioseo_posts` VALUES("233", "20565", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/home-2-event-2.jpg\"}]", "2026-01-31 09:36:29", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:36:29", "2026-01-31 09:36:29");
INSERT INTO `wp_aioseo_posts` VALUES("234", "20566", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/home-2-event-3.jpg\"}]", "2026-01-31 09:36:29", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:36:29", "2026-01-31 09:36:29");
INSERT INTO `wp_aioseo_posts` VALUES("235", "20567", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/home-testi-2-1.jpg\"}]", "2026-01-31 09:36:29", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:36:29", "2026-01-31 09:36:29");
INSERT INTO `wp_aioseo_posts` VALUES("236", "20568", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/home-testi-2-2.jpg\"}]", "2026-01-31 09:36:29", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:36:29", "2026-01-31 09:36:29");
INSERT INTO `wp_aioseo_posts` VALUES("237", "20569", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/home-testi-2-3.jpg\"}]", "2026-01-31 09:36:29", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:36:29", "2026-01-31 09:36:29");
INSERT INTO `wp_aioseo_posts` VALUES("238", "20571", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/home-testi-2-4.jpg\"}]", "2026-01-31 09:36:29", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:36:29", "2026-01-31 09:36:29");
INSERT INTO `wp_aioseo_posts` VALUES("239", "20572", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/home-3-1.png\"}]", "2026-01-31 09:36:29", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:36:29", "2026-01-31 09:36:29");
INSERT INTO `wp_aioseo_posts` VALUES("240", "20573", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/home-3-2.png\"}]", "2026-01-31 09:36:29", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:36:29", "2026-01-31 09:36:29");
INSERT INTO `wp_aioseo_posts` VALUES("241", "20574", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/home-3-1-1.jpg\"}]", "2026-01-31 09:36:29", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:36:29", "2026-01-31 09:36:29");
INSERT INTO `wp_aioseo_posts` VALUES("242", "20579", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/portfolio-8.jpg\"}]", "2026-01-31 09:37:25", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:37:25", "2026-01-31 09:37:25");
INSERT INTO `wp_aioseo_posts` VALUES("243", "20580", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/portfolio-1.jpg\"}]", "2026-01-31 09:37:25", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:37:25", "2026-01-31 09:37:25");
INSERT INTO `wp_aioseo_posts` VALUES("244", "20581", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/portfolio-2.jpg\"}]", "2026-01-31 09:37:25", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:37:25", "2026-01-31 09:37:25");
INSERT INTO `wp_aioseo_posts` VALUES("245", "20582", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/portfolio-3.jpg\"}]", "2026-01-31 09:37:25", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:37:25", "2026-01-31 09:37:25");
INSERT INTO `wp_aioseo_posts` VALUES("246", "20583", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/portfolio-5.jpg\"}]", "2026-01-31 09:37:25", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:37:25", "2026-01-31 09:37:25");
INSERT INTO `wp_aioseo_posts` VALUES("247", "20584", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/portfolio-4.jpg\"}]", "2026-01-31 09:37:25", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:37:25", "2026-01-31 09:37:25");
INSERT INTO `wp_aioseo_posts` VALUES("248", "20585", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/portfolio-6.jpg\"}]", "2026-01-31 09:37:25", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:37:25", "2026-01-31 09:37:25");
INSERT INTO `wp_aioseo_posts` VALUES("249", "20586", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/portfolio-7.jpg\"}]", "2026-01-31 09:37:25", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:37:25", "2026-01-31 09:37:25");
INSERT INTO `wp_aioseo_posts` VALUES("250", "20587", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/home-1-event-1.jpg\"}]", "2026-01-31 09:37:25", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:37:25", "2026-01-31 09:37:25");
INSERT INTO `wp_aioseo_posts` VALUES("251", "20588", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/home-1-event-3.jpg\"}]", "2026-01-31 09:37:25", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:37:25", "2026-01-31 09:37:25");
INSERT INTO `wp_aioseo_posts` VALUES("252", "20589", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/home-1-event-2.jpg\"}]", "2026-01-31 09:39:23", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:39:23", "2026-01-31 09:39:23");
INSERT INTO `wp_aioseo_posts` VALUES("253", "20591", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/portfolio-001-copy.jpg\"}]", "2026-01-31 09:39:23", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:39:23", "2026-01-31 09:39:23");
INSERT INTO `wp_aioseo_posts` VALUES("254", "20603", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/home-section-2-1.jpg\"}]", "2026-01-31 09:39:23", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:39:23", "2026-01-31 09:39:23");
INSERT INTO `wp_aioseo_posts` VALUES("255", "20604", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/home-section-2-7.jpg\"}]", "2026-01-31 09:39:23", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:39:23", "2026-01-31 09:39:23");
INSERT INTO `wp_aioseo_posts` VALUES("256", "20608", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/home-2-donation-detail-01.jpg\"}]", "2026-01-31 09:39:23", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:39:23", "2026-01-31 09:39:23");
INSERT INTO `wp_aioseo_posts` VALUES("257", "20627", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/home-donation-detail-3-3.jpg\"}]", "2026-01-31 09:39:23", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:39:23", "2026-01-31 09:39:23");
INSERT INTO `wp_aioseo_posts` VALUES("258", "20628", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/home-donation-detail-1.jpg\"}]", "2026-01-31 09:39:23", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:39:23", "2026-01-31 09:39:23");
INSERT INTO `wp_aioseo_posts` VALUES("259", "20629", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/home-donation-detail-3.jpg\"}]", "2026-01-31 09:39:23", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:39:23", "2026-01-31 09:39:23");
INSERT INTO `wp_aioseo_posts` VALUES("260", "20630", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/home-donation-detail-2.jpg\"}]", "2026-01-31 09:39:23", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:39:23", "2026-01-31 09:39:23");
INSERT INTO `wp_aioseo_posts` VALUES("261", "20631", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/home-donation-detail-4.jpg\"}]", "2026-01-31 09:39:23", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:39:23", "2026-01-31 09:39:23");
INSERT INTO `wp_aioseo_posts` VALUES("262", "20632", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/home-donation-detail-3-1.jpg\"}]", "2026-01-31 09:41:25", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:41:25", "2026-01-31 09:41:25");
INSERT INTO `wp_aioseo_posts` VALUES("263", "20633", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/home-donation-detail-3-2.jpg\"}]", "2026-01-31 09:41:25", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:41:25", "2026-01-31 09:41:25");
INSERT INTO `wp_aioseo_posts` VALUES("264", "20634", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/event-detail-2.jpg\"}]", "2026-01-31 09:41:25", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:41:25", "2026-01-31 09:41:25");
INSERT INTO `wp_aioseo_posts` VALUES("265", "20635", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/event-detail-1.jpg\"}]", "2026-01-31 09:41:25", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:41:25", "2026-01-31 09:41:25");
INSERT INTO `wp_aioseo_posts` VALUES("266", "20638", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/home-01-1.jpg\"}]", "2026-01-31 09:41:25", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:41:25", "2026-01-31 09:41:25");
INSERT INTO `wp_aioseo_posts` VALUES("267", "20639", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/one-half-image-scaled-image.jpg\"}]", "2026-01-31 09:41:25", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:41:25", "2026-01-31 09:41:25");
INSERT INTO `wp_aioseo_posts` VALUES("268", "20649", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/footer-image-scaled-1.jpg\"}]", "2026-01-31 09:41:25", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:41:25", "2026-01-31 09:41:25");
INSERT INTO `wp_aioseo_posts` VALUES("269", "20651", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/buddha-image.jpg\"}]", "2026-01-31 09:41:25", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:41:25", "2026-01-31 09:41:25");
INSERT INTO `wp_aioseo_posts` VALUES("270", "20652", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Untitled-1.jpg\"}]", "2026-01-31 09:41:25", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:41:25", "2026-01-31 09:41:25");
INSERT INTO `wp_aioseo_posts` VALUES("271", "20654", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Mask-Group-5.png\"}]", "2026-01-31 09:41:25", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:41:25", "2026-01-31 09:41:25");
INSERT INTO `wp_aioseo_posts` VALUES("272", "20655", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Mask-Group-6.png\"}]", "2026-01-31 09:43:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:43:19", "2026-01-31 09:43:19");
INSERT INTO `wp_aioseo_posts` VALUES("273", "20657", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/slider-02-icon-02.png\"}]", "2026-01-31 09:43:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:43:19", "2026-01-31 09:43:19");
INSERT INTO `wp_aioseo_posts` VALUES("274", "20659", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/slider-02-icon-01.png\"}]", "2026-01-31 09:43:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:43:19", "2026-01-31 09:43:19");
INSERT INTO `wp_aioseo_posts` VALUES("275", "20663", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/image-2.jpg\"}]", "2026-01-31 09:43:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:43:19", "2026-01-31 09:43:19");
INSERT INTO `wp_aioseo_posts` VALUES("276", "20666", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/image-3.jpg\"}]", "2026-01-31 09:43:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:43:19", "2026-01-31 09:43:19");
INSERT INTO `wp_aioseo_posts` VALUES("277", "20667", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/4.jpg\"}]", "2026-01-31 09:43:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:43:19", "2026-01-31 09:43:19");
INSERT INTO `wp_aioseo_posts` VALUES("278", "20668", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/3.jpg\"}]", "2026-01-31 09:43:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:43:19", "2026-01-31 09:43:19");
INSERT INTO `wp_aioseo_posts` VALUES("279", "20669", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/2.jpg\"}]", "2026-01-31 09:43:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:43:19", "2026-01-31 09:43:19");
INSERT INTO `wp_aioseo_posts` VALUES("280", "20670", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/1.jpg\"}]", "2026-01-31 09:43:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:43:19", "2026-01-31 09:43:19");
INSERT INTO `wp_aioseo_posts` VALUES("281", "20671", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/5.jpg\"}]", "2026-01-31 09:43:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:43:19", "2026-01-31 09:43:19");
INSERT INTO `wp_aioseo_posts` VALUES("282", "20672", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/image-4.jpg\"}]", "2026-01-31 09:45:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:45:20", "2026-01-31 09:45:20");
INSERT INTO `wp_aioseo_posts` VALUES("283", "20673", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/protfolio-image-1.jpg\"}]", "2026-01-31 09:45:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:45:20", "2026-01-31 09:45:20");
INSERT INTO `wp_aioseo_posts` VALUES("284", "20674", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/protfolio-image-2.jpg\"}]", "2026-01-31 09:45:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:45:20", "2026-01-31 09:45:20");
INSERT INTO `wp_aioseo_posts` VALUES("285", "20675", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/protfolio-image-3.jpg\"}]", "2026-01-31 09:45:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:45:20", "2026-01-31 09:45:20");
INSERT INTO `wp_aioseo_posts` VALUES("286", "20676", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/protfolio-image-4.jpg\"}]", "2026-01-31 09:45:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:45:20", "2026-01-31 09:45:20");
INSERT INTO `wp_aioseo_posts` VALUES("287", "20677", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/protfolio-image-5.jpg\"}]", "2026-01-31 09:45:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:45:20", "2026-01-31 09:45:20");
INSERT INTO `wp_aioseo_posts` VALUES("288", "20678", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/protfolio-image-6.jpg\"}]", "2026-01-31 09:45:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:45:20", "2026-01-31 09:45:20");
INSERT INTO `wp_aioseo_posts` VALUES("289", "20679", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/protfolio-image-7.jpg\"}]", "2026-01-31 09:45:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:45:20", "2026-01-31 09:45:20");
INSERT INTO `wp_aioseo_posts` VALUES("290", "20680", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/protfolio-image-8.jpg\"}]", "2026-01-31 09:45:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:45:20", "2026-01-31 09:45:20");
INSERT INTO `wp_aioseo_posts` VALUES("291", "20681", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/protfolio-image-9.jpg\"}]", "2026-01-31 09:45:20", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:45:20", "2026-01-31 09:45:20");
INSERT INTO `wp_aioseo_posts` VALUES("292", "20682", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/protfolio-image-3a.jpg\"}]", "2026-01-31 09:46:25", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:46:25", "2026-01-31 09:46:25");
INSERT INTO `wp_aioseo_posts` VALUES("293", "20698", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/blog-1.jpg\"}]", "2026-01-31 09:46:25", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:46:25", "2026-01-31 09:46:25");
INSERT INTO `wp_aioseo_posts` VALUES("294", "20700", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/blog-2.jpg\"}]", "2026-01-31 09:46:25", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:46:25", "2026-01-31 09:46:25");
INSERT INTO `wp_aioseo_posts` VALUES("295", "20701", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/blog-3.jpg\"}]", "2026-01-31 09:46:25", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:46:25", "2026-01-31 09:46:25");
INSERT INTO `wp_aioseo_posts` VALUES("296", "20703", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/blog-4.jpg\"}]", "2026-01-31 09:46:25", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:46:25", "2026-01-31 09:46:25");
INSERT INTO `wp_aioseo_posts` VALUES("297", "20704", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/blog-1-1.jpg\"}]", "2026-01-31 09:46:25", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:46:25", "2026-01-31 09:46:25");
INSERT INTO `wp_aioseo_posts` VALUES("298", "20706", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/blog-2-1.jpg\"}]", "2026-01-31 09:46:25", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:46:25", "2026-01-31 09:46:25");
INSERT INTO `wp_aioseo_posts` VALUES("299", "20708", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/blog-3-1.jpg\"}]", "2026-01-31 09:46:25", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:46:25", "2026-01-31 09:46:25");
INSERT INTO `wp_aioseo_posts` VALUES("300", "20713", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/blog-image-3.jpg\"}]", "2026-01-31 09:46:25", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:46:25", "2026-01-31 09:46:25");
INSERT INTO `wp_aioseo_posts` VALUES("301", "20716", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/service-image.jpg\"}]", "2026-01-31 09:46:25", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:46:25", "2026-01-31 09:46:25");
INSERT INTO `wp_aioseo_posts` VALUES("302", "20717", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/service-image-2.jpg\"}]", "2026-01-31 09:47:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:47:21", "2026-01-31 09:47:21");
INSERT INTO `wp_aioseo_posts` VALUES("303", "20718", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/service-image-3.jpg\"}]", "2026-01-31 09:47:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:47:21", "2026-01-31 09:47:21");
INSERT INTO `wp_aioseo_posts` VALUES("304", "20719", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/service-image-4.jpg\"}]", "2026-01-31 09:47:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:47:21", "2026-01-31 09:47:21");
INSERT INTO `wp_aioseo_posts` VALUES("305", "20721", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/Church-Logo-1.svg\"}]", "2026-01-31 09:47:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:47:21", "2026-01-31 09:47:21");
INSERT INTO `wp_aioseo_posts` VALUES("306", "20727", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/play-icon.svg\"}]", "2026-01-31 09:47:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:47:21", "2026-01-31 09:47:21");
INSERT INTO `wp_aioseo_posts` VALUES("307", "20728", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/play-icon-1.svg\"}]", "2026-01-31 09:47:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:47:21", "2026-01-31 09:47:21");
INSERT INTO `wp_aioseo_posts` VALUES("308", "20752", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/home-gallery-1.jpg\"}]", "2026-01-31 09:47:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:47:21", "2026-01-31 09:47:21");
INSERT INTO `wp_aioseo_posts` VALUES("309", "20753", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/home-gallery-2.jpg\"}]", "2026-01-31 09:47:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:47:21", "2026-01-31 09:47:21");
INSERT INTO `wp_aioseo_posts` VALUES("310", "20755", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/home-gallery-3.jpg\"}]", "2026-01-31 09:47:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:47:21", "2026-01-31 09:47:21");
INSERT INTO `wp_aioseo_posts` VALUES("311", "20763", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/10\\/icon-list-1a.svg\"}]", "2026-01-31 09:47:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:47:21", "2026-01-31 09:47:21");
INSERT INTO `wp_aioseo_posts` VALUES("312", "20764", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/flower-svg-icon.svg\"}]", "2026-01-31 09:48:40", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:48:40", "2026-01-31 09:48:40");
INSERT INTO `wp_aioseo_posts` VALUES("313", "20780", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/569x459.jpg\"}]", "2026-01-31 09:48:40", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:48:40", "2026-01-31 09:48:40");
INSERT INTO `wp_aioseo_posts` VALUES("314", "20781", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/710x820.jpg\"}]", "2026-01-31 09:48:40", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:48:40", "2026-01-31 09:48:40");
INSERT INTO `wp_aioseo_posts` VALUES("315", "20782", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/700x680.jpg\"}]", "2026-01-31 09:48:40", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:48:40", "2026-01-31 09:48:40");
INSERT INTO `wp_aioseo_posts` VALUES("316", "20787", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-2-donation-detail-1.jpg\"}]", "2026-01-31 09:48:40", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:48:40", "2026-01-31 09:48:40");
INSERT INTO `wp_aioseo_posts` VALUES("317", "20788", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-2-donation-detail-2.jpg\"}]", "2026-01-31 09:48:40", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:48:40", "2026-01-31 09:48:40");
INSERT INTO `wp_aioseo_posts` VALUES("318", "20789", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-2-donation-detail-3.jpg\"}]", "2026-01-31 09:48:40", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:48:40", "2026-01-31 09:48:40");
INSERT INTO `wp_aioseo_posts` VALUES("319", "20798", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-2-donation-detail-4-1.jpg\"}]", "2026-01-31 09:48:40", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:48:40", "2026-01-31 09:48:40");
INSERT INTO `wp_aioseo_posts` VALUES("320", "20800", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-3-donation-detail-2.jpg\"}]", "2026-01-31 09:48:40", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:48:40", "2026-01-31 09:48:40");
INSERT INTO `wp_aioseo_posts` VALUES("321", "20801", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-3-donation-detail-3.jpg\"}]", "2026-01-31 09:48:40", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:48:40", "2026-01-31 09:48:40");
INSERT INTO `wp_aioseo_posts` VALUES("322", "20805", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-3-donation-detail-1-1.jpg\"}]", "2026-01-31 09:49:26", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:49:26", "2026-01-31 09:49:26");
INSERT INTO `wp_aioseo_posts` VALUES("323", "20810", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-3-donation-detail-4-2.jpg\"}]", "2026-01-31 09:49:26", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:49:26", "2026-01-31 09:49:26");
INSERT INTO `wp_aioseo_posts` VALUES("324", "20813", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-1-donation-1.jpg\"}]", "2026-01-31 09:49:26", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:49:26", "2026-01-31 09:49:26");
INSERT INTO `wp_aioseo_posts` VALUES("325", "20815", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-1-donation-1-1.jpg\"}]", "2026-01-31 09:49:26", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:49:26", "2026-01-31 09:49:26");
INSERT INTO `wp_aioseo_posts` VALUES("326", "20823", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/square.svg\"}]", "2026-01-31 09:49:26", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:49:26", "2026-01-31 09:49:26");
INSERT INTO `wp_aioseo_posts` VALUES("327", "20826", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/Creedy-Black-logo.svg\"}]", "2026-01-31 09:49:26", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:49:26", "2026-01-31 09:49:26");
INSERT INTO `wp_aioseo_posts` VALUES("328", "20827", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/Creedy-White-logo.svg\"}]", "2026-01-31 09:49:26", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:49:26", "2026-01-31 09:49:26");
INSERT INTO `wp_aioseo_posts` VALUES("329", "20830", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/Creedy-Black-logo-1.svg\"}]", "2026-01-31 09:49:26", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:49:26", "2026-01-31 09:49:26");
INSERT INTO `wp_aioseo_posts` VALUES("330", "20831", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/Creedy-White-logo-1.svg\"}]", "2026-01-31 09:49:26", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:49:26", "2026-01-31 09:49:26");
INSERT INTO `wp_aioseo_posts` VALUES("331", "20835", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/H2-white-logo-1.svg\"}]", "2026-01-31 09:49:26", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:49:26", "2026-01-31 09:49:26");
INSERT INTO `wp_aioseo_posts` VALUES("332", "20857", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/home-1-donation-new-1.jpg\"}]", "2026-01-31 09:50:27", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:50:27", "2026-01-31 09:50:27");
INSERT INTO `wp_aioseo_posts` VALUES("333", "20859", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/home-1-donation-new-2.jpg\"}]", "2026-01-31 09:50:27", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:50:27", "2026-01-31 09:50:27");
INSERT INTO `wp_aioseo_posts` VALUES("334", "20861", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/home-1-donation-new-3.jpg\"}]", "2026-01-31 09:50:27", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:50:27", "2026-01-31 09:50:27");
INSERT INTO `wp_aioseo_posts` VALUES("335", "20864", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/home-1-donation-new-4.jpg\"}]", "2026-01-31 09:50:27", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:50:27", "2026-01-31 09:50:27");
INSERT INTO `wp_aioseo_posts` VALUES("336", "20866", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/home-1-donation-new-5-1.jpg\"}]", "2026-01-31 09:50:27", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:50:27", "2026-01-31 09:50:27");
INSERT INTO `wp_aioseo_posts` VALUES("337", "20868", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-1-donation-new-6.jpg\"}]", "2026-01-31 09:50:27", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:50:27", "2026-01-31 09:50:27");
INSERT INTO `wp_aioseo_posts` VALUES("338", "20870", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2022\\/11\\/home-1-donation-new-7.jpg\"}]", "2026-01-31 09:50:27", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:50:27", "2026-01-31 09:50:27");
INSERT INTO `wp_aioseo_posts` VALUES("339", "20873", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-1-donation-new-8.jpg\"}]", "2026-01-31 09:50:27", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:50:27", "2026-01-31 09:50:27");
INSERT INTO `wp_aioseo_posts` VALUES("340", "20875", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-1-donation-new-9.jpg\"}]", "2026-01-31 09:50:27", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:50:27", "2026-01-31 09:50:27");
INSERT INTO `wp_aioseo_posts` VALUES("341", "20880", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-2-donation-new-1.jpg\"}]", "2026-01-31 09:50:27", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:50:27", "2026-01-31 09:50:27");
INSERT INTO `wp_aioseo_posts` VALUES("342", "20881", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/home-2-donation-new-2.jpg\"}]", "2026-01-31 09:52:23", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:52:23", "2026-01-31 09:52:23");
INSERT INTO `wp_aioseo_posts` VALUES("343", "20883", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-2-donation-new-3.jpg\"}]", "2026-01-31 09:52:23", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:52:23", "2026-01-31 09:52:23");
INSERT INTO `wp_aioseo_posts` VALUES("344", "20888", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-2-donation-new-4.jpg\"}]", "2026-01-31 09:52:23", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:52:23", "2026-01-31 09:52:23");
INSERT INTO `wp_aioseo_posts` VALUES("345", "20889", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-2-donation-new-5.jpg\"}]", "2026-01-31 09:52:23", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:52:23", "2026-01-31 09:52:23");
INSERT INTO `wp_aioseo_posts` VALUES("346", "20891", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-2-donation-detail-2-4.jpg\"}]", "2026-01-31 09:52:23", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:52:23", "2026-01-31 09:52:23");
INSERT INTO `wp_aioseo_posts` VALUES("347", "20892", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-2-donation-detail-3-3.jpg\"}]", "2026-01-31 09:52:23", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:52:23", "2026-01-31 09:52:23");
INSERT INTO `wp_aioseo_posts` VALUES("348", "20893", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-2-donation-detail-4-2.jpg\"}]", "2026-01-31 09:52:23", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:52:23", "2026-01-31 09:52:23");
INSERT INTO `wp_aioseo_posts` VALUES("349", "20895", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/home-3-donation-new-2.jpg\"}]", "2026-01-31 09:52:23", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:52:23", "2026-01-31 09:52:23");
INSERT INTO `wp_aioseo_posts` VALUES("350", "20897", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/home-3-donation-new-3-1.jpg\"}]", "2026-01-31 09:52:23", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:52:23", "2026-01-31 09:52:23");
INSERT INTO `wp_aioseo_posts` VALUES("351", "20903", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-3-donation-new-1.jpg\"}]", "2026-01-31 09:52:23", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:52:23", "2026-01-31 09:52:23");
INSERT INTO `wp_aioseo_posts` VALUES("352", "20904", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-1-donation-new-1-detail-3.jpg\"}]", "2026-01-31 09:53:18", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:53:18", "2026-01-31 09:53:18");
INSERT INTO `wp_aioseo_posts` VALUES("353", "20905", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-1-donation-new-3-detail-2.jpg\"}]", "2026-01-31 09:53:18", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:53:18", "2026-01-31 09:53:18");
INSERT INTO `wp_aioseo_posts` VALUES("354", "20906", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-1-donation-new-3-detail-3.jpg\"}]", "2026-01-31 09:53:18", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:53:18", "2026-01-31 09:53:18");
INSERT INTO `wp_aioseo_posts` VALUES("355", "20907", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-1-donation-new-4-detail-2.jpg\"}]", "2026-01-31 09:53:18", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:53:18", "2026-01-31 09:53:18");
INSERT INTO `wp_aioseo_posts` VALUES("356", "20908", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-1-donation-new-4-detail-3.jpg\"}]", "2026-01-31 09:53:18", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:53:18", "2026-01-31 09:53:18");
INSERT INTO `wp_aioseo_posts` VALUES("357", "20909", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-1-donation-new-4-detail-4.jpg\"}]", "2026-01-31 09:53:18", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:53:18", "2026-01-31 09:53:18");
INSERT INTO `wp_aioseo_posts` VALUES("358", "20910", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-1-donation-new-1-detail-1.jpg\"}]", "2026-01-31 09:53:18", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:53:18", "2026-01-31 09:53:18");
INSERT INTO `wp_aioseo_posts` VALUES("359", "20913", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-1-donation-new-1-detail-4-1.jpg\"}]", "2026-01-31 09:53:18", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:53:18", "2026-01-31 09:53:18");
INSERT INTO `wp_aioseo_posts` VALUES("360", "20914", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-1-donation-new-1-detail-5.jpg\"}]", "2026-01-31 09:53:18", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:53:18", "2026-01-31 09:53:18");
INSERT INTO `wp_aioseo_posts` VALUES("361", "20915", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-1-donation-new-3-detail-4.jpg\"}]", "2026-01-31 09:53:18", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:53:18", "2026-01-31 09:53:18");
INSERT INTO `wp_aioseo_posts` VALUES("362", "20916", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-1-donation-new-1-detail-2-1.jpg\"}]", "2026-01-31 09:55:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:55:19", "2026-01-31 09:55:19");
INSERT INTO `wp_aioseo_posts` VALUES("363", "20919", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-1-donation-new-2-detail-1.jpg\"}]", "2026-01-31 09:55:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:55:19", "2026-01-31 09:55:19");
INSERT INTO `wp_aioseo_posts` VALUES("364", "20920", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-1-donation-new-2-detail-2.jpg\"}]", "2026-01-31 09:55:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:55:19", "2026-01-31 09:55:19");
INSERT INTO `wp_aioseo_posts` VALUES("365", "20921", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-1-donation-new-2-detail-3.jpg\"}]", "2026-01-31 09:55:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:55:19", "2026-01-31 09:55:19");
INSERT INTO `wp_aioseo_posts` VALUES("366", "20925", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-1-donation-new-1-detail-6-2.jpg\"}]", "2026-01-31 09:55:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:55:19", "2026-01-31 09:55:19");
INSERT INTO `wp_aioseo_posts` VALUES("367", "20926", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-1-donation-new-1-detail-8-2.jpg\"}]", "2026-01-31 09:55:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:55:19", "2026-01-31 09:55:19");
INSERT INTO `wp_aioseo_posts` VALUES("368", "20928", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-1-donation-new-5-detail-2.jpg\"}]", "2026-01-31 09:55:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:55:19", "2026-01-31 09:55:19");
INSERT INTO `wp_aioseo_posts` VALUES("369", "20929", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-1-donation-new-5-detail-5.jpg\"}]", "2026-01-31 09:55:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:55:19", "2026-01-31 09:55:19");
INSERT INTO `wp_aioseo_posts` VALUES("370", "20930", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-1-donation-new-5-detail-6.jpg\"}]", "2026-01-31 09:55:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:55:19", "2026-01-31 09:55:19");
INSERT INTO `wp_aioseo_posts` VALUES("371", "20931", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-1-donation-new-5-detail-1-1.jpg\"}]", "2026-01-31 09:55:19", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:55:19", "2026-01-31 09:55:19");
INSERT INTO `wp_aioseo_posts` VALUES("372", "20932", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-1-donation-new-5-detail-3.jpg\"}]", "2026-01-31 09:57:02", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:57:02", "2026-01-31 09:57:02");
INSERT INTO `wp_aioseo_posts` VALUES("373", "20933", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-1-donation-new-5-detail-4.jpg\"}]", "2026-01-31 09:57:02", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:57:02", "2026-01-31 09:57:02");
INSERT INTO `wp_aioseo_posts` VALUES("374", "20934", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-service-carousel-1.jpg\"}]", "2026-01-31 09:57:02", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:57:02", "2026-01-31 09:57:02");
INSERT INTO `wp_aioseo_posts` VALUES("375", "20935", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-1-testimonial-1.jpg\"}]", "2026-01-31 09:57:02", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:57:02", "2026-01-31 09:57:02");
INSERT INTO `wp_aioseo_posts` VALUES("376", "20936", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-1-testimonial-2.jpg\"}]", "2026-01-31 09:57:02", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:57:02", "2026-01-31 09:57:02");
INSERT INTO `wp_aioseo_posts` VALUES("377", "20937", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-1-testimonial-3.jpg\"}]", "2026-01-31 09:57:02", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:57:02", "2026-01-31 09:57:02");
INSERT INTO `wp_aioseo_posts` VALUES("378", "20938", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-1-testimonial-4.jpg\"}]", "2026-01-31 09:57:02", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:57:02", "2026-01-31 09:57:02");
INSERT INTO `wp_aioseo_posts` VALUES("379", "20940", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/02\\/home-1-testimonial-5.jpg\"}]", "2026-01-31 09:57:02", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:57:02", "2026-01-31 09:57:02");
INSERT INTO `wp_aioseo_posts` VALUES("380", "20949", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2023\\/01\\/chirs.png\"}]", "2026-01-31 09:57:02", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:57:02", "2026-01-31 09:57:02");
INSERT INTO `wp_aioseo_posts` VALUES("381", "21031", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/woocommerce-placeholder.webp\"}]", "2026-01-31 09:57:02", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:57:02", "2026-01-31 09:57:02");
INSERT INTO `wp_aioseo_posts` VALUES("382", "21033", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", NULL, "2026-01-31 09:59:14", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:59:14", "2026-01-31 09:59:14");
INSERT INTO `wp_aioseo_posts` VALUES("383", "21049", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/Panchang-Vastu-logo.png.bv_resized_desktop.png.bv_.webp\"}]", "2026-01-31 09:59:14", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:59:14", "2026-01-31 09:59:14");
INSERT INTO `wp_aioseo_posts` VALUES("384", "21050", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/cropped-Panchang-Vastu-logo.png.bv_resized_desktop.png.bv_.webp\"}]", "2026-01-31 09:59:14", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:59:14", "2026-01-31 09:59:14");
INSERT INTO `wp_aioseo_posts` VALUES("385", "21052", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/cropped-Panchang-Vastu-logo.png.bv_resized_desktop.png.bv_-1.webp\"}]", "2026-01-31 09:59:14", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:59:14", "2026-01-31 09:59:14");
INSERT INTO `wp_aioseo_posts` VALUES("386", "21053", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/cropped-cropped-Panchang-Vastu-logo.png.bv_resized_desktop.png.bv_-1.webp\"}]", "2026-01-31 09:59:14", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:59:14", "2026-01-31 09:59:14");
INSERT INTO `wp_aioseo_posts` VALUES("387", "21054", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/cropped-cropped-cropped-Panchang-Vastu-logo.png.bv_resized_desktop.png.bv_-1.webp\"}]", "2026-01-31 09:59:14", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:59:14", "2026-01-31 09:59:14");
INSERT INTO `wp_aioseo_posts` VALUES("388", "21061", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/1.png.bv_.webp\"}]", "2026-01-31 09:59:14", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:59:14", "2026-01-31 09:59:14");
INSERT INTO `wp_aioseo_posts` VALUES("389", "21062", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/tarot_Illustrations_13.png.bv_.webp\"}]", "2026-01-31 09:59:14", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:59:14", "2026-01-31 09:59:14");
INSERT INTO `wp_aioseo_posts` VALUES("390", "21063", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/Vaastu-purush.png.bv_.webp\"}]", "2026-01-31 09:59:14", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:59:14", "2026-01-31 09:59:14");
INSERT INTO `wp_aioseo_posts` VALUES("391", "21075", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/4440903659.png.bv_.webp\"}]", "2026-01-31 09:59:14", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 09:59:14", "2026-01-31 09:59:14");
INSERT INTO `wp_aioseo_posts` VALUES("392", "21099", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/1.png.bv-1.webp\"}]", "2026-01-31 10:00:17", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:00:17", "2026-01-31 10:00:17");
INSERT INTO `wp_aioseo_posts` VALUES("393", "21103", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/tarot_Illustrations_13.png.bv-1.webp\"}]", "2026-01-31 10:00:17", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:00:17", "2026-01-31 10:00:17");
INSERT INTO `wp_aioseo_posts` VALUES("394", "21121", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/IMG_20231231_231223-400x516-1.jpg\"}]", "2026-01-31 10:00:17", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:00:17", "2026-01-31 10:00:17");
INSERT INTO `wp_aioseo_posts` VALUES("395", "21122", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/WhatsApp-Image-2025-05-03-at-1.27.36-PM.jpeg.bv_.webp\"}]", "2026-01-31 10:00:17", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:00:17", "2026-01-31 10:00:17");
INSERT INTO `wp_aioseo_posts` VALUES("396", "21123", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/WhatsApp-Image-2025-05-03-at-1.28.10-PM.jpeg\"}]", "2026-01-31 10:00:17", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:00:17", "2026-01-31 10:00:17");
INSERT INTO `wp_aioseo_posts` VALUES("397", "21124", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/WhatsApp-Image-2025-05-03-at-1.32.01-PM-2.jpeg\"}]", "2026-01-31 10:00:17", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:00:17", "2026-01-31 10:00:17");
INSERT INTO `wp_aioseo_posts` VALUES("398", "21125", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/WhatsApp-Image-2025-05-03-at-1.32.38-PM-1.jpeg\"}]", "2026-01-31 10:00:17", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:00:17", "2026-01-31 10:00:17");
INSERT INTO `wp_aioseo_posts` VALUES("399", "21126", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/WhatsApp-Image-2025-05-09-at-1.15.51-PM-400x516-1.jpeg\"}]", "2026-01-31 10:00:17", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:00:17", "2026-01-31 10:00:17");
INSERT INTO `wp_aioseo_posts` VALUES("400", "21154", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/guruji.png\"}]", "2026-01-31 10:00:17", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:00:17", "2026-01-31 10:00:17");
INSERT INTO `wp_aioseo_posts` VALUES("401", "21156", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/WhatsApp-Image-2025-05-12-at-10.14.41-AM-400x516-1.jpeg\"}]", "2026-01-31 10:00:17", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:00:17", "2026-01-31 10:00:17");
INSERT INTO `wp_aioseo_posts` VALUES("402", "21157", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/WhatsApp-Image-2025-05-12-at-10.14.42-AM-400x516-1.jpeg\"}]", "2026-01-31 10:01:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:01:21", "2026-01-31 10:01:21");
INSERT INTO `wp_aioseo_posts` VALUES("403", "21158", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/WhatsApp-Image-2025-05-12-at-10.16.07-AM-400x516-1.jpeg\"}]", "2026-01-31 10:01:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:01:21", "2026-01-31 10:01:21");
INSERT INTO `wp_aioseo_posts` VALUES("404", "21159", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/WhatsApp-Image-2025-05-12-at-10.16.51-AM-400x516-1.jpeg\"}]", "2026-01-31 10:01:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:01:21", "2026-01-31 10:01:21");
INSERT INTO `wp_aioseo_posts` VALUES("405", "21160", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/WhatsApp-Image-2025-05-12-at-10.18.19-AM-400x516-1.jpeg\"}]", "2026-01-31 10:01:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:01:21", "2026-01-31 10:01:21");
INSERT INTO `wp_aioseo_posts` VALUES("406", "21164", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/astrology-illustrations-10-400x1024-2.png\"}]", "2026-01-31 10:01:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:01:21", "2026-01-31 10:01:21");
INSERT INTO `wp_aioseo_posts` VALUES("407", "21169", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/WhatsApp-Image-2025-05-03-at-1.32.38-PM-1-1.jpeg\"}]", "2026-01-31 10:01:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:01:21", "2026-01-31 10:01:21");
INSERT INTO `wp_aioseo_posts` VALUES("408", "21170", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/WhatsApp-Image-2025-05-03-at-1.32.01-PM-2-1.jpeg\"}]", "2026-01-31 10:01:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:01:21", "2026-01-31 10:01:21");
INSERT INTO `wp_aioseo_posts` VALUES("409", "21171", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/WhatsApp-Image-2025-05-03-at-1.27.36-PM.jpeg.bv-1.webp\"}]", "2026-01-31 10:01:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:01:21", "2026-01-31 10:01:21");
INSERT INTO `wp_aioseo_posts` VALUES("410", "21350", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/WhatsApp-Image-2025-05-03-at-1.32.32-PM-1-400x516-1.jpeg\"}]", "2026-01-31 10:01:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:01:21", "2026-01-31 10:01:21");
INSERT INTO `wp_aioseo_posts` VALUES("411", "21352", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/kalash.png.bv_.webp\"}]", "2026-01-31 10:01:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:01:21", "2026-01-31 10:01:21");
INSERT INTO `wp_aioseo_posts` VALUES("412", "21353", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/IMG-20250208-WA0217.jpg\"}]", "2026-01-31 10:02:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:02:21", "2026-01-31 10:02:21");
INSERT INTO `wp_aioseo_posts` VALUES("413", "21354", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/IMG-20250208-WA0228.jpg\"}]", "2026-01-31 10:02:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:02:21", "2026-01-31 10:02:21");
INSERT INTO `wp_aioseo_posts` VALUES("414", "21355", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/IMG-20250208-WA0201.jpg\"}]", "2026-01-31 10:02:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:02:21", "2026-01-31 10:02:21");
INSERT INTO `wp_aioseo_posts` VALUES("415", "21356", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/IMG-20250208-WA0202.jpg\"}]", "2026-01-31 10:02:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:02:21", "2026-01-31 10:02:21");
INSERT INTO `wp_aioseo_posts` VALUES("416", "21357", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/IMG-20250208-WA0203.jpg\"}]", "2026-01-31 10:02:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:02:21", "2026-01-31 10:02:21");
INSERT INTO `wp_aioseo_posts` VALUES("417", "21358", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/IMG-20250208-WA0208.jpg\"}]", "2026-01-31 10:02:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:02:21", "2026-01-31 10:02:21");
INSERT INTO `wp_aioseo_posts` VALUES("418", "21359", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/IMG-20250208-WA0216.jpg\"}]", "2026-01-31 10:02:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:02:21", "2026-01-31 10:02:21");
INSERT INTO `wp_aioseo_posts` VALUES("419", "21360", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/IMG-20250208-WA0218.jpg\"}]", "2026-01-31 10:02:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:02:21", "2026-01-31 10:02:21");
INSERT INTO `wp_aioseo_posts` VALUES("420", "21361", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/IMG-20250208-WA0219.jpg\"}]", "2026-01-31 10:02:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:02:21", "2026-01-31 10:02:21");
INSERT INTO `wp_aioseo_posts` VALUES("421", "21362", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/Jyotish-Shastra.png.bv_.webp\"}]", "2026-01-31 10:02:21", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:02:21", "2026-01-31 10:02:21");
INSERT INTO `wp_aioseo_posts` VALUES("422", "21363", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/WhatsApp-Image-2025-05-10-at-4.04.14-PM-1-1.jpeg\"}]", "2026-01-31 10:05:05", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:05:05", "2026-01-31 10:05:05");
INSERT INTO `wp_aioseo_posts` VALUES("423", "21364", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/WhatsApp-Image-2025-05-10-at-4.04.15-PM.jpeg\"}]", "2026-01-31 10:05:05", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:05:05", "2026-01-31 10:05:05");
INSERT INTO `wp_aioseo_posts` VALUES("424", "21365", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/WhatsApp-Image-2025-05-10-at-4.04.16-PM-rotated-1.jpeg\"}]", "2026-01-31 10:05:05", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:05:05", "2026-01-31 10:05:05");
INSERT INTO `wp_aioseo_posts` VALUES("425", "21366", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/WhatsApp-Image-2025-05-10-at-4.04.17-PM-rotated-1.jpeg\"}]", "2026-01-31 10:05:05", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:05:05", "2026-01-31 10:05:05");
INSERT INTO `wp_aioseo_posts` VALUES("426", "21367", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/WhatsApp-Image-2025-05-10-at-4.04.18-PM-rotated-1.jpeg\"}]", "2026-01-31 10:05:05", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:05:05", "2026-01-31 10:05:05");
INSERT INTO `wp_aioseo_posts` VALUES("427", "21368", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/WhatsApp-Image-2025-05-10-at-4.04.19-PM.jpeg\"}]", "2026-01-31 10:05:05", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:05:05", "2026-01-31 10:05:05");
INSERT INTO `wp_aioseo_posts` VALUES("428", "21369", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/WhatsApp-Image-2025-05-03-at-1.27.30-PM-1.jpeg\"}]", "2026-01-31 10:05:05", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:05:05", "2026-01-31 10:05:05");
INSERT INTO `wp_aioseo_posts` VALUES("429", "21370", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/WhatsApp-Image-2025-05-03-at-1.27.31-PM-1.jpeg\"}]", "2026-01-31 10:05:05", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:05:05", "2026-01-31 10:05:05");
INSERT INTO `wp_aioseo_posts` VALUES("430", "21371", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/WhatsApp-Image-2025-05-03-at-1.32.55-PM.jpeg\"}]", "2026-01-31 10:05:05", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:05:05", "2026-01-31 10:05:05");
INSERT INTO `wp_aioseo_posts` VALUES("431", "21372", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/WhatsApp-Image-2025-05-03-at-1.32.37-PM.jpeg\"}]", "2026-01-31 10:05:05", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:05:05", "2026-01-31 10:05:05");
INSERT INTO `wp_aioseo_posts` VALUES("432", "21373", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/WhatsApp-Image-2025-05-03-at-1.32.01-PM-2-2.jpeg\"}]", "2026-01-31 10:05:37", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:05:37", "2026-01-31 10:05:37");
INSERT INTO `wp_aioseo_posts` VALUES("433", "21374", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/WhatsApp-Image-2025-05-03-at-1.27.36-PM.jpeg.bv_-1.webp\"}]", "2026-01-31 10:05:37", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:05:37", "2026-01-31 10:05:37");
INSERT INTO `wp_aioseo_posts` VALUES("434", "21375", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/WhatsApp-Image-2025-05-03-at-1.28.21-PM.jpeg\"}]", "2026-01-31 10:05:37", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:05:37", "2026-01-31 10:05:37");
INSERT INTO `wp_aioseo_posts` VALUES("435", "21376", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/WhatsApp-Image-2025-05-03-at-1.28.22-PM-1.jpeg\"}]", "2026-01-31 10:05:37", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:05:37", "2026-01-31 10:05:37");
INSERT INTO `wp_aioseo_posts` VALUES("436", "21377", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/WhatsApp-Image-2025-05-03-at-1.32.13-PM.jpeg\"}]", "2026-01-31 10:05:37", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:05:37", "2026-01-31 10:05:37");
INSERT INTO `wp_aioseo_posts` VALUES("437", "21378", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/WhatsApp-Image-2025-05-03-at-1.32.14-PM-1.jpeg\"}]", "2026-01-31 10:05:37", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:05:37", "2026-01-31 10:05:37");
INSERT INTO `wp_aioseo_posts` VALUES("438", "21379", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/WhatsApp-Image-2025-05-03-at-1.27.30-PM.jpeg\"}]", "2026-01-31 10:05:37", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:05:37", "2026-01-31 10:05:37");
INSERT INTO `wp_aioseo_posts` VALUES("439", "21397", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/1.png.bv_-1.webp\"}]", "2026-01-31 10:05:37", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:05:37", "2026-01-31 10:05:37");
INSERT INTO `wp_aioseo_posts` VALUES("440", "21407", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/VAIDIK-SHASTRATIL-SANDARBH.png.bv_.webp\"}]", "2026-01-31 10:05:37", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:05:37", "2026-01-31 10:05:37");
INSERT INTO `wp_aioseo_posts` VALUES("441", "21408", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/WhatsApp-Image-2025-05-03-at-1.28.19-PM.jpeg.bv_.webp\"}]", "2026-01-31 10:05:37", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:05:37", "2026-01-31 10:05:37");
INSERT INTO `wp_aioseo_posts` VALUES("442", "21410", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/vaidik-shastrache-tatvdnyan.png.bv_.webp\"}]", "2026-01-31 10:07:58", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:07:58", "2026-01-31 10:07:58");
INSERT INTO `wp_aioseo_posts` VALUES("443", "21450", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/1.png\"}]", "2026-01-31 10:07:58", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:07:58", "2026-01-31 10:07:58");
INSERT INTO `wp_aioseo_posts` VALUES("444", "21451", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/2.png\"}]", "2026-01-31 10:07:58", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:07:58", "2026-01-31 10:07:58");
INSERT INTO `wp_aioseo_posts` VALUES("445", "21452", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/3.png\"}]", "2026-01-31 10:07:58", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:07:58", "2026-01-31 10:07:58");
INSERT INTO `wp_aioseo_posts` VALUES("446", "21453", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/4.png\"}]", "2026-01-31 10:07:58", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:07:58", "2026-01-31 10:07:58");
INSERT INTO `wp_aioseo_posts` VALUES("447", "21490", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/puja-vidhi-vaidik-shastranusar-savistar-mahiti.jpg\"}]", "2026-01-31 10:07:58", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:07:58", "2026-01-31 10:07:58");
INSERT INTO `wp_aioseo_posts` VALUES("448", "21493", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/mantrache-mahtv.png\"}]", "2026-01-31 10:07:58", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:07:58", "2026-01-31 10:07:58");
INSERT INTO `wp_aioseo_posts` VALUES("449", "21510", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/tarot_Illustrations_13.png.bv_-1.webp\"}]", "2026-01-31 10:07:58", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:07:58", "2026-01-31 10:07:58");
INSERT INTO `wp_aioseo_posts` VALUES("450", "21511", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/Cosmic-Year-Aesthetic-Wallpaper-_-Wonders-of-the-Universe-_-Fact-Blizz.jpg\"}]", "2026-02-03 06:18:23", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:07:58", "2026-02-03 06:18:23");
INSERT INTO `wp_aioseo_posts` VALUES("451", "21519", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/download-3.jpg\"}]", "2026-02-03 06:19:23", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:07:58", "2026-02-03 06:19:23");
INSERT INTO `wp_aioseo_posts` VALUES("452", "21552", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/download-5.jpg.bv_.webp\"}]", "2026-01-31 10:10:14", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:10:14", "2026-01-31 10:10:14");
INSERT INTO `wp_aioseo_posts` VALUES("453", "21553", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/Batu-image.jpg\"}]", "2026-01-31 10:10:14", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:10:14", "2026-01-31 10:10:14");
INSERT INTO `wp_aioseo_posts` VALUES("454", "21557", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/Planetas.jpg.bv_.webp\"}]", "2026-01-31 10:10:14", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:10:14", "2026-01-31 10:10:14");
INSERT INTO `wp_aioseo_posts` VALUES("455", "21558", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/Untitled-design-73.png\"}]", "2026-01-31 10:10:14", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:10:14", "2026-01-31 10:10:14");
INSERT INTO `wp_aioseo_posts` VALUES("456", "21591", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/unnamed-400x512-1.png.bv_.webp\"}]", "2026-01-31 10:10:14", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:10:14", "2026-01-31 10:10:14");
INSERT INTO `wp_aioseo_posts` VALUES("457", "21596", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/numerology-concept-with-note-scaled-1.jpg\"}]", "2026-01-31 10:10:14", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:10:14", "2026-01-31 10:10:14");
INSERT INTO `wp_aioseo_posts` VALUES("458", "21598", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/1-1.png\"}]", "2026-01-31 10:10:14", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:10:14", "2026-01-31 10:10:14");
INSERT INTO `wp_aioseo_posts` VALUES("459", "21599", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/2-1.png\"}]", "2026-01-31 10:10:14", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:10:14", "2026-01-31 10:10:14");
INSERT INTO `wp_aioseo_posts` VALUES("460", "21600", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/3-1.png\"}]", "2026-01-31 10:10:14", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:10:14", "2026-01-31 10:10:14");
INSERT INTO `wp_aioseo_posts` VALUES("461", "21616", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "default", "default", NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "default", "default", NULL, NULL, NULL, NULL, NULL, "0", "{\"blockGraphs\":[],\"customGraphs\":[],\"default\":{\"data\":{\"Article\":[],\"Course\":[],\"Dataset\":[],\"FAQPage\":[],\"Movie\":[],\"Person\":[],\"Product\":[],\"ProductReview\":[],\"Car\":[],\"Recipe\":[],\"Service\":[],\"SoftwareApplication\":[],\"WebPage\":[]},\"graphName\":\"\",\"isEnabled\":true},\"graphs\":[]}", "default", NULL, "0", "1", "0", "0", "0", "0", "0", "0", "0", NULL, NULL, "large", "[{\"image:loc\":\"\\/panchangvastu\\/wp-content\\/uploads\\/2026\\/01\\/high-angle-role-playing-game-elements-arrangement-scaled.jpg\"}]", "2026-01-31 10:10:14", NULL, NULL, NULL, NULL, NULL, NULL, NULL, "0", "{\"linkFormat\":{\"internalLinkCount\":0,\"linkAssistantDismissed\":false},\"primaryTerm\":{\"productEducationDismissed\":false}}", NULL, "2026-01-31 10:10:14", "2026-01-31 10:10:14");
INSERT INTO `wp_aioseo_posts` VALUES("462",