<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if (! class_exists ( 'CreedyPlusHeaderPostType' ) ) {

	class CreedyPlusHeaderPostType {

        private static $_instance = null;

        public static function instance() {
            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

		function __construct() {

			add_action ( 'init', array( $this, 'creedy_register_cpt' ), 5 );
			add_filter ( 'template_include', array ( $this, 'creedy_template_include' ) );
		}

		function creedy_register_cpt() {

			$labels = array (
				'name'				 => __( 'Headers', 'creedy-plus' ),
				'singular_name'		 => __( 'Header', 'creedy-plus' ),
				'menu_name'			 => __( 'Headers', 'creedy-plus' ),
				'add_new'			 => __( 'Add Header', 'creedy-plus' ),
				'add_new_item'		 => __( 'Add New Header', 'creedy-plus' ),
				'edit'				 => __( 'Edit Header', 'creedy-plus' ),
				'edit_item'			 => __( 'Edit Header', 'creedy-plus' ),
				'new_item'			 => __( 'New Header', 'creedy-plus' ),
				'view'				 => __( 'View Header', 'creedy-plus' ),
				'view_item' 		 => __( 'View Header', 'creedy-plus' ),
				'search_items' 		 => __( 'Search Headers', 'creedy-plus' ),
				'not_found' 		 => __( 'No Headers found', 'creedy-plus' ),
				'not_found_in_trash' => __( 'No Headers found in Trash', 'creedy-plus' ),
			);

			$args = array (
				'labels' 				=> $labels,
				'public' 				=> true,
				'exclude_from_search'	=> true,
				'show_in_nav_menus' 	=> false,
				'show_in_rest' 			=> true,
				'menu_position'			=> 25,
				'menu_icon' 			=> 'dashicons-heading',
				'hierarchical' 			=> false,
				'supports' 				=> array ( 'title', 'editor', 'revisions' ),
			);

			register_post_type ( 'wdt_headers', $args );
		}

		function creedy_template_include($template) {
			if ( is_singular( 'wdt_headers' ) ) {
				if ( ! file_exists ( get_stylesheet_directory () . '/single-wdt_headers.php' ) ) {
					$template = CREEDY_PLUS_DIR_PATH . 'post-types/templates/single-wdt_headers.php';
				}
			}

			return $template;
		}
	}
}

CreedyPlusHeaderPostType::instance();