<?php
add_action( 'creedy_after_main_css', 'pagination_style' );
function pagination_style() {
    wp_enqueue_style( 'creedy-pagination', get_theme_file_uri('/modules/pagination/assets/css/pagination.css'), false, CREEDY_THEME_VERSION, 'all');
}

if( !function_exists( 'after_single_page_content_wp_link_pages' ) ) {

    function after_single_page_content_wp_link_pages() {
        wp_link_pages(array(
            'before'         => '<div class="page-link">',
            'after'          => '</div>',
            'link_before'    => '<span>',
            'link_after'     => '</span>',
            'next_or_number' => 'number',
            'pagelink'       => '%',
        ));

        edit_post_link( esc_html__( ' Edit ','creedy' ) );
    }

    add_action( 'creedy_after_single_page_content', 'after_single_page_content_wp_link_pages' );
}

if( !function_exists( 'creedy_pagination' ) ) {
    function creedy_pagination( $query = false, $load_more = false ) {

        global $wp_query;
        $paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : ( ( get_query_var( 'page' ) ) ? get_query_var( 'page' ) : 1 );

        // default $wp_query
        if( $query ) {
            $custom_query = $query;
        } else {
            $custom_query = $wp_query;
        }

        $custom_query->query_vars['paged'] > 1 ? $current = $custom_query->query_vars['paged'] : $current = 1;

        if( empty( $paged ) ) $paged = 1;
        $prev = $paged - 1;
        $next = $paged + 1;

        $end_size = 1;
        $mid_size = 2;
        #$show_all = creedy_get_option( 'showall-pagination' );
        $dots = false;

        if( ! $total = $custom_query->max_num_pages ) $total = 1;

        $output = '';
        if( $total > 1 )
        {
            if( $load_more ){
                // ajax load more -------------------------------------------------
                if( $paged < $total ){
                    $output .= '<div class="column one pager_wrapper pager_lm">';
                        $output .= '<a class="pager_load_more button button_js" href="'. get_pagenum_link( $next ) .'">';
                            $output .= '<span class="button_icon"><i class="icon-layout"></i></span>';
                            $output .= '<span class="button_label">'. esc_html__('Load more', 'creedy') .'</span>';
                        $output .= '</a>';
                    $output .= '</div>';
                }

            } else {
                // default --------------------------------------------------------
                $output .= '<div class="column one pager_wrapper">';

                    $big = 999999999; // need an unlikely integer
                    $args = array(
                        'base'               => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
                        'total'              => $custom_query->max_num_pages,
                        'current'            => max( 1, get_query_var('paged') ),
                        #'show_all'           => $show_all,
                        'end_size'           => $end_size,
                        'mid_size'           => $mid_size,
                        'prev_next'          => true,
                        'prev_text'          => '<svg xmlns="http://www.w3.org/2000/svg" width="49.225" height="25.054" viewBox="0 0 49.225 25.054">
                                                    <path data-name="Shape 4" d="M972.217,2889.552a2.8,2.8,0,0,0-.277.218q-5.974,5.979-11.943,11.963a3.142,3.142,0,0,0-.221.271l-2.157-2.2,8.619-8.632-.049-.1h-43.2v-3.155h43.222l-8.677-8.691,2.278-2.28a1.128,1.128,0,0,0,.163.274q5.977,6,11.963,11.986a3.127,3.127,0,0,0,.276.22Z" transform="translate(-922.992 -2876.949)"/>
                                                </svg>',
                        'next_text'          => '<svg xmlns="http://www.w3.org/2000/svg" width="49.225" height="25.054" viewBox="0 0 49.225 25.054">
                                                    <path data-name="Shape 4" d="M972.217,2889.552a2.8,2.8,0,0,0-.277.218q-5.974,5.979-11.943,11.963a3.142,3.142,0,0,0-.221.271l-2.157-2.2,8.619-8.632-.049-.1h-43.2v-3.155h43.222l-8.677-8.691,2.278-2.28a1.128,1.128,0,0,0,.163.274q5.977,6,11.963,11.986a3.127,3.127,0,0,0,.276.22Z" transform="translate(-922.992 -2876.949)"/>
                                                </svg>',
                        'type'               => 'list'
                    );
                    $output .= paginate_links( $args );

                $output .= '</div>'."\n";
            }
        }
        return $output;
    }
}