<?php
/**
 * Recommends plugins for use with the theme via the TGMA Script
 *
 * @package Creedy WordPress theme
 */

function creedy_tgmpa_plugins_register() {
	// Get array of recommended plugins.
	$plugins_list = array(
        array(
            'name'               => esc_html__('Creedy Plus', 'creedy'),
            'slug'               => 'creedy-plus',
            'source'             => CREEDY_MODULE_DIR . '/plugins/creedy-plus.zip',
            'required'           => true,
            'version'            => '1.0.5',
            'force_activation'   => false,
            'force_deactivation' => false,
        ),
        array(
            'name'               => esc_html__('Creedy Pro', 'creedy'),
            'slug'               => 'creedy-pro',
            'source'             => CREEDY_MODULE_DIR . '/plugins/creedy-pro.zip',
            'required'           => true,
            'version'            => '1.0.6',
            'force_activation'   => false,
            'force_deactivation' => false,
        ),
        array(
            'name'     => esc_html__('Elementor', 'creedy'),
            'slug'     => 'elementor',
            'required' => true,
        ),
        array(
            'name'               => esc_html__('WeDesignTech Elementor Addon', 'creedy'),
            'slug'               => 'wedesigntech-elementor-addon',
            'source'             => CREEDY_MODULE_DIR . '/plugins/wedesigntech-elementor-addon.zip',
            'required'           => true,
            'version'            => '1.0.9',
            'force_activation'   => false,
            'force_deactivation' => false,
        ),
        array(
            'name'               => esc_html__('WeDesignTech Portfolio', 'creedy'),
            'slug'               => 'wedesigntech-portfolio',
            'source'             => CREEDY_MODULE_DIR . '/plugins/wedesigntech-portfolio.zip',
            'required'           => true,
            'version'            => '1.0.2',
            'force_activation'   => false,
            'force_deactivation' => false,
        ),
        array(
            'name'     => esc_html__('WooCommerce', 'creedy'),
            'slug'     => 'woocommerce',
            'required' => false,
        ),
        array(
            'name'               => esc_html__('Creedy Shop', 'creedy'),
            'slug'               => 'creedy-shop',
            'source'             => CREEDY_MODULE_DIR . '/plugins/creedy-shop.zip',
            'required'           => false,
            'version'            => '1.0.2',
            'force_activation'   => false,
            'force_deactivation' => false,
        ),
        array(
            'name'     => esc_html__('GiveWP Donation', 'creedy'),
            'slug'     => 'give',
            'required' => true,
        ),
        array(
            'name'     => esc_html__('The Events Calendar', 'creedy'),
            'slug'     => 'the-events-calendar',
            'required' => true,
        ),
        array(
            'name'     => esc_html__('YITH WooCommerce Wishlist', 'creedy'),
            'slug'     => 'yith-woocommerce-wishlist',
            'required' => false,
        ),
        array(
            'name'     => esc_html__('YITH WooCommerce Compare', 'creedy'),
            'slug'     => 'yith-woocommerce-compare',
            'required' => false,
        ),
        array(
            'name'     => esc_html__('One Click Demo Import', 'creedy'),
            'slug'     => 'one-click-demo-import',
            'required' => true,
        ),
        array(
            'name'     => esc_html__('Contact Form 7', 'creedy'),
            'slug'     => 'contact-form-7',
            'required' => true,
        ),


	);

	$plugins = apply_filters('creedy_required_plugins_list', $plugins_list);

	// Register notice
	tgmpa( $plugins, array(
		'id'           => 'creedy_theme',
		'domain'       => 'creedy',
		'menu'         => 'install-required-plugins',
		'has_notices'  => true,
		'is_automatic' => true,
		'dismissable'  => true,
	) );

}
add_action( 'tgmpa_register', 'creedy_tgmpa_plugins_register' );