<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if( !class_exists( 'Creedy_Shop_Metabox_Single_Upsell_Related' ) ) {
    class Creedy_Shop_Metabox_Single_Upsell_Related {

        private static $_instance = null;

        public static function instance() {
            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

        function __construct() {

			add_filter( 'creedy_shop_product_custom_settings', array( $this, 'creedy_shop_product_custom_settings' ), 10 );

		}

        function creedy_shop_product_custom_settings( $options ) {

			$ct_dependency      = array ();
			$upsell_dependency  = array ( 'show-upsell', '==', 'true');
			$related_dependency = array ( 'show-related', '==', 'true');
			if( function_exists('creedy_shop_single_module_custom_template') ) {
				$ct_dependency['dependency'] 	= array ( 'product-template', '!=', 'custom-template');
				$upsell_dependency 				= array ( 'product-template|show-upsell', '!=|==', 'custom-template|true');
				$related_dependency 			= array ( 'product-template|show-related', '!=|==', 'custom-template|true');
			}

			$product_options = array (

				array_merge (
					array(
						'id'         => 'show-upsell',
						'type'       => 'select',
						'title'      => esc_html__('Show Upsell Products', 'creedy'),
						'class'      => 'chosen',
						'default'    => 'admin-option',
						'attributes' => array( 'data-depend-id' => 'show-upsell' ),
						'options'    => array(
							'admin-option' => esc_html__( 'Admin Option', 'creedy' ),
							'true'         => esc_html__( 'Show', 'creedy'),
							null           => esc_html__( 'Hide', 'creedy'),
						)
					),
					$ct_dependency
				),

				array(
					'id'         => 'upsell-column',
					'type'       => 'select',
					'title'      => esc_html__('Choose Upsell Column', 'creedy'),
					'class'      => 'chosen',
					'default'    => 4,
					'options'    => array(
						'admin-option' => esc_html__( 'Admin Option', 'creedy' ),
						1              => esc_html__( 'One Column', 'creedy' ),
						2              => esc_html__( 'Two Columns', 'creedy' ),
						3              => esc_html__( 'Three Columns', 'creedy' ),
						4              => esc_html__( 'Four Columns', 'creedy' ),
					),
					'dependency' => $upsell_dependency
				),

				array(
					'id'         => 'upsell-limit',
					'type'       => 'select',
					'title'      => esc_html__('Choose Upsell Limit', 'creedy'),
					'class'      => 'chosen',
					'default'    => 4,
					'options'    => array(
						'admin-option' => esc_html__( 'Admin Option', 'creedy' ),
						1              => esc_html__( 'One', 'creedy' ),
						2              => esc_html__( 'Two', 'creedy' ),
						3              => esc_html__( 'Three', 'creedy' ),
						4              => esc_html__( 'Four', 'creedy' ),
						5              => esc_html__( 'Five', 'creedy' ),
						6              => esc_html__( 'Six', 'creedy' ),
						7              => esc_html__( 'Seven', 'creedy' ),
						8              => esc_html__( 'Eight', 'creedy' ),
						9              => esc_html__( 'Nine', 'creedy' ),
						10              => esc_html__( 'Ten', 'creedy' ),
					),
					'dependency' => $upsell_dependency
				),

				array_merge (
					array(
						'id'         => 'show-related',
						'type'       => 'select',
						'title'      => esc_html__('Show Related Products', 'creedy'),
						'class'      => 'chosen',
						'default'    => 'admin-option',
						'attributes' => array( 'data-depend-id' => 'show-related' ),
						'options'    => array(
							'admin-option' => esc_html__( 'Admin Option', 'creedy' ),
							'true'         => esc_html__( 'Show', 'creedy'),
							null           => esc_html__( 'Hide', 'creedy'),
						)
					),
					$ct_dependency
				),

				array(
					'id'         => 'related-column',
					'type'       => 'select',
					'title'      => esc_html__('Choose Related Column', 'creedy'),
					'class'      => 'chosen',
					'default'    => 4,
					'options'    => array(
						'admin-option' => esc_html__( 'Admin Option', 'creedy' ),
						2              => esc_html__( 'Two Columns', 'creedy' ),
						3              => esc_html__( 'Three Columns', 'creedy' ),
						4              => esc_html__( 'Four Columns', 'creedy' ),
					),
					'dependency' => $related_dependency
				),

				array(
					'id'         => 'related-limit',
					'type'       => 'select',
					'title'      => esc_html__('Choose Related Limit', 'creedy'),
					'class'      => 'chosen',
					'default'    => 4,
					'options'    => array(
						'admin-option' => esc_html__( 'Admin Option', 'creedy' ),
						1              => esc_html__( 'One', 'creedy' ),
						2              => esc_html__( 'Two', 'creedy' ),
						3              => esc_html__( 'Three', 'creedy' ),
						4              => esc_html__( 'Four', 'creedy' ),
						5              => esc_html__( 'Five', 'creedy' ),
						6              => esc_html__( 'Six', 'creedy' ),
						7              => esc_html__( 'Seven', 'creedy' ),
						8              => esc_html__( 'Eight', 'creedy' ),
						9              => esc_html__( 'Nine', 'creedy' ),
						10              => esc_html__( 'Ten', 'creedy' ),
					),
					'dependency' => $related_dependency
				)

			);

			$options = array_merge( $options, $product_options );

			return $options;

		}

    }
}

Creedy_Shop_Metabox_Single_Upsell_Related::instance();